/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.util.ProcessUtil;

@Deprecated
public abstract class BuildFileTest
extends TestCase {
    protected Project project;
    private StringBuffer logBuffer;
    private StringBuffer fullLogBuffer;
    private StringBuffer outBuffer;
    private StringBuffer errBuffer;
    private BuildException buildException;

    public BuildFileTest() {
    }

    public BuildFileTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        if (this.project == null) {
            return;
        }
        String tearDown = "tearDown";
        if (this.project.getTargets().containsKey("tearDown")) {
            this.project.executeTarget("tearDown");
        }
    }

    public void expectBuildException(String target, String cause) {
        this.expectSpecificBuildException(target, cause, null);
    }

    public void expectLog(String target, String log) {
        this.executeTarget(target);
        String realLog = this.getLog();
        BuildFileTest.assertEquals((String)log, (String)realLog);
    }

    public void assertLogContaining(String substring) {
        String realLog = this.getLog();
        BuildFileTest.assertTrue((String)("expecting log to contain \"" + substring + "\" log was \"" + realLog + "\""), (boolean)realLog.contains(substring));
    }

    public void assertLogNotContaining(String substring) {
        String realLog = this.getLog();
        BuildFileTest.assertFalse((String)("didn't expect log to contain \"" + substring + "\" log was \"" + realLog + "\""), (boolean)realLog.contains(substring));
    }

    public void assertOutputContaining(String substring) {
        this.assertOutputContaining(null, substring);
    }

    public void assertOutputContaining(String message, String substring) {
        String realOutput = this.getOutput();
        String realMessage = message != null ? message : "expecting output to contain \"" + substring + "\" output was \"" + realOutput + "\"";
        BuildFileTest.assertTrue((String)realMessage, (boolean)realOutput.contains(substring));
    }

    public void assertOutputNotContaining(String message, String substring) {
        String realOutput = this.getOutput();
        String realMessage = message != null ? message : "expecting output to not contain \"" + substring + "\" output was \"" + realOutput + "\"";
        BuildFileTest.assertFalse((String)realMessage, (boolean)realOutput.contains(substring));
    }

    public void expectLogContaining(String target, String log) {
        this.executeTarget(target);
        this.assertLogContaining(log);
    }

    public void expectLogNotContaining(String target, String log) {
        this.executeTarget(target);
        this.assertLogNotContaining(log);
    }

    public String getLog() {
        return this.logBuffer.toString();
    }

    public void expectDebuglog(String target, String log) {
        this.executeTarget(target);
        String realLog = this.getFullLog();
        BuildFileTest.assertEquals((String)log, (String)realLog);
    }

    public void assertDebuglogContaining(String substring) {
        String realLog = this.getFullLog();
        BuildFileTest.assertTrue((String)("expecting debug log to contain \"" + substring + "\" log was \"" + realLog + "\""), (boolean)realLog.contains(substring));
    }

    public String getFullLog() {
        return this.fullLogBuffer.toString();
    }

    public void expectOutput(String target, String output) {
        this.executeTarget(target);
        String realOutput = this.getOutput();
        BuildFileTest.assertEquals((String)output, (String)realOutput.trim());
    }

    public void expectOutputAndError(String target, String output, String error) {
        this.executeTarget(target);
        String realOutput = this.getOutput();
        BuildFileTest.assertEquals((String)output, (String)realOutput);
        String realError = this.getError();
        BuildFileTest.assertEquals((String)error, (String)realError);
    }

    public String getOutput() {
        return this.cleanBuffer(this.outBuffer);
    }

    public String getError() {
        return this.cleanBuffer(this.errBuffer);
    }

    public BuildException getBuildException() {
        return this.buildException;
    }

    private String cleanBuffer(StringBuffer buffer) {
        StringBuilder cleanedBuffer = new StringBuilder();
        for (int i = 0; i < buffer.length(); ++i) {
            char ch = buffer.charAt(i);
            if (ch == '\r') continue;
            cleanedBuffer.append(ch);
        }
        return cleanedBuffer.toString();
    }

    public void configureProject(String filename) throws BuildException {
        this.configureProject(filename, 4);
    }

    public void configureProject(String filename, int logLevel) throws BuildException {
        this.logBuffer = new StringBuffer();
        this.fullLogBuffer = new StringBuffer();
        this.project = new Project();
        this.project.init();
        File antFile = new File(System.getProperty("root"), filename);
        this.project.setUserProperty("ant.file", antFile.getAbsolutePath());
        this.project.setProperty("ant.processid", ProcessUtil.getProcessId((String)"<Process>"));
        this.project.setProperty("ant.threadname", Thread.currentThread().getName());
        this.project.addBuildListener((BuildListener)new AntTestListener(logLevel));
        ProjectHelper.configureProject((Project)this.project, (File)antFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTarget(String targetName) {
        PrintStream sysOut = System.out;
        PrintStream sysErr = System.err;
        try {
            sysOut.flush();
            sysErr.flush();
            this.outBuffer = new StringBuffer();
            PrintStream out = new PrintStream(new AntOutputStream(this.outBuffer));
            System.setOut(out);
            this.errBuffer = new StringBuffer();
            PrintStream err = new PrintStream(new AntOutputStream(this.errBuffer));
            System.setErr(err);
            this.logBuffer = new StringBuffer();
            this.fullLogBuffer = new StringBuffer();
            this.buildException = null;
            this.project.executeTarget(targetName);
        }
        finally {
            System.setOut(sysOut);
            System.setErr(sysErr);
        }
    }

    public Project getProject() {
        return this.project;
    }

    public File getProjectDir() {
        return this.project.getBaseDir();
    }

    public File getOutputDir() {
        return new File(this.project.getProperty("output"));
    }

    public void expectSpecificBuildException(String target, String cause, String msg) {
        try {
            this.executeTarget(target);
        }
        catch (BuildException ex) {
            this.buildException = ex;
            BuildFileTest.assertTrue((String)("Should throw BuildException because '" + cause + "' with message '" + msg + "' (actual message '" + ex.getMessage() + "' instead)"), (msg == null || ex.getMessage().equals(msg) ? 1 : 0) != 0);
            return;
        }
        BuildFileTest.fail((String)("Should throw BuildException because: " + cause));
    }

    public void expectBuildExceptionContaining(String target, String cause, String contains) {
        try {
            this.executeTarget(target);
        }
        catch (BuildException ex) {
            this.buildException = ex;
            BuildFileTest.assertTrue((String)("Should throw BuildException because '" + cause + "' with message containing '" + contains + "' (actual message '" + ex.getMessage() + "' instead)"), (null == contains || ex.getMessage().contains(contains) ? 1 : 0) != 0);
            return;
        }
        BuildFileTest.fail((String)("Should throw BuildException because: " + cause));
    }

    public void expectPropertySet(String target, String property, String value) {
        this.executeTarget(target);
        this.assertPropertyEquals(property, value);
    }

    public void assertPropertyEquals(String property, String value) {
        String result = this.project.getProperty(property);
        BuildFileTest.assertEquals((String)("property " + property), (String)value, (String)result);
    }

    public void assertPropertySet(String property) {
        this.assertPropertyEquals(property, "true");
    }

    public void assertPropertyUnset(String property) {
        String result = this.project.getProperty(property);
        BuildFileTest.assertNull((String)("Expected property " + property + " to be unset, but it is set to the value: " + result), (Object)result);
    }

    public void expectPropertySet(String target, String property) {
        this.expectPropertySet(target, property, "true");
    }

    public void expectPropertyUnset(String target, String property) {
        this.expectPropertySet(target, property, null);
    }

    public URL getResource(String resource) {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        BuildFileTest.assertNotNull((String)("Could not find resource :" + resource), (Object)url);
        return url;
    }

    private class AntTestListener
    implements BuildListener {
        private int logLevel;

        public AntTestListener(int logLevel) {
            this.logLevel = logLevel;
        }

        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            if (event.getPriority() > this.logLevel) {
                return;
            }
            if (event.getPriority() == 2 || event.getPriority() == 1 || event.getPriority() == 0) {
                BuildFileTest.this.logBuffer.append(event.getMessage());
            }
            BuildFileTest.this.fullLogBuffer.append(event.getMessage());
        }
    }

    protected static class AntOutputStream
    extends OutputStream {
        private StringBuffer buffer;

        public AntOutputStream(StringBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(int b) {
            this.buffer.append((char)b);
        }
    }
}

