/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.LocksFeatureUI;
import org.netbeans.modules.profiler.v2.impl.WeakProcessor;
import org.openide.util.Lookup;

final class LocksFeature
extends ProfilerFeature.Basic {
    private final WeakProcessor processor;
    private LocksFeatureUI ui;
    private Runnable refresher;
    private volatile boolean running;

    private LocksFeature(ProfilerSession profilerSession) {
        super(Icons.getIcon((String)"ProfilerIcons.WindowLocks"), Bundle.LocksFeature_name(), Bundle.LocksFeature_description(), 16, profilerSession);
        assert (!SwingUtilities.isEventDispatchThread());
        Lookup.Provider provider = profilerSession.getProject();
        String string = provider == null ? "External Process" : ProjectUtilities.getDisplayName((Lookup.Provider)provider);
        this.processor = new WeakProcessor("MethodsFeature Processor for " + string);
    }

    @Override
    public void configureSettings(ProfilingSettings profilingSettings) {
        profilingSettings.setLockContentionMonitoringEnabled(true);
    }

    @Override
    public JPanel getResultsUI() {
        return this.getUI().getResultsUI();
    }

    @Override
    public ProfilerToolbar getToolbar() {
        return this.getUI().getToolbar();
    }

    private LocksFeatureUI getUI() {
        if (this.ui == null) {
            this.ui = new LocksFeatureUI(){

                @Override
                int getSessionState() {
                    return LocksFeature.this.getSessionState();
                }

                @Override
                ProfilerClient getProfilerClient() {
                    Profiler profiler = LocksFeature.this.getSession().getProfiler();
                    return profiler.getTargetAppRunner().getProfilerClient();
                }

                @Override
                void refreshResults() {
                    LocksFeature.this.refreshResults();
                }
            };
        }
        return this.ui;
    }

    private void startResults() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.refresher = new Runnable(){

            @Override
            public void run() {
                if (LocksFeature.this.running) {
                    LocksFeature.this.refreshView();
                    LocksFeature.this.refreshResults(1500);
                }
            }
        };
        this.refreshResults(1000);
    }

    private void refreshView() {
        if (this.ui != null) {
            try {
                ProfilingSettings profilingSettings = this.getSession().getProfilingSettings();
                if (ProfilingSettings.isCPUSettings((ProfilingSettings)profilingSettings) || ProfilingSettings.isJDBCSettings((ProfilingSettings)profilingSettings) || ProfilingSettings.isMemorySettings((ProfilingSettings)profilingSettings)) {
                    return;
                }
                this.ui.refreshData();
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                this.stopResults();
            }
        }
    }

    private void refreshResults() {
        if (this.running) {
            this.processor.post(new Runnable(){

                @Override
                public void run() {
                    if (LocksFeature.this.ui != null) {
                        LocksFeature.this.ui.setForceRefresh();
                    }
                    LocksFeature.this.refreshView();
                }
            });
        }
    }

    private void refreshResults(int n) {
        if (this.running && this.refresher != null) {
            this.processor.post(this.refresher, n);
        }
    }

    private void resetResults() {
        if (this.ui != null) {
            this.ui.resetData();
        }
    }

    private void stopResults() {
        if (this.refresher != null) {
            this.running = false;
            this.refresher = null;
        }
    }

    private void unpauseResults() {
        if (this.ui != null) {
            this.ui.resetPause();
        }
    }

    @Override
    public void notifyActivated() {
        this.resetResults();
    }

    @Override
    public void notifyDeactivated() {
        this.resetResults();
    }

    @Override
    protected void profilingStateChanged(int n, int n2) {
        if (n2 == 1 || n2 == 128) {
            this.stopResults();
        } else if (this.isActivated() && n2 == 4) {
            this.startResults();
        } else if (n2 == 2) {
            this.resetResults();
            this.unpauseResults();
        }
        if (this.ui != null) {
            this.ui.sessionStateChanged(this.getSessionState());
        }
    }

    public static final class Provider
    extends ProfilerFeature.Provider {
        @Override
        public ProfilerFeature getFeature(ProfilerSession profilerSession) {
            return new LocksFeature(profilerSession);
        }
    }
}

