#ifndef _EFL_INTERPOLATOR_SPRING_EO_H_
#define _EFL_INTERPOLATOR_SPRING_EO_H_

#ifndef _EFL_INTERPOLATOR_SPRING_EO_CLASS_TYPE
#define _EFL_INTERPOLATOR_SPRING_EO_CLASS_TYPE

typedef Eo Efl_Interpolator_Spring;

#endif

#ifndef _EFL_INTERPOLATOR_SPRING_EO_TYPES
#define _EFL_INTERPOLATOR_SPRING_EO_TYPES


#endif
/** Efl spring interpolator class
 *
 * @ingroup Efl_Interpolator_Spring
 */
#define EFL_INTERPOLATOR_SPRING_CLASS efl_interpolator_spring_class_get()

EWAPI const Efl_Class *efl_interpolator_spring_class_get(void);

/**
 * @brief Factors property
 *
 * @param[in] obj The object.
 * @param[in] factor1 First factor of the interpolation function.
 * @param[in] factor2 Second factor of the interpolation function.
 *
 * @ingroup Efl_Interpolator_Spring
 */
EOAPI void efl_interpolator_spring_factors_set(Eo *obj, double factor1, double factor2);

/**
 * @brief Factors property
 *
 * @param[in] obj The object.
 * @param[out] factor1 First factor of the interpolation function.
 * @param[out] factor2 Second factor of the interpolation function.
 *
 * @ingroup Efl_Interpolator_Spring
 */
EOAPI void efl_interpolator_spring_factors_get(const Eo *obj, double *factor1, double *factor2);

#endif
