#ifndef _EFL_UI_DIRECTION_EO_H_
#define _EFL_UI_DIRECTION_EO_H_

#ifndef _EFL_UI_DIRECTION_EO_CLASS_TYPE
#define _EFL_UI_DIRECTION_EO_CLASS_TYPE

typedef Eo Efl_Ui_Direction;

#endif

#ifndef _EFL_UI_DIRECTION_EO_TYPES
#define _EFL_UI_DIRECTION_EO_TYPES

/**
 * @brief Direction for UI objects and layouts.
 *
 * Not to be confused with @ref Efl_Orient which is for images and canvases.
 * This enum is used to define how widgets should expand and orient themselves,
 * not to rotate images.
 *
 * See also @ref Efl_Ui_Direction.
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_DIR_DEFAULT = 0, /**< Default direction. Each widget may have a
                           * different default. */
  EFL_UI_DIR_HORIZONTAL, /**< Horizontal direction, along the X axis. Usually
                          * left-to-right, but may be inverted to right-to-left
                          * if mirroring is on. */
  EFL_UI_DIR_VERTICAL, /**< Vertical direction, along the Y axis. Usually
                        * downwards. */
  EFL_UI_DIR_LTR, /**< Horizontal, left-to-right direction. */
  EFL_UI_DIR_RTL, /**< Horizontal, right-to-left direction. */
  EFL_UI_DIR_DOWN, /**< Vertical, top-to-bottom direction. */
  EFL_UI_DIR_UP, /**< Vertical, bottom-to-top direction. */
  EFL_UI_DIR_RIGHT = 3 /* Efl.Ui.Dir.ltr */, /**< Right is an alias for LTR. */
  EFL_UI_DIR_LEFT = 4 /* Efl.Ui.Dir.rtl */ /**< Left is an alias for RTL. */
} Efl_Ui_Dir;


#endif
/** EFL UI object direction interface
 *
 * @ingroup Efl_Ui_Direction
 */
#define EFL_UI_DIRECTION_INTERFACE efl_ui_direction_interface_get()

EWAPI const Efl_Class *efl_ui_direction_interface_get(void);

/**
 * @brief Control the direction of a given widget.
 *
 * Use this function to change how your widget is to be disposed: vertically or
 * horizontally or inverted vertically or inverted horizontally.
 *
 * Mirroring as defined in @ref Efl_Ui_Base can invert the @c horizontal
 * direction: it is @c ltr by default, but becomes @c rtl if the object is
 * mirrored.
 *
 * @param[in] obj The object.
 * @param[in] dir Direction of the widget.
 *
 * @ingroup Efl_Ui_Direction
 */
EOAPI void efl_ui_direction_set(Eo *obj, Efl_Ui_Dir dir);

/**
 * @brief Control the direction of a given widget.
 *
 * Use this function to change how your widget is to be disposed: vertically or
 * horizontally or inverted vertically or inverted horizontally.
 *
 * Mirroring as defined in @ref Efl_Ui_Base can invert the @c horizontal
 * direction: it is @c ltr by default, but becomes @c rtl if the object is
 * mirrored.
 *
 * @param[in] obj The object.
 *
 * @return Direction of the widget.
 *
 * @ingroup Efl_Ui_Direction
 */
EOAPI Efl_Ui_Dir efl_ui_direction_get(const Eo *obj);

#endif
