#ifndef _EFL_PAGE_INDICATOR_EO_H_
#define _EFL_PAGE_INDICATOR_EO_H_

#ifndef _EFL_PAGE_INDICATOR_EO_CLASS_TYPE
#define _EFL_PAGE_INDICATOR_EO_CLASS_TYPE

typedef Eo Efl_Page_Indicator;

#endif

#ifndef _EFL_PAGE_INDICATOR_EO_TYPES
#define _EFL_PAGE_INDICATOR_EO_TYPES


#endif
/**
 * @brief Page indicator
 *
 * Page indicator is used with @ref Efl_Ui_Pager. It is located on the top
 * layer of pager widget and helps users to know the number of pages and the
 * current page's index without scrolling.
 *
 * @ingroup Efl_Page_Indicator
 */
#define EFL_PAGE_INDICATOR_CLASS efl_page_indicator_class_get()

EWAPI const Efl_Class *efl_page_indicator_class_get(void);

/**
 * @brief set object
 *
 * @param[in] obj The object.
 * @param[in] pager pager object
 * @param[in] group a dummy object for layer adjustment
 *
 * @ingroup Efl_Page_Indicator
 */
EOAPI void efl_page_indicator_bind(Eo *obj, Efl_Ui_Pager *pager, Efl_Canvas_Group *group);

#endif
