/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.reflect.annotation.AnnotationParser;

public class AnnotationType {
    private final Map<String, Class<?>> memberTypes;
    private final Map<String, Object> memberDefaults;
    private final Map<String, Method> members;
    private final RetentionPolicy retention;
    private final boolean inherited;

    public static AnnotationType getInstance(Class<? extends Annotation> clazz) {
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        AnnotationType annotationType = javaLangAccess.getAnnotationType(clazz);
        if (annotationType == null && !javaLangAccess.casAnnotationType(clazz, null, annotationType = new AnnotationType(clazz))) {
            annotationType = javaLangAccess.getAnnotationType(clazz);
            assert (annotationType != null);
        }
        return annotationType;
    }

    private AnnotationType(final Class<? extends Annotation> clazz) {
        if (!clazz.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type");
        }
        Method[] methodArray = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
        this.memberTypes = new HashMap(methodArray.length + 1, 1.0f);
        this.memberDefaults = new HashMap<String, Object>(0);
        this.members = new HashMap<String, Method>(methodArray.length + 1, 1.0f);
        for (Method method : methodArray) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isAbstract(method.getModifiers()) || method.isSynthetic()) continue;
            if (method.getParameterTypes().length != 0) {
                throw new IllegalArgumentException(method + " has params");
            }
            String string = method.getName();
            Class<?> clazz2 = method.getReturnType();
            this.memberTypes.put(string, AnnotationType.invocationHandlerReturnType(clazz2));
            this.members.put(string, method);
            Object object = method.getDefaultValue();
            if (object == null) continue;
            this.memberDefaults.put(string, object);
        }
        if (clazz != Retention.class && clazz != Inherited.class) {
            JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
            Map<Class<? extends Annotation>, Annotation> map = AnnotationParser.parseSelectAnnotations(javaLangAccess.getRawClassAnnotations(clazz), javaLangAccess.getConstantPool(clazz), clazz, Retention.class, Inherited.class);
            Retention retention = (Retention)map.get(Retention.class);
            this.retention = retention == null ? RetentionPolicy.CLASS : retention.value();
            this.inherited = map.containsKey(Inherited.class);
        } else {
            this.retention = RetentionPolicy.RUNTIME;
            this.inherited = false;
        }
    }

    public static Class<?> invocationHandlerReturnType(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    public Map<String, Class<?>> memberTypes() {
        return this.memberTypes;
    }

    public Map<String, Method> members() {
        return this.members;
    }

    public Map<String, Object> memberDefaults() {
        return this.memberDefaults;
    }

    public RetentionPolicy retention() {
        return this.retention;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String toString() {
        return "Annotation Type:\n   Member types: " + this.memberTypes + "\n   Member defaults: " + this.memberDefaults + "\n   Retention policy: " + (Object)((Object)this.retention) + "\n   Inherited: " + this.inherited;
    }
}

