/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_el extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "\u03a6\u03af\u03c4\u03b6\u03b9";
        final String metaValue_LA = "\u039b\u03ac\u03bf\u03c2";
        final String metaValue_NU = "\u039d\u03b9\u03bf\u03cd\u03b5";
        final String metaValue_TK = "\u03a4\u03bf\u03ba\u03b5\u03bb\u03ac\u03bf\u03c5";
        final String metaValue_TV = "\u03a4\u03bf\u03c5\u03b2\u03b1\u03bb\u03bf\u03cd";
        final String metaValue_ae = "\u0391\u03b2\u03b5\u03c3\u03c4\u03ac\u03bd";
        final String metaValue_gu = "\u0393\u03ba\u03bf\u03c5\u03b3\u03b9\u03b1\u03c1\u03ac\u03c4\u03b9";
        final String metaValue_km = "\u03a7\u03bc\u03b5\u03c1";
        final String metaValue_kn = "\u039a\u03b1\u03bd\u03ac\u03bd\u03c4\u03b1";
        final String metaValue_or = "\u038c\u03bd\u03c4\u03b9\u03b1";
        final String metaValue_te = "\u03a4\u03b5\u03bb\u03bf\u03cd\u03b3\u03ba\u03bf\u03c5";
        final String metaValue_ban = "\u039c\u03c0\u03b1\u03bb\u03b9\u03bd\u03af\u03b6";
        final String metaValue_chr = "\u03a4\u03c3\u03b5\u03c1\u03cc\u03ba\u03b9";
        final String metaValue_nqo = "\u039d\u2019\u039a\u03bf";
        final String metaValue_ssy = "\u03a3\u03ac\u03c7\u03bf";
        final String metaValue_vai = "\u0392\u03ac\u03b9";
        final String metaValue_zbl = "\u03a3\u03cd\u03bc\u03b2\u03bf\u03bb\u03b1 Bliss";
        final Object[][] data = new Object[][] {
            { "ksh", "\u039a\u03bf\u03bb\u03c9\u03bd\u03b9\u03ba\u03ac" },
            { "Ogam", "\u038c\u03b3\u03ba\u03c7\u03b1\u03bc" },
            { "mwl", "\u039c\u03b9\u03c1\u03b1\u03bd\u03c4\u03b5\u03b6\u03b9\u03ba\u03ac" },
            { "Zsym", "\u03a3\u03cd\u03bc\u03b2\u03bf\u03bb\u03b1" },
            { "cch", "\u0391\u03c4\u03c3\u03ac\u03bc" },
            { "mwr", "\u039c\u03b1\u03c1\u03b3\u03bf\u03c5\u03ac\u03c1\u03b9" },
            { "Tagb", "\u03a4\u03b1\u03b3\u03ba\u03bc\u03ac\u03bd\u03b3\u03bf\u03c5\u03b1" },
            { "Zsye", "Emoji" },
            { "%%NJIVA", "\u0394\u03b9\u03ac\u03bb\u03b5\u03ba\u03c4\u03bf\u03c2 \u0393\u03ba\u03bd\u03b9\u03b2\u03ac/\u039d\u03c4\u03b6\u03b9\u03b2\u03ac" },
            { "egy", "\u0391\u03c1\u03c7\u03b1\u03af\u03b1 \u0391\u03b9\u03b3\u03c5\u03c0\u03c4\u03b9\u03b1\u03ba\u03ac" },
            { "raj", "\u03a1\u03b1\u03b6\u03b1\u03c3\u03b8\u03ac\u03bd\u03b9" },
            { "Phag", "\u03a0\u03b1\u03b3\u03ba\u03c2-\u03c0\u03b1" },
            { "tem", "\u03a4\u03af\u03bc\u03bd\u03b5" },
            { "teo", "\u03a4\u03ad\u03c3\u03bf" },
            { "rap", "\u03a1\u03b1\u03c0\u03b1\u03bd\u03bf\u03cd\u03b9" },
            { "ter", "\u03a4\u03b5\u03c1\u03ad\u03bd\u03bf" },
            { "AC", "\u039d\u03ae\u03c3\u03bf\u03c2 \u0391\u03c3\u03b5\u03bd\u03c3\u03b9\u03cc\u03bd" },
            { "rar", "\u03a1\u03b1\u03c1\u03bf\u03c4\u03bf\u03bd\u03b3\u03ba\u03ac\u03bd" },
            { "tet", "\u03a4\u03ad\u03c4\u03bf\u03c5\u03bc" },
            { "AD", "\u0391\u03bd\u03b4\u03cc\u03c1\u03b1" },
            { "AE", "\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03b1 \u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ac \u0395\u03bc\u03b9\u03c1\u03ac\u03c4\u03b1" },
            { "nl_BE", "\u03a6\u03bb\u03b1\u03bc\u03b1\u03bd\u03b4\u03b9\u03ba\u03ac" },
            { "AF", "\u0391\u03c6\u03b3\u03b1\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "AG", "\u0391\u03bd\u03c4\u03af\u03b3\u03ba\u03bf\u03c5\u03b1 \u03ba\u03b1\u03b9 \u039c\u03c0\u03b1\u03c1\u03bc\u03c0\u03bf\u03cd\u03bd\u03c4\u03b1" },
            { "type.ca.ethiopic", "\u0391\u03b9\u03b8\u03b9\u03bf\u03c0\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "AI", "\u0391\u03bd\u03b3\u03ba\u03bf\u03c5\u03af\u03bb\u03b1" },
            { "key.tz", "\u0396\u03ce\u03bd\u03b7 \u03ce\u03c1\u03b1\u03c2" },
            { "AL", "\u0391\u03bb\u03b2\u03b1\u03bd\u03af\u03b1" },
            { "AM", "\u0391\u03c1\u03bc\u03b5\u03bd\u03af\u03b1" },
            { "Teng", "\u03a4\u03b5\u03b3\u03bd\u03b3\u03bf\u03c5\u03ac\u03c1" },
            { "AO", "\u0391\u03b3\u03ba\u03cc\u03bb\u03b1" },
            { "AQ", "\u0391\u03bd\u03c4\u03b1\u03c1\u03ba\u03c4\u03b9\u03ba\u03ae" },
            { "AR", "\u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae" },
            { "Prti", "\u0395\u03c0\u03b9\u03b3\u03c1\u03b1\u03c6\u03b9\u03ba\u03cc \u03a0\u03b1\u03c1\u03b8\u03b9\u03ac\u03bd" },
            { "AS", "\u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03ae \u03a3\u03b1\u03bc\u03cc\u03b1" },
            { "AT", "\u0391\u03c5\u03c3\u03c4\u03c1\u03af\u03b1" },
            { "AU", "\u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1" },
            { "AW", "\u0391\u03c1\u03bf\u03cd\u03bc\u03c0\u03b1" },
            { "en_US", "\u0391\u03b3\u03b3\u03bb\u03b9\u03ba\u03ac \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2" },
            { "AX", "\u039d\u03ae\u03c3\u03bf\u03b9 \u038c\u03bb\u03b1\u03bd\u03c4" },
            { "mye", "\u039c\u03b9\u03ad\u03bd\u03b5" },
            { "AZ", "\u0391\u03b6\u03b5\u03c1\u03bc\u03c0\u03b1\u03ca\u03c4\u03b6\u03ac\u03bd" },
            { "%%AREVELA", "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ac \u0391\u03c1\u03bc\u03b5\u03bd\u03b9\u03ba\u03ac" },
            { "BA", "\u0392\u03bf\u03c3\u03bd\u03af\u03b1 - \u0395\u03c1\u03b6\u03b5\u03b3\u03bf\u03b2\u03af\u03bd\u03b7" },
            { "BB", "\u039c\u03c0\u03b1\u03c1\u03bc\u03c0\u03ad\u03b9\u03bd\u03c4\u03bf\u03c2" },
            { "ceb", "\u03a3\u03b5\u03bc\u03c0\u03bf\u03c5\u03ac\u03bd\u03bf" },
            { "BD", "\u039c\u03c0\u03b1\u03bd\u03b3\u03ba\u03bb\u03b1\u03bd\u03c4\u03ad\u03c2" },
            { "kum", "\u039a\u03bf\u03c5\u03bc\u03b3\u03b9\u03bf\u03cd\u03ba" },
            { "BE", "\u0392\u03ad\u03bb\u03b3\u03b9\u03bf" },
            { "gmh", "\u039c\u03ad\u03c3\u03b1 \u0386\u03bd\u03c9 \u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "BF", "\u039c\u03c0\u03bf\u03c5\u03c1\u03ba\u03af\u03bd\u03b1 \u03a6\u03ac\u03c3\u03bf" },
            { "BG", "\u0392\u03bf\u03c5\u03bb\u03b3\u03b1\u03c1\u03af\u03b1" },
            { "BH", "\u039c\u03c0\u03b1\u03c7\u03c1\u03ad\u03b9\u03bd" },
            { "BI", "\u039c\u03c0\u03bf\u03c5\u03c1\u03bf\u03cd\u03bd\u03c4\u03b9" },
            { "BJ", "\u039c\u03c0\u03b5\u03bd\u03af\u03bd" },
            { "BL", "\u0386\u03b3\u03b9\u03bf\u03c2 \u0392\u03b1\u03c1\u03b8\u03bf\u03bb\u03bf\u03bc\u03b1\u03af\u03bf\u03c2" },
            { "BM", "\u0392\u03b5\u03c1\u03bc\u03bf\u03cd\u03b4\u03b5\u03c2" },
            { "kut", "\u039a\u03bf\u03c5\u03c4\u03b5\u03bd\u03ac\u03b9" },
            { "myv", "\u0388\u03c1\u03b6\u03c5\u03b1" },
            { "BN", "\u039c\u03c0\u03c1\u03bf\u03c5\u03bd\u03ad\u03b9" },
            { "BO", "\u0392\u03bf\u03bb\u03b9\u03b2\u03af\u03b1" },
            { "BQ", "\u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03af\u03b1 \u039a\u03b1\u03c1\u03b1\u03ca\u03b2\u03b9\u03ba\u03ae\u03c2" },
            { "BR", "\u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1" },
            { "BS", "\u039c\u03c0\u03b1\u03c7\u03ac\u03bc\u03b5\u03c2" },
            { "xog", "\u03a3\u03cc\u03b3\u03ba\u03b1" },
            { "BT", "\u039c\u03c0\u03bf\u03c5\u03c4\u03ac\u03bd" },
            { "BV", "\u039d\u03ae\u03c3\u03bf\u03c2 \u039c\u03c0\u03bf\u03c5\u03b2\u03ad" },
            { "BW", "\u039c\u03c0\u03bf\u03c4\u03c3\u03bf\u03c5\u03ac\u03bd\u03b1" },
            { "BY", "\u039b\u03b5\u03c5\u03ba\u03bf\u03c1\u03c9\u03c3\u03af\u03b1" },
            { "BZ", "\u039c\u03c0\u03b5\u03bb\u03af\u03b6" },
            { "Visp", "\u039f\u03c1\u03b1\u03c4\u03ae \u03bf\u03bc\u03b9\u03bb\u03af\u03b1" },
            { "type.ca.persian", "\u03a0\u03b5\u03c1\u03c3\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "type.nu.hebr", "\u0395\u03b2\u03c1\u03b1\u03ca\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "CA", "\u039a\u03b1\u03bd\u03b1\u03b4\u03ac\u03c2" },
            { "CC", "\u039d\u03ae\u03c3\u03bf\u03b9 \u039a\u03cc\u03ba\u03bf\u03c2 (\u039a\u03af\u03bb\u03b9\u03bd\u03b3\u03ba)" },
            { "mzn", "\u039c\u03b1\u03b6\u03b1\u03bd\u03c4\u03b5\u03c1\u03ac\u03bd\u03b9" },
            { "CD", "\u039a\u03bf\u03bd\u03b3\u03ba\u03cc - \u039a\u03b9\u03bd\u03c3\u03ac\u03c3\u03b1" },
            { "CF", "\u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b1\u03c6\u03c1\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1" },
            { "CG", "\u039a\u03bf\u03bd\u03b3\u03ba\u03cc - \u039c\u03c0\u03c1\u03b1\u03b6\u03b1\u03b2\u03af\u03bb" },
            { "CH", "\u0395\u03bb\u03b2\u03b5\u03c4\u03af\u03b1" },
            { "CI", "\u0391\u03ba\u03c4\u03ae \u0395\u03bb\u03b5\u03c6\u03b1\u03bd\u03c4\u03bf\u03c3\u03c4\u03bf\u03cd" },
            { "CK", "\u039d\u03ae\u03c3\u03bf\u03b9 \u039a\u03bf\u03c5\u03ba" },
            { "CL", "\u03a7\u03b9\u03bb\u03ae" },
            { "Kthi", "\u039a\u03b1\u03ca\u03b8\u03af" },
            { "CM", "\u039a\u03b1\u03bc\u03b5\u03c1\u03bf\u03cd\u03bd" },
            { "CN", "\u039a\u03af\u03bd\u03b1" },
            { "CO", "\u039a\u03bf\u03bb\u03bf\u03bc\u03b2\u03af\u03b1" },
            { "CP", "\u039d\u03ae\u03c3\u03bf\u03c2 \u039a\u03bb\u03af\u03c0\u03b5\u03c1\u03c4\u03bf\u03bd" },
            { "CR", "\u039a\u03cc\u03c3\u03c4\u03b1 \u03a1\u03af\u03ba\u03b1" },
            { "CU", "\u039a\u03bf\u03cd\u03b2\u03b1" },
            { "CV", "\u03a0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf \u0391\u03ba\u03c1\u03c9\u03c4\u03ae\u03c1\u03b9\u03bf" },
            { "CW", "\u039a\u03bf\u03c5\u03c1\u03b1\u03c3\u03ac\u03bf" },
            { "CX", "\u039d\u03ae\u03c3\u03bf\u03c2 \u03c4\u03c9\u03bd \u03a7\u03c1\u03b9\u03c3\u03c4\u03bf\u03c5\u03b3\u03ad\u03bd\u03bd\u03c9\u03bd" },
            { "CY", "\u039a\u03cd\u03c0\u03c1\u03bf\u03c2" },
            { "CZ", "\u03a4\u03c3\u03b5\u03c7\u03af\u03b1" },
            { "eka", "\u0395\u03ba\u03b1\u03c4\u03b6\u03bf\u03cd\u03ba" },
            { "DE", "\u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03af\u03b1" },
            { "goh", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03ac \u0386\u03bd\u03c9 \u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "ace", "\u0391\u03c7\u03b9\u03bd\u03af\u03b6" },
            { "cgg", "\u03a4\u03c3\u03af\u03b3\u03ba\u03b1" },
            { "DG", "\u039d\u03c4\u03b9\u03ad\u03b3\u03ba\u03bf \u0393\u03ba\u03b1\u03c1\u03c3\u03af\u03b1" },
            { "type.nu.deva", "\u03a8\u03b7\u03c6\u03af\u03b1 \u039d\u03c4\u03b5\u03b2\u03b1\u03bd\u03b1\u03b3\u03ba\u03ac\u03c1\u03b9" },
            { "DJ", "\u03a4\u03b6\u03b9\u03bc\u03c0\u03bf\u03c5\u03c4\u03af" },
            { "DK", "\u0394\u03b1\u03bd\u03af\u03b1" },
            { "ach", "\u0391\u03ba\u03bf\u03bb\u03af" },
            { "gon", "\u0393\u03ba\u03cc\u03bd\u03c4\u03b9" },
            { "Brai", "\u039c\u03c0\u03c1\u03ac\u03b9\u03b3" },
            { "Brah", "\u039c\u03c0\u03c1\u03b1\u03c7\u03bc\u03af" },
            { "DM", "\u039d\u03c4\u03bf\u03bc\u03af\u03bd\u03b9\u03ba\u03b1" },
            { "type.nu.armnlow", "\u03a0\u03b5\u03b6\u03ac \u03b1\u03c1\u03bc\u03b5\u03bd\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "DO", "\u0394\u03bf\u03bc\u03b9\u03bd\u03b9\u03ba\u03b1\u03bd\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1" },
            { "gor", "\u0393\u03ba\u03bf\u03c1\u03bf\u03bd\u03c4\u03ac\u03bb\u03bf" },
            { "got", "\u0393\u03bf\u03c4\u03b8\u03b9\u03ba\u03ac" },
            { "Mtei", "\u039c\u03b5\u03ca\u03c4\u03ad\u03b9 \u039c\u03ac\u03b3\u03b5\u03ba" },
            { "zun", "\u0396\u03bf\u03cd\u03bd\u03b9" },
            { "tig", "\u03a4\u03af\u03b3\u03ba\u03c1\u03b5" },
            { "DZ", "\u0391\u03bb\u03b3\u03b5\u03c1\u03af\u03b1" },
            { "pag", "\u03a0\u03b1\u03bd\u03b3\u03ba\u03b1\u03c3\u03b9\u03bd\u03ac\u03bd" },
            { "type.d0.hwidth", "\u039c\u03b9\u03c3\u03bf\u03cd \u03c0\u03bb\u03ac\u03c4\u03bf\u03c5\u03c2" },
            { "pal", "\u03a0\u03b1\u03c7\u03bb\u03ac\u03b2\u03b9" },
            { "EA", "\u0398\u03ad\u03bf\u03c5\u03c4\u03b1 \u03ba\u03b1\u03b9 \u039c\u03b5\u03bb\u03af\u03b3\u03b9\u03b1" },
            { "chb", "\u03a4\u03c3\u03af\u03bc\u03c0\u03c4\u03c3\u03b1" },
            { "pam", "\u03a0\u03b1\u03bc\u03c0\u03ac\u03bd\u03b3\u03ba\u03b1" },
            { "EC", "\u0399\u03c3\u03b7\u03bc\u03b5\u03c1\u03b9\u03bd\u03cc\u03c2" },
            { "pap", "\u03a0\u03b1\u03c0\u03b9\u03b1\u03bc\u03ad\u03bd\u03c4\u03bf" },
            { "ada", "\u0391\u03bd\u03c4\u03ac\u03bd\u03b3\u03ba\u03bc\u03b5" },
            { "EE", "\u0395\u03c3\u03b8\u03bf\u03bd\u03af\u03b1" },
            { "tiv", "\u03a4\u03b9\u03b2" },
            { "EG", "\u0391\u03af\u03b3\u03c5\u03c0\u03c4\u03bf\u03c2" },
            { "EH", "\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u03a3\u03b1\u03c7\u03ac\u03c1\u03b1" },
            { "chg", "\u03a4\u03c3\u03b1\u03b3\u03ba\u03b1\u03c4\u03ac\u03b9" },
            { "pau", "\u03a0\u03b1\u03bb\u03ac\u03bf\u03c5\u03b1\u03bd" },
            { "chk", "\u03a4\u03c3\u03bf\u03c5\u03ba\u03af\u03b6\u03b9" },
            { "chn", "\u0399\u03b4\u03b9\u03c9\u03bc\u03b1\u03c4\u03b9\u03ba\u03ac \u03a3\u03b9\u03bd\u03bf\u03cd\u03ba" },
            { "chm", "\u039c\u03ac\u03c1\u03b9" },
            { "chp", "\u03a4\u03c3\u03af\u03c0\u03b9\u03bf\u03c5\u03b1\u03bd" },
            { "cho", "\u03a4\u03c3\u03bf\u03ba\u03c4\u03ac\u03bf\u03c5" },
            { "chr", metaValue_chr },
            { "ER", "\u0395\u03c1\u03c5\u03b8\u03c1\u03b1\u03af\u03b1" },
            { "ES", "\u0399\u03c3\u03c0\u03b1\u03bd\u03af\u03b1" },
            { "ET", "\u0391\u03b9\u03b8\u03b9\u03bf\u03c0\u03af\u03b1" },
            { "EU", "\u0395\u03c5\u03c1\u03c9\u03c0\u03b1\u03ca\u03ba\u03ae \u0388\u03bd\u03c9\u03c3\u03b7" },
            { "elx", "\u0395\u03bb\u03b1\u03bc\u03ac\u03b9\u03c4" },
            { "type.ca.gregorian", "\u0393\u03c1\u03b7\u03b3\u03bf\u03c1\u03b9\u03b1\u03bd\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "EZ", "\u0395\u03c5\u03c1\u03c9\u03b6\u03ce\u03bd\u03b7" },
            { "chy", "\u03a3\u03b5\u03b3\u03b9\u03ad\u03bd" },
            { "type.nu.gujr", "\u0393\u03ba\u03bf\u03c5\u03c4\u03b6\u03b1\u03c1\u03b1\u03c4\u03b9\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "Inds", "\u038a\u03bd\u03b4\u03bf\u03c5\u03c2" },
            { "ady", "\u0391\u03bd\u03c4\u03b9\u03b3\u03ba\u03ad\u03b1" },
            { "FI", "\u03a6\u03b9\u03bd\u03bb\u03b1\u03bd\u03b4\u03af\u03b1" },
            { "FJ", metaValue_FJ },
            { "FK", "\u039d\u03ae\u03c3\u03bf\u03b9 \u03a6\u03cc\u03ba\u03bb\u03b1\u03bd\u03c4" },
            { "FM", "\u039c\u03b9\u03ba\u03c1\u03bf\u03bd\u03b7\u03c3\u03af\u03b1" },
            { "key.va", "\u03a0\u03b1\u03c1\u03b1\u03bb\u03bb\u03b1\u03b3\u03ae \u03c4\u03bf\u03c0\u03b9\u03ba\u03ce\u03bd \u03c1\u03c5\u03b8\u03bc\u03af\u03c3\u03b5\u03c9\u03bd" },
            { "FO", "\u039d\u03ae\u03c3\u03bf\u03b9 \u03a6\u03b5\u03c1\u03cc\u03b5\u03c2" },
            { "Taml", "\u03a4\u03b1\u03bc\u03af\u03bb" },
            { "FR", "\u0393\u03b1\u03bb\u03bb\u03af\u03b1" },
            { "tkl", metaValue_TK },
            { "grb", "\u0393\u03ba\u03c1\u03af\u03bc\u03c0\u03bf" },
            { "root", "\u03a1\u03af\u03b6\u03b1" },
            { "type.ca.indian", "\u0399\u03bd\u03b4\u03b9\u03ba\u03cc \u03b5\u03b8\u03bd\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "grc", "\u0391\u03c1\u03c7\u03b1\u03af\u03b1 \u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac" },
            { "GA", "\u0393\u03ba\u03b1\u03bc\u03c0\u03cc\u03bd" },
            { "vot", "\u0392\u03cc\u03c4\u03b9\u03ba" },
            { "GB", "\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03bf \u0392\u03b1\u03c3\u03af\u03bb\u03b5\u03b9\u03bf" },
            { "pcm", "\u03a0\u03af\u03c4\u03b6\u03b9\u03bd \u039d\u03b9\u03b3\u03b7\u03c1\u03af\u03b1\u03c2" },
            { "GD", "\u0393\u03c1\u03b5\u03bd\u03ac\u03b4\u03b1" },
            { "GE", "\u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1" },
            { "GF", "\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ae \u0393\u03bf\u03c5\u03b9\u03ac\u03bd\u03b1" },
            { "GG", "\u0393\u03ba\u03ad\u03c1\u03bd\u03b6\u03b9" },
            { "GH", "\u0393\u03ba\u03ac\u03bd\u03b1" },
            { "Tale", "\u03a4\u03ac\u03b9 \u039b\u03b5" },
            { "GI", "\u0393\u03b9\u03b2\u03c1\u03b1\u03bb\u03c4\u03ac\u03c1" },
            { "afh", "\u0391\u03c6\u03c1\u03b9\u03c7\u03af\u03bb\u03b9" },
            { "GL", "\u0393\u03c1\u03bf\u03b9\u03bb\u03b1\u03bd\u03b4\u03af\u03b1" },
            { "enm", "\u039c\u03ad\u03c3\u03b1 \u0391\u03b3\u03b3\u03bb\u03b9\u03ba\u03ac" },
            { "GM", "\u0393\u03ba\u03ac\u03bc\u03c0\u03b9\u03b1" },
            { "GN", "\u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1" },
            { "GP", "\u0393\u03bf\u03c5\u03b1\u03b4\u03b5\u03bb\u03bf\u03cd\u03c0\u03b7" },
            { "GQ", "\u0399\u03c3\u03b7\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1" },
            { "GR", "\u0395\u03bb\u03bb\u03ac\u03b4\u03b1" },
            { "GS", "\u039d\u03ae\u03c3\u03bf\u03b9 \u039d\u03cc\u03c4\u03b9\u03b1 \u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1 \u03ba\u03b1\u03b9 \u039d\u03cc\u03c4\u03b9\u03b5\u03c2 \u03a3\u03ac\u03bd\u03c4\u03bf\u03c5\u03b9\u03c4\u03c2" },
            { "GT", "\u0393\u03bf\u03c5\u03b1\u03c4\u03b5\u03bc\u03ac\u03bb\u03b1" },
            { "GU", "\u0393\u03ba\u03bf\u03c5\u03ac\u03bc" },
            { "GW", "\u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1 \u039c\u03c0\u03b9\u03c3\u03ac\u03bf\u03c5" },
            { "tli", "\u03a4\u03bb\u03af\u03bd\u03b3\u03ba\u03b9\u03c4" },
            { "tlh", "\u039a\u03bb\u03af\u03bd\u03b3\u03ba\u03bf\u03bd" },
            { "Talu", "\u039d\u03ad\u03bf \u03a4\u03ac\u03b9 \u039b\u03bf\u03cd\u03b5" },
            { "GY", "\u0393\u03bf\u03c5\u03b9\u03ac\u03bd\u03b1" },
            { "ckb", "\u039a\u03bf\u03c5\u03c1\u03b4\u03b9\u03ba\u03ac \u03a3\u03bf\u03c1\u03ac\u03bd\u03b9" },
            { "zxx", "\u03a7\u03c9\u03c1\u03af\u03c2 \u03b3\u03bb\u03c9\u03c3\u03c3\u03bf\u03bb\u03bf\u03b3\u03b9\u03ba\u03cc \u03c0\u03b5\u03c1\u03b9\u03b5\u03c7\u03cc\u03bc\u03b5\u03bd\u03bf" },
            { "de_AT", "\u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac \u0391\u03c5\u03c3\u03c4\u03c1\u03af\u03b1\u03c2" },
            { "Vaii", metaValue_vai },
            { "HK", "\u03a7\u03bf\u03bd\u03b3\u03ba \u039a\u03bf\u03bd\u03b3\u03ba \u0395\u0394\u03a0 \u039a\u03af\u03bd\u03b1\u03c2" },
            { "HM", "\u039d\u03ae\u03c3\u03bf\u03b9 \u03a7\u03b5\u03c1\u03bd\u03c4 \u03ba\u03b1\u03b9 \u039c\u03b1\u03ba\u03bd\u03c4\u03cc\u03bd\u03b1\u03bb\u03bd\u03c4" },
            { "HN", "\u039f\u03bd\u03b4\u03bf\u03cd\u03c1\u03b1" },
            { "HR", "\u039a\u03c1\u03bf\u03b1\u03c4\u03af\u03b1" },
            { "agq", "\u0391\u03b3\u03ba\u03ad\u03bc" },
            { "gsw", "\u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac \u0395\u03bb\u03b2\u03b5\u03c4\u03af\u03b1\u03c2" },
            { "type.ca.islamic-umalqura", "\u0399\u03c3\u03bb\u03b1\u03bc\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf (Umm al-Qura)" },
            { "HT", "\u0391\u03ca\u03c4\u03ae" },
            { "HU", "\u039f\u03c5\u03b3\u03b3\u03b1\u03c1\u03af\u03b1" },
            { "tmh", "\u03a4\u03b1\u03bc\u03b1\u03c3\u03ad\u03ba" },
            { "IC", "\u039a\u03b1\u03bd\u03ac\u03c1\u03b9\u03bf\u03b9 \u039d\u03ae\u03c3\u03bf\u03b9" },
            { "ID", "\u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1" },
            { "peo", "\u0391\u03c1\u03c7\u03b1\u03af\u03b1 \u03a0\u03b5\u03c1\u03c3\u03b9\u03ba\u03ac" },
            { "IE", "\u0399\u03c1\u03bb\u03b1\u03bd\u03b4\u03af\u03b1" },
            { "nap", "\u039d\u03b1\u03c0\u03bf\u03bb\u03b9\u03c4\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "naq", "\u039d\u03ac\u03bc\u03b1" },
            { "zza", "\u0396\u03ac\u03b6\u03b1" },
            { "IL", "\u0399\u03c3\u03c1\u03b1\u03ae\u03bb" },
            { "IM", "\u039d\u03ae\u03c3\u03bf\u03c2 \u03c4\u03bf\u03c5 \u039c\u03b1\u03bd" },
            { "IN", "\u0399\u03bd\u03b4\u03af\u03b1" },
            { "type.co.eor", "\u0395\u03c5\u03c1\u03c9\u03c0\u03b1\u03ca\u03ba\u03bf\u03af \u03ba\u03b1\u03bd\u03cc\u03bd\u03b5\u03c2 \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2" },
            { "IO", "\u0392\u03c1\u03b5\u03c4\u03b1\u03bd\u03b9\u03ba\u03ac \u0395\u03b4\u03ac\u03c6\u03b7 \u0399\u03bd\u03b4\u03b9\u03ba\u03bf\u03cd \u03a9\u03ba\u03b5\u03b1\u03bd\u03bf\u03cd" },
            { "IQ", "\u0399\u03c1\u03ac\u03ba" },
            { "IR", "\u0399\u03c1\u03ac\u03bd" },
            { "IS", "\u0399\u03c3\u03bb\u03b1\u03bd\u03b4\u03af\u03b1" },
            { "IT", "\u0399\u03c4\u03b1\u03bb\u03af\u03b1" },
            { "Zmth", "\u039c\u03b1\u03b8\u03b7\u03bc\u03b1\u03c4\u03b9\u03ba\u03ae \u03c3\u03b7\u03bc\u03b5\u03b9\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b1" },
            { "type.nu.thai", "\u03a4\u03b1\u03ca\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "%%POSIX", "\u03a5\u03c0\u03bf\u03bb\u03bf\u03b3\u03b9\u03c3\u03c4\u03ae\u03c2" },
            { "type.nu.beng", "\u0392\u03b5\u03b3\u03b3\u03b1\u03bb\u03b9\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "JE", "\u03a4\u03b6\u03ad\u03c1\u03b6\u03b9" },
            { "type.ca.islamic", "\u0399\u03c3\u03bb\u03b1\u03bc\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "JM", "\u03a4\u03b6\u03b1\u03bc\u03ac\u03b9\u03ba\u03b1" },
            { "Beng", "\u039c\u03c0\u03b5\u03bd\u03b3\u03ba\u03ac\u03bb\u03b9" },
            { "JO", "\u0399\u03bf\u03c1\u03b4\u03b1\u03bd\u03af\u03b1" },
            { "JP", "\u0399\u03b1\u03c0\u03c9\u03bd\u03af\u03b1" },
            { "%%1606NICT", "\u039d\u03b5\u03cc\u03c4\u03b5\u03c1\u03b1 \u039c\u03ad\u03c3\u03b1 \u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ac \u03c4\u03bf\u03c5 1606" },
            { "ain", "\u0391\u03ca\u03bd\u03bf\u03cd" },
            { "guz", "\u0393\u03ba\u03bf\u03cd\u03c3\u03b9" },
            { "tog", "\u039d\u03b9\u03ac\u03c3\u03b1 \u03a4\u03cc\u03bd\u03b3\u03ba\u03b1" },
            { "type.nu.knda", "\u03a8\u03b7\u03c6\u03af\u03b1 \u039a\u03b1\u03bd\u03ac\u03bd\u03c4\u03b1" },
            { "Kali", "\u039a\u03b1\u03b3\u03b9\u03ac\u03c7 \u039b\u03b9" },
            { "de_CH", "\u03a5\u03c8\u03b7\u03bb\u03ac \u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac \u0395\u03bb\u03b2\u03b5\u03c4\u03af\u03b1\u03c2" },
            { "type.co.phonetic", "\u03a6\u03c9\u03bd\u03b7\u03c4\u03b9\u03ba\u03ae \u03c3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2" },
            { "type.ca.buddhist", "\u0392\u03bf\u03c5\u03b4\u03b9\u03c3\u03c4\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "KE", "\u039a\u03ad\u03bd\u03c5\u03b1" },
            { "419", "\u039b\u03b1\u03c4\u03b9\u03bd\u03b9\u03ba\u03ae \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae" },
            { "KG", "\u039a\u03b9\u03c1\u03b3\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "KH", "\u039a\u03b1\u03bc\u03c0\u03cc\u03c4\u03b6\u03b7" },
            { "KI", "\u039a\u03b9\u03c1\u03b9\u03bc\u03c0\u03ac\u03c4\u03b9" },
            { "KM", "\u039a\u03bf\u03bc\u03cc\u03c1\u03b5\u03c2" },
            { "Knda", metaValue_kn },
            { "KN", "\u03a3\u03b5\u03bd \u039a\u03b9\u03c4\u03c2 \u03ba\u03b1\u03b9 \u039d\u03ad\u03b2\u03b9\u03c2" },
            { "Zinh", "\u039a\u03bb\u03b7\u03c1\u03bf\u03bd\u03bf\u03bc\u03b7\u03bc\u03ad\u03bd\u03bf" },
            { "fr_CA", "\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ac \u039a\u03b1\u03bd\u03b1\u03b4\u03ac" },
            { "KP", "\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u039a\u03bf\u03c1\u03ad\u03b1" },
            { "KR", "\u039d\u03cc\u03c4\u03b9\u03b1 \u039a\u03bf\u03c1\u03ad\u03b1" },
            { "Plrd", "\u03a6\u03c9\u03bd\u03b7\u03c4\u03b9\u03ba\u03cc \u03a0\u03cc\u03bb\u03b1\u03c1\u03bd\u03c4" },
            { "fr_CH", "\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ac \u0395\u03bb\u03b2\u03b5\u03c4\u03af\u03b1\u03c2" },
            { "KW", "\u039a\u03bf\u03c5\u03b2\u03ad\u03b9\u03c4" },
            { "tpi", "\u03a4\u03bf\u03ba \u03a0\u03b9\u03c3\u03af\u03bd" },
            { "KY", "\u039d\u03ae\u03c3\u03bf\u03b9 \u039a\u03ad\u03b9\u03bc\u03b1\u03bd" },
            { "KZ", "\u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd" },
            { "Cyrl", "\u039a\u03c5\u03c1\u03b9\u03bb\u03bb\u03b9\u03ba\u03cc" },
            { "LA", metaValue_LA },
            { "LB", "\u039b\u03af\u03b2\u03b1\u03bd\u03bf\u03c2" },
            { "LC", "\u0391\u03b3\u03af\u03b1 \u039b\u03bf\u03c5\u03ba\u03af\u03b1" },
            { "phn", "\u03a6\u03bf\u03b9\u03bd\u03b9\u03ba\u03b9\u03ba\u03ac" },
            { "Cyrs", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03cc \u0395\u03ba\u03ba\u03bb\u03b7\u03c3\u03b9\u03b1\u03c3\u03c4\u03b9\u03ba\u03cc \u03a3\u03bb\u03b1\u03b2\u03b9\u03ba\u03cc \u039a\u03c5\u03c1\u03b9\u03bb\u03bb\u03b9\u03ba\u03cc" },
            { "gwi", "\u0393\u03ba\u03bf\u03c5\u03af\u03c4\u03c3\u03b9\u03bd" },
            { "nds", "\u039a\u03ac\u03c4\u03c9 \u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "LI", "\u039b\u03b9\u03c7\u03c4\u03b5\u03bd\u03c3\u03c4\u03ac\u03b9\u03bd" },
            { "LK", "\u03a3\u03c1\u03b9 \u039b\u03ac\u03bd\u03ba\u03b1" },
            { "akk", "\u0391\u03ba\u03ac\u03bd\u03c4\u03b9\u03b1\u03bd" },
            { "cop", "\u039a\u03bf\u03c0\u03c4\u03b9\u03ba\u03ac" },
            { "LR", "\u039b\u03b9\u03b2\u03b5\u03c1\u03af\u03b1" },
            { "LS", "\u039b\u03b5\u03c3\u03cc\u03c4\u03bf" },
            { "Phlv", "\u039c\u03c0\u03bf\u03c5\u03ba \u03a0\u03b1\u03c7\u03bb\u03b1\u03b2\u03af" },
            { "LT", "\u039b\u03b9\u03b8\u03bf\u03c5\u03b1\u03bd\u03af\u03b1" },
            { "LU", "\u039b\u03bf\u03c5\u03be\u03b5\u03bc\u03b2\u03bf\u03cd\u03c1\u03b3\u03bf" },
            { "LV", "\u039b\u03b5\u03c4\u03bf\u03bd\u03af\u03b1" },
            { "Kana", "\u039a\u03b1\u03c4\u03b1\u03ba\u03ac\u03bd\u03b1" },
            { "LY", "\u039b\u03b9\u03b2\u03cd\u03b7" },
            { "lad", "\u039b\u03b1\u03b4\u03af\u03bd\u03bf" },
            { "vun", "\u0392\u03bf\u03cd\u03bd\u03c4\u03b6\u03bf" },
            { "lah", "\u039b\u03ac\u03c7\u03b4\u03b1" },
            { "lag", "\u039b\u03ac\u03bd\u03b3\u03ba\u03b9" },
            { "Thaa", "\u0398\u03b1\u03b1\u03bd\u03ac" },
            { "MA", "\u039c\u03b1\u03c1\u03cc\u03ba\u03bf" },
            { "MC", "\u039c\u03bf\u03bd\u03b1\u03ba\u03cc" },
            { "MD", "\u039c\u03bf\u03bb\u03b4\u03b1\u03b2\u03af\u03b1" },
            { "ME", "\u039c\u03b1\u03c5\u03c1\u03bf\u03b2\u03bf\u03cd\u03bd\u03b9\u03bf" },
            { "MF", "\u0386\u03b3\u03b9\u03bf\u03c2 \u039c\u03b1\u03c1\u03c4\u03af\u03bd\u03bf\u03c2 (\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03cc \u03c4\u03bc\u03ae\u03bc\u03b1)" },
            { "lam", "\u039b\u03ac\u03bc\u03c0\u03b1" },
            { "MG", "\u039c\u03b1\u03b4\u03b1\u03b3\u03b1\u03c3\u03ba\u03ac\u03c1\u03b7" },
            { "MH", "\u039d\u03ae\u03c3\u03bf\u03b9 \u039c\u03ac\u03c1\u03c3\u03b1\u03bb" },
            { "ale", "\u0391\u03bb\u03b5\u03bf\u03cd\u03c4" },
            { "Thai", "\u03a4\u03b1\u03ca\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03cc" },
            { "type.nu.vaii", "\u03a8\u03b7\u03c6\u03af\u03b1 \u0392\u03ac\u03b9" },
            { "MK", "\u03a0\u03c1\u03ce\u03b7\u03bd \u0393\u03b9\u03bf\u03c5\u03b3\u03ba\u03bf\u03c3\u03bb\u03b1\u03b2\u03b9\u03ba\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1 \u03c4\u03b7\u03c2 \u039c\u03b1\u03ba\u03b5\u03b4\u03bf\u03bd\u03af\u03b1\u03c2" },
            { "ML", "\u039c\u03ac\u03bb\u03b9" },
            { "MM", "\u039c\u03b9\u03b1\u03bd\u03bc\u03ac\u03c1 (\u0392\u03b9\u03c1\u03bc\u03b1\u03bd\u03af\u03b1)" },
            { "MN", "\u039c\u03bf\u03b3\u03b3\u03bf\u03bb\u03af\u03b1" },
            { "new", "\u039d\u03b5\u03b3\u03bf\u03c5\u03ac\u03c1\u03b9" },
            { "MO", "\u039c\u03b1\u03ba\u03ac\u03bf \u0395\u0394\u03a0 \u039a\u03af\u03bd\u03b1\u03c2" },
            { "MP", "\u039d\u03ae\u03c3\u03bf\u03b9 \u0392\u03cc\u03c1\u03b5\u03b9\u03b5\u03c2 \u039c\u03b1\u03c1\u03b9\u03ac\u03bd\u03b5\u03c2" },
            { "MQ", "\u039c\u03b1\u03c1\u03c4\u03b9\u03bd\u03af\u03ba\u03b1" },
            { "MR", "\u039c\u03b1\u03c5\u03c1\u03b9\u03c4\u03b1\u03bd\u03af\u03b1" },
            { "MS", "\u039c\u03bf\u03bd\u03c3\u03b5\u03c1\u03ac\u03c4" },
            { "MT", "\u039c\u03ac\u03bb\u03c4\u03b1" },
            { "type.m0.ungegn", "\u039c\u03b5\u03c4\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae GEGN \u039f\u0397\u0395" },
            { "MU", "\u039c\u03b1\u03c5\u03c1\u03af\u03ba\u03b9\u03bf\u03c2" },
            { "alt", "\u039d\u03cc\u03c4\u03b9\u03b1 \u0391\u03bb\u03c4\u03ac\u03b9" },
            { "MV", "\u039c\u03b1\u03bb\u03b4\u03af\u03b2\u03b5\u03c2" },
            { "MW", "\u039c\u03b1\u03bb\u03ac\u03bf\u03c5\u03b9" },
            { "MX", "\u039c\u03b5\u03be\u03b9\u03ba\u03cc" },
            { "type.ca.japanese", "\u0399\u03b1\u03c0\u03c9\u03bd\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "MY", "\u039c\u03b1\u03bb\u03b1\u03b9\u03c3\u03af\u03b1" },
            { "MZ", "\u039c\u03bf\u03b6\u03b1\u03bc\u03b2\u03af\u03ba\u03b7" },
            { "Phli", "\u0395\u03c0\u03b9\u03b3\u03c1\u03b1\u03c6\u03b9\u03ba\u03cc \u03a0\u03b1\u03c7\u03bb\u03ac\u03b2\u03b9" },
            { "NA", "\u039d\u03b1\u03bc\u03af\u03bc\u03c0\u03b9\u03b1" },
            { "202", "202" },
            { "type.ca.hebrew", "\u0395\u03b2\u03c1\u03b1\u03ca\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "type.co.dictionary", "\u03a3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2 \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03bf\u03b3\u03af\u03bf\u03c5" },
            { "NC", "\u039d\u03ad\u03b1 \u039a\u03b1\u03bb\u03b7\u03b4\u03bf\u03bd\u03af\u03b1" },
            { "%%WADEGILE", "\u0395\u03ba\u03bb\u03b1\u03c4\u03b9\u03bd\u03b9\u03c3\u03bc\u03ad\u03bd\u03b1 \u0393\u03bf\u03c5\u03ac\u03bd\u03c4-\u0393\u03ba\u03b9\u03bb\u03c2" },
            { "%%UCRCOR", "\u0395\u03bd\u03c9\u03c0\u03bf\u03b9\u03b7\u03bc\u03ad\u03bd\u03b7 \u03b1\u03bd\u03b1\u03b8\u03b5\u03c9\u03c1\u03b7\u03bc\u03ad\u03bd\u03b7 \u03bf\u03c1\u03b8\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b1" },
            { "NE", "\u039d\u03af\u03b3\u03b7\u03c1\u03b1\u03c2" },
            { "NF", "\u039d\u03ae\u03c3\u03bf\u03c2 \u039d\u03cc\u03c1\u03c6\u03bf\u03bb\u03ba" },
            { "NG", "\u039d\u03b9\u03b3\u03b7\u03c1\u03af\u03b1" },
            { "trv", "\u03a4\u03b1\u03c1\u03cc\u03ba\u03bf" },
            { "Phlp", "\u03a8\u03ac\u03bb\u03c4\u03b5\u03c1 \u03a0\u03b1\u03c7\u03bb\u03ac\u03b2\u03b9" },
            { "NI", "\u039d\u03b9\u03ba\u03b1\u03c1\u03ac\u03b3\u03bf\u03c5\u03b1" },
            { "Hmng", "\u03a0\u03b1\u03c7\u03ac\u03c7 \u03a7\u03bc\u03bf\u03bd\u03b3\u03ba" },
            { "NL", "\u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03af\u03b1" },
            { "NO", "\u039d\u03bf\u03c1\u03b2\u03b7\u03b3\u03af\u03b1" },
            { "NP", "\u039d\u03b5\u03c0\u03ac\u03bb" },
            { "NR", "\u039d\u03b1\u03bf\u03c5\u03c1\u03bf\u03cd" },
            { "NU", metaValue_NU },
            { "Phnx", "\u03a6\u03bf\u03b9\u03bd\u03b9\u03ba\u03b9\u03ba\u03cc" },
            { "rof", "\u03a1\u03cc\u03bc\u03c0\u03bf" },
            { "tsi", "\u03a4\u03c3\u03af\u03bc\u03c3\u03b9\u03b1\u03bd" },
            { "NZ", "\u039d\u03ad\u03b1 \u0396\u03b7\u03bb\u03b1\u03bd\u03b4\u03af\u03b1" },
            { "rom", "\u03a1\u03bf\u03bc\u03b1\u03bd\u03af" },
            { "Mero", "\u039c\u03b5\u03c1\u03bf\u03ca\u03c4\u03b9\u03ba\u03cc" },
            { "crh", "\u03a4\u03bf\u03c5\u03c1\u03ba\u03b9\u03ba\u03ac \u039a\u03c1\u03b9\u03bc\u03b1\u03af\u03b1\u03c2" },
            { "ang", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03ac \u0391\u03b3\u03b3\u03bb\u03b9\u03ba\u03ac" },
            { "OM", "\u039f\u03bc\u03ac\u03bd" },
            { "anp", "\u0391\u03bd\u03b3\u03ba\u03b9\u03ba\u03ac" },
            { "crs", "\u039a\u03c1\u03b5\u03bf\u03bb\u03b9\u03ba\u03ac \u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ac \u03a3\u03b5\u03cb\u03c7\u03b5\u03bb\u03bb\u03ce\u03bd" },
            { "Xpeo", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03cc \u03a0\u03b5\u03c1\u03c3\u03b9\u03ba\u03cc" },
            { "PA", "\u03a0\u03b1\u03bd\u03b1\u03bc\u03ac\u03c2" },
            { "type.ca.islamic-civil", "\u0399\u03c3\u03bb\u03b1\u03bc\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf (\u03c3\u03b5 \u03bc\u03bf\u03c1\u03c6\u03ae \u03c0\u03af\u03bd\u03b1\u03ba\u03b1, \u03b1\u03c3\u03c4\u03b9\u03ba\u03cc \u03b5\u03c0\u03bf\u03c7\u03ae\u03c2)" },
            { "csb", "\u039a\u03b1\u03c3\u03bf\u03cd\u03bc\u03c0\u03b9\u03b1\u03bd" },
            { "en_GB", "\u0391\u03b3\u03b3\u03bb\u03b9\u03ba\u03ac \u0392\u03c1\u03b5\u03c4\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "PE", "\u03a0\u03b5\u03c1\u03bf\u03cd" },
            { "PF", "\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ae \u03a0\u03bf\u03bb\u03c5\u03bd\u03b7\u03c3\u03af\u03b1" },
            { "PG", "\u03a0\u03b1\u03c0\u03bf\u03cd\u03b1 \u039d\u03ad\u03b1 \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1" },
            { "PH", "\u03a6\u03b9\u03bb\u03b9\u03c0\u03c0\u03af\u03bd\u03b5\u03c2" },
            { "PK", "\u03a0\u03b1\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "PL", "\u03a0\u03bf\u03bb\u03c9\u03bd\u03af\u03b1" },
            { "ewo", "\u0395\u03b3\u03bf\u03c5\u03cc\u03bd\u03c4\u03bf" },
            { "PM", "\u03a3\u03b5\u03bd \u03a0\u03b9\u03b5\u03c1 \u03ba\u03b1\u03b9 \u039c\u03b9\u03ba\u03b5\u03bb\u03cc\u03bd" },
            { "PN", "\u039d\u03ae\u03c3\u03bf\u03b9 \u03a0\u03af\u03c4\u03ba\u03b5\u03c1\u03bd" },
            { "PR", "\u03a0\u03bf\u03c5\u03ad\u03c1\u03c4\u03bf \u03a1\u03af\u03ba\u03bf" },
            { "Bali", metaValue_ban },
            { "PS", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03c3\u03c4\u03b9\u03bd\u03b9\u03b1\u03ba\u03ac \u0395\u03b4\u03ac\u03c6\u03b7" },
            { "PT", "\u03a0\u03bf\u03c1\u03c4\u03bf\u03b3\u03b1\u03bb\u03af\u03b1" },
            { "PW", "\u03a0\u03b1\u03bb\u03ac\u03bf\u03c5" },
            { "nia", "\u039d\u03af\u03b1\u03c2" },
            { "type.nu.greklow", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac \u03c0\u03b5\u03b6\u03ac" },
            { "PY", "\u03a0\u03b1\u03c1\u03b1\u03b3\u03bf\u03c5\u03ac\u03b7" },
            { "tum", "\u03a4\u03bf\u03c5\u03bc\u03c0\u03bf\u03cd\u03ba\u03b1" },
            { "Hebr", "\u0395\u03b2\u03c1\u03b1\u03ca\u03ba\u03cc" },
            { "QA", "\u039a\u03b1\u03c4\u03ac\u03c1" },
            { "%%SCOTLAND", "\u03a3\u03ba\u03bf\u03c4\u03c3\u03b5\u03b6\u03b9\u03ba\u03ac \u03c4\u03c5\u03c0\u03bf\u03c0\u03bf\u03b9\u03b7\u03bc\u03ad\u03bd\u03b1 \u0391\u03b3\u03b3\u03bb\u03b9\u03ba\u03ac" },
            { "niu", metaValue_NU },
            { "QO", "\u03a0\u03b5\u03c1\u03b9\u03c6\u03b5\u03c1\u03b5\u03b9\u03b1\u03ba\u03ae \u03a9\u03ba\u03b5\u03b1\u03bd\u03af\u03b1" },
            { "lez", "\u039b\u03b5\u03b6\u03b3\u03ba\u03b9\u03ba\u03ac" },
            { "%%FONUPA", "\u039f\u03c5\u03c1\u03b1\u03bb\u03b9\u03ba\u03ae \u03c6\u03c9\u03bd\u03b7\u03c4\u03b9\u03ba\u03ae \u03b1\u03bb\u03c6\u03ac\u03b2\u03b7\u03c4\u03bf\u03c2" },
            { "tvl", metaValue_TV },
            { "Tavt", "\u03a4\u03ac\u03b9 \u0392\u03b9\u03ad\u03c4" },
            { "001", "\u039a\u03cc\u03c3\u03bc\u03bf\u03c2" },
            { "002", "\u0391\u03c6\u03c1\u03b9\u03ba\u03ae" },
            { "003", "\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae" },
            { "RE", "\u03a1\u03b5\u03ca\u03bd\u03b9\u03cc\u03bd" },
            { "005", "\u039d\u03cc\u03c4\u03b9\u03b1 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae" },
            { "jbo", "\u039b\u03cc\u03b6\u03bc\u03c0\u03b1\u03bd" },
            { "Rjng", "\u03a1\u03b5\u03c4\u03b6\u03ac\u03bd\u03b3\u03ba" },
            { "009", "\u03a9\u03ba\u03b5\u03b1\u03bd\u03af\u03b1" },
            { "RO", "\u03a1\u03bf\u03c5\u03bc\u03b1\u03bd\u03af\u03b1" },
            { "RS", "\u03a3\u03b5\u03c1\u03b2\u03af\u03b1" },
            { "RU", "\u03a1\u03c9\u03c3\u03af\u03b1" },
            { "RW", "\u03a1\u03bf\u03c5\u03ac\u03bd\u03c4\u03b1" },
            { "Mani", "\u039c\u03b1\u03bd\u03b9\u03c7\u03b1\u03ca\u03ba\u03cc" },
            { "Ugar", "\u039f\u03c5\u03b3\u03ba\u03b1\u03c1\u03b9\u03c4\u03b9\u03ba\u03cc" },
            { "Khar", "\u039a\u03b1\u03c1\u03cc\u03c3\u03b8\u03b9" },
            { "SA", "\u03a3\u03b1\u03bf\u03c5\u03b4\u03b9\u03ba\u03ae \u0391\u03c1\u03b1\u03b2\u03af\u03b1" },
            { "pon", "\u03a0\u03bf\u03bc\u03c0\u03b7\u03b9\u03ba\u03ac" },
            { "Mand", "\u039c\u03b1\u03bd\u03b4\u03b1\u03ca\u03ba\u03cc" },
            { "SB", "\u039d\u03ae\u03c3\u03bf\u03b9 \u03a3\u03bf\u03bb\u03bf\u03bc\u03ce\u03bd\u03c4\u03bf\u03c2" },
            { "twq", "\u03a4\u03b1\u03c3\u03b1\u03b2\u03ac\u03ba" },
            { "011", "\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u0391\u03c6\u03c1\u03b9\u03ba\u03ae" },
            { "SC", "\u03a3\u03b5\u03cb\u03c7\u03ad\u03bb\u03bb\u03b5\u03c2" },
            { "SD", "\u03a3\u03bf\u03c5\u03b4\u03ac\u03bd" },
            { "013", "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae" },
            { "SE", "\u03a3\u03bf\u03c5\u03b7\u03b4\u03af\u03b1" },
            { "014", "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u0391\u03c6\u03c1\u03b9\u03ba\u03ae" },
            { "arc", "\u0391\u03c1\u03b1\u03bc\u03b1\u03ca\u03ba\u03ac" },
            { "015", "\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae" },
            { "SG", "\u03a3\u03b9\u03b3\u03ba\u03b1\u03c0\u03bf\u03cd\u03c1\u03b7" },
            { "SH", "\u0391\u03b3\u03af\u03b1 \u0395\u03bb\u03ad\u03bd\u03b7" },
            { "type.lb.strict", "\u03a3\u03c4\u03b5\u03bd\u03cc \u03c3\u03c4\u03b9\u03bb \u03b1\u03bb\u03bb\u03b1\u03b3\u03ae\u03c2 \u03b3\u03c1\u03b1\u03bc\u03bc\u03ce\u03bd" },
            { "017", "\u039c\u03ad\u03c3\u03b7 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae" },
            { "SI", "\u03a3\u03bb\u03bf\u03b2\u03b5\u03bd\u03af\u03b1" },
            { "018", "\u039d\u03cc\u03c4\u03b9\u03bf\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae" },
            { "SJ", "\u03a3\u03b2\u03ac\u03bb\u03bc\u03c0\u03b1\u03c1\u03bd\u03c4 \u03ba\u03b1\u03b9 \u0393\u03b9\u03b1\u03bd \u039c\u03b1\u03b3\u03b9\u03ad\u03bd" },
            { "019", "\u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae" },
            { "SK", "\u03a3\u03bb\u03bf\u03b2\u03b1\u03ba\u03af\u03b1" },
            { "SL", "\u03a3\u03b9\u03ad\u03c1\u03b1 \u039b\u03b5\u03cc\u03bd\u03b5" },
            { "SM", "\u0386\u03b3\u03b9\u03bf\u03c2 \u039c\u03b1\u03c1\u03af\u03bd\u03bf\u03c2" },
            { "SN", "\u03a3\u03b5\u03bd\u03b5\u03b3\u03ac\u03bb\u03b7" },
            { "SO", "\u03a3\u03bf\u03bc\u03b1\u03bb\u03af\u03b1" },
            { "arn", "\u0391\u03c1\u03b1\u03bf\u03c5\u03ba\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "arp", "\u0391\u03c1\u03b1\u03c0\u03ac\u03c7\u03bf" },
            { "type.nu.taml", "\u03a4\u03b1\u03bc\u03b9\u03bb\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "SR", "\u03a3\u03bf\u03c5\u03c1\u03b9\u03bd\u03ac\u03bc" },
            { "SS", "\u039d\u03cc\u03c4\u03b9\u03bf \u03a3\u03bf\u03c5\u03b4\u03ac\u03bd" },
            { "ST", "\u03a3\u03ac\u03bf \u03a4\u03bf\u03bc\u03ad \u03ba\u03b1\u03b9 \u03a0\u03c1\u03af\u03bd\u03c3\u03b9\u03c0\u03b5" },
            { "SV", "\u0395\u03bb \u03a3\u03b1\u03bb\u03b2\u03b1\u03b4\u03cc\u03c1" },
            { "ars", "\u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ac \u039d\u03ac\u03c4\u03b6\u03bd\u03c4\u03b9" },
            { "SX", "\u0386\u03b3\u03b9\u03bf\u03c2 \u039c\u03b1\u03c1\u03c4\u03af\u03bd\u03bf\u03c2 (\u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03cc \u03c4\u03bc\u03ae\u03bc\u03b1)" },
            { "SY", "\u03a3\u03c5\u03c1\u03af\u03b1" },
            { "yao", "\u0393\u03b9\u03ac\u03bf" },
            { "SZ", "\u03a3\u03bf\u03c5\u03b1\u03b6\u03b9\u03bb\u03ac\u03bd\u03b4\u03b7" },
            { "arw", "\u0391\u03c1\u03b1\u03b3\u03bf\u03c5\u03ac\u03ba" },
            { "yap", "\u0393\u03b9\u03b1\u03c0\u03af\u03b6" },
            { "TA", "\u03a4\u03c1\u03b9\u03c3\u03c4\u03ac\u03bd \u03bd\u03c4\u03b1 \u039a\u03bf\u03cd\u03bd\u03b9\u03b1" },
            { "asa", "\u0386\u03c3\u03bf\u03c5" },
            { "type.ms.ussystem", "\u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03cc \u03c3\u03cd\u03c3\u03c4\u03b7\u03bc\u03b1 \u03bc\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7\u03c2" },
            { "021", "\u0392\u03cc\u03c1\u03b5\u03b9\u03bf\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae" },
            { "TC", "\u039d\u03ae\u03c3\u03bf\u03b9 \u03a4\u03b5\u03c1\u03ba\u03c2 \u03ba\u03b1\u03b9 \u039a\u03ac\u03b9\u03ba\u03bf\u03c2" },
            { "yav", "\u0393\u03b9\u03b1\u03bd\u03b3\u03ba\u03bc\u03c0\u03ad\u03bd" },
            { "TD", "\u03a4\u03c3\u03b1\u03bd\u03c4" },
            { "TF", "\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ad\u03c2 \u03c0\u03b5\u03c1\u03b9\u03bf\u03c7\u03ad\u03c2 \u03c4\u03bf\u03c5 \u03bd\u03bf\u03c4\u03af\u03bf\u03c5 \u03b7\u03bc\u03b9\u03c3\u03c6\u03b1\u03b9\u03c1\u03af\u03bf\u03c5" },
            { "TG", "\u03a4\u03cc\u03b3\u03ba\u03bf" },
            { "TH", "\u03a4\u03b1\u03ca\u03bb\u03ac\u03bd\u03b4\u03b7" },
            { "TJ", "\u03a4\u03b1\u03c4\u03b6\u03b9\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "TK", metaValue_TK },
            { "029", "\u039a\u03b1\u03c1\u03b1\u03ca\u03b2\u03b9\u03ba\u03ae" },
            { "TL", "\u03a4\u03b9\u03bc\u03cc\u03c1-\u039b\u03ad\u03c3\u03c4\u03b5" },
            { "ybb", "\u0393\u03b9\u03ad\u03bc\u03c0\u03b1" },
            { "type.co.searchjl", "\u0391\u03bd\u03b1\u03b6\u03ae\u03c4\u03b7\u03c3\u03b7 \u03ba\u03b1\u03c4\u03ac \u03b1\u03c1\u03c7\u03b9\u03ba\u03cc \u03c3\u03cd\u03bc\u03c6\u03c9\u03bd\u03bf \u03a7\u03b1\u03bd\u03b3\u03ba\u03bf\u03cd\u03bb" },
            { "TM", "\u03a4\u03bf\u03c5\u03c1\u03ba\u03bc\u03b5\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "%%BOONT", "\u039c\u03c0\u03bf\u03cd\u03bd\u03c4\u03bb\u03b9\u03bd\u03b3\u03ba" },
            { "TN", "\u03a4\u03c5\u03bd\u03b7\u03c3\u03af\u03b1" },
            { "TO", "\u03a4\u03cc\u03bd\u03b3\u03ba\u03b1" },
            { "TR", "\u03a4\u03bf\u03c5\u03c1\u03ba\u03af\u03b1" },
            { "TT", "\u03a4\u03c1\u03b9\u03bd\u03b9\u03bd\u03c4\u03ac\u03bd\u03c4 \u03ba\u03b1\u03b9 \u03a4\u03bf\u03bc\u03c0\u03ac\u03b3\u03ba\u03bf" },
            { "TV", metaValue_TV },
            { "TW", "\u03a4\u03b1\u03ca\u03b2\u03ac\u03bd" },
            { "ast", "\u0391\u03c3\u03c4\u03bf\u03c5\u03c1\u03b9\u03b1\u03bd\u03ac" },
            { "Orkh", "\u038c\u03c1\u03ba\u03c7\u03bf\u03bd" },
            { "TZ", "\u03a4\u03b1\u03bd\u03b6\u03b1\u03bd\u03af\u03b1" },
            { "nmg", "\u039a\u03b2\u03ac\u03c3\u03b9\u03bf" },
            { "Zzzz", "\u0386\u03b3\u03bd\u03c9\u03c3\u03c4\u03b7 \u03b3\u03c1\u03b1\u03c6\u03ae" },
            { "UA", "\u039f\u03c5\u03ba\u03c1\u03b1\u03bd\u03af\u03b1" },
            { "rup", "\u0391\u03c1\u03bf\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "030", "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u0391\u03c3\u03af\u03b1" },
            { "tyv", "\u03a4\u03bf\u03c5\u03b2\u03b9\u03bd\u03b9\u03ba\u03ac" },
            { "sw_CD", "\u039a\u03bf\u03bd\u03b3\u03ba\u03cc \u03a3\u03bf\u03c5\u03b1\u03c7\u03af\u03bb\u03b9" },
            { "034", "\u039d\u03cc\u03c4\u03b9\u03b1 \u0391\u03c3\u03af\u03b1" },
            { "hai", "\u03a7\u03ac\u03b9\u03bd\u03c4\u03b1" },
            { "035", "\u039d\u03bf\u03c4\u03b9\u03bf\u03b1\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u0391\u03c3\u03af\u03b1" },
            { "UG", "\u039f\u03c5\u03b3\u03ba\u03ac\u03bd\u03c4\u03b1" },
            { "type.co.pinyin", "\u03a3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2 \u03a0\u03b9\u03bd\u03b3\u03af\u03bd" },
            { "039", "\u039d\u03cc\u03c4\u03b9\u03b1 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7" },
            { "Sinh", "\u03a3\u03b9\u03bd\u03c7\u03ac\u03bb\u03b1" },
            { "UM", "\u0391\u03c0\u03bf\u03bc\u03b1\u03ba\u03c1\u03c5\u03c3\u03bc\u03ad\u03bd\u03b5\u03c2 \u039d\u03b7\u03c3\u03af\u03b4\u03b5\u03c2 \u0397\u03a0\u0391" },
            { "UN", "\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03b1 \u0388\u03b8\u03bd\u03b7" },
            { "US", "\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03b5\u03c2 \u03a0\u03bf\u03bb\u03b9\u03c4\u03b5\u03af\u03b5\u03c2" },
            { "haw", "\u03a7\u03b1\u03b2\u03b1\u03ca\u03ba\u03ac" },
            { "%%1959ACAD", "\u0391\u03ba\u03b1\u03b4\u03b7\u03bc\u03b1\u03ca\u03ba\u03ac" },
            { "type.co.gb2312han", "\u03a3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2 \u0391\u03c0\u03bb\u03bf\u03c5\u03c3\u03c4\u03b5\u03c5\u03bc\u03ad\u03bd\u03c9\u03bd \u039a\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ce\u03bd - GB2312" },
            { "UY", "\u039f\u03c5\u03c1\u03bf\u03c5\u03b3\u03bf\u03c5\u03ac\u03b7" },
            { "prg", "\u03a0\u03c1\u03c9\u03c3\u03b9\u03ba\u03ac" },
            { "UZ", "\u039f\u03c5\u03b6\u03bc\u03c0\u03b5\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "tzm", "\u03a4\u03b1\u03bc\u03b1\u03b6\u03af\u03c4 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03bf\u03cd \u039c\u03b1\u03c1\u03cc\u03ba\u03bf" },
            { "type.co.stroke", "\u03a3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2 \u03ba\u03b9\u03bd\u03ae\u03c3\u03b5\u03c9\u03bd" },
            { "nnh", "\u039d\u03b3\u03ba\u03b9\u03b5\u03bc\u03c0\u03bf\u03cd\u03bd" },
            { "VA", "\u0392\u03b1\u03c4\u03b9\u03ba\u03b1\u03bd\u03cc" },
            { "pro", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03ac \u03a0\u03c1\u03bf\u03b2\u03b1\u03bd\u03c3\u03ac\u03bb" },
            { "VC", "\u0386\u03b3\u03b9\u03bf\u03c2 \u0392\u03b9\u03ba\u03ad\u03bd\u03c4\u03b9\u03bf\u03c2 \u03ba\u03b1\u03b9 \u0393\u03c1\u03b5\u03bd\u03b1\u03b4\u03af\u03bd\u03b5\u03c2" },
            { "VE", "\u0392\u03b5\u03bd\u03b5\u03b6\u03bf\u03c5\u03ad\u03bb\u03b1" },
            { "VG", "\u0392\u03c1\u03b5\u03c4\u03b1\u03bd\u03b9\u03ba\u03ad\u03c2 \u03a0\u03b1\u03c1\u03b8\u03ad\u03bd\u03b5\u03c2 \u039d\u03ae\u03c3\u03bf\u03b9" },
            { "VI", "\u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03ad\u03c2 \u03a0\u03b1\u03c1\u03b8\u03ad\u03bd\u03b5\u03c2 \u039d\u03ae\u03c3\u03bf\u03b9" },
            { "VN", "\u0392\u03b9\u03b5\u03c4\u03bd\u03ac\u03bc" },
            { "VU", "\u0392\u03b1\u03bd\u03bf\u03c5\u03ac\u03c4\u03bf\u03c5" },
            { "nog", "\u039d\u03bf\u03b3\u03ba\u03ac\u03b9" },
            { "rwk", "\u03a1\u03bf\u03c5\u03ac" },
            { "non", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03ac \u039d\u03bf\u03c1\u03b2\u03b7\u03b3\u03b9\u03ba\u03ac" },
            { "053", "\u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03b1\u03c3\u03af\u03b1" },
            { "%%AREVMDA", "\u0394\u03c5\u03c4\u03b9\u03ba\u03ac \u0391\u03c1\u03bc\u03b5\u03bd\u03b9\u03ba\u03ac" },
            { "054", "\u039c\u03b5\u03bb\u03b1\u03bd\u03b7\u03c3\u03af\u03b1" },
            { "WF", "\u039f\u03c5\u03ac\u03bb\u03b9\u03c2 \u03ba\u03b1\u03b9 \u03a6\u03bf\u03c5\u03c4\u03bf\u03cd\u03bd\u03b1" },
            { "type.co.traditional", "\u03a0\u03b1\u03c1\u03b1\u03b4\u03bf\u03c3\u03b9\u03b1\u03ba\u03ae \u03c3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2" },
            { "057", "\u03a0\u03b5\u03c1\u03b9\u03bf\u03c7\u03ae \u039c\u03b9\u03ba\u03c1\u03bf\u03bd\u03b7\u03c3\u03af\u03b1\u03c2" },
            { "jgo", "\u039d\u03b3\u03ba\u03cc\u03bc\u03c0\u03b1" },
            { "lkt", "\u039b\u03b1\u03ba\u03cc\u03c4\u03b1" },
            { "type.nu.finance", "\u039f\u03b9\u03ba\u03bf\u03bd\u03bf\u03bc\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "type.co.compat", "\u03a0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03b7 \u03c3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2, \u03b3\u03b9\u03b1 \u03c3\u03c5\u03bc\u03b2\u03b1\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1" },
            { "wae", "\u0392\u03ac\u03bb\u03c3\u03b5\u03c1" },
            { "WS", "\u03a3\u03b1\u03bc\u03cc\u03b1" },
            { "wal", "\u0393\u03bf\u03c5\u03bf\u03bb\u03ac\u03b9\u03c4\u03b1" },
            { "was", "\u0393\u03bf\u03c5\u03b1\u03c3\u03cc" },
            { "war", "\u0393\u03bf\u03c5\u03ac\u03c1\u03b1\u03ca" },
            { "awa", "\u0391\u03b3\u03bf\u03c5\u03b1\u03bd\u03c4\u03af" },
            { "061", "\u03a0\u03bf\u03bb\u03c5\u03bd\u03b7\u03c3\u03af\u03b1" },
            { "XK", "\u039a\u03bf\u03c3\u03c3\u03c5\u03c6\u03bf\u03c0\u03ad\u03b4\u03b9\u03bf" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0386\u03b3\u03c1\u03b1\u03c6\u03bf" },
            { "Olck", "\u039f\u03bb \u03a4\u03c3\u03af\u03ba\u03b9" },
            { "wbp", "\u0393\u03bf\u03c5\u03b1\u03c1\u03bb\u03c0\u03af\u03c1\u03b9" },
            { "Batk", "\u039c\u03c0\u03b1\u03c4\u03ac\u03ba" },
            { "Blis", metaValue_zbl },
            { "YE", "\u03a5\u03b5\u03bc\u03ad\u03bd\u03b7" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u03a4\u03c5\u03c0\u03b9\u03ba\u03ae \u03c3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2" },
            { "fan", "\u03a6\u03b1\u03bd\u03b3\u03ba" },
            { "%%ROZAJ", "\u03a1\u03b5\u03c3\u03b9\u03ac\u03bd" },
            { "fat", "\u03a6\u03ac\u03bd\u03c4\u03b9" },
            { "Sgnw", "\u039d\u03bf\u03b7\u03bc\u03b1\u03c4\u03b9\u03ba\u03ae \u03b3\u03c1\u03b1\u03c6\u03ae" },
            { "YT", "\u039c\u03b1\u03b3\u03b9\u03cc\u03c4" },
            { "ZA", "\u039d\u03cc\u03c4\u03b9\u03b1 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae" },
            { "type.lb.loose", "\u03a7\u03b1\u03bb\u03b1\u03c1\u03cc \u03c3\u03c4\u03b9\u03bb \u03b1\u03bb\u03bb\u03b1\u03b3\u03ae\u03c2 \u03b3\u03c1\u03b1\u03bc\u03bc\u03ce\u03bd" },
            { "Deva", "\u039d\u03c4\u03b5\u03b2\u03b1\u03bd\u03b1\u03b3\u03ba\u03ac\u03c1\u03b9" },
            { "type.nu.geor", "\u0393\u03b5\u03c9\u03c1\u03b3\u03b9\u03b1\u03bd\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "Hira", "\u03a7\u03b9\u03c1\u03b1\u03b3\u03ba\u03ac\u03bd\u03b1" },
            { "ZM", "\u0396\u03ac\u03bc\u03c0\u03b9\u03b1" },
            { "%%PINYIN", "\u0395\u03ba\u03bb\u03b1\u03c4\u03b9\u03bd\u03b9\u03c3\u03bc\u03ad\u03bd\u03b1 \u03a0\u03b9\u03bd\u03b3\u03af\u03bd" },
            { "ZW", "\u0396\u03b9\u03bc\u03c0\u03ac\u03bc\u03c0\u03bf\u03c5\u03b5" },
            { "ZZ", "\u0386\u03b3\u03bd\u03c9\u03c3\u03c4\u03b7 \u03c0\u03b5\u03c1\u03b9\u03bf\u03c7\u03ae" },
            { "Runr", "\u03a1\u03bf\u03c5\u03bd\u03af\u03ba" },
            { "type.ms.metric", "\u039c\u03b5\u03c4\u03c1\u03b9\u03ba\u03cc \u03c3\u03cd\u03c3\u03c4\u03b7\u03bc\u03b1" },
            { "type.ca.iso8601", "\u0397\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf ISO-8601" },
            { "lol", "\u039c\u03cc\u03bd\u03b3\u03ba\u03bf" },
            { "nso", "\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u03a3\u03cc\u03b8\u03bf" },
            { "type.nu.telu", "\u03a4\u03b5\u03bb\u03bf\u03c5\u03b3\u03ba\u03bf\u03c5\u03ca\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "lou", "\u039a\u03c1\u03b5\u03bf\u03bb\u03b9\u03ba\u03ac (\u039b\u03bf\u03c5\u03b9\u03b6\u03b9\u03ac\u03bd\u03b1)" },
            { "loz", "\u039b\u03cc\u03b6\u03b9" },
            { "jmc", "\u039c\u03b1\u03c4\u03c3\u03ac\u03bc\u03b5" },
            { "type.nu.hansfin", "\u0391\u03c0\u03bb\u03bf\u03c0\u03bf\u03b9\u03b7\u03bc\u03ad\u03bd\u03b1 \u03ba\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ac \u03bf\u03b9\u03ba\u03bf\u03bd\u03bf\u03bc\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "hil", "\u03a7\u03b9\u03bb\u03b9\u03b3\u03ba\u03b1\u03ca\u03bd\u03cc\u03bd" },
            { "type.nu.arabext", "\u0395\u03ba\u03c4\u03b5\u03c4\u03b1\u03bc\u03ad\u03bd\u03b1 \u03b1\u03c1\u03b1\u03b2\u03b9\u03ba\u03bf-\u03b9\u03bd\u03b4\u03b9\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "nus", "\u039d\u03bf\u03cd\u03b5\u03c1" },
            { "dak", "\u039d\u03c4\u03b1\u03ba\u03cc\u03c4\u03b1" },
            { "type.nu.fullwide", "\u03a8\u03b7\u03c6\u03af\u03b1 \u03c0\u03bb\u03ae\u03c1\u03bf\u03c5\u03c2 \u03c0\u03bb\u03ac\u03c4\u03bf\u03c5\u03c2" },
            { "hit", "\u03a7\u03b9\u03c4\u03af\u03c4\u03b5" },
            { "dar", "\u039d\u03c4\u03ac\u03c1\u03b3\u03ba\u03bf\u03c5\u03b1" },
            { "dav", "\u03a4\u03ac\u03b9\u03c4\u03b1" },
            { "Maya", "\u0399\u03b5\u03c1\u03bf\u03b3\u03bb\u03c5\u03c6\u03b9\u03ba\u03ac \u039c\u03ac\u03b3\u03b9\u03b1" },
            { "lrc", "\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u039b\u03bf\u03cd\u03c1\u03b9" },
            { "Copt", "\u039a\u03bf\u03c0\u03c4\u03b9\u03ba\u03cc" },
            { "nwc", "\u039a\u03bb\u03b1\u03c3\u03b9\u03ba\u03ac \u039d\u03b5\u03bf\u03c5\u03ac\u03c1\u03b9" },
            { "udm", "\u039f\u03c5\u03bd\u03c4\u03bc\u03bf\u03cd\u03c1\u03c4" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u0399\u03c3\u03bb\u03b1\u03bc\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf (\u03a3\u03b1\u03bf\u03c5\u03b4\u03b9\u03ba\u03ae \u0391\u03c1\u03b1\u03b2\u03af\u03b1, \u03b8\u03ad\u03b1\u03c3\u03b7)" },
            { "Limb", "\u039b\u03b9\u03bc\u03c0\u03bf\u03cd" },
            { "sad", "\u03a3\u03b1\u03bd\u03c4\u03ac\u03b3\u03bf\u03c5\u03b5" },
            { "type.nu.roman", "\u039b\u03b1\u03c4\u03b9\u03bd\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "sah", "\u03a3\u03b1\u03c7\u03ac" },
            { "sam", "\u03a3\u03b1\u03bc\u03b1\u03c1\u03af\u03c4\u03b9\u03ba\u03b1 \u0391\u03c1\u03b1\u03bc\u03b1\u03ca\u03ba\u03ac" },
            { "%%SCOUSE", "\u03a3\u03ba\u03bf\u03c5\u03b6" },
            { "saq", "\u03a3\u03b1\u03bc\u03c0\u03bf\u03cd\u03c1\u03bf\u03c5" },
            { "sas", "\u03a3\u03b1\u03c3\u03ac\u03ba" },
            { "sat", "\u03a3\u03b1\u03bd\u03c4\u03ac\u03bb\u03b9" },
            { "Tfng", "\u03a4\u03b9\u03c6\u03b9\u03bd\u03ac\u03b3\u03ba" },
            { "jpr", "\u0399\u03bf\u03c5\u03b4\u03b1\u03ca\u03ba\u03ac-\u03a0\u03b5\u03c1\u03c3\u03b9\u03ba\u03ac" },
            { "type.d0.npinyin", "\u0391\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03cc" },
            { "type.nu.native", "\u0395\u03b3\u03b3\u03b5\u03bd\u03ae \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "sba", "\u039d\u03b3\u03ba\u03b1\u03bc\u03c0\u03ad\u03b9" },
            { "Guru", "\u0393\u03ba\u03bf\u03c5\u03c1\u03bc\u03bf\u03c5\u03ba\u03c7\u03af" },
            { "lua", "\u039b\u03bf\u03cd\u03bc\u03c0\u03b1-\u039b\u03bf\u03c5\u03bb\u03bf\u03cd\u03b1" },
            { "type.d0.fwidth", "\u03a0\u03bb\u03ae\u03c1\u03bf\u03c5\u03c2 \u03c0\u03bb\u03ac\u03c4\u03bf\u03c5\u03c2" },
            { "sbp", "\u03a3\u03ac\u03bd\u03b3\u03ba\u03bf\u03c5" },
            { "lui", "\u039b\u03bf\u03c5\u03b9\u03c3\u03ad\u03bd\u03bf" },
            { "nyn", "\u039d\u03b9\u03b1\u03bd\u03ba\u03cc\u03bb\u03b5" },
            { "nym", "\u039d\u03b9\u03b1\u03bc\u03b3\u03bf\u03c5\u03ad\u03b6\u03b9" },
            { "lun", "\u039b\u03bf\u03cd\u03bd\u03c4\u03b1" },
            { "nyo", "\u039d\u03b9\u03cc\u03c1\u03bf" },
            { "luo", "\u039b\u03bf\u03cd\u03bf" },
            { "fil", "\u03a6\u03b9\u03bb\u03b9\u03c0\u03c0\u03b9\u03bd\u03b9\u03ba\u03ac" },
            { "hmn", "\u03a7\u03bc\u03bf\u03bd\u03b3\u03ba" },
            { "del", "\u039d\u03c4\u03ad\u03bb\u03b1\u03b3\u03bf\u03c5\u03b5\u03c1" },
            { "lus", "\u039c\u03af\u03b6\u03bf" },
            { "bal", "\u039c\u03c0\u03b1\u03bb\u03bf\u03cd\u03c4\u03c3\u03b9" },
            { "den", "\u03a3\u03bb\u03b1\u03b2\u03b9\u03ba\u03ac" },
            { "ban", metaValue_ban },
            { "uga", "\u039f\u03c5\u03b3\u03ba\u03b1\u03c1\u03b9\u03c4\u03b9\u03ba\u03ac" },
            { "luy", "\u039b\u03bf\u03c5\u03c7\u03af\u03b1" },
            { "bas", "\u039c\u03c0\u03ac\u03c3\u03b1" },
            { "bax", "\u039c\u03c0\u03b1\u03bc\u03bf\u03cd\u03bd" },
            { "jrb", "\u0399\u03bf\u03c5\u03b4\u03b1\u03ca\u03ba\u03ac-\u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ac" },
            { "es_ES", "\u0399\u03c3\u03c0\u03b1\u03bd\u03b9\u03ba\u03ac \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2" },
            { "nzi", "\u039d\u03b6\u03af\u03bc\u03b1" },
            { "sco", "\u03a3\u03ba\u03c9\u03c4\u03b9\u03ba\u03ac" },
            { "scn", "\u03a3\u03b9\u03ba\u03b5\u03bb\u03b9\u03ba\u03ac" },
            { "aa", "\u0391\u03c6\u03ac\u03c1" },
            { "ab", "\u0391\u03bc\u03c0\u03c7\u03b1\u03b6\u03b9\u03ba\u03ac" },
            { "ae", metaValue_ae },
            { "af", "\u0391\u03c6\u03c1\u03b9\u03ba\u03ac\u03b1\u03bd\u03c2" },
            { "ak", "\u0391\u03ba\u03ac\u03bd" },
            { "bbj", "\u0393\u03ba\u03bf\u03bc\u03ac\u03bb\u03b1" },
            { "am", "\u0391\u03bc\u03c7\u03b1\u03c1\u03b9\u03ba\u03ac" },
            { "an", "\u0391\u03c1\u03b1\u03b3\u03bf\u03bd\u03b9\u03ba\u03ac" },
            { "Arab", "\u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03cc" },
            { "%%SOLBA", "\u0394\u03b9\u03ac\u03bb\u03b5\u03ba\u03c4\u03bf\u03c2 \u03a3\u03c4\u03bf\u03bb\u03b2\u03b9\u03c4\u03b6\u03ac/\u03a3\u03bf\u03bb\u03bc\u03c0\u03b9\u03ba\u03ac" },
            { "Jpan", "\u0399\u03b1\u03c0\u03c9\u03bd\u03b9\u03ba\u03cc" },
            { "ar", "\u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ac" },
            { "Hrkt", "\u039a\u03b1\u03c4\u03b1\u03ba\u03ac\u03bd\u03b1 \u03ae \u03a7\u03b9\u03c1\u03b1\u03b3\u03ba\u03ac\u03bd\u03b1" },
            { "as", "\u0391\u03c3\u03b1\u03bc\u03b9\u03ba\u03ac" },
            { "Lina", "\u0393\u03c1\u03b1\u03bc\u03bc\u03b9\u03ba\u03cc \u0391" },
            { "av", "\u0391\u03b2\u03b1\u03c1\u03b9\u03ba\u03ac" },
            { "Linb", "\u0393\u03c1\u03b1\u03bc\u03bc\u03b9\u03ba\u03cc \u0392" },
            { "sdh", "\u039d\u03cc\u03c4\u03b9\u03b1 \u039a\u03bf\u03c5\u03c1\u03b4\u03b9\u03ba\u03ac" },
            { "ay", "\u0391\u03ca\u03bc\u03ac\u03c1\u03b1" },
            { "az", "\u0391\u03b6\u03b5\u03c1\u03bc\u03c0\u03b1\u03ca\u03c4\u03b6\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "%%OSOJS", "\u0394\u03b9\u03ac\u03bb\u03b5\u03ba\u03c4\u03bf\u03c2 \u039f\u03c3\u03b5\u03b1\u03ba\u03cc/\u039f\u03c3\u03bf\u03c4\u03b6\u03ac\u03bd" },
            { "ba", "\u039c\u03c0\u03b1\u03c3\u03ba\u03af\u03c1" },
            { "type.co.unihan", "\u03a3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2 \u03c1\u03b9\u03b6\u03b9\u03ba\u03ae\u03c2 \u03b1\u03c1\u03af\u03b8\u03bc\u03b7\u03c3\u03b7\u03c2" },
            { "be", "\u039b\u03b5\u03c5\u03ba\u03bf\u03c1\u03c9\u03c3\u03b9\u03ba\u03ac" },
            { "bg", "\u0392\u03bf\u03c5\u03bb\u03b3\u03b1\u03c1\u03b9\u03ba\u03ac" },
            { "bi", "\u039c\u03c0\u03b9\u03c3\u03bb\u03ac\u03bc\u03b1" },
            { "bm", "\u039c\u03c0\u03b1\u03bc\u03c0\u03ac\u03c1\u03b1" },
            { "bn", "\u0392\u03b5\u03b3\u03b3\u03b1\u03bb\u03b9\u03ba\u03ac" },
            { "bo", "\u0398\u03b9\u03b2\u03b5\u03c4\u03b9\u03b1\u03bd\u03ac" },
            { "dgr", "\u039d\u03c4\u03cc\u03b3\u03ba\u03c1\u03b9\u03bc\u03c0" },
            { "br", "\u0392\u03c1\u03b5\u03c4\u03bf\u03bd\u03b9\u03ba\u03ac" },
            { "bs", "\u0392\u03bf\u03c3\u03bd\u03b9\u03b1\u03ba\u03ac" },
            { "see", "\u03a3\u03ad\u03bd\u03b5\u03ba\u03b1" },
            { "Mymr", "\u039c\u03b9\u03b1\u03bd\u03bc\u03ac\u03c1" },
            { "type.nu.laoo", "\u039b\u03b1\u03bf\u03ca\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "seh", "\u03a3\u03ad\u03bd\u03b1" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u03a3\u03b5\u03bb\u03ba\u03bf\u03cd\u03c0" },
            { "ca", "\u039a\u03b1\u03c4\u03b1\u03bb\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "ses", "\u039a\u03bf\u03ca\u03c1\u03b1\u03bc\u03c0\u03cc\u03c1\u03bf \u03a3\u03ad\u03bd\u03b9" },
            { "ce", "\u03a4\u03c3\u03b5\u03c4\u03c3\u03b5\u03bd\u03b9\u03ba\u03ac" },
            { "ch", "\u03a4\u03c3\u03b1\u03bc\u03cc\u03c1\u03bf" },
            { "%%REVISED", "\u0391\u03bd\u03b1\u03b8\u03b5\u03c9\u03c1\u03b7\u03bc\u03ad\u03bd\u03b7 \u03bf\u03c1\u03b8\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b1" },
            { "co", "\u039a\u03bf\u03c1\u03c3\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "Orya", metaValue_or },
            { "cr", "\u039a\u03c1\u03b9" },
            { "cs", "\u03a4\u03c3\u03b5\u03c7\u03b9\u03ba\u03ac" },
            { "cu", "\u0395\u03ba\u03ba\u03bb\u03b7\u03c3\u03b9\u03b1\u03c3\u03c4\u03b9\u03ba\u03ac \u03a3\u03bb\u03b1\u03b2\u03b9\u03ba\u03ac" },
            { "cv", "\u03a4\u03c3\u03bf\u03c5\u03b2\u03b1\u03c3\u03b9\u03ba\u03ac" },
            { "cy", "\u039f\u03c5\u03b1\u03bb\u03b9\u03ba\u03ac" },
            { "type.nu.ethi", "\u0391\u03b9\u03b8\u03b9\u03bf\u03c0\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "Yiii", "\u0393\u03b9" },
            { "da", "\u0394\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "pt_PT", "\u03a0\u03bf\u03c1\u03c4\u03bf\u03b3\u03b1\u03bb\u03b9\u03ba\u03ac \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2" },
            { "de", "\u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "type.cf.standard", "\u03a4\u03c5\u03c0\u03b9\u03ba\u03ae \u03bc\u03bf\u03c1\u03c6\u03ae \u03bd\u03bf\u03bc\u03af\u03c3\u03bc\u03b1\u03c4\u03bf\u03c2" },
            { "bej", "\u039c\u03c0\u03ad\u03b6\u03b1" },
            { "din", "\u039d\u03c4\u03af\u03bd\u03ba\u03b1" },
            { "Bugi", "\u039c\u03c0\u03bf\u03cd\u03b3\u03ba\u03b9\u03c2" },
            { "bem", "\u039c\u03c0\u03ad\u03bc\u03c0\u03b1" },
            { "sga", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03ac \u0399\u03c1\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ac" },
            { "type.nu.mong", "\u039c\u03bf\u03b3\u03b3\u03bf\u03bb\u03b9\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "dv", "\u039d\u03c4\u03b9\u03b2\u03ad\u03c7\u03b9" },
            { "es_419", "\u0399\u03c3\u03c0\u03b1\u03bd\u03b9\u03ba\u03ac \u039b\u03b1\u03c4\u03b9\u03bd\u03b9\u03ba\u03ae\u03c2 \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae\u03c2" },
            { "dz", "\u039d\u03c4\u03b6\u03cc\u03bd\u03b3\u03ba\u03c7\u03b1" },
            { "bez", "\u039c\u03c0\u03ad\u03bd\u03b1" },
            { "type.ca.chinese", "\u039a\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "dje", "\u0396\u03ac\u03c1\u03bc\u03b1" },
            { "type.nu.grek", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "ee", "\u0388\u03bf\u03c5\u03b5" },
            { "bfd", "\u039c\u03c0\u03b1\u03c6\u03bf\u03cd\u03c4" },
            { "type.lb.normal", "\u039a\u03b1\u03bd\u03bf\u03bd\u03b9\u03ba\u03cc \u03c3\u03c4\u03b9\u03bb \u03b1\u03bb\u03bb\u03b1\u03b3\u03ae\u03c2 \u03b3\u03c1\u03b1\u03bc\u03bc\u03ce\u03bd" },
            { "ro_MD", "\u039c\u03bf\u03bb\u03b4\u03b1\u03b2\u03b9\u03ba\u03ac" },
            { "el", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac" },
            { "en", "\u0391\u03b3\u03b3\u03bb\u03b9\u03ba\u03ac" },
            { "eo", "\u0395\u03c3\u03c0\u03b5\u03c1\u03ac\u03bd\u03c4\u03bf" },
            { "type.co.big5han", "\u03a3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2 \u03a0\u03b1\u03c1\u03b1\u03b4\u03bf\u03c3\u03b9\u03b1\u03ba\u03ce\u03bd \u039a\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ce\u03bd - Big5" },
            { "es", "\u0399\u03c3\u03c0\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "et", "\u0395\u03c3\u03b8\u03bf\u03bd\u03b9\u03ba\u03ac" },
            { "Hanb", "\u03a7\u03b1\u03bd\u03bc\u03c0" },
            { "eu", "\u0392\u03b1\u03c3\u03ba\u03b9\u03ba\u03ac" },
            { "Buhd", "\u039c\u03c0\u03bf\u03c5\u03c7\u03af\u03bd\u03c4" },
            { "Hang", "\u03a7\u03b1\u03bd\u03b3\u03ba\u03bf\u03cd\u03bb" },
            { "Samr", "\u03a3\u03b1\u03bc\u03b1\u03c1\u03b9\u03c4\u03b9\u03ba\u03cc" },
            { "shi", "\u03a4\u03b1\u03c3\u03b5\u03bb\u03c7\u03af\u03c4" },
            { "hsb", "\u0386\u03bd\u03c9 \u03a3\u03bf\u03c1\u03b2\u03b9\u03ba\u03ac" },
            { "Hani", "\u03a7\u03b1\u03bd" },
            { "shn", "\u03a3\u03b1\u03bd" },
            { "Hano", "\u03a7\u03b1\u03bd\u03bf\u03cd\u03bd\u03bf\u03c5" },
            { "fa", "\u03a0\u03b5\u03c1\u03c3\u03b9\u03ba\u03ac" },
            { "Hans", "\u0391\u03c0\u03bb\u03bf\u03c0\u03bf\u03b9\u03b7\u03bc\u03ad\u03bd\u03bf" },
            { "type.nu.latn", "\u03a8\u03b7\u03c6\u03af\u03b1 \u03c4\u03b7\u03c2 \u0394\u03cd\u03c3\u03b7\u03c2" },
            { "Hant", "\u03a0\u03b1\u03c1\u03b1\u03b4\u03bf\u03c3\u03b9\u03b1\u03ba\u03cc" },
            { "ff", "\u03a6\u03bf\u03c5\u03bb\u03ac" },
            { "shu", "\u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ac \u03c4\u03bf\u03c5 \u03a4\u03c3\u03b1\u03bd\u03c4" },
            { "fi", "\u03a6\u03b9\u03bd\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ac" },
            { "fj", metaValue_FJ },
            { "fon", "\u03a6\u03bf\u03bd" },
            { "bgn", "\u0394\u03c5\u03c4\u03b9\u03ba\u03ac \u039c\u03c0\u03b1\u03bb\u03bf\u03c7\u03b9\u03ba\u03ac" },
            { "yue", "\u039a\u03b1\u03bd\u03c4\u03bf\u03bd\u03ad\u03b6\u03b9\u03ba\u03b1" },
            { "fo", "\u03a6\u03b5\u03c1\u03bf\u03ca\u03ba\u03ac" },
            { "type.m0.bgn", "\u039c\u03b5\u03c4\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae BGN \u0397\u03a0\u0391" },
            { "umb", "\u039f\u03c5\u03bc\u03c0\u03bf\u03cd\u03bd\u03c4\u03bf\u03c5" },
            { "fr", "\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ac" },
            { "sid", "\u03a3\u03b9\u03bd\u03c4\u03ac\u03bc\u03bf" },
            { "fy", "\u0394\u03c5\u03c4\u03b9\u03ba\u03ac \u03a6\u03c1\u03b9\u03b6\u03b9\u03ba\u03ac" },
            { "ga", "\u0399\u03c1\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ac" },
            { "gd", "\u03a3\u03ba\u03c9\u03c4\u03b9\u03ba\u03ac \u039a\u03b5\u03bb\u03c4\u03b9\u03ba\u03ac" },
            { "gl", "\u0393\u03b1\u03bb\u03b9\u03ba\u03b9\u03b1\u03bd\u03ac" },
            { "gn", "\u0393\u03ba\u03bf\u03c5\u03b1\u03c1\u03b1\u03bd\u03af" },
            { "bho", "\u039c\u03c0\u03bf\u03b6\u03c0\u03bf\u03cd\u03c1\u03b9" },
            { "und", "\u0386\u03b3\u03bd\u03c9\u03c3\u03c4\u03b7 \u03b3\u03bb\u03ce\u03c3\u03c3\u03b1" },
            { "type.ca.ethiopic-amete-alem", "\u0391\u03b9\u03b8\u03b9\u03bf\u03c0\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf \u0386\u03bc\u03b5\u03c4 \u0386\u03bb\u03b5\u03bc" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0399\u03c3\u03bb\u03b1\u03bc\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf (\u03b4\u03bf\u03bc\u03b7\u03bc\u03ad\u03bd\u03bf, \u03b1\u03c3\u03c4\u03c1\u03bf\u03bd\u03bf\u03bc\u03b9\u03ba\u03ae \u03b5\u03c0\u03bf\u03c7\u03ae)" },
            { "gv", "\u039c\u03b1\u03bd\u03be" },
            { "ha", "\u03a7\u03ac\u03bf\u03c5\u03c3\u03b1" },
            { "he", "\u0395\u03b2\u03c1\u03b1\u03ca\u03ba\u03ac" },
            { "hi", "\u03a7\u03af\u03bd\u03c4\u03b9" },
            { "hup", "\u03a7\u03bf\u03cd\u03c0\u03b1" },
            { "bik", "\u039c\u03c0\u03b9\u03ba\u03cc\u03bb" },
            { "bin", "\u039c\u03c0\u03af\u03bd\u03b9" },
            { "ho", "\u03a7\u03af\u03c1\u03b9 \u039c\u03cc\u03c4\u03bf\u03c5" },
            { "hr", "\u039a\u03c1\u03bf\u03b1\u03c4\u03b9\u03ba\u03ac" },
            { "ht", "\u0391\u03ca\u03c4\u03b9\u03b1\u03bd\u03ac" },
            { "hu", "\u039f\u03c5\u03b3\u03b3\u03c1\u03b9\u03ba\u03ac" },
            { "hy", "\u0391\u03c1\u03bc\u03b5\u03bd\u03b9\u03ba\u03ac" },
            { "hz", "\u03a7\u03b5\u03c1\u03ad\u03c1\u03bf" },
            { "frc", "\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ac (\u039b\u03bf\u03c5\u03b9\u03b6\u03b9\u03ac\u03bd\u03b1)" },
            { "%%FONIPA", "\u0394\u03b9\u03b5\u03b8\u03bd\u03ae\u03c2 \u03c6\u03c9\u03bd\u03b7\u03c4\u03b9\u03ba\u03ae \u03b1\u03bb\u03c6\u03ac\u03b2\u03b7\u03c4\u03bf\u03c2" },
            { "ia", "\u0399\u03bd\u03c4\u03b5\u03c1\u03bb\u03af\u03bd\u03b3\u03ba\u03bf\u03c5\u03b1" },
            { "Jamo", "\u03a4\u03b6\u03ac\u03bc\u03bf" },
            { "id", "\u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03b9\u03b1\u03ba\u03ac" },
            { "type.nu.tibt", "\u0398\u03b9\u03b2\u03b5\u03c4\u03b1\u03bd\u03b9\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "ie", "\u0399\u03bd\u03c4\u03b5\u03c1\u03bb\u03af\u03bd\u03b3\u03ba\u03bf\u03c5\u03b5" },
            { "ig", "\u038a\u03b3\u03ba\u03bc\u03c0\u03bf" },
            { "ii", "\u03a3\u03af\u03c4\u03c3\u03bf\u03c5\u03b1\u03bd \u0393\u03b9" },
            { "frm", "\u039c\u03ad\u03c3\u03b1 \u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ac" },
            { "ik", "\u0399\u03bd\u03bf\u03c5\u03c0\u03b9\u03ac\u03ba" },
            { "fro", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03ac \u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ac" },
            { "io", "\u038a\u03bd\u03c4\u03bf" },
            { "frs", "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ac \u03a6\u03c1\u03b9\u03b6\u03b9\u03b1\u03bd\u03ac" },
            { "frr", "\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u03a6\u03c1\u03b9\u03b6\u03b9\u03b1\u03bd\u03ac" },
            { "is", "\u0399\u03c3\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ac" },
            { "it", "\u0399\u03c4\u03b1\u03bb\u03b9\u03ba\u03ac" },
            { "iu", "\u0399\u03bd\u03bf\u03cd\u03ba\u03c4\u03b9\u03c4\u03bf\u03c5\u03c4" },
            { "ja", "\u0399\u03b1\u03c0\u03c9\u03bd\u03b9\u03ba\u03ac" },
            { "Mlym", "\u039c\u03b1\u03bb\u03b1\u03b3\u03b9\u03ac\u03bb\u03b1\u03bc" },
            { "Sara", "\u03a3\u03b1\u03c1\u03ac\u03b8\u03b9" },
            { "doi", "\u039d\u03c4\u03cc\u03b3\u03ba\u03c1\u03b9" },
            { "bkm", "\u039a\u03bf\u03bc" },
            { "sma", "\u039d\u03cc\u03c4\u03b9\u03b1 \u03a3\u03ac\u03bc\u03b9" },
            { "jv", "\u0399\u03b1\u03b2\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "Shaw", "\u03a3\u03b1\u03b2\u03b9\u03b1\u03bd\u03cc" },
            { "mad", "\u039c\u03b1\u03bd\u03c4\u03bf\u03c5\u03c1\u03af\u03b6" },
            { "smj", "\u039b\u03bf\u03cd\u03bb\u03b5 \u03a3\u03ac\u03bc\u03b9" },
            { "mag", "\u039c\u03b1\u03b3\u03ba\u03ac\u03c7\u03b9" },
            { "maf", "\u039c\u03ac\u03c6\u03b1" },
            { "mai", "\u039c\u03b1\u03ca\u03c4\u03c7\u03af\u03bb\u03b9" },
            { "smn", "\u0399\u03bd\u03ac\u03c1\u03b9 \u03a3\u03ac\u03bc\u03b9" },
            { "ka", "\u0393\u03b5\u03c9\u03c1\u03b3\u03b9\u03b1\u03bd\u03ac" },
            { "bla", "\u03a3\u03b9\u03ba\u03c3\u03af\u03ba\u03b1" },
            { "mak", "\u039c\u03b1\u03ba\u03b1\u03c3\u03ac\u03c1" },
            { "wuu", "\u039a\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ac \u0393\u03bf\u03c5" },
            { "sms", "\u03a3\u03ba\u03bf\u03bb\u03c4 \u03a3\u03ac\u03bc\u03b9" },
            { "man", "\u039c\u03b1\u03bd\u03c4\u03af\u03bd\u03b3\u03ba\u03bf" },
            { "kg", "\u039a\u03bf\u03bd\u03b3\u03ba\u03cc" },
            { "Goth", "\u0393\u03bf\u03c4\u03b8\u03b9\u03ba\u03cc" },
            { "ki", "\u039a\u03b9\u03ba\u03bf\u03cd\u03b3\u03b9\u03bf\u03c5" },
            { "mas", "\u039c\u03b1\u03c3\u03ac\u03b9" },
            { "kj", "\u039a\u03bf\u03c5\u03b1\u03bd\u03b9\u03ac\u03bc\u03b1" },
            { "kk", "\u039a\u03b1\u03b6\u03b1\u03ba\u03b9\u03ba\u03ac" },
            { "kl", "\u039a\u03b1\u03bb\u03b1\u03ac\u03bb\u03b9\u03c3\u03bf\u03c5\u03c4" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "\u039a\u03bf\u03c1\u03b5\u03b1\u03c4\u03b9\u03ba\u03ac" },
            { "kr", "\u039a\u03b1\u03bd\u03bf\u03cd\u03c1\u03b9" },
            { "ks", "\u039a\u03b1\u03c3\u03bc\u03b9\u03c1\u03b9\u03ba\u03ac" },
            { "Cirt", "\u03a3\u03b5\u03c1\u03b8" },
            { "Lepc", "\u039b\u03ad\u03c0\u03c4\u03c3\u03b1" },
            { "Avst", metaValue_ae },
            { "ku", "\u039a\u03bf\u03c5\u03c1\u03b4\u03b9\u03ba\u03ac" },
            { "kv", "\u039a\u03cc\u03bc\u03b9" },
            { "kw", "\u039a\u03bf\u03c1\u03bd\u03bf\u03c5\u03b1\u03bb\u03b9\u03ba\u03ac" },
            { "ky", "\u039a\u03b9\u03c1\u03b3\u03b9\u03b6\u03b9\u03ba\u03ac" },
            { "snk", "\u03a3\u03bf\u03bd\u03af\u03bd\u03ba\u03b5" },
            { "la", "\u039b\u03b1\u03c4\u03b9\u03bd\u03b9\u03ba\u03ac" },
            { "lb", "\u039b\u03bf\u03c5\u03be\u03b5\u03bc\u03b2\u03bf\u03c5\u03c1\u03b3\u03b9\u03b1\u03bd\u03ac" },
            { "type.nu.mlym", "\u039c\u03b1\u03bb\u03b1\u03b3\u03b9\u03b1\u03bb\u03b1\u03bc\u03b9\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "lg", "\u0393\u03ba\u03ac\u03bd\u03c4\u03b1" },
            { "Roro", "\u03a1\u03bf\u03bd\u03b3\u03ba\u03bf\u03c1\u03cc\u03bd\u03b3\u03ba\u03bf" },
            { "li", "\u039b\u03b9\u03bc\u03b2\u03bf\u03c5\u03c1\u03b3\u03b9\u03b1\u03bd\u03ac" },
            { "Tibt", "\u0398\u03b9\u03b2\u03b5\u03c4\u03b9\u03b1\u03bd\u03cc" },
            { "ln", "\u039b\u03b9\u03bd\u03b3\u03ba\u03ac\u03bb\u03b1" },
            { "fur", "\u03a6\u03c1\u03b9\u03bf\u03c5\u03bb\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "lo", "\u039b\u03b1\u03bf\u03c4\u03b9\u03bd\u03ac" },
            { "type.ms.uksystem", "\u0391\u03b3\u03b3\u03bb\u03bf\u03c3\u03b1\u03be\u03bf\u03bd\u03b9\u03ba\u03cc \u03c3\u03cd\u03c3\u03c4\u03b7\u03bc\u03b1 \u03bc\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7\u03c2" },
            { "lt", "\u039b\u03b9\u03b8\u03bf\u03c5\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "lu", "\u039b\u03bf\u03cd\u03bc\u03c0\u03b1-\u039a\u03b1\u03c4\u03ac\u03bd\u03b3\u03ba\u03b1" },
            { "lv", "\u039b\u03b5\u03c4\u03bf\u03bd\u03b9\u03ba\u03ac" },
            { "sog", "\u03a3\u03bf\u03b3\u03ba\u03bd\u03c4\u03b9\u03ad\u03bd" },
            { "mg", "\u039c\u03b1\u03bb\u03b3\u03b1\u03c3\u03b9\u03ba\u03ac" },
            { "mh", "\u039c\u03b1\u03c1\u03c3\u03b1\u03bb\u03ad\u03b6\u03b9\u03ba\u03b1" },
            { "type.co.ducet", "\u03a0\u03c1\u03bf\u03b5\u03c0\u03b9\u03bb\u03b5\u03b3\u03bc\u03ad\u03bd\u03b7 \u03c3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2 Unicode" },
            { "mi", "\u039c\u03b1\u03bf\u03c1\u03af" },
            { "mk", "\u03a3\u03bb\u03b1\u03b2\u03bf\u03bc\u03b1\u03ba\u03b5\u03b4\u03bf\u03bd\u03b9\u03ba\u03ac" },
            { "ml", "\u039c\u03b1\u03bb\u03b1\u03b3\u03b9\u03b1\u03bb\u03b1\u03bc\u03b9\u03ba\u03ac" },
            { "mn", "\u039c\u03bf\u03b3\u03b3\u03bf\u03bb\u03b9\u03ba\u03ac" },
            { "mr", "\u039c\u03b1\u03c1\u03b1\u03b8\u03b9\u03ba\u03ac" },
            { "ms", "\u039c\u03b1\u03bb\u03b1\u03b9\u03c3\u03b9\u03b1\u03bd\u03ac" },
            { "mt", "\u039c\u03b1\u03bb\u03c4\u03b5\u03b6\u03b9\u03ba\u03ac" },
            { "my", "\u0392\u03b9\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "Saur", "\u03a3\u03b1\u03bf\u03c5\u03c1\u03ac\u03c3\u03c4\u03c1\u03b1" },
            { "Armn", "\u0391\u03c1\u03bc\u03b5\u03bd\u03b9\u03ba\u03cc" },
            { "mdf", "\u039c\u03cc\u03ba\u03c3\u03b1" },
            { "mde", "\u039c\u03ac\u03bc\u03c0\u03b1" },
            { "dsb", "\u039a\u03ac\u03c4\u03c9 \u03a3\u03bf\u03c1\u03b2\u03b9\u03ba\u03ac" },
            { "Armi", "\u0391\u03c5\u03c4\u03bf\u03ba\u03c1\u03b1\u03c4\u03bf\u03c1\u03b9\u03ba\u03cc \u0391\u03c1\u03b1\u03bc\u03b1\u03ca\u03ba\u03cc" },
            { "na", "\u039d\u03b1\u03bf\u03cd\u03c1\u03bf\u03c5" },
            { "type.co.search", "\u0391\u03bd\u03b1\u03b6\u03ae\u03c4\u03b7\u03c3\u03b7 \u03b3\u03b5\u03bd\u03b9\u03ba\u03bf\u03cd \u03c4\u03cd\u03c0\u03bf\u03c5" },
            { "nb", "\u039d\u03bf\u03c1\u03b2\u03b7\u03b3\u03b9\u03ba\u03ac \u039c\u03c0\u03bf\u03ba\u03bc\u03ac\u03bb" },
            { "nd", "\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u039d\u03c4\u03b5\u03bc\u03c0\u03ad\u03bb\u03b5" },
            { "ne", "\u039d\u03b5\u03c0\u03b1\u03bb\u03b9\u03ba\u03ac" },
            { "ng", "\u039d\u03c4\u03cc\u03bd\u03b3\u03ba\u03b1" },
            { "mdr", "\u039c\u03b1\u03bd\u03b4\u03ac\u03c1" },
            { "nl", "\u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ac" },
            { "nn", "\u039d\u03bf\u03c1\u03b2\u03b7\u03b3\u03b9\u03ba\u03ac \u039d\u03b9\u03bd\u03cc\u03c1\u03c3\u03ba" },
            { "no", "\u039d\u03bf\u03c1\u03b2\u03b7\u03b3\u03b9\u03ba\u03ac" },
            { "nr", "\u039d\u03cc\u03c4\u03b9\u03b1 \u039d\u03c4\u03b5\u03bc\u03c0\u03ad\u03bb\u03b5" },
            { "nv", "\u039d\u03ac\u03b2\u03b1\u03c7\u03bf" },
            { "kaa", "\u039a\u03ac\u03c1\u03b1-\u039a\u03b1\u03bb\u03c0\u03ac\u03ba" },
            { "ny", "\u039d\u03b9\u03ac\u03bd\u03c4\u03b6\u03b1" },
            { "kac", "\u039a\u03b1\u03c4\u03c3\u03af\u03bd" },
            { "kab", "\u039a\u03b1\u03bc\u03c0\u03af\u03bb\u03b5" },
            { "%%POLYTON", "\u03a0\u03bf\u03bb\u03c5\u03c4\u03bf\u03bd\u03b9\u03ba\u03cc" },
            { "oc", "\u039f\u03be\u03b9\u03c4\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "kaj", "\u03a4\u03b6\u03bf\u03c5" },
            { "kam", "\u039a\u03ac\u03bc\u03c0\u03b1" },
            { "men", "\u039c\u03ad\u03bd\u03c4\u03b5" },
            { "oj", "\u039f\u03b6\u03b9\u03b2\u03af\u03b3\u03bf\u03c5\u03b1" },
            { "mer", "\u039c\u03ad\u03c1\u03bf\u03c5" },
            { "type.nu.armn", "\u0391\u03c1\u03bc\u03b5\u03bd\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "om", "\u039f\u03c1\u03cc\u03bc\u03bf" },
            { "kaw", "\u039a\u03ac\u03bf\u03c5\u03b9" },
            { "or", metaValue_or },
            { "os", "\u039f\u03c3\u03b5\u03c4\u03b9\u03ba\u03ac" },
            { "kbd", "\u039a\u03b1\u03bc\u03c0\u03b1\u03c1\u03bd\u03c4\u03b9\u03b1\u03bd\u03ac" },
            { "mfe", "\u039c\u03bf\u03c1\u03b9\u03c3\u03b9\u03ad\u03bd" },
            { "srn", "\u03a3\u03c1\u03b1\u03bd\u03ac\u03bd \u03a4\u03cc\u03bd\u03b3\u03ba\u03bf" },
            { "pa", "\u03a0\u03b1\u03bd\u03c4\u03b6\u03b1\u03c0\u03b9\u03ba\u03ac" },
            { "dua", "\u039d\u03c4\u03bf\u03c5\u03ac\u03bb\u03b1" },
            { "srr", "\u03a3\u03b5\u03c1\u03ad\u03c1" },
            { "%%LIPAW", "\u0394\u03b9\u03ac\u03bb\u03b5\u03ba\u03c4\u03bf\u03c2 \u039b\u03b9\u03c0\u03bf\u03b2\u03ac\u03b6 \u03c4\u03b7\u03c2 \u03a1\u03b5\u03c3\u03b9\u03ac\u03bd" },
            { "kbl", "\u039a\u03b1\u03bd\u03ad\u03bc\u03c0\u03bf\u03c5" },
            { "pi", "\u03a0\u03ac\u03bb\u03b9" },
            { "pl", "\u03a0\u03bf\u03bb\u03c9\u03bd\u03b9\u03ba\u03ac" },
            { "dum", "\u039c\u03ad\u03c3\u03b1 \u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ac" },
            { "type.ca.dangi", "\u039a\u03bf\u03c1\u03b5\u03b1\u03c4\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf \u03bd\u03c4\u03ac\u03bd\u03b3\u03ba\u03b9" },
            { "ps", "\u03a0\u03ac\u03c3\u03c4\u03bf" },
            { "pt", "\u03a0\u03bf\u03c1\u03c4\u03bf\u03b3\u03b1\u03bb\u03b9\u03ba\u03ac" },
            { "mga", "\u039c\u03ad\u03c3\u03b1 \u0399\u03c1\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ac" },
            { "key.co", "\u03a3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2" },
            { "pt_BR", "\u03a0\u03bf\u03c1\u03c4\u03bf\u03b3\u03b1\u03bb\u03b9\u03ba\u03ac \u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1\u03c2" },
            { "kcg", "\u03a4\u03b9\u03ac\u03c0" },
            { "mgh", "\u039c\u03b1\u03ba\u03bf\u03cd\u03b2\u03b1-\u039c\u03ad\u03c4\u03bf" },
            { "key.cf", "\u039c\u03bf\u03c1\u03c6\u03ae \u03bd\u03bf\u03bc\u03af\u03c3\u03bc\u03b1\u03c4\u03bf\u03c2" },
            { "bra", "\u039c\u03c0\u03c1\u03b1\u03c4\u03b6" },
            { "key.ca", "\u0397\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "Laoo", metaValue_LA },
            { "mgo", "\u039c\u03ad\u03c4\u03b1" },
            { "type.hc.h23", "24\u03c9\u03c1\u03bf \u03c3\u03cd\u03c3\u03c4\u03b7\u03bc\u03b1 (0\u201323)" },
            { "type.hc.h24", "24\u03c9\u03c1\u03bf \u03c3\u03cd\u03c3\u03c4\u03b7\u03bc\u03b1 (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "type.nu.mymr", "\u03a8\u03b7\u03c6\u03af\u03b1 \u039c\u03b9\u03b1\u03bd\u03bc\u03ac\u03c1" },
            { "qu", "\u039a\u03ad\u03c4\u03c3\u03bf\u03c5\u03b1" },
            { "zap", "\u0396\u03ac\u03c0\u03bf\u03c4\u03b5\u03ba" },
            { "brx", "\u039c\u03c0\u03cc\u03bd\u03c4\u03bf" },
            { "Lana", "\u039b\u03ac\u03bd\u03bd\u03b1" },
            { "kde", "\u039c\u03b1\u03ba\u03cc\u03bd\u03c4\u03b5" },
            { "Ethi", "\u0391\u03b9\u03b8\u03b9\u03bf\u03c0\u03b9\u03ba\u03cc" },
            { "type.hc.h12", "12\u03c9\u03c1\u03bf \u03c3\u03cd\u03c3\u03c4\u03b7\u03bc\u03b1 (1\u201312)" },
            { "type.hc.h11", "12\u03c9\u03c1\u03bf \u03c3\u03cd\u03c3\u03c4\u03b7\u03bc\u03b1 (0\u201311)" },
            { "rm", "\u03a1\u03bf\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "rn", "\u03a1\u03bf\u03cd\u03bd\u03c4\u03b9" },
            { "key.cu", "\u039d\u03cc\u03bc\u03b9\u03c3\u03bc\u03b1" },
            { "ro", "\u03a1\u03bf\u03c5\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "\u039f\u03c1\u03b9\u03b3\u03b9\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "type.nu.hanidec", "\u039a\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ac \u03b4\u03b5\u03ba\u03b1\u03b4\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "ru", "\u03a1\u03c9\u03c3\u03b9\u03ba\u03ac" },
            { "bss", "\u0391\u03ba\u03cc\u03c3\u03b9" },
            { "zbl", metaValue_zbl },
            { "rw", "\u039a\u03b9\u03bd\u03b9\u03b1\u03c1\u03bf\u03c5\u03ac\u03bd\u03c4\u03b1" },
            { "kea", "\u0393\u03bb\u03ce\u03c3\u03c3\u03b1 \u03c4\u03bf\u03c5 \u03a0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c5 \u0391\u03ba\u03c1\u03c9\u03c4\u03b7\u03c1\u03af\u03bf\u03c5" },
            { "mic", "\u039c\u03b9\u03ba\u03bc\u03ac\u03ba" },
            { "suk", "\u03a3\u03bf\u03c5\u03ba\u03bf\u03cd\u03bc\u03b1" },
            { "en_AU", "\u0391\u03b3\u03b3\u03bb\u03b9\u03ba\u03ac \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2" },
            { "sa", "\u03a3\u03b1\u03bd\u03c3\u03ba\u03c1\u03b9\u03c4\u03b9\u03ba\u03ac" },
            { "%%UCCOR", "\u0395\u03bd\u03c9\u03c0\u03bf\u03b9\u03b7\u03bc\u03ad\u03bd\u03b7 \u03bf\u03c1\u03b8\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b1" },
            { "sc", "\u03a3\u03b1\u03c1\u03b4\u03b7\u03bd\u03b9\u03b1\u03ba\u03ac" },
            { "sus", "\u03a3\u03bf\u03cd\u03c3\u03bf\u03c5" },
            { "sd", "\u03a3\u03af\u03bd\u03c4\u03b9" },
            { "se", "\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u03a3\u03ac\u03bc\u03b9" },
            { "min", "\u039c\u03b9\u03bd\u03b1\u03bd\u03b3\u03ba\u03b1\u03bc\u03c0\u03ac\u03bf\u03c5" },
            { "sg", "\u03a3\u03ac\u03bd\u03b3\u03ba\u03bf" },
            { "sh", "\u03a3\u03b5\u03c1\u03b2\u03bf\u03ba\u03c1\u03bf\u03b1\u03c4\u03b9\u03ba\u03ac" },
            { "si", "\u03a3\u03b9\u03bd\u03c7\u03b1\u03bb\u03b5\u03b6\u03b9\u03ba\u03ac" },
            { "sux", "\u03a3\u03bf\u03c5\u03bc\u03b5\u03c1\u03b9\u03ba\u03ac" },
            { "sk", "\u03a3\u03bb\u03bf\u03b2\u03b1\u03ba\u03b9\u03ba\u03ac" },
            { "sl", "\u03a3\u03bb\u03bf\u03b2\u03b5\u03bd\u03b9\u03ba\u03ac" },
            { "sm", "\u03a3\u03b1\u03bc\u03bf\u03b1\u03bd\u03ac" },
            { "sn", "\u03a3\u03cc\u03bd\u03b1" },
            { "so", "\u03a3\u03bf\u03bc\u03b1\u03bb\u03b9\u03ba\u03ac" },
            { "type.nu.arab", "\u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03bf-\u03b9\u03bd\u03b4\u03b9\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "sq", "\u0391\u03bb\u03b2\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "sr", "\u03a3\u03b5\u03c1\u03b2\u03b9\u03ba\u03ac" },
            { "ss", "\u03a3\u03bf\u03c5\u03ac\u03c4\u03b9" },
            { "type.cf.account", "\u039b\u03bf\u03b3\u03b9\u03c3\u03c4\u03b9\u03ba\u03ae \u03bc\u03bf\u03c1\u03c6\u03ae \u03bd\u03bf\u03bc\u03af\u03c3\u03bc\u03b1\u03c4\u03bf\u03c2" },
            { "st", "\u039d\u03cc\u03c4\u03b9\u03b1 \u03a3\u03cc\u03b8\u03bf" },
            { "Java", "\u0399\u03b1\u03b2\u03b1\u03bd\u03b5\u03b6\u03b9\u03ba\u03cc" },
            { "su", "\u03a3\u03bf\u03c5\u03bd\u03b4\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "%%NEDIS", "\u0394\u03b9\u03ac\u03bb\u03b5\u03ba\u03c4\u03bf\u03c2 \u039d\u03b1\u03c4\u03b9\u03c3\u03cc\u03bd\u03b5" },
            { "sv", "\u03a3\u03bf\u03c5\u03b7\u03b4\u03b9\u03ba\u03ac" },
            { "sw", "\u03a3\u03bf\u03c5\u03b1\u03c7\u03af\u03bb\u03b9" },
            { "type.nu.hantfin", "\u03a0\u03b1\u03c1\u03b1\u03b4\u03bf\u03c3\u03b9\u03b1\u03ba\u03ac \u03ba\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ac \u03bf\u03b9\u03ba\u03bf\u03bd\u03bf\u03bc\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "ibb", "\u0399\u03bc\u03c0\u03af\u03bc\u03c0\u03b9\u03bf" },
            { "iba", "\u0399\u03bc\u03c0\u03ac\u03bd" },
            { "ta", "\u03a4\u03b1\u03bc\u03b9\u03bb\u03b9\u03ba\u03ac" },
            { "142", "\u0391\u03c3\u03af\u03b1" },
            { "bua", "\u039c\u03c0\u03bf\u03c5\u03c1\u03b9\u03ac\u03c4" },
            { "143", "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u0391\u03c3\u03af\u03b1" },
            { "te", metaValue_te },
            { "145", "\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u0391\u03c3\u03af\u03b1" },
            { "tg", "\u03a4\u03b1\u03c4\u03b6\u03b9\u03ba\u03b9\u03ba\u03ac" },
            { "th", "\u03a4\u03b1\u03ca\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ac" },
            { "ti", "\u03a4\u03b9\u03b3\u03ba\u03c1\u03b9\u03bd\u03b9\u03ba\u03ac" },
            { "bug", "\u039c\u03c0\u03bf\u03c5\u03b3\u03ba\u03af\u03b6" },
            { "kfo", "\u039a\u03cc\u03c1\u03bf" },
            { "en_CA", "\u0391\u03b3\u03b3\u03bb\u03b9\u03ba\u03ac \u039a\u03b1\u03bd\u03b1\u03b4\u03ac" },
            { "tk", "\u03a4\u03bf\u03c5\u03c1\u03ba\u03bc\u03b5\u03bd\u03b9\u03ba\u03ac" },
            { "tl", "\u03a4\u03ac\u03b3\u03ba\u03b1\u03bb\u03bf\u03b3\u03ba" },
            { "tn", "\u03a4\u03c3\u03bf\u03c5\u03ac\u03bd\u03b1" },
            { "to", "\u03a4\u03bf\u03bd\u03b3\u03ba\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "bum", "\u039c\u03c0\u03bf\u03c5\u03bb\u03bf\u03cd" },
            { "dyo", "\u03a4\u03b6\u03cc\u03bb\u03b1-\u03a6\u03cc\u03bd\u03b9" },
            { "type.nu.jpan", "\u0399\u03b1\u03c0\u03c9\u03bd\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "tr", "\u03a4\u03bf\u03c5\u03c1\u03ba\u03b9\u03ba\u03ac" },
            { "ts", "\u03a4\u03c3\u03cc\u03bd\u03b3\u03ba\u03b1" },
            { "swb", "\u039a\u03bf\u03bc\u03bf\u03c1\u03b9\u03b1\u03bd\u03ac" },
            { "Cakm", "\u03a4\u03c3\u03ac\u03ba\u03bc\u03b1" },
            { "tt", "\u03a4\u03b1\u03c4\u03b1\u03c1\u03b9\u03ba\u03ac" },
            { "dyu", "\u039d\u03c4\u03bf\u03b3\u03b9\u03bf\u03cd\u03bb\u03b1" },
            { "tw", "\u03a4\u03bf\u03cd\u03b9" },
            { "ty", "\u03a4\u03b1\u03ca\u03c4\u03b9\u03b1\u03bd\u03ac" },
            { "%%BISKE", "\u0394\u03b9\u03ac\u03bb\u03b5\u03ba\u03c4\u03bf\u03c2 \u03a3\u03b1\u03bd \u03a4\u03b6\u03b9\u03cc\u03c1\u03c4\u03b6\u03b9\u03bf/\u0392\u03af\u03bb\u03b1" },
            { "150", "\u0395\u03c5\u03c1\u03ce\u03c0\u03b7" },
            { "151", "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u0395\u03c5\u03c1\u03ce\u03c0\u03b7" },
            { "154", "\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7" },
            { "dzg", "\u039d\u03c4\u03b1\u03b6\u03ac\u03b3\u03ba\u03b1" },
            { "155", "\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u0395\u03c5\u03c1\u03ce\u03c0\u03b7" },
            { "ug", "\u039f\u03c5\u03b9\u03b3\u03ba\u03bf\u03c5\u03c1\u03b9\u03ba\u03ac" },
            { "Ital", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03cc \u0399\u03c4\u03b1\u03bb\u03b9\u03ba\u03cc" },
            { "Kore", "\u039a\u03bf\u03c1\u03b5\u03b1\u03c4\u03b9\u03ba\u03cc" },
            { "Zyyy", "\u039a\u03bf\u03b9\u03bd\u03cc" },
            { "uk", "\u039f\u03c5\u03ba\u03c1\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "type.ca.coptic", "\u039a\u03bf\u03c0\u03c4\u03b9\u03ba\u03cc \u03b7\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf" },
            { "ur", "\u039f\u03c5\u03c1\u03bd\u03c4\u03bf\u03cd" },
            { "%%1994", "\u03a4\u03c5\u03c0\u03bf\u03c0\u03bf\u03b9\u03b7\u03bc\u03ad\u03bd\u03b7 \u03bf\u03c1\u03b8\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b1 \u03a1\u03b5\u03c3\u03b9\u03ac\u03bd" },
            { "xal", "\u039a\u03b1\u03bb\u03bc\u03af\u03ba" },
            { "zen", "\u0396\u03b5\u03bd\u03ac\u03b3\u03ba\u03b1" },
            { "uz", "\u039f\u03c5\u03b6\u03bc\u03c0\u03b5\u03ba\u03b9\u03ba\u03ac" },
            { "kha", "\u039a\u03ac\u03c3\u03b9" },
            { "%%1996", "\u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ae \u03bf\u03c1\u03b8\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b1 \u03c4\u03bf\u03c5 1996" },
            { "nds_NL", "\u039a\u03ac\u03c4\u03c9 \u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac \u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2" },
            { "Sylo", "\u03a3\u03c5\u03bb\u03cc\u03c4\u03b9 \u039d\u03ac\u03b3\u03ba\u03c1\u03b9" },
            { "ve", "\u0392\u03ad\u03bd\u03c4\u03b1" },
            { "type.ca.roc", "\u0397\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf \u03c4\u03b7\u03c2 \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1\u03c2 \u03c4\u03b7\u03c2 \u039a\u03af\u03bd\u03b1\u03c2" },
            { "vi", "\u0392\u03b9\u03b5\u03c4\u03bd\u03b1\u03bc\u03b9\u03ba\u03ac" },
            { "kho", "\u039a\u03bf\u03c4\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "khq", "\u039a\u03cc\u03b9\u03c1\u03b1 \u03a4\u03c3\u03af\u03bd\u03b9" },
            { "key.hc", "\u039a\u03cd\u03ba\u03bb\u03bf\u03c2 \u03c9\u03c1\u03ce\u03bd (12 \u03ae 24)" },
            { "%%TARASK", "\u03a4\u03b1\u03c1\u03b1\u03c3\u03ba\u03b9\u03b5\u03b2\u03b9\u03ba\u03ae \u03bf\u03c1\u03b8\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b1" },
            { "vo", "\u0392\u03bf\u03bb\u03b1\u03c0\u03b9\u03bf\u03cd\u03ba" },
            { "syc", "\u039a\u03bb\u03b1\u03c3\u03b9\u03ba\u03ac \u03a3\u03c5\u03c1\u03b9\u03b1\u03ba\u03ac" },
            { "Osma", "\u039f\u03c3\u03bc\u03ac\u03bd\u03b3\u03b9\u03b1" },
            { "quc", "\u039a\u03b9\u03c4\u03c3\u03ad" },
            { "gaa", "\u0393\u03ba\u03b1" },
            { "wa", "\u0392\u03b1\u03bb\u03bb\u03c9\u03bd\u03b9\u03ba\u03ac" },
            { "gag", "\u0393\u03ba\u03b1\u03b3\u03ba\u03ac\u03bf\u03c5\u03b6" },
            { "syr", "\u03a3\u03c5\u03c1\u03b9\u03b1\u03ba\u03ac" },
            { "Grek", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03cc" },
            { "Lydi", "\u039b\u03c5\u03b4\u03b9\u03b1\u03bd\u03b9\u03ba\u03cc" },
            { "Xsux", "\u03a3\u03bf\u03cd\u03bc\u03b5\u03c1\u03bf-\u0391\u03ba\u03ac\u03bd\u03c4\u03b9\u03b1\u03bd \u039a\u03bf\u03c5\u03bd\u03b5\u03ca\u03c6\u03cc\u03c1\u03bc" },
            { "wo", "\u0393\u03bf\u03c5\u03cc\u03bb\u03bf\u03c6" },
            { "zgh", "\u03a4\u03c5\u03c0\u03b9\u03ba\u03ac \u03a4\u03b1\u03bc\u03b1\u03b6\u03af\u03c4 \u039c\u03b1\u03c1\u03cc\u03ba\u03bf\u03c5" },
            { "ar_001", "\u03a3\u03cd\u03b3\u03c7\u03c1\u03bf\u03bd\u03b1 \u03a4\u03c5\u03c0\u03b9\u03ba\u03ac \u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ac" },
            { "Cans", "\u0395\u03bd\u03bf\u03c0\u03bf\u03b9\u03b7\u03bc\u03ad\u03bd\u03bf\u03b9 \u039a\u03b1\u03bd\u03b1\u03b4\u03b5\u03b6\u03b9\u03ba\u03bf\u03af \u03a3\u03c5\u03bb\u03bb\u03b1\u03b2\u03b9\u03c3\u03bc\u03bf\u03af \u0399\u03b8\u03b1\u03b3\u03b5\u03bd\u03ce\u03bd" },
            { "gay", "\u0393\u03ba\u03ac\u03b3\u03b9\u03bf" },
            { "Mong", "\u039c\u03bf\u03b3\u03b3\u03bf\u03bb\u03b9\u03ba\u03cc" },
            { "mnc", "\u039c\u03b1\u03bd\u03c4\u03c3\u03bf\u03cd" },
            { "Latf", "\u03a6\u03c1\u03ac\u03ba\u03c4\u03bf\u03c5\u03c1 \u039b\u03b1\u03c4\u03b9\u03bd\u03b9\u03ba\u03cc" },
            { "gba", "\u0393\u03ba\u03bc\u03c0\u03ac\u03b3\u03b9\u03b1" },
            { "mni", "\u039c\u03b1\u03bd\u03b9\u03c0\u03bf\u03cd\u03c1\u03b9" },
            { "Latn", "\u039b\u03b1\u03c4\u03b9\u03bd\u03b9\u03ba\u03cc" },
            { "Latg", "\u0393\u03b1\u03b5\u03bb\u03b9\u03ba\u03cc \u039b\u03b1\u03c4\u03b9\u03bd\u03b9\u03ba\u03cc" },
            { "type.nu.hans", "\u0391\u03c0\u03bb\u03bf\u03c0\u03bf\u03b9\u03b7\u03bc\u03ad\u03bd\u03b1 \u03ba\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "type.nu.hant", "\u03a0\u03b1\u03c1\u03b1\u03b4\u03bf\u03c3\u03b9\u03b1\u03ba\u03ac \u03ba\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "xh", "\u039a\u03cc\u03c3\u03b1" },
            { "type.nu.romanlow", "\u03a0\u03b5\u03b6\u03ac \u03bb\u03b1\u03c4\u03b9\u03bd\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "byn", "\u039c\u03c0\u03bb\u03b9\u03bd" },
            { "Lyci", "\u039b\u03c5\u03ba\u03b9\u03b1\u03bd\u03b9\u03ba\u03cc" },
            { "osa", "\u039f\u03c3\u03ac\u03b6" },
            { "byv", "\u039c\u03b5\u03bd\u03c4\u03bf\u03cd\u03bc\u03c0\u03b1" },
            { "Moon", "\u039c\u03bf\u03c5\u03bd" },
            { "moh", "\u039c\u03bf\u03c7\u03cc\u03ba" },
            { "kkj", "\u039a\u03ac\u03ba\u03bf" },
            { "%%1694ACAD", "\u03a0\u03c1\u03ce\u03b9\u03bc\u03b1 \u03a3\u03cd\u03b3\u03c7\u03c1\u03bf\u03bd\u03b1 \u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ac" },
            { "yi", "\u0393\u03af\u03bd\u03c4\u03b9\u03c2" },
            { "mos", "\u039c\u03cc\u03c3\u03b9" },
            { "Syrc", "\u03a3\u03c5\u03c1\u03b9\u03b1\u03ba\u03cc" },
            { "Dsrt", "\u039d\u03c4\u03b5\u03c3\u03b5\u03c1\u03ad" },
            { "yo", "\u0393\u03b9\u03bf\u03c1\u03bf\u03cd\u03bc\u03c0\u03b1" },
            { "type.nu.traditional", "\u03a0\u03b1\u03c1\u03b1\u03b4\u03bf\u03c3\u03b9\u03b1\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "es_MX", "\u0399\u03c3\u03c0\u03b1\u03bd\u03b9\u03ba\u03ac \u039c\u03b5\u03be\u03b9\u03ba\u03bf\u03cd" },
            { "Syrj", "\u0394\u03c5\u03c4\u03b9\u03ba\u03cc \u03a3\u03c5\u03c1\u03b9\u03b1\u03ba\u03cc" },
            { "ota", "\u039f\u03b8\u03c9\u03bc\u03b1\u03bd\u03b9\u03ba\u03ac \u03a4\u03bf\u03c5\u03c1\u03ba\u03b9\u03ba\u03ac" },
            { "Syre", "\u0395\u03c3\u03c4\u03c1\u03b1\u03bd\u03c4\u03b6\u03ad\u03bb\u03bf \u03a3\u03c5\u03c1\u03b9\u03b1\u03ba\u03cc" },
            { "vai", metaValue_vai },
            { "za", "\u0396\u03bf\u03c5\u03ac\u03bd\u03b3\u03ba" },
            { "Cari", "\u039a\u03b1\u03c1\u03b9\u03ac\u03bd" },
            { "kln", "\u039a\u03b1\u03bb\u03b5\u03bd\u03c4\u03b6\u03af\u03bd" },
            { "zh", "\u039a\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ac" },
            { "Bopo", "\u039c\u03c0\u03bf\u03c0\u03bf\u03bc\u03cc\u03c6\u03bf" },
            { "Perm", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03cc \u03a0\u03b5\u03c1\u03bc\u03b9\u03ba\u03cc" },
            { "key.lb", "\u03a3\u03c4\u03b9\u03bb \u03b1\u03bb\u03bb\u03b1\u03b3\u03ae\u03c2 \u03b3\u03c1\u03b1\u03bc\u03bc\u03ce\u03bd" },
            { "zu", "\u0396\u03bf\u03c5\u03bb\u03bf\u03cd" },
            { "type.co.phonebook", "\u03a3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2 \u03c4\u03b7\u03bb\u03b5\u03c6\u03c9\u03bd\u03b9\u03ba\u03bf\u03cd \u03ba\u03b1\u03c4\u03b1\u03bb\u03cc\u03b3\u03bf\u03c5" },
            { "%%MONOTON", "\u039c\u03bf\u03bd\u03bf\u03c4\u03bf\u03bd\u03b9\u03ba\u03cc" },
            { "Geor", "\u0393\u03b5\u03c9\u03c1\u03b3\u03b9\u03b1\u03bd\u03cc" },
            { "kmb", "\u039a\u03b9\u03bc\u03c0\u03bf\u03cd\u03bd\u03c4\u03bf\u03c5" },
            { "type.nu.jpanfin", "\u0399\u03b1\u03c0\u03c9\u03bd\u03b9\u03ba\u03ac \u03bf\u03b9\u03ba\u03bf\u03bd\u03bf\u03bc\u03b9\u03ba\u03ac \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ac" },
            { "Cham", "\u03a4\u03c3\u03b1\u03bc" },
            { "gez", "\u0393\u03ba\u03b9\u03b6" },
            { "Syrn", "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03cc \u03a3\u03c5\u03c1\u03b9\u03b1\u03ba\u03cc" },
            { "type.co.reformed", "\u0391\u03bd\u03b1\u03c3\u03c7\u03b7\u03bc\u03b1\u03c4\u03b9\u03c3\u03bc\u03ad\u03bd\u03b7 \u03c3\u03b5\u03b9\u03c1\u03ac \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2" },
            { "Tglg", "\u03a4\u03b1\u03b3\u03ba\u03b1\u03bb\u03cc\u03b3\u03ba" },
            { "Egyd", "\u039b\u03b1\u03ca\u03ba\u03cc \u0391\u03b9\u03b3\u03c5\u03c0\u03c4\u03b9\u03b1\u03ba\u03cc" },
            { "Egyh", "\u0399\u03b5\u03c1\u03b1\u03c4\u03b9\u03ba\u03cc \u0391\u03b9\u03b3\u03c5\u03c0\u03c4\u03b9\u03b1\u03ba\u03cc" },
            { "ebu", "\u0388\u03bc\u03c0\u03bf\u03c5" },
            { "Egyp", "\u0391\u03b9\u03b3\u03c5\u03c0\u03c4\u03b9\u03b1\u03ba\u03ac \u0399\u03b5\u03c1\u03bf\u03b3\u03bb\u03c5\u03c6\u03b9\u03ba\u03ac" },
            { "Geok", "\u0393\u03b5\u03c9\u03c1\u03b3\u03b9\u03b1\u03bd\u03cc \u039a\u03c7\u03bf\u03c5\u03c4\u03c3\u03bf\u03cd\u03c1\u03b9" },
            { "zh_Hans", "\u0391\u03c0\u03bb\u03bf\u03c0\u03bf\u03b9\u03b7\u03bc\u03ad\u03bd\u03b1 \u039a\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ac" },
            { "koi", "\u039a\u03cc\u03bc\u03b9-\u03a0\u03b5\u03c1\u03bc\u03b9\u03ac\u03ba" },
            { "Hung", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03cc \u039f\u03c5\u03b3\u03b3\u03c1\u03b9\u03ba\u03cc" },
            { "kok", "\u039a\u03bf\u03bd\u03ba\u03b1\u03bd\u03b9\u03ba\u03ac" },
            { "%%1901", "\u03a0\u03b1\u03c1\u03b1\u03b4\u03bf\u03c3\u03b9\u03b1\u03ba\u03ae \u03b3\u03b5\u03c1\u03bc\u03b1\u03bd\u03b9\u03ba\u03ae \u03bf\u03c1\u03b8\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b1" },
            { "kos", "\u039a\u03bf\u03c3\u03c1\u03b1\u03b5\u03bd\u03b9\u03ba\u03ac" },
            { "zh_Hant", "\u03a0\u03b1\u03c1\u03b1\u03b4\u03bf\u03c3\u03b9\u03b1\u03ba\u03ac \u039a\u03b9\u03bd\u03b5\u03b6\u03b9\u03ba\u03ac" },
            { "Sund", "\u03a3\u03bf\u03c5\u03bd\u03b4\u03b1\u03bd\u03b9\u03ba\u03cc" },
            { "kpe", "\u039a\u03c0\u03ad\u03bb\u03b5" },
            { "type.nu.khmr", "\u03a8\u03b7\u03c6\u03af\u03b1 \u03a7\u03bc\u03b5\u03c1" },
            { "ilo", "\u0399\u03bb\u03cc\u03ba\u03bf" },
            { "%%VALENCIA", "\u0392\u03b1\u03bb\u03b5\u03bd\u03b8\u03b9\u03b1\u03bd\u03ac" },
            { "Cprt", "\u039a\u03c5\u03c0\u03c1\u03b9\u03b1\u03ba\u03cc" },
            { "%%BAKU1926", "\u0395\u03bd\u03bf\u03c0\u03bf\u03b9\u03b7\u03bc\u03ad\u03bd\u03b7 \u03c4\u03bf\u03c5\u03c1\u03ba\u03b9\u03ba\u03ae \u03bb\u03b1\u03c4\u03b9\u03bd\u03b9\u03ba\u03ae \u03b1\u03bb\u03c6\u03ac\u03b2\u03b7\u03c4\u03bf\u03c2" },
            { "mua", "\u039c\u03bf\u03c5\u03bd\u03c4\u03ac\u03bd\u03b3\u03ba" },
            { "type.nu.guru", "\u03a8\u03b7\u03c6\u03af\u03b1 \u0393\u03ba\u03bf\u03c5\u03c1\u03bc\u03bf\u03cd\u03ba\u03b9" },
            { "mul", "\u03a0\u03bf\u03bb\u03bb\u03b1\u03c0\u03bb\u03ad\u03c2 \u03b3\u03bb\u03ce\u03c3\u03c3\u03b5\u03c2" },
            { "cad", "\u039a\u03ac\u03bd\u03c4\u03bf" },
            { "key.ms", "\u03a3\u03cd\u03c3\u03c4\u03b7\u03bc\u03b1 \u03bc\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7\u03c2" },
            { "mus", "\u039a\u03c1\u03b9\u03ba" },
            { "Glag", "\u0393\u03ba\u03bb\u03b1\u03b3\u03ba\u03bf\u03bb\u03b9\u03c4\u03b9\u03ba\u03cc" },
            { "gil", "\u0393\u03ba\u03b9\u03bb\u03bc\u03c0\u03b5\u03c1\u03c4\u03af\u03b6" },
            { "%%KKCOR", "\u039a\u03bf\u03b9\u03bd\u03ae \u03bf\u03c1\u03b8\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b1" },
            { "Cher", metaValue_chr },
            { "car", "\u039a\u03b1\u03c1\u03af\u03bc\u03c0" },
            { "cay", "\u039a\u03b1\u03b3\u03b9\u03bf\u03cd\u03b3\u03ba\u03b1" },
            { "type.nu.tamldec", "\u03a4\u03b1\u03bc\u03b9\u03bb\u03b9\u03ba\u03ac \u03c8\u03b7\u03c6\u03af\u03b1" },
            { "krc", "\u039a\u03b1\u03c1\u03b1\u03c4\u03c3\u03ac\u03b9-\u039c\u03c0\u03b1\u03bb\u03ba\u03ac\u03c1" },
            { "inh", "\u0399\u03bd\u03b3\u03ba\u03bf\u03cd\u03c2" },
            { "krl", "\u039a\u03b1\u03c1\u03b5\u03bb\u03b9\u03ba\u03ac" },
            { "efi", "\u0395\u03c6\u03af\u03ba" },
            { "key.nu", "\u0391\u03c1\u03b9\u03b8\u03bc\u03bf\u03af" },
            { "kru", "\u039a\u03bf\u03c5\u03c1\u03bf\u03cd\u03c7" },
            { "ksb", "\u03a3\u03b1\u03bc\u03c0\u03ac\u03bb\u03b1" },
            { "Telu", metaValue_te },
            { "ksf", "\u039c\u03c0\u03ac\u03c6\u03b9\u03b1" },
        };
        return data;
    }
}
