/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.io.File;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import javajs.util.PT;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jmol.api.JmolAppAPI;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.InputScannerThread;
import org.openscience.jmol.app.SplashInterface;

public class JmolApp
implements JmolAppAPI {
    public int port;
    public int startupWidth;
    public int startupHeight;
    public Point border;
    public boolean haveBorder;
    public File userPropsFile;
    public HistoryFile historyFile;
    public HistoryFile pluginFile;
    public boolean haveConsole = true;
    public boolean haveDisplay = true;
    public boolean splashEnabled = true;
    public boolean isDataOnly;
    public boolean isKiosk;
    public boolean isPrintOnly;
    public boolean isSilent;
    public Map<String, Object> info = new Hashtable<String, Object>();
    public Point jmolPosition;
    public float autoAnimationDelay = 0.2f;
    private String modelFilename;
    private String scriptFilename;
    private String script1 = "";
    private String script2 = "";
    private boolean scanInput;
    private String menuFile;

    public JmolApp() {
    }

    public JmolApp(String[] stringArray) {
        if (System.getProperty("javawebstart.version") != null) {
            System.setSecurityManager(null);
        }
        if (System.getProperty("user.home") == null) {
            System.err.println(GT.$("Error starting Jmol: the property 'user.home' is not defined."));
            System.exit(1);
        }
        File file = new File(new File(System.getProperty("user.home")), ".jmol");
        file.mkdirs();
        this.userPropsFile = new File(file, "properties");
        this.historyFile = new HistoryFile(new File(file, "history"), "Jmol's persistent values");
        this.pluginFile = new HistoryFile(new File(file, "plugins"), "Jmol plugin persistent values");
        this.parseCommandLine(stringArray);
    }

    public void parseCommandLine(String[] stringArray) {
        Options options = this.getOptions();
        CommandLine commandLine = null;
        try {
            PosixParser posixParser = new PosixParser();
            commandLine = posixParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("Unexpected exception: " + parseException.toString());
        }
        stringArray = commandLine.getArgs();
        if (stringArray.length > 0) {
            this.modelFilename = stringArray[0];
        }
        this.checkOptions(commandLine, options);
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("a", "autoanimationdelay", true, GT.$("delay time in seconds for press-and-hold operation of toolbar animation buttons (default 0.2; numbers > 10 assumed to be milliseconds; set to 0 to disable)"));
        options.addOption("b", "backgroundtransparent", false, GT.$("transparent background"));
        options.addOption("C", "checkload", false, GT.$("check script syntax only - with file loading"));
        options.addOption("c", "check", false, GT.$("check script syntax only - no file loading"));
        OptionBuilder.withValueSeparator();
        options.addOption("D", "property=value", true, GT.$("supported options are given below"));
        options.addOption("d", "debug", false, GT.$("debug"));
        options.addOption("g", "geometry", true, GT.o(GT.$("window width x height, e.g. {0}"), "-g500x500"));
        options.addOption("h", "help", false, GT.$("give this help page"));
        options.addOption("I", "input", false, GT.$("allow piping of input from System.Input"));
        options.addOption("i", "silent", false, GT.$("silent startup operation"));
        options.addOption("J", "jmolscript1", true, GT.$("Jmol script to execute BEFORE -s option"));
        options.addOption("j", "jmolscript2", true, GT.$("Jmol script to execute AFTER -s option"));
        options.addOption("k", "kiosk", false, GT.$("kiosk mode -- no frame"));
        options.addOption("L", "nosplash", false, GT.$("start with no splash screen"));
        options.addOption("l", "list", false, GT.$("list commands during script execution"));
        options.addOption("M", "multitouch", true, GT.$("use multitouch interface (requires \"sparshui\" parameter"));
        options.addOption("m", "menu", true, GT.$("menu file to use"));
        options.addOption("n", "nodisplay", false, GT.$("no display (and also exit when done)"));
        options.addOption("o", "noconsole", false, GT.$("no console -- all output to sysout"));
        options.addOption("P", "port", true, GT.$("port for JSON/MolecularPlayground-style communication"));
        options.addOption("p", "printOnly", false, GT.$("send only output from print messages to console (implies -i)"));
        options.addOption("q", "quality", true, GT.$("JPG image quality (1-100; default 75) or PNG image compression (0-9; default 2, maximum compression 9)"));
        options.addOption("R", "restricted", false, GT.$("restrict local file access"));
        options.addOption("r", "restrictSpt", false, GT.$("restrict local file access (allow reading of SPT files)"));
        options.addOption("s", "script", true, GT.$("script file to execute or '-' for System.in"));
        options.addOption("T", "headlessmaxtime", true, GT.$("headless max time (sec)"));
        options.addOption("t", "threaded", false, GT.$("independent command thread"));
        options.addOption("U", "plugin", true, GT.$("plugin to start initially"));
        options.addOption("w", "write", true, GT.o(GT.$("{0} or {1}:filename"), new Object[]{"CLIP", "GIF|JPG|JPG64|PNG|PPM"}));
        options.addOption("x", "exit", false, GT.$("exit after script (implicit with -n)"));
        return options;
    }

    private void checkOptions(CommandLine commandLine, Options options) {
        Object object;
        if (commandLine.hasOption("h")) {
            object = new HelpFormatter();
            object.setOptionComparator((Comparator)new OptSort());
            object.printHelp("Jmol", options);
            System.out.println();
            System.out.println(GT.$("For example:"));
            System.out.println();
            System.out.println("Jmol -ions myscript.spt -w JPEG:myfile.jpg > output.txt");
            System.out.println();
            System.out.println(GT.$("The -D options are as follows (defaults in parenthesis) and must be called preceding '-jar Jmol.jar':"));
            System.out.println();
            System.out.println("  cdk.debugging=[true|false] (false)");
            System.out.println("  cdk.debug.stdout=[true|false] (false)");
            System.out.println("  display.speed=[fps|ms] (ms)");
            System.out.println("  logger.debug=[true|false] (false)");
            System.out.println("  logger.error=[true|false] (true)");
            System.out.println("  logger.fatal=[true|false] (true)");
            System.out.println("  logger.info=[true|false] (true)");
            System.out.println("  logger.logLevel=[true|false] (false)");
            System.out.println("  logger.warn=[true|false] (true)");
            System.out.println("  plugin.dir (unset)");
            System.out.println("  user.language=[ca|cs|de|en_GB|en_US|es|fr|hu|it|ko|nl|pt_BR|tr|zh_TW] (en_US)");
            System.exit(0);
        }
        if (commandLine.hasOption("a")) {
            this.autoAnimationDelay = PT.parseFloat(commandLine.getOptionValue("a"));
            if (this.autoAnimationDelay > 10.0f) {
                this.autoAnimationDelay /= 1000.0f;
            }
            Logger.info("setting autoAnimationDelay to " + this.autoAnimationDelay + " seconds");
        }
        if (commandLine.hasOption("d")) {
            Logger.setLogLevel(5);
        }
        this.info.put(this.isDataOnly ? "JmolData" : "Jmol", Boolean.TRUE);
        if (commandLine.hasOption("k")) {
            this.isKiosk = true;
            this.info.put("isKiosk", true);
        }
        if (commandLine.hasOption("P")) {
            this.port = PT.parseInt(commandLine.getOptionValue("P"));
        }
        if (this.port > 0) {
            this.info.put("port", this.port);
        }
        if (commandLine.hasOption("p")) {
            this.isPrintOnly = true;
        }
        if (this.isPrintOnly) {
            this.info.put("printOnly", Boolean.TRUE);
            this.isSilent = true;
        }
        if (commandLine.hasOption("i")) {
            this.isSilent = true;
        }
        if (this.isSilent) {
            this.info.put("silent", Boolean.TRUE);
        }
        if (commandLine.hasOption("o")) {
            this.haveConsole = false;
        }
        if (!this.haveConsole) {
            this.info.put("noConsole", Boolean.TRUE);
        }
        if (commandLine.hasOption("b")) {
            this.info.put("transparentBackground", Boolean.TRUE);
        }
        if (commandLine.hasOption("R")) {
            this.info.put("access:NONE", Boolean.TRUE);
        }
        if (commandLine.hasOption("r")) {
            this.info.put("access:READSPT", Boolean.TRUE);
        }
        if (commandLine.hasOption("t")) {
            this.info.put("useCommandThread", Boolean.TRUE);
        }
        if (commandLine.hasOption("l")) {
            this.info.put("listCommands", Boolean.TRUE);
        }
        if (commandLine.hasOption("L")) {
            this.splashEnabled = false;
        }
        if (commandLine.hasOption("c")) {
            this.info.put("check", Boolean.TRUE);
        }
        if (commandLine.hasOption("C")) {
            this.info.put("checkLoad", Boolean.TRUE);
        }
        if (commandLine.hasOption("m")) {
            this.menuFile = commandLine.getOptionValue("m");
        }
        if (commandLine.hasOption("J")) {
            this.script1 = commandLine.getOptionValue("J");
        }
        if (commandLine.hasOption("M")) {
            this.info.put("multitouch", commandLine.getOptionValue("M"));
        }
        if (commandLine.hasOption("s")) {
            this.scriptFilename = commandLine.getOptionValue("s");
        }
        if (commandLine.hasOption("U")) {
            this.info.put("plugin", commandLine.getOptionValue("U"));
        }
        if (commandLine.hasOption("j")) {
            this.script2 = commandLine.getOptionValue("j");
        }
        if (this.haveDisplay && this.historyFile != null) {
            String string = System.getProperty("java.version");
            if (string.compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing components require a 1.1.2 or higher version VM!!!");
            }
            if (!this.isKiosk) {
                object = this.historyFile.getWindowSize("Jmol");
                if (object != null) {
                    this.startupWidth = object.width;
                    this.startupHeight = object.height;
                }
                this.historyFile.getWindowBorder("Jmol");
                this.border = new Point(12, 116);
            }
        }
        int n = this.isKiosk ? 0 : 500;
        int n2 = 500;
        if (commandLine.hasOption("g")) {
            String string = commandLine.getOptionValue("g");
            int n3 = string.indexOf(120);
            if (n3 > 0) {
                n = PT.parseInt(string.substring(0, n3));
                n2 = PT.parseInt(string.substring(n3 + 1));
            } else {
                n = n2 = PT.parseInt(string);
            }
            this.startupWidth = -1;
        }
        if (this.startupWidth <= 0 || this.startupHeight <= 0) {
            if (this.haveDisplay && !this.isKiosk && this.border != null) {
                this.startupWidth = n + this.border.x;
                this.startupHeight = n2 + this.border.y;
            } else {
                this.startupWidth = n;
                this.startupHeight = n2;
            }
        }
        if (commandLine.hasOption("w")) {
            String string;
            int n4 = -1;
            if (commandLine.hasOption("q")) {
                n4 = PT.parseInt(commandLine.getOptionValue("q"));
            }
            if ((string = commandLine.getOptionValue("w")) != null) {
                if (string.length() == 0) {
                    string = "JPG:jpg";
                }
                if (string.indexOf(":") < 0) {
                    string = String.valueOf(string) + ":jpg";
                }
                int n5 = string.indexOf(":");
                String string2 = string.substring(0, n5).toUpperCase();
                string = string.substring(n5 + 1).trim();
                if (string2.indexOf(" ") >= 0) {
                    n4 = PT.parseInt(string2.substring(string2.indexOf(" ")).trim());
                    string2.substring(0, string2.indexOf(" "));
                }
                if (GraphicsEnvironment.isHeadless()) {
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    hashtable.put("fileName", string);
                    hashtable.put("type", string2);
                    hashtable.put("quality", n4);
                    hashtable.put("width", n);
                    hashtable.put("height", n2);
                    this.info.put("headlessImage", hashtable);
                } else {
                    this.script2 = String.valueOf(this.script2) + ";write image " + (n > 0 && n2 > 0 ? String.valueOf(n) + " " + n2 : "") + " " + string2 + " " + n4 + " " + PT.esc(string);
                }
            }
        }
        if (GraphicsEnvironment.isHeadless()) {
            this.info.put("headlistMaxTimeMs", 1000 * (commandLine.hasOption("T") ? PT.parseInt(commandLine.getOptionValue("T")) : 60));
        }
        if (commandLine.hasOption("I")) {
            this.scanInput = true;
        }
        boolean bl = false;
        if (commandLine.hasOption("n")) {
            this.haveDisplay = false;
            boolean bl2 = bl = !this.scanInput;
        }
        if (commandLine.hasOption("x")) {
            bl = true;
        }
        if (!this.haveDisplay) {
            this.info.put("noDisplay", Boolean.TRUE);
        }
        if (bl) {
            this.info.put("exit", Boolean.TRUE);
            this.script2 = String.valueOf(this.script2) + ";exitJmol;";
        }
    }

    public void startViewer(JmolViewer jmolViewer, SplashInterface splashInterface, boolean bl) {
        Object object;
        if (this.menuFile != null) {
            jmolViewer.setMenu(this.menuFile, true);
        }
        if (this.modelFilename != null) {
            if (this.script1 == null) {
                this.script1 = "";
            }
            this.script1 = String.valueOf(this.modelFilename.endsWith(".spt") ? "script " : "load ") + PT.esc(this.modelFilename) + ";" + this.script1;
        }
        if (this.script1 != null && this.script1.length() > 0) {
            if (!this.isSilent) {
                Logger.info("Executing script: " + this.script1);
            }
            if (splashInterface != null) {
                splashInterface.showStatus(GT.$("Executing script 1..."));
            }
            this.runScript(this.script1, bl, jmolViewer);
        }
        if (this.scriptFilename != null) {
            if (!this.isSilent) {
                Logger.info("Executing script from file: " + this.scriptFilename);
            }
            if (splashInterface != null) {
                splashInterface.showStatus(GT.$("Executing script file..."));
            }
            if (this.scriptFilename.equals("-")) {
                object = new Scanner(System.in);
                String string = "";
                StringBuilder stringBuilder = new StringBuilder();
                while (((Scanner)object).hasNextLine() && (string = ((Scanner)object).nextLine()) != null && !string.equals("!quit")) {
                    stringBuilder.append(string).append("\n");
                }
                ((Scanner)object).close();
                this.runScript(stringBuilder.toString(), bl, jmolViewer);
            } else {
                jmolViewer.evalFile(this.scriptFilename);
            }
        }
        if (this.script2 != null && this.script2.length() > 0) {
            if (!this.isSilent) {
                Logger.info("Executing script: " + this.script2);
            }
            if (splashInterface != null) {
                splashInterface.showStatus(GT.$("Executing script 2..."));
            }
            this.runScript(this.script2, bl, jmolViewer);
        }
        if ((object = (String)this.info.get("plugin")) != null) {
            ((Viewer)jmolViewer).startPlugin((String)object);
        }
        if (this.scanInput) {
            new InputScannerThread(jmolViewer, this.isSilent);
        }
    }

    private void runScript(String string, boolean bl, JmolViewer jmolViewer) {
        if (bl) {
            System.out.print(jmolViewer.scriptWaitStatus(string, null));
        } else {
            jmolViewer.script(string);
        }
    }

    @Override
    public void addHistoryWindowInfo(String string, Component component, Point point) {
        this.historyFile.addWindowInfo(string, component, point);
    }

    @Override
    public Point getHistoryWindowPosition(String string) {
        return this.historyFile.getWindowPosition(string);
    }

    @Override
    public Dimension getHistoryWindowSize(String string) {
        return this.historyFile.getWindowSize(string);
    }

    class OptSort
    implements Comparator<Option> {
        OptSort() {
        }

        @Override
        public int compare(Option option, Option option2) {
            char c;
            char c2 = option.getOpt().charAt(0);
            char c3 = option2.getOpt().charAt(0);
            char c4 = Character.toUpperCase(c2);
            return c4 == (c = Character.toUpperCase(c3)) ? (c2 < c3 ? -1 : 1) : Character.compare(c4, c);
        }
    }
}

