/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FOTreeBuilder;
import org.apache.fop.fo.PropertyListMaker;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.image.ImageFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FOTreeBuilder
extends DefaultHandler {
    protected Log log = LogFactory.getLog(class$org$apache$fop$fo$FOTreeBuilder == null ? (class$org$apache$fop$fo$FOTreeBuilder = FOTreeBuilder.class$("org.apache.fop.fo.FOTreeBuilder")) : class$org$apache$fop$fo$FOTreeBuilder);
    protected ElementMappingRegistry elementMappingRegistry;
    protected Root rootFObj = null;
    protected MainFOHandler mainFOHandler;
    protected ContentHandler delegate;
    private FOEventHandler foEventHandler;
    private Locator locator;
    private FOUserAgent userAgent;
    private boolean used = false;
    private int depth;
    static /* synthetic */ Class class$org$apache$fop$fo$FOTreeBuilder;

    public FOTreeBuilder(String outputFormat, FOUserAgent foUserAgent, OutputStream stream) throws FOPException {
        this.userAgent = foUserAgent;
        this.elementMappingRegistry = this.userAgent.getFactory().getElementMappingRegistry();
        this.foEventHandler = foUserAgent.getRendererFactory().createFOEventHandler(foUserAgent, outputFormat, stream);
        this.foEventHandler.setPropertyListMaker((PropertyListMaker)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean isLocatorDisabled() {
        return !this.userAgent.isLocatorEnabled();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected Locator getEffectiveLocator() {
        return this.userAgent.isLocatorEnabled() ? this.locator : null;
    }

    public void characters(char[] data, int start, int length) throws SAXException {
        this.delegate.characters(data, start, length);
    }

    public void startDocument() throws SAXException {
        if (this.used) {
            throw new IllegalStateException("FOTreeBuilder (and the Fop class) cannot be reused. Please instantiate a new instance.");
        }
        this.used = true;
        this.rootFObj = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Building formatting object tree");
        }
        this.foEventHandler.startDocument();
        this.mainFOHandler = new MainFOHandler(this, null);
        this.mainFOHandler.startDocument();
        this.delegate = this.mainFOHandler;
    }

    public void endDocument() throws SAXException {
        this.delegate.endDocument();
        this.rootFObj = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Parsing of document complete");
        }
        this.foEventHandler.endDocument();
        ImageFactory imageFactory = this.userAgent.getFactory().getImageFactory();
        imageFactory.removeContext(this.userAgent);
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attlist) throws SAXException {
        ++this.depth;
        this.delegate.startElement(namespaceURI, localName, rawName, attlist);
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        this.delegate.endElement(uri, localName, rawName);
        --this.depth;
        if (this.depth == 0 && this.delegate != this.mainFOHandler) {
            this.delegate.endDocument();
            this.delegate = this.mainFOHandler;
            this.delegate.endElement(uri, localName, rawName);
        }
    }

    private ElementMapping.Maker findFOMaker(String namespaceURI, String localName) throws FOPException {
        return this.elementMappingRegistry.findFOMaker(namespaceURI, localName, this.locator);
    }

    public void warning(SAXParseException e) {
        this.log.warn(e.toString());
    }

    public void error(SAXParseException e) {
        this.log.error(e.toString());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.log.error(e.toString());
        throw e;
    }

    public FOEventHandler getEventHandler() {
        return this.foEventHandler;
    }

    public FormattingResults getResults() {
        if (this.getEventHandler() instanceof AreaTreeHandler) {
            return ((AreaTreeHandler)this.getEventHandler()).getResults();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Locator access$100(FOTreeBuilder x0) {
        return x0.locator;
    }

    static /* synthetic */ ElementMapping.Maker access$200(FOTreeBuilder x0, String x1, String x2) throws FOPException {
        return x0.findFOMaker(x1, x2);
    }

    static /* synthetic */ FOEventHandler access$300(FOTreeBuilder x0) {
        return x0.foEventHandler;
    }

    static /* synthetic */ int access$402(FOTreeBuilder x0, int x1) {
        x0.depth = x1;
        return x0.depth;
    }
}

