/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.perspective;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import javax.swing.SwingUtilities;
import org.gephi.perspective.api.PerspectiveController;
import org.gephi.perspective.spi.Perspective;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public class PerspectiveControllerImpl
implements PerspectiveController {
    private static final String SELECTED_PERSPECTIVE_PREFERENCE = "PerspectiveControllerImpl_selectedPerspective";
    private String selectedPerspective;
    private final Perspective[] perspectives = Lookup.getDefault().lookupAll(Perspective.class).toArray(new Perspective[0]);

    public PerspectiveControllerImpl() {
        String firstPerspective = this.perspectives.length > 0 ? this.perspectives[0].getName() : null;
        String defaultPerspectiveName = System.getProperty("org.gephi.perspective.default");
        if (defaultPerspectiveName != null) {
            for (Perspective p : this.perspectives) {
                if (!p.getName().equals(defaultPerspectiveName)) continue;
                this.selectedPerspective = p.getName();
                break;
            }
        }
        if (this.selectedPerspective == null) {
            this.selectedPerspective = NbPreferences.root().get(SELECTED_PERSPECTIVE_PREFERENCE, firstPerspective);
        }
        NbPreferences.root().put(SELECTED_PERSPECTIVE_PREFERENCE, this.selectedPerspective);
        Perspective selectedPerspectiveInstance = this.getSelectedPerspective();
        this.openAndCloseMembers(selectedPerspectiveInstance);
        WindowManager.getDefault().addWindowSystemListener(new WindowSystemListener(){
            private Dimension lastDimension = null;
            private Integer lastState = null;
            private Point lastLocation = null;

            public void beforeLoad(WindowSystemEvent event) {
            }

            public void afterLoad(WindowSystemEvent event) {
                Frame mainWindow = WindowManager.getDefault().getMainWindow();
                if (mainWindow != null) {
                    if (this.lastDimension != null) {
                        mainWindow.setSize(this.lastDimension);
                    }
                    if (this.lastLocation != null) {
                        mainWindow.setLocation(this.lastLocation);
                    }
                    if (this.lastState != null) {
                        mainWindow.setState(this.lastState);
                    }
                }
            }

            public void beforeSave(WindowSystemEvent event) {
                Frame mainWindow = WindowManager.getDefault().getMainWindow();
                if (mainWindow != null) {
                    this.lastDimension = mainWindow.getSize();
                    this.lastLocation = mainWindow.getLocation();
                    this.lastState = mainWindow.getExtendedState();
                }
            }

            public void afterSave(WindowSystemEvent event) {
            }
        });
    }

    @Override
    public Perspective[] getPerspectives() {
        return this.perspectives;
    }

    @Override
    public Perspective getSelectedPerspective() {
        for (Perspective p : this.perspectives) {
            if (!p.getName().equals(this.selectedPerspective)) continue;
            return p;
        }
        return null;
    }

    @Override
    public void selectPerspective(Perspective perspective) {
        if (perspective.getName().equals(this.selectedPerspective)) {
            return;
        }
        this.openAndCloseMembers(perspective);
        this.selectedPerspective = perspective.getName();
        NbPreferences.root().put(SELECTED_PERSPECTIVE_PREFERENCE, this.selectedPerspective);
    }

    private void openAndCloseMembers(final Perspective perspective) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().setRole(perspective.getName());
            }
        });
    }
}

