/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.NamespaceBuilder;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

public abstract class CppProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    public CppProjectInitDescriptor(BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider) {
        super("cpp", scriptBuilderFactory, templateOperationFactory, fileResolver, libraryVersionProvider);
    }

    @Override
    protected void generate(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.fileComment("This generated file contains a sample CPP project to get you started.");
        this.configureBuildScript(settings, buildScriptBuilder);
        TemplateOperation sourceTemplate = this.sourceTemplateOperation(settings);
        TemplateOperation headerTemplate = this.headerTemplateOperation(settings);
        TemplateOperation testSourceTemplate = this.testTemplateOperation(settings);
        this.whenNoSourcesAvailable(sourceTemplate, headerTemplate, testSourceTemplate).generate();
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Sets.newHashSet();
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return null;
    }

    protected abstract TemplateOperation sourceTemplateOperation(InitSettings var1);

    protected abstract TemplateOperation headerTemplateOperation(InitSettings var1);

    protected abstract TemplateOperation testTemplateOperation(InitSettings var1);

    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
    }

    @Override
    public boolean supportsPackage() {
        return false;
    }

    protected String getHostTargetMachineDefinition() {
        DefaultNativePlatform host = DefaultNativePlatform.host();
        String definition = "machines.";
        definition = host.getOperatingSystem().isWindows() ? definition + "windows" : (host.getOperatingSystem().isMacOsX() ? definition + "macOS" : (host.getOperatingSystem().isLinux() ? definition + "linux" : definition + "os('" + host.getOperatingSystem().toFamilyName() + "')"));
        definition = definition + ".";
        definition = host.getArchitecture().isI386() ? definition + "x86" : (host.getArchitecture().isAmd64() ? definition + "x86_64" : definition + "architecture('" + host.getArchitecture().getName() + "')");
        return definition;
    }

    TemplateOperation fromCppTemplate(String template, InitSettings settings, String sourceSetName, String sourceDir) {
        String targetFileName = template.substring(template.lastIndexOf("/") + 1).replace(".template", "");
        return this.fromCppTemplate(template, targetFileName, settings, sourceSetName, sourceDir);
    }

    TemplateOperation fromCppTemplate(String template, String targetFileName, InitSettings settings, String sourceSetName, String sourceDir) {
        if (settings == null || settings.getProjectName().isEmpty()) {
            throw new IllegalArgumentException("Project name cannot be empty for a C++ project");
        }
        String namespace = NamespaceBuilder.toNamespace(settings.getProjectName());
        return this.templateOperationFactory.newTemplateOperation().withTemplate(template).withTarget("src/" + sourceSetName + "/" + sourceDir + "/" + targetFileName).withBinding("projectName", settings.getProjectName()).withBinding("namespace", namespace).create();
    }
}

