/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.BasePrimitiveBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializerImpl;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.OptionTag;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.Element;

class OptionTagBinding
extends BasePrimitiveBinding {
    private final String myTagName;
    private final String myNameAttribute;
    private final String myValueAttribute;

    OptionTagBinding(@NotNull MutableAccessor accessor, @Nullable OptionTag optionTag) {
        if (accessor == null) {
            OptionTagBinding.$$$reportNull$$$0(0);
        }
        super(accessor, optionTag == null ? null : optionTag.value(), optionTag == null ? null : optionTag.converter());
        if (optionTag == null) {
            this.myTagName = "option";
            this.myNameAttribute = "name";
            this.myValueAttribute = "value";
        } else {
            this.myNameAttribute = optionTag.nameAttribute();
            this.myValueAttribute = optionTag.valueAttribute();
            String tagName = optionTag.tag();
            if (StringUtil.isEmpty(this.myNameAttribute) && "option".equals(tagName)) {
                tagName = this.myAccessor.getName();
            }
            this.myTagName = tagName;
        }
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        Attribute valueAttribute;
        if (context == null) {
            OptionTagBinding.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OptionTagBinding.$$$reportNull$$$0(3);
        }
        if ((valueAttribute = element.getAttribute(this.myValueAttribute)) == null) {
            if (this.myValueAttribute.isEmpty()) {
                assert (this.myBinding != null);
                this.myAccessor.set(context, this.myBinding.deserializeUnsafe(context, element));
            } else {
                List<Element> children2 = element.getChildren();
                if (children2.isEmpty()) {
                    this.myAccessor.set(context, null);
                } else {
                    assert (this.myBinding != null);
                    Object oldValue = this.myAccessor.read(context);
                    Object newValue = Binding.deserializeList(this.myBinding, oldValue, children2);
                    if (this.myAccessor.isFinal()) {
                        LOG.assertTrue(oldValue == newValue);
                    } else {
                        this.myAccessor.set(context, newValue);
                    }
                }
            }
        } else {
            String value = valueAttribute.getValue();
            if (this.myConverter == null) {
                try {
                    XmlSerializerImpl.doSet(context, value, this.myAccessor, XmlSerializerImpl.typeToClass(this.myAccessor.getGenericType()));
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot set value for field " + this.myName, e);
                }
            } else {
                this.myAccessor.set(context, this.myConverter.fromString(value));
            }
        }
        Object object = context;
        if (object == null) {
            OptionTagBinding.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            OptionTagBinding.$$$reportNull$$$0(5);
        }
        if (!element.getName().equals(this.myTagName)) {
            return false;
        }
        String name = element.getAttributeValue(this.myNameAttribute);
        if (StringUtil.isEmpty(this.myNameAttribute)) {
            return name == null || name.equals(this.myName);
        }
        return name != null && name.equals(this.myName);
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.myName + ", binding=" + this.myBinding + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/xmlb/OptionTagBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/OptionTagBinding";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

