/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.events.AChart2DAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;

public final class Chart2DActionSetAxis
extends AChart2DAction {
    private final int m_axisTarget;
    private final transient AAxis m_axis;

    public Chart2DActionSetAxis(Chart2D chart, AAxis axis, String description, int axisTarget) throws IllegalArgumentException {
        super(chart, description);
        if (axisTarget != 1 && axisTarget != 2) {
            throw new IllegalArgumentException("Argument axisTarget is invalid, choose one of Chart2D.X, Chart2D.Y.");
        }
        this.m_axisTarget = axisTarget;
        this.m_axis = axis;
        chart.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_X", this);
        chart.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_Y", this);
    }

    public void actionPerformed(ActionEvent e) {
        switch (this.m_axisTarget) {
            case 1: {
                this.m_chart.setAxisXBottom(this.m_axis);
                break;
            }
            case 2: {
                this.m_chart.setAxisYLeft(this.m_axis);
                break;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Chart2D.PROPERTY_AXIS_X") && this.m_axisTarget == 1) {
            if (evt.getNewValue() != null) {
                Class<?> axisClass = evt.getNewValue().getClass();
                if (this.m_axis.getClass() == axisClass) {
                    this.firePropertyChange("", new Boolean(false), new Boolean(true));
                } else {
                    this.firePropertyChange("", new Boolean(true), new Boolean(false));
                }
            }
        } else if (evt.getPropertyName().equals("Chart2D.PROPERTY_AXIS_Y") && this.m_axisTarget == 2 && evt.getNewValue() != null) {
            Class<?> axisClass = evt.getNewValue().getClass();
            if (this.m_axis.getClass() == axisClass) {
                this.firePropertyChange("", new Boolean(false), new Boolean(true));
            } else {
                this.firePropertyChange("", new Boolean(true), new Boolean(false));
            }
        }
    }
}

