/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;

public abstract class RefDatabase {
    protected static final String[] SEARCH_PATH = new String[]{"", "refs/", "refs/tags/", "refs/heads/", "refs/remotes/"};
    public static final int MAX_SYMBOLIC_REF_DEPTH = 5;
    public static final String ALL = "";

    public abstract void create() throws IOException;

    public abstract void close();

    public abstract boolean isNameConflicting(String var1) throws IOException;

    @NonNull
    public Collection<String> getConflictingNames(String name2) throws IOException {
        Map<String, Ref> allRefs = this.getRefs(ALL);
        int lastSlash = name2.lastIndexOf(47);
        while (0 < lastSlash) {
            String needle = name2.substring(0, lastSlash);
            if (allRefs.containsKey(needle)) {
                return Collections.singletonList(needle);
            }
            lastSlash = name2.lastIndexOf(47, lastSlash - 1);
        }
        ArrayList<String> conflicting = new ArrayList<String>();
        String prefix = name2 + '/';
        for (String existing : allRefs.keySet()) {
            if (!existing.startsWith(prefix)) continue;
            conflicting.add(existing);
        }
        return conflicting;
    }

    @NonNull
    public abstract RefUpdate newUpdate(String var1, boolean var2) throws IOException;

    @NonNull
    public abstract RefRename newRename(String var1, String var2) throws IOException;

    @NonNull
    public BatchRefUpdate newBatchUpdate() {
        return new BatchRefUpdate(this);
    }

    public boolean performsAtomicTransactions() {
        return false;
    }

    @Nullable
    public abstract Ref getRef(String var1) throws IOException;

    @Nullable
    public Ref exactRef(String name2) throws IOException {
        Ref ref2 = this.getRef(name2);
        if (ref2 == null || !name2.equals(ref2.getName())) {
            return null;
        }
        return ref2;
    }

    @NonNull
    public Map<String, Ref> exactRef(String ... refs) throws IOException {
        HashMap<String, Ref> result = new HashMap<String, Ref>(refs.length);
        for (String name2 : refs) {
            Ref ref2 = this.exactRef(name2);
            if (ref2 == null) continue;
            result.put(name2, ref2);
        }
        return result;
    }

    @Nullable
    public Ref firstExactRef(String ... refs) throws IOException {
        for (String name2 : refs) {
            Ref ref2 = this.exactRef(name2);
            if (ref2 == null) continue;
            return ref2;
        }
        return null;
    }

    @NonNull
    public abstract Map<String, Ref> getRefs(String var1) throws IOException;

    @NonNull
    public abstract List<Ref> getAdditionalRefs() throws IOException;

    @NonNull
    public abstract Ref peel(Ref var1) throws IOException;

    public void refresh() {
    }

    @Nullable
    public static Ref findRef(Map<String, Ref> map2, String name2) {
        for (String prefix : SEARCH_PATH) {
            String fullname = prefix + name2;
            Ref ref2 = map2.get(fullname);
            if (ref2 == null) continue;
            return ref2;
        }
        return null;
    }
}

