/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.estimate;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.RangeStats;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;

public class EstimationParameters {
    private double _flatMins = 0.0;
    private double _gentleClimbMins = 0.0;
    private double _steepClimbMins;
    private double _gentleDescentMins = 0.0;
    private double _steepDescentMins;
    private boolean _parseFailed = false;
    private static final Unit KILOMETRES = UnitSetLibrary.UNITS_KILOMETRES;

    public EstimationParameters() {
        this.resetToDefaults();
    }

    public EstimationParameters(String string) {
        this.populateWithString(string);
        if (this._parseFailed) {
            this.resetToDefaults();
        }
    }

    public void resetToDefaults() {
        this._flatMins = 60.0;
        this._gentleClimbMins = 12.0;
        this._steepClimbMins = 18.0;
        this._gentleDescentMins = 0.0;
        this._steepDescentMins = 12.0;
        this._parseFailed = false;
    }

    public boolean sameAsDefaults() {
        EstimationParameters estimationParameters = new EstimationParameters();
        return this._flatMins == estimationParameters._flatMins && this._gentleClimbMins == estimationParameters._gentleClimbMins && this._steepClimbMins == estimationParameters._steepClimbMins && this._gentleDescentMins == estimationParameters._gentleDescentMins && this._steepDescentMins == estimationParameters._steepDescentMins;
    }

    private void populateWithString(String string) {
        if (string != null && !string.trim().equals("")) {
            Object object;
            String[] stringArray = string.trim().split(";");
            boolean bl = this._parseFailed = stringArray == null || stringArray.length != 5;
            if (!this._parseFailed) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = stringArray2[n2];
                    if (!EstimationParameters.isParamStringValid((String)object)) {
                        this._parseFailed = true;
                    }
                    ++n2;
                }
            }
            if (!this._parseFailed) {
                try {
                    object = NumberFormat.getNumberInstance(Locale.UK);
                    this._flatMins = ((NumberFormat)object).parse(stringArray[0]).doubleValue();
                    this._gentleClimbMins = ((NumberFormat)object).parse(stringArray[1]).doubleValue();
                    this._steepClimbMins = ((NumberFormat)object).parse(stringArray[2]).doubleValue();
                    this._gentleDescentMins = ((NumberFormat)object).parse(stringArray[3]).doubleValue();
                    this._steepDescentMins = ((NumberFormat)object).parse(stringArray[4]).doubleValue();
                }
                catch (Exception exception) {
                    this._parseFailed = true;
                }
            }
        } else {
            this._parseFailed = true;
        }
    }

    public void populateWithStrings(String string, String string2, String string3, String string4, String string5) {
        if (EstimationParameters.isParamStringValid(string) && EstimationParameters.isParamStringValid(string2) && EstimationParameters.isParamStringValid(string3) && EstimationParameters.isParamStringValid(string4) && EstimationParameters.isParamStringValid(string5)) {
            Unit unit = Config.getUnitSet().getDistanceUnit();
            Unit unit2 = Config.getUnitSet().getAltitudeUnit();
            double d = unit == KILOMETRES ? 1.0 : 1666.6666666666667 * unit.getMultFactorFromStd();
            double d2 = unit2.isStandard() ? 1.0 : 0.3333333333333333 * unit2.getMultFactorFromStd();
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            try {
                this._flatMins = numberFormat.parse(string).doubleValue() * d;
                this._gentleClimbMins = numberFormat.parse(string2).doubleValue() * d2;
                this._steepClimbMins = numberFormat.parse(string3).doubleValue() * d2;
                this._gentleDescentMins = numberFormat.parse(string4).doubleValue() * d2;
                this._steepDescentMins = numberFormat.parse(string5).doubleValue() * d2;
            }
            catch (Exception exception) {
                this._parseFailed = true;
            }
        } else {
            this._parseFailed = true;
        }
    }

    public void populateWithMetrics(double d, double d2, double d3, double d4, double d5) {
        this._flatMins = d;
        this._gentleClimbMins = d2;
        this._steepClimbMins = d3;
        this._gentleDescentMins = d4;
        this._steepDescentMins = d5;
    }

    private static boolean isParamStringValid(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isLetter(c)) {
                return false;
            }
            boolean bl4 = bl2 = c == '.' || c == ',';
            if (bl2 && bl3) {
                return false;
            }
            bl3 = bl2;
            bl = bl || Character.isDigit(c);
            ++n;
        }
        return bl;
    }

    public boolean isValid() {
        return !this._parseFailed;
    }

    public String[] getStrings() {
        Unit unit = Config.getUnitSet().getDistanceUnit();
        Unit unit2 = Config.getUnitSet().getAltitudeUnit();
        double d = unit == KILOMETRES ? 1.0 : 1666.6666666666667 * unit.getMultFactorFromStd();
        double d2 = unit2.isStandard() ? 1.0 : 0.3333333333333333 * unit2.getMultFactorFromStd();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).applyPattern("0.00");
        }
        return new String[]{numberFormat.format(this._flatMins / d), numberFormat.format(this._gentleClimbMins / d2), numberFormat.format(this._steepClimbMins / d2), numberFormat.format(this._gentleDescentMins / d2), numberFormat.format(this._steepDescentMins / d2)};
    }

    public static String getStandardDistance() {
        Unit unit = Config.getUnitSet().getDistanceUnit();
        return String.valueOf(unit == KILOMETRES ? "5 " : "3 ") + I18nManager.getText(unit.getShortnameKey());
    }

    public static String getStandardClimb() {
        Unit unit = Config.getUnitSet().getAltitudeUnit();
        return String.valueOf(unit.isStandard() ? "100 " : "300 ") + I18nManager.getText(unit.getShortnameKey());
    }

    public String toConfigString() {
        return EstimationParameters.twoDp(this._flatMins) + ";" + EstimationParameters.twoDp(this._gentleClimbMins) + ";" + EstimationParameters.twoDp(this._steepClimbMins) + ";" + EstimationParameters.twoDp(this._gentleDescentMins) + ";" + EstimationParameters.twoDp(this._steepDescentMins);
    }

    private static String twoDp(double d) {
        if (d < 0.0) {
            return "-" + EstimationParameters.twoDp(-d);
        }
        int n = (int)(d * 100.0 + 0.5);
        return n / 100 + "." + n % 100;
    }

    public double applyToStats(RangeStats rangeStats) {
        if (rangeStats == null || !rangeStats.isValid()) {
            return 0.0;
        }
        Unit unit = UnitSetLibrary.UNITS_METRES;
        return this._flatMins * rangeStats.getMovingDistanceKilometres() / 5.0 + this._gentleClimbMins * (double)rangeStats.getGentleAltitudeRange().getClimb(unit) / 100.0 + this._steepClimbMins * (double)rangeStats.getSteepAltitudeRange().getClimb(unit) / 100.0 + this._gentleDescentMins * (double)rangeStats.getGentleAltitudeRange().getDescent(unit) / 100.0 + this._steepDescentMins * (double)rangeStats.getSteepAltitudeRange().getDescent(unit) / 100.0;
    }

    public EstimationParameters combine(EstimationParameters estimationParameters, double d) {
        if (d < 0.0 || d > 1.0 || estimationParameters == null) {
            return null;
        }
        double d2 = 1.0 - d;
        EstimationParameters estimationParameters2 = new EstimationParameters();
        estimationParameters2._flatMins = d * this._flatMins + d2 * estimationParameters._flatMins;
        estimationParameters2._gentleClimbMins = d * this._gentleClimbMins + d2 * estimationParameters._gentleClimbMins;
        estimationParameters2._gentleDescentMins = d * this._gentleDescentMins + d2 * estimationParameters._gentleDescentMins;
        estimationParameters2._steepClimbMins = d * this._steepClimbMins + d2 * estimationParameters._steepClimbMins;
        estimationParameters2._steepDescentMins = d * this._steepDescentMins + d2 * estimationParameters._steepDescentMins;
        return estimationParameters2;
    }
}

