/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoLookupSrtm
implements UndoOperation {
    private DataPoint[] _points;
    private String[] _altitudes;

    public UndoLookupSrtm(TrackInfo trackInfo) {
        Track track = trackInfo.getTrack();
        int n = track.getNumPoints();
        this._points = new DataPoint[n];
        this._altitudes = new String[n];
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = track.getPoint(n2);
            if (!dataPoint.hasAltitude() || dataPoint.getAltitude().getValue() == 0) {
                this._points[n2] = dataPoint;
                if (dataPoint.hasAltitude()) {
                    this._altitudes[n2] = dataPoint.getFieldValue(Field.ALTITUDE);
                }
            }
            ++n2;
        }
    }

    public String getDescription() {
        return I18nManager.getText("undo.lookupsrtm");
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        int n = this._points.length;
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = this._points[n2];
            if (dataPoint != null && dataPoint.hasAltitude()) {
                if (this._altitudes[n2] == null) {
                    dataPoint.setFieldValue(Field.ALTITUDE, null, true);
                } else {
                    dataPoint.setFieldValue(Field.ALTITUDE, this._altitudes[n2], true);
                }
            }
            ++n2;
        }
        this._points = null;
        UpdateMessageBroker.informSubscribers();
    }
}

