/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities on the wrap.utils pakage


module gstreamer.ReferenceTimestampMeta;

private import glib.MemorySlice;
private import gobject.ObjectG;
private import gstreamer.Caps;
private import gstreamer.c.functions;
public  import gstreamer.c.types;
public  import gstreamerc.gstreamertypes;
private import gtkd.Loader;


/**
 * #GstReferenceTimestampMeta can be used to attach alternative timestamps and
 * possibly durations to a #GstBuffer. These are generally not according to
 * the pipeline clock and could be e.g. the NTP timestamp when the media was
 * captured.
 * 
 * The reference is stored as a #GstCaps in @reference. Examples of valid
 * references would be "timestamp/x-drivername-stream" for timestamps that are locally
 * generated by some driver named "drivername" when generating the stream,
 * e.g. based on a frame counter, or "timestamp/x-ntp, host=pool.ntp.org,
 * port=123" for timestamps based on a specific NTP server.
 *
 * Since: 1.14
 */
public struct ReferenceTimestampMeta
{

	/**
	 * Get the global #GstMetaInfo describing  the #GstReferenceTimestampMeta meta.
	 *
	 * Returns: The #GstMetaInfo
	 *
	 * Since: 1.14
	 */
	public static GstMetaInfo* getInfo()
	{
		return gst_reference_timestamp_meta_get_info();
	}
}
