/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class VFSDirectoryEntryTableModel
extends AbstractTableModel {
    Entry[] files;
    private List<ExtendedAttribute> extAttrs = new ArrayList<ExtendedAttribute>();
    private int sortColumnIndex = 0;
    private boolean ascending = true;

    public void setRoot(VFS vFS, List<VFSFile> list) {
        this.extAttrs.clear();
        this.addExtendedAttributes(vFS);
        this.files = new Entry[list.size()];
        for (int i = 0; i < this.files.length; ++i) {
            this.files[i] = new Entry(list.get(i), 0);
        }
        Arrays.sort(this.files, new EntryCompare(this.getSortAttribute(this.sortColumnIndex), this.ascending));
        this.fireTableStructureChanged();
    }

    public int expand(VFS vFS, Entry entry, List<VFSFile> list) {
        int n = -1;
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i] != entry) continue;
            n = i;
        }
        if (n != -1) {
            this.collapse(vFS, n);
        }
        this.addExtendedAttributes(vFS);
        entry.expanded = true;
        if (list != null) {
            int n2;
            Entry[] entryArray = new Entry[this.files.length + list.size()];
            Entry[] entryArray2 = new Entry[list.size()];
            for (n2 = 0; n2 < list.size(); ++n2) {
                entryArray2[n2] = new Entry(list.get(n2), entry.level + 1, entry);
            }
            Arrays.sort(entryArray2, new EntryCompare(this.getSortAttribute(this.sortColumnIndex), this.ascending));
            n2 = n + 1;
            System.arraycopy(this.files, 0, entryArray, 0, n2);
            System.arraycopy(entryArray2, 0, entryArray, n2, list.size());
            System.arraycopy(this.files, n2, entryArray, n2 + list.size(), this.files.length - n2);
            this.files = entryArray;
        }
        this.fireTableStructureChanged();
        return n;
    }

    public void collapse(VFS vFS, int n) {
        Entry[] entryArray;
        int n2;
        Entry entry = this.files[n];
        if (!entry.expanded) {
            return;
        }
        entry.expanded = false;
        for (n2 = n + 1; n2 < this.files.length; ++n2) {
            entryArray = this.files[n2];
            if (entryArray.level <= entry.level) break;
            if (!entryArray.expanded) continue;
            this.removeExtendedAttributes(VFSManager.getVFSForPath(entryArray.dirEntry.getPath()));
        }
        this.removeExtendedAttributes(vFS);
        entryArray = new Entry[this.files.length - n2 + n + 1];
        System.arraycopy(this.files, 0, entryArray, 0, n + 1);
        System.arraycopy(this.files, n2, entryArray, n + 1, this.files.length - n2);
        this.files = entryArray;
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return 1 + this.extAttrs.size();
    }

    @Override
    public int getRowCount() {
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return jEdit.getProperty("vfs.browser.name");
        }
        return jEdit.getProperty("vfs.browser." + this.getExtendedAttribute(n));
    }

    public Class getColumnClass(int n) {
        return Entry.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.files == null) {
            return null;
        }
        return this.files[n];
    }

    public boolean getAscending() {
        return this.ascending;
    }

    public int getSortColumnIndex() {
        return this.sortColumnIndex;
    }

    public String getSortAttribute(int n) {
        return n == 0 ? "name" : this.getExtendedAttribute(n);
    }

    public boolean sortByColumn(int n) {
        this.ascending = this.sortColumnIndex != n || !this.ascending;
        String string = this.getSortAttribute(n);
        if (string == "status") {
            return false;
        }
        Arrays.sort(this.files, new EntryCompare(string, this.ascending));
        this.sortColumnIndex = n;
        this.fireTableStructureChanged();
        return true;
    }

    public String getExtendedAttribute(int n) {
        return this.extAttrs.get((int)(n - 1)).name;
    }

    public int getColumnWidth(int n) {
        String string = this.getExtendedAttribute(n);
        return jEdit.getIntegerProperty("vfs.browser." + string + ".width", 100);
    }

    public void saveColumnWidth(int n, int n2) {
        String string = this.getExtendedAttribute(n);
        jEdit.setIntegerProperty("vfs.browser." + string + ".width", n2);
    }

    protected void columnMoved(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n < 1 || n > this.getColumnCount()) {
            return;
        }
        if (n2 < 1 || n2 > this.getColumnCount()) {
            return;
        }
        ExtendedAttribute extendedAttribute = this.extAttrs.remove(n - 1);
        this.extAttrs.add(n2 - 1, extendedAttribute);
        if (this.sortColumnIndex == n) {
            this.sortColumnIndex = n2;
        } else if (this.sortColumnIndex == n2) {
            this.sortColumnIndex = n;
        }
    }

    public VFSFile[] getFiles() {
        VFSFile[] vFSFileArray = new VFSFile[this.files.length];
        for (int i = 0; i < vFSFileArray.length; ++i) {
            vFSFileArray[i] = this.files[i].dirEntry;
        }
        return vFSFileArray;
    }

    private void addExtendedAttributes(VFS vFS) {
        String[] stringArray = vFS.getExtendedAttributes();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (ExtendedAttribute extendedAttribute : this.extAttrs) {
                if (!stringArray[i].equals(extendedAttribute.name)) continue;
                ++extendedAttribute.ref;
                continue block0;
            }
            this.extAttrs.add(new ExtendedAttribute(stringArray[i]));
        }
    }

    private void removeExtendedAttributes(VFS vFS) {
        String[] stringArray = vFS.getExtendedAttributes();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            Iterator<ExtendedAttribute> iterator = this.extAttrs.iterator();
            while (iterator.hasNext()) {
                ExtendedAttribute extendedAttribute = iterator.next();
                if (!stringArray[i].equals(extendedAttribute.name)) continue;
                if (--extendedAttribute.ref != 0) continue block0;
                iterator.remove();
                continue block0;
            }
            Log.log(7, this, "We forgot about " + stringArray[i]);
        }
    }

    static class EntryCompare
    implements Comparator<Entry> {
        private boolean sortIgnoreCase;
        private boolean sortMixFilesAndDirs = jEdit.getBooleanProperty("vfs.browser.sortMixFilesAndDirs");
        private boolean sortAscending;
        private String sortAttribute;

        EntryCompare(String string, boolean bl) {
            this.sortIgnoreCase = jEdit.getBooleanProperty("vfs.browser.sortIgnoreCase");
            this.sortAscending = bl;
            this.sortAttribute = string;
        }

        @Override
        public int compare(Entry entry, Entry entry2) {
            if (entry.level < entry2.level) {
                return this.compare(entry, entry2.parent);
            }
            if (entry.level > entry2.level) {
                return this.compare(entry.parent, entry2);
            }
            if (entry.parent != entry2.parent) {
                return this.compare(entry.parent, entry2.parent);
            }
            VFSFile vFSFile = entry.dirEntry;
            VFSFile vFSFile2 = entry2.dirEntry;
            if (!this.sortMixFilesAndDirs && vFSFile.getType() != vFSFile2.getType()) {
                return vFSFile2.getType() - vFSFile.getType();
            }
            int n = this.sortAttribute == "modified" ? Long.valueOf(vFSFile.getModified()).compareTo(vFSFile2.getModified()) : (this.sortAttribute == "size" ? Long.valueOf(vFSFile.getLength()).compareTo(vFSFile2.getLength()) : (this.sortAttribute == "type" ? StandardUtilities.compareStrings(entry.extension, entry2.extension, this.sortIgnoreCase) : StandardUtilities.compareStrings(vFSFile.getName(), vFSFile2.getName(), this.sortIgnoreCase)));
            return this.sortAscending ? n : -n;
        }
    }

    static class ExtendedAttribute {
        int ref;
        String name;

        ExtendedAttribute(String string) {
            this.name = string;
            this.ref = 1;
        }
    }

    static class Entry {
        VFSFile dirEntry;
        boolean expanded;
        int level;
        Entry parent;
        String extension;

        Entry(VFSFile vFSFile, int n, Entry entry) {
            this(vFSFile, n);
            this.parent = entry;
        }

        Entry(VFSFile vFSFile, int n) {
            this.dirEntry = vFSFile;
            this.level = n;
            this.extension = MiscUtilities.getFileExtension(vFSFile.getName());
        }
    }
}

