/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.network.SSLEngineManager;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.FdOutStream;
import com.tigervnc.rdr.OutStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;

public class TLSOutStream
extends OutStream {
    static final int defaultBufSize = 16384;
    private SSLEngineManager manager;
    private FdOutStream out;
    private int start;
    private int offset;
    private int bufSize;

    public TLSOutStream(OutStream outStream, SSLEngineManager sSLEngineManager) {
        this.manager = sSLEngineManager;
        this.out = (FdOutStream)outStream;
        SSLSession sSLSession = this.manager.getSession();
        this.bufSize = sSLSession.getApplicationBufferSize();
        this.b = new byte[this.bufSize];
        this.start = 0;
        this.offset = 0;
        this.ptr = 0;
        this.end = this.start + this.bufSize;
    }

    @Override
    public int length() {
        return this.offset + this.ptr - this.start;
    }

    @Override
    public void flush() {
        int n = this.start;
        while (n < this.ptr) {
            int n2 = this.writeTLS(this.b, n, this.ptr - n);
            n += n2;
            this.offset += n2;
        }
        this.ptr = this.start;
    }

    @Override
    protected int overrun(int n, int n2) {
        if (n > this.bufSize) {
            throw new Exception("TLSOutStream overrun: max itemSize exceeded");
        }
        this.flush();
        if (n * n2 > this.end - this.ptr) {
            n2 = (this.end - this.ptr) / n;
        }
        return n2;
    }

    protected int writeTLS(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            n3 = this.manager.write(ByteBuffer.wrap(byArray, n, n2), n2);
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        return n3;
    }
}

