/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.Cursor;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.ScreenSet;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConnParams {
    private static final int subsampleUndefined = -1;
    private static final int subsampleNone = 0;
    private static final int subsampleGray = 1;
    private static final int subsample2X = 2;
    private static final int subsample4X = 3;
    private static final int subsample8X = 4;
    private static final int subsample16X = 5;
    public int majorVersion = 0;
    public int minorVersion = 0;
    public int width = 0;
    public int height = 0;
    public ScreenSet screenLayout;
    public boolean useCopyRect = false;
    public boolean supportsLocalCursor = false;
    public boolean supportsLocalXCursor = false;
    public boolean supportsLocalCursorWithAlpha = false;
    public boolean supportsDesktopResize = false;
    public boolean supportsExtendedDesktopSize = false;
    public boolean supportsDesktopRename = false;
    public boolean supportsLastRect = false;
    public boolean supportsClientRedirect = false;
    public boolean supportsSetDesktopSize = false;
    public boolean supportsFence = false;
    public boolean supportsContinuousUpdates = false;
    public int compressLevel = 6;
    public int qualityLevel = -1;
    public int fineQualityLevel = -1;
    public int subsampling = -1;
    private PixelFormat pf_;
    private String name_ = null;
    private Cursor cursor_;
    private ArrayList encodings_ = new ArrayList();
    private StringBuilder verStr;
    private int verStrPos = 0;

    public ConnParams() {
        this.screenLayout = new ScreenSet();
        this.setName("");
    }

    public boolean readVersion(InStream inStream, AtomicBoolean atomicBoolean) {
        if (this.verStrPos >= 12) {
            return false;
        }
        this.verStr = new StringBuilder(13);
        while (inStream.checkNoWait(1) && this.verStrPos < 12) {
            this.verStr.insert(this.verStrPos++, (char)inStream.readU8());
        }
        if (this.verStrPos < 12) {
            atomicBoolean.set(false);
            return true;
        }
        atomicBoolean.set(true);
        this.verStr.insert(12, '0');
        this.verStrPos = 0;
        if (this.verStr.toString().matches("RFB \\d{3}\\.\\d{3}\\n0")) {
            this.majorVersion = Integer.parseInt(this.verStr.substring(4, 7));
            this.minorVersion = Integer.parseInt(this.verStr.substring(8, 11));
            return true;
        }
        return false;
    }

    public void writeVersion(OutStream outStream) {
        String string = String.format("RFB %03d.%03d\n", this.majorVersion, this.minorVersion);
        outStream.writeBytes(string.getBytes(), 0, 12);
        outStream.flush();
    }

    public void setVersion(int n, int n2) {
        this.majorVersion = n;
        this.minorVersion = n2;
    }

    public boolean isVersion(int n, int n2) {
        return this.majorVersion == n && this.minorVersion == n2;
    }

    public boolean beforeVersion(int n, int n2) {
        return this.majorVersion < n || this.majorVersion == n && this.minorVersion < n2;
    }

    public boolean afterVersion(int n, int n2) {
        return !this.beforeVersion(n, n2 + 1);
    }

    public PixelFormat pf() {
        return this.pf_;
    }

    public void setPF(PixelFormat pixelFormat) {
        this.pf_ = pixelFormat;
        if (pixelFormat.bpp != 8 && pixelFormat.bpp != 16 && pixelFormat.bpp != 32) {
            throw new Exception("setPF: not 8, 16 or 32 bpp?");
        }
    }

    public String name() {
        return this.name_;
    }

    public void setName(String string) {
        this.name_ = string;
    }

    public boolean supportsEncoding(int n) {
        return this.encodings_.indexOf(n) != -1;
    }

    public void setEncodings(int n, int[] nArray) {
        this.useCopyRect = false;
        this.supportsLocalCursor = false;
        this.supportsLocalCursorWithAlpha = false;
        this.supportsDesktopResize = false;
        this.supportsExtendedDesktopSize = false;
        this.supportsLocalXCursor = false;
        this.supportsLastRect = false;
        this.compressLevel = -1;
        this.qualityLevel = -1;
        this.fineQualityLevel = -1;
        this.subsampling = -1;
        this.encodings_.clear();
        this.encodings_.add(0);
        for (int i = n - 1; i >= 0; --i) {
            switch (nArray[i]) {
                case 1: {
                    this.useCopyRect = true;
                    break;
                }
                case -239: {
                    this.supportsLocalCursor = true;
                    break;
                }
                case -240: {
                    this.supportsLocalXCursor = true;
                    break;
                }
                case -314: {
                    this.supportsLocalCursorWithAlpha = true;
                    break;
                }
                case -223: {
                    this.supportsDesktopResize = true;
                    break;
                }
                case -308: {
                    this.supportsExtendedDesktopSize = true;
                    break;
                }
                case -307: {
                    this.supportsDesktopRename = true;
                    break;
                }
                case -224: {
                    this.supportsLastRect = true;
                    break;
                }
                case -312: {
                    this.supportsFence = true;
                    break;
                }
                case -313: {
                    this.supportsContinuousUpdates = true;
                    break;
                }
                case -311: {
                    this.supportsClientRedirect = true;
                    break;
                }
                case -768: {
                    this.subsampling = 0;
                    break;
                }
                case -765: {
                    this.subsampling = 1;
                    break;
                }
                case -766: {
                    this.subsampling = 2;
                    break;
                }
                case -767: {
                    this.subsampling = 3;
                    break;
                }
                case -764: {
                    this.subsampling = 4;
                    break;
                }
                case -763: {
                    this.subsampling = 5;
                }
            }
            if (nArray[i] >= -256 && nArray[i] <= -247) {
                this.compressLevel = nArray[i] - -256;
            }
            if (nArray[i] >= -32 && nArray[i] <= -23) {
                this.qualityLevel = nArray[i] - -32;
            }
            if (nArray[i] >= -512 && nArray[i] <= -412) {
                this.fineQualityLevel = nArray[i] - -512;
            }
            if (nArray[i] <= 0) continue;
            this.encodings_.add(nArray[i]);
        }
    }
}

