/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.ObjectFloatHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.zen.ElectMasterService;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.gateway.TransportNodesListGatewayMetaState;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndicesService;

public class Gateway {
    private static final Logger logger = LogManager.getLogger(Gateway.class);
    private final ClusterService clusterService;
    private final TransportNodesListGatewayMetaState listGatewayMetaState;
    private final int minimumMasterNodes;
    private final IndicesService indicesService;

    public Gateway(Settings settings, ClusterService clusterService, TransportNodesListGatewayMetaState listGatewayMetaState, IndicesService indicesService) {
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.listGatewayMetaState = listGatewayMetaState;
        this.minimumMasterNodes = ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.get(settings);
    }

    public void performStateRecovery(GatewayStateRecoveredListener listener) throws GatewayException {
        Object[] nodesIds = (String[])this.clusterService.state().nodes().getMasterNodes().keys().toArray(String.class);
        logger.trace("performing state recovery from {}", (Object)Arrays.toString(nodesIds));
        TransportNodesListGatewayMetaState.NodesGatewayMetaState nodesState = this.listGatewayMetaState.list((String[])nodesIds, null).actionGet();
        int requiredAllocation = Math.max(1, this.minimumMasterNodes);
        if (nodesState.hasFailures()) {
            for (FailedNodeException failedNodeException : nodesState.failures()) {
                logger.warn("failed to fetch state from node", (Throwable)failedNodeException);
            }
        }
        ObjectFloatHashMap indices = new ObjectFloatHashMap();
        MetaData electedGlobalState = null;
        int found = 0;
        for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
            if (nodeState.metaData() == null) continue;
            ++found;
            if (electedGlobalState == null) {
                electedGlobalState = nodeState.metaData();
            } else if (nodeState.metaData().version() > electedGlobalState.version()) {
                electedGlobalState = nodeState.metaData();
            }
            for (ObjectCursor cursor : nodeState.metaData().indices().values()) {
                indices.addTo((Object)((IndexMetaData)cursor.value).getIndex(), 1.0f);
            }
        }
        if (found < requiredAllocation) {
            listener.onFailure("found [" + found + "] metadata states, required [" + requiredAllocation + "]");
            return;
        }
        MetaData.Builder metaDataBuilder = MetaData.builder(electedGlobalState).removeAllIndices();
        assert (!indices.containsKey(null));
        Object[] keys = indices.keys;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            Index index = (Index)keys[i];
            IndexMetaData electedIndexMetaData = null;
            int indexMetaDataCount = 0;
            for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
                IndexMetaData indexMetaData;
                if (nodeState.metaData() == null || (indexMetaData = nodeState.metaData().index(index)) == null) continue;
                if (electedIndexMetaData == null) {
                    electedIndexMetaData = indexMetaData;
                } else if (indexMetaData.getVersion() > electedIndexMetaData.getVersion()) {
                    electedIndexMetaData = indexMetaData;
                }
                ++indexMetaDataCount;
            }
            if (electedIndexMetaData == null) continue;
            if (indexMetaDataCount < requiredAllocation) {
                logger.debug("[{}] found [{}], required [{}], not adding", (Object)index, (Object)indexMetaDataCount, (Object)requiredAllocation);
            }
            metaDataBuilder.put(electedIndexMetaData, false);
        }
        ClusterState recoveredState = Function.identity().andThen(state -> ClusterStateUpdaters.upgradeAndArchiveUnknownOrInvalidSettings(state, this.clusterService.getClusterSettings())).apply(ClusterState.builder(this.clusterService.getClusterName()).metaData(metaDataBuilder).build());
        listener.onSuccess(recoveredState);
    }

    public static interface GatewayStateRecoveredListener {
        public void onSuccess(ClusterState var1);

        public void onFailure(String var1);
    }
}

