/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;

class ErrorOutputDispatchingListener
implements OutputEventListener {
    private final OutputEventListener stderrChain;
    private final OutputEventListener stdoutChain;
    private final boolean redirectStderr;

    public ErrorOutputDispatchingListener(OutputEventListener stderrChain, OutputEventListener stdoutChain, boolean redirectStderr) {
        this.stderrChain = stderrChain;
        this.stdoutChain = stdoutChain;
        this.redirectStderr = redirectStderr;
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event.getLogLevel() == null) {
            this.stderrChain.onOutput(event);
            this.stdoutChain.onOutput(event);
        } else if (event.getLogLevel() != LogLevel.ERROR) {
            this.stdoutChain.onOutput(event);
        } else if (this.redirectStderr) {
            this.stdoutChain.onOutput(event);
        } else {
            this.stderrChain.onOutput(event);
        }
    }
}

