/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.openstreetmap.josm.actions.DownloadAlongAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongPanel;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DownloadAlongTrackAction
extends DownloadAlongAction {
    private static final int NEAR_TRACK = 0;
    private static final int NEAR_WAYPOINTS = 1;
    private static final int NEAR_BOTH = 2;
    private static final String PREF_DOWNLOAD_ALONG_TRACK_OSM = "downloadAlongTrack.download.osm";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_GPS = "downloadAlongTrack.download.gps";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_DISTANCE = "downloadAlongTrack.distance";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_AREA = "downloadAlongTrack.area";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_NEAR = "downloadAlongTrack.near";
    private final transient GpxData data;

    public DownloadAlongTrackAction(GpxData data) {
        super(I18n.tr("Download from OSM along this track", new Object[0]), "downloadalongtrack", null, null, false);
        this.data = data;
    }

    PleaseWaitRunnable createTask() {
        final DownloadAlongPanel panel = new DownloadAlongPanel(PREF_DOWNLOAD_ALONG_TRACK_OSM, PREF_DOWNLOAD_ALONG_TRACK_GPS, PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, PREF_DOWNLOAD_ALONG_TRACK_AREA, PREF_DOWNLOAD_ALONG_TRACK_NEAR);
        if (0 != panel.showInDownloadDialog(I18n.tr("Download from OSM along this track", new Object[0]), HelpUtil.ht("/Action/DownloadAlongTrack"))) {
            return null;
        }
        final int near = panel.getNear();
        double latsum = 0.0;
        int latcnt = 0;
        if (near == 0 || near == 2) {
            for (GpxTrack trk : this.data.tracks) {
                for (GpxTrackSegment segment : trk.getSegments()) {
                    for (WayPoint p : segment.getWayPoints()) {
                        latsum += p.lat();
                        ++latcnt;
                    }
                }
            }
        }
        if (near == 1 || near == 2) {
            for (WayPoint p : this.data.waypoints) {
                latsum += p.getCoor().lat();
                ++latcnt;
            }
        }
        if (latcnt == 0) {
            return null;
        }
        double avglat = latsum / (double)latcnt;
        double scale = Math.cos(Utils.toRadians(avglat));
        final double bufferDist = panel.getDistance();
        final double maxArea = panel.getArea() / 10000.0 / scale;
        final double bufferY = bufferDist / 100000.0;
        final double bufferX = bufferY / scale;
        final int totalTicks = latcnt;
        final boolean displayProgress = totalTicks > 200000 && bufferY < 0.01;
        class CalculateDownloadArea
        extends PleaseWaitRunnable {
            private final Path2D path;
            private boolean cancel;
            private int ticks;
            private final Rectangle2D r;

            CalculateDownloadArea() {
                super(I18n.tr("Calculating Download Area", new Object[0]), bl ? null : NullProgressMonitor.INSTANCE, false);
                this.path = new Path2D.Double();
                this.r = new Rectangle2D.Double();
            }

            @Override
            protected void cancel() {
                this.cancel = true;
            }

            @Override
            protected void finish() {
            }

            @Override
            protected void afterFinish() {
                if (this.cancel) {
                    return;
                }
                DownloadAlongTrackAction.confirmAndDownloadAreas(new Area(this.path), maxArea, panel.isDownloadOsmData(), panel.isDownloadGpxData(), I18n.tr("Download from OSM along this track", new Object[0]), this.progressMonitor);
            }

            private void tick() {
                ++this.ticks;
                if (this.ticks % 100 == 0) {
                    this.progressMonitor.worked(100);
                }
            }

            private LatLon calcAreaForWayPoint(WayPoint p, LatLon previous) {
                this.tick();
                LatLon c = p.getCoor();
                if (previous == null || c.greatCircleDistance(previous) > bufferDist) {
                    this.r.setRect(c.lon() - bufferX, c.lat() - bufferY, 2.0 * bufferX, 2.0 * bufferY);
                    this.path.append(this.r, false);
                    return c;
                }
                return previous;
            }

            @Override
            protected void realRun() {
                this.progressMonitor.setTicksCount(totalTicks);
                LatLon previous = null;
                if (near == 0 || near == 2) {
                    for (GpxTrack trk : ((DownloadAlongTrackAction)DownloadAlongTrackAction.this).data.tracks) {
                        for (GpxTrackSegment segment : trk.getSegments()) {
                            for (WayPoint p : segment.getWayPoints()) {
                                if (this.cancel) {
                                    return;
                                }
                                previous = this.calcAreaForWayPoint(p, previous);
                            }
                        }
                    }
                }
                if (near == 1 || near == 2) {
                    for (WayPoint p : ((DownloadAlongTrackAction)DownloadAlongTrackAction.this).data.waypoints) {
                        if (this.cancel) {
                            return;
                        }
                        previous = this.calcAreaForWayPoint(p, previous);
                    }
                }
            }
        }
        return new CalculateDownloadArea();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PleaseWaitRunnable task = this.createTask();
        if (task != null) {
            MainApplication.worker.submit(task);
        }
    }
}

