/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ClassReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "booleanClass", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "doubleClass", "intClass", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;", "primitiveClassProperties", "", "primitiveClassesObject", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "callGetKClass", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "typeArgument", "callGetKClassFromExpression", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "callJsClass", "type", "getPrimitiveClass", "target", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.js"})
public final class ClassReferenceLowering
implements FileLoweringPass {
    private final JsIntrinsics intrinsics;
    private final IrClass primitiveClassesObject;
    private final List<IrProperty> primitiveClassProperties;
    private final IrProperty booleanClass;
    private final IrProperty intClass;
    private final IrProperty doubleClass;
    @NotNull
    private final JsIrBackendContext context;

    private final IrCall callGetKClassFromExpression(IrType returnType2, IrType typeArgument, IrExpression argument) {
        IrCall irCall = JsIrBuilder.INSTANCE.buildCall(this.intrinsics.getJsGetKClassFromExpression(), returnType2, CollectionsKt.listOf(typeArgument));
        boolean bl = false;
        boolean bl2 = false;
        IrCall $this$apply = irCall;
        boolean bl3 = false;
        $this$apply.putValueArgument(0, argument);
        return irCall;
    }

    private final IrCall getPrimitiveClass(IrSimpleFunction target, IrType returnType2) {
        IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, target.getSymbol(), returnType2, null, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCall $this$apply = irCall;
        boolean bl3 = false;
        $this$apply.setDispatchReceiver(JsIrBuilder.INSTANCE.buildGetObjectValue(IrUtilsKt.getDefaultType(this.primitiveClassesObject), (IrClassSymbol)this.primitiveClassesObject.getSymbol()));
        return irCall;
    }

    private final IrCall callGetKClass(IrType returnType2, IrType typeArgument) {
        IrCall irCall;
        if (IrTypePredicatesKt.isBoolean(typeArgument)) {
            IrSimpleFunction irSimpleFunction = this.booleanClass.getGetter();
            if (irSimpleFunction == null) {
                Intrinsics.throwNpe();
            }
            irCall = this.getPrimitiveClass(irSimpleFunction, returnType2);
        } else if (IrTypePredicatesKt.isByte(typeArgument)) {
            IrSimpleFunction irSimpleFunction = this.intClass.getGetter();
            if (irSimpleFunction == null) {
                Intrinsics.throwNpe();
            }
            irCall = this.getPrimitiveClass(irSimpleFunction, returnType2);
        } else if (IrTypePredicatesKt.isShort(typeArgument)) {
            IrSimpleFunction irSimpleFunction = this.intClass.getGetter();
            if (irSimpleFunction == null) {
                Intrinsics.throwNpe();
            }
            irCall = this.getPrimitiveClass(irSimpleFunction, returnType2);
        } else if (IrTypePredicatesKt.isInt(typeArgument)) {
            IrSimpleFunction irSimpleFunction = this.intClass.getGetter();
            if (irSimpleFunction == null) {
                Intrinsics.throwNpe();
            }
            irCall = this.getPrimitiveClass(irSimpleFunction, returnType2);
        } else if (IrTypePredicatesKt.isFloat(typeArgument)) {
            IrSimpleFunction irSimpleFunction = this.doubleClass.getGetter();
            if (irSimpleFunction == null) {
                Intrinsics.throwNpe();
            }
            irCall = this.getPrimitiveClass(irSimpleFunction, returnType2);
        } else if (IrTypePredicatesKt.isDouble(typeArgument)) {
            IrSimpleFunction irSimpleFunction = this.doubleClass.getGetter();
            if (irSimpleFunction == null) {
                Intrinsics.throwNpe();
            }
            irCall = this.getPrimitiveClass(irSimpleFunction, returnType2);
        } else {
            IrCall irCall2 = JsIrBuilder.INSTANCE.buildCall(this.intrinsics.getJsGetKClass(), returnType2, CollectionsKt.listOf(typeArgument));
            boolean bl = false;
            boolean bl2 = false;
            IrCall $this$apply = irCall2;
            boolean bl3 = false;
            $this$apply.putValueArgument(0, this.callJsClass(typeArgument));
            irCall = irCall2;
        }
        return irCall;
    }

    private final IrCall callJsClass(IrType type2) {
        return JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.intrinsics.getJsClass(), null, CollectionsKt.listOf(type2), 2, null);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ ClassReferenceLowering this$0;

            @NotNull
            public IrCall visitGetClass(@NotNull IrGetClass expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                return ClassReferenceLowering.access$callGetKClassFromExpression(this.this$0, expression2.getType(), expression2.getArgument().getType(), expression2.getArgument().transform(this, null));
            }

            @NotNull
            public IrCall visitClassReference(@NotNull IrClassReference expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                return ClassReferenceLowering.access$callGetKClass(this.this$0, expression2.getType(), IrTypesKt.makeNotNull$default(expression2.getClassType(), false, 1, null));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public ClassReferenceLowering(@NotNull JsIrBackendContext context) {
        IrProperty it;
        Iterable $this$single$iv;
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.intrinsics = this.context.getIntrinsics();
        this.primitiveClassesObject = this.context.getPrimitiveClassesObject();
        this.primitiveClassProperties = this.context.getPrimitiveClassProperties();
        Iterable iterable = this.primitiveClassProperties;
        ClassReferenceLowering classReferenceLowering = this;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrProperty)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName(), Name.identifier("booleanClass"))) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object var11_11 = single$iv;
        classReferenceLowering.booleanClass = var11_11;
        $this$single$iv = this.primitiveClassProperties;
        classReferenceLowering = this;
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrProperty)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName(), Name.identifier("intClass"))) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        var11_11 = single$iv;
        classReferenceLowering.intClass = var11_11;
        $this$single$iv = this.primitiveClassProperties;
        classReferenceLowering = this;
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrProperty)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName(), Name.identifier("doubleClass"))) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        var11_11 = single$iv;
        classReferenceLowering.doubleClass = var11_11;
    }

    public static final /* synthetic */ IrCall access$callGetKClassFromExpression(ClassReferenceLowering $this, IrType returnType2, IrType typeArgument, IrExpression argument) {
        return $this.callGetKClassFromExpression(returnType2, typeArgument, argument);
    }

    public static final /* synthetic */ IrCall access$callGetKClass(ClassReferenceLowering $this, IrType returnType2, IrType typeArgument) {
        return $this.callGetKClass(returnType2, typeArgument);
    }
}

