# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# @generated
# flake8: noqa
# pylint: skip-file
try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (ImportError, SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

try:
    from . import (
        common,
        file_requests,
        files,
        sharing,
        team,
        team_common,
        team_policies,
        users_common,
    )
except (ImportError, SystemError, ValueError):
    import common
    import file_requests
    import files
    import sharing
    import team
    import team_common
    import team_policies
    import users_common

class AccessMethodLogInfo(bb.Union):
    """
    Indicates the method in which the action was performed.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar SessionLogInfo end_user: End user session details.
    :ivar WebSessionLogInfo sign_in_as: Sign in as session details.
    :ivar WebSessionLogInfo content_manager: Content manager session details.
    :ivar WebSessionLogInfo admin_console: Admin console session details.
    :ivar ApiSessionLogInfo api: Api session details.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def end_user(cls, val):
        """
        Create an instance of this class set to the ``end_user`` tag with value
        ``val``.

        :param SessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('end_user', val)

    @classmethod
    def sign_in_as(cls, val):
        """
        Create an instance of this class set to the ``sign_in_as`` tag with
        value ``val``.

        :param WebSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('sign_in_as', val)

    @classmethod
    def content_manager(cls, val):
        """
        Create an instance of this class set to the ``content_manager`` tag with
        value ``val``.

        :param WebSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('content_manager', val)

    @classmethod
    def admin_console(cls, val):
        """
        Create an instance of this class set to the ``admin_console`` tag with
        value ``val``.

        :param WebSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('admin_console', val)

    @classmethod
    def api(cls, val):
        """
        Create an instance of this class set to the ``api`` tag with value
        ``val``.

        :param ApiSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('api', val)

    def is_end_user(self):
        """
        Check if the union tag is ``end_user``.

        :rtype: bool
        """
        return self._tag == 'end_user'

    def is_sign_in_as(self):
        """
        Check if the union tag is ``sign_in_as``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as'

    def is_content_manager(self):
        """
        Check if the union tag is ``content_manager``.

        :rtype: bool
        """
        return self._tag == 'content_manager'

    def is_admin_console(self):
        """
        Check if the union tag is ``admin_console``.

        :rtype: bool
        """
        return self._tag == 'admin_console'

    def is_api(self):
        """
        Check if the union tag is ``api``.

        :rtype: bool
        """
        return self._tag == 'api'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_end_user(self):
        """
        End user session details.

        Only call this if :meth:`is_end_user` is true.

        :rtype: SessionLogInfo
        """
        if not self.is_end_user():
            raise AttributeError("tag 'end_user' not set")
        return self._value

    def get_sign_in_as(self):
        """
        Sign in as session details.

        Only call this if :meth:`is_sign_in_as` is true.

        :rtype: WebSessionLogInfo
        """
        if not self.is_sign_in_as():
            raise AttributeError("tag 'sign_in_as' not set")
        return self._value

    def get_content_manager(self):
        """
        Content manager session details.

        Only call this if :meth:`is_content_manager` is true.

        :rtype: WebSessionLogInfo
        """
        if not self.is_content_manager():
            raise AttributeError("tag 'content_manager' not set")
        return self._value

    def get_admin_console(self):
        """
        Admin console session details.

        Only call this if :meth:`is_admin_console` is true.

        :rtype: WebSessionLogInfo
        """
        if not self.is_admin_console():
            raise AttributeError("tag 'admin_console' not set")
        return self._value

    def get_api(self):
        """
        Api session details.

        Only call this if :meth:`is_api` is true.

        :rtype: ApiSessionLogInfo
        """
        if not self.is_api():
            raise AttributeError("tag 'api' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccessMethodLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccessMethodLogInfo(%r, %r)' % (self._tag, self._value)

AccessMethodLogInfo_validator = bv.Union(AccessMethodLogInfo)

class AccountCaptureAvailability(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    unavailable = None
    # Attribute is overwritten below the class definition
    available = None
    # Attribute is overwritten below the class definition
    other = None

    def is_unavailable(self):
        """
        Check if the union tag is ``unavailable``.

        :rtype: bool
        """
        return self._tag == 'unavailable'

    def is_available(self):
        """
        Check if the union tag is ``available``.

        :rtype: bool
        """
        return self._tag == 'available'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureAvailability, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureAvailability(%r, %r)' % (self._tag, self._value)

AccountCaptureAvailability_validator = bv.Union(AccountCaptureAvailability)

class AccountCaptureChangeAvailabilityDetails(bb.Struct):
    """
    Granted/revoked option to enable account capture on team domains.

    :ivar new_value: New account capture availabilty value.
    :ivar previous_value: Previous account capture availabilty value. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New account capture availabilty value.

        :rtype: AccountCaptureAvailability
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous account capture availabilty value. Might be missing due to
        historical data gap.

        :rtype: AccountCaptureAvailability
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureChangeAvailabilityDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureChangeAvailabilityDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

AccountCaptureChangeAvailabilityDetails_validator = bv.Struct(AccountCaptureChangeAvailabilityDetails)

class AccountCaptureChangeAvailabilityType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureChangeAvailabilityType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureChangeAvailabilityType(description={!r})'.format(
            self._description_value,
        )

AccountCaptureChangeAvailabilityType_validator = bv.Struct(AccountCaptureChangeAvailabilityType)

class AccountCaptureChangePolicyDetails(bb.Struct):
    """
    Changed account capture setting on team domain.

    :ivar new_value: New account capture policy.
    :ivar previous_value: Previous account capture policy. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New account capture policy.

        :rtype: AccountCapturePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous account capture policy. Might be missing due to historical data
        gap.

        :rtype: AccountCapturePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureChangePolicyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

AccountCaptureChangePolicyDetails_validator = bv.Struct(AccountCaptureChangePolicyDetails)

class AccountCaptureChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureChangePolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureChangePolicyType(description={!r})'.format(
            self._description_value,
        )

AccountCaptureChangePolicyType_validator = bv.Struct(AccountCaptureChangePolicyType)

class AccountCaptureMigrateAccountDetails(bb.Struct):
    """
    Account-captured user migrated account to team.

    :ivar domain_name: Domain name.
    """

    __slots__ = [
        '_domain_name_value',
        '_domain_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None):
        self._domain_name_value = None
        self._domain_name_present = False
        if domain_name is not None:
            self.domain_name = domain_name

    @property
    def domain_name(self):
        """
        Domain name.

        :rtype: str
        """
        if self._domain_name_present:
            return self._domain_name_value
        else:
            raise AttributeError("missing required field 'domain_name'")

    @domain_name.setter
    def domain_name(self, val):
        val = self._domain_name_validator.validate(val)
        self._domain_name_value = val
        self._domain_name_present = True

    @domain_name.deleter
    def domain_name(self):
        self._domain_name_value = None
        self._domain_name_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureMigrateAccountDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureMigrateAccountDetails(domain_name={!r})'.format(
            self._domain_name_value,
        )

AccountCaptureMigrateAccountDetails_validator = bv.Struct(AccountCaptureMigrateAccountDetails)

class AccountCaptureMigrateAccountType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureMigrateAccountType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureMigrateAccountType(description={!r})'.format(
            self._description_value,
        )

AccountCaptureMigrateAccountType_validator = bv.Struct(AccountCaptureMigrateAccountType)

class AccountCaptureNotificationEmailsSentDetails(bb.Struct):
    """
    Sent proactive account capture email to all unmanaged members.

    :ivar domain_name: Domain name.
    """

    __slots__ = [
        '_domain_name_value',
        '_domain_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None):
        self._domain_name_value = None
        self._domain_name_present = False
        if domain_name is not None:
            self.domain_name = domain_name

    @property
    def domain_name(self):
        """
        Domain name.

        :rtype: str
        """
        if self._domain_name_present:
            return self._domain_name_value
        else:
            raise AttributeError("missing required field 'domain_name'")

    @domain_name.setter
    def domain_name(self, val):
        val = self._domain_name_validator.validate(val)
        self._domain_name_value = val
        self._domain_name_present = True

    @domain_name.deleter
    def domain_name(self):
        self._domain_name_value = None
        self._domain_name_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureNotificationEmailsSentDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureNotificationEmailsSentDetails(domain_name={!r})'.format(
            self._domain_name_value,
        )

AccountCaptureNotificationEmailsSentDetails_validator = bv.Struct(AccountCaptureNotificationEmailsSentDetails)

class AccountCaptureNotificationEmailsSentType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureNotificationEmailsSentType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureNotificationEmailsSentType(description={!r})'.format(
            self._description_value,
        )

AccountCaptureNotificationEmailsSentType_validator = bv.Struct(AccountCaptureNotificationEmailsSentType)

class AccountCapturePolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    invited_users = None
    # Attribute is overwritten below the class definition
    all_users = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_invited_users(self):
        """
        Check if the union tag is ``invited_users``.

        :rtype: bool
        """
        return self._tag == 'invited_users'

    def is_all_users(self):
        """
        Check if the union tag is ``all_users``.

        :rtype: bool
        """
        return self._tag == 'all_users'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCapturePolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCapturePolicy(%r, %r)' % (self._tag, self._value)

AccountCapturePolicy_validator = bv.Union(AccountCapturePolicy)

class AccountCaptureRelinquishAccountDetails(bb.Struct):
    """
    Account-captured user changed account email to personal email.

    :ivar domain_name: Domain name.
    """

    __slots__ = [
        '_domain_name_value',
        '_domain_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None):
        self._domain_name_value = None
        self._domain_name_present = False
        if domain_name is not None:
            self.domain_name = domain_name

    @property
    def domain_name(self):
        """
        Domain name.

        :rtype: str
        """
        if self._domain_name_present:
            return self._domain_name_value
        else:
            raise AttributeError("missing required field 'domain_name'")

    @domain_name.setter
    def domain_name(self, val):
        val = self._domain_name_validator.validate(val)
        self._domain_name_value = val
        self._domain_name_present = True

    @domain_name.deleter
    def domain_name(self):
        self._domain_name_value = None
        self._domain_name_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureRelinquishAccountDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureRelinquishAccountDetails(domain_name={!r})'.format(
            self._domain_name_value,
        )

AccountCaptureRelinquishAccountDetails_validator = bv.Struct(AccountCaptureRelinquishAccountDetails)

class AccountCaptureRelinquishAccountType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AccountCaptureRelinquishAccountType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AccountCaptureRelinquishAccountType(description={!r})'.format(
            self._description_value,
        )

AccountCaptureRelinquishAccountType_validator = bv.Struct(AccountCaptureRelinquishAccountType)

class ActionDetails(bb.Union):
    """
    Additional information indicating the action taken that caused status
    change.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar JoinTeamDetails team_join_details: Additional information relevant
        when a new member joins the team.
    :ivar MemberRemoveActionType remove_action: Define how the user was removed
        from the team.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def team_join_details(cls, val):
        """
        Create an instance of this class set to the ``team_join_details`` tag
        with value ``val``.

        :param JoinTeamDetails val:
        :rtype: ActionDetails
        """
        return cls('team_join_details', val)

    @classmethod
    def remove_action(cls, val):
        """
        Create an instance of this class set to the ``remove_action`` tag with
        value ``val``.

        :param MemberRemoveActionType val:
        :rtype: ActionDetails
        """
        return cls('remove_action', val)

    def is_team_join_details(self):
        """
        Check if the union tag is ``team_join_details``.

        :rtype: bool
        """
        return self._tag == 'team_join_details'

    def is_remove_action(self):
        """
        Check if the union tag is ``remove_action``.

        :rtype: bool
        """
        return self._tag == 'remove_action'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_team_join_details(self):
        """
        Additional information relevant when a new member joins the team.

        Only call this if :meth:`is_team_join_details` is true.

        :rtype: JoinTeamDetails
        """
        if not self.is_team_join_details():
            raise AttributeError("tag 'team_join_details' not set")
        return self._value

    def get_remove_action(self):
        """
        Define how the user was removed from the team.

        Only call this if :meth:`is_remove_action` is true.

        :rtype: MemberRemoveActionType
        """
        if not self.is_remove_action():
            raise AttributeError("tag 'remove_action' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, processor):
        super(ActionDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ActionDetails(%r, %r)' % (self._tag, self._value)

ActionDetails_validator = bv.Union(ActionDetails)

class ActorLogInfo(bb.Union):
    """
    The entity who performed the action.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UserLogInfo user: The user who did the action.
    :ivar UserLogInfo admin: The admin who did the action.
    :ivar AppLogInfo app: The application who did the action.
    :ivar ResellerLogInfo reseller: Action done by reseller.
    :ivar dropbox: Action done by Dropbox.
    :ivar anonymous: Anonymous actor.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    dropbox = None
    # Attribute is overwritten below the class definition
    anonymous = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def user(cls, val):
        """
        Create an instance of this class set to the ``user`` tag with value
        ``val``.

        :param UserLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('user', val)

    @classmethod
    def admin(cls, val):
        """
        Create an instance of this class set to the ``admin`` tag with value
        ``val``.

        :param UserLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('admin', val)

    @classmethod
    def app(cls, val):
        """
        Create an instance of this class set to the ``app`` tag with value
        ``val``.

        :param AppLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('app', val)

    @classmethod
    def reseller(cls, val):
        """
        Create an instance of this class set to the ``reseller`` tag with value
        ``val``.

        :param ResellerLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('reseller', val)

    def is_user(self):
        """
        Check if the union tag is ``user``.

        :rtype: bool
        """
        return self._tag == 'user'

    def is_admin(self):
        """
        Check if the union tag is ``admin``.

        :rtype: bool
        """
        return self._tag == 'admin'

    def is_app(self):
        """
        Check if the union tag is ``app``.

        :rtype: bool
        """
        return self._tag == 'app'

    def is_reseller(self):
        """
        Check if the union tag is ``reseller``.

        :rtype: bool
        """
        return self._tag == 'reseller'

    def is_dropbox(self):
        """
        Check if the union tag is ``dropbox``.

        :rtype: bool
        """
        return self._tag == 'dropbox'

    def is_anonymous(self):
        """
        Check if the union tag is ``anonymous``.

        :rtype: bool
        """
        return self._tag == 'anonymous'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_user(self):
        """
        The user who did the action.

        Only call this if :meth:`is_user` is true.

        :rtype: UserLogInfo
        """
        if not self.is_user():
            raise AttributeError("tag 'user' not set")
        return self._value

    def get_admin(self):
        """
        The admin who did the action.

        Only call this if :meth:`is_admin` is true.

        :rtype: UserLogInfo
        """
        if not self.is_admin():
            raise AttributeError("tag 'admin' not set")
        return self._value

    def get_app(self):
        """
        The application who did the action.

        Only call this if :meth:`is_app` is true.

        :rtype: AppLogInfo
        """
        if not self.is_app():
            raise AttributeError("tag 'app' not set")
        return self._value

    def get_reseller(self):
        """
        Action done by reseller.

        Only call this if :meth:`is_reseller` is true.

        :rtype: ResellerLogInfo
        """
        if not self.is_reseller():
            raise AttributeError("tag 'reseller' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, processor):
        super(ActorLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ActorLogInfo(%r, %r)' % (self._tag, self._value)

ActorLogInfo_validator = bv.Union(ActorLogInfo)

class AdminRole(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    team_admin = None
    # Attribute is overwritten below the class definition
    user_management_admin = None
    # Attribute is overwritten below the class definition
    support_admin = None
    # Attribute is overwritten below the class definition
    limited_admin = None
    # Attribute is overwritten below the class definition
    member_only = None
    # Attribute is overwritten below the class definition
    other = None

    def is_team_admin(self):
        """
        Check if the union tag is ``team_admin``.

        :rtype: bool
        """
        return self._tag == 'team_admin'

    def is_user_management_admin(self):
        """
        Check if the union tag is ``user_management_admin``.

        :rtype: bool
        """
        return self._tag == 'user_management_admin'

    def is_support_admin(self):
        """
        Check if the union tag is ``support_admin``.

        :rtype: bool
        """
        return self._tag == 'support_admin'

    def is_limited_admin(self):
        """
        Check if the union tag is ``limited_admin``.

        :rtype: bool
        """
        return self._tag == 'limited_admin'

    def is_member_only(self):
        """
        Check if the union tag is ``member_only``.

        :rtype: bool
        """
        return self._tag == 'member_only'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(AdminRole, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AdminRole(%r, %r)' % (self._tag, self._value)

AdminRole_validator = bv.Union(AdminRole)

class AllowDownloadDisabledDetails(bb.Struct):
    """
    Disabled downloads.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(AllowDownloadDisabledDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AllowDownloadDisabledDetails()'

AllowDownloadDisabledDetails_validator = bv.Struct(AllowDownloadDisabledDetails)

class AllowDownloadDisabledType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AllowDownloadDisabledType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AllowDownloadDisabledType(description={!r})'.format(
            self._description_value,
        )

AllowDownloadDisabledType_validator = bv.Struct(AllowDownloadDisabledType)

class AllowDownloadEnabledDetails(bb.Struct):
    """
    Enabled downloads.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(AllowDownloadEnabledDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AllowDownloadEnabledDetails()'

AllowDownloadEnabledDetails_validator = bv.Struct(AllowDownloadEnabledDetails)

class AllowDownloadEnabledType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AllowDownloadEnabledType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AllowDownloadEnabledType(description={!r})'.format(
            self._description_value,
        )

AllowDownloadEnabledType_validator = bv.Struct(AllowDownloadEnabledType)

class ApiSessionLogInfo(bb.Struct):
    """
    Api session.

    :ivar request_id: Api request ID.
    """

    __slots__ = [
        '_request_id_value',
        '_request_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_id=None):
        self._request_id_value = None
        self._request_id_present = False
        if request_id is not None:
            self.request_id = request_id

    @property
    def request_id(self):
        """
        Api request ID.

        :rtype: str
        """
        if self._request_id_present:
            return self._request_id_value
        else:
            raise AttributeError("missing required field 'request_id'")

    @request_id.setter
    def request_id(self, val):
        val = self._request_id_validator.validate(val)
        self._request_id_value = val
        self._request_id_present = True

    @request_id.deleter
    def request_id(self):
        self._request_id_value = None
        self._request_id_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ApiSessionLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ApiSessionLogInfo(request_id={!r})'.format(
            self._request_id_value,
        )

ApiSessionLogInfo_validator = bv.Struct(ApiSessionLogInfo)

class AppLinkTeamDetails(bb.Struct):
    """
    Linked app for team.

    :ivar app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
        '_app_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = None
        self._app_info_present = False
        if app_info is not None:
            self.app_info = app_info

    @property
    def app_info(self):
        """
        Relevant application details.

        :rtype: AppLogInfo
        """
        if self._app_info_present:
            return self._app_info_value
        else:
            raise AttributeError("missing required field 'app_info'")

    @app_info.setter
    def app_info(self, val):
        self._app_info_validator.validate_type_only(val)
        self._app_info_value = val
        self._app_info_present = True

    @app_info.deleter
    def app_info(self):
        self._app_info_value = None
        self._app_info_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AppLinkTeamDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AppLinkTeamDetails(app_info={!r})'.format(
            self._app_info_value,
        )

AppLinkTeamDetails_validator = bv.Struct(AppLinkTeamDetails)

class AppLinkTeamType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AppLinkTeamType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AppLinkTeamType(description={!r})'.format(
            self._description_value,
        )

AppLinkTeamType_validator = bv.Struct(AppLinkTeamType)

class AppLinkUserDetails(bb.Struct):
    """
    Linked app for member.

    :ivar app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
        '_app_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = None
        self._app_info_present = False
        if app_info is not None:
            self.app_info = app_info

    @property
    def app_info(self):
        """
        Relevant application details.

        :rtype: AppLogInfo
        """
        if self._app_info_present:
            return self._app_info_value
        else:
            raise AttributeError("missing required field 'app_info'")

    @app_info.setter
    def app_info(self, val):
        self._app_info_validator.validate_type_only(val)
        self._app_info_value = val
        self._app_info_present = True

    @app_info.deleter
    def app_info(self):
        self._app_info_value = None
        self._app_info_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AppLinkUserDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AppLinkUserDetails(app_info={!r})'.format(
            self._app_info_value,
        )

AppLinkUserDetails_validator = bv.Struct(AppLinkUserDetails)

class AppLinkUserType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AppLinkUserType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AppLinkUserType(description={!r})'.format(
            self._description_value,
        )

AppLinkUserType_validator = bv.Struct(AppLinkUserType)

class AppLogInfo(bb.Struct):
    """
    App's logged information.

    :ivar app_id: App unique ID. Might be missing due to historical data gap.
    :ivar display_name: App display name. Might be missing due to historical
        data gap.
    """

    __slots__ = [
        '_app_id_value',
        '_app_id_present',
        '_display_name_value',
        '_display_name_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 app_id=None,
                 display_name=None):
        self._app_id_value = None
        self._app_id_present = False
        self._display_name_value = None
        self._display_name_present = False
        if app_id is not None:
            self.app_id = app_id
        if display_name is not None:
            self.display_name = display_name

    @property
    def app_id(self):
        """
        App unique ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._app_id_present:
            return self._app_id_value
        else:
            return None

    @app_id.setter
    def app_id(self, val):
        if val is None:
            del self.app_id
            return
        val = self._app_id_validator.validate(val)
        self._app_id_value = val
        self._app_id_present = True

    @app_id.deleter
    def app_id(self):
        self._app_id_value = None
        self._app_id_present = False

    @property
    def display_name(self):
        """
        App display name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            return None

    @display_name.setter
    def display_name(self, val):
        if val is None:
            del self.display_name
            return
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AppLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AppLogInfo(app_id={!r}, display_name={!r})'.format(
            self._app_id_value,
            self._display_name_value,
        )

AppLogInfo_validator = bv.StructTree(AppLogInfo)

class AppUnlinkTeamDetails(bb.Struct):
    """
    Unlinked app for team.

    :ivar app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
        '_app_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = None
        self._app_info_present = False
        if app_info is not None:
            self.app_info = app_info

    @property
    def app_info(self):
        """
        Relevant application details.

        :rtype: AppLogInfo
        """
        if self._app_info_present:
            return self._app_info_value
        else:
            raise AttributeError("missing required field 'app_info'")

    @app_info.setter
    def app_info(self, val):
        self._app_info_validator.validate_type_only(val)
        self._app_info_value = val
        self._app_info_present = True

    @app_info.deleter
    def app_info(self):
        self._app_info_value = None
        self._app_info_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AppUnlinkTeamDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AppUnlinkTeamDetails(app_info={!r})'.format(
            self._app_info_value,
        )

AppUnlinkTeamDetails_validator = bv.Struct(AppUnlinkTeamDetails)

class AppUnlinkTeamType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AppUnlinkTeamType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AppUnlinkTeamType(description={!r})'.format(
            self._description_value,
        )

AppUnlinkTeamType_validator = bv.Struct(AppUnlinkTeamType)

class AppUnlinkUserDetails(bb.Struct):
    """
    Unlinked app for member.

    :ivar app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
        '_app_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = None
        self._app_info_present = False
        if app_info is not None:
            self.app_info = app_info

    @property
    def app_info(self):
        """
        Relevant application details.

        :rtype: AppLogInfo
        """
        if self._app_info_present:
            return self._app_info_value
        else:
            raise AttributeError("missing required field 'app_info'")

    @app_info.setter
    def app_info(self, val):
        self._app_info_validator.validate_type_only(val)
        self._app_info_value = val
        self._app_info_present = True

    @app_info.deleter
    def app_info(self):
        self._app_info_value = None
        self._app_info_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AppUnlinkUserDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AppUnlinkUserDetails(app_info={!r})'.format(
            self._app_info_value,
        )

AppUnlinkUserDetails_validator = bv.Struct(AppUnlinkUserDetails)

class AppUnlinkUserType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AppUnlinkUserType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AppUnlinkUserType(description={!r})'.format(
            self._description_value,
        )

AppUnlinkUserType_validator = bv.Struct(AppUnlinkUserType)

class AssetLogInfo(bb.Union):
    """
    Asset details.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar FileLogInfo file: File's details.
    :ivar FolderLogInfo folder: Folder's details.
    :ivar PaperDocumentLogInfo paper_document: Paper docuement's details.
    :ivar PaperFolderLogInfo paper_folder: Paper folder's details.
    :ivar ShowcaseDocumentLogInfo showcase_document: Showcase document's
        details.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def file(cls, val):
        """
        Create an instance of this class set to the ``file`` tag with value
        ``val``.

        :param FileLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('file', val)

    @classmethod
    def folder(cls, val):
        """
        Create an instance of this class set to the ``folder`` tag with value
        ``val``.

        :param FolderLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('folder', val)

    @classmethod
    def paper_document(cls, val):
        """
        Create an instance of this class set to the ``paper_document`` tag with
        value ``val``.

        :param PaperDocumentLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('paper_document', val)

    @classmethod
    def paper_folder(cls, val):
        """
        Create an instance of this class set to the ``paper_folder`` tag with
        value ``val``.

        :param PaperFolderLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('paper_folder', val)

    @classmethod
    def showcase_document(cls, val):
        """
        Create an instance of this class set to the ``showcase_document`` tag
        with value ``val``.

        :param ShowcaseDocumentLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('showcase_document', val)

    def is_file(self):
        """
        Check if the union tag is ``file``.

        :rtype: bool
        """
        return self._tag == 'file'

    def is_folder(self):
        """
        Check if the union tag is ``folder``.

        :rtype: bool
        """
        return self._tag == 'folder'

    def is_paper_document(self):
        """
        Check if the union tag is ``paper_document``.

        :rtype: bool
        """
        return self._tag == 'paper_document'

    def is_paper_folder(self):
        """
        Check if the union tag is ``paper_folder``.

        :rtype: bool
        """
        return self._tag == 'paper_folder'

    def is_showcase_document(self):
        """
        Check if the union tag is ``showcase_document``.

        :rtype: bool
        """
        return self._tag == 'showcase_document'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_file(self):
        """
        File's details.

        Only call this if :meth:`is_file` is true.

        :rtype: FileLogInfo
        """
        if not self.is_file():
            raise AttributeError("tag 'file' not set")
        return self._value

    def get_folder(self):
        """
        Folder's details.

        Only call this if :meth:`is_folder` is true.

        :rtype: FolderLogInfo
        """
        if not self.is_folder():
            raise AttributeError("tag 'folder' not set")
        return self._value

    def get_paper_document(self):
        """
        Paper docuement's details.

        Only call this if :meth:`is_paper_document` is true.

        :rtype: PaperDocumentLogInfo
        """
        if not self.is_paper_document():
            raise AttributeError("tag 'paper_document' not set")
        return self._value

    def get_paper_folder(self):
        """
        Paper folder's details.

        Only call this if :meth:`is_paper_folder` is true.

        :rtype: PaperFolderLogInfo
        """
        if not self.is_paper_folder():
            raise AttributeError("tag 'paper_folder' not set")
        return self._value

    def get_showcase_document(self):
        """
        Showcase document's details.

        Only call this if :meth:`is_showcase_document` is true.

        :rtype: ShowcaseDocumentLogInfo
        """
        if not self.is_showcase_document():
            raise AttributeError("tag 'showcase_document' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, processor):
        super(AssetLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AssetLogInfo(%r, %r)' % (self._tag, self._value)

AssetLogInfo_validator = bv.Union(AssetLogInfo)

class Certificate(bb.Struct):
    """
    Certificate details.

    :ivar subject: Certificate subject.
    :ivar issuer: Certificate issuer.
    :ivar issue_date: Certificate issue date.
    :ivar expiration_date: Certificate expiration date.
    :ivar serial_number: Certificate serial number.
    :ivar sha1_fingerprint: Certificate sha1 fingerprint.
    :ivar common_name: Certificate common name.
    """

    __slots__ = [
        '_subject_value',
        '_subject_present',
        '_issuer_value',
        '_issuer_present',
        '_issue_date_value',
        '_issue_date_present',
        '_expiration_date_value',
        '_expiration_date_present',
        '_serial_number_value',
        '_serial_number_present',
        '_sha1_fingerprint_value',
        '_sha1_fingerprint_present',
        '_common_name_value',
        '_common_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 subject=None,
                 issuer=None,
                 issue_date=None,
                 expiration_date=None,
                 serial_number=None,
                 sha1_fingerprint=None,
                 common_name=None):
        self._subject_value = None
        self._subject_present = False
        self._issuer_value = None
        self._issuer_present = False
        self._issue_date_value = None
        self._issue_date_present = False
        self._expiration_date_value = None
        self._expiration_date_present = False
        self._serial_number_value = None
        self._serial_number_present = False
        self._sha1_fingerprint_value = None
        self._sha1_fingerprint_present = False
        self._common_name_value = None
        self._common_name_present = False
        if subject is not None:
            self.subject = subject
        if issuer is not None:
            self.issuer = issuer
        if issue_date is not None:
            self.issue_date = issue_date
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if serial_number is not None:
            self.serial_number = serial_number
        if sha1_fingerprint is not None:
            self.sha1_fingerprint = sha1_fingerprint
        if common_name is not None:
            self.common_name = common_name

    @property
    def subject(self):
        """
        Certificate subject.

        :rtype: str
        """
        if self._subject_present:
            return self._subject_value
        else:
            raise AttributeError("missing required field 'subject'")

    @subject.setter
    def subject(self, val):
        val = self._subject_validator.validate(val)
        self._subject_value = val
        self._subject_present = True

    @subject.deleter
    def subject(self):
        self._subject_value = None
        self._subject_present = False

    @property
    def issuer(self):
        """
        Certificate issuer.

        :rtype: str
        """
        if self._issuer_present:
            return self._issuer_value
        else:
            raise AttributeError("missing required field 'issuer'")

    @issuer.setter
    def issuer(self, val):
        val = self._issuer_validator.validate(val)
        self._issuer_value = val
        self._issuer_present = True

    @issuer.deleter
    def issuer(self):
        self._issuer_value = None
        self._issuer_present = False

    @property
    def issue_date(self):
        """
        Certificate issue date.

        :rtype: str
        """
        if self._issue_date_present:
            return self._issue_date_value
        else:
            raise AttributeError("missing required field 'issue_date'")

    @issue_date.setter
    def issue_date(self, val):
        val = self._issue_date_validator.validate(val)
        self._issue_date_value = val
        self._issue_date_present = True

    @issue_date.deleter
    def issue_date(self):
        self._issue_date_value = None
        self._issue_date_present = False

    @property
    def expiration_date(self):
        """
        Certificate expiration date.

        :rtype: str
        """
        if self._expiration_date_present:
            return self._expiration_date_value
        else:
            raise AttributeError("missing required field 'expiration_date'")

    @expiration_date.setter
    def expiration_date(self, val):
        val = self._expiration_date_validator.validate(val)
        self._expiration_date_value = val
        self._expiration_date_present = True

    @expiration_date.deleter
    def expiration_date(self):
        self._expiration_date_value = None
        self._expiration_date_present = False

    @property
    def serial_number(self):
        """
        Certificate serial number.

        :rtype: str
        """
        if self._serial_number_present:
            return self._serial_number_value
        else:
            raise AttributeError("missing required field 'serial_number'")

    @serial_number.setter
    def serial_number(self, val):
        val = self._serial_number_validator.validate(val)
        self._serial_number_value = val
        self._serial_number_present = True

    @serial_number.deleter
    def serial_number(self):
        self._serial_number_value = None
        self._serial_number_present = False

    @property
    def sha1_fingerprint(self):
        """
        Certificate sha1 fingerprint.

        :rtype: str
        """
        if self._sha1_fingerprint_present:
            return self._sha1_fingerprint_value
        else:
            raise AttributeError("missing required field 'sha1_fingerprint'")

    @sha1_fingerprint.setter
    def sha1_fingerprint(self, val):
        val = self._sha1_fingerprint_validator.validate(val)
        self._sha1_fingerprint_value = val
        self._sha1_fingerprint_present = True

    @sha1_fingerprint.deleter
    def sha1_fingerprint(self):
        self._sha1_fingerprint_value = None
        self._sha1_fingerprint_present = False

    @property
    def common_name(self):
        """
        Certificate common name.

        :rtype: str
        """
        if self._common_name_present:
            return self._common_name_value
        else:
            return None

    @common_name.setter
    def common_name(self, val):
        if val is None:
            del self.common_name
            return
        val = self._common_name_validator.validate(val)
        self._common_name_value = val
        self._common_name_present = True

    @common_name.deleter
    def common_name(self):
        self._common_name_value = None
        self._common_name_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(Certificate, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'Certificate(subject={!r}, issuer={!r}, issue_date={!r}, expiration_date={!r}, serial_number={!r}, sha1_fingerprint={!r}, common_name={!r})'.format(
            self._subject_value,
            self._issuer_value,
            self._issue_date_value,
            self._expiration_date_value,
            self._serial_number_value,
            self._sha1_fingerprint_value,
            self._common_name_value,
        )

Certificate_validator = bv.Struct(Certificate)

class CollectionShareDetails(bb.Struct):
    """
    Shared album.

    :ivar album_name: Album name.
    """

    __slots__ = [
        '_album_name_value',
        '_album_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 album_name=None):
        self._album_name_value = None
        self._album_name_present = False
        if album_name is not None:
            self.album_name = album_name

    @property
    def album_name(self):
        """
        Album name.

        :rtype: str
        """
        if self._album_name_present:
            return self._album_name_value
        else:
            raise AttributeError("missing required field 'album_name'")

    @album_name.setter
    def album_name(self, val):
        val = self._album_name_validator.validate(val)
        self._album_name_value = val
        self._album_name_present = True

    @album_name.deleter
    def album_name(self):
        self._album_name_value = None
        self._album_name_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(CollectionShareDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'CollectionShareDetails(album_name={!r})'.format(
            self._album_name_value,
        )

CollectionShareDetails_validator = bv.Struct(CollectionShareDetails)

class CollectionShareType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(CollectionShareType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'CollectionShareType(description={!r})'.format(
            self._description_value,
        )

CollectionShareType_validator = bv.Struct(CollectionShareType)

class ContentPermanentDeletePolicy(bb.Union):
    """
    Policy for pemanent content deletion

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(ContentPermanentDeletePolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ContentPermanentDeletePolicy(%r, %r)' % (self._tag, self._value)

ContentPermanentDeletePolicy_validator = bv.Union(ContentPermanentDeletePolicy)

class ContextLogInfo(bb.Union):
    """
    The primary entity on which the action was done.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar TeamMemberLogInfo team_member: Action was done on behalf of a team
        member.
    :ivar NonTeamMemberLogInfo non_team_member: Action was done on behalf of a
        non team member.
    :ivar anonymous: Anonymous context.
    :ivar team: Action was done on behalf of the team.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    anonymous = None
    # Attribute is overwritten below the class definition
    team = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def team_member(cls, val):
        """
        Create an instance of this class set to the ``team_member`` tag with
        value ``val``.

        :param TeamMemberLogInfo val:
        :rtype: ContextLogInfo
        """
        return cls('team_member', val)

    @classmethod
    def non_team_member(cls, val):
        """
        Create an instance of this class set to the ``non_team_member`` tag with
        value ``val``.

        :param NonTeamMemberLogInfo val:
        :rtype: ContextLogInfo
        """
        return cls('non_team_member', val)

    def is_team_member(self):
        """
        Check if the union tag is ``team_member``.

        :rtype: bool
        """
        return self._tag == 'team_member'

    def is_non_team_member(self):
        """
        Check if the union tag is ``non_team_member``.

        :rtype: bool
        """
        return self._tag == 'non_team_member'

    def is_anonymous(self):
        """
        Check if the union tag is ``anonymous``.

        :rtype: bool
        """
        return self._tag == 'anonymous'

    def is_team(self):
        """
        Check if the union tag is ``team``.

        :rtype: bool
        """
        return self._tag == 'team'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_team_member(self):
        """
        Action was done on behalf of a team member.

        Only call this if :meth:`is_team_member` is true.

        :rtype: TeamMemberLogInfo
        """
        if not self.is_team_member():
            raise AttributeError("tag 'team_member' not set")
        return self._value

    def get_non_team_member(self):
        """
        Action was done on behalf of a non team member.

        Only call this if :meth:`is_non_team_member` is true.

        :rtype: NonTeamMemberLogInfo
        """
        if not self.is_non_team_member():
            raise AttributeError("tag 'non_team_member' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, processor):
        super(ContextLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ContextLogInfo(%r, %r)' % (self._tag, self._value)

ContextLogInfo_validator = bv.Union(ContextLogInfo)

class CreateFolderDetails(bb.Struct):
    """
    Created folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(CreateFolderDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'CreateFolderDetails()'

CreateFolderDetails_validator = bv.Struct(CreateFolderDetails)

class CreateFolderType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(CreateFolderType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'CreateFolderType(description={!r})'.format(
            self._description_value,
        )

CreateFolderType_validator = bv.Struct(CreateFolderType)

class DataPlacementRestrictionChangePolicyDetails(bb.Struct):
    """
    Set restrictions on data center locations where team data resides.

    :ivar previous_value: Previous placement restriction.
    :ivar new_value: New placement restriction.
    """

    __slots__ = [
        '_previous_value_value',
        '_previous_value_present',
        '_new_value_value',
        '_new_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_value=None,
                 new_value=None):
        self._previous_value_value = None
        self._previous_value_present = False
        self._new_value_value = None
        self._new_value_present = False
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value

    @property
    def previous_value(self):
        """
        Previous placement restriction.

        :rtype: PlacementRestriction
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            raise AttributeError("missing required field 'previous_value'")

    @previous_value.setter
    def previous_value(self, val):
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    @property
    def new_value(self):
        """
        New placement restriction.

        :rtype: PlacementRestriction
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DataPlacementRestrictionChangePolicyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DataPlacementRestrictionChangePolicyDetails(previous_value={!r}, new_value={!r})'.format(
            self._previous_value_value,
            self._new_value_value,
        )

DataPlacementRestrictionChangePolicyDetails_validator = bv.Struct(DataPlacementRestrictionChangePolicyDetails)

class DataPlacementRestrictionChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DataPlacementRestrictionChangePolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DataPlacementRestrictionChangePolicyType(description={!r})'.format(
            self._description_value,
        )

DataPlacementRestrictionChangePolicyType_validator = bv.Struct(DataPlacementRestrictionChangePolicyType)

class DataPlacementRestrictionSatisfyPolicyDetails(bb.Struct):
    """
    Completed restrictions on data center locations where team data resides.

    :ivar placement_restriction: Placement restriction.
    """

    __slots__ = [
        '_placement_restriction_value',
        '_placement_restriction_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 placement_restriction=None):
        self._placement_restriction_value = None
        self._placement_restriction_present = False
        if placement_restriction is not None:
            self.placement_restriction = placement_restriction

    @property
    def placement_restriction(self):
        """
        Placement restriction.

        :rtype: PlacementRestriction
        """
        if self._placement_restriction_present:
            return self._placement_restriction_value
        else:
            raise AttributeError("missing required field 'placement_restriction'")

    @placement_restriction.setter
    def placement_restriction(self, val):
        self._placement_restriction_validator.validate_type_only(val)
        self._placement_restriction_value = val
        self._placement_restriction_present = True

    @placement_restriction.deleter
    def placement_restriction(self):
        self._placement_restriction_value = None
        self._placement_restriction_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DataPlacementRestrictionSatisfyPolicyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DataPlacementRestrictionSatisfyPolicyDetails(placement_restriction={!r})'.format(
            self._placement_restriction_value,
        )

DataPlacementRestrictionSatisfyPolicyDetails_validator = bv.Struct(DataPlacementRestrictionSatisfyPolicyDetails)

class DataPlacementRestrictionSatisfyPolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DataPlacementRestrictionSatisfyPolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DataPlacementRestrictionSatisfyPolicyType(description={!r})'.format(
            self._description_value,
        )

DataPlacementRestrictionSatisfyPolicyType_validator = bv.Struct(DataPlacementRestrictionSatisfyPolicyType)

class DeviceSessionLogInfo(bb.Struct):
    """
    Device's session logged information.

    :ivar ip_address: The IP address of the last activity from this session.
        Might be missing due to historical data gap.
    :ivar created: The time this session was created. Might be missing due to
        historical data gap.
    :ivar updated: The time of the last activity from this session. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_ip_address_value',
        '_ip_address_present',
        '_created_value',
        '_created_present',
        '_updated_value',
        '_updated_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 ip_address=None,
                 created=None,
                 updated=None):
        self._ip_address_value = None
        self._ip_address_present = False
        self._created_value = None
        self._created_present = False
        self._updated_value = None
        self._updated_present = False
        if ip_address is not None:
            self.ip_address = ip_address
        if created is not None:
            self.created = created
        if updated is not None:
            self.updated = updated

    @property
    def ip_address(self):
        """
        The IP address of the last activity from this session. Might be missing
        due to historical data gap.

        :rtype: str
        """
        if self._ip_address_present:
            return self._ip_address_value
        else:
            return None

    @ip_address.setter
    def ip_address(self, val):
        if val is None:
            del self.ip_address
            return
        val = self._ip_address_validator.validate(val)
        self._ip_address_value = val
        self._ip_address_present = True

    @ip_address.deleter
    def ip_address(self):
        self._ip_address_value = None
        self._ip_address_present = False

    @property
    def created(self):
        """
        The time this session was created. Might be missing due to historical
        data gap.

        :rtype: datetime.datetime
        """
        if self._created_present:
            return self._created_value
        else:
            return None

    @created.setter
    def created(self, val):
        if val is None:
            del self.created
            return
        val = self._created_validator.validate(val)
        self._created_value = val
        self._created_present = True

    @created.deleter
    def created(self):
        self._created_value = None
        self._created_present = False

    @property
    def updated(self):
        """
        The time of the last activity from this session. Might be missing due to
        historical data gap.

        :rtype: datetime.datetime
        """
        if self._updated_present:
            return self._updated_value
        else:
            return None

    @updated.setter
    def updated(self, val):
        if val is None:
            del self.updated
            return
        val = self._updated_validator.validate(val)
        self._updated_value = val
        self._updated_present = True

    @updated.deleter
    def updated(self):
        self._updated_value = None
        self._updated_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceSessionLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceSessionLogInfo(ip_address={!r}, created={!r}, updated={!r})'.format(
            self._ip_address_value,
            self._created_value,
            self._updated_value,
        )

DeviceSessionLogInfo_validator = bv.StructTree(DeviceSessionLogInfo)

class DesktopDeviceSessionLogInfo(DeviceSessionLogInfo):
    """
    Information about linked Dropbox desktop client sessions

    :ivar session_info: Desktop session unique id. Might be missing due to
        historical data gap.
    :ivar host_name: Name of the hosting desktop.
    :ivar client_type: The Dropbox desktop client type.
    :ivar client_version: The Dropbox client version.
    :ivar platform: Information on the hosting platform.
    :ivar is_delete_on_unlink_supported: Whether itu2019s possible to delete all
        of the account files upon unlinking.
    """

    __slots__ = [
        '_session_info_value',
        '_session_info_present',
        '_host_name_value',
        '_host_name_present',
        '_client_type_value',
        '_client_type_present',
        '_client_version_value',
        '_client_version_present',
        '_platform_value',
        '_platform_present',
        '_is_delete_on_unlink_supported_value',
        '_is_delete_on_unlink_supported_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 host_name=None,
                 client_type=None,
                 platform=None,
                 is_delete_on_unlink_supported=None,
                 ip_address=None,
                 created=None,
                 updated=None,
                 session_info=None,
                 client_version=None):
        super(DesktopDeviceSessionLogInfo, self).__init__(ip_address,
                                                          created,
                                                          updated)
        self._session_info_value = None
        self._session_info_present = False
        self._host_name_value = None
        self._host_name_present = False
        self._client_type_value = None
        self._client_type_present = False
        self._client_version_value = None
        self._client_version_present = False
        self._platform_value = None
        self._platform_present = False
        self._is_delete_on_unlink_supported_value = None
        self._is_delete_on_unlink_supported_present = False
        if session_info is not None:
            self.session_info = session_info
        if host_name is not None:
            self.host_name = host_name
        if client_type is not None:
            self.client_type = client_type
        if client_version is not None:
            self.client_version = client_version
        if platform is not None:
            self.platform = platform
        if is_delete_on_unlink_supported is not None:
            self.is_delete_on_unlink_supported = is_delete_on_unlink_supported

    @property
    def session_info(self):
        """
        Desktop session unique id. Might be missing due to historical data gap.

        :rtype: DesktopSessionLogInfo
        """
        if self._session_info_present:
            return self._session_info_value
        else:
            return None

    @session_info.setter
    def session_info(self, val):
        if val is None:
            del self.session_info
            return
        self._session_info_validator.validate_type_only(val)
        self._session_info_value = val
        self._session_info_present = True

    @session_info.deleter
    def session_info(self):
        self._session_info_value = None
        self._session_info_present = False

    @property
    def host_name(self):
        """
        Name of the hosting desktop.

        :rtype: str
        """
        if self._host_name_present:
            return self._host_name_value
        else:
            raise AttributeError("missing required field 'host_name'")

    @host_name.setter
    def host_name(self, val):
        val = self._host_name_validator.validate(val)
        self._host_name_value = val
        self._host_name_present = True

    @host_name.deleter
    def host_name(self):
        self._host_name_value = None
        self._host_name_present = False

    @property
    def client_type(self):
        """
        The Dropbox desktop client type.

        :rtype: team.DesktopPlatform
        """
        if self._client_type_present:
            return self._client_type_value
        else:
            raise AttributeError("missing required field 'client_type'")

    @client_type.setter
    def client_type(self, val):
        self._client_type_validator.validate_type_only(val)
        self._client_type_value = val
        self._client_type_present = True

    @client_type.deleter
    def client_type(self):
        self._client_type_value = None
        self._client_type_present = False

    @property
    def client_version(self):
        """
        The Dropbox client version.

        :rtype: str
        """
        if self._client_version_present:
            return self._client_version_value
        else:
            return None

    @client_version.setter
    def client_version(self, val):
        if val is None:
            del self.client_version
            return
        val = self._client_version_validator.validate(val)
        self._client_version_value = val
        self._client_version_present = True

    @client_version.deleter
    def client_version(self):
        self._client_version_value = None
        self._client_version_present = False

    @property
    def platform(self):
        """
        Information on the hosting platform.

        :rtype: str
        """
        if self._platform_present:
            return self._platform_value
        else:
            raise AttributeError("missing required field 'platform'")

    @platform.setter
    def platform(self, val):
        val = self._platform_validator.validate(val)
        self._platform_value = val
        self._platform_present = True

    @platform.deleter
    def platform(self):
        self._platform_value = None
        self._platform_present = False

    @property
    def is_delete_on_unlink_supported(self):
        """
        Whether itu2019s possible to delete all of the account files upon
        unlinking.

        :rtype: bool
        """
        if self._is_delete_on_unlink_supported_present:
            return self._is_delete_on_unlink_supported_value
        else:
            raise AttributeError("missing required field 'is_delete_on_unlink_supported'")

    @is_delete_on_unlink_supported.setter
    def is_delete_on_unlink_supported(self, val):
        val = self._is_delete_on_unlink_supported_validator.validate(val)
        self._is_delete_on_unlink_supported_value = val
        self._is_delete_on_unlink_supported_present = True

    @is_delete_on_unlink_supported.deleter
    def is_delete_on_unlink_supported(self):
        self._is_delete_on_unlink_supported_value = None
        self._is_delete_on_unlink_supported_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DesktopDeviceSessionLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DesktopDeviceSessionLogInfo(host_name={!r}, client_type={!r}, platform={!r}, is_delete_on_unlink_supported={!r}, ip_address={!r}, created={!r}, updated={!r}, session_info={!r}, client_version={!r})'.format(
            self._host_name_value,
            self._client_type_value,
            self._platform_value,
            self._is_delete_on_unlink_supported_value,
            self._ip_address_value,
            self._created_value,
            self._updated_value,
            self._session_info_value,
            self._client_version_value,
        )

DesktopDeviceSessionLogInfo_validator = bv.Struct(DesktopDeviceSessionLogInfo)

class SessionLogInfo(bb.Struct):
    """
    Session's logged information.

    :ivar session_id: Session ID. Might be missing due to historical data gap.
    """

    __slots__ = [
        '_session_id_value',
        '_session_id_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 session_id=None):
        self._session_id_value = None
        self._session_id_present = False
        if session_id is not None:
            self.session_id = session_id

    @property
    def session_id(self):
        """
        Session ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._session_id_present:
            return self._session_id_value
        else:
            return None

    @session_id.setter
    def session_id(self, val):
        if val is None:
            del self.session_id
            return
        val = self._session_id_validator.validate(val)
        self._session_id_value = val
        self._session_id_present = True

    @session_id.deleter
    def session_id(self):
        self._session_id_value = None
        self._session_id_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(SessionLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'SessionLogInfo(session_id={!r})'.format(
            self._session_id_value,
        )

SessionLogInfo_validator = bv.StructTree(SessionLogInfo)

class DesktopSessionLogInfo(SessionLogInfo):
    """
    Desktop session.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self,
                 session_id=None):
        super(DesktopSessionLogInfo, self).__init__(session_id)

    def _process_custom_annotations(self, annotation_type, processor):
        super(DesktopSessionLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DesktopSessionLogInfo(session_id={!r})'.format(
            self._session_id_value,
        )

DesktopSessionLogInfo_validator = bv.Struct(DesktopSessionLogInfo)

class DeviceApprovalsChangeDesktopPolicyDetails(bb.Struct):
    """
    Set/removed limit on number of computers member can link to team Dropbox
    account.

    :ivar new_value: New desktop device approvals policy. Might be missing due
        to historical data gap.
    :ivar previous_value: Previous desktop device approvals policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New desktop device approvals policy. Might be missing due to historical
        data gap.

        :rtype: DeviceApprovalsPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            return None

    @new_value.setter
    def new_value(self, val):
        if val is None:
            del self.new_value
            return
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous desktop device approvals policy. Might be missing due to
        historical data gap.

        :rtype: DeviceApprovalsPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceApprovalsChangeDesktopPolicyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceApprovalsChangeDesktopPolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

DeviceApprovalsChangeDesktopPolicyDetails_validator = bv.Struct(DeviceApprovalsChangeDesktopPolicyDetails)

class DeviceApprovalsChangeDesktopPolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceApprovalsChangeDesktopPolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceApprovalsChangeDesktopPolicyType(description={!r})'.format(
            self._description_value,
        )

DeviceApprovalsChangeDesktopPolicyType_validator = bv.Struct(DeviceApprovalsChangeDesktopPolicyType)

class DeviceApprovalsChangeMobilePolicyDetails(bb.Struct):
    """
    Set/removed limit on number of mobile devices member can link to team
    Dropbox account.

    :ivar new_value: New mobile device approvals policy. Might be missing due to
        historical data gap.
    :ivar previous_value: Previous mobile device approvals policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New mobile device approvals policy. Might be missing due to historical
        data gap.

        :rtype: DeviceApprovalsPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            return None

    @new_value.setter
    def new_value(self, val):
        if val is None:
            del self.new_value
            return
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous mobile device approvals policy. Might be missing due to
        historical data gap.

        :rtype: DeviceApprovalsPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceApprovalsChangeMobilePolicyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceApprovalsChangeMobilePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

DeviceApprovalsChangeMobilePolicyDetails_validator = bv.Struct(DeviceApprovalsChangeMobilePolicyDetails)

class DeviceApprovalsChangeMobilePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceApprovalsChangeMobilePolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceApprovalsChangeMobilePolicyType(description={!r})'.format(
            self._description_value,
        )

DeviceApprovalsChangeMobilePolicyType_validator = bv.Struct(DeviceApprovalsChangeMobilePolicyType)

class DeviceApprovalsChangeOverageActionDetails(bb.Struct):
    """
    Changed device approvals setting when member is over limit.

    :ivar new_value: New over the limits policy. Might be missing due to
        historical data gap.
    :ivar previous_value: Previous over the limit policy. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New over the limits policy. Might be missing due to historical data gap.

        :rtype: team_policies.RolloutMethod
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            return None

    @new_value.setter
    def new_value(self, val):
        if val is None:
            del self.new_value
            return
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous over the limit policy. Might be missing due to historical data
        gap.

        :rtype: team_policies.RolloutMethod
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceApprovalsChangeOverageActionDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceApprovalsChangeOverageActionDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

DeviceApprovalsChangeOverageActionDetails_validator = bv.Struct(DeviceApprovalsChangeOverageActionDetails)

class DeviceApprovalsChangeOverageActionType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceApprovalsChangeOverageActionType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceApprovalsChangeOverageActionType(description={!r})'.format(
            self._description_value,
        )

DeviceApprovalsChangeOverageActionType_validator = bv.Struct(DeviceApprovalsChangeOverageActionType)

class DeviceApprovalsChangeUnlinkActionDetails(bb.Struct):
    """
    Changed device approvals setting when member unlinks approved device.

    :ivar new_value: New device unlink policy. Might be missing due to
        historical data gap.
    :ivar previous_value: Previous device unlink policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New device unlink policy. Might be missing due to historical data gap.

        :rtype: DeviceUnlinkPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            return None

    @new_value.setter
    def new_value(self, val):
        if val is None:
            del self.new_value
            return
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous device unlink policy. Might be missing due to historical data
        gap.

        :rtype: DeviceUnlinkPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceApprovalsChangeUnlinkActionDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceApprovalsChangeUnlinkActionDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

DeviceApprovalsChangeUnlinkActionDetails_validator = bv.Struct(DeviceApprovalsChangeUnlinkActionDetails)

class DeviceApprovalsChangeUnlinkActionType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceApprovalsChangeUnlinkActionType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceApprovalsChangeUnlinkActionType(description={!r})'.format(
            self._description_value,
        )

DeviceApprovalsChangeUnlinkActionType_validator = bv.Struct(DeviceApprovalsChangeUnlinkActionType)

class DeviceApprovalsPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    unlimited = None
    # Attribute is overwritten below the class definition
    limited = None
    # Attribute is overwritten below the class definition
    other = None

    def is_unlimited(self):
        """
        Check if the union tag is ``unlimited``.

        :rtype: bool
        """
        return self._tag == 'unlimited'

    def is_limited(self):
        """
        Check if the union tag is ``limited``.

        :rtype: bool
        """
        return self._tag == 'limited'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceApprovalsPolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceApprovalsPolicy(%r, %r)' % (self._tag, self._value)

DeviceApprovalsPolicy_validator = bv.Union(DeviceApprovalsPolicy)

class DeviceChangeIpDesktopDetails(bb.Struct):
    """
    Changed IP address associated with active desktop session.

    :ivar device_session_info: Device's session logged information.
    """

    __slots__ = [
        '_device_session_info_value',
        '_device_session_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_session_info=None):
        self._device_session_info_value = None
        self._device_session_info_present = False
        if device_session_info is not None:
            self.device_session_info = device_session_info

    @property
    def device_session_info(self):
        """
        Device's session logged information.

        :rtype: DeviceSessionLogInfo
        """
        if self._device_session_info_present:
            return self._device_session_info_value
        else:
            raise AttributeError("missing required field 'device_session_info'")

    @device_session_info.setter
    def device_session_info(self, val):
        self._device_session_info_validator.validate_type_only(val)
        self._device_session_info_value = val
        self._device_session_info_present = True

    @device_session_info.deleter
    def device_session_info(self):
        self._device_session_info_value = None
        self._device_session_info_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceChangeIpDesktopDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceChangeIpDesktopDetails(device_session_info={!r})'.format(
            self._device_session_info_value,
        )

DeviceChangeIpDesktopDetails_validator = bv.Struct(DeviceChangeIpDesktopDetails)

class DeviceChangeIpDesktopType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceChangeIpDesktopType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceChangeIpDesktopType(description={!r})'.format(
            self._description_value,
        )

DeviceChangeIpDesktopType_validator = bv.Struct(DeviceChangeIpDesktopType)

class DeviceChangeIpMobileDetails(bb.Struct):
    """
    Changed IP address associated with active mobile session.

    :ivar device_session_info: Device's session logged information.
    """

    __slots__ = [
        '_device_session_info_value',
        '_device_session_info_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 device_session_info=None):
        self._device_session_info_value = None
        self._device_session_info_present = False
        if device_session_info is not None:
            self.device_session_info = device_session_info

    @property
    def device_session_info(self):
        """
        Device's session logged information.

        :rtype: DeviceSessionLogInfo
        """
        if self._device_session_info_present:
            return self._device_session_info_value
        else:
            return None

    @device_session_info.setter
    def device_session_info(self, val):
        if val is None:
            del self.device_session_info
            return
        self._device_session_info_validator.validate_type_only(val)
        self._device_session_info_value = val
        self._device_session_info_present = True

    @device_session_info.deleter
    def device_session_info(self):
        self._device_session_info_value = None
        self._device_session_info_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceChangeIpMobileDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceChangeIpMobileDetails(device_session_info={!r})'.format(
            self._device_session_info_value,
        )

DeviceChangeIpMobileDetails_validator = bv.Struct(DeviceChangeIpMobileDetails)

class DeviceChangeIpMobileType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceChangeIpMobileType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceChangeIpMobileType(description={!r})'.format(
            self._description_value,
        )

DeviceChangeIpMobileType_validator = bv.Struct(DeviceChangeIpMobileType)

class DeviceChangeIpWebDetails(bb.Struct):
    """
    Changed IP address associated with active web session.

    :ivar user_agent: Web browser name.
    """

    __slots__ = [
        '_user_agent_value',
        '_user_agent_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 user_agent=None):
        self._user_agent_value = None
        self._user_agent_present = False
        if user_agent is not None:
            self.user_agent = user_agent

    @property
    def user_agent(self):
        """
        Web browser name.

        :rtype: str
        """
        if self._user_agent_present:
            return self._user_agent_value
        else:
            raise AttributeError("missing required field 'user_agent'")

    @user_agent.setter
    def user_agent(self, val):
        val = self._user_agent_validator.validate(val)
        self._user_agent_value = val
        self._user_agent_present = True

    @user_agent.deleter
    def user_agent(self):
        self._user_agent_value = None
        self._user_agent_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceChangeIpWebDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceChangeIpWebDetails(user_agent={!r})'.format(
            self._user_agent_value,
        )

DeviceChangeIpWebDetails_validator = bv.Struct(DeviceChangeIpWebDetails)

class DeviceChangeIpWebType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceChangeIpWebType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceChangeIpWebType(description={!r})'.format(
            self._description_value,
        )

DeviceChangeIpWebType_validator = bv.Struct(DeviceChangeIpWebType)

class DeviceDeleteOnUnlinkFailDetails(bb.Struct):
    """
    Failed to delete all files from unlinked device.

    :ivar session_info: Session unique id. Might be missing due to historical
        data gap.
    :ivar display_name: The device name. Might be missing due to historical data
        gap.
    :ivar num_failures: The number of times that remote file deletion failed.
    """

    __slots__ = [
        '_session_info_value',
        '_session_info_present',
        '_display_name_value',
        '_display_name_present',
        '_num_failures_value',
        '_num_failures_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 num_failures=None,
                 session_info=None,
                 display_name=None):
        self._session_info_value = None
        self._session_info_present = False
        self._display_name_value = None
        self._display_name_present = False
        self._num_failures_value = None
        self._num_failures_present = False
        if session_info is not None:
            self.session_info = session_info
        if display_name is not None:
            self.display_name = display_name
        if num_failures is not None:
            self.num_failures = num_failures

    @property
    def session_info(self):
        """
        Session unique id. Might be missing due to historical data gap.

        :rtype: SessionLogInfo
        """
        if self._session_info_present:
            return self._session_info_value
        else:
            return None

    @session_info.setter
    def session_info(self, val):
        if val is None:
            del self.session_info
            return
        self._session_info_validator.validate_type_only(val)
        self._session_info_value = val
        self._session_info_present = True

    @session_info.deleter
    def session_info(self):
        self._session_info_value = None
        self._session_info_present = False

    @property
    def display_name(self):
        """
        The device name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            return None

    @display_name.setter
    def display_name(self, val):
        if val is None:
            del self.display_name
            return
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def num_failures(self):
        """
        The number of times that remote file deletion failed.

        :rtype: long
        """
        if self._num_failures_present:
            return self._num_failures_value
        else:
            raise AttributeError("missing required field 'num_failures'")

    @num_failures.setter
    def num_failures(self, val):
        val = self._num_failures_validator.validate(val)
        self._num_failures_value = val
        self._num_failures_present = True

    @num_failures.deleter
    def num_failures(self):
        self._num_failures_value = None
        self._num_failures_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceDeleteOnUnlinkFailDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceDeleteOnUnlinkFailDetails(num_failures={!r}, session_info={!r}, display_name={!r})'.format(
            self._num_failures_value,
            self._session_info_value,
            self._display_name_value,
        )

DeviceDeleteOnUnlinkFailDetails_validator = bv.Struct(DeviceDeleteOnUnlinkFailDetails)

class DeviceDeleteOnUnlinkFailType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceDeleteOnUnlinkFailType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceDeleteOnUnlinkFailType(description={!r})'.format(
            self._description_value,
        )

DeviceDeleteOnUnlinkFailType_validator = bv.Struct(DeviceDeleteOnUnlinkFailType)

class DeviceDeleteOnUnlinkSuccessDetails(bb.Struct):
    """
    Deleted all files from unlinked device.

    :ivar session_info: Session unique id. Might be missing due to historical
        data gap.
    :ivar display_name: The device name. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_session_info_value',
        '_session_info_present',
        '_display_name_value',
        '_display_name_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 session_info=None,
                 display_name=None):
        self._session_info_value = None
        self._session_info_present = False
        self._display_name_value = None
        self._display_name_present = False
        if session_info is not None:
            self.session_info = session_info
        if display_name is not None:
            self.display_name = display_name

    @property
    def session_info(self):
        """
        Session unique id. Might be missing due to historical data gap.

        :rtype: SessionLogInfo
        """
        if self._session_info_present:
            return self._session_info_value
        else:
            return None

    @session_info.setter
    def session_info(self, val):
        if val is None:
            del self.session_info
            return
        self._session_info_validator.validate_type_only(val)
        self._session_info_value = val
        self._session_info_present = True

    @session_info.deleter
    def session_info(self):
        self._session_info_value = None
        self._session_info_present = False

    @property
    def display_name(self):
        """
        The device name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            return None

    @display_name.setter
    def display_name(self, val):
        if val is None:
            del self.display_name
            return
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceDeleteOnUnlinkSuccessDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceDeleteOnUnlinkSuccessDetails(session_info={!r}, display_name={!r})'.format(
            self._session_info_value,
            self._display_name_value,
        )

DeviceDeleteOnUnlinkSuccessDetails_validator = bv.Struct(DeviceDeleteOnUnlinkSuccessDetails)

class DeviceDeleteOnUnlinkSuccessType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceDeleteOnUnlinkSuccessType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceDeleteOnUnlinkSuccessType(description={!r})'.format(
            self._description_value,
        )

DeviceDeleteOnUnlinkSuccessType_validator = bv.Struct(DeviceDeleteOnUnlinkSuccessType)

class DeviceLinkFailDetails(bb.Struct):
    """
    Failed to link device.

    :ivar ip_address: IP address. Might be missing due to historical data gap.
    :ivar device_type: A description of the device used while user approval
        blocked.
    """

    __slots__ = [
        '_ip_address_value',
        '_ip_address_present',
        '_device_type_value',
        '_device_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_type=None,
                 ip_address=None):
        self._ip_address_value = None
        self._ip_address_present = False
        self._device_type_value = None
        self._device_type_present = False
        if ip_address is not None:
            self.ip_address = ip_address
        if device_type is not None:
            self.device_type = device_type

    @property
    def ip_address(self):
        """
        IP address. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._ip_address_present:
            return self._ip_address_value
        else:
            return None

    @ip_address.setter
    def ip_address(self, val):
        if val is None:
            del self.ip_address
            return
        val = self._ip_address_validator.validate(val)
        self._ip_address_value = val
        self._ip_address_present = True

    @ip_address.deleter
    def ip_address(self):
        self._ip_address_value = None
        self._ip_address_present = False

    @property
    def device_type(self):
        """
        A description of the device used while user approval blocked.

        :rtype: DeviceType
        """
        if self._device_type_present:
            return self._device_type_value
        else:
            raise AttributeError("missing required field 'device_type'")

    @device_type.setter
    def device_type(self, val):
        self._device_type_validator.validate_type_only(val)
        self._device_type_value = val
        self._device_type_present = True

    @device_type.deleter
    def device_type(self):
        self._device_type_value = None
        self._device_type_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceLinkFailDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceLinkFailDetails(device_type={!r}, ip_address={!r})'.format(
            self._device_type_value,
            self._ip_address_value,
        )

DeviceLinkFailDetails_validator = bv.Struct(DeviceLinkFailDetails)

class DeviceLinkFailType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceLinkFailType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceLinkFailType(description={!r})'.format(
            self._description_value,
        )

DeviceLinkFailType_validator = bv.Struct(DeviceLinkFailType)

class DeviceLinkSuccessDetails(bb.Struct):
    """
    Linked device.

    :ivar device_session_info: Device's session logged information.
    """

    __slots__ = [
        '_device_session_info_value',
        '_device_session_info_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 device_session_info=None):
        self._device_session_info_value = None
        self._device_session_info_present = False
        if device_session_info is not None:
            self.device_session_info = device_session_info

    @property
    def device_session_info(self):
        """
        Device's session logged information.

        :rtype: DeviceSessionLogInfo
        """
        if self._device_session_info_present:
            return self._device_session_info_value
        else:
            return None

    @device_session_info.setter
    def device_session_info(self, val):
        if val is None:
            del self.device_session_info
            return
        self._device_session_info_validator.validate_type_only(val)
        self._device_session_info_value = val
        self._device_session_info_present = True

    @device_session_info.deleter
    def device_session_info(self):
        self._device_session_info_value = None
        self._device_session_info_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceLinkSuccessDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceLinkSuccessDetails(device_session_info={!r})'.format(
            self._device_session_info_value,
        )

DeviceLinkSuccessDetails_validator = bv.Struct(DeviceLinkSuccessDetails)

class DeviceLinkSuccessType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceLinkSuccessType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceLinkSuccessType(description={!r})'.format(
            self._description_value,
        )

DeviceLinkSuccessType_validator = bv.Struct(DeviceLinkSuccessType)

class DeviceManagementDisabledDetails(bb.Struct):
    """
    Disabled device management.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceManagementDisabledDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceManagementDisabledDetails()'

DeviceManagementDisabledDetails_validator = bv.Struct(DeviceManagementDisabledDetails)

class DeviceManagementDisabledType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceManagementDisabledType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceManagementDisabledType(description={!r})'.format(
            self._description_value,
        )

DeviceManagementDisabledType_validator = bv.Struct(DeviceManagementDisabledType)

class DeviceManagementEnabledDetails(bb.Struct):
    """
    Enabled device management.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceManagementEnabledDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceManagementEnabledDetails()'

DeviceManagementEnabledDetails_validator = bv.Struct(DeviceManagementEnabledDetails)

class DeviceManagementEnabledType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceManagementEnabledType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceManagementEnabledType(description={!r})'.format(
            self._description_value,
        )

DeviceManagementEnabledType_validator = bv.Struct(DeviceManagementEnabledType)

class DeviceType(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    desktop = None
    # Attribute is overwritten below the class definition
    mobile = None
    # Attribute is overwritten below the class definition
    other = None

    def is_desktop(self):
        """
        Check if the union tag is ``desktop``.

        :rtype: bool
        """
        return self._tag == 'desktop'

    def is_mobile(self):
        """
        Check if the union tag is ``mobile``.

        :rtype: bool
        """
        return self._tag == 'mobile'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceType(%r, %r)' % (self._tag, self._value)

DeviceType_validator = bv.Union(DeviceType)

class DeviceUnlinkDetails(bb.Struct):
    """
    Disconnected device.

    :ivar session_info: Session unique id.
    :ivar display_name: The device name. Might be missing due to historical data
        gap.
    :ivar delete_data: True if the user requested to delete data after device
        unlink, false otherwise.
    """

    __slots__ = [
        '_session_info_value',
        '_session_info_present',
        '_display_name_value',
        '_display_name_present',
        '_delete_data_value',
        '_delete_data_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 delete_data=None,
                 session_info=None,
                 display_name=None):
        self._session_info_value = None
        self._session_info_present = False
        self._display_name_value = None
        self._display_name_present = False
        self._delete_data_value = None
        self._delete_data_present = False
        if session_info is not None:
            self.session_info = session_info
        if display_name is not None:
            self.display_name = display_name
        if delete_data is not None:
            self.delete_data = delete_data

    @property
    def session_info(self):
        """
        Session unique id.

        :rtype: SessionLogInfo
        """
        if self._session_info_present:
            return self._session_info_value
        else:
            return None

    @session_info.setter
    def session_info(self, val):
        if val is None:
            del self.session_info
            return
        self._session_info_validator.validate_type_only(val)
        self._session_info_value = val
        self._session_info_present = True

    @session_info.deleter
    def session_info(self):
        self._session_info_value = None
        self._session_info_present = False

    @property
    def display_name(self):
        """
        The device name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            return None

    @display_name.setter
    def display_name(self, val):
        if val is None:
            del self.display_name
            return
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def delete_data(self):
        """
        True if the user requested to delete data after device unlink, false
        otherwise.

        :rtype: bool
        """
        if self._delete_data_present:
            return self._delete_data_value
        else:
            raise AttributeError("missing required field 'delete_data'")

    @delete_data.setter
    def delete_data(self, val):
        val = self._delete_data_validator.validate(val)
        self._delete_data_value = val
        self._delete_data_present = True

    @delete_data.deleter
    def delete_data(self):
        self._delete_data_value = None
        self._delete_data_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceUnlinkDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceUnlinkDetails(delete_data={!r}, session_info={!r}, display_name={!r})'.format(
            self._delete_data_value,
            self._session_info_value,
            self._display_name_value,
        )

DeviceUnlinkDetails_validator = bv.Struct(DeviceUnlinkDetails)

class DeviceUnlinkPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    remove = None
    # Attribute is overwritten below the class definition
    keep = None
    # Attribute is overwritten below the class definition
    other = None

    def is_remove(self):
        """
        Check if the union tag is ``remove``.

        :rtype: bool
        """
        return self._tag == 'remove'

    def is_keep(self):
        """
        Check if the union tag is ``keep``.

        :rtype: bool
        """
        return self._tag == 'keep'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceUnlinkPolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceUnlinkPolicy(%r, %r)' % (self._tag, self._value)

DeviceUnlinkPolicy_validator = bv.Union(DeviceUnlinkPolicy)

class DeviceUnlinkType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DeviceUnlinkType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DeviceUnlinkType(description={!r})'.format(
            self._description_value,
        )

DeviceUnlinkType_validator = bv.Struct(DeviceUnlinkType)

class DirectoryRestrictionsAddMembersDetails(bb.Struct):
    """
    Added members to directory restrictions list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(DirectoryRestrictionsAddMembersDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DirectoryRestrictionsAddMembersDetails()'

DirectoryRestrictionsAddMembersDetails_validator = bv.Struct(DirectoryRestrictionsAddMembersDetails)

class DirectoryRestrictionsAddMembersType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DirectoryRestrictionsAddMembersType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DirectoryRestrictionsAddMembersType(description={!r})'.format(
            self._description_value,
        )

DirectoryRestrictionsAddMembersType_validator = bv.Struct(DirectoryRestrictionsAddMembersType)

class DirectoryRestrictionsRemoveMembersDetails(bb.Struct):
    """
    Removed members from directory restrictions list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(DirectoryRestrictionsRemoveMembersDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DirectoryRestrictionsRemoveMembersDetails()'

DirectoryRestrictionsRemoveMembersDetails_validator = bv.Struct(DirectoryRestrictionsRemoveMembersDetails)

class DirectoryRestrictionsRemoveMembersType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DirectoryRestrictionsRemoveMembersType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DirectoryRestrictionsRemoveMembersType(description={!r})'.format(
            self._description_value,
        )

DirectoryRestrictionsRemoveMembersType_validator = bv.Struct(DirectoryRestrictionsRemoveMembersType)

class DisabledDomainInvitesDetails(bb.Struct):
    """
    Disabled domain invites.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(DisabledDomainInvitesDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DisabledDomainInvitesDetails()'

DisabledDomainInvitesDetails_validator = bv.Struct(DisabledDomainInvitesDetails)

class DisabledDomainInvitesType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DisabledDomainInvitesType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DisabledDomainInvitesType(description={!r})'.format(
            self._description_value,
        )

DisabledDomainInvitesType_validator = bv.Struct(DisabledDomainInvitesType)

class DomainInvitesApproveRequestToJoinTeamDetails(bb.Struct):
    """
    Approved user's request to join team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesApproveRequestToJoinTeamDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesApproveRequestToJoinTeamDetails()'

DomainInvitesApproveRequestToJoinTeamDetails_validator = bv.Struct(DomainInvitesApproveRequestToJoinTeamDetails)

class DomainInvitesApproveRequestToJoinTeamType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesApproveRequestToJoinTeamType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesApproveRequestToJoinTeamType(description={!r})'.format(
            self._description_value,
        )

DomainInvitesApproveRequestToJoinTeamType_validator = bv.Struct(DomainInvitesApproveRequestToJoinTeamType)

class DomainInvitesDeclineRequestToJoinTeamDetails(bb.Struct):
    """
    Declined user's request to join team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesDeclineRequestToJoinTeamDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesDeclineRequestToJoinTeamDetails()'

DomainInvitesDeclineRequestToJoinTeamDetails_validator = bv.Struct(DomainInvitesDeclineRequestToJoinTeamDetails)

class DomainInvitesDeclineRequestToJoinTeamType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesDeclineRequestToJoinTeamType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesDeclineRequestToJoinTeamType(description={!r})'.format(
            self._description_value,
        )

DomainInvitesDeclineRequestToJoinTeamType_validator = bv.Struct(DomainInvitesDeclineRequestToJoinTeamType)

class DomainInvitesEmailExistingUsersDetails(bb.Struct):
    """
    Sent domain invites to existing domain accounts.

    :ivar domain_name: Domain names.
    :ivar num_recipients: Number of recipients.
    """

    __slots__ = [
        '_domain_name_value',
        '_domain_name_present',
        '_num_recipients_value',
        '_num_recipients_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None,
                 num_recipients=None):
        self._domain_name_value = None
        self._domain_name_present = False
        self._num_recipients_value = None
        self._num_recipients_present = False
        if domain_name is not None:
            self.domain_name = domain_name
        if num_recipients is not None:
            self.num_recipients = num_recipients

    @property
    def domain_name(self):
        """
        Domain names.

        :rtype: str
        """
        if self._domain_name_present:
            return self._domain_name_value
        else:
            raise AttributeError("missing required field 'domain_name'")

    @domain_name.setter
    def domain_name(self, val):
        val = self._domain_name_validator.validate(val)
        self._domain_name_value = val
        self._domain_name_present = True

    @domain_name.deleter
    def domain_name(self):
        self._domain_name_value = None
        self._domain_name_present = False

    @property
    def num_recipients(self):
        """
        Number of recipients.

        :rtype: long
        """
        if self._num_recipients_present:
            return self._num_recipients_value
        else:
            raise AttributeError("missing required field 'num_recipients'")

    @num_recipients.setter
    def num_recipients(self, val):
        val = self._num_recipients_validator.validate(val)
        self._num_recipients_value = val
        self._num_recipients_present = True

    @num_recipients.deleter
    def num_recipients(self):
        self._num_recipients_value = None
        self._num_recipients_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesEmailExistingUsersDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesEmailExistingUsersDetails(domain_name={!r}, num_recipients={!r})'.format(
            self._domain_name_value,
            self._num_recipients_value,
        )

DomainInvitesEmailExistingUsersDetails_validator = bv.Struct(DomainInvitesEmailExistingUsersDetails)

class DomainInvitesEmailExistingUsersType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesEmailExistingUsersType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesEmailExistingUsersType(description={!r})'.format(
            self._description_value,
        )

DomainInvitesEmailExistingUsersType_validator = bv.Struct(DomainInvitesEmailExistingUsersType)

class DomainInvitesRequestToJoinTeamDetails(bb.Struct):
    """
    Requested to join team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesRequestToJoinTeamDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesRequestToJoinTeamDetails()'

DomainInvitesRequestToJoinTeamDetails_validator = bv.Struct(DomainInvitesRequestToJoinTeamDetails)

class DomainInvitesRequestToJoinTeamType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesRequestToJoinTeamType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesRequestToJoinTeamType(description={!r})'.format(
            self._description_value,
        )

DomainInvitesRequestToJoinTeamType_validator = bv.Struct(DomainInvitesRequestToJoinTeamType)

class DomainInvitesSetInviteNewUserPrefToNoDetails(bb.Struct):
    """
    Disabled "Automatically invite new users".
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesSetInviteNewUserPrefToNoDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesSetInviteNewUserPrefToNoDetails()'

DomainInvitesSetInviteNewUserPrefToNoDetails_validator = bv.Struct(DomainInvitesSetInviteNewUserPrefToNoDetails)

class DomainInvitesSetInviteNewUserPrefToNoType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesSetInviteNewUserPrefToNoType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesSetInviteNewUserPrefToNoType(description={!r})'.format(
            self._description_value,
        )

DomainInvitesSetInviteNewUserPrefToNoType_validator = bv.Struct(DomainInvitesSetInviteNewUserPrefToNoType)

class DomainInvitesSetInviteNewUserPrefToYesDetails(bb.Struct):
    """
    Enabled "Automatically invite new users".
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesSetInviteNewUserPrefToYesDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesSetInviteNewUserPrefToYesDetails()'

DomainInvitesSetInviteNewUserPrefToYesDetails_validator = bv.Struct(DomainInvitesSetInviteNewUserPrefToYesDetails)

class DomainInvitesSetInviteNewUserPrefToYesType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainInvitesSetInviteNewUserPrefToYesType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainInvitesSetInviteNewUserPrefToYesType(description={!r})'.format(
            self._description_value,
        )

DomainInvitesSetInviteNewUserPrefToYesType_validator = bv.Struct(DomainInvitesSetInviteNewUserPrefToYesType)

class DomainVerificationAddDomainFailDetails(bb.Struct):
    """
    Failed to verify team domain.

    :ivar domain_name: Domain name.
    :ivar verification_method: Domain name verification method. Might be missing
        due to historical data gap.
    """

    __slots__ = [
        '_domain_name_value',
        '_domain_name_present',
        '_verification_method_value',
        '_verification_method_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None,
                 verification_method=None):
        self._domain_name_value = None
        self._domain_name_present = False
        self._verification_method_value = None
        self._verification_method_present = False
        if domain_name is not None:
            self.domain_name = domain_name
        if verification_method is not None:
            self.verification_method = verification_method

    @property
    def domain_name(self):
        """
        Domain name.

        :rtype: str
        """
        if self._domain_name_present:
            return self._domain_name_value
        else:
            raise AttributeError("missing required field 'domain_name'")

    @domain_name.setter
    def domain_name(self, val):
        val = self._domain_name_validator.validate(val)
        self._domain_name_value = val
        self._domain_name_present = True

    @domain_name.deleter
    def domain_name(self):
        self._domain_name_value = None
        self._domain_name_present = False

    @property
    def verification_method(self):
        """
        Domain name verification method. Might be missing due to historical data
        gap.

        :rtype: str
        """
        if self._verification_method_present:
            return self._verification_method_value
        else:
            return None

    @verification_method.setter
    def verification_method(self, val):
        if val is None:
            del self.verification_method
            return
        val = self._verification_method_validator.validate(val)
        self._verification_method_value = val
        self._verification_method_present = True

    @verification_method.deleter
    def verification_method(self):
        self._verification_method_value = None
        self._verification_method_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainVerificationAddDomainFailDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainVerificationAddDomainFailDetails(domain_name={!r}, verification_method={!r})'.format(
            self._domain_name_value,
            self._verification_method_value,
        )

DomainVerificationAddDomainFailDetails_validator = bv.Struct(DomainVerificationAddDomainFailDetails)

class DomainVerificationAddDomainFailType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainVerificationAddDomainFailType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainVerificationAddDomainFailType(description={!r})'.format(
            self._description_value,
        )

DomainVerificationAddDomainFailType_validator = bv.Struct(DomainVerificationAddDomainFailType)

class DomainVerificationAddDomainSuccessDetails(bb.Struct):
    """
    Verified team domain.

    :ivar domain_names: Domain names.
    :ivar verification_method: Domain name verification method. Might be missing
        due to historical data gap.
    """

    __slots__ = [
        '_domain_names_value',
        '_domain_names_present',
        '_verification_method_value',
        '_verification_method_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_names=None,
                 verification_method=None):
        self._domain_names_value = None
        self._domain_names_present = False
        self._verification_method_value = None
        self._verification_method_present = False
        if domain_names is not None:
            self.domain_names = domain_names
        if verification_method is not None:
            self.verification_method = verification_method

    @property
    def domain_names(self):
        """
        Domain names.

        :rtype: list of [str]
        """
        if self._domain_names_present:
            return self._domain_names_value
        else:
            raise AttributeError("missing required field 'domain_names'")

    @domain_names.setter
    def domain_names(self, val):
        val = self._domain_names_validator.validate(val)
        self._domain_names_value = val
        self._domain_names_present = True

    @domain_names.deleter
    def domain_names(self):
        self._domain_names_value = None
        self._domain_names_present = False

    @property
    def verification_method(self):
        """
        Domain name verification method. Might be missing due to historical data
        gap.

        :rtype: str
        """
        if self._verification_method_present:
            return self._verification_method_value
        else:
            return None

    @verification_method.setter
    def verification_method(self, val):
        if val is None:
            del self.verification_method
            return
        val = self._verification_method_validator.validate(val)
        self._verification_method_value = val
        self._verification_method_present = True

    @verification_method.deleter
    def verification_method(self):
        self._verification_method_value = None
        self._verification_method_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainVerificationAddDomainSuccessDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainVerificationAddDomainSuccessDetails(domain_names={!r}, verification_method={!r})'.format(
            self._domain_names_value,
            self._verification_method_value,
        )

DomainVerificationAddDomainSuccessDetails_validator = bv.Struct(DomainVerificationAddDomainSuccessDetails)

class DomainVerificationAddDomainSuccessType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainVerificationAddDomainSuccessType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainVerificationAddDomainSuccessType(description={!r})'.format(
            self._description_value,
        )

DomainVerificationAddDomainSuccessType_validator = bv.Struct(DomainVerificationAddDomainSuccessType)

class DomainVerificationRemoveDomainDetails(bb.Struct):
    """
    Removed domain from list of verified team domains.

    :ivar domain_names: Domain names.
    """

    __slots__ = [
        '_domain_names_value',
        '_domain_names_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_names=None):
        self._domain_names_value = None
        self._domain_names_present = False
        if domain_names is not None:
            self.domain_names = domain_names

    @property
    def domain_names(self):
        """
        Domain names.

        :rtype: list of [str]
        """
        if self._domain_names_present:
            return self._domain_names_value
        else:
            raise AttributeError("missing required field 'domain_names'")

    @domain_names.setter
    def domain_names(self, val):
        val = self._domain_names_validator.validate(val)
        self._domain_names_value = val
        self._domain_names_present = True

    @domain_names.deleter
    def domain_names(self):
        self._domain_names_value = None
        self._domain_names_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainVerificationRemoveDomainDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainVerificationRemoveDomainDetails(domain_names={!r})'.format(
            self._domain_names_value,
        )

DomainVerificationRemoveDomainDetails_validator = bv.Struct(DomainVerificationRemoveDomainDetails)

class DomainVerificationRemoveDomainType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DomainVerificationRemoveDomainType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DomainVerificationRemoveDomainType(description={!r})'.format(
            self._description_value,
        )

DomainVerificationRemoveDomainType_validator = bv.Struct(DomainVerificationRemoveDomainType)

class DownloadPolicyType(bb.Union):
    """
    Shared content downloads policy

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    allow = None
    # Attribute is overwritten below the class definition
    disallow = None
    # Attribute is overwritten below the class definition
    other = None

    def is_allow(self):
        """
        Check if the union tag is ``allow``.

        :rtype: bool
        """
        return self._tag == 'allow'

    def is_disallow(self):
        """
        Check if the union tag is ``disallow``.

        :rtype: bool
        """
        return self._tag == 'disallow'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(DownloadPolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DownloadPolicyType(%r, %r)' % (self._tag, self._value)

DownloadPolicyType_validator = bv.Union(DownloadPolicyType)

class DurationLogInfo(bb.Struct):
    """
    Represents a time duration: unit and amount

    :ivar unit: Time unit.
    :ivar amount: Amount of time.
    """

    __slots__ = [
        '_unit_value',
        '_unit_present',
        '_amount_value',
        '_amount_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 unit=None,
                 amount=None):
        self._unit_value = None
        self._unit_present = False
        self._amount_value = None
        self._amount_present = False
        if unit is not None:
            self.unit = unit
        if amount is not None:
            self.amount = amount

    @property
    def unit(self):
        """
        Time unit.

        :rtype: TimeUnit
        """
        if self._unit_present:
            return self._unit_value
        else:
            raise AttributeError("missing required field 'unit'")

    @unit.setter
    def unit(self, val):
        self._unit_validator.validate_type_only(val)
        self._unit_value = val
        self._unit_present = True

    @unit.deleter
    def unit(self):
        self._unit_value = None
        self._unit_present = False

    @property
    def amount(self):
        """
        Amount of time.

        :rtype: long
        """
        if self._amount_present:
            return self._amount_value
        else:
            raise AttributeError("missing required field 'amount'")

    @amount.setter
    def amount(self, val):
        val = self._amount_validator.validate(val)
        self._amount_value = val
        self._amount_present = True

    @amount.deleter
    def amount(self):
        self._amount_value = None
        self._amount_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(DurationLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DurationLogInfo(unit={!r}, amount={!r})'.format(
            self._unit_value,
            self._amount_value,
        )

DurationLogInfo_validator = bv.Struct(DurationLogInfo)

class EmmAddExceptionDetails(bb.Struct):
    """
    Added members to EMM exception list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmAddExceptionDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmAddExceptionDetails()'

EmmAddExceptionDetails_validator = bv.Struct(EmmAddExceptionDetails)

class EmmAddExceptionType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmAddExceptionType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmAddExceptionType(description={!r})'.format(
            self._description_value,
        )

EmmAddExceptionType_validator = bv.Struct(EmmAddExceptionType)

class EmmChangePolicyDetails(bb.Struct):
    """
    Enabled/disabled enterprise mobility management for members.

    :ivar new_value: New enterprise mobility management policy.
    :ivar previous_value: Previous enterprise mobility management policy. Might
        be missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New enterprise mobility management policy.

        :rtype: team_policies.EmmState
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous enterprise mobility management policy. Might be missing due to
        historical data gap.

        :rtype: team_policies.EmmState
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmChangePolicyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

EmmChangePolicyDetails_validator = bv.Struct(EmmChangePolicyDetails)

class EmmChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmChangePolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmChangePolicyType(description={!r})'.format(
            self._description_value,
        )

EmmChangePolicyType_validator = bv.Struct(EmmChangePolicyType)

class EmmCreateExceptionsReportDetails(bb.Struct):
    """
    Created EMM-excluded users report.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmCreateExceptionsReportDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmCreateExceptionsReportDetails()'

EmmCreateExceptionsReportDetails_validator = bv.Struct(EmmCreateExceptionsReportDetails)

class EmmCreateExceptionsReportType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmCreateExceptionsReportType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmCreateExceptionsReportType(description={!r})'.format(
            self._description_value,
        )

EmmCreateExceptionsReportType_validator = bv.Struct(EmmCreateExceptionsReportType)

class EmmCreateUsageReportDetails(bb.Struct):
    """
    Created EMM mobile app usage report.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmCreateUsageReportDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmCreateUsageReportDetails()'

EmmCreateUsageReportDetails_validator = bv.Struct(EmmCreateUsageReportDetails)

class EmmCreateUsageReportType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmCreateUsageReportType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmCreateUsageReportType(description={!r})'.format(
            self._description_value,
        )

EmmCreateUsageReportType_validator = bv.Struct(EmmCreateUsageReportType)

class EmmErrorDetails(bb.Struct):
    """
    Failed to sign in via EMM.

    :ivar error_details: Error details.
    """

    __slots__ = [
        '_error_details_value',
        '_error_details_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 error_details=None):
        self._error_details_value = None
        self._error_details_present = False
        if error_details is not None:
            self.error_details = error_details

    @property
    def error_details(self):
        """
        Error details.

        :rtype: FailureDetailsLogInfo
        """
        if self._error_details_present:
            return self._error_details_value
        else:
            raise AttributeError("missing required field 'error_details'")

    @error_details.setter
    def error_details(self, val):
        self._error_details_validator.validate_type_only(val)
        self._error_details_value = val
        self._error_details_present = True

    @error_details.deleter
    def error_details(self):
        self._error_details_value = None
        self._error_details_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmErrorDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmErrorDetails(error_details={!r})'.format(
            self._error_details_value,
        )

EmmErrorDetails_validator = bv.Struct(EmmErrorDetails)

class EmmErrorType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmErrorType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmErrorType(description={!r})'.format(
            self._description_value,
        )

EmmErrorType_validator = bv.Struct(EmmErrorType)

class EmmRefreshAuthTokenDetails(bb.Struct):
    """
    Refreshed auth token used for setting up enterprise mobility management.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmRefreshAuthTokenDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmRefreshAuthTokenDetails()'

EmmRefreshAuthTokenDetails_validator = bv.Struct(EmmRefreshAuthTokenDetails)

class EmmRefreshAuthTokenType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmRefreshAuthTokenType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmRefreshAuthTokenType(description={!r})'.format(
            self._description_value,
        )

EmmRefreshAuthTokenType_validator = bv.Struct(EmmRefreshAuthTokenType)

class EmmRemoveExceptionDetails(bb.Struct):
    """
    Removed members from EMM exception list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmRemoveExceptionDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmRemoveExceptionDetails()'

EmmRemoveExceptionDetails_validator = bv.Struct(EmmRemoveExceptionDetails)

class EmmRemoveExceptionType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(EmmRemoveExceptionType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EmmRemoveExceptionType(description={!r})'.format(
            self._description_value,
        )

EmmRemoveExceptionType_validator = bv.Struct(EmmRemoveExceptionType)

class EnabledDomainInvitesDetails(bb.Struct):
    """
    Enabled domain invites.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(EnabledDomainInvitesDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EnabledDomainInvitesDetails()'

EnabledDomainInvitesDetails_validator = bv.Struct(EnabledDomainInvitesDetails)

class EnabledDomainInvitesType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(EnabledDomainInvitesType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EnabledDomainInvitesType(description={!r})'.format(
            self._description_value,
        )

EnabledDomainInvitesType_validator = bv.Struct(EnabledDomainInvitesType)

class EventCategory(bb.Union):
    """
    Category of events in event audit log.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar apps: Events that apply to management of linked apps.
    :ivar comments: Events that have to do with comments on files and Paper
        documents.
    :ivar devices: Events that apply to linked devices on mobile, desktop and
        Web platforms.
    :ivar domains: Events that involve domain management feature: domain
        verification, invite enforcement and account capture.
    :ivar file_operations: Events that have to do with filesystem operations on
        files and folders: copy, move, delete, etc.
    :ivar file_requests: Events that apply to the file requests feature.
    :ivar groups: Events that involve group management.
    :ivar logins: Events that involve users signing in to or out of Dropbox.
    :ivar members: Events that involve team member management.
    :ivar paper: Events that apply to Dropbox Paper.
    :ivar passwords: Events that involve using, changing or resetting passwords.
    :ivar reports: Events that concern generation of admin reports, including
        team activity and device usage.
    :ivar sharing: Events that apply to all types of sharing and collaboration.
    :ivar showcase: Events that apply to Dropbox Showcase.
    :ivar sso: Events that involve using or configuring single sign-on as well
        as administrative policies concerning single sign-on.
    :ivar team_folders: Events that involve team folder management.
    :ivar team_policies: Events that involve a change in team-wide policies.
    :ivar team_profile: Events that involve a change in the team profile.
    :ivar tfa: Events that involve using or configuring two factor
        authentication as well as administrative policies concerning two factor
        authentication.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    apps = None
    # Attribute is overwritten below the class definition
    comments = None
    # Attribute is overwritten below the class definition
    devices = None
    # Attribute is overwritten below the class definition
    domains = None
    # Attribute is overwritten below the class definition
    file_operations = None
    # Attribute is overwritten below the class definition
    file_requests = None
    # Attribute is overwritten below the class definition
    groups = None
    # Attribute is overwritten below the class definition
    logins = None
    # Attribute is overwritten below the class definition
    members = None
    # Attribute is overwritten below the class definition
    paper = None
    # Attribute is overwritten below the class definition
    passwords = None
    # Attribute is overwritten below the class definition
    reports = None
    # Attribute is overwritten below the class definition
    sharing = None
    # Attribute is overwritten below the class definition
    showcase = None
    # Attribute is overwritten below the class definition
    sso = None
    # Attribute is overwritten below the class definition
    team_folders = None
    # Attribute is overwritten below the class definition
    team_policies = None
    # Attribute is overwritten below the class definition
    team_profile = None
    # Attribute is overwritten below the class definition
    tfa = None
    # Attribute is overwritten below the class definition
    other = None

    def is_apps(self):
        """
        Check if the union tag is ``apps``.

        :rtype: bool
        """
        return self._tag == 'apps'

    def is_comments(self):
        """
        Check if the union tag is ``comments``.

        :rtype: bool
        """
        return self._tag == 'comments'

    def is_devices(self):
        """
        Check if the union tag is ``devices``.

        :rtype: bool
        """
        return self._tag == 'devices'

    def is_domains(self):
        """
        Check if the union tag is ``domains``.

        :rtype: bool
        """
        return self._tag == 'domains'

    def is_file_operations(self):
        """
        Check if the union tag is ``file_operations``.

        :rtype: bool
        """
        return self._tag == 'file_operations'

    def is_file_requests(self):
        """
        Check if the union tag is ``file_requests``.

        :rtype: bool
        """
        return self._tag == 'file_requests'

    def is_groups(self):
        """
        Check if the union tag is ``groups``.

        :rtype: bool
        """
        return self._tag == 'groups'

    def is_logins(self):
        """
        Check if the union tag is ``logins``.

        :rtype: bool
        """
        return self._tag == 'logins'

    def is_members(self):
        """
        Check if the union tag is ``members``.

        :rtype: bool
        """
        return self._tag == 'members'

    def is_paper(self):
        """
        Check if the union tag is ``paper``.

        :rtype: bool
        """
        return self._tag == 'paper'

    def is_passwords(self):
        """
        Check if the union tag is ``passwords``.

        :rtype: bool
        """
        return self._tag == 'passwords'

    def is_reports(self):
        """
        Check if the union tag is ``reports``.

        :rtype: bool
        """
        return self._tag == 'reports'

    def is_sharing(self):
        """
        Check if the union tag is ``sharing``.

        :rtype: bool
        """
        return self._tag == 'sharing'

    def is_showcase(self):
        """
        Check if the union tag is ``showcase``.

        :rtype: bool
        """
        return self._tag == 'showcase'

    def is_sso(self):
        """
        Check if the union tag is ``sso``.

        :rtype: bool
        """
        return self._tag == 'sso'

    def is_team_folders(self):
        """
        Check if the union tag is ``team_folders``.

        :rtype: bool
        """
        return self._tag == 'team_folders'

    def is_team_policies(self):
        """
        Check if the union tag is ``team_policies``.

        :rtype: bool
        """
        return self._tag == 'team_policies'

    def is_team_profile(self):
        """
        Check if the union tag is ``team_profile``.

        :rtype: bool
        """
        return self._tag == 'team_profile'

    def is_tfa(self):
        """
        Check if the union tag is ``tfa``.

        :rtype: bool
        """
        return self._tag == 'tfa'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(EventCategory, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EventCategory(%r, %r)' % (self._tag, self._value)

EventCategory_validator = bv.Union(EventCategory)

class EventDetails(bb.Union):
    """
    Additional fields depending on the event type.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar MissingDetails missing_details: Hints that this event was returned
        with missing details due to an internal error.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def app_link_team_details(cls, val):
        """
        Create an instance of this class set to the ``app_link_team_details``
        tag with value ``val``.

        :param AppLinkTeamDetails val:
        :rtype: EventDetails
        """
        return cls('app_link_team_details', val)

    @classmethod
    def app_link_user_details(cls, val):
        """
        Create an instance of this class set to the ``app_link_user_details``
        tag with value ``val``.

        :param AppLinkUserDetails val:
        :rtype: EventDetails
        """
        return cls('app_link_user_details', val)

    @classmethod
    def app_unlink_team_details(cls, val):
        """
        Create an instance of this class set to the ``app_unlink_team_details``
        tag with value ``val``.

        :param AppUnlinkTeamDetails val:
        :rtype: EventDetails
        """
        return cls('app_unlink_team_details', val)

    @classmethod
    def app_unlink_user_details(cls, val):
        """
        Create an instance of this class set to the ``app_unlink_user_details``
        tag with value ``val``.

        :param AppUnlinkUserDetails val:
        :rtype: EventDetails
        """
        return cls('app_unlink_user_details', val)

    @classmethod
    def file_add_comment_details(cls, val):
        """
        Create an instance of this class set to the ``file_add_comment_details``
        tag with value ``val``.

        :param FileAddCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_add_comment_details', val)

    @classmethod
    def file_change_comment_subscription_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_change_comment_subscription_details`` tag with value ``val``.

        :param FileChangeCommentSubscriptionDetails val:
        :rtype: EventDetails
        """
        return cls('file_change_comment_subscription_details', val)

    @classmethod
    def file_delete_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_delete_comment_details`` tag with value ``val``.

        :param FileDeleteCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_delete_comment_details', val)

    @classmethod
    def file_like_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_like_comment_details`` tag with value ``val``.

        :param FileLikeCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_like_comment_details', val)

    @classmethod
    def file_resolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_resolve_comment_details`` tag with value ``val``.

        :param FileResolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_resolve_comment_details', val)

    @classmethod
    def file_unlike_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_unlike_comment_details`` tag with value ``val``.

        :param FileUnlikeCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_unlike_comment_details', val)

    @classmethod
    def file_unresolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_unresolve_comment_details`` tag with value ``val``.

        :param FileUnresolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_unresolve_comment_details', val)

    @classmethod
    def device_change_ip_desktop_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_change_ip_desktop_details`` tag with value ``val``.

        :param DeviceChangeIpDesktopDetails val:
        :rtype: EventDetails
        """
        return cls('device_change_ip_desktop_details', val)

    @classmethod
    def device_change_ip_mobile_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_change_ip_mobile_details`` tag with value ``val``.

        :param DeviceChangeIpMobileDetails val:
        :rtype: EventDetails
        """
        return cls('device_change_ip_mobile_details', val)

    @classmethod
    def device_change_ip_web_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_change_ip_web_details`` tag with value ``val``.

        :param DeviceChangeIpWebDetails val:
        :rtype: EventDetails
        """
        return cls('device_change_ip_web_details', val)

    @classmethod
    def device_delete_on_unlink_fail_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_delete_on_unlink_fail_details`` tag with value ``val``.

        :param DeviceDeleteOnUnlinkFailDetails val:
        :rtype: EventDetails
        """
        return cls('device_delete_on_unlink_fail_details', val)

    @classmethod
    def device_delete_on_unlink_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_delete_on_unlink_success_details`` tag with value ``val``.

        :param DeviceDeleteOnUnlinkSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('device_delete_on_unlink_success_details', val)

    @classmethod
    def device_link_fail_details(cls, val):
        """
        Create an instance of this class set to the ``device_link_fail_details``
        tag with value ``val``.

        :param DeviceLinkFailDetails val:
        :rtype: EventDetails
        """
        return cls('device_link_fail_details', val)

    @classmethod
    def device_link_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_link_success_details`` tag with value ``val``.

        :param DeviceLinkSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('device_link_success_details', val)

    @classmethod
    def device_management_disabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_management_disabled_details`` tag with value ``val``.

        :param DeviceManagementDisabledDetails val:
        :rtype: EventDetails
        """
        return cls('device_management_disabled_details', val)

    @classmethod
    def device_management_enabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_management_enabled_details`` tag with value ``val``.

        :param DeviceManagementEnabledDetails val:
        :rtype: EventDetails
        """
        return cls('device_management_enabled_details', val)

    @classmethod
    def device_unlink_details(cls, val):
        """
        Create an instance of this class set to the ``device_unlink_details``
        tag with value ``val``.

        :param DeviceUnlinkDetails val:
        :rtype: EventDetails
        """
        return cls('device_unlink_details', val)

    @classmethod
    def emm_refresh_auth_token_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_refresh_auth_token_details`` tag with value ``val``.

        :param EmmRefreshAuthTokenDetails val:
        :rtype: EventDetails
        """
        return cls('emm_refresh_auth_token_details', val)

    @classmethod
    def account_capture_change_availability_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_change_availability_details`` tag with value ``val``.

        :param AccountCaptureChangeAvailabilityDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_change_availability_details', val)

    @classmethod
    def account_capture_migrate_account_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_migrate_account_details`` tag with value ``val``.

        :param AccountCaptureMigrateAccountDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_migrate_account_details', val)

    @classmethod
    def account_capture_notification_emails_sent_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_notification_emails_sent_details`` tag with value
        ``val``.

        :param AccountCaptureNotificationEmailsSentDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_notification_emails_sent_details', val)

    @classmethod
    def account_capture_relinquish_account_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_relinquish_account_details`` tag with value ``val``.

        :param AccountCaptureRelinquishAccountDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_relinquish_account_details', val)

    @classmethod
    def disabled_domain_invites_details(cls, val):
        """
        Create an instance of this class set to the
        ``disabled_domain_invites_details`` tag with value ``val``.

        :param DisabledDomainInvitesDetails val:
        :rtype: EventDetails
        """
        return cls('disabled_domain_invites_details', val)

    @classmethod
    def domain_invites_approve_request_to_join_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_approve_request_to_join_team_details`` tag with value
        ``val``.

        :param DomainInvitesApproveRequestToJoinTeamDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_approve_request_to_join_team_details', val)

    @classmethod
    def domain_invites_decline_request_to_join_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_decline_request_to_join_team_details`` tag with value
        ``val``.

        :param DomainInvitesDeclineRequestToJoinTeamDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_decline_request_to_join_team_details', val)

    @classmethod
    def domain_invites_email_existing_users_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_email_existing_users_details`` tag with value ``val``.

        :param DomainInvitesEmailExistingUsersDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_email_existing_users_details', val)

    @classmethod
    def domain_invites_request_to_join_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_request_to_join_team_details`` tag with value ``val``.

        :param DomainInvitesRequestToJoinTeamDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_request_to_join_team_details', val)

    @classmethod
    def domain_invites_set_invite_new_user_pref_to_no_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_set_invite_new_user_pref_to_no_details`` tag with value
        ``val``.

        :param DomainInvitesSetInviteNewUserPrefToNoDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_set_invite_new_user_pref_to_no_details', val)

    @classmethod
    def domain_invites_set_invite_new_user_pref_to_yes_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_set_invite_new_user_pref_to_yes_details`` tag with
        value ``val``.

        :param DomainInvitesSetInviteNewUserPrefToYesDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_set_invite_new_user_pref_to_yes_details', val)

    @classmethod
    def domain_verification_add_domain_fail_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_add_domain_fail_details`` tag with value ``val``.

        :param DomainVerificationAddDomainFailDetails val:
        :rtype: EventDetails
        """
        return cls('domain_verification_add_domain_fail_details', val)

    @classmethod
    def domain_verification_add_domain_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_add_domain_success_details`` tag with value
        ``val``.

        :param DomainVerificationAddDomainSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('domain_verification_add_domain_success_details', val)

    @classmethod
    def domain_verification_remove_domain_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_remove_domain_details`` tag with value ``val``.

        :param DomainVerificationRemoveDomainDetails val:
        :rtype: EventDetails
        """
        return cls('domain_verification_remove_domain_details', val)

    @classmethod
    def enabled_domain_invites_details(cls, val):
        """
        Create an instance of this class set to the
        ``enabled_domain_invites_details`` tag with value ``val``.

        :param EnabledDomainInvitesDetails val:
        :rtype: EventDetails
        """
        return cls('enabled_domain_invites_details', val)

    @classmethod
    def create_folder_details(cls, val):
        """
        Create an instance of this class set to the ``create_folder_details``
        tag with value ``val``.

        :param CreateFolderDetails val:
        :rtype: EventDetails
        """
        return cls('create_folder_details', val)

    @classmethod
    def file_add_details(cls, val):
        """
        Create an instance of this class set to the ``file_add_details`` tag
        with value ``val``.

        :param FileAddDetails val:
        :rtype: EventDetails
        """
        return cls('file_add_details', val)

    @classmethod
    def file_copy_details(cls, val):
        """
        Create an instance of this class set to the ``file_copy_details`` tag
        with value ``val``.

        :param FileCopyDetails val:
        :rtype: EventDetails
        """
        return cls('file_copy_details', val)

    @classmethod
    def file_delete_details(cls, val):
        """
        Create an instance of this class set to the ``file_delete_details`` tag
        with value ``val``.

        :param FileDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('file_delete_details', val)

    @classmethod
    def file_download_details(cls, val):
        """
        Create an instance of this class set to the ``file_download_details``
        tag with value ``val``.

        :param FileDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('file_download_details', val)

    @classmethod
    def file_edit_details(cls, val):
        """
        Create an instance of this class set to the ``file_edit_details`` tag
        with value ``val``.

        :param FileEditDetails val:
        :rtype: EventDetails
        """
        return cls('file_edit_details', val)

    @classmethod
    def file_get_copy_reference_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_get_copy_reference_details`` tag with value ``val``.

        :param FileGetCopyReferenceDetails val:
        :rtype: EventDetails
        """
        return cls('file_get_copy_reference_details', val)

    @classmethod
    def file_move_details(cls, val):
        """
        Create an instance of this class set to the ``file_move_details`` tag
        with value ``val``.

        :param FileMoveDetails val:
        :rtype: EventDetails
        """
        return cls('file_move_details', val)

    @classmethod
    def file_permanently_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_permanently_delete_details`` tag with value ``val``.

        :param FilePermanentlyDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('file_permanently_delete_details', val)

    @classmethod
    def file_preview_details(cls, val):
        """
        Create an instance of this class set to the ``file_preview_details`` tag
        with value ``val``.

        :param FilePreviewDetails val:
        :rtype: EventDetails
        """
        return cls('file_preview_details', val)

    @classmethod
    def file_rename_details(cls, val):
        """
        Create an instance of this class set to the ``file_rename_details`` tag
        with value ``val``.

        :param FileRenameDetails val:
        :rtype: EventDetails
        """
        return cls('file_rename_details', val)

    @classmethod
    def file_restore_details(cls, val):
        """
        Create an instance of this class set to the ``file_restore_details`` tag
        with value ``val``.

        :param FileRestoreDetails val:
        :rtype: EventDetails
        """
        return cls('file_restore_details', val)

    @classmethod
    def file_revert_details(cls, val):
        """
        Create an instance of this class set to the ``file_revert_details`` tag
        with value ``val``.

        :param FileRevertDetails val:
        :rtype: EventDetails
        """
        return cls('file_revert_details', val)

    @classmethod
    def file_rollback_changes_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_rollback_changes_details`` tag with value ``val``.

        :param FileRollbackChangesDetails val:
        :rtype: EventDetails
        """
        return cls('file_rollback_changes_details', val)

    @classmethod
    def file_save_copy_reference_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_save_copy_reference_details`` tag with value ``val``.

        :param FileSaveCopyReferenceDetails val:
        :rtype: EventDetails
        """
        return cls('file_save_copy_reference_details', val)

    @classmethod
    def file_request_change_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_change_details`` tag with value ``val``.

        :param FileRequestChangeDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_change_details', val)

    @classmethod
    def file_request_close_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_close_details`` tag with value ``val``.

        :param FileRequestCloseDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_close_details', val)

    @classmethod
    def file_request_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_create_details`` tag with value ``val``.

        :param FileRequestCreateDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_create_details', val)

    @classmethod
    def file_request_receive_file_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_receive_file_details`` tag with value ``val``.

        :param FileRequestReceiveFileDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_receive_file_details', val)

    @classmethod
    def group_add_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_add_external_id_details`` tag with value ``val``.

        :param GroupAddExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('group_add_external_id_details', val)

    @classmethod
    def group_add_member_details(cls, val):
        """
        Create an instance of this class set to the ``group_add_member_details``
        tag with value ``val``.

        :param GroupAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('group_add_member_details', val)

    @classmethod
    def group_change_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_external_id_details`` tag with value ``val``.

        :param GroupChangeExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('group_change_external_id_details', val)

    @classmethod
    def group_change_management_type_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_management_type_details`` tag with value ``val``.

        :param GroupChangeManagementTypeDetails val:
        :rtype: EventDetails
        """
        return cls('group_change_management_type_details', val)

    @classmethod
    def group_change_member_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_member_role_details`` tag with value ``val``.

        :param GroupChangeMemberRoleDetails val:
        :rtype: EventDetails
        """
        return cls('group_change_member_role_details', val)

    @classmethod
    def group_create_details(cls, val):
        """
        Create an instance of this class set to the ``group_create_details`` tag
        with value ``val``.

        :param GroupCreateDetails val:
        :rtype: EventDetails
        """
        return cls('group_create_details', val)

    @classmethod
    def group_delete_details(cls, val):
        """
        Create an instance of this class set to the ``group_delete_details`` tag
        with value ``val``.

        :param GroupDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('group_delete_details', val)

    @classmethod
    def group_description_updated_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_description_updated_details`` tag with value ``val``.

        :param GroupDescriptionUpdatedDetails val:
        :rtype: EventDetails
        """
        return cls('group_description_updated_details', val)

    @classmethod
    def group_join_policy_updated_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_join_policy_updated_details`` tag with value ``val``.

        :param GroupJoinPolicyUpdatedDetails val:
        :rtype: EventDetails
        """
        return cls('group_join_policy_updated_details', val)

    @classmethod
    def group_moved_details(cls, val):
        """
        Create an instance of this class set to the ``group_moved_details`` tag
        with value ``val``.

        :param GroupMovedDetails val:
        :rtype: EventDetails
        """
        return cls('group_moved_details', val)

    @classmethod
    def group_remove_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_remove_external_id_details`` tag with value ``val``.

        :param GroupRemoveExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('group_remove_external_id_details', val)

    @classmethod
    def group_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_remove_member_details`` tag with value ``val``.

        :param GroupRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('group_remove_member_details', val)

    @classmethod
    def group_rename_details(cls, val):
        """
        Create an instance of this class set to the ``group_rename_details`` tag
        with value ``val``.

        :param GroupRenameDetails val:
        :rtype: EventDetails
        """
        return cls('group_rename_details', val)

    @classmethod
    def emm_error_details(cls, val):
        """
        Create an instance of this class set to the ``emm_error_details`` tag
        with value ``val``.

        :param EmmErrorDetails val:
        :rtype: EventDetails
        """
        return cls('emm_error_details', val)

    @classmethod
    def login_fail_details(cls, val):
        """
        Create an instance of this class set to the ``login_fail_details`` tag
        with value ``val``.

        :param LoginFailDetails val:
        :rtype: EventDetails
        """
        return cls('login_fail_details', val)

    @classmethod
    def login_success_details(cls, val):
        """
        Create an instance of this class set to the ``login_success_details``
        tag with value ``val``.

        :param LoginSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('login_success_details', val)

    @classmethod
    def logout_details(cls, val):
        """
        Create an instance of this class set to the ``logout_details`` tag with
        value ``val``.

        :param LogoutDetails val:
        :rtype: EventDetails
        """
        return cls('logout_details', val)

    @classmethod
    def reseller_support_session_end_details(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_session_end_details`` tag with value ``val``.

        :param ResellerSupportSessionEndDetails val:
        :rtype: EventDetails
        """
        return cls('reseller_support_session_end_details', val)

    @classmethod
    def reseller_support_session_start_details(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_session_start_details`` tag with value ``val``.

        :param ResellerSupportSessionStartDetails val:
        :rtype: EventDetails
        """
        return cls('reseller_support_session_start_details', val)

    @classmethod
    def sign_in_as_session_end_details(cls, val):
        """
        Create an instance of this class set to the
        ``sign_in_as_session_end_details`` tag with value ``val``.

        :param SignInAsSessionEndDetails val:
        :rtype: EventDetails
        """
        return cls('sign_in_as_session_end_details', val)

    @classmethod
    def sign_in_as_session_start_details(cls, val):
        """
        Create an instance of this class set to the
        ``sign_in_as_session_start_details`` tag with value ``val``.

        :param SignInAsSessionStartDetails val:
        :rtype: EventDetails
        """
        return cls('sign_in_as_session_start_details', val)

    @classmethod
    def sso_error_details(cls, val):
        """
        Create an instance of this class set to the ``sso_error_details`` tag
        with value ``val``.

        :param SsoErrorDetails val:
        :rtype: EventDetails
        """
        return cls('sso_error_details', val)

    @classmethod
    def member_add_name_details(cls, val):
        """
        Create an instance of this class set to the ``member_add_name_details``
        tag with value ``val``.

        :param MemberAddNameDetails val:
        :rtype: EventDetails
        """
        return cls('member_add_name_details', val)

    @classmethod
    def member_change_admin_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_admin_role_details`` tag with value ``val``.

        :param MemberChangeAdminRoleDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_admin_role_details', val)

    @classmethod
    def member_change_email_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_email_details`` tag with value ``val``.

        :param MemberChangeEmailDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_email_details', val)

    @classmethod
    def member_change_membership_type_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_membership_type_details`` tag with value ``val``.

        :param MemberChangeMembershipTypeDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_membership_type_details', val)

    @classmethod
    def member_change_name_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_name_details`` tag with value ``val``.

        :param MemberChangeNameDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_name_details', val)

    @classmethod
    def member_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_status_details`` tag with value ``val``.

        :param MemberChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_status_details', val)

    @classmethod
    def member_delete_manual_contacts_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_delete_manual_contacts_details`` tag with value ``val``.

        :param MemberDeleteManualContactsDetails val:
        :rtype: EventDetails
        """
        return cls('member_delete_manual_contacts_details', val)

    @classmethod
    def member_permanently_delete_account_contents_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_permanently_delete_account_contents_details`` tag with value
        ``val``.

        :param MemberPermanentlyDeleteAccountContentsDetails val:
        :rtype: EventDetails
        """
        return cls('member_permanently_delete_account_contents_details', val)

    @classmethod
    def member_space_limits_add_custom_quota_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_add_custom_quota_details`` tag with value ``val``.

        :param MemberSpaceLimitsAddCustomQuotaDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_add_custom_quota_details', val)

    @classmethod
    def member_space_limits_change_custom_quota_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_custom_quota_details`` tag with value
        ``val``.

        :param MemberSpaceLimitsChangeCustomQuotaDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_change_custom_quota_details', val)

    @classmethod
    def member_space_limits_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_status_details`` tag with value ``val``.

        :param MemberSpaceLimitsChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_change_status_details', val)

    @classmethod
    def member_space_limits_remove_custom_quota_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_remove_custom_quota_details`` tag with value
        ``val``.

        :param MemberSpaceLimitsRemoveCustomQuotaDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_remove_custom_quota_details', val)

    @classmethod
    def member_suggest_details(cls, val):
        """
        Create an instance of this class set to the ``member_suggest_details``
        tag with value ``val``.

        :param MemberSuggestDetails val:
        :rtype: EventDetails
        """
        return cls('member_suggest_details', val)

    @classmethod
    def member_transfer_account_contents_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_transfer_account_contents_details`` tag with value ``val``.

        :param MemberTransferAccountContentsDetails val:
        :rtype: EventDetails
        """
        return cls('member_transfer_account_contents_details', val)

    @classmethod
    def secondary_mails_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``secondary_mails_policy_changed_details`` tag with value ``val``.

        :param SecondaryMailsPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('secondary_mails_policy_changed_details', val)

    @classmethod
    def paper_content_add_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_add_member_details`` tag with value ``val``.

        :param PaperContentAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_add_member_details', val)

    @classmethod
    def paper_content_add_to_folder_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_add_to_folder_details`` tag with value ``val``.

        :param PaperContentAddToFolderDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_add_to_folder_details', val)

    @classmethod
    def paper_content_archive_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_archive_details`` tag with value ``val``.

        :param PaperContentArchiveDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_archive_details', val)

    @classmethod
    def paper_content_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_create_details`` tag with value ``val``.

        :param PaperContentCreateDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_create_details', val)

    @classmethod
    def paper_content_permanently_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_permanently_delete_details`` tag with value ``val``.

        :param PaperContentPermanentlyDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_permanently_delete_details', val)

    @classmethod
    def paper_content_remove_from_folder_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_remove_from_folder_details`` tag with value ``val``.

        :param PaperContentRemoveFromFolderDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_remove_from_folder_details', val)

    @classmethod
    def paper_content_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_remove_member_details`` tag with value ``val``.

        :param PaperContentRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_remove_member_details', val)

    @classmethod
    def paper_content_rename_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_rename_details`` tag with value ``val``.

        :param PaperContentRenameDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_rename_details', val)

    @classmethod
    def paper_content_restore_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_restore_details`` tag with value ``val``.

        :param PaperContentRestoreDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_restore_details', val)

    @classmethod
    def paper_doc_add_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_add_comment_details`` tag with value ``val``.

        :param PaperDocAddCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_add_comment_details', val)

    @classmethod
    def paper_doc_change_member_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_member_role_details`` tag with value ``val``.

        :param PaperDocChangeMemberRoleDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_change_member_role_details', val)

    @classmethod
    def paper_doc_change_sharing_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_sharing_policy_details`` tag with value ``val``.

        :param PaperDocChangeSharingPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_change_sharing_policy_details', val)

    @classmethod
    def paper_doc_change_subscription_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_subscription_details`` tag with value ``val``.

        :param PaperDocChangeSubscriptionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_change_subscription_details', val)

    @classmethod
    def paper_doc_deleted_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_deleted_details`` tag with value ``val``.

        :param PaperDocDeletedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_deleted_details', val)

    @classmethod
    def paper_doc_delete_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_delete_comment_details`` tag with value ``val``.

        :param PaperDocDeleteCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_delete_comment_details', val)

    @classmethod
    def paper_doc_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_download_details`` tag with value ``val``.

        :param PaperDocDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_download_details', val)

    @classmethod
    def paper_doc_edit_details(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_edit_details``
        tag with value ``val``.

        :param PaperDocEditDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_edit_details', val)

    @classmethod
    def paper_doc_edit_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_edit_comment_details`` tag with value ``val``.

        :param PaperDocEditCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_edit_comment_details', val)

    @classmethod
    def paper_doc_followed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_followed_details`` tag with value ``val``.

        :param PaperDocFollowedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_followed_details', val)

    @classmethod
    def paper_doc_mention_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_mention_details`` tag with value ``val``.

        :param PaperDocMentionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_mention_details', val)

    @classmethod
    def paper_doc_ownership_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_ownership_changed_details`` tag with value ``val``.

        :param PaperDocOwnershipChangedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_ownership_changed_details', val)

    @classmethod
    def paper_doc_request_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_request_access_details`` tag with value ``val``.

        :param PaperDocRequestAccessDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_request_access_details', val)

    @classmethod
    def paper_doc_resolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_resolve_comment_details`` tag with value ``val``.

        :param PaperDocResolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_resolve_comment_details', val)

    @classmethod
    def paper_doc_revert_details(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_revert_details``
        tag with value ``val``.

        :param PaperDocRevertDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_revert_details', val)

    @classmethod
    def paper_doc_slack_share_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_slack_share_details`` tag with value ``val``.

        :param PaperDocSlackShareDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_slack_share_details', val)

    @classmethod
    def paper_doc_team_invite_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_team_invite_details`` tag with value ``val``.

        :param PaperDocTeamInviteDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_team_invite_details', val)

    @classmethod
    def paper_doc_trashed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_trashed_details`` tag with value ``val``.

        :param PaperDocTrashedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_trashed_details', val)

    @classmethod
    def paper_doc_unresolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_unresolve_comment_details`` tag with value ``val``.

        :param PaperDocUnresolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_unresolve_comment_details', val)

    @classmethod
    def paper_doc_untrashed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_untrashed_details`` tag with value ``val``.

        :param PaperDocUntrashedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_untrashed_details', val)

    @classmethod
    def paper_doc_view_details(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_view_details``
        tag with value ``val``.

        :param PaperDocViewDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_view_details', val)

    @classmethod
    def paper_external_view_allow_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_allow_details`` tag with value ``val``.

        :param PaperExternalViewAllowDetails val:
        :rtype: EventDetails
        """
        return cls('paper_external_view_allow_details', val)

    @classmethod
    def paper_external_view_default_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_default_team_details`` tag with value ``val``.

        :param PaperExternalViewDefaultTeamDetails val:
        :rtype: EventDetails
        """
        return cls('paper_external_view_default_team_details', val)

    @classmethod
    def paper_external_view_forbid_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_forbid_details`` tag with value ``val``.

        :param PaperExternalViewForbidDetails val:
        :rtype: EventDetails
        """
        return cls('paper_external_view_forbid_details', val)

    @classmethod
    def paper_folder_change_subscription_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_change_subscription_details`` tag with value ``val``.

        :param PaperFolderChangeSubscriptionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_change_subscription_details', val)

    @classmethod
    def paper_folder_deleted_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_deleted_details`` tag with value ``val``.

        :param PaperFolderDeletedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_deleted_details', val)

    @classmethod
    def paper_folder_followed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_followed_details`` tag with value ``val``.

        :param PaperFolderFollowedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_followed_details', val)

    @classmethod
    def paper_folder_team_invite_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_team_invite_details`` tag with value ``val``.

        :param PaperFolderTeamInviteDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_team_invite_details', val)

    @classmethod
    def password_change_details(cls, val):
        """
        Create an instance of this class set to the ``password_change_details``
        tag with value ``val``.

        :param PasswordChangeDetails val:
        :rtype: EventDetails
        """
        return cls('password_change_details', val)

    @classmethod
    def password_reset_details(cls, val):
        """
        Create an instance of this class set to the ``password_reset_details``
        tag with value ``val``.

        :param PasswordResetDetails val:
        :rtype: EventDetails
        """
        return cls('password_reset_details', val)

    @classmethod
    def password_reset_all_details(cls, val):
        """
        Create an instance of this class set to the
        ``password_reset_all_details`` tag with value ``val``.

        :param PasswordResetAllDetails val:
        :rtype: EventDetails
        """
        return cls('password_reset_all_details', val)

    @classmethod
    def emm_create_exceptions_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_create_exceptions_report_details`` tag with value ``val``.

        :param EmmCreateExceptionsReportDetails val:
        :rtype: EventDetails
        """
        return cls('emm_create_exceptions_report_details', val)

    @classmethod
    def emm_create_usage_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_create_usage_report_details`` tag with value ``val``.

        :param EmmCreateUsageReportDetails val:
        :rtype: EventDetails
        """
        return cls('emm_create_usage_report_details', val)

    @classmethod
    def export_members_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``export_members_report_details`` tag with value ``val``.

        :param ExportMembersReportDetails val:
        :rtype: EventDetails
        """
        return cls('export_members_report_details', val)

    @classmethod
    def paper_admin_export_start_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_admin_export_start_details`` tag with value ``val``.

        :param PaperAdminExportStartDetails val:
        :rtype: EventDetails
        """
        return cls('paper_admin_export_start_details', val)

    @classmethod
    def smart_sync_create_admin_privilege_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_create_admin_privilege_report_details`` tag with value
        ``val``.

        :param SmartSyncCreateAdminPrivilegeReportDetails val:
        :rtype: EventDetails
        """
        return cls('smart_sync_create_admin_privilege_report_details', val)

    @classmethod
    def team_activity_create_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_activity_create_report_details`` tag with value ``val``.

        :param TeamActivityCreateReportDetails val:
        :rtype: EventDetails
        """
        return cls('team_activity_create_report_details', val)

    @classmethod
    def collection_share_details(cls, val):
        """
        Create an instance of this class set to the ``collection_share_details``
        tag with value ``val``.

        :param CollectionShareDetails val:
        :rtype: EventDetails
        """
        return cls('collection_share_details', val)

    @classmethod
    def note_acl_invite_only_details(cls, val):
        """
        Create an instance of this class set to the
        ``note_acl_invite_only_details`` tag with value ``val``.

        :param NoteAclInviteOnlyDetails val:
        :rtype: EventDetails
        """
        return cls('note_acl_invite_only_details', val)

    @classmethod
    def note_acl_link_details(cls, val):
        """
        Create an instance of this class set to the ``note_acl_link_details``
        tag with value ``val``.

        :param NoteAclLinkDetails val:
        :rtype: EventDetails
        """
        return cls('note_acl_link_details', val)

    @classmethod
    def note_acl_team_link_details(cls, val):
        """
        Create an instance of this class set to the
        ``note_acl_team_link_details`` tag with value ``val``.

        :param NoteAclTeamLinkDetails val:
        :rtype: EventDetails
        """
        return cls('note_acl_team_link_details', val)

    @classmethod
    def note_shared_details(cls, val):
        """
        Create an instance of this class set to the ``note_shared_details`` tag
        with value ``val``.

        :param NoteSharedDetails val:
        :rtype: EventDetails
        """
        return cls('note_shared_details', val)

    @classmethod
    def note_share_receive_details(cls, val):
        """
        Create an instance of this class set to the
        ``note_share_receive_details`` tag with value ``val``.

        :param NoteShareReceiveDetails val:
        :rtype: EventDetails
        """
        return cls('note_share_receive_details', val)

    @classmethod
    def open_note_shared_details(cls, val):
        """
        Create an instance of this class set to the ``open_note_shared_details``
        tag with value ``val``.

        :param OpenNoteSharedDetails val:
        :rtype: EventDetails
        """
        return cls('open_note_shared_details', val)

    @classmethod
    def sf_add_group_details(cls, val):
        """
        Create an instance of this class set to the ``sf_add_group_details`` tag
        with value ``val``.

        :param SfAddGroupDetails val:
        :rtype: EventDetails
        """
        return cls('sf_add_group_details', val)

    @classmethod
    def sf_allow_non_members_to_view_shared_links_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_allow_non_members_to_view_shared_links_details`` tag with value
        ``val``.

        :param SfAllowNonMembersToViewSharedLinksDetails val:
        :rtype: EventDetails
        """
        return cls('sf_allow_non_members_to_view_shared_links_details', val)

    @classmethod
    def sf_external_invite_warn_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_external_invite_warn_details`` tag with value ``val``.

        :param SfExternalInviteWarnDetails val:
        :rtype: EventDetails
        """
        return cls('sf_external_invite_warn_details', val)

    @classmethod
    def sf_fb_invite_details(cls, val):
        """
        Create an instance of this class set to the ``sf_fb_invite_details`` tag
        with value ``val``.

        :param SfFbInviteDetails val:
        :rtype: EventDetails
        """
        return cls('sf_fb_invite_details', val)

    @classmethod
    def sf_fb_invite_change_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_fb_invite_change_role_details`` tag with value ``val``.

        :param SfFbInviteChangeRoleDetails val:
        :rtype: EventDetails
        """
        return cls('sf_fb_invite_change_role_details', val)

    @classmethod
    def sf_fb_uninvite_details(cls, val):
        """
        Create an instance of this class set to the ``sf_fb_uninvite_details``
        tag with value ``val``.

        :param SfFbUninviteDetails val:
        :rtype: EventDetails
        """
        return cls('sf_fb_uninvite_details', val)

    @classmethod
    def sf_invite_group_details(cls, val):
        """
        Create an instance of this class set to the ``sf_invite_group_details``
        tag with value ``val``.

        :param SfInviteGroupDetails val:
        :rtype: EventDetails
        """
        return cls('sf_invite_group_details', val)

    @classmethod
    def sf_team_grant_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_grant_access_details`` tag with value ``val``.

        :param SfTeamGrantAccessDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_grant_access_details', val)

    @classmethod
    def sf_team_invite_details(cls, val):
        """
        Create an instance of this class set to the ``sf_team_invite_details``
        tag with value ``val``.

        :param SfTeamInviteDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_invite_details', val)

    @classmethod
    def sf_team_invite_change_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_invite_change_role_details`` tag with value ``val``.

        :param SfTeamInviteChangeRoleDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_invite_change_role_details', val)

    @classmethod
    def sf_team_join_details(cls, val):
        """
        Create an instance of this class set to the ``sf_team_join_details`` tag
        with value ``val``.

        :param SfTeamJoinDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_join_details', val)

    @classmethod
    def sf_team_join_from_oob_link_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_join_from_oob_link_details`` tag with value ``val``.

        :param SfTeamJoinFromOobLinkDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_join_from_oob_link_details', val)

    @classmethod
    def sf_team_uninvite_details(cls, val):
        """
        Create an instance of this class set to the ``sf_team_uninvite_details``
        tag with value ``val``.

        :param SfTeamUninviteDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_uninvite_details', val)

    @classmethod
    def shared_content_add_invitees_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_invitees_details`` tag with value ``val``.

        :param SharedContentAddInviteesDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_invitees_details', val)

    @classmethod
    def shared_content_add_link_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_link_expiry_details`` tag with value ``val``.

        :param SharedContentAddLinkExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_link_expiry_details', val)

    @classmethod
    def shared_content_add_link_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_link_password_details`` tag with value ``val``.

        :param SharedContentAddLinkPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_link_password_details', val)

    @classmethod
    def shared_content_add_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_member_details`` tag with value ``val``.

        :param SharedContentAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_member_details', val)

    @classmethod
    def shared_content_change_downloads_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_downloads_policy_details`` tag with value
        ``val``.

        :param SharedContentChangeDownloadsPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_downloads_policy_details', val)

    @classmethod
    def shared_content_change_invitee_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_invitee_role_details`` tag with value ``val``.

        :param SharedContentChangeInviteeRoleDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_invitee_role_details', val)

    @classmethod
    def shared_content_change_link_audience_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_audience_details`` tag with value ``val``.

        :param SharedContentChangeLinkAudienceDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_link_audience_details', val)

    @classmethod
    def shared_content_change_link_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_expiry_details`` tag with value ``val``.

        :param SharedContentChangeLinkExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_link_expiry_details', val)

    @classmethod
    def shared_content_change_link_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_password_details`` tag with value ``val``.

        :param SharedContentChangeLinkPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_link_password_details', val)

    @classmethod
    def shared_content_change_member_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_member_role_details`` tag with value ``val``.

        :param SharedContentChangeMemberRoleDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_member_role_details', val)

    @classmethod
    def shared_content_change_viewer_info_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_viewer_info_policy_details`` tag with value
        ``val``.

        :param SharedContentChangeViewerInfoPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_viewer_info_policy_details', val)

    @classmethod
    def shared_content_claim_invitation_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_claim_invitation_details`` tag with value ``val``.

        :param SharedContentClaimInvitationDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_claim_invitation_details', val)

    @classmethod
    def shared_content_copy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_copy_details`` tag with value ``val``.

        :param SharedContentCopyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_copy_details', val)

    @classmethod
    def shared_content_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_download_details`` tag with value ``val``.

        :param SharedContentDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_download_details', val)

    @classmethod
    def shared_content_relinquish_membership_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_relinquish_membership_details`` tag with value ``val``.

        :param SharedContentRelinquishMembershipDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_relinquish_membership_details', val)

    @classmethod
    def shared_content_remove_invitees_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_invitees_details`` tag with value ``val``.

        :param SharedContentRemoveInviteesDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_invitees_details', val)

    @classmethod
    def shared_content_remove_link_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_link_expiry_details`` tag with value ``val``.

        :param SharedContentRemoveLinkExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_link_expiry_details', val)

    @classmethod
    def shared_content_remove_link_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_link_password_details`` tag with value ``val``.

        :param SharedContentRemoveLinkPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_link_password_details', val)

    @classmethod
    def shared_content_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_member_details`` tag with value ``val``.

        :param SharedContentRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_member_details', val)

    @classmethod
    def shared_content_request_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_request_access_details`` tag with value ``val``.

        :param SharedContentRequestAccessDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_request_access_details', val)

    @classmethod
    def shared_content_unshare_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_unshare_details`` tag with value ``val``.

        :param SharedContentUnshareDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_unshare_details', val)

    @classmethod
    def shared_content_view_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_view_details`` tag with value ``val``.

        :param SharedContentViewDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_view_details', val)

    @classmethod
    def shared_folder_change_link_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_link_policy_details`` tag with value ``val``.

        :param SharedFolderChangeLinkPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_link_policy_details', val)

    @classmethod
    def shared_folder_change_members_inheritance_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_inheritance_policy_details`` tag with
        value ``val``.

        :param SharedFolderChangeMembersInheritancePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_members_inheritance_policy_details', val)

    @classmethod
    def shared_folder_change_members_management_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_management_policy_details`` tag with
        value ``val``.

        :param SharedFolderChangeMembersManagementPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_members_management_policy_details', val)

    @classmethod
    def shared_folder_change_members_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_policy_details`` tag with value ``val``.

        :param SharedFolderChangeMembersPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_members_policy_details', val)

    @classmethod
    def shared_folder_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_create_details`` tag with value ``val``.

        :param SharedFolderCreateDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_create_details', val)

    @classmethod
    def shared_folder_decline_invitation_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_decline_invitation_details`` tag with value ``val``.

        :param SharedFolderDeclineInvitationDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_decline_invitation_details', val)

    @classmethod
    def shared_folder_mount_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_mount_details`` tag with value ``val``.

        :param SharedFolderMountDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_mount_details', val)

    @classmethod
    def shared_folder_nest_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_nest_details`` tag with value ``val``.

        :param SharedFolderNestDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_nest_details', val)

    @classmethod
    def shared_folder_transfer_ownership_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_transfer_ownership_details`` tag with value ``val``.

        :param SharedFolderTransferOwnershipDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_transfer_ownership_details', val)

    @classmethod
    def shared_folder_unmount_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_unmount_details`` tag with value ``val``.

        :param SharedFolderUnmountDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_unmount_details', val)

    @classmethod
    def shared_link_add_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_add_expiry_details`` tag with value ``val``.

        :param SharedLinkAddExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_add_expiry_details', val)

    @classmethod
    def shared_link_change_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_change_expiry_details`` tag with value ``val``.

        :param SharedLinkChangeExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_change_expiry_details', val)

    @classmethod
    def shared_link_change_visibility_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_change_visibility_details`` tag with value ``val``.

        :param SharedLinkChangeVisibilityDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_change_visibility_details', val)

    @classmethod
    def shared_link_copy_details(cls, val):
        """
        Create an instance of this class set to the ``shared_link_copy_details``
        tag with value ``val``.

        :param SharedLinkCopyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_copy_details', val)

    @classmethod
    def shared_link_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_create_details`` tag with value ``val``.

        :param SharedLinkCreateDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_create_details', val)

    @classmethod
    def shared_link_disable_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_disable_details`` tag with value ``val``.

        :param SharedLinkDisableDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_disable_details', val)

    @classmethod
    def shared_link_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_download_details`` tag with value ``val``.

        :param SharedLinkDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_download_details', val)

    @classmethod
    def shared_link_remove_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_remove_expiry_details`` tag with value ``val``.

        :param SharedLinkRemoveExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_remove_expiry_details', val)

    @classmethod
    def shared_link_share_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_share_details`` tag with value ``val``.

        :param SharedLinkShareDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_share_details', val)

    @classmethod
    def shared_link_view_details(cls, val):
        """
        Create an instance of this class set to the ``shared_link_view_details``
        tag with value ``val``.

        :param SharedLinkViewDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_view_details', val)

    @classmethod
    def shared_note_opened_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_note_opened_details`` tag with value ``val``.

        :param SharedNoteOpenedDetails val:
        :rtype: EventDetails
        """
        return cls('shared_note_opened_details', val)

    @classmethod
    def shmodel_group_share_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_group_share_details`` tag with value ``val``.

        :param ShmodelGroupShareDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_group_share_details', val)

    @classmethod
    def showcase_access_granted_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_access_granted_details`` tag with value ``val``.

        :param ShowcaseAccessGrantedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_access_granted_details', val)

    @classmethod
    def showcase_add_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_add_member_details`` tag with value ``val``.

        :param ShowcaseAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_add_member_details', val)

    @classmethod
    def showcase_archived_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_archived_details`` tag with value ``val``.

        :param ShowcaseArchivedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_archived_details', val)

    @classmethod
    def showcase_created_details(cls, val):
        """
        Create an instance of this class set to the ``showcase_created_details``
        tag with value ``val``.

        :param ShowcaseCreatedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_created_details', val)

    @classmethod
    def showcase_delete_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_delete_comment_details`` tag with value ``val``.

        :param ShowcaseDeleteCommentDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_delete_comment_details', val)

    @classmethod
    def showcase_edited_details(cls, val):
        """
        Create an instance of this class set to the ``showcase_edited_details``
        tag with value ``val``.

        :param ShowcaseEditedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_edited_details', val)

    @classmethod
    def showcase_edit_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_edit_comment_details`` tag with value ``val``.

        :param ShowcaseEditCommentDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_edit_comment_details', val)

    @classmethod
    def showcase_file_added_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_file_added_details`` tag with value ``val``.

        :param ShowcaseFileAddedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_file_added_details', val)

    @classmethod
    def showcase_file_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_file_download_details`` tag with value ``val``.

        :param ShowcaseFileDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_file_download_details', val)

    @classmethod
    def showcase_file_removed_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_file_removed_details`` tag with value ``val``.

        :param ShowcaseFileRemovedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_file_removed_details', val)

    @classmethod
    def showcase_file_view_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_file_view_details`` tag with value ``val``.

        :param ShowcaseFileViewDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_file_view_details', val)

    @classmethod
    def showcase_permanently_deleted_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_permanently_deleted_details`` tag with value ``val``.

        :param ShowcasePermanentlyDeletedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_permanently_deleted_details', val)

    @classmethod
    def showcase_post_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_post_comment_details`` tag with value ``val``.

        :param ShowcasePostCommentDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_post_comment_details', val)

    @classmethod
    def showcase_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_remove_member_details`` tag with value ``val``.

        :param ShowcaseRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_remove_member_details', val)

    @classmethod
    def showcase_renamed_details(cls, val):
        """
        Create an instance of this class set to the ``showcase_renamed_details``
        tag with value ``val``.

        :param ShowcaseRenamedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_renamed_details', val)

    @classmethod
    def showcase_request_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_request_access_details`` tag with value ``val``.

        :param ShowcaseRequestAccessDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_request_access_details', val)

    @classmethod
    def showcase_resolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_resolve_comment_details`` tag with value ``val``.

        :param ShowcaseResolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_resolve_comment_details', val)

    @classmethod
    def showcase_restored_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_restored_details`` tag with value ``val``.

        :param ShowcaseRestoredDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_restored_details', val)

    @classmethod
    def showcase_trashed_details(cls, val):
        """
        Create an instance of this class set to the ``showcase_trashed_details``
        tag with value ``val``.

        :param ShowcaseTrashedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_trashed_details', val)

    @classmethod
    def showcase_trashed_deprecated_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_trashed_deprecated_details`` tag with value ``val``.

        :param ShowcaseTrashedDeprecatedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_trashed_deprecated_details', val)

    @classmethod
    def showcase_unresolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_unresolve_comment_details`` tag with value ``val``.

        :param ShowcaseUnresolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_unresolve_comment_details', val)

    @classmethod
    def showcase_untrashed_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_untrashed_details`` tag with value ``val``.

        :param ShowcaseUntrashedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_untrashed_details', val)

    @classmethod
    def showcase_untrashed_deprecated_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_untrashed_deprecated_details`` tag with value ``val``.

        :param ShowcaseUntrashedDeprecatedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_untrashed_deprecated_details', val)

    @classmethod
    def showcase_view_details(cls, val):
        """
        Create an instance of this class set to the ``showcase_view_details``
        tag with value ``val``.

        :param ShowcaseViewDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_view_details', val)

    @classmethod
    def sso_add_cert_details(cls, val):
        """
        Create an instance of this class set to the ``sso_add_cert_details`` tag
        with value ``val``.

        :param SsoAddCertDetails val:
        :rtype: EventDetails
        """
        return cls('sso_add_cert_details', val)

    @classmethod
    def sso_add_login_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_add_login_url_details`` tag with value ``val``.

        :param SsoAddLoginUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_add_login_url_details', val)

    @classmethod
    def sso_add_logout_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_add_logout_url_details`` tag with value ``val``.

        :param SsoAddLogoutUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_add_logout_url_details', val)

    @classmethod
    def sso_change_cert_details(cls, val):
        """
        Create an instance of this class set to the ``sso_change_cert_details``
        tag with value ``val``.

        :param SsoChangeCertDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_cert_details', val)

    @classmethod
    def sso_change_login_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_login_url_details`` tag with value ``val``.

        :param SsoChangeLoginUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_login_url_details', val)

    @classmethod
    def sso_change_logout_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_logout_url_details`` tag with value ``val``.

        :param SsoChangeLogoutUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_logout_url_details', val)

    @classmethod
    def sso_change_saml_identity_mode_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_saml_identity_mode_details`` tag with value ``val``.

        :param SsoChangeSamlIdentityModeDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_saml_identity_mode_details', val)

    @classmethod
    def sso_remove_cert_details(cls, val):
        """
        Create an instance of this class set to the ``sso_remove_cert_details``
        tag with value ``val``.

        :param SsoRemoveCertDetails val:
        :rtype: EventDetails
        """
        return cls('sso_remove_cert_details', val)

    @classmethod
    def sso_remove_login_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_remove_login_url_details`` tag with value ``val``.

        :param SsoRemoveLoginUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_remove_login_url_details', val)

    @classmethod
    def sso_remove_logout_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_remove_logout_url_details`` tag with value ``val``.

        :param SsoRemoveLogoutUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_remove_logout_url_details', val)

    @classmethod
    def team_folder_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_change_status_details`` tag with value ``val``.

        :param TeamFolderChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_change_status_details', val)

    @classmethod
    def team_folder_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_create_details`` tag with value ``val``.

        :param TeamFolderCreateDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_create_details', val)

    @classmethod
    def team_folder_downgrade_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_downgrade_details`` tag with value ``val``.

        :param TeamFolderDowngradeDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_downgrade_details', val)

    @classmethod
    def team_folder_permanently_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_permanently_delete_details`` tag with value ``val``.

        :param TeamFolderPermanentlyDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_permanently_delete_details', val)

    @classmethod
    def team_folder_rename_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_rename_details`` tag with value ``val``.

        :param TeamFolderRenameDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_rename_details', val)

    @classmethod
    def team_selective_sync_settings_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_selective_sync_settings_changed_details`` tag with value ``val``.

        :param TeamSelectiveSyncSettingsChangedDetails val:
        :rtype: EventDetails
        """
        return cls('team_selective_sync_settings_changed_details', val)

    @classmethod
    def account_capture_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_change_policy_details`` tag with value ``val``.

        :param AccountCaptureChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_change_policy_details', val)

    @classmethod
    def allow_download_disabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``allow_download_disabled_details`` tag with value ``val``.

        :param AllowDownloadDisabledDetails val:
        :rtype: EventDetails
        """
        return cls('allow_download_disabled_details', val)

    @classmethod
    def allow_download_enabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``allow_download_enabled_details`` tag with value ``val``.

        :param AllowDownloadEnabledDetails val:
        :rtype: EventDetails
        """
        return cls('allow_download_enabled_details', val)

    @classmethod
    def data_placement_restriction_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``data_placement_restriction_change_policy_details`` tag with value
        ``val``.

        :param DataPlacementRestrictionChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('data_placement_restriction_change_policy_details', val)

    @classmethod
    def data_placement_restriction_satisfy_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``data_placement_restriction_satisfy_policy_details`` tag with value
        ``val``.

        :param DataPlacementRestrictionSatisfyPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('data_placement_restriction_satisfy_policy_details', val)

    @classmethod
    def device_approvals_change_desktop_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_desktop_policy_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeDesktopPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_desktop_policy_details', val)

    @classmethod
    def device_approvals_change_mobile_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_mobile_policy_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeMobilePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_mobile_policy_details', val)

    @classmethod
    def device_approvals_change_overage_action_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_overage_action_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeOverageActionDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_overage_action_details', val)

    @classmethod
    def device_approvals_change_unlink_action_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_unlink_action_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeUnlinkActionDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_unlink_action_details', val)

    @classmethod
    def directory_restrictions_add_members_details(cls, val):
        """
        Create an instance of this class set to the
        ``directory_restrictions_add_members_details`` tag with value ``val``.

        :param DirectoryRestrictionsAddMembersDetails val:
        :rtype: EventDetails
        """
        return cls('directory_restrictions_add_members_details', val)

    @classmethod
    def directory_restrictions_remove_members_details(cls, val):
        """
        Create an instance of this class set to the
        ``directory_restrictions_remove_members_details`` tag with value
        ``val``.

        :param DirectoryRestrictionsRemoveMembersDetails val:
        :rtype: EventDetails
        """
        return cls('directory_restrictions_remove_members_details', val)

    @classmethod
    def emm_add_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_add_exception_details`` tag with value ``val``.

        :param EmmAddExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('emm_add_exception_details', val)

    @classmethod
    def emm_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_change_policy_details`` tag with value ``val``.

        :param EmmChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('emm_change_policy_details', val)

    @classmethod
    def emm_remove_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_remove_exception_details`` tag with value ``val``.

        :param EmmRemoveExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('emm_remove_exception_details', val)

    @classmethod
    def extended_version_history_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``extended_version_history_change_policy_details`` tag with value
        ``val``.

        :param ExtendedVersionHistoryChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('extended_version_history_change_policy_details', val)

    @classmethod
    def file_comments_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_comments_change_policy_details`` tag with value ``val``.

        :param FileCommentsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('file_comments_change_policy_details', val)

    @classmethod
    def file_requests_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_change_policy_details`` tag with value ``val``.

        :param FileRequestsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('file_requests_change_policy_details', val)

    @classmethod
    def file_requests_emails_enabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_emails_enabled_details`` tag with value ``val``.

        :param FileRequestsEmailsEnabledDetails val:
        :rtype: EventDetails
        """
        return cls('file_requests_emails_enabled_details', val)

    @classmethod
    def file_requests_emails_restricted_to_team_only_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_emails_restricted_to_team_only_details`` tag with value
        ``val``.

        :param FileRequestsEmailsRestrictedToTeamOnlyDetails val:
        :rtype: EventDetails
        """
        return cls('file_requests_emails_restricted_to_team_only_details', val)

    @classmethod
    def google_sso_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``google_sso_change_policy_details`` tag with value ``val``.

        :param GoogleSsoChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('google_sso_change_policy_details', val)

    @classmethod
    def group_user_management_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_user_management_change_policy_details`` tag with value ``val``.

        :param GroupUserManagementChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('group_user_management_change_policy_details', val)

    @classmethod
    def member_requests_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_requests_change_policy_details`` tag with value ``val``.

        :param MemberRequestsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_requests_change_policy_details', val)

    @classmethod
    def member_space_limits_add_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_add_exception_details`` tag with value ``val``.

        :param MemberSpaceLimitsAddExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_add_exception_details', val)

    @classmethod
    def member_space_limits_change_caps_type_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_caps_type_policy_details`` tag with value
        ``val``.

        :param MemberSpaceLimitsChangeCapsTypePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_change_caps_type_policy_details', val)

    @classmethod
    def member_space_limits_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_policy_details`` tag with value ``val``.

        :param MemberSpaceLimitsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_change_policy_details', val)

    @classmethod
    def member_space_limits_remove_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_remove_exception_details`` tag with value ``val``.

        :param MemberSpaceLimitsRemoveExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_remove_exception_details', val)

    @classmethod
    def member_suggestions_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_suggestions_change_policy_details`` tag with value ``val``.

        :param MemberSuggestionsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_suggestions_change_policy_details', val)

    @classmethod
    def microsoft_office_addin_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``microsoft_office_addin_change_policy_details`` tag with value ``val``.

        :param MicrosoftOfficeAddinChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('microsoft_office_addin_change_policy_details', val)

    @classmethod
    def network_control_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``network_control_change_policy_details`` tag with value ``val``.

        :param NetworkControlChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('network_control_change_policy_details', val)

    @classmethod
    def paper_change_deployment_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_deployment_policy_details`` tag with value ``val``.

        :param PaperChangeDeploymentPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_deployment_policy_details', val)

    @classmethod
    def paper_change_member_link_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_member_link_policy_details`` tag with value ``val``.

        :param PaperChangeMemberLinkPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_member_link_policy_details', val)

    @classmethod
    def paper_change_member_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_member_policy_details`` tag with value ``val``.

        :param PaperChangeMemberPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_member_policy_details', val)

    @classmethod
    def paper_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_policy_details`` tag with value ``val``.

        :param PaperChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_policy_details', val)

    @classmethod
    def paper_enabled_users_group_addition_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_enabled_users_group_addition_details`` tag with value ``val``.

        :param PaperEnabledUsersGroupAdditionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_enabled_users_group_addition_details', val)

    @classmethod
    def paper_enabled_users_group_removal_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_enabled_users_group_removal_details`` tag with value ``val``.

        :param PaperEnabledUsersGroupRemovalDetails val:
        :rtype: EventDetails
        """
        return cls('paper_enabled_users_group_removal_details', val)

    @classmethod
    def permanent_delete_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``permanent_delete_change_policy_details`` tag with value ``val``.

        :param PermanentDeleteChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('permanent_delete_change_policy_details', val)

    @classmethod
    def sharing_change_folder_join_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_folder_join_policy_details`` tag with value ``val``.

        :param SharingChangeFolderJoinPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_folder_join_policy_details', val)

    @classmethod
    def sharing_change_link_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_policy_details`` tag with value ``val``.

        :param SharingChangeLinkPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_link_policy_details', val)

    @classmethod
    def sharing_change_member_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_member_policy_details`` tag with value ``val``.

        :param SharingChangeMemberPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_member_policy_details', val)

    @classmethod
    def showcase_change_download_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_download_policy_details`` tag with value ``val``.

        :param ShowcaseChangeDownloadPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_change_download_policy_details', val)

    @classmethod
    def showcase_change_enabled_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_enabled_policy_details`` tag with value ``val``.

        :param ShowcaseChangeEnabledPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_change_enabled_policy_details', val)

    @classmethod
    def showcase_change_external_sharing_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_external_sharing_policy_details`` tag with value
        ``val``.

        :param ShowcaseChangeExternalSharingPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_change_external_sharing_policy_details', val)

    @classmethod
    def smart_sync_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_change_policy_details`` tag with value ``val``.

        :param SmartSyncChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('smart_sync_change_policy_details', val)

    @classmethod
    def smart_sync_not_opt_out_details(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_not_opt_out_details`` tag with value ``val``.

        :param SmartSyncNotOptOutDetails val:
        :rtype: EventDetails
        """
        return cls('smart_sync_not_opt_out_details', val)

    @classmethod
    def smart_sync_opt_out_details(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_opt_out_details`` tag with value ``val``.

        :param SmartSyncOptOutDetails val:
        :rtype: EventDetails
        """
        return cls('smart_sync_opt_out_details', val)

    @classmethod
    def sso_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_policy_details`` tag with value ``val``.

        :param SsoChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_policy_details', val)

    @classmethod
    def team_selective_sync_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_selective_sync_policy_changed_details`` tag with value ``val``.

        :param TeamSelectiveSyncPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('team_selective_sync_policy_changed_details', val)

    @classmethod
    def tfa_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_change_policy_details`` tag with value ``val``.

        :param TfaChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_change_policy_details', val)

    @classmethod
    def two_account_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``two_account_change_policy_details`` tag with value ``val``.

        :param TwoAccountChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('two_account_change_policy_details', val)

    @classmethod
    def viewer_info_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``viewer_info_policy_changed_details`` tag with value ``val``.

        :param ViewerInfoPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('viewer_info_policy_changed_details', val)

    @classmethod
    def web_sessions_change_fixed_length_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_fixed_length_policy_details`` tag with value
        ``val``.

        :param WebSessionsChangeFixedLengthPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('web_sessions_change_fixed_length_policy_details', val)

    @classmethod
    def web_sessions_change_idle_length_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_idle_length_policy_details`` tag with value
        ``val``.

        :param WebSessionsChangeIdleLengthPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('web_sessions_change_idle_length_policy_details', val)

    @classmethod
    def team_merge_from_details(cls, val):
        """
        Create an instance of this class set to the ``team_merge_from_details``
        tag with value ``val``.

        :param TeamMergeFromDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_from_details', val)

    @classmethod
    def team_merge_to_details(cls, val):
        """
        Create an instance of this class set to the ``team_merge_to_details``
        tag with value ``val``.

        :param TeamMergeToDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_to_details', val)

    @classmethod
    def team_profile_add_logo_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_add_logo_details`` tag with value ``val``.

        :param TeamProfileAddLogoDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_add_logo_details', val)

    @classmethod
    def team_profile_change_default_language_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_default_language_details`` tag with value ``val``.

        :param TeamProfileChangeDefaultLanguageDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_change_default_language_details', val)

    @classmethod
    def team_profile_change_logo_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_logo_details`` tag with value ``val``.

        :param TeamProfileChangeLogoDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_change_logo_details', val)

    @classmethod
    def team_profile_change_name_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_name_details`` tag with value ``val``.

        :param TeamProfileChangeNameDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_change_name_details', val)

    @classmethod
    def team_profile_remove_logo_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_remove_logo_details`` tag with value ``val``.

        :param TeamProfileRemoveLogoDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_remove_logo_details', val)

    @classmethod
    def tfa_add_backup_phone_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_add_backup_phone_details`` tag with value ``val``.

        :param TfaAddBackupPhoneDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_add_backup_phone_details', val)

    @classmethod
    def tfa_add_security_key_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_add_security_key_details`` tag with value ``val``.

        :param TfaAddSecurityKeyDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_add_security_key_details', val)

    @classmethod
    def tfa_change_backup_phone_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_change_backup_phone_details`` tag with value ``val``.

        :param TfaChangeBackupPhoneDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_change_backup_phone_details', val)

    @classmethod
    def tfa_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_change_status_details`` tag with value ``val``.

        :param TfaChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_change_status_details', val)

    @classmethod
    def tfa_remove_backup_phone_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_remove_backup_phone_details`` tag with value ``val``.

        :param TfaRemoveBackupPhoneDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_remove_backup_phone_details', val)

    @classmethod
    def tfa_remove_security_key_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_remove_security_key_details`` tag with value ``val``.

        :param TfaRemoveSecurityKeyDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_remove_security_key_details', val)

    @classmethod
    def tfa_reset_details(cls, val):
        """
        Create an instance of this class set to the ``tfa_reset_details`` tag
        with value ``val``.

        :param TfaResetDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_reset_details', val)

    @classmethod
    def missing_details(cls, val):
        """
        Create an instance of this class set to the ``missing_details`` tag with
        value ``val``.

        :param MissingDetails val:
        :rtype: EventDetails
        """
        return cls('missing_details', val)

    def is_app_link_team_details(self):
        """
        Check if the union tag is ``app_link_team_details``.

        :rtype: bool
        """
        return self._tag == 'app_link_team_details'

    def is_app_link_user_details(self):
        """
        Check if the union tag is ``app_link_user_details``.

        :rtype: bool
        """
        return self._tag == 'app_link_user_details'

    def is_app_unlink_team_details(self):
        """
        Check if the union tag is ``app_unlink_team_details``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_team_details'

    def is_app_unlink_user_details(self):
        """
        Check if the union tag is ``app_unlink_user_details``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_user_details'

    def is_file_add_comment_details(self):
        """
        Check if the union tag is ``file_add_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_add_comment_details'

    def is_file_change_comment_subscription_details(self):
        """
        Check if the union tag is ``file_change_comment_subscription_details``.

        :rtype: bool
        """
        return self._tag == 'file_change_comment_subscription_details'

    def is_file_delete_comment_details(self):
        """
        Check if the union tag is ``file_delete_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_delete_comment_details'

    def is_file_like_comment_details(self):
        """
        Check if the union tag is ``file_like_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_like_comment_details'

    def is_file_resolve_comment_details(self):
        """
        Check if the union tag is ``file_resolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_resolve_comment_details'

    def is_file_unlike_comment_details(self):
        """
        Check if the union tag is ``file_unlike_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_unlike_comment_details'

    def is_file_unresolve_comment_details(self):
        """
        Check if the union tag is ``file_unresolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_unresolve_comment_details'

    def is_device_change_ip_desktop_details(self):
        """
        Check if the union tag is ``device_change_ip_desktop_details``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_desktop_details'

    def is_device_change_ip_mobile_details(self):
        """
        Check if the union tag is ``device_change_ip_mobile_details``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_mobile_details'

    def is_device_change_ip_web_details(self):
        """
        Check if the union tag is ``device_change_ip_web_details``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_web_details'

    def is_device_delete_on_unlink_fail_details(self):
        """
        Check if the union tag is ``device_delete_on_unlink_fail_details``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_fail_details'

    def is_device_delete_on_unlink_success_details(self):
        """
        Check if the union tag is ``device_delete_on_unlink_success_details``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_success_details'

    def is_device_link_fail_details(self):
        """
        Check if the union tag is ``device_link_fail_details``.

        :rtype: bool
        """
        return self._tag == 'device_link_fail_details'

    def is_device_link_success_details(self):
        """
        Check if the union tag is ``device_link_success_details``.

        :rtype: bool
        """
        return self._tag == 'device_link_success_details'

    def is_device_management_disabled_details(self):
        """
        Check if the union tag is ``device_management_disabled_details``.

        :rtype: bool
        """
        return self._tag == 'device_management_disabled_details'

    def is_device_management_enabled_details(self):
        """
        Check if the union tag is ``device_management_enabled_details``.

        :rtype: bool
        """
        return self._tag == 'device_management_enabled_details'

    def is_device_unlink_details(self):
        """
        Check if the union tag is ``device_unlink_details``.

        :rtype: bool
        """
        return self._tag == 'device_unlink_details'

    def is_emm_refresh_auth_token_details(self):
        """
        Check if the union tag is ``emm_refresh_auth_token_details``.

        :rtype: bool
        """
        return self._tag == 'emm_refresh_auth_token_details'

    def is_account_capture_change_availability_details(self):
        """
        Check if the union tag is ``account_capture_change_availability_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_availability_details'

    def is_account_capture_migrate_account_details(self):
        """
        Check if the union tag is ``account_capture_migrate_account_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_migrate_account_details'

    def is_account_capture_notification_emails_sent_details(self):
        """
        Check if the union tag is ``account_capture_notification_emails_sent_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_notification_emails_sent_details'

    def is_account_capture_relinquish_account_details(self):
        """
        Check if the union tag is ``account_capture_relinquish_account_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_relinquish_account_details'

    def is_disabled_domain_invites_details(self):
        """
        Check if the union tag is ``disabled_domain_invites_details``.

        :rtype: bool
        """
        return self._tag == 'disabled_domain_invites_details'

    def is_domain_invites_approve_request_to_join_team_details(self):
        """
        Check if the union tag is ``domain_invites_approve_request_to_join_team_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_approve_request_to_join_team_details'

    def is_domain_invites_decline_request_to_join_team_details(self):
        """
        Check if the union tag is ``domain_invites_decline_request_to_join_team_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_decline_request_to_join_team_details'

    def is_domain_invites_email_existing_users_details(self):
        """
        Check if the union tag is ``domain_invites_email_existing_users_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_email_existing_users_details'

    def is_domain_invites_request_to_join_team_details(self):
        """
        Check if the union tag is ``domain_invites_request_to_join_team_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_request_to_join_team_details'

    def is_domain_invites_set_invite_new_user_pref_to_no_details(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_no_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_no_details'

    def is_domain_invites_set_invite_new_user_pref_to_yes_details(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_yes_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_yes_details'

    def is_domain_verification_add_domain_fail_details(self):
        """
        Check if the union tag is ``domain_verification_add_domain_fail_details``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_fail_details'

    def is_domain_verification_add_domain_success_details(self):
        """
        Check if the union tag is ``domain_verification_add_domain_success_details``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_success_details'

    def is_domain_verification_remove_domain_details(self):
        """
        Check if the union tag is ``domain_verification_remove_domain_details``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_remove_domain_details'

    def is_enabled_domain_invites_details(self):
        """
        Check if the union tag is ``enabled_domain_invites_details``.

        :rtype: bool
        """
        return self._tag == 'enabled_domain_invites_details'

    def is_create_folder_details(self):
        """
        Check if the union tag is ``create_folder_details``.

        :rtype: bool
        """
        return self._tag == 'create_folder_details'

    def is_file_add_details(self):
        """
        Check if the union tag is ``file_add_details``.

        :rtype: bool
        """
        return self._tag == 'file_add_details'

    def is_file_copy_details(self):
        """
        Check if the union tag is ``file_copy_details``.

        :rtype: bool
        """
        return self._tag == 'file_copy_details'

    def is_file_delete_details(self):
        """
        Check if the union tag is ``file_delete_details``.

        :rtype: bool
        """
        return self._tag == 'file_delete_details'

    def is_file_download_details(self):
        """
        Check if the union tag is ``file_download_details``.

        :rtype: bool
        """
        return self._tag == 'file_download_details'

    def is_file_edit_details(self):
        """
        Check if the union tag is ``file_edit_details``.

        :rtype: bool
        """
        return self._tag == 'file_edit_details'

    def is_file_get_copy_reference_details(self):
        """
        Check if the union tag is ``file_get_copy_reference_details``.

        :rtype: bool
        """
        return self._tag == 'file_get_copy_reference_details'

    def is_file_move_details(self):
        """
        Check if the union tag is ``file_move_details``.

        :rtype: bool
        """
        return self._tag == 'file_move_details'

    def is_file_permanently_delete_details(self):
        """
        Check if the union tag is ``file_permanently_delete_details``.

        :rtype: bool
        """
        return self._tag == 'file_permanently_delete_details'

    def is_file_preview_details(self):
        """
        Check if the union tag is ``file_preview_details``.

        :rtype: bool
        """
        return self._tag == 'file_preview_details'

    def is_file_rename_details(self):
        """
        Check if the union tag is ``file_rename_details``.

        :rtype: bool
        """
        return self._tag == 'file_rename_details'

    def is_file_restore_details(self):
        """
        Check if the union tag is ``file_restore_details``.

        :rtype: bool
        """
        return self._tag == 'file_restore_details'

    def is_file_revert_details(self):
        """
        Check if the union tag is ``file_revert_details``.

        :rtype: bool
        """
        return self._tag == 'file_revert_details'

    def is_file_rollback_changes_details(self):
        """
        Check if the union tag is ``file_rollback_changes_details``.

        :rtype: bool
        """
        return self._tag == 'file_rollback_changes_details'

    def is_file_save_copy_reference_details(self):
        """
        Check if the union tag is ``file_save_copy_reference_details``.

        :rtype: bool
        """
        return self._tag == 'file_save_copy_reference_details'

    def is_file_request_change_details(self):
        """
        Check if the union tag is ``file_request_change_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_change_details'

    def is_file_request_close_details(self):
        """
        Check if the union tag is ``file_request_close_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_close_details'

    def is_file_request_create_details(self):
        """
        Check if the union tag is ``file_request_create_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_create_details'

    def is_file_request_receive_file_details(self):
        """
        Check if the union tag is ``file_request_receive_file_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_receive_file_details'

    def is_group_add_external_id_details(self):
        """
        Check if the union tag is ``group_add_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'group_add_external_id_details'

    def is_group_add_member_details(self):
        """
        Check if the union tag is ``group_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'group_add_member_details'

    def is_group_change_external_id_details(self):
        """
        Check if the union tag is ``group_change_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'group_change_external_id_details'

    def is_group_change_management_type_details(self):
        """
        Check if the union tag is ``group_change_management_type_details``.

        :rtype: bool
        """
        return self._tag == 'group_change_management_type_details'

    def is_group_change_member_role_details(self):
        """
        Check if the union tag is ``group_change_member_role_details``.

        :rtype: bool
        """
        return self._tag == 'group_change_member_role_details'

    def is_group_create_details(self):
        """
        Check if the union tag is ``group_create_details``.

        :rtype: bool
        """
        return self._tag == 'group_create_details'

    def is_group_delete_details(self):
        """
        Check if the union tag is ``group_delete_details``.

        :rtype: bool
        """
        return self._tag == 'group_delete_details'

    def is_group_description_updated_details(self):
        """
        Check if the union tag is ``group_description_updated_details``.

        :rtype: bool
        """
        return self._tag == 'group_description_updated_details'

    def is_group_join_policy_updated_details(self):
        """
        Check if the union tag is ``group_join_policy_updated_details``.

        :rtype: bool
        """
        return self._tag == 'group_join_policy_updated_details'

    def is_group_moved_details(self):
        """
        Check if the union tag is ``group_moved_details``.

        :rtype: bool
        """
        return self._tag == 'group_moved_details'

    def is_group_remove_external_id_details(self):
        """
        Check if the union tag is ``group_remove_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'group_remove_external_id_details'

    def is_group_remove_member_details(self):
        """
        Check if the union tag is ``group_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'group_remove_member_details'

    def is_group_rename_details(self):
        """
        Check if the union tag is ``group_rename_details``.

        :rtype: bool
        """
        return self._tag == 'group_rename_details'

    def is_emm_error_details(self):
        """
        Check if the union tag is ``emm_error_details``.

        :rtype: bool
        """
        return self._tag == 'emm_error_details'

    def is_login_fail_details(self):
        """
        Check if the union tag is ``login_fail_details``.

        :rtype: bool
        """
        return self._tag == 'login_fail_details'

    def is_login_success_details(self):
        """
        Check if the union tag is ``login_success_details``.

        :rtype: bool
        """
        return self._tag == 'login_success_details'

    def is_logout_details(self):
        """
        Check if the union tag is ``logout_details``.

        :rtype: bool
        """
        return self._tag == 'logout_details'

    def is_reseller_support_session_end_details(self):
        """
        Check if the union tag is ``reseller_support_session_end_details``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_end_details'

    def is_reseller_support_session_start_details(self):
        """
        Check if the union tag is ``reseller_support_session_start_details``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_start_details'

    def is_sign_in_as_session_end_details(self):
        """
        Check if the union tag is ``sign_in_as_session_end_details``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_end_details'

    def is_sign_in_as_session_start_details(self):
        """
        Check if the union tag is ``sign_in_as_session_start_details``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_start_details'

    def is_sso_error_details(self):
        """
        Check if the union tag is ``sso_error_details``.

        :rtype: bool
        """
        return self._tag == 'sso_error_details'

    def is_member_add_name_details(self):
        """
        Check if the union tag is ``member_add_name_details``.

        :rtype: bool
        """
        return self._tag == 'member_add_name_details'

    def is_member_change_admin_role_details(self):
        """
        Check if the union tag is ``member_change_admin_role_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_admin_role_details'

    def is_member_change_email_details(self):
        """
        Check if the union tag is ``member_change_email_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_email_details'

    def is_member_change_membership_type_details(self):
        """
        Check if the union tag is ``member_change_membership_type_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_membership_type_details'

    def is_member_change_name_details(self):
        """
        Check if the union tag is ``member_change_name_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_name_details'

    def is_member_change_status_details(self):
        """
        Check if the union tag is ``member_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_status_details'

    def is_member_delete_manual_contacts_details(self):
        """
        Check if the union tag is ``member_delete_manual_contacts_details``.

        :rtype: bool
        """
        return self._tag == 'member_delete_manual_contacts_details'

    def is_member_permanently_delete_account_contents_details(self):
        """
        Check if the union tag is ``member_permanently_delete_account_contents_details``.

        :rtype: bool
        """
        return self._tag == 'member_permanently_delete_account_contents_details'

    def is_member_space_limits_add_custom_quota_details(self):
        """
        Check if the union tag is ``member_space_limits_add_custom_quota_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_add_custom_quota_details'

    def is_member_space_limits_change_custom_quota_details(self):
        """
        Check if the union tag is ``member_space_limits_change_custom_quota_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_custom_quota_details'

    def is_member_space_limits_change_status_details(self):
        """
        Check if the union tag is ``member_space_limits_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_status_details'

    def is_member_space_limits_remove_custom_quota_details(self):
        """
        Check if the union tag is ``member_space_limits_remove_custom_quota_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_remove_custom_quota_details'

    def is_member_suggest_details(self):
        """
        Check if the union tag is ``member_suggest_details``.

        :rtype: bool
        """
        return self._tag == 'member_suggest_details'

    def is_member_transfer_account_contents_details(self):
        """
        Check if the union tag is ``member_transfer_account_contents_details``.

        :rtype: bool
        """
        return self._tag == 'member_transfer_account_contents_details'

    def is_secondary_mails_policy_changed_details(self):
        """
        Check if the union tag is ``secondary_mails_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'secondary_mails_policy_changed_details'

    def is_paper_content_add_member_details(self):
        """
        Check if the union tag is ``paper_content_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_member_details'

    def is_paper_content_add_to_folder_details(self):
        """
        Check if the union tag is ``paper_content_add_to_folder_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_to_folder_details'

    def is_paper_content_archive_details(self):
        """
        Check if the union tag is ``paper_content_archive_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_archive_details'

    def is_paper_content_create_details(self):
        """
        Check if the union tag is ``paper_content_create_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_create_details'

    def is_paper_content_permanently_delete_details(self):
        """
        Check if the union tag is ``paper_content_permanently_delete_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_permanently_delete_details'

    def is_paper_content_remove_from_folder_details(self):
        """
        Check if the union tag is ``paper_content_remove_from_folder_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_from_folder_details'

    def is_paper_content_remove_member_details(self):
        """
        Check if the union tag is ``paper_content_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_member_details'

    def is_paper_content_rename_details(self):
        """
        Check if the union tag is ``paper_content_rename_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_rename_details'

    def is_paper_content_restore_details(self):
        """
        Check if the union tag is ``paper_content_restore_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_restore_details'

    def is_paper_doc_add_comment_details(self):
        """
        Check if the union tag is ``paper_doc_add_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_add_comment_details'

    def is_paper_doc_change_member_role_details(self):
        """
        Check if the union tag is ``paper_doc_change_member_role_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_member_role_details'

    def is_paper_doc_change_sharing_policy_details(self):
        """
        Check if the union tag is ``paper_doc_change_sharing_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_sharing_policy_details'

    def is_paper_doc_change_subscription_details(self):
        """
        Check if the union tag is ``paper_doc_change_subscription_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_subscription_details'

    def is_paper_doc_deleted_details(self):
        """
        Check if the union tag is ``paper_doc_deleted_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_deleted_details'

    def is_paper_doc_delete_comment_details(self):
        """
        Check if the union tag is ``paper_doc_delete_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_delete_comment_details'

    def is_paper_doc_download_details(self):
        """
        Check if the union tag is ``paper_doc_download_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_download_details'

    def is_paper_doc_edit_details(self):
        """
        Check if the union tag is ``paper_doc_edit_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit_details'

    def is_paper_doc_edit_comment_details(self):
        """
        Check if the union tag is ``paper_doc_edit_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit_comment_details'

    def is_paper_doc_followed_details(self):
        """
        Check if the union tag is ``paper_doc_followed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_followed_details'

    def is_paper_doc_mention_details(self):
        """
        Check if the union tag is ``paper_doc_mention_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_mention_details'

    def is_paper_doc_ownership_changed_details(self):
        """
        Check if the union tag is ``paper_doc_ownership_changed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_ownership_changed_details'

    def is_paper_doc_request_access_details(self):
        """
        Check if the union tag is ``paper_doc_request_access_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_request_access_details'

    def is_paper_doc_resolve_comment_details(self):
        """
        Check if the union tag is ``paper_doc_resolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_resolve_comment_details'

    def is_paper_doc_revert_details(self):
        """
        Check if the union tag is ``paper_doc_revert_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_revert_details'

    def is_paper_doc_slack_share_details(self):
        """
        Check if the union tag is ``paper_doc_slack_share_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_slack_share_details'

    def is_paper_doc_team_invite_details(self):
        """
        Check if the union tag is ``paper_doc_team_invite_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_team_invite_details'

    def is_paper_doc_trashed_details(self):
        """
        Check if the union tag is ``paper_doc_trashed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_trashed_details'

    def is_paper_doc_unresolve_comment_details(self):
        """
        Check if the union tag is ``paper_doc_unresolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_unresolve_comment_details'

    def is_paper_doc_untrashed_details(self):
        """
        Check if the union tag is ``paper_doc_untrashed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_untrashed_details'

    def is_paper_doc_view_details(self):
        """
        Check if the union tag is ``paper_doc_view_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_view_details'

    def is_paper_external_view_allow_details(self):
        """
        Check if the union tag is ``paper_external_view_allow_details``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_allow_details'

    def is_paper_external_view_default_team_details(self):
        """
        Check if the union tag is ``paper_external_view_default_team_details``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_default_team_details'

    def is_paper_external_view_forbid_details(self):
        """
        Check if the union tag is ``paper_external_view_forbid_details``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_forbid_details'

    def is_paper_folder_change_subscription_details(self):
        """
        Check if the union tag is ``paper_folder_change_subscription_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_change_subscription_details'

    def is_paper_folder_deleted_details(self):
        """
        Check if the union tag is ``paper_folder_deleted_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_deleted_details'

    def is_paper_folder_followed_details(self):
        """
        Check if the union tag is ``paper_folder_followed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_followed_details'

    def is_paper_folder_team_invite_details(self):
        """
        Check if the union tag is ``paper_folder_team_invite_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_team_invite_details'

    def is_password_change_details(self):
        """
        Check if the union tag is ``password_change_details``.

        :rtype: bool
        """
        return self._tag == 'password_change_details'

    def is_password_reset_details(self):
        """
        Check if the union tag is ``password_reset_details``.

        :rtype: bool
        """
        return self._tag == 'password_reset_details'

    def is_password_reset_all_details(self):
        """
        Check if the union tag is ``password_reset_all_details``.

        :rtype: bool
        """
        return self._tag == 'password_reset_all_details'

    def is_emm_create_exceptions_report_details(self):
        """
        Check if the union tag is ``emm_create_exceptions_report_details``.

        :rtype: bool
        """
        return self._tag == 'emm_create_exceptions_report_details'

    def is_emm_create_usage_report_details(self):
        """
        Check if the union tag is ``emm_create_usage_report_details``.

        :rtype: bool
        """
        return self._tag == 'emm_create_usage_report_details'

    def is_export_members_report_details(self):
        """
        Check if the union tag is ``export_members_report_details``.

        :rtype: bool
        """
        return self._tag == 'export_members_report_details'

    def is_paper_admin_export_start_details(self):
        """
        Check if the union tag is ``paper_admin_export_start_details``.

        :rtype: bool
        """
        return self._tag == 'paper_admin_export_start_details'

    def is_smart_sync_create_admin_privilege_report_details(self):
        """
        Check if the union tag is ``smart_sync_create_admin_privilege_report_details``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_create_admin_privilege_report_details'

    def is_team_activity_create_report_details(self):
        """
        Check if the union tag is ``team_activity_create_report_details``.

        :rtype: bool
        """
        return self._tag == 'team_activity_create_report_details'

    def is_collection_share_details(self):
        """
        Check if the union tag is ``collection_share_details``.

        :rtype: bool
        """
        return self._tag == 'collection_share_details'

    def is_note_acl_invite_only_details(self):
        """
        Check if the union tag is ``note_acl_invite_only_details``.

        :rtype: bool
        """
        return self._tag == 'note_acl_invite_only_details'

    def is_note_acl_link_details(self):
        """
        Check if the union tag is ``note_acl_link_details``.

        :rtype: bool
        """
        return self._tag == 'note_acl_link_details'

    def is_note_acl_team_link_details(self):
        """
        Check if the union tag is ``note_acl_team_link_details``.

        :rtype: bool
        """
        return self._tag == 'note_acl_team_link_details'

    def is_note_shared_details(self):
        """
        Check if the union tag is ``note_shared_details``.

        :rtype: bool
        """
        return self._tag == 'note_shared_details'

    def is_note_share_receive_details(self):
        """
        Check if the union tag is ``note_share_receive_details``.

        :rtype: bool
        """
        return self._tag == 'note_share_receive_details'

    def is_open_note_shared_details(self):
        """
        Check if the union tag is ``open_note_shared_details``.

        :rtype: bool
        """
        return self._tag == 'open_note_shared_details'

    def is_sf_add_group_details(self):
        """
        Check if the union tag is ``sf_add_group_details``.

        :rtype: bool
        """
        return self._tag == 'sf_add_group_details'

    def is_sf_allow_non_members_to_view_shared_links_details(self):
        """
        Check if the union tag is ``sf_allow_non_members_to_view_shared_links_details``.

        :rtype: bool
        """
        return self._tag == 'sf_allow_non_members_to_view_shared_links_details'

    def is_sf_external_invite_warn_details(self):
        """
        Check if the union tag is ``sf_external_invite_warn_details``.

        :rtype: bool
        """
        return self._tag == 'sf_external_invite_warn_details'

    def is_sf_fb_invite_details(self):
        """
        Check if the union tag is ``sf_fb_invite_details``.

        :rtype: bool
        """
        return self._tag == 'sf_fb_invite_details'

    def is_sf_fb_invite_change_role_details(self):
        """
        Check if the union tag is ``sf_fb_invite_change_role_details``.

        :rtype: bool
        """
        return self._tag == 'sf_fb_invite_change_role_details'

    def is_sf_fb_uninvite_details(self):
        """
        Check if the union tag is ``sf_fb_uninvite_details``.

        :rtype: bool
        """
        return self._tag == 'sf_fb_uninvite_details'

    def is_sf_invite_group_details(self):
        """
        Check if the union tag is ``sf_invite_group_details``.

        :rtype: bool
        """
        return self._tag == 'sf_invite_group_details'

    def is_sf_team_grant_access_details(self):
        """
        Check if the union tag is ``sf_team_grant_access_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_grant_access_details'

    def is_sf_team_invite_details(self):
        """
        Check if the union tag is ``sf_team_invite_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_invite_details'

    def is_sf_team_invite_change_role_details(self):
        """
        Check if the union tag is ``sf_team_invite_change_role_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_invite_change_role_details'

    def is_sf_team_join_details(self):
        """
        Check if the union tag is ``sf_team_join_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_join_details'

    def is_sf_team_join_from_oob_link_details(self):
        """
        Check if the union tag is ``sf_team_join_from_oob_link_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_join_from_oob_link_details'

    def is_sf_team_uninvite_details(self):
        """
        Check if the union tag is ``sf_team_uninvite_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_uninvite_details'

    def is_shared_content_add_invitees_details(self):
        """
        Check if the union tag is ``shared_content_add_invitees_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_invitees_details'

    def is_shared_content_add_link_expiry_details(self):
        """
        Check if the union tag is ``shared_content_add_link_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_link_expiry_details'

    def is_shared_content_add_link_password_details(self):
        """
        Check if the union tag is ``shared_content_add_link_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_link_password_details'

    def is_shared_content_add_member_details(self):
        """
        Check if the union tag is ``shared_content_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_member_details'

    def is_shared_content_change_downloads_policy_details(self):
        """
        Check if the union tag is ``shared_content_change_downloads_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_downloads_policy_details'

    def is_shared_content_change_invitee_role_details(self):
        """
        Check if the union tag is ``shared_content_change_invitee_role_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_invitee_role_details'

    def is_shared_content_change_link_audience_details(self):
        """
        Check if the union tag is ``shared_content_change_link_audience_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_audience_details'

    def is_shared_content_change_link_expiry_details(self):
        """
        Check if the union tag is ``shared_content_change_link_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_expiry_details'

    def is_shared_content_change_link_password_details(self):
        """
        Check if the union tag is ``shared_content_change_link_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_password_details'

    def is_shared_content_change_member_role_details(self):
        """
        Check if the union tag is ``shared_content_change_member_role_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_member_role_details'

    def is_shared_content_change_viewer_info_policy_details(self):
        """
        Check if the union tag is ``shared_content_change_viewer_info_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_viewer_info_policy_details'

    def is_shared_content_claim_invitation_details(self):
        """
        Check if the union tag is ``shared_content_claim_invitation_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_claim_invitation_details'

    def is_shared_content_copy_details(self):
        """
        Check if the union tag is ``shared_content_copy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_copy_details'

    def is_shared_content_download_details(self):
        """
        Check if the union tag is ``shared_content_download_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_download_details'

    def is_shared_content_relinquish_membership_details(self):
        """
        Check if the union tag is ``shared_content_relinquish_membership_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_relinquish_membership_details'

    def is_shared_content_remove_invitees_details(self):
        """
        Check if the union tag is ``shared_content_remove_invitees_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_invitees_details'

    def is_shared_content_remove_link_expiry_details(self):
        """
        Check if the union tag is ``shared_content_remove_link_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_link_expiry_details'

    def is_shared_content_remove_link_password_details(self):
        """
        Check if the union tag is ``shared_content_remove_link_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_link_password_details'

    def is_shared_content_remove_member_details(self):
        """
        Check if the union tag is ``shared_content_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_member_details'

    def is_shared_content_request_access_details(self):
        """
        Check if the union tag is ``shared_content_request_access_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_request_access_details'

    def is_shared_content_unshare_details(self):
        """
        Check if the union tag is ``shared_content_unshare_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_unshare_details'

    def is_shared_content_view_details(self):
        """
        Check if the union tag is ``shared_content_view_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_view_details'

    def is_shared_folder_change_link_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_link_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_link_policy_details'

    def is_shared_folder_change_members_inheritance_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_members_inheritance_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_members_inheritance_policy_details'

    def is_shared_folder_change_members_management_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_members_management_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_members_management_policy_details'

    def is_shared_folder_change_members_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_members_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_members_policy_details'

    def is_shared_folder_create_details(self):
        """
        Check if the union tag is ``shared_folder_create_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_create_details'

    def is_shared_folder_decline_invitation_details(self):
        """
        Check if the union tag is ``shared_folder_decline_invitation_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_decline_invitation_details'

    def is_shared_folder_mount_details(self):
        """
        Check if the union tag is ``shared_folder_mount_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_mount_details'

    def is_shared_folder_nest_details(self):
        """
        Check if the union tag is ``shared_folder_nest_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_nest_details'

    def is_shared_folder_transfer_ownership_details(self):
        """
        Check if the union tag is ``shared_folder_transfer_ownership_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_transfer_ownership_details'

    def is_shared_folder_unmount_details(self):
        """
        Check if the union tag is ``shared_folder_unmount_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_unmount_details'

    def is_shared_link_add_expiry_details(self):
        """
        Check if the union tag is ``shared_link_add_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_add_expiry_details'

    def is_shared_link_change_expiry_details(self):
        """
        Check if the union tag is ``shared_link_change_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_change_expiry_details'

    def is_shared_link_change_visibility_details(self):
        """
        Check if the union tag is ``shared_link_change_visibility_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_change_visibility_details'

    def is_shared_link_copy_details(self):
        """
        Check if the union tag is ``shared_link_copy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_copy_details'

    def is_shared_link_create_details(self):
        """
        Check if the union tag is ``shared_link_create_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_create_details'

    def is_shared_link_disable_details(self):
        """
        Check if the union tag is ``shared_link_disable_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_disable_details'

    def is_shared_link_download_details(self):
        """
        Check if the union tag is ``shared_link_download_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_download_details'

    def is_shared_link_remove_expiry_details(self):
        """
        Check if the union tag is ``shared_link_remove_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_remove_expiry_details'

    def is_shared_link_share_details(self):
        """
        Check if the union tag is ``shared_link_share_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_share_details'

    def is_shared_link_view_details(self):
        """
        Check if the union tag is ``shared_link_view_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_view_details'

    def is_shared_note_opened_details(self):
        """
        Check if the union tag is ``shared_note_opened_details``.

        :rtype: bool
        """
        return self._tag == 'shared_note_opened_details'

    def is_shmodel_group_share_details(self):
        """
        Check if the union tag is ``shmodel_group_share_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_group_share_details'

    def is_showcase_access_granted_details(self):
        """
        Check if the union tag is ``showcase_access_granted_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_access_granted_details'

    def is_showcase_add_member_details(self):
        """
        Check if the union tag is ``showcase_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_add_member_details'

    def is_showcase_archived_details(self):
        """
        Check if the union tag is ``showcase_archived_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_archived_details'

    def is_showcase_created_details(self):
        """
        Check if the union tag is ``showcase_created_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_created_details'

    def is_showcase_delete_comment_details(self):
        """
        Check if the union tag is ``showcase_delete_comment_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_delete_comment_details'

    def is_showcase_edited_details(self):
        """
        Check if the union tag is ``showcase_edited_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_edited_details'

    def is_showcase_edit_comment_details(self):
        """
        Check if the union tag is ``showcase_edit_comment_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_edit_comment_details'

    def is_showcase_file_added_details(self):
        """
        Check if the union tag is ``showcase_file_added_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_added_details'

    def is_showcase_file_download_details(self):
        """
        Check if the union tag is ``showcase_file_download_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_download_details'

    def is_showcase_file_removed_details(self):
        """
        Check if the union tag is ``showcase_file_removed_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_removed_details'

    def is_showcase_file_view_details(self):
        """
        Check if the union tag is ``showcase_file_view_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_view_details'

    def is_showcase_permanently_deleted_details(self):
        """
        Check if the union tag is ``showcase_permanently_deleted_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_permanently_deleted_details'

    def is_showcase_post_comment_details(self):
        """
        Check if the union tag is ``showcase_post_comment_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_post_comment_details'

    def is_showcase_remove_member_details(self):
        """
        Check if the union tag is ``showcase_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_remove_member_details'

    def is_showcase_renamed_details(self):
        """
        Check if the union tag is ``showcase_renamed_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_renamed_details'

    def is_showcase_request_access_details(self):
        """
        Check if the union tag is ``showcase_request_access_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_request_access_details'

    def is_showcase_resolve_comment_details(self):
        """
        Check if the union tag is ``showcase_resolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_resolve_comment_details'

    def is_showcase_restored_details(self):
        """
        Check if the union tag is ``showcase_restored_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_restored_details'

    def is_showcase_trashed_details(self):
        """
        Check if the union tag is ``showcase_trashed_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_trashed_details'

    def is_showcase_trashed_deprecated_details(self):
        """
        Check if the union tag is ``showcase_trashed_deprecated_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_trashed_deprecated_details'

    def is_showcase_unresolve_comment_details(self):
        """
        Check if the union tag is ``showcase_unresolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_unresolve_comment_details'

    def is_showcase_untrashed_details(self):
        """
        Check if the union tag is ``showcase_untrashed_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_untrashed_details'

    def is_showcase_untrashed_deprecated_details(self):
        """
        Check if the union tag is ``showcase_untrashed_deprecated_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_untrashed_deprecated_details'

    def is_showcase_view_details(self):
        """
        Check if the union tag is ``showcase_view_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_view_details'

    def is_sso_add_cert_details(self):
        """
        Check if the union tag is ``sso_add_cert_details``.

        :rtype: bool
        """
        return self._tag == 'sso_add_cert_details'

    def is_sso_add_login_url_details(self):
        """
        Check if the union tag is ``sso_add_login_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_add_login_url_details'

    def is_sso_add_logout_url_details(self):
        """
        Check if the union tag is ``sso_add_logout_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_add_logout_url_details'

    def is_sso_change_cert_details(self):
        """
        Check if the union tag is ``sso_change_cert_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_cert_details'

    def is_sso_change_login_url_details(self):
        """
        Check if the union tag is ``sso_change_login_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_login_url_details'

    def is_sso_change_logout_url_details(self):
        """
        Check if the union tag is ``sso_change_logout_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_logout_url_details'

    def is_sso_change_saml_identity_mode_details(self):
        """
        Check if the union tag is ``sso_change_saml_identity_mode_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_saml_identity_mode_details'

    def is_sso_remove_cert_details(self):
        """
        Check if the union tag is ``sso_remove_cert_details``.

        :rtype: bool
        """
        return self._tag == 'sso_remove_cert_details'

    def is_sso_remove_login_url_details(self):
        """
        Check if the union tag is ``sso_remove_login_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_remove_login_url_details'

    def is_sso_remove_logout_url_details(self):
        """
        Check if the union tag is ``sso_remove_logout_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_remove_logout_url_details'

    def is_team_folder_change_status_details(self):
        """
        Check if the union tag is ``team_folder_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_change_status_details'

    def is_team_folder_create_details(self):
        """
        Check if the union tag is ``team_folder_create_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_create_details'

    def is_team_folder_downgrade_details(self):
        """
        Check if the union tag is ``team_folder_downgrade_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_downgrade_details'

    def is_team_folder_permanently_delete_details(self):
        """
        Check if the union tag is ``team_folder_permanently_delete_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_permanently_delete_details'

    def is_team_folder_rename_details(self):
        """
        Check if the union tag is ``team_folder_rename_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_rename_details'

    def is_team_selective_sync_settings_changed_details(self):
        """
        Check if the union tag is ``team_selective_sync_settings_changed_details``.

        :rtype: bool
        """
        return self._tag == 'team_selective_sync_settings_changed_details'

    def is_account_capture_change_policy_details(self):
        """
        Check if the union tag is ``account_capture_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_policy_details'

    def is_allow_download_disabled_details(self):
        """
        Check if the union tag is ``allow_download_disabled_details``.

        :rtype: bool
        """
        return self._tag == 'allow_download_disabled_details'

    def is_allow_download_enabled_details(self):
        """
        Check if the union tag is ``allow_download_enabled_details``.

        :rtype: bool
        """
        return self._tag == 'allow_download_enabled_details'

    def is_data_placement_restriction_change_policy_details(self):
        """
        Check if the union tag is ``data_placement_restriction_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'data_placement_restriction_change_policy_details'

    def is_data_placement_restriction_satisfy_policy_details(self):
        """
        Check if the union tag is ``data_placement_restriction_satisfy_policy_details``.

        :rtype: bool
        """
        return self._tag == 'data_placement_restriction_satisfy_policy_details'

    def is_device_approvals_change_desktop_policy_details(self):
        """
        Check if the union tag is ``device_approvals_change_desktop_policy_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_desktop_policy_details'

    def is_device_approvals_change_mobile_policy_details(self):
        """
        Check if the union tag is ``device_approvals_change_mobile_policy_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_mobile_policy_details'

    def is_device_approvals_change_overage_action_details(self):
        """
        Check if the union tag is ``device_approvals_change_overage_action_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_overage_action_details'

    def is_device_approvals_change_unlink_action_details(self):
        """
        Check if the union tag is ``device_approvals_change_unlink_action_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_unlink_action_details'

    def is_directory_restrictions_add_members_details(self):
        """
        Check if the union tag is ``directory_restrictions_add_members_details``.

        :rtype: bool
        """
        return self._tag == 'directory_restrictions_add_members_details'

    def is_directory_restrictions_remove_members_details(self):
        """
        Check if the union tag is ``directory_restrictions_remove_members_details``.

        :rtype: bool
        """
        return self._tag == 'directory_restrictions_remove_members_details'

    def is_emm_add_exception_details(self):
        """
        Check if the union tag is ``emm_add_exception_details``.

        :rtype: bool
        """
        return self._tag == 'emm_add_exception_details'

    def is_emm_change_policy_details(self):
        """
        Check if the union tag is ``emm_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'emm_change_policy_details'

    def is_emm_remove_exception_details(self):
        """
        Check if the union tag is ``emm_remove_exception_details``.

        :rtype: bool
        """
        return self._tag == 'emm_remove_exception_details'

    def is_extended_version_history_change_policy_details(self):
        """
        Check if the union tag is ``extended_version_history_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'extended_version_history_change_policy_details'

    def is_file_comments_change_policy_details(self):
        """
        Check if the union tag is ``file_comments_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'file_comments_change_policy_details'

    def is_file_requests_change_policy_details(self):
        """
        Check if the union tag is ``file_requests_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'file_requests_change_policy_details'

    def is_file_requests_emails_enabled_details(self):
        """
        Check if the union tag is ``file_requests_emails_enabled_details``.

        :rtype: bool
        """
        return self._tag == 'file_requests_emails_enabled_details'

    def is_file_requests_emails_restricted_to_team_only_details(self):
        """
        Check if the union tag is ``file_requests_emails_restricted_to_team_only_details``.

        :rtype: bool
        """
        return self._tag == 'file_requests_emails_restricted_to_team_only_details'

    def is_google_sso_change_policy_details(self):
        """
        Check if the union tag is ``google_sso_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'google_sso_change_policy_details'

    def is_group_user_management_change_policy_details(self):
        """
        Check if the union tag is ``group_user_management_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'group_user_management_change_policy_details'

    def is_member_requests_change_policy_details(self):
        """
        Check if the union tag is ``member_requests_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_requests_change_policy_details'

    def is_member_space_limits_add_exception_details(self):
        """
        Check if the union tag is ``member_space_limits_add_exception_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_add_exception_details'

    def is_member_space_limits_change_caps_type_policy_details(self):
        """
        Check if the union tag is ``member_space_limits_change_caps_type_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_caps_type_policy_details'

    def is_member_space_limits_change_policy_details(self):
        """
        Check if the union tag is ``member_space_limits_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_policy_details'

    def is_member_space_limits_remove_exception_details(self):
        """
        Check if the union tag is ``member_space_limits_remove_exception_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_remove_exception_details'

    def is_member_suggestions_change_policy_details(self):
        """
        Check if the union tag is ``member_suggestions_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_suggestions_change_policy_details'

    def is_microsoft_office_addin_change_policy_details(self):
        """
        Check if the union tag is ``microsoft_office_addin_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'microsoft_office_addin_change_policy_details'

    def is_network_control_change_policy_details(self):
        """
        Check if the union tag is ``network_control_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'network_control_change_policy_details'

    def is_paper_change_deployment_policy_details(self):
        """
        Check if the union tag is ``paper_change_deployment_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_deployment_policy_details'

    def is_paper_change_member_link_policy_details(self):
        """
        Check if the union tag is ``paper_change_member_link_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_member_link_policy_details'

    def is_paper_change_member_policy_details(self):
        """
        Check if the union tag is ``paper_change_member_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_member_policy_details'

    def is_paper_change_policy_details(self):
        """
        Check if the union tag is ``paper_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_policy_details'

    def is_paper_enabled_users_group_addition_details(self):
        """
        Check if the union tag is ``paper_enabled_users_group_addition_details``.

        :rtype: bool
        """
        return self._tag == 'paper_enabled_users_group_addition_details'

    def is_paper_enabled_users_group_removal_details(self):
        """
        Check if the union tag is ``paper_enabled_users_group_removal_details``.

        :rtype: bool
        """
        return self._tag == 'paper_enabled_users_group_removal_details'

    def is_permanent_delete_change_policy_details(self):
        """
        Check if the union tag is ``permanent_delete_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'permanent_delete_change_policy_details'

    def is_sharing_change_folder_join_policy_details(self):
        """
        Check if the union tag is ``sharing_change_folder_join_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_folder_join_policy_details'

    def is_sharing_change_link_policy_details(self):
        """
        Check if the union tag is ``sharing_change_link_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_link_policy_details'

    def is_sharing_change_member_policy_details(self):
        """
        Check if the union tag is ``sharing_change_member_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_member_policy_details'

    def is_showcase_change_download_policy_details(self):
        """
        Check if the union tag is ``showcase_change_download_policy_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_change_download_policy_details'

    def is_showcase_change_enabled_policy_details(self):
        """
        Check if the union tag is ``showcase_change_enabled_policy_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_change_enabled_policy_details'

    def is_showcase_change_external_sharing_policy_details(self):
        """
        Check if the union tag is ``showcase_change_external_sharing_policy_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_change_external_sharing_policy_details'

    def is_smart_sync_change_policy_details(self):
        """
        Check if the union tag is ``smart_sync_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_change_policy_details'

    def is_smart_sync_not_opt_out_details(self):
        """
        Check if the union tag is ``smart_sync_not_opt_out_details``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_not_opt_out_details'

    def is_smart_sync_opt_out_details(self):
        """
        Check if the union tag is ``smart_sync_opt_out_details``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_opt_out_details'

    def is_sso_change_policy_details(self):
        """
        Check if the union tag is ``sso_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_policy_details'

    def is_team_selective_sync_policy_changed_details(self):
        """
        Check if the union tag is ``team_selective_sync_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'team_selective_sync_policy_changed_details'

    def is_tfa_change_policy_details(self):
        """
        Check if the union tag is ``tfa_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_policy_details'

    def is_two_account_change_policy_details(self):
        """
        Check if the union tag is ``two_account_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'two_account_change_policy_details'

    def is_viewer_info_policy_changed_details(self):
        """
        Check if the union tag is ``viewer_info_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'viewer_info_policy_changed_details'

    def is_web_sessions_change_fixed_length_policy_details(self):
        """
        Check if the union tag is ``web_sessions_change_fixed_length_policy_details``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_fixed_length_policy_details'

    def is_web_sessions_change_idle_length_policy_details(self):
        """
        Check if the union tag is ``web_sessions_change_idle_length_policy_details``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_idle_length_policy_details'

    def is_team_merge_from_details(self):
        """
        Check if the union tag is ``team_merge_from_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_from_details'

    def is_team_merge_to_details(self):
        """
        Check if the union tag is ``team_merge_to_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_to_details'

    def is_team_profile_add_logo_details(self):
        """
        Check if the union tag is ``team_profile_add_logo_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_add_logo_details'

    def is_team_profile_change_default_language_details(self):
        """
        Check if the union tag is ``team_profile_change_default_language_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_default_language_details'

    def is_team_profile_change_logo_details(self):
        """
        Check if the union tag is ``team_profile_change_logo_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_logo_details'

    def is_team_profile_change_name_details(self):
        """
        Check if the union tag is ``team_profile_change_name_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_name_details'

    def is_team_profile_remove_logo_details(self):
        """
        Check if the union tag is ``team_profile_remove_logo_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_remove_logo_details'

    def is_tfa_add_backup_phone_details(self):
        """
        Check if the union tag is ``tfa_add_backup_phone_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_backup_phone_details'

    def is_tfa_add_security_key_details(self):
        """
        Check if the union tag is ``tfa_add_security_key_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_security_key_details'

    def is_tfa_change_backup_phone_details(self):
        """
        Check if the union tag is ``tfa_change_backup_phone_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_backup_phone_details'

    def is_tfa_change_status_details(self):
        """
        Check if the union tag is ``tfa_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_status_details'

    def is_tfa_remove_backup_phone_details(self):
        """
        Check if the union tag is ``tfa_remove_backup_phone_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_backup_phone_details'

    def is_tfa_remove_security_key_details(self):
        """
        Check if the union tag is ``tfa_remove_security_key_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_security_key_details'

    def is_tfa_reset_details(self):
        """
        Check if the union tag is ``tfa_reset_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_reset_details'

    def is_missing_details(self):
        """
        Check if the union tag is ``missing_details``.

        :rtype: bool
        """
        return self._tag == 'missing_details'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_app_link_team_details(self):
        """
        Only call this if :meth:`is_app_link_team_details` is true.

        :rtype: AppLinkTeamDetails
        """
        if not self.is_app_link_team_details():
            raise AttributeError("tag 'app_link_team_details' not set")
        return self._value

    def get_app_link_user_details(self):
        """
        Only call this if :meth:`is_app_link_user_details` is true.

        :rtype: AppLinkUserDetails
        """
        if not self.is_app_link_user_details():
            raise AttributeError("tag 'app_link_user_details' not set")
        return self._value

    def get_app_unlink_team_details(self):
        """
        Only call this if :meth:`is_app_unlink_team_details` is true.

        :rtype: AppUnlinkTeamDetails
        """
        if not self.is_app_unlink_team_details():
            raise AttributeError("tag 'app_unlink_team_details' not set")
        return self._value

    def get_app_unlink_user_details(self):
        """
        Only call this if :meth:`is_app_unlink_user_details` is true.

        :rtype: AppUnlinkUserDetails
        """
        if not self.is_app_unlink_user_details():
            raise AttributeError("tag 'app_unlink_user_details' not set")
        return self._value

    def get_file_add_comment_details(self):
        """
        Only call this if :meth:`is_file_add_comment_details` is true.

        :rtype: FileAddCommentDetails
        """
        if not self.is_file_add_comment_details():
            raise AttributeError("tag 'file_add_comment_details' not set")
        return self._value

    def get_file_change_comment_subscription_details(self):
        """
        Only call this if :meth:`is_file_change_comment_subscription_details` is true.

        :rtype: FileChangeCommentSubscriptionDetails
        """
        if not self.is_file_change_comment_subscription_details():
            raise AttributeError("tag 'file_change_comment_subscription_details' not set")
        return self._value

    def get_file_delete_comment_details(self):
        """
        Only call this if :meth:`is_file_delete_comment_details` is true.

        :rtype: FileDeleteCommentDetails
        """
        if not self.is_file_delete_comment_details():
            raise AttributeError("tag 'file_delete_comment_details' not set")
        return self._value

    def get_file_like_comment_details(self):
        """
        Only call this if :meth:`is_file_like_comment_details` is true.

        :rtype: FileLikeCommentDetails
        """
        if not self.is_file_like_comment_details():
            raise AttributeError("tag 'file_like_comment_details' not set")
        return self._value

    def get_file_resolve_comment_details(self):
        """
        Only call this if :meth:`is_file_resolve_comment_details` is true.

        :rtype: FileResolveCommentDetails
        """
        if not self.is_file_resolve_comment_details():
            raise AttributeError("tag 'file_resolve_comment_details' not set")
        return self._value

    def get_file_unlike_comment_details(self):
        """
        Only call this if :meth:`is_file_unlike_comment_details` is true.

        :rtype: FileUnlikeCommentDetails
        """
        if not self.is_file_unlike_comment_details():
            raise AttributeError("tag 'file_unlike_comment_details' not set")
        return self._value

    def get_file_unresolve_comment_details(self):
        """
        Only call this if :meth:`is_file_unresolve_comment_details` is true.

        :rtype: FileUnresolveCommentDetails
        """
        if not self.is_file_unresolve_comment_details():
            raise AttributeError("tag 'file_unresolve_comment_details' not set")
        return self._value

    def get_device_change_ip_desktop_details(self):
        """
        Only call this if :meth:`is_device_change_ip_desktop_details` is true.

        :rtype: DeviceChangeIpDesktopDetails
        """
        if not self.is_device_change_ip_desktop_details():
            raise AttributeError("tag 'device_change_ip_desktop_details' not set")
        return self._value

    def get_device_change_ip_mobile_details(self):
        """
        Only call this if :meth:`is_device_change_ip_mobile_details` is true.

        :rtype: DeviceChangeIpMobileDetails
        """
        if not self.is_device_change_ip_mobile_details():
            raise AttributeError("tag 'device_change_ip_mobile_details' not set")
        return self._value

    def get_device_change_ip_web_details(self):
        """
        Only call this if :meth:`is_device_change_ip_web_details` is true.

        :rtype: DeviceChangeIpWebDetails
        """
        if not self.is_device_change_ip_web_details():
            raise AttributeError("tag 'device_change_ip_web_details' not set")
        return self._value

    def get_device_delete_on_unlink_fail_details(self):
        """
        Only call this if :meth:`is_device_delete_on_unlink_fail_details` is true.

        :rtype: DeviceDeleteOnUnlinkFailDetails
        """
        if not self.is_device_delete_on_unlink_fail_details():
            raise AttributeError("tag 'device_delete_on_unlink_fail_details' not set")
        return self._value

    def get_device_delete_on_unlink_success_details(self):
        """
        Only call this if :meth:`is_device_delete_on_unlink_success_details` is true.

        :rtype: DeviceDeleteOnUnlinkSuccessDetails
        """
        if not self.is_device_delete_on_unlink_success_details():
            raise AttributeError("tag 'device_delete_on_unlink_success_details' not set")
        return self._value

    def get_device_link_fail_details(self):
        """
        Only call this if :meth:`is_device_link_fail_details` is true.

        :rtype: DeviceLinkFailDetails
        """
        if not self.is_device_link_fail_details():
            raise AttributeError("tag 'device_link_fail_details' not set")
        return self._value

    def get_device_link_success_details(self):
        """
        Only call this if :meth:`is_device_link_success_details` is true.

        :rtype: DeviceLinkSuccessDetails
        """
        if not self.is_device_link_success_details():
            raise AttributeError("tag 'device_link_success_details' not set")
        return self._value

    def get_device_management_disabled_details(self):
        """
        Only call this if :meth:`is_device_management_disabled_details` is true.

        :rtype: DeviceManagementDisabledDetails
        """
        if not self.is_device_management_disabled_details():
            raise AttributeError("tag 'device_management_disabled_details' not set")
        return self._value

    def get_device_management_enabled_details(self):
        """
        Only call this if :meth:`is_device_management_enabled_details` is true.

        :rtype: DeviceManagementEnabledDetails
        """
        if not self.is_device_management_enabled_details():
            raise AttributeError("tag 'device_management_enabled_details' not set")
        return self._value

    def get_device_unlink_details(self):
        """
        Only call this if :meth:`is_device_unlink_details` is true.

        :rtype: DeviceUnlinkDetails
        """
        if not self.is_device_unlink_details():
            raise AttributeError("tag 'device_unlink_details' not set")
        return self._value

    def get_emm_refresh_auth_token_details(self):
        """
        Only call this if :meth:`is_emm_refresh_auth_token_details` is true.

        :rtype: EmmRefreshAuthTokenDetails
        """
        if not self.is_emm_refresh_auth_token_details():
            raise AttributeError("tag 'emm_refresh_auth_token_details' not set")
        return self._value

    def get_account_capture_change_availability_details(self):
        """
        Only call this if :meth:`is_account_capture_change_availability_details` is true.

        :rtype: AccountCaptureChangeAvailabilityDetails
        """
        if not self.is_account_capture_change_availability_details():
            raise AttributeError("tag 'account_capture_change_availability_details' not set")
        return self._value

    def get_account_capture_migrate_account_details(self):
        """
        Only call this if :meth:`is_account_capture_migrate_account_details` is true.

        :rtype: AccountCaptureMigrateAccountDetails
        """
        if not self.is_account_capture_migrate_account_details():
            raise AttributeError("tag 'account_capture_migrate_account_details' not set")
        return self._value

    def get_account_capture_notification_emails_sent_details(self):
        """
        Only call this if :meth:`is_account_capture_notification_emails_sent_details` is true.

        :rtype: AccountCaptureNotificationEmailsSentDetails
        """
        if not self.is_account_capture_notification_emails_sent_details():
            raise AttributeError("tag 'account_capture_notification_emails_sent_details' not set")
        return self._value

    def get_account_capture_relinquish_account_details(self):
        """
        Only call this if :meth:`is_account_capture_relinquish_account_details` is true.

        :rtype: AccountCaptureRelinquishAccountDetails
        """
        if not self.is_account_capture_relinquish_account_details():
            raise AttributeError("tag 'account_capture_relinquish_account_details' not set")
        return self._value

    def get_disabled_domain_invites_details(self):
        """
        Only call this if :meth:`is_disabled_domain_invites_details` is true.

        :rtype: DisabledDomainInvitesDetails
        """
        if not self.is_disabled_domain_invites_details():
            raise AttributeError("tag 'disabled_domain_invites_details' not set")
        return self._value

    def get_domain_invites_approve_request_to_join_team_details(self):
        """
        Only call this if :meth:`is_domain_invites_approve_request_to_join_team_details` is true.

        :rtype: DomainInvitesApproveRequestToJoinTeamDetails
        """
        if not self.is_domain_invites_approve_request_to_join_team_details():
            raise AttributeError("tag 'domain_invites_approve_request_to_join_team_details' not set")
        return self._value

    def get_domain_invites_decline_request_to_join_team_details(self):
        """
        Only call this if :meth:`is_domain_invites_decline_request_to_join_team_details` is true.

        :rtype: DomainInvitesDeclineRequestToJoinTeamDetails
        """
        if not self.is_domain_invites_decline_request_to_join_team_details():
            raise AttributeError("tag 'domain_invites_decline_request_to_join_team_details' not set")
        return self._value

    def get_domain_invites_email_existing_users_details(self):
        """
        Only call this if :meth:`is_domain_invites_email_existing_users_details` is true.

        :rtype: DomainInvitesEmailExistingUsersDetails
        """
        if not self.is_domain_invites_email_existing_users_details():
            raise AttributeError("tag 'domain_invites_email_existing_users_details' not set")
        return self._value

    def get_domain_invites_request_to_join_team_details(self):
        """
        Only call this if :meth:`is_domain_invites_request_to_join_team_details` is true.

        :rtype: DomainInvitesRequestToJoinTeamDetails
        """
        if not self.is_domain_invites_request_to_join_team_details():
            raise AttributeError("tag 'domain_invites_request_to_join_team_details' not set")
        return self._value

    def get_domain_invites_set_invite_new_user_pref_to_no_details(self):
        """
        Only call this if :meth:`is_domain_invites_set_invite_new_user_pref_to_no_details` is true.

        :rtype: DomainInvitesSetInviteNewUserPrefToNoDetails
        """
        if not self.is_domain_invites_set_invite_new_user_pref_to_no_details():
            raise AttributeError("tag 'domain_invites_set_invite_new_user_pref_to_no_details' not set")
        return self._value

    def get_domain_invites_set_invite_new_user_pref_to_yes_details(self):
        """
        Only call this if :meth:`is_domain_invites_set_invite_new_user_pref_to_yes_details` is true.

        :rtype: DomainInvitesSetInviteNewUserPrefToYesDetails
        """
        if not self.is_domain_invites_set_invite_new_user_pref_to_yes_details():
            raise AttributeError("tag 'domain_invites_set_invite_new_user_pref_to_yes_details' not set")
        return self._value

    def get_domain_verification_add_domain_fail_details(self):
        """
        Only call this if :meth:`is_domain_verification_add_domain_fail_details` is true.

        :rtype: DomainVerificationAddDomainFailDetails
        """
        if not self.is_domain_verification_add_domain_fail_details():
            raise AttributeError("tag 'domain_verification_add_domain_fail_details' not set")
        return self._value

    def get_domain_verification_add_domain_success_details(self):
        """
        Only call this if :meth:`is_domain_verification_add_domain_success_details` is true.

        :rtype: DomainVerificationAddDomainSuccessDetails
        """
        if not self.is_domain_verification_add_domain_success_details():
            raise AttributeError("tag 'domain_verification_add_domain_success_details' not set")
        return self._value

    def get_domain_verification_remove_domain_details(self):
        """
        Only call this if :meth:`is_domain_verification_remove_domain_details` is true.

        :rtype: DomainVerificationRemoveDomainDetails
        """
        if not self.is_domain_verification_remove_domain_details():
            raise AttributeError("tag 'domain_verification_remove_domain_details' not set")
        return self._value

    def get_enabled_domain_invites_details(self):
        """
        Only call this if :meth:`is_enabled_domain_invites_details` is true.

        :rtype: EnabledDomainInvitesDetails
        """
        if not self.is_enabled_domain_invites_details():
            raise AttributeError("tag 'enabled_domain_invites_details' not set")
        return self._value

    def get_create_folder_details(self):
        """
        Only call this if :meth:`is_create_folder_details` is true.

        :rtype: CreateFolderDetails
        """
        if not self.is_create_folder_details():
            raise AttributeError("tag 'create_folder_details' not set")
        return self._value

    def get_file_add_details(self):
        """
        Only call this if :meth:`is_file_add_details` is true.

        :rtype: FileAddDetails
        """
        if not self.is_file_add_details():
            raise AttributeError("tag 'file_add_details' not set")
        return self._value

    def get_file_copy_details(self):
        """
        Only call this if :meth:`is_file_copy_details` is true.

        :rtype: FileCopyDetails
        """
        if not self.is_file_copy_details():
            raise AttributeError("tag 'file_copy_details' not set")
        return self._value

    def get_file_delete_details(self):
        """
        Only call this if :meth:`is_file_delete_details` is true.

        :rtype: FileDeleteDetails
        """
        if not self.is_file_delete_details():
            raise AttributeError("tag 'file_delete_details' not set")
        return self._value

    def get_file_download_details(self):
        """
        Only call this if :meth:`is_file_download_details` is true.

        :rtype: FileDownloadDetails
        """
        if not self.is_file_download_details():
            raise AttributeError("tag 'file_download_details' not set")
        return self._value

    def get_file_edit_details(self):
        """
        Only call this if :meth:`is_file_edit_details` is true.

        :rtype: FileEditDetails
        """
        if not self.is_file_edit_details():
            raise AttributeError("tag 'file_edit_details' not set")
        return self._value

    def get_file_get_copy_reference_details(self):
        """
        Only call this if :meth:`is_file_get_copy_reference_details` is true.

        :rtype: FileGetCopyReferenceDetails
        """
        if not self.is_file_get_copy_reference_details():
            raise AttributeError("tag 'file_get_copy_reference_details' not set")
        return self._value

    def get_file_move_details(self):
        """
        Only call this if :meth:`is_file_move_details` is true.

        :rtype: FileMoveDetails
        """
        if not self.is_file_move_details():
            raise AttributeError("tag 'file_move_details' not set")
        return self._value

    def get_file_permanently_delete_details(self):
        """
        Only call this if :meth:`is_file_permanently_delete_details` is true.

        :rtype: FilePermanentlyDeleteDetails
        """
        if not self.is_file_permanently_delete_details():
            raise AttributeError("tag 'file_permanently_delete_details' not set")
        return self._value

    def get_file_preview_details(self):
        """
        Only call this if :meth:`is_file_preview_details` is true.

        :rtype: FilePreviewDetails
        """
        if not self.is_file_preview_details():
            raise AttributeError("tag 'file_preview_details' not set")
        return self._value

    def get_file_rename_details(self):
        """
        Only call this if :meth:`is_file_rename_details` is true.

        :rtype: FileRenameDetails
        """
        if not self.is_file_rename_details():
            raise AttributeError("tag 'file_rename_details' not set")
        return self._value

    def get_file_restore_details(self):
        """
        Only call this if :meth:`is_file_restore_details` is true.

        :rtype: FileRestoreDetails
        """
        if not self.is_file_restore_details():
            raise AttributeError("tag 'file_restore_details' not set")
        return self._value

    def get_file_revert_details(self):
        """
        Only call this if :meth:`is_file_revert_details` is true.

        :rtype: FileRevertDetails
        """
        if not self.is_file_revert_details():
            raise AttributeError("tag 'file_revert_details' not set")
        return self._value

    def get_file_rollback_changes_details(self):
        """
        Only call this if :meth:`is_file_rollback_changes_details` is true.

        :rtype: FileRollbackChangesDetails
        """
        if not self.is_file_rollback_changes_details():
            raise AttributeError("tag 'file_rollback_changes_details' not set")
        return self._value

    def get_file_save_copy_reference_details(self):
        """
        Only call this if :meth:`is_file_save_copy_reference_details` is true.

        :rtype: FileSaveCopyReferenceDetails
        """
        if not self.is_file_save_copy_reference_details():
            raise AttributeError("tag 'file_save_copy_reference_details' not set")
        return self._value

    def get_file_request_change_details(self):
        """
        Only call this if :meth:`is_file_request_change_details` is true.

        :rtype: FileRequestChangeDetails
        """
        if not self.is_file_request_change_details():
            raise AttributeError("tag 'file_request_change_details' not set")
        return self._value

    def get_file_request_close_details(self):
        """
        Only call this if :meth:`is_file_request_close_details` is true.

        :rtype: FileRequestCloseDetails
        """
        if not self.is_file_request_close_details():
            raise AttributeError("tag 'file_request_close_details' not set")
        return self._value

    def get_file_request_create_details(self):
        """
        Only call this if :meth:`is_file_request_create_details` is true.

        :rtype: FileRequestCreateDetails
        """
        if not self.is_file_request_create_details():
            raise AttributeError("tag 'file_request_create_details' not set")
        return self._value

    def get_file_request_receive_file_details(self):
        """
        Only call this if :meth:`is_file_request_receive_file_details` is true.

        :rtype: FileRequestReceiveFileDetails
        """
        if not self.is_file_request_receive_file_details():
            raise AttributeError("tag 'file_request_receive_file_details' not set")
        return self._value

    def get_group_add_external_id_details(self):
        """
        Only call this if :meth:`is_group_add_external_id_details` is true.

        :rtype: GroupAddExternalIdDetails
        """
        if not self.is_group_add_external_id_details():
            raise AttributeError("tag 'group_add_external_id_details' not set")
        return self._value

    def get_group_add_member_details(self):
        """
        Only call this if :meth:`is_group_add_member_details` is true.

        :rtype: GroupAddMemberDetails
        """
        if not self.is_group_add_member_details():
            raise AttributeError("tag 'group_add_member_details' not set")
        return self._value

    def get_group_change_external_id_details(self):
        """
        Only call this if :meth:`is_group_change_external_id_details` is true.

        :rtype: GroupChangeExternalIdDetails
        """
        if not self.is_group_change_external_id_details():
            raise AttributeError("tag 'group_change_external_id_details' not set")
        return self._value

    def get_group_change_management_type_details(self):
        """
        Only call this if :meth:`is_group_change_management_type_details` is true.

        :rtype: GroupChangeManagementTypeDetails
        """
        if not self.is_group_change_management_type_details():
            raise AttributeError("tag 'group_change_management_type_details' not set")
        return self._value

    def get_group_change_member_role_details(self):
        """
        Only call this if :meth:`is_group_change_member_role_details` is true.

        :rtype: GroupChangeMemberRoleDetails
        """
        if not self.is_group_change_member_role_details():
            raise AttributeError("tag 'group_change_member_role_details' not set")
        return self._value

    def get_group_create_details(self):
        """
        Only call this if :meth:`is_group_create_details` is true.

        :rtype: GroupCreateDetails
        """
        if not self.is_group_create_details():
            raise AttributeError("tag 'group_create_details' not set")
        return self._value

    def get_group_delete_details(self):
        """
        Only call this if :meth:`is_group_delete_details` is true.

        :rtype: GroupDeleteDetails
        """
        if not self.is_group_delete_details():
            raise AttributeError("tag 'group_delete_details' not set")
        return self._value

    def get_group_description_updated_details(self):
        """
        Only call this if :meth:`is_group_description_updated_details` is true.

        :rtype: GroupDescriptionUpdatedDetails
        """
        if not self.is_group_description_updated_details():
            raise AttributeError("tag 'group_description_updated_details' not set")
        return self._value

    def get_group_join_policy_updated_details(self):
        """
        Only call this if :meth:`is_group_join_policy_updated_details` is true.

        :rtype: GroupJoinPolicyUpdatedDetails
        """
        if not self.is_group_join_policy_updated_details():
            raise AttributeError("tag 'group_join_policy_updated_details' not set")
        return self._value

    def get_group_moved_details(self):
        """
        Only call this if :meth:`is_group_moved_details` is true.

        :rtype: GroupMovedDetails
        """
        if not self.is_group_moved_details():
            raise AttributeError("tag 'group_moved_details' not set")
        return self._value

    def get_group_remove_external_id_details(self):
        """
        Only call this if :meth:`is_group_remove_external_id_details` is true.

        :rtype: GroupRemoveExternalIdDetails
        """
        if not self.is_group_remove_external_id_details():
            raise AttributeError("tag 'group_remove_external_id_details' not set")
        return self._value

    def get_group_remove_member_details(self):
        """
        Only call this if :meth:`is_group_remove_member_details` is true.

        :rtype: GroupRemoveMemberDetails
        """
        if not self.is_group_remove_member_details():
            raise AttributeError("tag 'group_remove_member_details' not set")
        return self._value

    def get_group_rename_details(self):
        """
        Only call this if :meth:`is_group_rename_details` is true.

        :rtype: GroupRenameDetails
        """
        if not self.is_group_rename_details():
            raise AttributeError("tag 'group_rename_details' not set")
        return self._value

    def get_emm_error_details(self):
        """
        Only call this if :meth:`is_emm_error_details` is true.

        :rtype: EmmErrorDetails
        """
        if not self.is_emm_error_details():
            raise AttributeError("tag 'emm_error_details' not set")
        return self._value

    def get_login_fail_details(self):
        """
        Only call this if :meth:`is_login_fail_details` is true.

        :rtype: LoginFailDetails
        """
        if not self.is_login_fail_details():
            raise AttributeError("tag 'login_fail_details' not set")
        return self._value

    def get_login_success_details(self):
        """
        Only call this if :meth:`is_login_success_details` is true.

        :rtype: LoginSuccessDetails
        """
        if not self.is_login_success_details():
            raise AttributeError("tag 'login_success_details' not set")
        return self._value

    def get_logout_details(self):
        """
        Only call this if :meth:`is_logout_details` is true.

        :rtype: LogoutDetails
        """
        if not self.is_logout_details():
            raise AttributeError("tag 'logout_details' not set")
        return self._value

    def get_reseller_support_session_end_details(self):
        """
        Only call this if :meth:`is_reseller_support_session_end_details` is true.

        :rtype: ResellerSupportSessionEndDetails
        """
        if not self.is_reseller_support_session_end_details():
            raise AttributeError("tag 'reseller_support_session_end_details' not set")
        return self._value

    def get_reseller_support_session_start_details(self):
        """
        Only call this if :meth:`is_reseller_support_session_start_details` is true.

        :rtype: ResellerSupportSessionStartDetails
        """
        if not self.is_reseller_support_session_start_details():
            raise AttributeError("tag 'reseller_support_session_start_details' not set")
        return self._value

    def get_sign_in_as_session_end_details(self):
        """
        Only call this if :meth:`is_sign_in_as_session_end_details` is true.

        :rtype: SignInAsSessionEndDetails
        """
        if not self.is_sign_in_as_session_end_details():
            raise AttributeError("tag 'sign_in_as_session_end_details' not set")
        return self._value

    def get_sign_in_as_session_start_details(self):
        """
        Only call this if :meth:`is_sign_in_as_session_start_details` is true.

        :rtype: SignInAsSessionStartDetails
        """
        if not self.is_sign_in_as_session_start_details():
            raise AttributeError("tag 'sign_in_as_session_start_details' not set")
        return self._value

    def get_sso_error_details(self):
        """
        Only call this if :meth:`is_sso_error_details` is true.

        :rtype: SsoErrorDetails
        """
        if not self.is_sso_error_details():
            raise AttributeError("tag 'sso_error_details' not set")
        return self._value

    def get_member_add_name_details(self):
        """
        Only call this if :meth:`is_member_add_name_details` is true.

        :rtype: MemberAddNameDetails
        """
        if not self.is_member_add_name_details():
            raise AttributeError("tag 'member_add_name_details' not set")
        return self._value

    def get_member_change_admin_role_details(self):
        """
        Only call this if :meth:`is_member_change_admin_role_details` is true.

        :rtype: MemberChangeAdminRoleDetails
        """
        if not self.is_member_change_admin_role_details():
            raise AttributeError("tag 'member_change_admin_role_details' not set")
        return self._value

    def get_member_change_email_details(self):
        """
        Only call this if :meth:`is_member_change_email_details` is true.

        :rtype: MemberChangeEmailDetails
        """
        if not self.is_member_change_email_details():
            raise AttributeError("tag 'member_change_email_details' not set")
        return self._value

    def get_member_change_membership_type_details(self):
        """
        Only call this if :meth:`is_member_change_membership_type_details` is true.

        :rtype: MemberChangeMembershipTypeDetails
        """
        if not self.is_member_change_membership_type_details():
            raise AttributeError("tag 'member_change_membership_type_details' not set")
        return self._value

    def get_member_change_name_details(self):
        """
        Only call this if :meth:`is_member_change_name_details` is true.

        :rtype: MemberChangeNameDetails
        """
        if not self.is_member_change_name_details():
            raise AttributeError("tag 'member_change_name_details' not set")
        return self._value

    def get_member_change_status_details(self):
        """
        Only call this if :meth:`is_member_change_status_details` is true.

        :rtype: MemberChangeStatusDetails
        """
        if not self.is_member_change_status_details():
            raise AttributeError("tag 'member_change_status_details' not set")
        return self._value

    def get_member_delete_manual_contacts_details(self):
        """
        Only call this if :meth:`is_member_delete_manual_contacts_details` is true.

        :rtype: MemberDeleteManualContactsDetails
        """
        if not self.is_member_delete_manual_contacts_details():
            raise AttributeError("tag 'member_delete_manual_contacts_details' not set")
        return self._value

    def get_member_permanently_delete_account_contents_details(self):
        """
        Only call this if :meth:`is_member_permanently_delete_account_contents_details` is true.

        :rtype: MemberPermanentlyDeleteAccountContentsDetails
        """
        if not self.is_member_permanently_delete_account_contents_details():
            raise AttributeError("tag 'member_permanently_delete_account_contents_details' not set")
        return self._value

    def get_member_space_limits_add_custom_quota_details(self):
        """
        Only call this if :meth:`is_member_space_limits_add_custom_quota_details` is true.

        :rtype: MemberSpaceLimitsAddCustomQuotaDetails
        """
        if not self.is_member_space_limits_add_custom_quota_details():
            raise AttributeError("tag 'member_space_limits_add_custom_quota_details' not set")
        return self._value

    def get_member_space_limits_change_custom_quota_details(self):
        """
        Only call this if :meth:`is_member_space_limits_change_custom_quota_details` is true.

        :rtype: MemberSpaceLimitsChangeCustomQuotaDetails
        """
        if not self.is_member_space_limits_change_custom_quota_details():
            raise AttributeError("tag 'member_space_limits_change_custom_quota_details' not set")
        return self._value

    def get_member_space_limits_change_status_details(self):
        """
        Only call this if :meth:`is_member_space_limits_change_status_details` is true.

        :rtype: MemberSpaceLimitsChangeStatusDetails
        """
        if not self.is_member_space_limits_change_status_details():
            raise AttributeError("tag 'member_space_limits_change_status_details' not set")
        return self._value

    def get_member_space_limits_remove_custom_quota_details(self):
        """
        Only call this if :meth:`is_member_space_limits_remove_custom_quota_details` is true.

        :rtype: MemberSpaceLimitsRemoveCustomQuotaDetails
        """
        if not self.is_member_space_limits_remove_custom_quota_details():
            raise AttributeError("tag 'member_space_limits_remove_custom_quota_details' not set")
        return self._value

    def get_member_suggest_details(self):
        """
        Only call this if :meth:`is_member_suggest_details` is true.

        :rtype: MemberSuggestDetails
        """
        if not self.is_member_suggest_details():
            raise AttributeError("tag 'member_suggest_details' not set")
        return self._value

    def get_member_transfer_account_contents_details(self):
        """
        Only call this if :meth:`is_member_transfer_account_contents_details` is true.

        :rtype: MemberTransferAccountContentsDetails
        """
        if not self.is_member_transfer_account_contents_details():
            raise AttributeError("tag 'member_transfer_account_contents_details' not set")
        return self._value

    def get_secondary_mails_policy_changed_details(self):
        """
        Only call this if :meth:`is_secondary_mails_policy_changed_details` is true.

        :rtype: SecondaryMailsPolicyChangedDetails
        """
        if not self.is_secondary_mails_policy_changed_details():
            raise AttributeError("tag 'secondary_mails_policy_changed_details' not set")
        return self._value

    def get_paper_content_add_member_details(self):
        """
        Only call this if :meth:`is_paper_content_add_member_details` is true.

        :rtype: PaperContentAddMemberDetails
        """
        if not self.is_paper_content_add_member_details():
            raise AttributeError("tag 'paper_content_add_member_details' not set")
        return self._value

    def get_paper_content_add_to_folder_details(self):
        """
        Only call this if :meth:`is_paper_content_add_to_folder_details` is true.

        :rtype: PaperContentAddToFolderDetails
        """
        if not self.is_paper_content_add_to_folder_details():
            raise AttributeError("tag 'paper_content_add_to_folder_details' not set")
        return self._value

    def get_paper_content_archive_details(self):
        """
        Only call this if :meth:`is_paper_content_archive_details` is true.

        :rtype: PaperContentArchiveDetails
        """
        if not self.is_paper_content_archive_details():
            raise AttributeError("tag 'paper_content_archive_details' not set")
        return self._value

    def get_paper_content_create_details(self):
        """
        Only call this if :meth:`is_paper_content_create_details` is true.

        :rtype: PaperContentCreateDetails
        """
        if not self.is_paper_content_create_details():
            raise AttributeError("tag 'paper_content_create_details' not set")
        return self._value

    def get_paper_content_permanently_delete_details(self):
        """
        Only call this if :meth:`is_paper_content_permanently_delete_details` is true.

        :rtype: PaperContentPermanentlyDeleteDetails
        """
        if not self.is_paper_content_permanently_delete_details():
            raise AttributeError("tag 'paper_content_permanently_delete_details' not set")
        return self._value

    def get_paper_content_remove_from_folder_details(self):
        """
        Only call this if :meth:`is_paper_content_remove_from_folder_details` is true.

        :rtype: PaperContentRemoveFromFolderDetails
        """
        if not self.is_paper_content_remove_from_folder_details():
            raise AttributeError("tag 'paper_content_remove_from_folder_details' not set")
        return self._value

    def get_paper_content_remove_member_details(self):
        """
        Only call this if :meth:`is_paper_content_remove_member_details` is true.

        :rtype: PaperContentRemoveMemberDetails
        """
        if not self.is_paper_content_remove_member_details():
            raise AttributeError("tag 'paper_content_remove_member_details' not set")
        return self._value

    def get_paper_content_rename_details(self):
        """
        Only call this if :meth:`is_paper_content_rename_details` is true.

        :rtype: PaperContentRenameDetails
        """
        if not self.is_paper_content_rename_details():
            raise AttributeError("tag 'paper_content_rename_details' not set")
        return self._value

    def get_paper_content_restore_details(self):
        """
        Only call this if :meth:`is_paper_content_restore_details` is true.

        :rtype: PaperContentRestoreDetails
        """
        if not self.is_paper_content_restore_details():
            raise AttributeError("tag 'paper_content_restore_details' not set")
        return self._value

    def get_paper_doc_add_comment_details(self):
        """
        Only call this if :meth:`is_paper_doc_add_comment_details` is true.

        :rtype: PaperDocAddCommentDetails
        """
        if not self.is_paper_doc_add_comment_details():
            raise AttributeError("tag 'paper_doc_add_comment_details' not set")
        return self._value

    def get_paper_doc_change_member_role_details(self):
        """
        Only call this if :meth:`is_paper_doc_change_member_role_details` is true.

        :rtype: PaperDocChangeMemberRoleDetails
        """
        if not self.is_paper_doc_change_member_role_details():
            raise AttributeError("tag 'paper_doc_change_member_role_details' not set")
        return self._value

    def get_paper_doc_change_sharing_policy_details(self):
        """
        Only call this if :meth:`is_paper_doc_change_sharing_policy_details` is true.

        :rtype: PaperDocChangeSharingPolicyDetails
        """
        if not self.is_paper_doc_change_sharing_policy_details():
            raise AttributeError("tag 'paper_doc_change_sharing_policy_details' not set")
        return self._value

    def get_paper_doc_change_subscription_details(self):
        """
        Only call this if :meth:`is_paper_doc_change_subscription_details` is true.

        :rtype: PaperDocChangeSubscriptionDetails
        """
        if not self.is_paper_doc_change_subscription_details():
            raise AttributeError("tag 'paper_doc_change_subscription_details' not set")
        return self._value

    def get_paper_doc_deleted_details(self):
        """
        Only call this if :meth:`is_paper_doc_deleted_details` is true.

        :rtype: PaperDocDeletedDetails
        """
        if not self.is_paper_doc_deleted_details():
            raise AttributeError("tag 'paper_doc_deleted_details' not set")
        return self._value

    def get_paper_doc_delete_comment_details(self):
        """
        Only call this if :meth:`is_paper_doc_delete_comment_details` is true.

        :rtype: PaperDocDeleteCommentDetails
        """
        if not self.is_paper_doc_delete_comment_details():
            raise AttributeError("tag 'paper_doc_delete_comment_details' not set")
        return self._value

    def get_paper_doc_download_details(self):
        """
        Only call this if :meth:`is_paper_doc_download_details` is true.

        :rtype: PaperDocDownloadDetails
        """
        if not self.is_paper_doc_download_details():
            raise AttributeError("tag 'paper_doc_download_details' not set")
        return self._value

    def get_paper_doc_edit_details(self):
        """
        Only call this if :meth:`is_paper_doc_edit_details` is true.

        :rtype: PaperDocEditDetails
        """
        if not self.is_paper_doc_edit_details():
            raise AttributeError("tag 'paper_doc_edit_details' not set")
        return self._value

    def get_paper_doc_edit_comment_details(self):
        """
        Only call this if :meth:`is_paper_doc_edit_comment_details` is true.

        :rtype: PaperDocEditCommentDetails
        """
        if not self.is_paper_doc_edit_comment_details():
            raise AttributeError("tag 'paper_doc_edit_comment_details' not set")
        return self._value

    def get_paper_doc_followed_details(self):
        """
        Only call this if :meth:`is_paper_doc_followed_details` is true.

        :rtype: PaperDocFollowedDetails
        """
        if not self.is_paper_doc_followed_details():
            raise AttributeError("tag 'paper_doc_followed_details' not set")
        return self._value

    def get_paper_doc_mention_details(self):
        """
        Only call this if :meth:`is_paper_doc_mention_details` is true.

        :rtype: PaperDocMentionDetails
        """
        if not self.is_paper_doc_mention_details():
            raise AttributeError("tag 'paper_doc_mention_details' not set")
        return self._value

    def get_paper_doc_ownership_changed_details(self):
        """
        Only call this if :meth:`is_paper_doc_ownership_changed_details` is true.

        :rtype: PaperDocOwnershipChangedDetails
        """
        if not self.is_paper_doc_ownership_changed_details():
            raise AttributeError("tag 'paper_doc_ownership_changed_details' not set")
        return self._value

    def get_paper_doc_request_access_details(self):
        """
        Only call this if :meth:`is_paper_doc_request_access_details` is true.

        :rtype: PaperDocRequestAccessDetails
        """
        if not self.is_paper_doc_request_access_details():
            raise AttributeError("tag 'paper_doc_request_access_details' not set")
        return self._value

    def get_paper_doc_resolve_comment_details(self):
        """
        Only call this if :meth:`is_paper_doc_resolve_comment_details` is true.

        :rtype: PaperDocResolveCommentDetails
        """
        if not self.is_paper_doc_resolve_comment_details():
            raise AttributeError("tag 'paper_doc_resolve_comment_details' not set")
        return self._value

    def get_paper_doc_revert_details(self):
        """
        Only call this if :meth:`is_paper_doc_revert_details` is true.

        :rtype: PaperDocRevertDetails
        """
        if not self.is_paper_doc_revert_details():
            raise AttributeError("tag 'paper_doc_revert_details' not set")
        return self._value

    def get_paper_doc_slack_share_details(self):
        """
        Only call this if :meth:`is_paper_doc_slack_share_details` is true.

        :rtype: PaperDocSlackShareDetails
        """
        if not self.is_paper_doc_slack_share_details():
            raise AttributeError("tag 'paper_doc_slack_share_details' not set")
        return self._value

    def get_paper_doc_team_invite_details(self):
        """
        Only call this if :meth:`is_paper_doc_team_invite_details` is true.

        :rtype: PaperDocTeamInviteDetails
        """
        if not self.is_paper_doc_team_invite_details():
            raise AttributeError("tag 'paper_doc_team_invite_details' not set")
        return self._value

    def get_paper_doc_trashed_details(self):
        """
        Only call this if :meth:`is_paper_doc_trashed_details` is true.

        :rtype: PaperDocTrashedDetails
        """
        if not self.is_paper_doc_trashed_details():
            raise AttributeError("tag 'paper_doc_trashed_details' not set")
        return self._value

    def get_paper_doc_unresolve_comment_details(self):
        """
        Only call this if :meth:`is_paper_doc_unresolve_comment_details` is true.

        :rtype: PaperDocUnresolveCommentDetails
        """
        if not self.is_paper_doc_unresolve_comment_details():
            raise AttributeError("tag 'paper_doc_unresolve_comment_details' not set")
        return self._value

    def get_paper_doc_untrashed_details(self):
        """
        Only call this if :meth:`is_paper_doc_untrashed_details` is true.

        :rtype: PaperDocUntrashedDetails
        """
        if not self.is_paper_doc_untrashed_details():
            raise AttributeError("tag 'paper_doc_untrashed_details' not set")
        return self._value

    def get_paper_doc_view_details(self):
        """
        Only call this if :meth:`is_paper_doc_view_details` is true.

        :rtype: PaperDocViewDetails
        """
        if not self.is_paper_doc_view_details():
            raise AttributeError("tag 'paper_doc_view_details' not set")
        return self._value

    def get_paper_external_view_allow_details(self):
        """
        Only call this if :meth:`is_paper_external_view_allow_details` is true.

        :rtype: PaperExternalViewAllowDetails
        """
        if not self.is_paper_external_view_allow_details():
            raise AttributeError("tag 'paper_external_view_allow_details' not set")
        return self._value

    def get_paper_external_view_default_team_details(self):
        """
        Only call this if :meth:`is_paper_external_view_default_team_details` is true.

        :rtype: PaperExternalViewDefaultTeamDetails
        """
        if not self.is_paper_external_view_default_team_details():
            raise AttributeError("tag 'paper_external_view_default_team_details' not set")
        return self._value

    def get_paper_external_view_forbid_details(self):
        """
        Only call this if :meth:`is_paper_external_view_forbid_details` is true.

        :rtype: PaperExternalViewForbidDetails
        """
        if not self.is_paper_external_view_forbid_details():
            raise AttributeError("tag 'paper_external_view_forbid_details' not set")
        return self._value

    def get_paper_folder_change_subscription_details(self):
        """
        Only call this if :meth:`is_paper_folder_change_subscription_details` is true.

        :rtype: PaperFolderChangeSubscriptionDetails
        """
        if not self.is_paper_folder_change_subscription_details():
            raise AttributeError("tag 'paper_folder_change_subscription_details' not set")
        return self._value

    def get_paper_folder_deleted_details(self):
        """
        Only call this if :meth:`is_paper_folder_deleted_details` is true.

        :rtype: PaperFolderDeletedDetails
        """
        if not self.is_paper_folder_deleted_details():
            raise AttributeError("tag 'paper_folder_deleted_details' not set")
        return self._value

    def get_paper_folder_followed_details(self):
        """
        Only call this if :meth:`is_paper_folder_followed_details` is true.

        :rtype: PaperFolderFollowedDetails
        """
        if not self.is_paper_folder_followed_details():
            raise AttributeError("tag 'paper_folder_followed_details' not set")
        return self._value

    def get_paper_folder_team_invite_details(self):
        """
        Only call this if :meth:`is_paper_folder_team_invite_details` is true.

        :rtype: PaperFolderTeamInviteDetails
        """
        if not self.is_paper_folder_team_invite_details():
            raise AttributeError("tag 'paper_folder_team_invite_details' not set")
        return self._value

    def get_password_change_details(self):
        """
        Only call this if :meth:`is_password_change_details` is true.

        :rtype: PasswordChangeDetails
        """
        if not self.is_password_change_details():
            raise AttributeError("tag 'password_change_details' not set")
        return self._value

    def get_password_reset_details(self):
        """
        Only call this if :meth:`is_password_reset_details` is true.

        :rtype: PasswordResetDetails
        """
        if not self.is_password_reset_details():
            raise AttributeError("tag 'password_reset_details' not set")
        return self._value

    def get_password_reset_all_details(self):
        """
        Only call this if :meth:`is_password_reset_all_details` is true.

        :rtype: PasswordResetAllDetails
        """
        if not self.is_password_reset_all_details():
            raise AttributeError("tag 'password_reset_all_details' not set")
        return self._value

    def get_emm_create_exceptions_report_details(self):
        """
        Only call this if :meth:`is_emm_create_exceptions_report_details` is true.

        :rtype: EmmCreateExceptionsReportDetails
        """
        if not self.is_emm_create_exceptions_report_details():
            raise AttributeError("tag 'emm_create_exceptions_report_details' not set")
        return self._value

    def get_emm_create_usage_report_details(self):
        """
        Only call this if :meth:`is_emm_create_usage_report_details` is true.

        :rtype: EmmCreateUsageReportDetails
        """
        if not self.is_emm_create_usage_report_details():
            raise AttributeError("tag 'emm_create_usage_report_details' not set")
        return self._value

    def get_export_members_report_details(self):
        """
        Only call this if :meth:`is_export_members_report_details` is true.

        :rtype: ExportMembersReportDetails
        """
        if not self.is_export_members_report_details():
            raise AttributeError("tag 'export_members_report_details' not set")
        return self._value

    def get_paper_admin_export_start_details(self):
        """
        Only call this if :meth:`is_paper_admin_export_start_details` is true.

        :rtype: PaperAdminExportStartDetails
        """
        if not self.is_paper_admin_export_start_details():
            raise AttributeError("tag 'paper_admin_export_start_details' not set")
        return self._value

    def get_smart_sync_create_admin_privilege_report_details(self):
        """
        Only call this if :meth:`is_smart_sync_create_admin_privilege_report_details` is true.

        :rtype: SmartSyncCreateAdminPrivilegeReportDetails
        """
        if not self.is_smart_sync_create_admin_privilege_report_details():
            raise AttributeError("tag 'smart_sync_create_admin_privilege_report_details' not set")
        return self._value

    def get_team_activity_create_report_details(self):
        """
        Only call this if :meth:`is_team_activity_create_report_details` is true.

        :rtype: TeamActivityCreateReportDetails
        """
        if not self.is_team_activity_create_report_details():
            raise AttributeError("tag 'team_activity_create_report_details' not set")
        return self._value

    def get_collection_share_details(self):
        """
        Only call this if :meth:`is_collection_share_details` is true.

        :rtype: CollectionShareDetails
        """
        if not self.is_collection_share_details():
            raise AttributeError("tag 'collection_share_details' not set")
        return self._value

    def get_note_acl_invite_only_details(self):
        """
        Only call this if :meth:`is_note_acl_invite_only_details` is true.

        :rtype: NoteAclInviteOnlyDetails
        """
        if not self.is_note_acl_invite_only_details():
            raise AttributeError("tag 'note_acl_invite_only_details' not set")
        return self._value

    def get_note_acl_link_details(self):
        """
        Only call this if :meth:`is_note_acl_link_details` is true.

        :rtype: NoteAclLinkDetails
        """
        if not self.is_note_acl_link_details():
            raise AttributeError("tag 'note_acl_link_details' not set")
        return self._value

    def get_note_acl_team_link_details(self):
        """
        Only call this if :meth:`is_note_acl_team_link_details` is true.

        :rtype: NoteAclTeamLinkDetails
        """
        if not self.is_note_acl_team_link_details():
            raise AttributeError("tag 'note_acl_team_link_details' not set")
        return self._value

    def get_note_shared_details(self):
        """
        Only call this if :meth:`is_note_shared_details` is true.

        :rtype: NoteSharedDetails
        """
        if not self.is_note_shared_details():
            raise AttributeError("tag 'note_shared_details' not set")
        return self._value

    def get_note_share_receive_details(self):
        """
        Only call this if :meth:`is_note_share_receive_details` is true.

        :rtype: NoteShareReceiveDetails
        """
        if not self.is_note_share_receive_details():
            raise AttributeError("tag 'note_share_receive_details' not set")
        return self._value

    def get_open_note_shared_details(self):
        """
        Only call this if :meth:`is_open_note_shared_details` is true.

        :rtype: OpenNoteSharedDetails
        """
        if not self.is_open_note_shared_details():
            raise AttributeError("tag 'open_note_shared_details' not set")
        return self._value

    def get_sf_add_group_details(self):
        """
        Only call this if :meth:`is_sf_add_group_details` is true.

        :rtype: SfAddGroupDetails
        """
        if not self.is_sf_add_group_details():
            raise AttributeError("tag 'sf_add_group_details' not set")
        return self._value

    def get_sf_allow_non_members_to_view_shared_links_details(self):
        """
        Only call this if :meth:`is_sf_allow_non_members_to_view_shared_links_details` is true.

        :rtype: SfAllowNonMembersToViewSharedLinksDetails
        """
        if not self.is_sf_allow_non_members_to_view_shared_links_details():
            raise AttributeError("tag 'sf_allow_non_members_to_view_shared_links_details' not set")
        return self._value

    def get_sf_external_invite_warn_details(self):
        """
        Only call this if :meth:`is_sf_external_invite_warn_details` is true.

        :rtype: SfExternalInviteWarnDetails
        """
        if not self.is_sf_external_invite_warn_details():
            raise AttributeError("tag 'sf_external_invite_warn_details' not set")
        return self._value

    def get_sf_fb_invite_details(self):
        """
        Only call this if :meth:`is_sf_fb_invite_details` is true.

        :rtype: SfFbInviteDetails
        """
        if not self.is_sf_fb_invite_details():
            raise AttributeError("tag 'sf_fb_invite_details' not set")
        return self._value

    def get_sf_fb_invite_change_role_details(self):
        """
        Only call this if :meth:`is_sf_fb_invite_change_role_details` is true.

        :rtype: SfFbInviteChangeRoleDetails
        """
        if not self.is_sf_fb_invite_change_role_details():
            raise AttributeError("tag 'sf_fb_invite_change_role_details' not set")
        return self._value

    def get_sf_fb_uninvite_details(self):
        """
        Only call this if :meth:`is_sf_fb_uninvite_details` is true.

        :rtype: SfFbUninviteDetails
        """
        if not self.is_sf_fb_uninvite_details():
            raise AttributeError("tag 'sf_fb_uninvite_details' not set")
        return self._value

    def get_sf_invite_group_details(self):
        """
        Only call this if :meth:`is_sf_invite_group_details` is true.

        :rtype: SfInviteGroupDetails
        """
        if not self.is_sf_invite_group_details():
            raise AttributeError("tag 'sf_invite_group_details' not set")
        return self._value

    def get_sf_team_grant_access_details(self):
        """
        Only call this if :meth:`is_sf_team_grant_access_details` is true.

        :rtype: SfTeamGrantAccessDetails
        """
        if not self.is_sf_team_grant_access_details():
            raise AttributeError("tag 'sf_team_grant_access_details' not set")
        return self._value

    def get_sf_team_invite_details(self):
        """
        Only call this if :meth:`is_sf_team_invite_details` is true.

        :rtype: SfTeamInviteDetails
        """
        if not self.is_sf_team_invite_details():
            raise AttributeError("tag 'sf_team_invite_details' not set")
        return self._value

    def get_sf_team_invite_change_role_details(self):
        """
        Only call this if :meth:`is_sf_team_invite_change_role_details` is true.

        :rtype: SfTeamInviteChangeRoleDetails
        """
        if not self.is_sf_team_invite_change_role_details():
            raise AttributeError("tag 'sf_team_invite_change_role_details' not set")
        return self._value

    def get_sf_team_join_details(self):
        """
        Only call this if :meth:`is_sf_team_join_details` is true.

        :rtype: SfTeamJoinDetails
        """
        if not self.is_sf_team_join_details():
            raise AttributeError("tag 'sf_team_join_details' not set")
        return self._value

    def get_sf_team_join_from_oob_link_details(self):
        """
        Only call this if :meth:`is_sf_team_join_from_oob_link_details` is true.

        :rtype: SfTeamJoinFromOobLinkDetails
        """
        if not self.is_sf_team_join_from_oob_link_details():
            raise AttributeError("tag 'sf_team_join_from_oob_link_details' not set")
        return self._value

    def get_sf_team_uninvite_details(self):
        """
        Only call this if :meth:`is_sf_team_uninvite_details` is true.

        :rtype: SfTeamUninviteDetails
        """
        if not self.is_sf_team_uninvite_details():
            raise AttributeError("tag 'sf_team_uninvite_details' not set")
        return self._value

    def get_shared_content_add_invitees_details(self):
        """
        Only call this if :meth:`is_shared_content_add_invitees_details` is true.

        :rtype: SharedContentAddInviteesDetails
        """
        if not self.is_shared_content_add_invitees_details():
            raise AttributeError("tag 'shared_content_add_invitees_details' not set")
        return self._value

    def get_shared_content_add_link_expiry_details(self):
        """
        Only call this if :meth:`is_shared_content_add_link_expiry_details` is true.

        :rtype: SharedContentAddLinkExpiryDetails
        """
        if not self.is_shared_content_add_link_expiry_details():
            raise AttributeError("tag 'shared_content_add_link_expiry_details' not set")
        return self._value

    def get_shared_content_add_link_password_details(self):
        """
        Only call this if :meth:`is_shared_content_add_link_password_details` is true.

        :rtype: SharedContentAddLinkPasswordDetails
        """
        if not self.is_shared_content_add_link_password_details():
            raise AttributeError("tag 'shared_content_add_link_password_details' not set")
        return self._value

    def get_shared_content_add_member_details(self):
        """
        Only call this if :meth:`is_shared_content_add_member_details` is true.

        :rtype: SharedContentAddMemberDetails
        """
        if not self.is_shared_content_add_member_details():
            raise AttributeError("tag 'shared_content_add_member_details' not set")
        return self._value

    def get_shared_content_change_downloads_policy_details(self):
        """
        Only call this if :meth:`is_shared_content_change_downloads_policy_details` is true.

        :rtype: SharedContentChangeDownloadsPolicyDetails
        """
        if not self.is_shared_content_change_downloads_policy_details():
            raise AttributeError("tag 'shared_content_change_downloads_policy_details' not set")
        return self._value

    def get_shared_content_change_invitee_role_details(self):
        """
        Only call this if :meth:`is_shared_content_change_invitee_role_details` is true.

        :rtype: SharedContentChangeInviteeRoleDetails
        """
        if not self.is_shared_content_change_invitee_role_details():
            raise AttributeError("tag 'shared_content_change_invitee_role_details' not set")
        return self._value

    def get_shared_content_change_link_audience_details(self):
        """
        Only call this if :meth:`is_shared_content_change_link_audience_details` is true.

        :rtype: SharedContentChangeLinkAudienceDetails
        """
        if not self.is_shared_content_change_link_audience_details():
            raise AttributeError("tag 'shared_content_change_link_audience_details' not set")
        return self._value

    def get_shared_content_change_link_expiry_details(self):
        """
        Only call this if :meth:`is_shared_content_change_link_expiry_details` is true.

        :rtype: SharedContentChangeLinkExpiryDetails
        """
        if not self.is_shared_content_change_link_expiry_details():
            raise AttributeError("tag 'shared_content_change_link_expiry_details' not set")
        return self._value

    def get_shared_content_change_link_password_details(self):
        """
        Only call this if :meth:`is_shared_content_change_link_password_details` is true.

        :rtype: SharedContentChangeLinkPasswordDetails
        """
        if not self.is_shared_content_change_link_password_details():
            raise AttributeError("tag 'shared_content_change_link_password_details' not set")
        return self._value

    def get_shared_content_change_member_role_details(self):
        """
        Only call this if :meth:`is_shared_content_change_member_role_details` is true.

        :rtype: SharedContentChangeMemberRoleDetails
        """
        if not self.is_shared_content_change_member_role_details():
            raise AttributeError("tag 'shared_content_change_member_role_details' not set")
        return self._value

    def get_shared_content_change_viewer_info_policy_details(self):
        """
        Only call this if :meth:`is_shared_content_change_viewer_info_policy_details` is true.

        :rtype: SharedContentChangeViewerInfoPolicyDetails
        """
        if not self.is_shared_content_change_viewer_info_policy_details():
            raise AttributeError("tag 'shared_content_change_viewer_info_policy_details' not set")
        return self._value

    def get_shared_content_claim_invitation_details(self):
        """
        Only call this if :meth:`is_shared_content_claim_invitation_details` is true.

        :rtype: SharedContentClaimInvitationDetails
        """
        if not self.is_shared_content_claim_invitation_details():
            raise AttributeError("tag 'shared_content_claim_invitation_details' not set")
        return self._value

    def get_shared_content_copy_details(self):
        """
        Only call this if :meth:`is_shared_content_copy_details` is true.

        :rtype: SharedContentCopyDetails
        """
        if not self.is_shared_content_copy_details():
            raise AttributeError("tag 'shared_content_copy_details' not set")
        return self._value

    def get_shared_content_download_details(self):
        """
        Only call this if :meth:`is_shared_content_download_details` is true.

        :rtype: SharedContentDownloadDetails
        """
        if not self.is_shared_content_download_details():
            raise AttributeError("tag 'shared_content_download_details' not set")
        return self._value

    def get_shared_content_relinquish_membership_details(self):
        """
        Only call this if :meth:`is_shared_content_relinquish_membership_details` is true.

        :rtype: SharedContentRelinquishMembershipDetails
        """
        if not self.is_shared_content_relinquish_membership_details():
            raise AttributeError("tag 'shared_content_relinquish_membership_details' not set")
        return self._value

    def get_shared_content_remove_invitees_details(self):
        """
        Only call this if :meth:`is_shared_content_remove_invitees_details` is true.

        :rtype: SharedContentRemoveInviteesDetails
        """
        if not self.is_shared_content_remove_invitees_details():
            raise AttributeError("tag 'shared_content_remove_invitees_details' not set")
        return self._value

    def get_shared_content_remove_link_expiry_details(self):
        """
        Only call this if :meth:`is_shared_content_remove_link_expiry_details` is true.

        :rtype: SharedContentRemoveLinkExpiryDetails
        """
        if not self.is_shared_content_remove_link_expiry_details():
            raise AttributeError("tag 'shared_content_remove_link_expiry_details' not set")
        return self._value

    def get_shared_content_remove_link_password_details(self):
        """
        Only call this if :meth:`is_shared_content_remove_link_password_details` is true.

        :rtype: SharedContentRemoveLinkPasswordDetails
        """
        if not self.is_shared_content_remove_link_password_details():
            raise AttributeError("tag 'shared_content_remove_link_password_details' not set")
        return self._value

    def get_shared_content_remove_member_details(self):
        """
        Only call this if :meth:`is_shared_content_remove_member_details` is true.

        :rtype: SharedContentRemoveMemberDetails
        """
        if not self.is_shared_content_remove_member_details():
            raise AttributeError("tag 'shared_content_remove_member_details' not set")
        return self._value

    def get_shared_content_request_access_details(self):
        """
        Only call this if :meth:`is_shared_content_request_access_details` is true.

        :rtype: SharedContentRequestAccessDetails
        """
        if not self.is_shared_content_request_access_details():
            raise AttributeError("tag 'shared_content_request_access_details' not set")
        return self._value

    def get_shared_content_unshare_details(self):
        """
        Only call this if :meth:`is_shared_content_unshare_details` is true.

        :rtype: SharedContentUnshareDetails
        """
        if not self.is_shared_content_unshare_details():
            raise AttributeError("tag 'shared_content_unshare_details' not set")
        return self._value

    def get_shared_content_view_details(self):
        """
        Only call this if :meth:`is_shared_content_view_details` is true.

        :rtype: SharedContentViewDetails
        """
        if not self.is_shared_content_view_details():
            raise AttributeError("tag 'shared_content_view_details' not set")
        return self._value

    def get_shared_folder_change_link_policy_details(self):
        """
        Only call this if :meth:`is_shared_folder_change_link_policy_details` is true.

        :rtype: SharedFolderChangeLinkPolicyDetails
        """
        if not self.is_shared_folder_change_link_policy_details():
            raise AttributeError("tag 'shared_folder_change_link_policy_details' not set")
        return self._value

    def get_shared_folder_change_members_inheritance_policy_details(self):
        """
        Only call this if :meth:`is_shared_folder_change_members_inheritance_policy_details` is true.

        :rtype: SharedFolderChangeMembersInheritancePolicyDetails
        """
        if not self.is_shared_folder_change_members_inheritance_policy_details():
            raise AttributeError("tag 'shared_folder_change_members_inheritance_policy_details' not set")
        return self._value

    def get_shared_folder_change_members_management_policy_details(self):
        """
        Only call this if :meth:`is_shared_folder_change_members_management_policy_details` is true.

        :rtype: SharedFolderChangeMembersManagementPolicyDetails
        """
        if not self.is_shared_folder_change_members_management_policy_details():
            raise AttributeError("tag 'shared_folder_change_members_management_policy_details' not set")
        return self._value

    def get_shared_folder_change_members_policy_details(self):
        """
        Only call this if :meth:`is_shared_folder_change_members_policy_details` is true.

        :rtype: SharedFolderChangeMembersPolicyDetails
        """
        if not self.is_shared_folder_change_members_policy_details():
            raise AttributeError("tag 'shared_folder_change_members_policy_details' not set")
        return self._value

    def get_shared_folder_create_details(self):
        """
        Only call this if :meth:`is_shared_folder_create_details` is true.

        :rtype: SharedFolderCreateDetails
        """
        if not self.is_shared_folder_create_details():
            raise AttributeError("tag 'shared_folder_create_details' not set")
        return self._value

    def get_shared_folder_decline_invitation_details(self):
        """
        Only call this if :meth:`is_shared_folder_decline_invitation_details` is true.

        :rtype: SharedFolderDeclineInvitationDetails
        """
        if not self.is_shared_folder_decline_invitation_details():
            raise AttributeError("tag 'shared_folder_decline_invitation_details' not set")
        return self._value

    def get_shared_folder_mount_details(self):
        """
        Only call this if :meth:`is_shared_folder_mount_details` is true.

        :rtype: SharedFolderMountDetails
        """
        if not self.is_shared_folder_mount_details():
            raise AttributeError("tag 'shared_folder_mount_details' not set")
        return self._value

    def get_shared_folder_nest_details(self):
        """
        Only call this if :meth:`is_shared_folder_nest_details` is true.

        :rtype: SharedFolderNestDetails
        """
        if not self.is_shared_folder_nest_details():
            raise AttributeError("tag 'shared_folder_nest_details' not set")
        return self._value

    def get_shared_folder_transfer_ownership_details(self):
        """
        Only call this if :meth:`is_shared_folder_transfer_ownership_details` is true.

        :rtype: SharedFolderTransferOwnershipDetails
        """
        if not self.is_shared_folder_transfer_ownership_details():
            raise AttributeError("tag 'shared_folder_transfer_ownership_details' not set")
        return self._value

    def get_shared_folder_unmount_details(self):
        """
        Only call this if :meth:`is_shared_folder_unmount_details` is true.

        :rtype: SharedFolderUnmountDetails
        """
        if not self.is_shared_folder_unmount_details():
            raise AttributeError("tag 'shared_folder_unmount_details' not set")
        return self._value

    def get_shared_link_add_expiry_details(self):
        """
        Only call this if :meth:`is_shared_link_add_expiry_details` is true.

        :rtype: SharedLinkAddExpiryDetails
        """
        if not self.is_shared_link_add_expiry_details():
            raise AttributeError("tag 'shared_link_add_expiry_details' not set")
        return self._value

    def get_shared_link_change_expiry_details(self):
        """
        Only call this if :meth:`is_shared_link_change_expiry_details` is true.

        :rtype: SharedLinkChangeExpiryDetails
        """
        if not self.is_shared_link_change_expiry_details():
            raise AttributeError("tag 'shared_link_change_expiry_details' not set")
        return self._value

    def get_shared_link_change_visibility_details(self):
        """
        Only call this if :meth:`is_shared_link_change_visibility_details` is true.

        :rtype: SharedLinkChangeVisibilityDetails
        """
        if not self.is_shared_link_change_visibility_details():
            raise AttributeError("tag 'shared_link_change_visibility_details' not set")
        return self._value

    def get_shared_link_copy_details(self):
        """
        Only call this if :meth:`is_shared_link_copy_details` is true.

        :rtype: SharedLinkCopyDetails
        """
        if not self.is_shared_link_copy_details():
            raise AttributeError("tag 'shared_link_copy_details' not set")
        return self._value

    def get_shared_link_create_details(self):
        """
        Only call this if :meth:`is_shared_link_create_details` is true.

        :rtype: SharedLinkCreateDetails
        """
        if not self.is_shared_link_create_details():
            raise AttributeError("tag 'shared_link_create_details' not set")
        return self._value

    def get_shared_link_disable_details(self):
        """
        Only call this if :meth:`is_shared_link_disable_details` is true.

        :rtype: SharedLinkDisableDetails
        """
        if not self.is_shared_link_disable_details():
            raise AttributeError("tag 'shared_link_disable_details' not set")
        return self._value

    def get_shared_link_download_details(self):
        """
        Only call this if :meth:`is_shared_link_download_details` is true.

        :rtype: SharedLinkDownloadDetails
        """
        if not self.is_shared_link_download_details():
            raise AttributeError("tag 'shared_link_download_details' not set")
        return self._value

    def get_shared_link_remove_expiry_details(self):
        """
        Only call this if :meth:`is_shared_link_remove_expiry_details` is true.

        :rtype: SharedLinkRemoveExpiryDetails
        """
        if not self.is_shared_link_remove_expiry_details():
            raise AttributeError("tag 'shared_link_remove_expiry_details' not set")
        return self._value

    def get_shared_link_share_details(self):
        """
        Only call this if :meth:`is_shared_link_share_details` is true.

        :rtype: SharedLinkShareDetails
        """
        if not self.is_shared_link_share_details():
            raise AttributeError("tag 'shared_link_share_details' not set")
        return self._value

    def get_shared_link_view_details(self):
        """
        Only call this if :meth:`is_shared_link_view_details` is true.

        :rtype: SharedLinkViewDetails
        """
        if not self.is_shared_link_view_details():
            raise AttributeError("tag 'shared_link_view_details' not set")
        return self._value

    def get_shared_note_opened_details(self):
        """
        Only call this if :meth:`is_shared_note_opened_details` is true.

        :rtype: SharedNoteOpenedDetails
        """
        if not self.is_shared_note_opened_details():
            raise AttributeError("tag 'shared_note_opened_details' not set")
        return self._value

    def get_shmodel_group_share_details(self):
        """
        Only call this if :meth:`is_shmodel_group_share_details` is true.

        :rtype: ShmodelGroupShareDetails
        """
        if not self.is_shmodel_group_share_details():
            raise AttributeError("tag 'shmodel_group_share_details' not set")
        return self._value

    def get_showcase_access_granted_details(self):
        """
        Only call this if :meth:`is_showcase_access_granted_details` is true.

        :rtype: ShowcaseAccessGrantedDetails
        """
        if not self.is_showcase_access_granted_details():
            raise AttributeError("tag 'showcase_access_granted_details' not set")
        return self._value

    def get_showcase_add_member_details(self):
        """
        Only call this if :meth:`is_showcase_add_member_details` is true.

        :rtype: ShowcaseAddMemberDetails
        """
        if not self.is_showcase_add_member_details():
            raise AttributeError("tag 'showcase_add_member_details' not set")
        return self._value

    def get_showcase_archived_details(self):
        """
        Only call this if :meth:`is_showcase_archived_details` is true.

        :rtype: ShowcaseArchivedDetails
        """
        if not self.is_showcase_archived_details():
            raise AttributeError("tag 'showcase_archived_details' not set")
        return self._value

    def get_showcase_created_details(self):
        """
        Only call this if :meth:`is_showcase_created_details` is true.

        :rtype: ShowcaseCreatedDetails
        """
        if not self.is_showcase_created_details():
            raise AttributeError("tag 'showcase_created_details' not set")
        return self._value

    def get_showcase_delete_comment_details(self):
        """
        Only call this if :meth:`is_showcase_delete_comment_details` is true.

        :rtype: ShowcaseDeleteCommentDetails
        """
        if not self.is_showcase_delete_comment_details():
            raise AttributeError("tag 'showcase_delete_comment_details' not set")
        return self._value

    def get_showcase_edited_details(self):
        """
        Only call this if :meth:`is_showcase_edited_details` is true.

        :rtype: ShowcaseEditedDetails
        """
        if not self.is_showcase_edited_details():
            raise AttributeError("tag 'showcase_edited_details' not set")
        return self._value

    def get_showcase_edit_comment_details(self):
        """
        Only call this if :meth:`is_showcase_edit_comment_details` is true.

        :rtype: ShowcaseEditCommentDetails
        """
        if not self.is_showcase_edit_comment_details():
            raise AttributeError("tag 'showcase_edit_comment_details' not set")
        return self._value

    def get_showcase_file_added_details(self):
        """
        Only call this if :meth:`is_showcase_file_added_details` is true.

        :rtype: ShowcaseFileAddedDetails
        """
        if not self.is_showcase_file_added_details():
            raise AttributeError("tag 'showcase_file_added_details' not set")
        return self._value

    def get_showcase_file_download_details(self):
        """
        Only call this if :meth:`is_showcase_file_download_details` is true.

        :rtype: ShowcaseFileDownloadDetails
        """
        if not self.is_showcase_file_download_details():
            raise AttributeError("tag 'showcase_file_download_details' not set")
        return self._value

    def get_showcase_file_removed_details(self):
        """
        Only call this if :meth:`is_showcase_file_removed_details` is true.

        :rtype: ShowcaseFileRemovedDetails
        """
        if not self.is_showcase_file_removed_details():
            raise AttributeError("tag 'showcase_file_removed_details' not set")
        return self._value

    def get_showcase_file_view_details(self):
        """
        Only call this if :meth:`is_showcase_file_view_details` is true.

        :rtype: ShowcaseFileViewDetails
        """
        if not self.is_showcase_file_view_details():
            raise AttributeError("tag 'showcase_file_view_details' not set")
        return self._value

    def get_showcase_permanently_deleted_details(self):
        """
        Only call this if :meth:`is_showcase_permanently_deleted_details` is true.

        :rtype: ShowcasePermanentlyDeletedDetails
        """
        if not self.is_showcase_permanently_deleted_details():
            raise AttributeError("tag 'showcase_permanently_deleted_details' not set")
        return self._value

    def get_showcase_post_comment_details(self):
        """
        Only call this if :meth:`is_showcase_post_comment_details` is true.

        :rtype: ShowcasePostCommentDetails
        """
        if not self.is_showcase_post_comment_details():
            raise AttributeError("tag 'showcase_post_comment_details' not set")
        return self._value

    def get_showcase_remove_member_details(self):
        """
        Only call this if :meth:`is_showcase_remove_member_details` is true.

        :rtype: ShowcaseRemoveMemberDetails
        """
        if not self.is_showcase_remove_member_details():
            raise AttributeError("tag 'showcase_remove_member_details' not set")
        return self._value

    def get_showcase_renamed_details(self):
        """
        Only call this if :meth:`is_showcase_renamed_details` is true.

        :rtype: ShowcaseRenamedDetails
        """
        if not self.is_showcase_renamed_details():
            raise AttributeError("tag 'showcase_renamed_details' not set")
        return self._value

    def get_showcase_request_access_details(self):
        """
        Only call this if :meth:`is_showcase_request_access_details` is true.

        :rtype: ShowcaseRequestAccessDetails
        """
        if not self.is_showcase_request_access_details():
            raise AttributeError("tag 'showcase_request_access_details' not set")
        return self._value

    def get_showcase_resolve_comment_details(self):
        """
        Only call this if :meth:`is_showcase_resolve_comment_details` is true.

        :rtype: ShowcaseResolveCommentDetails
        """
        if not self.is_showcase_resolve_comment_details():
            raise AttributeError("tag 'showcase_resolve_comment_details' not set")
        return self._value

    def get_showcase_restored_details(self):
        """
        Only call this if :meth:`is_showcase_restored_details` is true.

        :rtype: ShowcaseRestoredDetails
        """
        if not self.is_showcase_restored_details():
            raise AttributeError("tag 'showcase_restored_details' not set")
        return self._value

    def get_showcase_trashed_details(self):
        """
        Only call this if :meth:`is_showcase_trashed_details` is true.

        :rtype: ShowcaseTrashedDetails
        """
        if not self.is_showcase_trashed_details():
            raise AttributeError("tag 'showcase_trashed_details' not set")
        return self._value

    def get_showcase_trashed_deprecated_details(self):
        """
        Only call this if :meth:`is_showcase_trashed_deprecated_details` is true.

        :rtype: ShowcaseTrashedDeprecatedDetails
        """
        if not self.is_showcase_trashed_deprecated_details():
            raise AttributeError("tag 'showcase_trashed_deprecated_details' not set")
        return self._value

    def get_showcase_unresolve_comment_details(self):
        """
        Only call this if :meth:`is_showcase_unresolve_comment_details` is true.

        :rtype: ShowcaseUnresolveCommentDetails
        """
        if not self.is_showcase_unresolve_comment_details():
            raise AttributeError("tag 'showcase_unresolve_comment_details' not set")
        return self._value

    def get_showcase_untrashed_details(self):
        """
        Only call this if :meth:`is_showcase_untrashed_details` is true.

        :rtype: ShowcaseUntrashedDetails
        """
        if not self.is_showcase_untrashed_details():
            raise AttributeError("tag 'showcase_untrashed_details' not set")
        return self._value

    def get_showcase_untrashed_deprecated_details(self):
        """
        Only call this if :meth:`is_showcase_untrashed_deprecated_details` is true.

        :rtype: ShowcaseUntrashedDeprecatedDetails
        """
        if not self.is_showcase_untrashed_deprecated_details():
            raise AttributeError("tag 'showcase_untrashed_deprecated_details' not set")
        return self._value

    def get_showcase_view_details(self):
        """
        Only call this if :meth:`is_showcase_view_details` is true.

        :rtype: ShowcaseViewDetails
        """
        if not self.is_showcase_view_details():
            raise AttributeError("tag 'showcase_view_details' not set")
        return self._value

    def get_sso_add_cert_details(self):
        """
        Only call this if :meth:`is_sso_add_cert_details` is true.

        :rtype: SsoAddCertDetails
        """
        if not self.is_sso_add_cert_details():
            raise AttributeError("tag 'sso_add_cert_details' not set")
        return self._value

    def get_sso_add_login_url_details(self):
        """
        Only call this if :meth:`is_sso_add_login_url_details` is true.

        :rtype: SsoAddLoginUrlDetails
        """
        if not self.is_sso_add_login_url_details():
            raise AttributeError("tag 'sso_add_login_url_details' not set")
        return self._value

    def get_sso_add_logout_url_details(self):
        """
        Only call this if :meth:`is_sso_add_logout_url_details` is true.

        :rtype: SsoAddLogoutUrlDetails
        """
        if not self.is_sso_add_logout_url_details():
            raise AttributeError("tag 'sso_add_logout_url_details' not set")
        return self._value

    def get_sso_change_cert_details(self):
        """
        Only call this if :meth:`is_sso_change_cert_details` is true.

        :rtype: SsoChangeCertDetails
        """
        if not self.is_sso_change_cert_details():
            raise AttributeError("tag 'sso_change_cert_details' not set")
        return self._value

    def get_sso_change_login_url_details(self):
        """
        Only call this if :meth:`is_sso_change_login_url_details` is true.

        :rtype: SsoChangeLoginUrlDetails
        """
        if not self.is_sso_change_login_url_details():
            raise AttributeError("tag 'sso_change_login_url_details' not set")
        return self._value

    def get_sso_change_logout_url_details(self):
        """
        Only call this if :meth:`is_sso_change_logout_url_details` is true.

        :rtype: SsoChangeLogoutUrlDetails
        """
        if not self.is_sso_change_logout_url_details():
            raise AttributeError("tag 'sso_change_logout_url_details' not set")
        return self._value

    def get_sso_change_saml_identity_mode_details(self):
        """
        Only call this if :meth:`is_sso_change_saml_identity_mode_details` is true.

        :rtype: SsoChangeSamlIdentityModeDetails
        """
        if not self.is_sso_change_saml_identity_mode_details():
            raise AttributeError("tag 'sso_change_saml_identity_mode_details' not set")
        return self._value

    def get_sso_remove_cert_details(self):
        """
        Only call this if :meth:`is_sso_remove_cert_details` is true.

        :rtype: SsoRemoveCertDetails
        """
        if not self.is_sso_remove_cert_details():
            raise AttributeError("tag 'sso_remove_cert_details' not set")
        return self._value

    def get_sso_remove_login_url_details(self):
        """
        Only call this if :meth:`is_sso_remove_login_url_details` is true.

        :rtype: SsoRemoveLoginUrlDetails
        """
        if not self.is_sso_remove_login_url_details():
            raise AttributeError("tag 'sso_remove_login_url_details' not set")
        return self._value

    def get_sso_remove_logout_url_details(self):
        """
        Only call this if :meth:`is_sso_remove_logout_url_details` is true.

        :rtype: SsoRemoveLogoutUrlDetails
        """
        if not self.is_sso_remove_logout_url_details():
            raise AttributeError("tag 'sso_remove_logout_url_details' not set")
        return self._value

    def get_team_folder_change_status_details(self):
        """
        Only call this if :meth:`is_team_folder_change_status_details` is true.

        :rtype: TeamFolderChangeStatusDetails
        """
        if not self.is_team_folder_change_status_details():
            raise AttributeError("tag 'team_folder_change_status_details' not set")
        return self._value

    def get_team_folder_create_details(self):
        """
        Only call this if :meth:`is_team_folder_create_details` is true.

        :rtype: TeamFolderCreateDetails
        """
        if not self.is_team_folder_create_details():
            raise AttributeError("tag 'team_folder_create_details' not set")
        return self._value

    def get_team_folder_downgrade_details(self):
        """
        Only call this if :meth:`is_team_folder_downgrade_details` is true.

        :rtype: TeamFolderDowngradeDetails
        """
        if not self.is_team_folder_downgrade_details():
            raise AttributeError("tag 'team_folder_downgrade_details' not set")
        return self._value

    def get_team_folder_permanently_delete_details(self):
        """
        Only call this if :meth:`is_team_folder_permanently_delete_details` is true.

        :rtype: TeamFolderPermanentlyDeleteDetails
        """
        if not self.is_team_folder_permanently_delete_details():
            raise AttributeError("tag 'team_folder_permanently_delete_details' not set")
        return self._value

    def get_team_folder_rename_details(self):
        """
        Only call this if :meth:`is_team_folder_rename_details` is true.

        :rtype: TeamFolderRenameDetails
        """
        if not self.is_team_folder_rename_details():
            raise AttributeError("tag 'team_folder_rename_details' not set")
        return self._value

    def get_team_selective_sync_settings_changed_details(self):
        """
        Only call this if :meth:`is_team_selective_sync_settings_changed_details` is true.

        :rtype: TeamSelectiveSyncSettingsChangedDetails
        """
        if not self.is_team_selective_sync_settings_changed_details():
            raise AttributeError("tag 'team_selective_sync_settings_changed_details' not set")
        return self._value

    def get_account_capture_change_policy_details(self):
        """
        Only call this if :meth:`is_account_capture_change_policy_details` is true.

        :rtype: AccountCaptureChangePolicyDetails
        """
        if not self.is_account_capture_change_policy_details():
            raise AttributeError("tag 'account_capture_change_policy_details' not set")
        return self._value

    def get_allow_download_disabled_details(self):
        """
        Only call this if :meth:`is_allow_download_disabled_details` is true.

        :rtype: AllowDownloadDisabledDetails
        """
        if not self.is_allow_download_disabled_details():
            raise AttributeError("tag 'allow_download_disabled_details' not set")
        return self._value

    def get_allow_download_enabled_details(self):
        """
        Only call this if :meth:`is_allow_download_enabled_details` is true.

        :rtype: AllowDownloadEnabledDetails
        """
        if not self.is_allow_download_enabled_details():
            raise AttributeError("tag 'allow_download_enabled_details' not set")
        return self._value

    def get_data_placement_restriction_change_policy_details(self):
        """
        Only call this if :meth:`is_data_placement_restriction_change_policy_details` is true.

        :rtype: DataPlacementRestrictionChangePolicyDetails
        """
        if not self.is_data_placement_restriction_change_policy_details():
            raise AttributeError("tag 'data_placement_restriction_change_policy_details' not set")
        return self._value

    def get_data_placement_restriction_satisfy_policy_details(self):
        """
        Only call this if :meth:`is_data_placement_restriction_satisfy_policy_details` is true.

        :rtype: DataPlacementRestrictionSatisfyPolicyDetails
        """
        if not self.is_data_placement_restriction_satisfy_policy_details():
            raise AttributeError("tag 'data_placement_restriction_satisfy_policy_details' not set")
        return self._value

    def get_device_approvals_change_desktop_policy_details(self):
        """
        Only call this if :meth:`is_device_approvals_change_desktop_policy_details` is true.

        :rtype: DeviceApprovalsChangeDesktopPolicyDetails
        """
        if not self.is_device_approvals_change_desktop_policy_details():
            raise AttributeError("tag 'device_approvals_change_desktop_policy_details' not set")
        return self._value

    def get_device_approvals_change_mobile_policy_details(self):
        """
        Only call this if :meth:`is_device_approvals_change_mobile_policy_details` is true.

        :rtype: DeviceApprovalsChangeMobilePolicyDetails
        """
        if not self.is_device_approvals_change_mobile_policy_details():
            raise AttributeError("tag 'device_approvals_change_mobile_policy_details' not set")
        return self._value

    def get_device_approvals_change_overage_action_details(self):
        """
        Only call this if :meth:`is_device_approvals_change_overage_action_details` is true.

        :rtype: DeviceApprovalsChangeOverageActionDetails
        """
        if not self.is_device_approvals_change_overage_action_details():
            raise AttributeError("tag 'device_approvals_change_overage_action_details' not set")
        return self._value

    def get_device_approvals_change_unlink_action_details(self):
        """
        Only call this if :meth:`is_device_approvals_change_unlink_action_details` is true.

        :rtype: DeviceApprovalsChangeUnlinkActionDetails
        """
        if not self.is_device_approvals_change_unlink_action_details():
            raise AttributeError("tag 'device_approvals_change_unlink_action_details' not set")
        return self._value

    def get_directory_restrictions_add_members_details(self):
        """
        Only call this if :meth:`is_directory_restrictions_add_members_details` is true.

        :rtype: DirectoryRestrictionsAddMembersDetails
        """
        if not self.is_directory_restrictions_add_members_details():
            raise AttributeError("tag 'directory_restrictions_add_members_details' not set")
        return self._value

    def get_directory_restrictions_remove_members_details(self):
        """
        Only call this if :meth:`is_directory_restrictions_remove_members_details` is true.

        :rtype: DirectoryRestrictionsRemoveMembersDetails
        """
        if not self.is_directory_restrictions_remove_members_details():
            raise AttributeError("tag 'directory_restrictions_remove_members_details' not set")
        return self._value

    def get_emm_add_exception_details(self):
        """
        Only call this if :meth:`is_emm_add_exception_details` is true.

        :rtype: EmmAddExceptionDetails
        """
        if not self.is_emm_add_exception_details():
            raise AttributeError("tag 'emm_add_exception_details' not set")
        return self._value

    def get_emm_change_policy_details(self):
        """
        Only call this if :meth:`is_emm_change_policy_details` is true.

        :rtype: EmmChangePolicyDetails
        """
        if not self.is_emm_change_policy_details():
            raise AttributeError("tag 'emm_change_policy_details' not set")
        return self._value

    def get_emm_remove_exception_details(self):
        """
        Only call this if :meth:`is_emm_remove_exception_details` is true.

        :rtype: EmmRemoveExceptionDetails
        """
        if not self.is_emm_remove_exception_details():
            raise AttributeError("tag 'emm_remove_exception_details' not set")
        return self._value

    def get_extended_version_history_change_policy_details(self):
        """
        Only call this if :meth:`is_extended_version_history_change_policy_details` is true.

        :rtype: ExtendedVersionHistoryChangePolicyDetails
        """
        if not self.is_extended_version_history_change_policy_details():
            raise AttributeError("tag 'extended_version_history_change_policy_details' not set")
        return self._value

    def get_file_comments_change_policy_details(self):
        """
        Only call this if :meth:`is_file_comments_change_policy_details` is true.

        :rtype: FileCommentsChangePolicyDetails
        """
        if not self.is_file_comments_change_policy_details():
            raise AttributeError("tag 'file_comments_change_policy_details' not set")
        return self._value

    def get_file_requests_change_policy_details(self):
        """
        Only call this if :meth:`is_file_requests_change_policy_details` is true.

        :rtype: FileRequestsChangePolicyDetails
        """
        if not self.is_file_requests_change_policy_details():
            raise AttributeError("tag 'file_requests_change_policy_details' not set")
        return self._value

    def get_file_requests_emails_enabled_details(self):
        """
        Only call this if :meth:`is_file_requests_emails_enabled_details` is true.

        :rtype: FileRequestsEmailsEnabledDetails
        """
        if not self.is_file_requests_emails_enabled_details():
            raise AttributeError("tag 'file_requests_emails_enabled_details' not set")
        return self._value

    def get_file_requests_emails_restricted_to_team_only_details(self):
        """
        Only call this if :meth:`is_file_requests_emails_restricted_to_team_only_details` is true.

        :rtype: FileRequestsEmailsRestrictedToTeamOnlyDetails
        """
        if not self.is_file_requests_emails_restricted_to_team_only_details():
            raise AttributeError("tag 'file_requests_emails_restricted_to_team_only_details' not set")
        return self._value

    def get_google_sso_change_policy_details(self):
        """
        Only call this if :meth:`is_google_sso_change_policy_details` is true.

        :rtype: GoogleSsoChangePolicyDetails
        """
        if not self.is_google_sso_change_policy_details():
            raise AttributeError("tag 'google_sso_change_policy_details' not set")
        return self._value

    def get_group_user_management_change_policy_details(self):
        """
        Only call this if :meth:`is_group_user_management_change_policy_details` is true.

        :rtype: GroupUserManagementChangePolicyDetails
        """
        if not self.is_group_user_management_change_policy_details():
            raise AttributeError("tag 'group_user_management_change_policy_details' not set")
        return self._value

    def get_member_requests_change_policy_details(self):
        """
        Only call this if :meth:`is_member_requests_change_policy_details` is true.

        :rtype: MemberRequestsChangePolicyDetails
        """
        if not self.is_member_requests_change_policy_details():
            raise AttributeError("tag 'member_requests_change_policy_details' not set")
        return self._value

    def get_member_space_limits_add_exception_details(self):
        """
        Only call this if :meth:`is_member_space_limits_add_exception_details` is true.

        :rtype: MemberSpaceLimitsAddExceptionDetails
        """
        if not self.is_member_space_limits_add_exception_details():
            raise AttributeError("tag 'member_space_limits_add_exception_details' not set")
        return self._value

    def get_member_space_limits_change_caps_type_policy_details(self):
        """
        Only call this if :meth:`is_member_space_limits_change_caps_type_policy_details` is true.

        :rtype: MemberSpaceLimitsChangeCapsTypePolicyDetails
        """
        if not self.is_member_space_limits_change_caps_type_policy_details():
            raise AttributeError("tag 'member_space_limits_change_caps_type_policy_details' not set")
        return self._value

    def get_member_space_limits_change_policy_details(self):
        """
        Only call this if :meth:`is_member_space_limits_change_policy_details` is true.

        :rtype: MemberSpaceLimitsChangePolicyDetails
        """
        if not self.is_member_space_limits_change_policy_details():
            raise AttributeError("tag 'member_space_limits_change_policy_details' not set")
        return self._value

    def get_member_space_limits_remove_exception_details(self):
        """
        Only call this if :meth:`is_member_space_limits_remove_exception_details` is true.

        :rtype: MemberSpaceLimitsRemoveExceptionDetails
        """
        if not self.is_member_space_limits_remove_exception_details():
            raise AttributeError("tag 'member_space_limits_remove_exception_details' not set")
        return self._value

    def get_member_suggestions_change_policy_details(self):
        """
        Only call this if :meth:`is_member_suggestions_change_policy_details` is true.

        :rtype: MemberSuggestionsChangePolicyDetails
        """
        if not self.is_member_suggestions_change_policy_details():
            raise AttributeError("tag 'member_suggestions_change_policy_details' not set")
        return self._value

    def get_microsoft_office_addin_change_policy_details(self):
        """
        Only call this if :meth:`is_microsoft_office_addin_change_policy_details` is true.

        :rtype: MicrosoftOfficeAddinChangePolicyDetails
        """
        if not self.is_microsoft_office_addin_change_policy_details():
            raise AttributeError("tag 'microsoft_office_addin_change_policy_details' not set")
        return self._value

    def get_network_control_change_policy_details(self):
        """
        Only call this if :meth:`is_network_control_change_policy_details` is true.

        :rtype: NetworkControlChangePolicyDetails
        """
        if not self.is_network_control_change_policy_details():
            raise AttributeError("tag 'network_control_change_policy_details' not set")
        return self._value

    def get_paper_change_deployment_policy_details(self):
        """
        Only call this if :meth:`is_paper_change_deployment_policy_details` is true.

        :rtype: PaperChangeDeploymentPolicyDetails
        """
        if not self.is_paper_change_deployment_policy_details():
            raise AttributeError("tag 'paper_change_deployment_policy_details' not set")
        return self._value

    def get_paper_change_member_link_policy_details(self):
        """
        Only call this if :meth:`is_paper_change_member_link_policy_details` is true.

        :rtype: PaperChangeMemberLinkPolicyDetails
        """
        if not self.is_paper_change_member_link_policy_details():
            raise AttributeError("tag 'paper_change_member_link_policy_details' not set")
        return self._value

    def get_paper_change_member_policy_details(self):
        """
        Only call this if :meth:`is_paper_change_member_policy_details` is true.

        :rtype: PaperChangeMemberPolicyDetails
        """
        if not self.is_paper_change_member_policy_details():
            raise AttributeError("tag 'paper_change_member_policy_details' not set")
        return self._value

    def get_paper_change_policy_details(self):
        """
        Only call this if :meth:`is_paper_change_policy_details` is true.

        :rtype: PaperChangePolicyDetails
        """
        if not self.is_paper_change_policy_details():
            raise AttributeError("tag 'paper_change_policy_details' not set")
        return self._value

    def get_paper_enabled_users_group_addition_details(self):
        """
        Only call this if :meth:`is_paper_enabled_users_group_addition_details` is true.

        :rtype: PaperEnabledUsersGroupAdditionDetails
        """
        if not self.is_paper_enabled_users_group_addition_details():
            raise AttributeError("tag 'paper_enabled_users_group_addition_details' not set")
        return self._value

    def get_paper_enabled_users_group_removal_details(self):
        """
        Only call this if :meth:`is_paper_enabled_users_group_removal_details` is true.

        :rtype: PaperEnabledUsersGroupRemovalDetails
        """
        if not self.is_paper_enabled_users_group_removal_details():
            raise AttributeError("tag 'paper_enabled_users_group_removal_details' not set")
        return self._value

    def get_permanent_delete_change_policy_details(self):
        """
        Only call this if :meth:`is_permanent_delete_change_policy_details` is true.

        :rtype: PermanentDeleteChangePolicyDetails
        """
        if not self.is_permanent_delete_change_policy_details():
            raise AttributeError("tag 'permanent_delete_change_policy_details' not set")
        return self._value

    def get_sharing_change_folder_join_policy_details(self):
        """
        Only call this if :meth:`is_sharing_change_folder_join_policy_details` is true.

        :rtype: SharingChangeFolderJoinPolicyDetails
        """
        if not self.is_sharing_change_folder_join_policy_details():
            raise AttributeError("tag 'sharing_change_folder_join_policy_details' not set")
        return self._value

    def get_sharing_change_link_policy_details(self):
        """
        Only call this if :meth:`is_sharing_change_link_policy_details` is true.

        :rtype: SharingChangeLinkPolicyDetails
        """
        if not self.is_sharing_change_link_policy_details():
            raise AttributeError("tag 'sharing_change_link_policy_details' not set")
        return self._value

    def get_sharing_change_member_policy_details(self):
        """
        Only call this if :meth:`is_sharing_change_member_policy_details` is true.

        :rtype: SharingChangeMemberPolicyDetails
        """
        if not self.is_sharing_change_member_policy_details():
            raise AttributeError("tag 'sharing_change_member_policy_details' not set")
        return self._value

    def get_showcase_change_download_policy_details(self):
        """
        Only call this if :meth:`is_showcase_change_download_policy_details` is true.

        :rtype: ShowcaseChangeDownloadPolicyDetails
        """
        if not self.is_showcase_change_download_policy_details():
            raise AttributeError("tag 'showcase_change_download_policy_details' not set")
        return self._value

    def get_showcase_change_enabled_policy_details(self):
        """
        Only call this if :meth:`is_showcase_change_enabled_policy_details` is true.

        :rtype: ShowcaseChangeEnabledPolicyDetails
        """
        if not self.is_showcase_change_enabled_policy_details():
            raise AttributeError("tag 'showcase_change_enabled_policy_details' not set")
        return self._value

    def get_showcase_change_external_sharing_policy_details(self):
        """
        Only call this if :meth:`is_showcase_change_external_sharing_policy_details` is true.

        :rtype: ShowcaseChangeExternalSharingPolicyDetails
        """
        if not self.is_showcase_change_external_sharing_policy_details():
            raise AttributeError("tag 'showcase_change_external_sharing_policy_details' not set")
        return self._value

    def get_smart_sync_change_policy_details(self):
        """
        Only call this if :meth:`is_smart_sync_change_policy_details` is true.

        :rtype: SmartSyncChangePolicyDetails
        """
        if not self.is_smart_sync_change_policy_details():
            raise AttributeError("tag 'smart_sync_change_policy_details' not set")
        return self._value

    def get_smart_sync_not_opt_out_details(self):
        """
        Only call this if :meth:`is_smart_sync_not_opt_out_details` is true.

        :rtype: SmartSyncNotOptOutDetails
        """
        if not self.is_smart_sync_not_opt_out_details():
            raise AttributeError("tag 'smart_sync_not_opt_out_details' not set")
        return self._value

    def get_smart_sync_opt_out_details(self):
        """
        Only call this if :meth:`is_smart_sync_opt_out_details` is true.

        :rtype: SmartSyncOptOutDetails
        """
        if not self.is_smart_sync_opt_out_details():
            raise AttributeError("tag 'smart_sync_opt_out_details' not set")
        return self._value

    def get_sso_change_policy_details(self):
        """
        Only call this if :meth:`is_sso_change_policy_details` is true.

        :rtype: SsoChangePolicyDetails
        """
        if not self.is_sso_change_policy_details():
            raise AttributeError("tag 'sso_change_policy_details' not set")
        return self._value

    def get_team_selective_sync_policy_changed_details(self):
        """
        Only call this if :meth:`is_team_selective_sync_policy_changed_details` is true.

        :rtype: TeamSelectiveSyncPolicyChangedDetails
        """
        if not self.is_team_selective_sync_policy_changed_details():
            raise AttributeError("tag 'team_selective_sync_policy_changed_details' not set")
        return self._value

    def get_tfa_change_policy_details(self):
        """
        Only call this if :meth:`is_tfa_change_policy_details` is true.

        :rtype: TfaChangePolicyDetails
        """
        if not self.is_tfa_change_policy_details():
            raise AttributeError("tag 'tfa_change_policy_details' not set")
        return self._value

    def get_two_account_change_policy_details(self):
        """
        Only call this if :meth:`is_two_account_change_policy_details` is true.

        :rtype: TwoAccountChangePolicyDetails
        """
        if not self.is_two_account_change_policy_details():
            raise AttributeError("tag 'two_account_change_policy_details' not set")
        return self._value

    def get_viewer_info_policy_changed_details(self):
        """
        Only call this if :meth:`is_viewer_info_policy_changed_details` is true.

        :rtype: ViewerInfoPolicyChangedDetails
        """
        if not self.is_viewer_info_policy_changed_details():
            raise AttributeError("tag 'viewer_info_policy_changed_details' not set")
        return self._value

    def get_web_sessions_change_fixed_length_policy_details(self):
        """
        Only call this if :meth:`is_web_sessions_change_fixed_length_policy_details` is true.

        :rtype: WebSessionsChangeFixedLengthPolicyDetails
        """
        if not self.is_web_sessions_change_fixed_length_policy_details():
            raise AttributeError("tag 'web_sessions_change_fixed_length_policy_details' not set")
        return self._value

    def get_web_sessions_change_idle_length_policy_details(self):
        """
        Only call this if :meth:`is_web_sessions_change_idle_length_policy_details` is true.

        :rtype: WebSessionsChangeIdleLengthPolicyDetails
        """
        if not self.is_web_sessions_change_idle_length_policy_details():
            raise AttributeError("tag 'web_sessions_change_idle_length_policy_details' not set")
        return self._value

    def get_team_merge_from_details(self):
        """
        Only call this if :meth:`is_team_merge_from_details` is true.

        :rtype: TeamMergeFromDetails
        """
        if not self.is_team_merge_from_details():
            raise AttributeError("tag 'team_merge_from_details' not set")
        return self._value

    def get_team_merge_to_details(self):
        """
        Only call this if :meth:`is_team_merge_to_details` is true.

        :rtype: TeamMergeToDetails
        """
        if not self.is_team_merge_to_details():
            raise AttributeError("tag 'team_merge_to_details' not set")
        return self._value

    def get_team_profile_add_logo_details(self):
        """
        Only call this if :meth:`is_team_profile_add_logo_details` is true.

        :rtype: TeamProfileAddLogoDetails
        """
        if not self.is_team_profile_add_logo_details():
            raise AttributeError("tag 'team_profile_add_logo_details' not set")
        return self._value

    def get_team_profile_change_default_language_details(self):
        """
        Only call this if :meth:`is_team_profile_change_default_language_details` is true.

        :rtype: TeamProfileChangeDefaultLanguageDetails
        """
        if not self.is_team_profile_change_default_language_details():
            raise AttributeError("tag 'team_profile_change_default_language_details' not set")
        return self._value

    def get_team_profile_change_logo_details(self):
        """
        Only call this if :meth:`is_team_profile_change_logo_details` is true.

        :rtype: TeamProfileChangeLogoDetails
        """
        if not self.is_team_profile_change_logo_details():
            raise AttributeError("tag 'team_profile_change_logo_details' not set")
        return self._value

    def get_team_profile_change_name_details(self):
        """
        Only call this if :meth:`is_team_profile_change_name_details` is true.

        :rtype: TeamProfileChangeNameDetails
        """
        if not self.is_team_profile_change_name_details():
            raise AttributeError("tag 'team_profile_change_name_details' not set")
        return self._value

    def get_team_profile_remove_logo_details(self):
        """
        Only call this if :meth:`is_team_profile_remove_logo_details` is true.

        :rtype: TeamProfileRemoveLogoDetails
        """
        if not self.is_team_profile_remove_logo_details():
            raise AttributeError("tag 'team_profile_remove_logo_details' not set")
        return self._value

    def get_tfa_add_backup_phone_details(self):
        """
        Only call this if :meth:`is_tfa_add_backup_phone_details` is true.

        :rtype: TfaAddBackupPhoneDetails
        """
        if not self.is_tfa_add_backup_phone_details():
            raise AttributeError("tag 'tfa_add_backup_phone_details' not set")
        return self._value

    def get_tfa_add_security_key_details(self):
        """
        Only call this if :meth:`is_tfa_add_security_key_details` is true.

        :rtype: TfaAddSecurityKeyDetails
        """
        if not self.is_tfa_add_security_key_details():
            raise AttributeError("tag 'tfa_add_security_key_details' not set")
        return self._value

    def get_tfa_change_backup_phone_details(self):
        """
        Only call this if :meth:`is_tfa_change_backup_phone_details` is true.

        :rtype: TfaChangeBackupPhoneDetails
        """
        if not self.is_tfa_change_backup_phone_details():
            raise AttributeError("tag 'tfa_change_backup_phone_details' not set")
        return self._value

    def get_tfa_change_status_details(self):
        """
        Only call this if :meth:`is_tfa_change_status_details` is true.

        :rtype: TfaChangeStatusDetails
        """
        if not self.is_tfa_change_status_details():
            raise AttributeError("tag 'tfa_change_status_details' not set")
        return self._value

    def get_tfa_remove_backup_phone_details(self):
        """
        Only call this if :meth:`is_tfa_remove_backup_phone_details` is true.

        :rtype: TfaRemoveBackupPhoneDetails
        """
        if not self.is_tfa_remove_backup_phone_details():
            raise AttributeError("tag 'tfa_remove_backup_phone_details' not set")
        return self._value

    def get_tfa_remove_security_key_details(self):
        """
        Only call this if :meth:`is_tfa_remove_security_key_details` is true.

        :rtype: TfaRemoveSecurityKeyDetails
        """
        if not self.is_tfa_remove_security_key_details():
            raise AttributeError("tag 'tfa_remove_security_key_details' not set")
        return self._value

    def get_tfa_reset_details(self):
        """
        Only call this if :meth:`is_tfa_reset_details` is true.

        :rtype: TfaResetDetails
        """
        if not self.is_tfa_reset_details():
            raise AttributeError("tag 'tfa_reset_details' not set")
        return self._value

    def get_missing_details(self):
        """
        Hints that this event was returned with missing details due to an
        internal error.

        Only call this if :meth:`is_missing_details` is true.

        :rtype: MissingDetails
        """
        if not self.is_missing_details():
            raise AttributeError("tag 'missing_details' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, processor):
        super(EventDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EventDetails(%r, %r)' % (self._tag, self._value)

EventDetails_validator = bv.Union(EventDetails)

class EventType(bb.Union):
    """
    The type of the event.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar AppLinkTeamType app_link_team: (apps) Linked app for team
    :ivar AppLinkUserType app_link_user: (apps) Linked app for member
    :ivar AppUnlinkTeamType app_unlink_team: (apps) Unlinked app for team
    :ivar AppUnlinkUserType app_unlink_user: (apps) Unlinked app for member
    :ivar FileAddCommentType file_add_comment: (comments) Added file comment
    :ivar FileChangeCommentSubscriptionType file_change_comment_subscription:
        (comments) Subscribed to or unsubscribed from comment notifications for
        file
    :ivar FileDeleteCommentType file_delete_comment: (comments) Deleted file
        comment
    :ivar FileLikeCommentType file_like_comment: (comments) Liked file comment
        (deprecated, no longer logged)
    :ivar FileResolveCommentType file_resolve_comment: (comments) Resolved file
        comment
    :ivar FileUnlikeCommentType file_unlike_comment: (comments) Unliked file
        comment (deprecated, no longer logged)
    :ivar FileUnresolveCommentType file_unresolve_comment: (comments) Unresolved
        file comment
    :ivar DeviceChangeIpDesktopType device_change_ip_desktop: (devices) Changed
        IP address associated with active desktop session
    :ivar DeviceChangeIpMobileType device_change_ip_mobile: (devices) Changed IP
        address associated with active mobile session
    :ivar DeviceChangeIpWebType device_change_ip_web: (devices) Changed IP
        address associated with active web session
    :ivar DeviceDeleteOnUnlinkFailType device_delete_on_unlink_fail: (devices)
        Failed to delete all files from unlinked device
    :ivar DeviceDeleteOnUnlinkSuccessType device_delete_on_unlink_success:
        (devices) Deleted all files from unlinked device
    :ivar DeviceLinkFailType device_link_fail: (devices) Failed to link device
    :ivar DeviceLinkSuccessType device_link_success: (devices) Linked device
    :ivar DeviceManagementDisabledType device_management_disabled: (devices)
        Disabled device management (deprecated, no longer logged)
    :ivar DeviceManagementEnabledType device_management_enabled: (devices)
        Enabled device management (deprecated, no longer logged)
    :ivar DeviceUnlinkType device_unlink: (devices) Disconnected device
    :ivar EmmRefreshAuthTokenType emm_refresh_auth_token: (devices) Refreshed
        auth token used for setting up enterprise mobility management
    :ivar AccountCaptureChangeAvailabilityType
        account_capture_change_availability: (domains) Granted/revoked option to
        enable account capture on team domains
    :ivar AccountCaptureMigrateAccountType account_capture_migrate_account:
        (domains) Account-captured user migrated account to team
    :ivar AccountCaptureNotificationEmailsSentType
        account_capture_notification_emails_sent: (domains) Sent proactive
        account capture email to all unmanaged members
    :ivar AccountCaptureRelinquishAccountType
        account_capture_relinquish_account: (domains) Account-captured user
        changed account email to personal email
    :ivar DisabledDomainInvitesType disabled_domain_invites: (domains) Disabled
        domain invites (deprecated, no longer logged)
    :ivar DomainInvitesApproveRequestToJoinTeamType
        domain_invites_approve_request_to_join_team: (domains) Approved user's
        request to join team
    :ivar DomainInvitesDeclineRequestToJoinTeamType
        domain_invites_decline_request_to_join_team: (domains) Declined user's
        request to join team
    :ivar DomainInvitesEmailExistingUsersType
        domain_invites_email_existing_users: (domains) Sent domain invites to
        existing domain accounts (deprecated, no longer logged)
    :ivar DomainInvitesRequestToJoinTeamType
        domain_invites_request_to_join_team: (domains) Requested to join team
    :ivar DomainInvitesSetInviteNewUserPrefToNoType
        domain_invites_set_invite_new_user_pref_to_no: (domains) Disabled
        "Automatically invite new users" (deprecated, no longer logged)
    :ivar DomainInvitesSetInviteNewUserPrefToYesType
        domain_invites_set_invite_new_user_pref_to_yes: (domains) Enabled
        "Automatically invite new users" (deprecated, no longer logged)
    :ivar DomainVerificationAddDomainFailType
        domain_verification_add_domain_fail: (domains) Failed to verify team
        domain
    :ivar DomainVerificationAddDomainSuccessType
        domain_verification_add_domain_success: (domains) Verified team domain
    :ivar DomainVerificationRemoveDomainType domain_verification_remove_domain:
        (domains) Removed domain from list of verified team domains
    :ivar EnabledDomainInvitesType enabled_domain_invites: (domains) Enabled
        domain invites (deprecated, no longer logged)
    :ivar CreateFolderType create_folder: (file_operations) Created folders
        (deprecated, no longer logged)
    :ivar FileAddType file_add: (file_operations) Added files and/or folders
    :ivar FileCopyType file_copy: (file_operations) Copied files and/or folders
    :ivar FileDeleteType file_delete: (file_operations) Deleted files and/or
        folders
    :ivar FileDownloadType file_download: (file_operations) Downloaded files
        and/or folders
    :ivar FileEditType file_edit: (file_operations) Edited files
    :ivar FileGetCopyReferenceType file_get_copy_reference: (file_operations)
        Created copy reference to file/folder
    :ivar FileMoveType file_move: (file_operations) Moved files and/or folders
    :ivar FilePermanentlyDeleteType file_permanently_delete: (file_operations)
        Permanently deleted files and/or folders
    :ivar FilePreviewType file_preview: (file_operations) Previewed files and/or
        folders
    :ivar FileRenameType file_rename: (file_operations) Renamed files and/or
        folders
    :ivar FileRestoreType file_restore: (file_operations) Restored deleted files
        and/or folders
    :ivar FileRevertType file_revert: (file_operations) Reverted files to
        previous version
    :ivar FileRollbackChangesType file_rollback_changes: (file_operations)
        Rolled back file actions
    :ivar FileSaveCopyReferenceType file_save_copy_reference: (file_operations)
        Saved file/folder using copy reference
    :ivar FileRequestChangeType file_request_change: (file_requests) Changed
        file request
    :ivar FileRequestCloseType file_request_close: (file_requests) Closed file
        request
    :ivar FileRequestCreateType file_request_create: (file_requests) Created
        file request
    :ivar FileRequestReceiveFileType file_request_receive_file: (file_requests)
        Received files for file request
    :ivar GroupAddExternalIdType group_add_external_id: (groups) Added external
        ID for group
    :ivar GroupAddMemberType group_add_member: (groups) Added team members to
        group
    :ivar GroupChangeExternalIdType group_change_external_id: (groups) Changed
        external ID for group
    :ivar GroupChangeManagementTypeType group_change_management_type: (groups)
        Changed group management type
    :ivar GroupChangeMemberRoleType group_change_member_role: (groups) Changed
        manager permissions of group member
    :ivar GroupCreateType group_create: (groups) Created group
    :ivar GroupDeleteType group_delete: (groups) Deleted group
    :ivar GroupDescriptionUpdatedType group_description_updated: (groups)
        Updated group (deprecated, no longer logged)
    :ivar GroupJoinPolicyUpdatedType group_join_policy_updated: (groups) Updated
        group join policy (deprecated, no longer logged)
    :ivar GroupMovedType group_moved: (groups) Moved group (deprecated, no
        longer logged)
    :ivar GroupRemoveExternalIdType group_remove_external_id: (groups) Removed
        external ID for group
    :ivar GroupRemoveMemberType group_remove_member: (groups) Removed team
        members from group
    :ivar GroupRenameType group_rename: (groups) Renamed group
    :ivar EmmErrorType emm_error: (logins) Failed to sign in via EMM
        (deprecated, replaced by 'Failed to sign in')
    :ivar LoginFailType login_fail: (logins) Failed to sign in
    :ivar LoginSuccessType login_success: (logins) Signed in
    :ivar LogoutType logout: (logins) Signed out
    :ivar ResellerSupportSessionEndType reseller_support_session_end: (logins)
        Ended reseller support session
    :ivar ResellerSupportSessionStartType reseller_support_session_start:
        (logins) Started reseller support session
    :ivar SignInAsSessionEndType sign_in_as_session_end: (logins) Ended admin
        sign-in-as session
    :ivar SignInAsSessionStartType sign_in_as_session_start: (logins) Started
        admin sign-in-as session
    :ivar SsoErrorType sso_error: (logins) Failed to sign in via SSO
        (deprecated, replaced by 'Failed to sign in')
    :ivar MemberAddNameType member_add_name: (members) Added team member name
    :ivar MemberChangeAdminRoleType member_change_admin_role: (members) Changed
        team member admin role
    :ivar MemberChangeEmailType member_change_email: (members) Changed team
        member email
    :ivar MemberChangeMembershipTypeType member_change_membership_type:
        (members) Changed membership type (limited/full) of member (deprecated,
        no longer logged)
    :ivar MemberChangeNameType member_change_name: (members) Changed team member
        name
    :ivar MemberChangeStatusType member_change_status: (members) Changed member
        status (invited, joined, suspended, etc.)
    :ivar MemberDeleteManualContactsType member_delete_manual_contacts:
        (members) Cleared saved contacts
    :ivar MemberPermanentlyDeleteAccountContentsType
        member_permanently_delete_account_contents: (members) Permanently
        deleted contents of deleted team member account
    :ivar MemberSpaceLimitsAddCustomQuotaType
        member_space_limits_add_custom_quota: (members) Set custom member space
        limit
    :ivar MemberSpaceLimitsChangeCustomQuotaType
        member_space_limits_change_custom_quota: (members) Changed custom member
        space limit
    :ivar MemberSpaceLimitsChangeStatusType member_space_limits_change_status:
        (members) Changed space limit status
    :ivar MemberSpaceLimitsRemoveCustomQuotaType
        member_space_limits_remove_custom_quota: (members) Removed custom member
        space limit
    :ivar MemberSuggestType member_suggest: (members) Suggested person to add to
        team
    :ivar MemberTransferAccountContentsType member_transfer_account_contents:
        (members) Transferred contents of deleted member account to another
        member
    :ivar SecondaryMailsPolicyChangedType secondary_mails_policy_changed:
        (members) Secondary mails policy changed
    :ivar PaperContentAddMemberType paper_content_add_member: (paper) Added team
        member to Paper doc/folder
    :ivar PaperContentAddToFolderType paper_content_add_to_folder: (paper) Added
        Paper doc/folder to folder
    :ivar PaperContentArchiveType paper_content_archive: (paper) Archived Paper
        doc/folder
    :ivar PaperContentCreateType paper_content_create: (paper) Created Paper
        doc/folder
    :ivar PaperContentPermanentlyDeleteType paper_content_permanently_delete:
        (paper) Permanently deleted Paper doc/folder
    :ivar PaperContentRemoveFromFolderType paper_content_remove_from_folder:
        (paper) Removed Paper doc/folder from folder
    :ivar PaperContentRemoveMemberType paper_content_remove_member: (paper)
        Removed team member from Paper doc/folder
    :ivar PaperContentRenameType paper_content_rename: (paper) Renamed Paper
        doc/folder
    :ivar PaperContentRestoreType paper_content_restore: (paper) Restored
        archived Paper doc/folder
    :ivar PaperDocAddCommentType paper_doc_add_comment: (paper) Added Paper doc
        comment
    :ivar PaperDocChangeMemberRoleType paper_doc_change_member_role: (paper)
        Changed team member permissions for Paper doc
    :ivar PaperDocChangeSharingPolicyType paper_doc_change_sharing_policy:
        (paper) Changed sharing setting for Paper doc
    :ivar PaperDocChangeSubscriptionType paper_doc_change_subscription: (paper)
        Followed/unfollowed Paper doc
    :ivar PaperDocDeletedType paper_doc_deleted: (paper) Archived Paper doc
        (deprecated, no longer logged)
    :ivar PaperDocDeleteCommentType paper_doc_delete_comment: (paper) Deleted
        Paper doc comment
    :ivar PaperDocDownloadType paper_doc_download: (paper) Downloaded Paper doc
        in specific format
    :ivar PaperDocEditType paper_doc_edit: (paper) Edited Paper doc
    :ivar PaperDocEditCommentType paper_doc_edit_comment: (paper) Edited Paper
        doc comment
    :ivar PaperDocFollowedType paper_doc_followed: (paper) Followed Paper doc
        (deprecated, replaced by 'Followed/unfollowed Paper doc')
    :ivar PaperDocMentionType paper_doc_mention: (paper) Mentioned team member
        in Paper doc
    :ivar PaperDocOwnershipChangedType paper_doc_ownership_changed: (paper)
        Transferred ownership of Paper doc
    :ivar PaperDocRequestAccessType paper_doc_request_access: (paper) Requested
        access to Paper doc
    :ivar PaperDocResolveCommentType paper_doc_resolve_comment: (paper) Resolved
        Paper doc comment
    :ivar PaperDocRevertType paper_doc_revert: (paper) Restored Paper doc to
        previous version
    :ivar PaperDocSlackShareType paper_doc_slack_share: (paper) Shared Paper doc
        via Slack
    :ivar PaperDocTeamInviteType paper_doc_team_invite: (paper) Shared Paper doc
        with team member (deprecated, no longer logged)
    :ivar PaperDocTrashedType paper_doc_trashed: (paper) Deleted Paper doc
    :ivar PaperDocUnresolveCommentType paper_doc_unresolve_comment: (paper)
        Unresolved Paper doc comment
    :ivar PaperDocUntrashedType paper_doc_untrashed: (paper) Restored Paper doc
    :ivar PaperDocViewType paper_doc_view: (paper) Viewed Paper doc
    :ivar PaperExternalViewAllowType paper_external_view_allow: (paper) Changed
        Paper external sharing setting to anyone (deprecated, no longer logged)
    :ivar PaperExternalViewDefaultTeamType paper_external_view_default_team:
        (paper) Changed Paper external sharing setting to default team
        (deprecated, no longer logged)
    :ivar PaperExternalViewForbidType paper_external_view_forbid: (paper)
        Changed Paper external sharing setting to team-only (deprecated, no
        longer logged)
    :ivar PaperFolderChangeSubscriptionType paper_folder_change_subscription:
        (paper) Followed/unfollowed Paper folder
    :ivar PaperFolderDeletedType paper_folder_deleted: (paper) Archived Paper
        folder (deprecated, no longer logged)
    :ivar PaperFolderFollowedType paper_folder_followed: (paper) Followed Paper
        folder (deprecated, replaced by 'Followed/unfollowed Paper folder')
    :ivar PaperFolderTeamInviteType paper_folder_team_invite: (paper) Shared
        Paper folder with member (deprecated, no longer logged)
    :ivar PasswordChangeType password_change: (passwords) Changed password
    :ivar PasswordResetType password_reset: (passwords) Reset password
    :ivar PasswordResetAllType password_reset_all: (passwords) Reset all team
        member passwords
    :ivar EmmCreateExceptionsReportType emm_create_exceptions_report: (reports)
        Created EMM-excluded users report
    :ivar EmmCreateUsageReportType emm_create_usage_report: (reports) Created
        EMM mobile app usage report
    :ivar ExportMembersReportType export_members_report: (reports) Created
        member data report
    :ivar PaperAdminExportStartType paper_admin_export_start: (reports) Exported
        all team Paper docs
    :ivar SmartSyncCreateAdminPrivilegeReportType
        smart_sync_create_admin_privilege_report: (reports) Created Smart Sync
        non-admin devices report
    :ivar TeamActivityCreateReportType team_activity_create_report: (reports)
        Created team activity report
    :ivar CollectionShareType collection_share: (sharing) Shared album
    :ivar NoteAclInviteOnlyType note_acl_invite_only: (sharing) Changed Paper
        doc to invite-only (deprecated, no longer logged)
    :ivar NoteAclLinkType note_acl_link: (sharing) Changed Paper doc to
        link-accessible (deprecated, no longer logged)
    :ivar NoteAclTeamLinkType note_acl_team_link: (sharing) Changed Paper doc to
        link-accessible for team (deprecated, no longer logged)
    :ivar NoteSharedType note_shared: (sharing) Shared Paper doc (deprecated, no
        longer logged)
    :ivar NoteShareReceiveType note_share_receive: (sharing) Shared received
        Paper doc (deprecated, no longer logged)
    :ivar OpenNoteSharedType open_note_shared: (sharing) Opened shared Paper doc
        (deprecated, no longer logged)
    :ivar SfAddGroupType sf_add_group: (sharing) Added team to shared folder
        (deprecated, no longer logged)
    :ivar SfAllowNonMembersToViewSharedLinksType
        sf_allow_non_members_to_view_shared_links: (sharing) Allowed
        non-collaborators to view links to files in shared folder (deprecated,
        no longer logged)
    :ivar SfExternalInviteWarnType sf_external_invite_warn: (sharing) Set team
        members to see warning before sharing folders outside team (deprecated,
        no longer logged)
    :ivar SfFbInviteType sf_fb_invite: (sharing) Invited Facebook users to
        shared folder (deprecated, no longer logged)
    :ivar SfFbInviteChangeRoleType sf_fb_invite_change_role: (sharing) Changed
        Facebook user's role in shared folder (deprecated, no longer logged)
    :ivar SfFbUninviteType sf_fb_uninvite: (sharing) Uninvited Facebook user
        from shared folder (deprecated, no longer logged)
    :ivar SfInviteGroupType sf_invite_group: (sharing) Invited group to shared
        folder (deprecated, no longer logged)
    :ivar SfTeamGrantAccessType sf_team_grant_access: (sharing) Granted access
        to shared folder (deprecated, no longer logged)
    :ivar SfTeamInviteType sf_team_invite: (sharing) Invited team members to
        shared folder (deprecated, replaced by 'Invited user to Dropbox and
        added them to shared file/folder')
    :ivar SfTeamInviteChangeRoleType sf_team_invite_change_role: (sharing)
        Changed team member's role in shared folder (deprecated, no longer
        logged)
    :ivar SfTeamJoinType sf_team_join: (sharing) Joined team member's shared
        folder (deprecated, no longer logged)
    :ivar SfTeamJoinFromOobLinkType sf_team_join_from_oob_link: (sharing) Joined
        team member's shared folder from link (deprecated, no longer logged)
    :ivar SfTeamUninviteType sf_team_uninvite: (sharing) Unshared folder with
        team member (deprecated, replaced by 'Removed invitee from shared
        file/folder before invite was accepted')
    :ivar SharedContentAddInviteesType shared_content_add_invitees: (sharing)
        Invited user to Dropbox and added them to shared file/folder
    :ivar SharedContentAddLinkExpiryType shared_content_add_link_expiry:
        (sharing) Added expiration date to link for shared file/folder
    :ivar SharedContentAddLinkPasswordType shared_content_add_link_password:
        (sharing) Added password to link for shared file/folder
    :ivar SharedContentAddMemberType shared_content_add_member: (sharing) Added
        users and/or groups to shared file/folder
    :ivar SharedContentChangeDownloadsPolicyType
        shared_content_change_downloads_policy: (sharing) Changed whether
        members can download shared file/folder
    :ivar SharedContentChangeInviteeRoleType shared_content_change_invitee_role:
        (sharing) Changed access type of invitee to shared file/folder before
        invite was accepted
    :ivar SharedContentChangeLinkAudienceType
        shared_content_change_link_audience: (sharing) Changed link audience of
        shared file/folder
    :ivar SharedContentChangeLinkExpiryType shared_content_change_link_expiry:
        (sharing) Changed link expiration of shared file/folder
    :ivar SharedContentChangeLinkPasswordType
        shared_content_change_link_password: (sharing) Changed link password of
        shared file/folder
    :ivar SharedContentChangeMemberRoleType shared_content_change_member_role:
        (sharing) Changed access type of shared file/folder member
    :ivar SharedContentChangeViewerInfoPolicyType
        shared_content_change_viewer_info_policy: (sharing) Changed whether
        members can see who viewed shared file/folder
    :ivar SharedContentClaimInvitationType shared_content_claim_invitation:
        (sharing) Acquired membership of shared file/folder by accepting invite
    :ivar SharedContentCopyType shared_content_copy: (sharing) Copied shared
        file/folder to own Dropbox
    :ivar SharedContentDownloadType shared_content_download: (sharing)
        Downloaded shared file/folder
    :ivar SharedContentRelinquishMembershipType
        shared_content_relinquish_membership: (sharing) Left shared file/folder
    :ivar SharedContentRemoveInviteesType shared_content_remove_invitees:
        (sharing) Removed invitee from shared file/folder before invite was
        accepted
    :ivar SharedContentRemoveLinkExpiryType shared_content_remove_link_expiry:
        (sharing) Removed link expiration date of shared file/folder
    :ivar SharedContentRemoveLinkPasswordType
        shared_content_remove_link_password: (sharing) Removed link password of
        shared file/folder
    :ivar SharedContentRemoveMemberType shared_content_remove_member: (sharing)
        Removed user/group from shared file/folder
    :ivar SharedContentRequestAccessType shared_content_request_access:
        (sharing) Requested access to shared file/folder
    :ivar SharedContentUnshareType shared_content_unshare: (sharing) Unshared
        file/folder by clearing membership and turning off link
    :ivar SharedContentViewType shared_content_view: (sharing) Previewed shared
        file/folder
    :ivar SharedFolderChangeLinkPolicyType shared_folder_change_link_policy:
        (sharing) Changed who can access shared folder via link
    :ivar SharedFolderChangeMembersInheritancePolicyType
        shared_folder_change_members_inheritance_policy: (sharing) Changed
        whether shared folder inherits members from parent folder
    :ivar SharedFolderChangeMembersManagementPolicyType
        shared_folder_change_members_management_policy: (sharing) Changed who
        can add/remove members of shared folder
    :ivar SharedFolderChangeMembersPolicyType
        shared_folder_change_members_policy: (sharing) Changed who can become
        member of shared folder
    :ivar SharedFolderCreateType shared_folder_create: (sharing) Created shared
        folder
    :ivar SharedFolderDeclineInvitationType shared_folder_decline_invitation:
        (sharing) Declined team member's invite to shared folder
    :ivar SharedFolderMountType shared_folder_mount: (sharing) Added shared
        folder to own Dropbox
    :ivar SharedFolderNestType shared_folder_nest: (sharing) Changed parent of
        shared folder
    :ivar SharedFolderTransferOwnershipType shared_folder_transfer_ownership:
        (sharing) Transferred ownership of shared folder to another member
    :ivar SharedFolderUnmountType shared_folder_unmount: (sharing) Deleted
        shared folder from Dropbox
    :ivar SharedLinkAddExpiryType shared_link_add_expiry: (sharing) Added shared
        link expiration date
    :ivar SharedLinkChangeExpiryType shared_link_change_expiry: (sharing)
        Changed shared link expiration date
    :ivar SharedLinkChangeVisibilityType shared_link_change_visibility:
        (sharing) Changed visibility of shared link
    :ivar SharedLinkCopyType shared_link_copy: (sharing) Added file/folder to
        Dropbox from shared link
    :ivar SharedLinkCreateType shared_link_create: (sharing) Created shared link
    :ivar SharedLinkDisableType shared_link_disable: (sharing) Removed shared
        link
    :ivar SharedLinkDownloadType shared_link_download: (sharing) Downloaded
        file/folder from shared link
    :ivar SharedLinkRemoveExpiryType shared_link_remove_expiry: (sharing)
        Removed shared link expiration date
    :ivar SharedLinkShareType shared_link_share: (sharing) Added members as
        audience of shared link
    :ivar SharedLinkViewType shared_link_view: (sharing) Opened shared link
    :ivar SharedNoteOpenedType shared_note_opened: (sharing) Opened shared Paper
        doc (deprecated, no longer logged)
    :ivar ShmodelGroupShareType shmodel_group_share: (sharing) Shared link with
        group (deprecated, no longer logged)
    :ivar ShowcaseAccessGrantedType showcase_access_granted: (showcase) Granted
        access to showcase
    :ivar ShowcaseAddMemberType showcase_add_member: (showcase) Added member to
        showcase
    :ivar ShowcaseArchivedType showcase_archived: (showcase) Archived showcase
    :ivar ShowcaseCreatedType showcase_created: (showcase) Created showcase
    :ivar ShowcaseDeleteCommentType showcase_delete_comment: (showcase) Deleted
        showcase comment
    :ivar ShowcaseEditedType showcase_edited: (showcase) Edited showcase
    :ivar ShowcaseEditCommentType showcase_edit_comment: (showcase) Edited
        showcase comment
    :ivar ShowcaseFileAddedType showcase_file_added: (showcase) Added file to
        showcase
    :ivar ShowcaseFileDownloadType showcase_file_download: (showcase) Downloaded
        file from showcase
    :ivar ShowcaseFileRemovedType showcase_file_removed: (showcase) Removed file
        from showcase
    :ivar ShowcaseFileViewType showcase_file_view: (showcase) Viewed file in
        showcase
    :ivar ShowcasePermanentlyDeletedType showcase_permanently_deleted:
        (showcase) Permanently deleted showcase
    :ivar ShowcasePostCommentType showcase_post_comment: (showcase) Added
        showcase comment
    :ivar ShowcaseRemoveMemberType showcase_remove_member: (showcase) Removed
        member from showcase
    :ivar ShowcaseRenamedType showcase_renamed: (showcase) Renamed showcase
    :ivar ShowcaseRequestAccessType showcase_request_access: (showcase)
        Requested access to showcase
    :ivar ShowcaseResolveCommentType showcase_resolve_comment: (showcase)
        Resolved showcase comment
    :ivar ShowcaseRestoredType showcase_restored: (showcase) Unarchived showcase
    :ivar ShowcaseTrashedType showcase_trashed: (showcase) Deleted showcase
    :ivar ShowcaseTrashedDeprecatedType showcase_trashed_deprecated: (showcase)
        Deleted showcase (old version) (deprecated, replaced by 'Deleted
        showcase')
    :ivar ShowcaseUnresolveCommentType showcase_unresolve_comment: (showcase)
        Unresolved showcase comment
    :ivar ShowcaseUntrashedType showcase_untrashed: (showcase) Restored showcase
    :ivar ShowcaseUntrashedDeprecatedType showcase_untrashed_deprecated:
        (showcase) Restored showcase (old version) (deprecated, replaced by
        'Restored showcase')
    :ivar ShowcaseViewType showcase_view: (showcase) Viewed showcase
    :ivar SsoAddCertType sso_add_cert: (sso) Added X.509 certificate for SSO
    :ivar SsoAddLoginUrlType sso_add_login_url: (sso) Added sign-in URL for SSO
    :ivar SsoAddLogoutUrlType sso_add_logout_url: (sso) Added sign-out URL for
        SSO
    :ivar SsoChangeCertType sso_change_cert: (sso) Changed X.509 certificate for
        SSO
    :ivar SsoChangeLoginUrlType sso_change_login_url: (sso) Changed sign-in URL
        for SSO
    :ivar SsoChangeLogoutUrlType sso_change_logout_url: (sso) Changed sign-out
        URL for SSO
    :ivar SsoChangeSamlIdentityModeType sso_change_saml_identity_mode: (sso)
        Changed SAML identity mode for SSO
    :ivar SsoRemoveCertType sso_remove_cert: (sso) Removed X.509 certificate for
        SSO
    :ivar SsoRemoveLoginUrlType sso_remove_login_url: (sso) Removed sign-in URL
        for SSO
    :ivar SsoRemoveLogoutUrlType sso_remove_logout_url: (sso) Removed sign-out
        URL for SSO
    :ivar TeamFolderChangeStatusType team_folder_change_status: (team_folders)
        Changed archival status of team folder
    :ivar TeamFolderCreateType team_folder_create: (team_folders) Created team
        folder in active status
    :ivar TeamFolderDowngradeType team_folder_downgrade: (team_folders)
        Downgraded team folder to regular shared folder
    :ivar TeamFolderPermanentlyDeleteType team_folder_permanently_delete:
        (team_folders) Permanently deleted archived team folder
    :ivar TeamFolderRenameType team_folder_rename: (team_folders) Renamed
        active/archived team folder
    :ivar TeamSelectiveSyncSettingsChangedType
        team_selective_sync_settings_changed: (team_folders) Changed sync
        default
    :ivar AccountCaptureChangePolicyType account_capture_change_policy:
        (team_policies) Changed account capture setting on team domain
    :ivar AllowDownloadDisabledType allow_download_disabled: (team_policies)
        Disabled downloads (deprecated, no longer logged)
    :ivar AllowDownloadEnabledType allow_download_enabled: (team_policies)
        Enabled downloads (deprecated, no longer logged)
    :ivar DataPlacementRestrictionChangePolicyType
        data_placement_restriction_change_policy: (team_policies) Set
        restrictions on data center locations where team data resides
    :ivar DataPlacementRestrictionSatisfyPolicyType
        data_placement_restriction_satisfy_policy: (team_policies) Completed
        restrictions on data center locations where team data resides
    :ivar DeviceApprovalsChangeDesktopPolicyType
        device_approvals_change_desktop_policy: (team_policies) Set/removed
        limit on number of computers member can link to team Dropbox account
    :ivar DeviceApprovalsChangeMobilePolicyType
        device_approvals_change_mobile_policy: (team_policies) Set/removed limit
        on number of mobile devices member can link to team Dropbox account
    :ivar DeviceApprovalsChangeOverageActionType
        device_approvals_change_overage_action: (team_policies) Changed device
        approvals setting when member is over limit
    :ivar DeviceApprovalsChangeUnlinkActionType
        device_approvals_change_unlink_action: (team_policies) Changed device
        approvals setting when member unlinks approved device
    :ivar DirectoryRestrictionsAddMembersType
        directory_restrictions_add_members: (team_policies) Added members to
        directory restrictions list
    :ivar DirectoryRestrictionsRemoveMembersType
        directory_restrictions_remove_members: (team_policies) Removed members
        from directory restrictions list
    :ivar EmmAddExceptionType emm_add_exception: (team_policies) Added members
        to EMM exception list
    :ivar EmmChangePolicyType emm_change_policy: (team_policies)
        Enabled/disabled enterprise mobility management for members
    :ivar EmmRemoveExceptionType emm_remove_exception: (team_policies) Removed
        members from EMM exception list
    :ivar ExtendedVersionHistoryChangePolicyType
        extended_version_history_change_policy: (team_policies) Accepted/opted
        out of extended version history
    :ivar FileCommentsChangePolicyType file_comments_change_policy:
        (team_policies) Enabled/disabled commenting on team files
    :ivar FileRequestsChangePolicyType file_requests_change_policy:
        (team_policies) Enabled/disabled file requests
    :ivar FileRequestsEmailsEnabledType file_requests_emails_enabled:
        (team_policies) Enabled file request emails for everyone (deprecated, no
        longer logged)
    :ivar FileRequestsEmailsRestrictedToTeamOnlyType
        file_requests_emails_restricted_to_team_only: (team_policies) Enabled
        file request emails for team (deprecated, no longer logged)
    :ivar GoogleSsoChangePolicyType google_sso_change_policy: (team_policies)
        Enabled/disabled Google single sign-on for team
    :ivar GroupUserManagementChangePolicyType
        group_user_management_change_policy: (team_policies) Changed who can
        create groups
    :ivar MemberRequestsChangePolicyType member_requests_change_policy:
        (team_policies) Changed whether users can find team when not invited
    :ivar MemberSpaceLimitsAddExceptionType member_space_limits_add_exception:
        (team_policies) Added members to member space limit exception list
    :ivar MemberSpaceLimitsChangeCapsTypePolicyType
        member_space_limits_change_caps_type_policy: (team_policies) Changed
        member space limit type for team
    :ivar MemberSpaceLimitsChangePolicyType member_space_limits_change_policy:
        (team_policies) Changed team default member space limit
    :ivar MemberSpaceLimitsRemoveExceptionType
        member_space_limits_remove_exception: (team_policies) Removed members
        from member space limit exception list
    :ivar MemberSuggestionsChangePolicyType member_suggestions_change_policy:
        (team_policies) Enabled/disabled option for team members to suggest
        people to add to team
    :ivar MicrosoftOfficeAddinChangePolicyType
        microsoft_office_addin_change_policy: (team_policies) Enabled/disabled
        Microsoft Office add-in
    :ivar NetworkControlChangePolicyType network_control_change_policy:
        (team_policies) Enabled/disabled network control
    :ivar PaperChangeDeploymentPolicyType paper_change_deployment_policy:
        (team_policies) Changed whether Dropbox Paper, when enabled, is deployed
        to all members or to specific members
    :ivar PaperChangeMemberLinkPolicyType paper_change_member_link_policy:
        (team_policies) Changed whether non-members can view Paper docs with
        link (deprecated, no longer logged)
    :ivar PaperChangeMemberPolicyType paper_change_member_policy:
        (team_policies) Changed whether members can share Paper docs outside
        team, and if docs are accessible only by team members or anyone by
        default
    :ivar PaperChangePolicyType paper_change_policy: (team_policies)
        Enabled/disabled Dropbox Paper for team
    :ivar PaperEnabledUsersGroupAdditionType paper_enabled_users_group_addition:
        (team_policies) Added users to Paper-enabled users list
    :ivar PaperEnabledUsersGroupRemovalType paper_enabled_users_group_removal:
        (team_policies) Removed users from Paper-enabled users list
    :ivar PermanentDeleteChangePolicyType permanent_delete_change_policy:
        (team_policies) Enabled/disabled ability of team members to permanently
        delete content
    :ivar SharingChangeFolderJoinPolicyType sharing_change_folder_join_policy:
        (team_policies) Changed whether team members can join shared folders
        owned outside team
    :ivar SharingChangeLinkPolicyType sharing_change_link_policy:
        (team_policies) Changed whether members can share links outside team,
        and if links are accessible only by team members or anyone by default
    :ivar SharingChangeMemberPolicyType sharing_change_member_policy:
        (team_policies) Changed whether members can share files/folders outside
        team
    :ivar ShowcaseChangeDownloadPolicyType showcase_change_download_policy:
        (team_policies) Enabled/disabled downloading files from Dropbox Showcase
        for team
    :ivar ShowcaseChangeEnabledPolicyType showcase_change_enabled_policy:
        (team_policies) Enabled/disabled Dropbox Showcase for team
    :ivar ShowcaseChangeExternalSharingPolicyType
        showcase_change_external_sharing_policy: (team_policies)
        Enabled/disabled sharing Dropbox Showcase externally for team
    :ivar SmartSyncChangePolicyType smart_sync_change_policy: (team_policies)
        Changed default Smart Sync setting for team members
    :ivar SmartSyncNotOptOutType smart_sync_not_opt_out: (team_policies) Opted
        team into Smart Sync
    :ivar SmartSyncOptOutType smart_sync_opt_out: (team_policies) Opted team out
        of Smart Sync
    :ivar SsoChangePolicyType sso_change_policy: (team_policies) Changed single
        sign-on setting for team
    :ivar TeamSelectiveSyncPolicyChangedType team_selective_sync_policy_changed:
        (team_policies) Enabled/disabled Team Selective Sync for team
    :ivar TfaChangePolicyType tfa_change_policy: (team_policies) Changed
        two-step verification setting for team
    :ivar TwoAccountChangePolicyType two_account_change_policy: (team_policies)
        Enabled/disabled option for members to link personal Dropbox account and
        team account to same computer
    :ivar ViewerInfoPolicyChangedType viewer_info_policy_changed:
        (team_policies) Changed team policy for viewer info
    :ivar WebSessionsChangeFixedLengthPolicyType
        web_sessions_change_fixed_length_policy: (team_policies) Changed how
        long members can stay signed in to Dropbox.com
    :ivar WebSessionsChangeIdleLengthPolicyType
        web_sessions_change_idle_length_policy: (team_policies) Changed how long
        team members can be idle while signed in to Dropbox.com
    :ivar TeamMergeFromType team_merge_from: (team_profile) Merged another team
        into this team
    :ivar TeamMergeToType team_merge_to: (team_profile) Merged this team into
        another team
    :ivar TeamProfileAddLogoType team_profile_add_logo: (team_profile) Added
        team logo to display on shared link headers
    :ivar TeamProfileChangeDefaultLanguageType
        team_profile_change_default_language: (team_profile) Changed default
        language for team
    :ivar TeamProfileChangeLogoType team_profile_change_logo: (team_profile)
        Changed team logo displayed on shared link headers
    :ivar TeamProfileChangeNameType team_profile_change_name: (team_profile)
        Changed team name
    :ivar TeamProfileRemoveLogoType team_profile_remove_logo: (team_profile)
        Removed team logo displayed on shared link headers
    :ivar TfaAddBackupPhoneType tfa_add_backup_phone: (tfa) Added backup phone
        for two-step verification
    :ivar TfaAddSecurityKeyType tfa_add_security_key: (tfa) Added security key
        for two-step verification
    :ivar TfaChangeBackupPhoneType tfa_change_backup_phone: (tfa) Changed backup
        phone for two-step verification
    :ivar TfaChangeStatusType tfa_change_status: (tfa) Enabled/disabled/changed
        two-step verification setting
    :ivar TfaRemoveBackupPhoneType tfa_remove_backup_phone: (tfa) Removed backup
        phone for two-step verification
    :ivar TfaRemoveSecurityKeyType tfa_remove_security_key: (tfa) Removed
        security key for two-step verification
    :ivar TfaResetType tfa_reset: (tfa) Reset two-step verification for team
        member
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def app_link_team(cls, val):
        """
        Create an instance of this class set to the ``app_link_team`` tag with
        value ``val``.

        :param AppLinkTeamType val:
        :rtype: EventType
        """
        return cls('app_link_team', val)

    @classmethod
    def app_link_user(cls, val):
        """
        Create an instance of this class set to the ``app_link_user`` tag with
        value ``val``.

        :param AppLinkUserType val:
        :rtype: EventType
        """
        return cls('app_link_user', val)

    @classmethod
    def app_unlink_team(cls, val):
        """
        Create an instance of this class set to the ``app_unlink_team`` tag with
        value ``val``.

        :param AppUnlinkTeamType val:
        :rtype: EventType
        """
        return cls('app_unlink_team', val)

    @classmethod
    def app_unlink_user(cls, val):
        """
        Create an instance of this class set to the ``app_unlink_user`` tag with
        value ``val``.

        :param AppUnlinkUserType val:
        :rtype: EventType
        """
        return cls('app_unlink_user', val)

    @classmethod
    def file_add_comment(cls, val):
        """
        Create an instance of this class set to the ``file_add_comment`` tag
        with value ``val``.

        :param FileAddCommentType val:
        :rtype: EventType
        """
        return cls('file_add_comment', val)

    @classmethod
    def file_change_comment_subscription(cls, val):
        """
        Create an instance of this class set to the
        ``file_change_comment_subscription`` tag with value ``val``.

        :param FileChangeCommentSubscriptionType val:
        :rtype: EventType
        """
        return cls('file_change_comment_subscription', val)

    @classmethod
    def file_delete_comment(cls, val):
        """
        Create an instance of this class set to the ``file_delete_comment`` tag
        with value ``val``.

        :param FileDeleteCommentType val:
        :rtype: EventType
        """
        return cls('file_delete_comment', val)

    @classmethod
    def file_like_comment(cls, val):
        """
        Create an instance of this class set to the ``file_like_comment`` tag
        with value ``val``.

        :param FileLikeCommentType val:
        :rtype: EventType
        """
        return cls('file_like_comment', val)

    @classmethod
    def file_resolve_comment(cls, val):
        """
        Create an instance of this class set to the ``file_resolve_comment`` tag
        with value ``val``.

        :param FileResolveCommentType val:
        :rtype: EventType
        """
        return cls('file_resolve_comment', val)

    @classmethod
    def file_unlike_comment(cls, val):
        """
        Create an instance of this class set to the ``file_unlike_comment`` tag
        with value ``val``.

        :param FileUnlikeCommentType val:
        :rtype: EventType
        """
        return cls('file_unlike_comment', val)

    @classmethod
    def file_unresolve_comment(cls, val):
        """
        Create an instance of this class set to the ``file_unresolve_comment``
        tag with value ``val``.

        :param FileUnresolveCommentType val:
        :rtype: EventType
        """
        return cls('file_unresolve_comment', val)

    @classmethod
    def device_change_ip_desktop(cls, val):
        """
        Create an instance of this class set to the ``device_change_ip_desktop``
        tag with value ``val``.

        :param DeviceChangeIpDesktopType val:
        :rtype: EventType
        """
        return cls('device_change_ip_desktop', val)

    @classmethod
    def device_change_ip_mobile(cls, val):
        """
        Create an instance of this class set to the ``device_change_ip_mobile``
        tag with value ``val``.

        :param DeviceChangeIpMobileType val:
        :rtype: EventType
        """
        return cls('device_change_ip_mobile', val)

    @classmethod
    def device_change_ip_web(cls, val):
        """
        Create an instance of this class set to the ``device_change_ip_web`` tag
        with value ``val``.

        :param DeviceChangeIpWebType val:
        :rtype: EventType
        """
        return cls('device_change_ip_web', val)

    @classmethod
    def device_delete_on_unlink_fail(cls, val):
        """
        Create an instance of this class set to the
        ``device_delete_on_unlink_fail`` tag with value ``val``.

        :param DeviceDeleteOnUnlinkFailType val:
        :rtype: EventType
        """
        return cls('device_delete_on_unlink_fail', val)

    @classmethod
    def device_delete_on_unlink_success(cls, val):
        """
        Create an instance of this class set to the
        ``device_delete_on_unlink_success`` tag with value ``val``.

        :param DeviceDeleteOnUnlinkSuccessType val:
        :rtype: EventType
        """
        return cls('device_delete_on_unlink_success', val)

    @classmethod
    def device_link_fail(cls, val):
        """
        Create an instance of this class set to the ``device_link_fail`` tag
        with value ``val``.

        :param DeviceLinkFailType val:
        :rtype: EventType
        """
        return cls('device_link_fail', val)

    @classmethod
    def device_link_success(cls, val):
        """
        Create an instance of this class set to the ``device_link_success`` tag
        with value ``val``.

        :param DeviceLinkSuccessType val:
        :rtype: EventType
        """
        return cls('device_link_success', val)

    @classmethod
    def device_management_disabled(cls, val):
        """
        Create an instance of this class set to the
        ``device_management_disabled`` tag with value ``val``.

        :param DeviceManagementDisabledType val:
        :rtype: EventType
        """
        return cls('device_management_disabled', val)

    @classmethod
    def device_management_enabled(cls, val):
        """
        Create an instance of this class set to the
        ``device_management_enabled`` tag with value ``val``.

        :param DeviceManagementEnabledType val:
        :rtype: EventType
        """
        return cls('device_management_enabled', val)

    @classmethod
    def device_unlink(cls, val):
        """
        Create an instance of this class set to the ``device_unlink`` tag with
        value ``val``.

        :param DeviceUnlinkType val:
        :rtype: EventType
        """
        return cls('device_unlink', val)

    @classmethod
    def emm_refresh_auth_token(cls, val):
        """
        Create an instance of this class set to the ``emm_refresh_auth_token``
        tag with value ``val``.

        :param EmmRefreshAuthTokenType val:
        :rtype: EventType
        """
        return cls('emm_refresh_auth_token', val)

    @classmethod
    def account_capture_change_availability(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_change_availability`` tag with value ``val``.

        :param AccountCaptureChangeAvailabilityType val:
        :rtype: EventType
        """
        return cls('account_capture_change_availability', val)

    @classmethod
    def account_capture_migrate_account(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_migrate_account`` tag with value ``val``.

        :param AccountCaptureMigrateAccountType val:
        :rtype: EventType
        """
        return cls('account_capture_migrate_account', val)

    @classmethod
    def account_capture_notification_emails_sent(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_notification_emails_sent`` tag with value ``val``.

        :param AccountCaptureNotificationEmailsSentType val:
        :rtype: EventType
        """
        return cls('account_capture_notification_emails_sent', val)

    @classmethod
    def account_capture_relinquish_account(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_relinquish_account`` tag with value ``val``.

        :param AccountCaptureRelinquishAccountType val:
        :rtype: EventType
        """
        return cls('account_capture_relinquish_account', val)

    @classmethod
    def disabled_domain_invites(cls, val):
        """
        Create an instance of this class set to the ``disabled_domain_invites``
        tag with value ``val``.

        :param DisabledDomainInvitesType val:
        :rtype: EventType
        """
        return cls('disabled_domain_invites', val)

    @classmethod
    def domain_invites_approve_request_to_join_team(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_approve_request_to_join_team`` tag with value ``val``.

        :param DomainInvitesApproveRequestToJoinTeamType val:
        :rtype: EventType
        """
        return cls('domain_invites_approve_request_to_join_team', val)

    @classmethod
    def domain_invites_decline_request_to_join_team(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_decline_request_to_join_team`` tag with value ``val``.

        :param DomainInvitesDeclineRequestToJoinTeamType val:
        :rtype: EventType
        """
        return cls('domain_invites_decline_request_to_join_team', val)

    @classmethod
    def domain_invites_email_existing_users(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_email_existing_users`` tag with value ``val``.

        :param DomainInvitesEmailExistingUsersType val:
        :rtype: EventType
        """
        return cls('domain_invites_email_existing_users', val)

    @classmethod
    def domain_invites_request_to_join_team(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_request_to_join_team`` tag with value ``val``.

        :param DomainInvitesRequestToJoinTeamType val:
        :rtype: EventType
        """
        return cls('domain_invites_request_to_join_team', val)

    @classmethod
    def domain_invites_set_invite_new_user_pref_to_no(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_set_invite_new_user_pref_to_no`` tag with value
        ``val``.

        :param DomainInvitesSetInviteNewUserPrefToNoType val:
        :rtype: EventType
        """
        return cls('domain_invites_set_invite_new_user_pref_to_no', val)

    @classmethod
    def domain_invites_set_invite_new_user_pref_to_yes(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_set_invite_new_user_pref_to_yes`` tag with value
        ``val``.

        :param DomainInvitesSetInviteNewUserPrefToYesType val:
        :rtype: EventType
        """
        return cls('domain_invites_set_invite_new_user_pref_to_yes', val)

    @classmethod
    def domain_verification_add_domain_fail(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_add_domain_fail`` tag with value ``val``.

        :param DomainVerificationAddDomainFailType val:
        :rtype: EventType
        """
        return cls('domain_verification_add_domain_fail', val)

    @classmethod
    def domain_verification_add_domain_success(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_add_domain_success`` tag with value ``val``.

        :param DomainVerificationAddDomainSuccessType val:
        :rtype: EventType
        """
        return cls('domain_verification_add_domain_success', val)

    @classmethod
    def domain_verification_remove_domain(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_remove_domain`` tag with value ``val``.

        :param DomainVerificationRemoveDomainType val:
        :rtype: EventType
        """
        return cls('domain_verification_remove_domain', val)

    @classmethod
    def enabled_domain_invites(cls, val):
        """
        Create an instance of this class set to the ``enabled_domain_invites``
        tag with value ``val``.

        :param EnabledDomainInvitesType val:
        :rtype: EventType
        """
        return cls('enabled_domain_invites', val)

    @classmethod
    def create_folder(cls, val):
        """
        Create an instance of this class set to the ``create_folder`` tag with
        value ``val``.

        :param CreateFolderType val:
        :rtype: EventType
        """
        return cls('create_folder', val)

    @classmethod
    def file_add(cls, val):
        """
        Create an instance of this class set to the ``file_add`` tag with value
        ``val``.

        :param FileAddType val:
        :rtype: EventType
        """
        return cls('file_add', val)

    @classmethod
    def file_copy(cls, val):
        """
        Create an instance of this class set to the ``file_copy`` tag with value
        ``val``.

        :param FileCopyType val:
        :rtype: EventType
        """
        return cls('file_copy', val)

    @classmethod
    def file_delete(cls, val):
        """
        Create an instance of this class set to the ``file_delete`` tag with
        value ``val``.

        :param FileDeleteType val:
        :rtype: EventType
        """
        return cls('file_delete', val)

    @classmethod
    def file_download(cls, val):
        """
        Create an instance of this class set to the ``file_download`` tag with
        value ``val``.

        :param FileDownloadType val:
        :rtype: EventType
        """
        return cls('file_download', val)

    @classmethod
    def file_edit(cls, val):
        """
        Create an instance of this class set to the ``file_edit`` tag with value
        ``val``.

        :param FileEditType val:
        :rtype: EventType
        """
        return cls('file_edit', val)

    @classmethod
    def file_get_copy_reference(cls, val):
        """
        Create an instance of this class set to the ``file_get_copy_reference``
        tag with value ``val``.

        :param FileGetCopyReferenceType val:
        :rtype: EventType
        """
        return cls('file_get_copy_reference', val)

    @classmethod
    def file_move(cls, val):
        """
        Create an instance of this class set to the ``file_move`` tag with value
        ``val``.

        :param FileMoveType val:
        :rtype: EventType
        """
        return cls('file_move', val)

    @classmethod
    def file_permanently_delete(cls, val):
        """
        Create an instance of this class set to the ``file_permanently_delete``
        tag with value ``val``.

        :param FilePermanentlyDeleteType val:
        :rtype: EventType
        """
        return cls('file_permanently_delete', val)

    @classmethod
    def file_preview(cls, val):
        """
        Create an instance of this class set to the ``file_preview`` tag with
        value ``val``.

        :param FilePreviewType val:
        :rtype: EventType
        """
        return cls('file_preview', val)

    @classmethod
    def file_rename(cls, val):
        """
        Create an instance of this class set to the ``file_rename`` tag with
        value ``val``.

        :param FileRenameType val:
        :rtype: EventType
        """
        return cls('file_rename', val)

    @classmethod
    def file_restore(cls, val):
        """
        Create an instance of this class set to the ``file_restore`` tag with
        value ``val``.

        :param FileRestoreType val:
        :rtype: EventType
        """
        return cls('file_restore', val)

    @classmethod
    def file_revert(cls, val):
        """
        Create an instance of this class set to the ``file_revert`` tag with
        value ``val``.

        :param FileRevertType val:
        :rtype: EventType
        """
        return cls('file_revert', val)

    @classmethod
    def file_rollback_changes(cls, val):
        """
        Create an instance of this class set to the ``file_rollback_changes``
        tag with value ``val``.

        :param FileRollbackChangesType val:
        :rtype: EventType
        """
        return cls('file_rollback_changes', val)

    @classmethod
    def file_save_copy_reference(cls, val):
        """
        Create an instance of this class set to the ``file_save_copy_reference``
        tag with value ``val``.

        :param FileSaveCopyReferenceType val:
        :rtype: EventType
        """
        return cls('file_save_copy_reference', val)

    @classmethod
    def file_request_change(cls, val):
        """
        Create an instance of this class set to the ``file_request_change`` tag
        with value ``val``.

        :param FileRequestChangeType val:
        :rtype: EventType
        """
        return cls('file_request_change', val)

    @classmethod
    def file_request_close(cls, val):
        """
        Create an instance of this class set to the ``file_request_close`` tag
        with value ``val``.

        :param FileRequestCloseType val:
        :rtype: EventType
        """
        return cls('file_request_close', val)

    @classmethod
    def file_request_create(cls, val):
        """
        Create an instance of this class set to the ``file_request_create`` tag
        with value ``val``.

        :param FileRequestCreateType val:
        :rtype: EventType
        """
        return cls('file_request_create', val)

    @classmethod
    def file_request_receive_file(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_receive_file`` tag with value ``val``.

        :param FileRequestReceiveFileType val:
        :rtype: EventType
        """
        return cls('file_request_receive_file', val)

    @classmethod
    def group_add_external_id(cls, val):
        """
        Create an instance of this class set to the ``group_add_external_id``
        tag with value ``val``.

        :param GroupAddExternalIdType val:
        :rtype: EventType
        """
        return cls('group_add_external_id', val)

    @classmethod
    def group_add_member(cls, val):
        """
        Create an instance of this class set to the ``group_add_member`` tag
        with value ``val``.

        :param GroupAddMemberType val:
        :rtype: EventType
        """
        return cls('group_add_member', val)

    @classmethod
    def group_change_external_id(cls, val):
        """
        Create an instance of this class set to the ``group_change_external_id``
        tag with value ``val``.

        :param GroupChangeExternalIdType val:
        :rtype: EventType
        """
        return cls('group_change_external_id', val)

    @classmethod
    def group_change_management_type(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_management_type`` tag with value ``val``.

        :param GroupChangeManagementTypeType val:
        :rtype: EventType
        """
        return cls('group_change_management_type', val)

    @classmethod
    def group_change_member_role(cls, val):
        """
        Create an instance of this class set to the ``group_change_member_role``
        tag with value ``val``.

        :param GroupChangeMemberRoleType val:
        :rtype: EventType
        """
        return cls('group_change_member_role', val)

    @classmethod
    def group_create(cls, val):
        """
        Create an instance of this class set to the ``group_create`` tag with
        value ``val``.

        :param GroupCreateType val:
        :rtype: EventType
        """
        return cls('group_create', val)

    @classmethod
    def group_delete(cls, val):
        """
        Create an instance of this class set to the ``group_delete`` tag with
        value ``val``.

        :param GroupDeleteType val:
        :rtype: EventType
        """
        return cls('group_delete', val)

    @classmethod
    def group_description_updated(cls, val):
        """
        Create an instance of this class set to the
        ``group_description_updated`` tag with value ``val``.

        :param GroupDescriptionUpdatedType val:
        :rtype: EventType
        """
        return cls('group_description_updated', val)

    @classmethod
    def group_join_policy_updated(cls, val):
        """
        Create an instance of this class set to the
        ``group_join_policy_updated`` tag with value ``val``.

        :param GroupJoinPolicyUpdatedType val:
        :rtype: EventType
        """
        return cls('group_join_policy_updated', val)

    @classmethod
    def group_moved(cls, val):
        """
        Create an instance of this class set to the ``group_moved`` tag with
        value ``val``.

        :param GroupMovedType val:
        :rtype: EventType
        """
        return cls('group_moved', val)

    @classmethod
    def group_remove_external_id(cls, val):
        """
        Create an instance of this class set to the ``group_remove_external_id``
        tag with value ``val``.

        :param GroupRemoveExternalIdType val:
        :rtype: EventType
        """
        return cls('group_remove_external_id', val)

    @classmethod
    def group_remove_member(cls, val):
        """
        Create an instance of this class set to the ``group_remove_member`` tag
        with value ``val``.

        :param GroupRemoveMemberType val:
        :rtype: EventType
        """
        return cls('group_remove_member', val)

    @classmethod
    def group_rename(cls, val):
        """
        Create an instance of this class set to the ``group_rename`` tag with
        value ``val``.

        :param GroupRenameType val:
        :rtype: EventType
        """
        return cls('group_rename', val)

    @classmethod
    def emm_error(cls, val):
        """
        Create an instance of this class set to the ``emm_error`` tag with value
        ``val``.

        :param EmmErrorType val:
        :rtype: EventType
        """
        return cls('emm_error', val)

    @classmethod
    def login_fail(cls, val):
        """
        Create an instance of this class set to the ``login_fail`` tag with
        value ``val``.

        :param LoginFailType val:
        :rtype: EventType
        """
        return cls('login_fail', val)

    @classmethod
    def login_success(cls, val):
        """
        Create an instance of this class set to the ``login_success`` tag with
        value ``val``.

        :param LoginSuccessType val:
        :rtype: EventType
        """
        return cls('login_success', val)

    @classmethod
    def logout(cls, val):
        """
        Create an instance of this class set to the ``logout`` tag with value
        ``val``.

        :param LogoutType val:
        :rtype: EventType
        """
        return cls('logout', val)

    @classmethod
    def reseller_support_session_end(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_session_end`` tag with value ``val``.

        :param ResellerSupportSessionEndType val:
        :rtype: EventType
        """
        return cls('reseller_support_session_end', val)

    @classmethod
    def reseller_support_session_start(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_session_start`` tag with value ``val``.

        :param ResellerSupportSessionStartType val:
        :rtype: EventType
        """
        return cls('reseller_support_session_start', val)

    @classmethod
    def sign_in_as_session_end(cls, val):
        """
        Create an instance of this class set to the ``sign_in_as_session_end``
        tag with value ``val``.

        :param SignInAsSessionEndType val:
        :rtype: EventType
        """
        return cls('sign_in_as_session_end', val)

    @classmethod
    def sign_in_as_session_start(cls, val):
        """
        Create an instance of this class set to the ``sign_in_as_session_start``
        tag with value ``val``.

        :param SignInAsSessionStartType val:
        :rtype: EventType
        """
        return cls('sign_in_as_session_start', val)

    @classmethod
    def sso_error(cls, val):
        """
        Create an instance of this class set to the ``sso_error`` tag with value
        ``val``.

        :param SsoErrorType val:
        :rtype: EventType
        """
        return cls('sso_error', val)

    @classmethod
    def member_add_name(cls, val):
        """
        Create an instance of this class set to the ``member_add_name`` tag with
        value ``val``.

        :param MemberAddNameType val:
        :rtype: EventType
        """
        return cls('member_add_name', val)

    @classmethod
    def member_change_admin_role(cls, val):
        """
        Create an instance of this class set to the ``member_change_admin_role``
        tag with value ``val``.

        :param MemberChangeAdminRoleType val:
        :rtype: EventType
        """
        return cls('member_change_admin_role', val)

    @classmethod
    def member_change_email(cls, val):
        """
        Create an instance of this class set to the ``member_change_email`` tag
        with value ``val``.

        :param MemberChangeEmailType val:
        :rtype: EventType
        """
        return cls('member_change_email', val)

    @classmethod
    def member_change_membership_type(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_membership_type`` tag with value ``val``.

        :param MemberChangeMembershipTypeType val:
        :rtype: EventType
        """
        return cls('member_change_membership_type', val)

    @classmethod
    def member_change_name(cls, val):
        """
        Create an instance of this class set to the ``member_change_name`` tag
        with value ``val``.

        :param MemberChangeNameType val:
        :rtype: EventType
        """
        return cls('member_change_name', val)

    @classmethod
    def member_change_status(cls, val):
        """
        Create an instance of this class set to the ``member_change_status`` tag
        with value ``val``.

        :param MemberChangeStatusType val:
        :rtype: EventType
        """
        return cls('member_change_status', val)

    @classmethod
    def member_delete_manual_contacts(cls, val):
        """
        Create an instance of this class set to the
        ``member_delete_manual_contacts`` tag with value ``val``.

        :param MemberDeleteManualContactsType val:
        :rtype: EventType
        """
        return cls('member_delete_manual_contacts', val)

    @classmethod
    def member_permanently_delete_account_contents(cls, val):
        """
        Create an instance of this class set to the
        ``member_permanently_delete_account_contents`` tag with value ``val``.

        :param MemberPermanentlyDeleteAccountContentsType val:
        :rtype: EventType
        """
        return cls('member_permanently_delete_account_contents', val)

    @classmethod
    def member_space_limits_add_custom_quota(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_add_custom_quota`` tag with value ``val``.

        :param MemberSpaceLimitsAddCustomQuotaType val:
        :rtype: EventType
        """
        return cls('member_space_limits_add_custom_quota', val)

    @classmethod
    def member_space_limits_change_custom_quota(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_custom_quota`` tag with value ``val``.

        :param MemberSpaceLimitsChangeCustomQuotaType val:
        :rtype: EventType
        """
        return cls('member_space_limits_change_custom_quota', val)

    @classmethod
    def member_space_limits_change_status(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_status`` tag with value ``val``.

        :param MemberSpaceLimitsChangeStatusType val:
        :rtype: EventType
        """
        return cls('member_space_limits_change_status', val)

    @classmethod
    def member_space_limits_remove_custom_quota(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_remove_custom_quota`` tag with value ``val``.

        :param MemberSpaceLimitsRemoveCustomQuotaType val:
        :rtype: EventType
        """
        return cls('member_space_limits_remove_custom_quota', val)

    @classmethod
    def member_suggest(cls, val):
        """
        Create an instance of this class set to the ``member_suggest`` tag with
        value ``val``.

        :param MemberSuggestType val:
        :rtype: EventType
        """
        return cls('member_suggest', val)

    @classmethod
    def member_transfer_account_contents(cls, val):
        """
        Create an instance of this class set to the
        ``member_transfer_account_contents`` tag with value ``val``.

        :param MemberTransferAccountContentsType val:
        :rtype: EventType
        """
        return cls('member_transfer_account_contents', val)

    @classmethod
    def secondary_mails_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``secondary_mails_policy_changed`` tag with value ``val``.

        :param SecondaryMailsPolicyChangedType val:
        :rtype: EventType
        """
        return cls('secondary_mails_policy_changed', val)

    @classmethod
    def paper_content_add_member(cls, val):
        """
        Create an instance of this class set to the ``paper_content_add_member``
        tag with value ``val``.

        :param PaperContentAddMemberType val:
        :rtype: EventType
        """
        return cls('paper_content_add_member', val)

    @classmethod
    def paper_content_add_to_folder(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_add_to_folder`` tag with value ``val``.

        :param PaperContentAddToFolderType val:
        :rtype: EventType
        """
        return cls('paper_content_add_to_folder', val)

    @classmethod
    def paper_content_archive(cls, val):
        """
        Create an instance of this class set to the ``paper_content_archive``
        tag with value ``val``.

        :param PaperContentArchiveType val:
        :rtype: EventType
        """
        return cls('paper_content_archive', val)

    @classmethod
    def paper_content_create(cls, val):
        """
        Create an instance of this class set to the ``paper_content_create`` tag
        with value ``val``.

        :param PaperContentCreateType val:
        :rtype: EventType
        """
        return cls('paper_content_create', val)

    @classmethod
    def paper_content_permanently_delete(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_permanently_delete`` tag with value ``val``.

        :param PaperContentPermanentlyDeleteType val:
        :rtype: EventType
        """
        return cls('paper_content_permanently_delete', val)

    @classmethod
    def paper_content_remove_from_folder(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_remove_from_folder`` tag with value ``val``.

        :param PaperContentRemoveFromFolderType val:
        :rtype: EventType
        """
        return cls('paper_content_remove_from_folder', val)

    @classmethod
    def paper_content_remove_member(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_remove_member`` tag with value ``val``.

        :param PaperContentRemoveMemberType val:
        :rtype: EventType
        """
        return cls('paper_content_remove_member', val)

    @classmethod
    def paper_content_rename(cls, val):
        """
        Create an instance of this class set to the ``paper_content_rename`` tag
        with value ``val``.

        :param PaperContentRenameType val:
        :rtype: EventType
        """
        return cls('paper_content_rename', val)

    @classmethod
    def paper_content_restore(cls, val):
        """
        Create an instance of this class set to the ``paper_content_restore``
        tag with value ``val``.

        :param PaperContentRestoreType val:
        :rtype: EventType
        """
        return cls('paper_content_restore', val)

    @classmethod
    def paper_doc_add_comment(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_add_comment``
        tag with value ``val``.

        :param PaperDocAddCommentType val:
        :rtype: EventType
        """
        return cls('paper_doc_add_comment', val)

    @classmethod
    def paper_doc_change_member_role(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_member_role`` tag with value ``val``.

        :param PaperDocChangeMemberRoleType val:
        :rtype: EventType
        """
        return cls('paper_doc_change_member_role', val)

    @classmethod
    def paper_doc_change_sharing_policy(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_sharing_policy`` tag with value ``val``.

        :param PaperDocChangeSharingPolicyType val:
        :rtype: EventType
        """
        return cls('paper_doc_change_sharing_policy', val)

    @classmethod
    def paper_doc_change_subscription(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_subscription`` tag with value ``val``.

        :param PaperDocChangeSubscriptionType val:
        :rtype: EventType
        """
        return cls('paper_doc_change_subscription', val)

    @classmethod
    def paper_doc_deleted(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_deleted`` tag
        with value ``val``.

        :param PaperDocDeletedType val:
        :rtype: EventType
        """
        return cls('paper_doc_deleted', val)

    @classmethod
    def paper_doc_delete_comment(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_delete_comment``
        tag with value ``val``.

        :param PaperDocDeleteCommentType val:
        :rtype: EventType
        """
        return cls('paper_doc_delete_comment', val)

    @classmethod
    def paper_doc_download(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_download`` tag
        with value ``val``.

        :param PaperDocDownloadType val:
        :rtype: EventType
        """
        return cls('paper_doc_download', val)

    @classmethod
    def paper_doc_edit(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_edit`` tag with
        value ``val``.

        :param PaperDocEditType val:
        :rtype: EventType
        """
        return cls('paper_doc_edit', val)

    @classmethod
    def paper_doc_edit_comment(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_edit_comment``
        tag with value ``val``.

        :param PaperDocEditCommentType val:
        :rtype: EventType
        """
        return cls('paper_doc_edit_comment', val)

    @classmethod
    def paper_doc_followed(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_followed`` tag
        with value ``val``.

        :param PaperDocFollowedType val:
        :rtype: EventType
        """
        return cls('paper_doc_followed', val)

    @classmethod
    def paper_doc_mention(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_mention`` tag
        with value ``val``.

        :param PaperDocMentionType val:
        :rtype: EventType
        """
        return cls('paper_doc_mention', val)

    @classmethod
    def paper_doc_ownership_changed(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_ownership_changed`` tag with value ``val``.

        :param PaperDocOwnershipChangedType val:
        :rtype: EventType
        """
        return cls('paper_doc_ownership_changed', val)

    @classmethod
    def paper_doc_request_access(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_request_access``
        tag with value ``val``.

        :param PaperDocRequestAccessType val:
        :rtype: EventType
        """
        return cls('paper_doc_request_access', val)

    @classmethod
    def paper_doc_resolve_comment(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_resolve_comment`` tag with value ``val``.

        :param PaperDocResolveCommentType val:
        :rtype: EventType
        """
        return cls('paper_doc_resolve_comment', val)

    @classmethod
    def paper_doc_revert(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_revert`` tag
        with value ``val``.

        :param PaperDocRevertType val:
        :rtype: EventType
        """
        return cls('paper_doc_revert', val)

    @classmethod
    def paper_doc_slack_share(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_slack_share``
        tag with value ``val``.

        :param PaperDocSlackShareType val:
        :rtype: EventType
        """
        return cls('paper_doc_slack_share', val)

    @classmethod
    def paper_doc_team_invite(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_team_invite``
        tag with value ``val``.

        :param PaperDocTeamInviteType val:
        :rtype: EventType
        """
        return cls('paper_doc_team_invite', val)

    @classmethod
    def paper_doc_trashed(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_trashed`` tag
        with value ``val``.

        :param PaperDocTrashedType val:
        :rtype: EventType
        """
        return cls('paper_doc_trashed', val)

    @classmethod
    def paper_doc_unresolve_comment(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_unresolve_comment`` tag with value ``val``.

        :param PaperDocUnresolveCommentType val:
        :rtype: EventType
        """
        return cls('paper_doc_unresolve_comment', val)

    @classmethod
    def paper_doc_untrashed(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_untrashed`` tag
        with value ``val``.

        :param PaperDocUntrashedType val:
        :rtype: EventType
        """
        return cls('paper_doc_untrashed', val)

    @classmethod
    def paper_doc_view(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_view`` tag with
        value ``val``.

        :param PaperDocViewType val:
        :rtype: EventType
        """
        return cls('paper_doc_view', val)

    @classmethod
    def paper_external_view_allow(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_allow`` tag with value ``val``.

        :param PaperExternalViewAllowType val:
        :rtype: EventType
        """
        return cls('paper_external_view_allow', val)

    @classmethod
    def paper_external_view_default_team(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_default_team`` tag with value ``val``.

        :param PaperExternalViewDefaultTeamType val:
        :rtype: EventType
        """
        return cls('paper_external_view_default_team', val)

    @classmethod
    def paper_external_view_forbid(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_forbid`` tag with value ``val``.

        :param PaperExternalViewForbidType val:
        :rtype: EventType
        """
        return cls('paper_external_view_forbid', val)

    @classmethod
    def paper_folder_change_subscription(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_change_subscription`` tag with value ``val``.

        :param PaperFolderChangeSubscriptionType val:
        :rtype: EventType
        """
        return cls('paper_folder_change_subscription', val)

    @classmethod
    def paper_folder_deleted(cls, val):
        """
        Create an instance of this class set to the ``paper_folder_deleted`` tag
        with value ``val``.

        :param PaperFolderDeletedType val:
        :rtype: EventType
        """
        return cls('paper_folder_deleted', val)

    @classmethod
    def paper_folder_followed(cls, val):
        """
        Create an instance of this class set to the ``paper_folder_followed``
        tag with value ``val``.

        :param PaperFolderFollowedType val:
        :rtype: EventType
        """
        return cls('paper_folder_followed', val)

    @classmethod
    def paper_folder_team_invite(cls, val):
        """
        Create an instance of this class set to the ``paper_folder_team_invite``
        tag with value ``val``.

        :param PaperFolderTeamInviteType val:
        :rtype: EventType
        """
        return cls('paper_folder_team_invite', val)

    @classmethod
    def password_change(cls, val):
        """
        Create an instance of this class set to the ``password_change`` tag with
        value ``val``.

        :param PasswordChangeType val:
        :rtype: EventType
        """
        return cls('password_change', val)

    @classmethod
    def password_reset(cls, val):
        """
        Create an instance of this class set to the ``password_reset`` tag with
        value ``val``.

        :param PasswordResetType val:
        :rtype: EventType
        """
        return cls('password_reset', val)

    @classmethod
    def password_reset_all(cls, val):
        """
        Create an instance of this class set to the ``password_reset_all`` tag
        with value ``val``.

        :param PasswordResetAllType val:
        :rtype: EventType
        """
        return cls('password_reset_all', val)

    @classmethod
    def emm_create_exceptions_report(cls, val):
        """
        Create an instance of this class set to the
        ``emm_create_exceptions_report`` tag with value ``val``.

        :param EmmCreateExceptionsReportType val:
        :rtype: EventType
        """
        return cls('emm_create_exceptions_report', val)

    @classmethod
    def emm_create_usage_report(cls, val):
        """
        Create an instance of this class set to the ``emm_create_usage_report``
        tag with value ``val``.

        :param EmmCreateUsageReportType val:
        :rtype: EventType
        """
        return cls('emm_create_usage_report', val)

    @classmethod
    def export_members_report(cls, val):
        """
        Create an instance of this class set to the ``export_members_report``
        tag with value ``val``.

        :param ExportMembersReportType val:
        :rtype: EventType
        """
        return cls('export_members_report', val)

    @classmethod
    def paper_admin_export_start(cls, val):
        """
        Create an instance of this class set to the ``paper_admin_export_start``
        tag with value ``val``.

        :param PaperAdminExportStartType val:
        :rtype: EventType
        """
        return cls('paper_admin_export_start', val)

    @classmethod
    def smart_sync_create_admin_privilege_report(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_create_admin_privilege_report`` tag with value ``val``.

        :param SmartSyncCreateAdminPrivilegeReportType val:
        :rtype: EventType
        """
        return cls('smart_sync_create_admin_privilege_report', val)

    @classmethod
    def team_activity_create_report(cls, val):
        """
        Create an instance of this class set to the
        ``team_activity_create_report`` tag with value ``val``.

        :param TeamActivityCreateReportType val:
        :rtype: EventType
        """
        return cls('team_activity_create_report', val)

    @classmethod
    def collection_share(cls, val):
        """
        Create an instance of this class set to the ``collection_share`` tag
        with value ``val``.

        :param CollectionShareType val:
        :rtype: EventType
        """
        return cls('collection_share', val)

    @classmethod
    def note_acl_invite_only(cls, val):
        """
        Create an instance of this class set to the ``note_acl_invite_only`` tag
        with value ``val``.

        :param NoteAclInviteOnlyType val:
        :rtype: EventType
        """
        return cls('note_acl_invite_only', val)

    @classmethod
    def note_acl_link(cls, val):
        """
        Create an instance of this class set to the ``note_acl_link`` tag with
        value ``val``.

        :param NoteAclLinkType val:
        :rtype: EventType
        """
        return cls('note_acl_link', val)

    @classmethod
    def note_acl_team_link(cls, val):
        """
        Create an instance of this class set to the ``note_acl_team_link`` tag
        with value ``val``.

        :param NoteAclTeamLinkType val:
        :rtype: EventType
        """
        return cls('note_acl_team_link', val)

    @classmethod
    def note_shared(cls, val):
        """
        Create an instance of this class set to the ``note_shared`` tag with
        value ``val``.

        :param NoteSharedType val:
        :rtype: EventType
        """
        return cls('note_shared', val)

    @classmethod
    def note_share_receive(cls, val):
        """
        Create an instance of this class set to the ``note_share_receive`` tag
        with value ``val``.

        :param NoteShareReceiveType val:
        :rtype: EventType
        """
        return cls('note_share_receive', val)

    @classmethod
    def open_note_shared(cls, val):
        """
        Create an instance of this class set to the ``open_note_shared`` tag
        with value ``val``.

        :param OpenNoteSharedType val:
        :rtype: EventType
        """
        return cls('open_note_shared', val)

    @classmethod
    def sf_add_group(cls, val):
        """
        Create an instance of this class set to the ``sf_add_group`` tag with
        value ``val``.

        :param SfAddGroupType val:
        :rtype: EventType
        """
        return cls('sf_add_group', val)

    @classmethod
    def sf_allow_non_members_to_view_shared_links(cls, val):
        """
        Create an instance of this class set to the
        ``sf_allow_non_members_to_view_shared_links`` tag with value ``val``.

        :param SfAllowNonMembersToViewSharedLinksType val:
        :rtype: EventType
        """
        return cls('sf_allow_non_members_to_view_shared_links', val)

    @classmethod
    def sf_external_invite_warn(cls, val):
        """
        Create an instance of this class set to the ``sf_external_invite_warn``
        tag with value ``val``.

        :param SfExternalInviteWarnType val:
        :rtype: EventType
        """
        return cls('sf_external_invite_warn', val)

    @classmethod
    def sf_fb_invite(cls, val):
        """
        Create an instance of this class set to the ``sf_fb_invite`` tag with
        value ``val``.

        :param SfFbInviteType val:
        :rtype: EventType
        """
        return cls('sf_fb_invite', val)

    @classmethod
    def sf_fb_invite_change_role(cls, val):
        """
        Create an instance of this class set to the ``sf_fb_invite_change_role``
        tag with value ``val``.

        :param SfFbInviteChangeRoleType val:
        :rtype: EventType
        """
        return cls('sf_fb_invite_change_role', val)

    @classmethod
    def sf_fb_uninvite(cls, val):
        """
        Create an instance of this class set to the ``sf_fb_uninvite`` tag with
        value ``val``.

        :param SfFbUninviteType val:
        :rtype: EventType
        """
        return cls('sf_fb_uninvite', val)

    @classmethod
    def sf_invite_group(cls, val):
        """
        Create an instance of this class set to the ``sf_invite_group`` tag with
        value ``val``.

        :param SfInviteGroupType val:
        :rtype: EventType
        """
        return cls('sf_invite_group', val)

    @classmethod
    def sf_team_grant_access(cls, val):
        """
        Create an instance of this class set to the ``sf_team_grant_access`` tag
        with value ``val``.

        :param SfTeamGrantAccessType val:
        :rtype: EventType
        """
        return cls('sf_team_grant_access', val)

    @classmethod
    def sf_team_invite(cls, val):
        """
        Create an instance of this class set to the ``sf_team_invite`` tag with
        value ``val``.

        :param SfTeamInviteType val:
        :rtype: EventType
        """
        return cls('sf_team_invite', val)

    @classmethod
    def sf_team_invite_change_role(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_invite_change_role`` tag with value ``val``.

        :param SfTeamInviteChangeRoleType val:
        :rtype: EventType
        """
        return cls('sf_team_invite_change_role', val)

    @classmethod
    def sf_team_join(cls, val):
        """
        Create an instance of this class set to the ``sf_team_join`` tag with
        value ``val``.

        :param SfTeamJoinType val:
        :rtype: EventType
        """
        return cls('sf_team_join', val)

    @classmethod
    def sf_team_join_from_oob_link(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_join_from_oob_link`` tag with value ``val``.

        :param SfTeamJoinFromOobLinkType val:
        :rtype: EventType
        """
        return cls('sf_team_join_from_oob_link', val)

    @classmethod
    def sf_team_uninvite(cls, val):
        """
        Create an instance of this class set to the ``sf_team_uninvite`` tag
        with value ``val``.

        :param SfTeamUninviteType val:
        :rtype: EventType
        """
        return cls('sf_team_uninvite', val)

    @classmethod
    def shared_content_add_invitees(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_invitees`` tag with value ``val``.

        :param SharedContentAddInviteesType val:
        :rtype: EventType
        """
        return cls('shared_content_add_invitees', val)

    @classmethod
    def shared_content_add_link_expiry(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_link_expiry`` tag with value ``val``.

        :param SharedContentAddLinkExpiryType val:
        :rtype: EventType
        """
        return cls('shared_content_add_link_expiry', val)

    @classmethod
    def shared_content_add_link_password(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_link_password`` tag with value ``val``.

        :param SharedContentAddLinkPasswordType val:
        :rtype: EventType
        """
        return cls('shared_content_add_link_password', val)

    @classmethod
    def shared_content_add_member(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_member`` tag with value ``val``.

        :param SharedContentAddMemberType val:
        :rtype: EventType
        """
        return cls('shared_content_add_member', val)

    @classmethod
    def shared_content_change_downloads_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_downloads_policy`` tag with value ``val``.

        :param SharedContentChangeDownloadsPolicyType val:
        :rtype: EventType
        """
        return cls('shared_content_change_downloads_policy', val)

    @classmethod
    def shared_content_change_invitee_role(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_invitee_role`` tag with value ``val``.

        :param SharedContentChangeInviteeRoleType val:
        :rtype: EventType
        """
        return cls('shared_content_change_invitee_role', val)

    @classmethod
    def shared_content_change_link_audience(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_audience`` tag with value ``val``.

        :param SharedContentChangeLinkAudienceType val:
        :rtype: EventType
        """
        return cls('shared_content_change_link_audience', val)

    @classmethod
    def shared_content_change_link_expiry(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_expiry`` tag with value ``val``.

        :param SharedContentChangeLinkExpiryType val:
        :rtype: EventType
        """
        return cls('shared_content_change_link_expiry', val)

    @classmethod
    def shared_content_change_link_password(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_password`` tag with value ``val``.

        :param SharedContentChangeLinkPasswordType val:
        :rtype: EventType
        """
        return cls('shared_content_change_link_password', val)

    @classmethod
    def shared_content_change_member_role(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_member_role`` tag with value ``val``.

        :param SharedContentChangeMemberRoleType val:
        :rtype: EventType
        """
        return cls('shared_content_change_member_role', val)

    @classmethod
    def shared_content_change_viewer_info_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_viewer_info_policy`` tag with value ``val``.

        :param SharedContentChangeViewerInfoPolicyType val:
        :rtype: EventType
        """
        return cls('shared_content_change_viewer_info_policy', val)

    @classmethod
    def shared_content_claim_invitation(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_claim_invitation`` tag with value ``val``.

        :param SharedContentClaimInvitationType val:
        :rtype: EventType
        """
        return cls('shared_content_claim_invitation', val)

    @classmethod
    def shared_content_copy(cls, val):
        """
        Create an instance of this class set to the ``shared_content_copy`` tag
        with value ``val``.

        :param SharedContentCopyType val:
        :rtype: EventType
        """
        return cls('shared_content_copy', val)

    @classmethod
    def shared_content_download(cls, val):
        """
        Create an instance of this class set to the ``shared_content_download``
        tag with value ``val``.

        :param SharedContentDownloadType val:
        :rtype: EventType
        """
        return cls('shared_content_download', val)

    @classmethod
    def shared_content_relinquish_membership(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_relinquish_membership`` tag with value ``val``.

        :param SharedContentRelinquishMembershipType val:
        :rtype: EventType
        """
        return cls('shared_content_relinquish_membership', val)

    @classmethod
    def shared_content_remove_invitees(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_invitees`` tag with value ``val``.

        :param SharedContentRemoveInviteesType val:
        :rtype: EventType
        """
        return cls('shared_content_remove_invitees', val)

    @classmethod
    def shared_content_remove_link_expiry(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_link_expiry`` tag with value ``val``.

        :param SharedContentRemoveLinkExpiryType val:
        :rtype: EventType
        """
        return cls('shared_content_remove_link_expiry', val)

    @classmethod
    def shared_content_remove_link_password(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_link_password`` tag with value ``val``.

        :param SharedContentRemoveLinkPasswordType val:
        :rtype: EventType
        """
        return cls('shared_content_remove_link_password', val)

    @classmethod
    def shared_content_remove_member(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_member`` tag with value ``val``.

        :param SharedContentRemoveMemberType val:
        :rtype: EventType
        """
        return cls('shared_content_remove_member', val)

    @classmethod
    def shared_content_request_access(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_request_access`` tag with value ``val``.

        :param SharedContentRequestAccessType val:
        :rtype: EventType
        """
        return cls('shared_content_request_access', val)

    @classmethod
    def shared_content_unshare(cls, val):
        """
        Create an instance of this class set to the ``shared_content_unshare``
        tag with value ``val``.

        :param SharedContentUnshareType val:
        :rtype: EventType
        """
        return cls('shared_content_unshare', val)

    @classmethod
    def shared_content_view(cls, val):
        """
        Create an instance of this class set to the ``shared_content_view`` tag
        with value ``val``.

        :param SharedContentViewType val:
        :rtype: EventType
        """
        return cls('shared_content_view', val)

    @classmethod
    def shared_folder_change_link_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_link_policy`` tag with value ``val``.

        :param SharedFolderChangeLinkPolicyType val:
        :rtype: EventType
        """
        return cls('shared_folder_change_link_policy', val)

    @classmethod
    def shared_folder_change_members_inheritance_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_inheritance_policy`` tag with value
        ``val``.

        :param SharedFolderChangeMembersInheritancePolicyType val:
        :rtype: EventType
        """
        return cls('shared_folder_change_members_inheritance_policy', val)

    @classmethod
    def shared_folder_change_members_management_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_management_policy`` tag with value
        ``val``.

        :param SharedFolderChangeMembersManagementPolicyType val:
        :rtype: EventType
        """
        return cls('shared_folder_change_members_management_policy', val)

    @classmethod
    def shared_folder_change_members_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_policy`` tag with value ``val``.

        :param SharedFolderChangeMembersPolicyType val:
        :rtype: EventType
        """
        return cls('shared_folder_change_members_policy', val)

    @classmethod
    def shared_folder_create(cls, val):
        """
        Create an instance of this class set to the ``shared_folder_create`` tag
        with value ``val``.

        :param SharedFolderCreateType val:
        :rtype: EventType
        """
        return cls('shared_folder_create', val)

    @classmethod
    def shared_folder_decline_invitation(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_decline_invitation`` tag with value ``val``.

        :param SharedFolderDeclineInvitationType val:
        :rtype: EventType
        """
        return cls('shared_folder_decline_invitation', val)

    @classmethod
    def shared_folder_mount(cls, val):
        """
        Create an instance of this class set to the ``shared_folder_mount`` tag
        with value ``val``.

        :param SharedFolderMountType val:
        :rtype: EventType
        """
        return cls('shared_folder_mount', val)

    @classmethod
    def shared_folder_nest(cls, val):
        """
        Create an instance of this class set to the ``shared_folder_nest`` tag
        with value ``val``.

        :param SharedFolderNestType val:
        :rtype: EventType
        """
        return cls('shared_folder_nest', val)

    @classmethod
    def shared_folder_transfer_ownership(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_transfer_ownership`` tag with value ``val``.

        :param SharedFolderTransferOwnershipType val:
        :rtype: EventType
        """
        return cls('shared_folder_transfer_ownership', val)

    @classmethod
    def shared_folder_unmount(cls, val):
        """
        Create an instance of this class set to the ``shared_folder_unmount``
        tag with value ``val``.

        :param SharedFolderUnmountType val:
        :rtype: EventType
        """
        return cls('shared_folder_unmount', val)

    @classmethod
    def shared_link_add_expiry(cls, val):
        """
        Create an instance of this class set to the ``shared_link_add_expiry``
        tag with value ``val``.

        :param SharedLinkAddExpiryType val:
        :rtype: EventType
        """
        return cls('shared_link_add_expiry', val)

    @classmethod
    def shared_link_change_expiry(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_change_expiry`` tag with value ``val``.

        :param SharedLinkChangeExpiryType val:
        :rtype: EventType
        """
        return cls('shared_link_change_expiry', val)

    @classmethod
    def shared_link_change_visibility(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_change_visibility`` tag with value ``val``.

        :param SharedLinkChangeVisibilityType val:
        :rtype: EventType
        """
        return cls('shared_link_change_visibility', val)

    @classmethod
    def shared_link_copy(cls, val):
        """
        Create an instance of this class set to the ``shared_link_copy`` tag
        with value ``val``.

        :param SharedLinkCopyType val:
        :rtype: EventType
        """
        return cls('shared_link_copy', val)

    @classmethod
    def shared_link_create(cls, val):
        """
        Create an instance of this class set to the ``shared_link_create`` tag
        with value ``val``.

        :param SharedLinkCreateType val:
        :rtype: EventType
        """
        return cls('shared_link_create', val)

    @classmethod
    def shared_link_disable(cls, val):
        """
        Create an instance of this class set to the ``shared_link_disable`` tag
        with value ``val``.

        :param SharedLinkDisableType val:
        :rtype: EventType
        """
        return cls('shared_link_disable', val)

    @classmethod
    def shared_link_download(cls, val):
        """
        Create an instance of this class set to the ``shared_link_download`` tag
        with value ``val``.

        :param SharedLinkDownloadType val:
        :rtype: EventType
        """
        return cls('shared_link_download', val)

    @classmethod
    def shared_link_remove_expiry(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_remove_expiry`` tag with value ``val``.

        :param SharedLinkRemoveExpiryType val:
        :rtype: EventType
        """
        return cls('shared_link_remove_expiry', val)

    @classmethod
    def shared_link_share(cls, val):
        """
        Create an instance of this class set to the ``shared_link_share`` tag
        with value ``val``.

        :param SharedLinkShareType val:
        :rtype: EventType
        """
        return cls('shared_link_share', val)

    @classmethod
    def shared_link_view(cls, val):
        """
        Create an instance of this class set to the ``shared_link_view`` tag
        with value ``val``.

        :param SharedLinkViewType val:
        :rtype: EventType
        """
        return cls('shared_link_view', val)

    @classmethod
    def shared_note_opened(cls, val):
        """
        Create an instance of this class set to the ``shared_note_opened`` tag
        with value ``val``.

        :param SharedNoteOpenedType val:
        :rtype: EventType
        """
        return cls('shared_note_opened', val)

    @classmethod
    def shmodel_group_share(cls, val):
        """
        Create an instance of this class set to the ``shmodel_group_share`` tag
        with value ``val``.

        :param ShmodelGroupShareType val:
        :rtype: EventType
        """
        return cls('shmodel_group_share', val)

    @classmethod
    def showcase_access_granted(cls, val):
        """
        Create an instance of this class set to the ``showcase_access_granted``
        tag with value ``val``.

        :param ShowcaseAccessGrantedType val:
        :rtype: EventType
        """
        return cls('showcase_access_granted', val)

    @classmethod
    def showcase_add_member(cls, val):
        """
        Create an instance of this class set to the ``showcase_add_member`` tag
        with value ``val``.

        :param ShowcaseAddMemberType val:
        :rtype: EventType
        """
        return cls('showcase_add_member', val)

    @classmethod
    def showcase_archived(cls, val):
        """
        Create an instance of this class set to the ``showcase_archived`` tag
        with value ``val``.

        :param ShowcaseArchivedType val:
        :rtype: EventType
        """
        return cls('showcase_archived', val)

    @classmethod
    def showcase_created(cls, val):
        """
        Create an instance of this class set to the ``showcase_created`` tag
        with value ``val``.

        :param ShowcaseCreatedType val:
        :rtype: EventType
        """
        return cls('showcase_created', val)

    @classmethod
    def showcase_delete_comment(cls, val):
        """
        Create an instance of this class set to the ``showcase_delete_comment``
        tag with value ``val``.

        :param ShowcaseDeleteCommentType val:
        :rtype: EventType
        """
        return cls('showcase_delete_comment', val)

    @classmethod
    def showcase_edited(cls, val):
        """
        Create an instance of this class set to the ``showcase_edited`` tag with
        value ``val``.

        :param ShowcaseEditedType val:
        :rtype: EventType
        """
        return cls('showcase_edited', val)

    @classmethod
    def showcase_edit_comment(cls, val):
        """
        Create an instance of this class set to the ``showcase_edit_comment``
        tag with value ``val``.

        :param ShowcaseEditCommentType val:
        :rtype: EventType
        """
        return cls('showcase_edit_comment', val)

    @classmethod
    def showcase_file_added(cls, val):
        """
        Create an instance of this class set to the ``showcase_file_added`` tag
        with value ``val``.

        :param ShowcaseFileAddedType val:
        :rtype: EventType
        """
        return cls('showcase_file_added', val)

    @classmethod
    def showcase_file_download(cls, val):
        """
        Create an instance of this class set to the ``showcase_file_download``
        tag with value ``val``.

        :param ShowcaseFileDownloadType val:
        :rtype: EventType
        """
        return cls('showcase_file_download', val)

    @classmethod
    def showcase_file_removed(cls, val):
        """
        Create an instance of this class set to the ``showcase_file_removed``
        tag with value ``val``.

        :param ShowcaseFileRemovedType val:
        :rtype: EventType
        """
        return cls('showcase_file_removed', val)

    @classmethod
    def showcase_file_view(cls, val):
        """
        Create an instance of this class set to the ``showcase_file_view`` tag
        with value ``val``.

        :param ShowcaseFileViewType val:
        :rtype: EventType
        """
        return cls('showcase_file_view', val)

    @classmethod
    def showcase_permanently_deleted(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_permanently_deleted`` tag with value ``val``.

        :param ShowcasePermanentlyDeletedType val:
        :rtype: EventType
        """
        return cls('showcase_permanently_deleted', val)

    @classmethod
    def showcase_post_comment(cls, val):
        """
        Create an instance of this class set to the ``showcase_post_comment``
        tag with value ``val``.

        :param ShowcasePostCommentType val:
        :rtype: EventType
        """
        return cls('showcase_post_comment', val)

    @classmethod
    def showcase_remove_member(cls, val):
        """
        Create an instance of this class set to the ``showcase_remove_member``
        tag with value ``val``.

        :param ShowcaseRemoveMemberType val:
        :rtype: EventType
        """
        return cls('showcase_remove_member', val)

    @classmethod
    def showcase_renamed(cls, val):
        """
        Create an instance of this class set to the ``showcase_renamed`` tag
        with value ``val``.

        :param ShowcaseRenamedType val:
        :rtype: EventType
        """
        return cls('showcase_renamed', val)

    @classmethod
    def showcase_request_access(cls, val):
        """
        Create an instance of this class set to the ``showcase_request_access``
        tag with value ``val``.

        :param ShowcaseRequestAccessType val:
        :rtype: EventType
        """
        return cls('showcase_request_access', val)

    @classmethod
    def showcase_resolve_comment(cls, val):
        """
        Create an instance of this class set to the ``showcase_resolve_comment``
        tag with value ``val``.

        :param ShowcaseResolveCommentType val:
        :rtype: EventType
        """
        return cls('showcase_resolve_comment', val)

    @classmethod
    def showcase_restored(cls, val):
        """
        Create an instance of this class set to the ``showcase_restored`` tag
        with value ``val``.

        :param ShowcaseRestoredType val:
        :rtype: EventType
        """
        return cls('showcase_restored', val)

    @classmethod
    def showcase_trashed(cls, val):
        """
        Create an instance of this class set to the ``showcase_trashed`` tag
        with value ``val``.

        :param ShowcaseTrashedType val:
        :rtype: EventType
        """
        return cls('showcase_trashed', val)

    @classmethod
    def showcase_trashed_deprecated(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_trashed_deprecated`` tag with value ``val``.

        :param ShowcaseTrashedDeprecatedType val:
        :rtype: EventType
        """
        return cls('showcase_trashed_deprecated', val)

    @classmethod
    def showcase_unresolve_comment(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_unresolve_comment`` tag with value ``val``.

        :param ShowcaseUnresolveCommentType val:
        :rtype: EventType
        """
        return cls('showcase_unresolve_comment', val)

    @classmethod
    def showcase_untrashed(cls, val):
        """
        Create an instance of this class set to the ``showcase_untrashed`` tag
        with value ``val``.

        :param ShowcaseUntrashedType val:
        :rtype: EventType
        """
        return cls('showcase_untrashed', val)

    @classmethod
    def showcase_untrashed_deprecated(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_untrashed_deprecated`` tag with value ``val``.

        :param ShowcaseUntrashedDeprecatedType val:
        :rtype: EventType
        """
        return cls('showcase_untrashed_deprecated', val)

    @classmethod
    def showcase_view(cls, val):
        """
        Create an instance of this class set to the ``showcase_view`` tag with
        value ``val``.

        :param ShowcaseViewType val:
        :rtype: EventType
        """
        return cls('showcase_view', val)

    @classmethod
    def sso_add_cert(cls, val):
        """
        Create an instance of this class set to the ``sso_add_cert`` tag with
        value ``val``.

        :param SsoAddCertType val:
        :rtype: EventType
        """
        return cls('sso_add_cert', val)

    @classmethod
    def sso_add_login_url(cls, val):
        """
        Create an instance of this class set to the ``sso_add_login_url`` tag
        with value ``val``.

        :param SsoAddLoginUrlType val:
        :rtype: EventType
        """
        return cls('sso_add_login_url', val)

    @classmethod
    def sso_add_logout_url(cls, val):
        """
        Create an instance of this class set to the ``sso_add_logout_url`` tag
        with value ``val``.

        :param SsoAddLogoutUrlType val:
        :rtype: EventType
        """
        return cls('sso_add_logout_url', val)

    @classmethod
    def sso_change_cert(cls, val):
        """
        Create an instance of this class set to the ``sso_change_cert`` tag with
        value ``val``.

        :param SsoChangeCertType val:
        :rtype: EventType
        """
        return cls('sso_change_cert', val)

    @classmethod
    def sso_change_login_url(cls, val):
        """
        Create an instance of this class set to the ``sso_change_login_url`` tag
        with value ``val``.

        :param SsoChangeLoginUrlType val:
        :rtype: EventType
        """
        return cls('sso_change_login_url', val)

    @classmethod
    def sso_change_logout_url(cls, val):
        """
        Create an instance of this class set to the ``sso_change_logout_url``
        tag with value ``val``.

        :param SsoChangeLogoutUrlType val:
        :rtype: EventType
        """
        return cls('sso_change_logout_url', val)

    @classmethod
    def sso_change_saml_identity_mode(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_saml_identity_mode`` tag with value ``val``.

        :param SsoChangeSamlIdentityModeType val:
        :rtype: EventType
        """
        return cls('sso_change_saml_identity_mode', val)

    @classmethod
    def sso_remove_cert(cls, val):
        """
        Create an instance of this class set to the ``sso_remove_cert`` tag with
        value ``val``.

        :param SsoRemoveCertType val:
        :rtype: EventType
        """
        return cls('sso_remove_cert', val)

    @classmethod
    def sso_remove_login_url(cls, val):
        """
        Create an instance of this class set to the ``sso_remove_login_url`` tag
        with value ``val``.

        :param SsoRemoveLoginUrlType val:
        :rtype: EventType
        """
        return cls('sso_remove_login_url', val)

    @classmethod
    def sso_remove_logout_url(cls, val):
        """
        Create an instance of this class set to the ``sso_remove_logout_url``
        tag with value ``val``.

        :param SsoRemoveLogoutUrlType val:
        :rtype: EventType
        """
        return cls('sso_remove_logout_url', val)

    @classmethod
    def team_folder_change_status(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_change_status`` tag with value ``val``.

        :param TeamFolderChangeStatusType val:
        :rtype: EventType
        """
        return cls('team_folder_change_status', val)

    @classmethod
    def team_folder_create(cls, val):
        """
        Create an instance of this class set to the ``team_folder_create`` tag
        with value ``val``.

        :param TeamFolderCreateType val:
        :rtype: EventType
        """
        return cls('team_folder_create', val)

    @classmethod
    def team_folder_downgrade(cls, val):
        """
        Create an instance of this class set to the ``team_folder_downgrade``
        tag with value ``val``.

        :param TeamFolderDowngradeType val:
        :rtype: EventType
        """
        return cls('team_folder_downgrade', val)

    @classmethod
    def team_folder_permanently_delete(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_permanently_delete`` tag with value ``val``.

        :param TeamFolderPermanentlyDeleteType val:
        :rtype: EventType
        """
        return cls('team_folder_permanently_delete', val)

    @classmethod
    def team_folder_rename(cls, val):
        """
        Create an instance of this class set to the ``team_folder_rename`` tag
        with value ``val``.

        :param TeamFolderRenameType val:
        :rtype: EventType
        """
        return cls('team_folder_rename', val)

    @classmethod
    def team_selective_sync_settings_changed(cls, val):
        """
        Create an instance of this class set to the
        ``team_selective_sync_settings_changed`` tag with value ``val``.

        :param TeamSelectiveSyncSettingsChangedType val:
        :rtype: EventType
        """
        return cls('team_selective_sync_settings_changed', val)

    @classmethod
    def account_capture_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_change_policy`` tag with value ``val``.

        :param AccountCaptureChangePolicyType val:
        :rtype: EventType
        """
        return cls('account_capture_change_policy', val)

    @classmethod
    def allow_download_disabled(cls, val):
        """
        Create an instance of this class set to the ``allow_download_disabled``
        tag with value ``val``.

        :param AllowDownloadDisabledType val:
        :rtype: EventType
        """
        return cls('allow_download_disabled', val)

    @classmethod
    def allow_download_enabled(cls, val):
        """
        Create an instance of this class set to the ``allow_download_enabled``
        tag with value ``val``.

        :param AllowDownloadEnabledType val:
        :rtype: EventType
        """
        return cls('allow_download_enabled', val)

    @classmethod
    def data_placement_restriction_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``data_placement_restriction_change_policy`` tag with value ``val``.

        :param DataPlacementRestrictionChangePolicyType val:
        :rtype: EventType
        """
        return cls('data_placement_restriction_change_policy', val)

    @classmethod
    def data_placement_restriction_satisfy_policy(cls, val):
        """
        Create an instance of this class set to the
        ``data_placement_restriction_satisfy_policy`` tag with value ``val``.

        :param DataPlacementRestrictionSatisfyPolicyType val:
        :rtype: EventType
        """
        return cls('data_placement_restriction_satisfy_policy', val)

    @classmethod
    def device_approvals_change_desktop_policy(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_desktop_policy`` tag with value ``val``.

        :param DeviceApprovalsChangeDesktopPolicyType val:
        :rtype: EventType
        """
        return cls('device_approvals_change_desktop_policy', val)

    @classmethod
    def device_approvals_change_mobile_policy(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_mobile_policy`` tag with value ``val``.

        :param DeviceApprovalsChangeMobilePolicyType val:
        :rtype: EventType
        """
        return cls('device_approvals_change_mobile_policy', val)

    @classmethod
    def device_approvals_change_overage_action(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_overage_action`` tag with value ``val``.

        :param DeviceApprovalsChangeOverageActionType val:
        :rtype: EventType
        """
        return cls('device_approvals_change_overage_action', val)

    @classmethod
    def device_approvals_change_unlink_action(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_unlink_action`` tag with value ``val``.

        :param DeviceApprovalsChangeUnlinkActionType val:
        :rtype: EventType
        """
        return cls('device_approvals_change_unlink_action', val)

    @classmethod
    def directory_restrictions_add_members(cls, val):
        """
        Create an instance of this class set to the
        ``directory_restrictions_add_members`` tag with value ``val``.

        :param DirectoryRestrictionsAddMembersType val:
        :rtype: EventType
        """
        return cls('directory_restrictions_add_members', val)

    @classmethod
    def directory_restrictions_remove_members(cls, val):
        """
        Create an instance of this class set to the
        ``directory_restrictions_remove_members`` tag with value ``val``.

        :param DirectoryRestrictionsRemoveMembersType val:
        :rtype: EventType
        """
        return cls('directory_restrictions_remove_members', val)

    @classmethod
    def emm_add_exception(cls, val):
        """
        Create an instance of this class set to the ``emm_add_exception`` tag
        with value ``val``.

        :param EmmAddExceptionType val:
        :rtype: EventType
        """
        return cls('emm_add_exception', val)

    @classmethod
    def emm_change_policy(cls, val):
        """
        Create an instance of this class set to the ``emm_change_policy`` tag
        with value ``val``.

        :param EmmChangePolicyType val:
        :rtype: EventType
        """
        return cls('emm_change_policy', val)

    @classmethod
    def emm_remove_exception(cls, val):
        """
        Create an instance of this class set to the ``emm_remove_exception`` tag
        with value ``val``.

        :param EmmRemoveExceptionType val:
        :rtype: EventType
        """
        return cls('emm_remove_exception', val)

    @classmethod
    def extended_version_history_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``extended_version_history_change_policy`` tag with value ``val``.

        :param ExtendedVersionHistoryChangePolicyType val:
        :rtype: EventType
        """
        return cls('extended_version_history_change_policy', val)

    @classmethod
    def file_comments_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``file_comments_change_policy`` tag with value ``val``.

        :param FileCommentsChangePolicyType val:
        :rtype: EventType
        """
        return cls('file_comments_change_policy', val)

    @classmethod
    def file_requests_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_change_policy`` tag with value ``val``.

        :param FileRequestsChangePolicyType val:
        :rtype: EventType
        """
        return cls('file_requests_change_policy', val)

    @classmethod
    def file_requests_emails_enabled(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_emails_enabled`` tag with value ``val``.

        :param FileRequestsEmailsEnabledType val:
        :rtype: EventType
        """
        return cls('file_requests_emails_enabled', val)

    @classmethod
    def file_requests_emails_restricted_to_team_only(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_emails_restricted_to_team_only`` tag with value ``val``.

        :param FileRequestsEmailsRestrictedToTeamOnlyType val:
        :rtype: EventType
        """
        return cls('file_requests_emails_restricted_to_team_only', val)

    @classmethod
    def google_sso_change_policy(cls, val):
        """
        Create an instance of this class set to the ``google_sso_change_policy``
        tag with value ``val``.

        :param GoogleSsoChangePolicyType val:
        :rtype: EventType
        """
        return cls('google_sso_change_policy', val)

    @classmethod
    def group_user_management_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``group_user_management_change_policy`` tag with value ``val``.

        :param GroupUserManagementChangePolicyType val:
        :rtype: EventType
        """
        return cls('group_user_management_change_policy', val)

    @classmethod
    def member_requests_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``member_requests_change_policy`` tag with value ``val``.

        :param MemberRequestsChangePolicyType val:
        :rtype: EventType
        """
        return cls('member_requests_change_policy', val)

    @classmethod
    def member_space_limits_add_exception(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_add_exception`` tag with value ``val``.

        :param MemberSpaceLimitsAddExceptionType val:
        :rtype: EventType
        """
        return cls('member_space_limits_add_exception', val)

    @classmethod
    def member_space_limits_change_caps_type_policy(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_caps_type_policy`` tag with value ``val``.

        :param MemberSpaceLimitsChangeCapsTypePolicyType val:
        :rtype: EventType
        """
        return cls('member_space_limits_change_caps_type_policy', val)

    @classmethod
    def member_space_limits_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_policy`` tag with value ``val``.

        :param MemberSpaceLimitsChangePolicyType val:
        :rtype: EventType
        """
        return cls('member_space_limits_change_policy', val)

    @classmethod
    def member_space_limits_remove_exception(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_remove_exception`` tag with value ``val``.

        :param MemberSpaceLimitsRemoveExceptionType val:
        :rtype: EventType
        """
        return cls('member_space_limits_remove_exception', val)

    @classmethod
    def member_suggestions_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``member_suggestions_change_policy`` tag with value ``val``.

        :param MemberSuggestionsChangePolicyType val:
        :rtype: EventType
        """
        return cls('member_suggestions_change_policy', val)

    @classmethod
    def microsoft_office_addin_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``microsoft_office_addin_change_policy`` tag with value ``val``.

        :param MicrosoftOfficeAddinChangePolicyType val:
        :rtype: EventType
        """
        return cls('microsoft_office_addin_change_policy', val)

    @classmethod
    def network_control_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``network_control_change_policy`` tag with value ``val``.

        :param NetworkControlChangePolicyType val:
        :rtype: EventType
        """
        return cls('network_control_change_policy', val)

    @classmethod
    def paper_change_deployment_policy(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_deployment_policy`` tag with value ``val``.

        :param PaperChangeDeploymentPolicyType val:
        :rtype: EventType
        """
        return cls('paper_change_deployment_policy', val)

    @classmethod
    def paper_change_member_link_policy(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_member_link_policy`` tag with value ``val``.

        :param PaperChangeMemberLinkPolicyType val:
        :rtype: EventType
        """
        return cls('paper_change_member_link_policy', val)

    @classmethod
    def paper_change_member_policy(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_member_policy`` tag with value ``val``.

        :param PaperChangeMemberPolicyType val:
        :rtype: EventType
        """
        return cls('paper_change_member_policy', val)

    @classmethod
    def paper_change_policy(cls, val):
        """
        Create an instance of this class set to the ``paper_change_policy`` tag
        with value ``val``.

        :param PaperChangePolicyType val:
        :rtype: EventType
        """
        return cls('paper_change_policy', val)

    @classmethod
    def paper_enabled_users_group_addition(cls, val):
        """
        Create an instance of this class set to the
        ``paper_enabled_users_group_addition`` tag with value ``val``.

        :param PaperEnabledUsersGroupAdditionType val:
        :rtype: EventType
        """
        return cls('paper_enabled_users_group_addition', val)

    @classmethod
    def paper_enabled_users_group_removal(cls, val):
        """
        Create an instance of this class set to the
        ``paper_enabled_users_group_removal`` tag with value ``val``.

        :param PaperEnabledUsersGroupRemovalType val:
        :rtype: EventType
        """
        return cls('paper_enabled_users_group_removal', val)

    @classmethod
    def permanent_delete_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``permanent_delete_change_policy`` tag with value ``val``.

        :param PermanentDeleteChangePolicyType val:
        :rtype: EventType
        """
        return cls('permanent_delete_change_policy', val)

    @classmethod
    def sharing_change_folder_join_policy(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_folder_join_policy`` tag with value ``val``.

        :param SharingChangeFolderJoinPolicyType val:
        :rtype: EventType
        """
        return cls('sharing_change_folder_join_policy', val)

    @classmethod
    def sharing_change_link_policy(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_policy`` tag with value ``val``.

        :param SharingChangeLinkPolicyType val:
        :rtype: EventType
        """
        return cls('sharing_change_link_policy', val)

    @classmethod
    def sharing_change_member_policy(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_member_policy`` tag with value ``val``.

        :param SharingChangeMemberPolicyType val:
        :rtype: EventType
        """
        return cls('sharing_change_member_policy', val)

    @classmethod
    def showcase_change_download_policy(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_download_policy`` tag with value ``val``.

        :param ShowcaseChangeDownloadPolicyType val:
        :rtype: EventType
        """
        return cls('showcase_change_download_policy', val)

    @classmethod
    def showcase_change_enabled_policy(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_enabled_policy`` tag with value ``val``.

        :param ShowcaseChangeEnabledPolicyType val:
        :rtype: EventType
        """
        return cls('showcase_change_enabled_policy', val)

    @classmethod
    def showcase_change_external_sharing_policy(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_external_sharing_policy`` tag with value ``val``.

        :param ShowcaseChangeExternalSharingPolicyType val:
        :rtype: EventType
        """
        return cls('showcase_change_external_sharing_policy', val)

    @classmethod
    def smart_sync_change_policy(cls, val):
        """
        Create an instance of this class set to the ``smart_sync_change_policy``
        tag with value ``val``.

        :param SmartSyncChangePolicyType val:
        :rtype: EventType
        """
        return cls('smart_sync_change_policy', val)

    @classmethod
    def smart_sync_not_opt_out(cls, val):
        """
        Create an instance of this class set to the ``smart_sync_not_opt_out``
        tag with value ``val``.

        :param SmartSyncNotOptOutType val:
        :rtype: EventType
        """
        return cls('smart_sync_not_opt_out', val)

    @classmethod
    def smart_sync_opt_out(cls, val):
        """
        Create an instance of this class set to the ``smart_sync_opt_out`` tag
        with value ``val``.

        :param SmartSyncOptOutType val:
        :rtype: EventType
        """
        return cls('smart_sync_opt_out', val)

    @classmethod
    def sso_change_policy(cls, val):
        """
        Create an instance of this class set to the ``sso_change_policy`` tag
        with value ``val``.

        :param SsoChangePolicyType val:
        :rtype: EventType
        """
        return cls('sso_change_policy', val)

    @classmethod
    def team_selective_sync_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``team_selective_sync_policy_changed`` tag with value ``val``.

        :param TeamSelectiveSyncPolicyChangedType val:
        :rtype: EventType
        """
        return cls('team_selective_sync_policy_changed', val)

    @classmethod
    def tfa_change_policy(cls, val):
        """
        Create an instance of this class set to the ``tfa_change_policy`` tag
        with value ``val``.

        :param TfaChangePolicyType val:
        :rtype: EventType
        """
        return cls('tfa_change_policy', val)

    @classmethod
    def two_account_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``two_account_change_policy`` tag with value ``val``.

        :param TwoAccountChangePolicyType val:
        :rtype: EventType
        """
        return cls('two_account_change_policy', val)

    @classmethod
    def viewer_info_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``viewer_info_policy_changed`` tag with value ``val``.

        :param ViewerInfoPolicyChangedType val:
        :rtype: EventType
        """
        return cls('viewer_info_policy_changed', val)

    @classmethod
    def web_sessions_change_fixed_length_policy(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_fixed_length_policy`` tag with value ``val``.

        :param WebSessionsChangeFixedLengthPolicyType val:
        :rtype: EventType
        """
        return cls('web_sessions_change_fixed_length_policy', val)

    @classmethod
    def web_sessions_change_idle_length_policy(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_idle_length_policy`` tag with value ``val``.

        :param WebSessionsChangeIdleLengthPolicyType val:
        :rtype: EventType
        """
        return cls('web_sessions_change_idle_length_policy', val)

    @classmethod
    def team_merge_from(cls, val):
        """
        Create an instance of this class set to the ``team_merge_from`` tag with
        value ``val``.

        :param TeamMergeFromType val:
        :rtype: EventType
        """
        return cls('team_merge_from', val)

    @classmethod
    def team_merge_to(cls, val):
        """
        Create an instance of this class set to the ``team_merge_to`` tag with
        value ``val``.

        :param TeamMergeToType val:
        :rtype: EventType
        """
        return cls('team_merge_to', val)

    @classmethod
    def team_profile_add_logo(cls, val):
        """
        Create an instance of this class set to the ``team_profile_add_logo``
        tag with value ``val``.

        :param TeamProfileAddLogoType val:
        :rtype: EventType
        """
        return cls('team_profile_add_logo', val)

    @classmethod
    def team_profile_change_default_language(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_default_language`` tag with value ``val``.

        :param TeamProfileChangeDefaultLanguageType val:
        :rtype: EventType
        """
        return cls('team_profile_change_default_language', val)

    @classmethod
    def team_profile_change_logo(cls, val):
        """
        Create an instance of this class set to the ``team_profile_change_logo``
        tag with value ``val``.

        :param TeamProfileChangeLogoType val:
        :rtype: EventType
        """
        return cls('team_profile_change_logo', val)

    @classmethod
    def team_profile_change_name(cls, val):
        """
        Create an instance of this class set to the ``team_profile_change_name``
        tag with value ``val``.

        :param TeamProfileChangeNameType val:
        :rtype: EventType
        """
        return cls('team_profile_change_name', val)

    @classmethod
    def team_profile_remove_logo(cls, val):
        """
        Create an instance of this class set to the ``team_profile_remove_logo``
        tag with value ``val``.

        :param TeamProfileRemoveLogoType val:
        :rtype: EventType
        """
        return cls('team_profile_remove_logo', val)

    @classmethod
    def tfa_add_backup_phone(cls, val):
        """
        Create an instance of this class set to the ``tfa_add_backup_phone`` tag
        with value ``val``.

        :param TfaAddBackupPhoneType val:
        :rtype: EventType
        """
        return cls('tfa_add_backup_phone', val)

    @classmethod
    def tfa_add_security_key(cls, val):
        """
        Create an instance of this class set to the ``tfa_add_security_key`` tag
        with value ``val``.

        :param TfaAddSecurityKeyType val:
        :rtype: EventType
        """
        return cls('tfa_add_security_key', val)

    @classmethod
    def tfa_change_backup_phone(cls, val):
        """
        Create an instance of this class set to the ``tfa_change_backup_phone``
        tag with value ``val``.

        :param TfaChangeBackupPhoneType val:
        :rtype: EventType
        """
        return cls('tfa_change_backup_phone', val)

    @classmethod
    def tfa_change_status(cls, val):
        """
        Create an instance of this class set to the ``tfa_change_status`` tag
        with value ``val``.

        :param TfaChangeStatusType val:
        :rtype: EventType
        """
        return cls('tfa_change_status', val)

    @classmethod
    def tfa_remove_backup_phone(cls, val):
        """
        Create an instance of this class set to the ``tfa_remove_backup_phone``
        tag with value ``val``.

        :param TfaRemoveBackupPhoneType val:
        :rtype: EventType
        """
        return cls('tfa_remove_backup_phone', val)

    @classmethod
    def tfa_remove_security_key(cls, val):
        """
        Create an instance of this class set to the ``tfa_remove_security_key``
        tag with value ``val``.

        :param TfaRemoveSecurityKeyType val:
        :rtype: EventType
        """
        return cls('tfa_remove_security_key', val)

    @classmethod
    def tfa_reset(cls, val):
        """
        Create an instance of this class set to the ``tfa_reset`` tag with value
        ``val``.

        :param TfaResetType val:
        :rtype: EventType
        """
        return cls('tfa_reset', val)

    def is_app_link_team(self):
        """
        Check if the union tag is ``app_link_team``.

        :rtype: bool
        """
        return self._tag == 'app_link_team'

    def is_app_link_user(self):
        """
        Check if the union tag is ``app_link_user``.

        :rtype: bool
        """
        return self._tag == 'app_link_user'

    def is_app_unlink_team(self):
        """
        Check if the union tag is ``app_unlink_team``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_team'

    def is_app_unlink_user(self):
        """
        Check if the union tag is ``app_unlink_user``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_user'

    def is_file_add_comment(self):
        """
        Check if the union tag is ``file_add_comment``.

        :rtype: bool
        """
        return self._tag == 'file_add_comment'

    def is_file_change_comment_subscription(self):
        """
        Check if the union tag is ``file_change_comment_subscription``.

        :rtype: bool
        """
        return self._tag == 'file_change_comment_subscription'

    def is_file_delete_comment(self):
        """
        Check if the union tag is ``file_delete_comment``.

        :rtype: bool
        """
        return self._tag == 'file_delete_comment'

    def is_file_like_comment(self):
        """
        Check if the union tag is ``file_like_comment``.

        :rtype: bool
        """
        return self._tag == 'file_like_comment'

    def is_file_resolve_comment(self):
        """
        Check if the union tag is ``file_resolve_comment``.

        :rtype: bool
        """
        return self._tag == 'file_resolve_comment'

    def is_file_unlike_comment(self):
        """
        Check if the union tag is ``file_unlike_comment``.

        :rtype: bool
        """
        return self._tag == 'file_unlike_comment'

    def is_file_unresolve_comment(self):
        """
        Check if the union tag is ``file_unresolve_comment``.

        :rtype: bool
        """
        return self._tag == 'file_unresolve_comment'

    def is_device_change_ip_desktop(self):
        """
        Check if the union tag is ``device_change_ip_desktop``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_desktop'

    def is_device_change_ip_mobile(self):
        """
        Check if the union tag is ``device_change_ip_mobile``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_mobile'

    def is_device_change_ip_web(self):
        """
        Check if the union tag is ``device_change_ip_web``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_web'

    def is_device_delete_on_unlink_fail(self):
        """
        Check if the union tag is ``device_delete_on_unlink_fail``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_fail'

    def is_device_delete_on_unlink_success(self):
        """
        Check if the union tag is ``device_delete_on_unlink_success``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_success'

    def is_device_link_fail(self):
        """
        Check if the union tag is ``device_link_fail``.

        :rtype: bool
        """
        return self._tag == 'device_link_fail'

    def is_device_link_success(self):
        """
        Check if the union tag is ``device_link_success``.

        :rtype: bool
        """
        return self._tag == 'device_link_success'

    def is_device_management_disabled(self):
        """
        Check if the union tag is ``device_management_disabled``.

        :rtype: bool
        """
        return self._tag == 'device_management_disabled'

    def is_device_management_enabled(self):
        """
        Check if the union tag is ``device_management_enabled``.

        :rtype: bool
        """
        return self._tag == 'device_management_enabled'

    def is_device_unlink(self):
        """
        Check if the union tag is ``device_unlink``.

        :rtype: bool
        """
        return self._tag == 'device_unlink'

    def is_emm_refresh_auth_token(self):
        """
        Check if the union tag is ``emm_refresh_auth_token``.

        :rtype: bool
        """
        return self._tag == 'emm_refresh_auth_token'

    def is_account_capture_change_availability(self):
        """
        Check if the union tag is ``account_capture_change_availability``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_availability'

    def is_account_capture_migrate_account(self):
        """
        Check if the union tag is ``account_capture_migrate_account``.

        :rtype: bool
        """
        return self._tag == 'account_capture_migrate_account'

    def is_account_capture_notification_emails_sent(self):
        """
        Check if the union tag is ``account_capture_notification_emails_sent``.

        :rtype: bool
        """
        return self._tag == 'account_capture_notification_emails_sent'

    def is_account_capture_relinquish_account(self):
        """
        Check if the union tag is ``account_capture_relinquish_account``.

        :rtype: bool
        """
        return self._tag == 'account_capture_relinquish_account'

    def is_disabled_domain_invites(self):
        """
        Check if the union tag is ``disabled_domain_invites``.

        :rtype: bool
        """
        return self._tag == 'disabled_domain_invites'

    def is_domain_invites_approve_request_to_join_team(self):
        """
        Check if the union tag is ``domain_invites_approve_request_to_join_team``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_approve_request_to_join_team'

    def is_domain_invites_decline_request_to_join_team(self):
        """
        Check if the union tag is ``domain_invites_decline_request_to_join_team``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_decline_request_to_join_team'

    def is_domain_invites_email_existing_users(self):
        """
        Check if the union tag is ``domain_invites_email_existing_users``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_email_existing_users'

    def is_domain_invites_request_to_join_team(self):
        """
        Check if the union tag is ``domain_invites_request_to_join_team``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_request_to_join_team'

    def is_domain_invites_set_invite_new_user_pref_to_no(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_no``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_no'

    def is_domain_invites_set_invite_new_user_pref_to_yes(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_yes``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_yes'

    def is_domain_verification_add_domain_fail(self):
        """
        Check if the union tag is ``domain_verification_add_domain_fail``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_fail'

    def is_domain_verification_add_domain_success(self):
        """
        Check if the union tag is ``domain_verification_add_domain_success``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_success'

    def is_domain_verification_remove_domain(self):
        """
        Check if the union tag is ``domain_verification_remove_domain``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_remove_domain'

    def is_enabled_domain_invites(self):
        """
        Check if the union tag is ``enabled_domain_invites``.

        :rtype: bool
        """
        return self._tag == 'enabled_domain_invites'

    def is_create_folder(self):
        """
        Check if the union tag is ``create_folder``.

        :rtype: bool
        """
        return self._tag == 'create_folder'

    def is_file_add(self):
        """
        Check if the union tag is ``file_add``.

        :rtype: bool
        """
        return self._tag == 'file_add'

    def is_file_copy(self):
        """
        Check if the union tag is ``file_copy``.

        :rtype: bool
        """
        return self._tag == 'file_copy'

    def is_file_delete(self):
        """
        Check if the union tag is ``file_delete``.

        :rtype: bool
        """
        return self._tag == 'file_delete'

    def is_file_download(self):
        """
        Check if the union tag is ``file_download``.

        :rtype: bool
        """
        return self._tag == 'file_download'

    def is_file_edit(self):
        """
        Check if the union tag is ``file_edit``.

        :rtype: bool
        """
        return self._tag == 'file_edit'

    def is_file_get_copy_reference(self):
        """
        Check if the union tag is ``file_get_copy_reference``.

        :rtype: bool
        """
        return self._tag == 'file_get_copy_reference'

    def is_file_move(self):
        """
        Check if the union tag is ``file_move``.

        :rtype: bool
        """
        return self._tag == 'file_move'

    def is_file_permanently_delete(self):
        """
        Check if the union tag is ``file_permanently_delete``.

        :rtype: bool
        """
        return self._tag == 'file_permanently_delete'

    def is_file_preview(self):
        """
        Check if the union tag is ``file_preview``.

        :rtype: bool
        """
        return self._tag == 'file_preview'

    def is_file_rename(self):
        """
        Check if the union tag is ``file_rename``.

        :rtype: bool
        """
        return self._tag == 'file_rename'

    def is_file_restore(self):
        """
        Check if the union tag is ``file_restore``.

        :rtype: bool
        """
        return self._tag == 'file_restore'

    def is_file_revert(self):
        """
        Check if the union tag is ``file_revert``.

        :rtype: bool
        """
        return self._tag == 'file_revert'

    def is_file_rollback_changes(self):
        """
        Check if the union tag is ``file_rollback_changes``.

        :rtype: bool
        """
        return self._tag == 'file_rollback_changes'

    def is_file_save_copy_reference(self):
        """
        Check if the union tag is ``file_save_copy_reference``.

        :rtype: bool
        """
        return self._tag == 'file_save_copy_reference'

    def is_file_request_change(self):
        """
        Check if the union tag is ``file_request_change``.

        :rtype: bool
        """
        return self._tag == 'file_request_change'

    def is_file_request_close(self):
        """
        Check if the union tag is ``file_request_close``.

        :rtype: bool
        """
        return self._tag == 'file_request_close'

    def is_file_request_create(self):
        """
        Check if the union tag is ``file_request_create``.

        :rtype: bool
        """
        return self._tag == 'file_request_create'

    def is_file_request_receive_file(self):
        """
        Check if the union tag is ``file_request_receive_file``.

        :rtype: bool
        """
        return self._tag == 'file_request_receive_file'

    def is_group_add_external_id(self):
        """
        Check if the union tag is ``group_add_external_id``.

        :rtype: bool
        """
        return self._tag == 'group_add_external_id'

    def is_group_add_member(self):
        """
        Check if the union tag is ``group_add_member``.

        :rtype: bool
        """
        return self._tag == 'group_add_member'

    def is_group_change_external_id(self):
        """
        Check if the union tag is ``group_change_external_id``.

        :rtype: bool
        """
        return self._tag == 'group_change_external_id'

    def is_group_change_management_type(self):
        """
        Check if the union tag is ``group_change_management_type``.

        :rtype: bool
        """
        return self._tag == 'group_change_management_type'

    def is_group_change_member_role(self):
        """
        Check if the union tag is ``group_change_member_role``.

        :rtype: bool
        """
        return self._tag == 'group_change_member_role'

    def is_group_create(self):
        """
        Check if the union tag is ``group_create``.

        :rtype: bool
        """
        return self._tag == 'group_create'

    def is_group_delete(self):
        """
        Check if the union tag is ``group_delete``.

        :rtype: bool
        """
        return self._tag == 'group_delete'

    def is_group_description_updated(self):
        """
        Check if the union tag is ``group_description_updated``.

        :rtype: bool
        """
        return self._tag == 'group_description_updated'

    def is_group_join_policy_updated(self):
        """
        Check if the union tag is ``group_join_policy_updated``.

        :rtype: bool
        """
        return self._tag == 'group_join_policy_updated'

    def is_group_moved(self):
        """
        Check if the union tag is ``group_moved``.

        :rtype: bool
        """
        return self._tag == 'group_moved'

    def is_group_remove_external_id(self):
        """
        Check if the union tag is ``group_remove_external_id``.

        :rtype: bool
        """
        return self._tag == 'group_remove_external_id'

    def is_group_remove_member(self):
        """
        Check if the union tag is ``group_remove_member``.

        :rtype: bool
        """
        return self._tag == 'group_remove_member'

    def is_group_rename(self):
        """
        Check if the union tag is ``group_rename``.

        :rtype: bool
        """
        return self._tag == 'group_rename'

    def is_emm_error(self):
        """
        Check if the union tag is ``emm_error``.

        :rtype: bool
        """
        return self._tag == 'emm_error'

    def is_login_fail(self):
        """
        Check if the union tag is ``login_fail``.

        :rtype: bool
        """
        return self._tag == 'login_fail'

    def is_login_success(self):
        """
        Check if the union tag is ``login_success``.

        :rtype: bool
        """
        return self._tag == 'login_success'

    def is_logout(self):
        """
        Check if the union tag is ``logout``.

        :rtype: bool
        """
        return self._tag == 'logout'

    def is_reseller_support_session_end(self):
        """
        Check if the union tag is ``reseller_support_session_end``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_end'

    def is_reseller_support_session_start(self):
        """
        Check if the union tag is ``reseller_support_session_start``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_start'

    def is_sign_in_as_session_end(self):
        """
        Check if the union tag is ``sign_in_as_session_end``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_end'

    def is_sign_in_as_session_start(self):
        """
        Check if the union tag is ``sign_in_as_session_start``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_start'

    def is_sso_error(self):
        """
        Check if the union tag is ``sso_error``.

        :rtype: bool
        """
        return self._tag == 'sso_error'

    def is_member_add_name(self):
        """
        Check if the union tag is ``member_add_name``.

        :rtype: bool
        """
        return self._tag == 'member_add_name'

    def is_member_change_admin_role(self):
        """
        Check if the union tag is ``member_change_admin_role``.

        :rtype: bool
        """
        return self._tag == 'member_change_admin_role'

    def is_member_change_email(self):
        """
        Check if the union tag is ``member_change_email``.

        :rtype: bool
        """
        return self._tag == 'member_change_email'

    def is_member_change_membership_type(self):
        """
        Check if the union tag is ``member_change_membership_type``.

        :rtype: bool
        """
        return self._tag == 'member_change_membership_type'

    def is_member_change_name(self):
        """
        Check if the union tag is ``member_change_name``.

        :rtype: bool
        """
        return self._tag == 'member_change_name'

    def is_member_change_status(self):
        """
        Check if the union tag is ``member_change_status``.

        :rtype: bool
        """
        return self._tag == 'member_change_status'

    def is_member_delete_manual_contacts(self):
        """
        Check if the union tag is ``member_delete_manual_contacts``.

        :rtype: bool
        """
        return self._tag == 'member_delete_manual_contacts'

    def is_member_permanently_delete_account_contents(self):
        """
        Check if the union tag is ``member_permanently_delete_account_contents``.

        :rtype: bool
        """
        return self._tag == 'member_permanently_delete_account_contents'

    def is_member_space_limits_add_custom_quota(self):
        """
        Check if the union tag is ``member_space_limits_add_custom_quota``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_add_custom_quota'

    def is_member_space_limits_change_custom_quota(self):
        """
        Check if the union tag is ``member_space_limits_change_custom_quota``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_custom_quota'

    def is_member_space_limits_change_status(self):
        """
        Check if the union tag is ``member_space_limits_change_status``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_status'

    def is_member_space_limits_remove_custom_quota(self):
        """
        Check if the union tag is ``member_space_limits_remove_custom_quota``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_remove_custom_quota'

    def is_member_suggest(self):
        """
        Check if the union tag is ``member_suggest``.

        :rtype: bool
        """
        return self._tag == 'member_suggest'

    def is_member_transfer_account_contents(self):
        """
        Check if the union tag is ``member_transfer_account_contents``.

        :rtype: bool
        """
        return self._tag == 'member_transfer_account_contents'

    def is_secondary_mails_policy_changed(self):
        """
        Check if the union tag is ``secondary_mails_policy_changed``.

        :rtype: bool
        """
        return self._tag == 'secondary_mails_policy_changed'

    def is_paper_content_add_member(self):
        """
        Check if the union tag is ``paper_content_add_member``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_member'

    def is_paper_content_add_to_folder(self):
        """
        Check if the union tag is ``paper_content_add_to_folder``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_to_folder'

    def is_paper_content_archive(self):
        """
        Check if the union tag is ``paper_content_archive``.

        :rtype: bool
        """
        return self._tag == 'paper_content_archive'

    def is_paper_content_create(self):
        """
        Check if the union tag is ``paper_content_create``.

        :rtype: bool
        """
        return self._tag == 'paper_content_create'

    def is_paper_content_permanently_delete(self):
        """
        Check if the union tag is ``paper_content_permanently_delete``.

        :rtype: bool
        """
        return self._tag == 'paper_content_permanently_delete'

    def is_paper_content_remove_from_folder(self):
        """
        Check if the union tag is ``paper_content_remove_from_folder``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_from_folder'

    def is_paper_content_remove_member(self):
        """
        Check if the union tag is ``paper_content_remove_member``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_member'

    def is_paper_content_rename(self):
        """
        Check if the union tag is ``paper_content_rename``.

        :rtype: bool
        """
        return self._tag == 'paper_content_rename'

    def is_paper_content_restore(self):
        """
        Check if the union tag is ``paper_content_restore``.

        :rtype: bool
        """
        return self._tag == 'paper_content_restore'

    def is_paper_doc_add_comment(self):
        """
        Check if the union tag is ``paper_doc_add_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_add_comment'

    def is_paper_doc_change_member_role(self):
        """
        Check if the union tag is ``paper_doc_change_member_role``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_member_role'

    def is_paper_doc_change_sharing_policy(self):
        """
        Check if the union tag is ``paper_doc_change_sharing_policy``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_sharing_policy'

    def is_paper_doc_change_subscription(self):
        """
        Check if the union tag is ``paper_doc_change_subscription``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_subscription'

    def is_paper_doc_deleted(self):
        """
        Check if the union tag is ``paper_doc_deleted``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_deleted'

    def is_paper_doc_delete_comment(self):
        """
        Check if the union tag is ``paper_doc_delete_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_delete_comment'

    def is_paper_doc_download(self):
        """
        Check if the union tag is ``paper_doc_download``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_download'

    def is_paper_doc_edit(self):
        """
        Check if the union tag is ``paper_doc_edit``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit'

    def is_paper_doc_edit_comment(self):
        """
        Check if the union tag is ``paper_doc_edit_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit_comment'

    def is_paper_doc_followed(self):
        """
        Check if the union tag is ``paper_doc_followed``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_followed'

    def is_paper_doc_mention(self):
        """
        Check if the union tag is ``paper_doc_mention``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_mention'

    def is_paper_doc_ownership_changed(self):
        """
        Check if the union tag is ``paper_doc_ownership_changed``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_ownership_changed'

    def is_paper_doc_request_access(self):
        """
        Check if the union tag is ``paper_doc_request_access``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_request_access'

    def is_paper_doc_resolve_comment(self):
        """
        Check if the union tag is ``paper_doc_resolve_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_resolve_comment'

    def is_paper_doc_revert(self):
        """
        Check if the union tag is ``paper_doc_revert``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_revert'

    def is_paper_doc_slack_share(self):
        """
        Check if the union tag is ``paper_doc_slack_share``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_slack_share'

    def is_paper_doc_team_invite(self):
        """
        Check if the union tag is ``paper_doc_team_invite``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_team_invite'

    def is_paper_doc_trashed(self):
        """
        Check if the union tag is ``paper_doc_trashed``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_trashed'

    def is_paper_doc_unresolve_comment(self):
        """
        Check if the union tag is ``paper_doc_unresolve_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_unresolve_comment'

    def is_paper_doc_untrashed(self):
        """
        Check if the union tag is ``paper_doc_untrashed``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_untrashed'

    def is_paper_doc_view(self):
        """
        Check if the union tag is ``paper_doc_view``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_view'

    def is_paper_external_view_allow(self):
        """
        Check if the union tag is ``paper_external_view_allow``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_allow'

    def is_paper_external_view_default_team(self):
        """
        Check if the union tag is ``paper_external_view_default_team``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_default_team'

    def is_paper_external_view_forbid(self):
        """
        Check if the union tag is ``paper_external_view_forbid``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_forbid'

    def is_paper_folder_change_subscription(self):
        """
        Check if the union tag is ``paper_folder_change_subscription``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_change_subscription'

    def is_paper_folder_deleted(self):
        """
        Check if the union tag is ``paper_folder_deleted``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_deleted'

    def is_paper_folder_followed(self):
        """
        Check if the union tag is ``paper_folder_followed``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_followed'

    def is_paper_folder_team_invite(self):
        """
        Check if the union tag is ``paper_folder_team_invite``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_team_invite'

    def is_password_change(self):
        """
        Check if the union tag is ``password_change``.

        :rtype: bool
        """
        return self._tag == 'password_change'

    def is_password_reset(self):
        """
        Check if the union tag is ``password_reset``.

        :rtype: bool
        """
        return self._tag == 'password_reset'

    def is_password_reset_all(self):
        """
        Check if the union tag is ``password_reset_all``.

        :rtype: bool
        """
        return self._tag == 'password_reset_all'

    def is_emm_create_exceptions_report(self):
        """
        Check if the union tag is ``emm_create_exceptions_report``.

        :rtype: bool
        """
        return self._tag == 'emm_create_exceptions_report'

    def is_emm_create_usage_report(self):
        """
        Check if the union tag is ``emm_create_usage_report``.

        :rtype: bool
        """
        return self._tag == 'emm_create_usage_report'

    def is_export_members_report(self):
        """
        Check if the union tag is ``export_members_report``.

        :rtype: bool
        """
        return self._tag == 'export_members_report'

    def is_paper_admin_export_start(self):
        """
        Check if the union tag is ``paper_admin_export_start``.

        :rtype: bool
        """
        return self._tag == 'paper_admin_export_start'

    def is_smart_sync_create_admin_privilege_report(self):
        """
        Check if the union tag is ``smart_sync_create_admin_privilege_report``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_create_admin_privilege_report'

    def is_team_activity_create_report(self):
        """
        Check if the union tag is ``team_activity_create_report``.

        :rtype: bool
        """
        return self._tag == 'team_activity_create_report'

    def is_collection_share(self):
        """
        Check if the union tag is ``collection_share``.

        :rtype: bool
        """
        return self._tag == 'collection_share'

    def is_note_acl_invite_only(self):
        """
        Check if the union tag is ``note_acl_invite_only``.

        :rtype: bool
        """
        return self._tag == 'note_acl_invite_only'

    def is_note_acl_link(self):
        """
        Check if the union tag is ``note_acl_link``.

        :rtype: bool
        """
        return self._tag == 'note_acl_link'

    def is_note_acl_team_link(self):
        """
        Check if the union tag is ``note_acl_team_link``.

        :rtype: bool
        """
        return self._tag == 'note_acl_team_link'

    def is_note_shared(self):
        """
        Check if the union tag is ``note_shared``.

        :rtype: bool
        """
        return self._tag == 'note_shared'

    def is_note_share_receive(self):
        """
        Check if the union tag is ``note_share_receive``.

        :rtype: bool
        """
        return self._tag == 'note_share_receive'

    def is_open_note_shared(self):
        """
        Check if the union tag is ``open_note_shared``.

        :rtype: bool
        """
        return self._tag == 'open_note_shared'

    def is_sf_add_group(self):
        """
        Check if the union tag is ``sf_add_group``.

        :rtype: bool
        """
        return self._tag == 'sf_add_group'

    def is_sf_allow_non_members_to_view_shared_links(self):
        """
        Check if the union tag is ``sf_allow_non_members_to_view_shared_links``.

        :rtype: bool
        """
        return self._tag == 'sf_allow_non_members_to_view_shared_links'

    def is_sf_external_invite_warn(self):
        """
        Check if the union tag is ``sf_external_invite_warn``.

        :rtype: bool
        """
        return self._tag == 'sf_external_invite_warn'

    def is_sf_fb_invite(self):
        """
        Check if the union tag is ``sf_fb_invite``.

        :rtype: bool
        """
        return self._tag == 'sf_fb_invite'

    def is_sf_fb_invite_change_role(self):
        """
        Check if the union tag is ``sf_fb_invite_change_role``.

        :rtype: bool
        """
        return self._tag == 'sf_fb_invite_change_role'

    def is_sf_fb_uninvite(self):
        """
        Check if the union tag is ``sf_fb_uninvite``.

        :rtype: bool
        """
        return self._tag == 'sf_fb_uninvite'

    def is_sf_invite_group(self):
        """
        Check if the union tag is ``sf_invite_group``.

        :rtype: bool
        """
        return self._tag == 'sf_invite_group'

    def is_sf_team_grant_access(self):
        """
        Check if the union tag is ``sf_team_grant_access``.

        :rtype: bool
        """
        return self._tag == 'sf_team_grant_access'

    def is_sf_team_invite(self):
        """
        Check if the union tag is ``sf_team_invite``.

        :rtype: bool
        """
        return self._tag == 'sf_team_invite'

    def is_sf_team_invite_change_role(self):
        """
        Check if the union tag is ``sf_team_invite_change_role``.

        :rtype: bool
        """
        return self._tag == 'sf_team_invite_change_role'

    def is_sf_team_join(self):
        """
        Check if the union tag is ``sf_team_join``.

        :rtype: bool
        """
        return self._tag == 'sf_team_join'

    def is_sf_team_join_from_oob_link(self):
        """
        Check if the union tag is ``sf_team_join_from_oob_link``.

        :rtype: bool
        """
        return self._tag == 'sf_team_join_from_oob_link'

    def is_sf_team_uninvite(self):
        """
        Check if the union tag is ``sf_team_uninvite``.

        :rtype: bool
        """
        return self._tag == 'sf_team_uninvite'

    def is_shared_content_add_invitees(self):
        """
        Check if the union tag is ``shared_content_add_invitees``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_invitees'

    def is_shared_content_add_link_expiry(self):
        """
        Check if the union tag is ``shared_content_add_link_expiry``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_link_expiry'

    def is_shared_content_add_link_password(self):
        """
        Check if the union tag is ``shared_content_add_link_password``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_link_password'

    def is_shared_content_add_member(self):
        """
        Check if the union tag is ``shared_content_add_member``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_member'

    def is_shared_content_change_downloads_policy(self):
        """
        Check if the union tag is ``shared_content_change_downloads_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_downloads_policy'

    def is_shared_content_change_invitee_role(self):
        """
        Check if the union tag is ``shared_content_change_invitee_role``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_invitee_role'

    def is_shared_content_change_link_audience(self):
        """
        Check if the union tag is ``shared_content_change_link_audience``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_audience'

    def is_shared_content_change_link_expiry(self):
        """
        Check if the union tag is ``shared_content_change_link_expiry``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_expiry'

    def is_shared_content_change_link_password(self):
        """
        Check if the union tag is ``shared_content_change_link_password``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_password'

    def is_shared_content_change_member_role(self):
        """
        Check if the union tag is ``shared_content_change_member_role``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_member_role'

    def is_shared_content_change_viewer_info_policy(self):
        """
        Check if the union tag is ``shared_content_change_viewer_info_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_viewer_info_policy'

    def is_shared_content_claim_invitation(self):
        """
        Check if the union tag is ``shared_content_claim_invitation``.

        :rtype: bool
        """
        return self._tag == 'shared_content_claim_invitation'

    def is_shared_content_copy(self):
        """
        Check if the union tag is ``shared_content_copy``.

        :rtype: bool
        """
        return self._tag == 'shared_content_copy'

    def is_shared_content_download(self):
        """
        Check if the union tag is ``shared_content_download``.

        :rtype: bool
        """
        return self._tag == 'shared_content_download'

    def is_shared_content_relinquish_membership(self):
        """
        Check if the union tag is ``shared_content_relinquish_membership``.

        :rtype: bool
        """
        return self._tag == 'shared_content_relinquish_membership'

    def is_shared_content_remove_invitees(self):
        """
        Check if the union tag is ``shared_content_remove_invitees``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_invitees'

    def is_shared_content_remove_link_expiry(self):
        """
        Check if the union tag is ``shared_content_remove_link_expiry``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_link_expiry'

    def is_shared_content_remove_link_password(self):
        """
        Check if the union tag is ``shared_content_remove_link_password``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_link_password'

    def is_shared_content_remove_member(self):
        """
        Check if the union tag is ``shared_content_remove_member``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_member'

    def is_shared_content_request_access(self):
        """
        Check if the union tag is ``shared_content_request_access``.

        :rtype: bool
        """
        return self._tag == 'shared_content_request_access'

    def is_shared_content_unshare(self):
        """
        Check if the union tag is ``shared_content_unshare``.

        :rtype: bool
        """
        return self._tag == 'shared_content_unshare'

    def is_shared_content_view(self):
        """
        Check if the union tag is ``shared_content_view``.

        :rtype: bool
        """
        return self._tag == 'shared_content_view'

    def is_shared_folder_change_link_policy(self):
        """
        Check if the union tag is ``shared_folder_change_link_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_link_policy'

    def is_shared_folder_change_members_inheritance_policy(self):
        """
        Check if the union tag is ``shared_folder_change_members_inheritance_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_members_inheritance_policy'

    def is_shared_folder_change_members_management_policy(self):
        """
        Check if the union tag is ``shared_folder_change_members_management_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_members_management_policy'

    def is_shared_folder_change_members_policy(self):
        """
        Check if the union tag is ``shared_folder_change_members_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_members_policy'

    def is_shared_folder_create(self):
        """
        Check if the union tag is ``shared_folder_create``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_create'

    def is_shared_folder_decline_invitation(self):
        """
        Check if the union tag is ``shared_folder_decline_invitation``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_decline_invitation'

    def is_shared_folder_mount(self):
        """
        Check if the union tag is ``shared_folder_mount``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_mount'

    def is_shared_folder_nest(self):
        """
        Check if the union tag is ``shared_folder_nest``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_nest'

    def is_shared_folder_transfer_ownership(self):
        """
        Check if the union tag is ``shared_folder_transfer_ownership``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_transfer_ownership'

    def is_shared_folder_unmount(self):
        """
        Check if the union tag is ``shared_folder_unmount``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_unmount'

    def is_shared_link_add_expiry(self):
        """
        Check if the union tag is ``shared_link_add_expiry``.

        :rtype: bool
        """
        return self._tag == 'shared_link_add_expiry'

    def is_shared_link_change_expiry(self):
        """
        Check if the union tag is ``shared_link_change_expiry``.

        :rtype: bool
        """
        return self._tag == 'shared_link_change_expiry'

    def is_shared_link_change_visibility(self):
        """
        Check if the union tag is ``shared_link_change_visibility``.

        :rtype: bool
        """
        return self._tag == 'shared_link_change_visibility'

    def is_shared_link_copy(self):
        """
        Check if the union tag is ``shared_link_copy``.

        :rtype: bool
        """
        return self._tag == 'shared_link_copy'

    def is_shared_link_create(self):
        """
        Check if the union tag is ``shared_link_create``.

        :rtype: bool
        """
        return self._tag == 'shared_link_create'

    def is_shared_link_disable(self):
        """
        Check if the union tag is ``shared_link_disable``.

        :rtype: bool
        """
        return self._tag == 'shared_link_disable'

    def is_shared_link_download(self):
        """
        Check if the union tag is ``shared_link_download``.

        :rtype: bool
        """
        return self._tag == 'shared_link_download'

    def is_shared_link_remove_expiry(self):
        """
        Check if the union tag is ``shared_link_remove_expiry``.

        :rtype: bool
        """
        return self._tag == 'shared_link_remove_expiry'

    def is_shared_link_share(self):
        """
        Check if the union tag is ``shared_link_share``.

        :rtype: bool
        """
        return self._tag == 'shared_link_share'

    def is_shared_link_view(self):
        """
        Check if the union tag is ``shared_link_view``.

        :rtype: bool
        """
        return self._tag == 'shared_link_view'

    def is_shared_note_opened(self):
        """
        Check if the union tag is ``shared_note_opened``.

        :rtype: bool
        """
        return self._tag == 'shared_note_opened'

    def is_shmodel_group_share(self):
        """
        Check if the union tag is ``shmodel_group_share``.

        :rtype: bool
        """
        return self._tag == 'shmodel_group_share'

    def is_showcase_access_granted(self):
        """
        Check if the union tag is ``showcase_access_granted``.

        :rtype: bool
        """
        return self._tag == 'showcase_access_granted'

    def is_showcase_add_member(self):
        """
        Check if the union tag is ``showcase_add_member``.

        :rtype: bool
        """
        return self._tag == 'showcase_add_member'

    def is_showcase_archived(self):
        """
        Check if the union tag is ``showcase_archived``.

        :rtype: bool
        """
        return self._tag == 'showcase_archived'

    def is_showcase_created(self):
        """
        Check if the union tag is ``showcase_created``.

        :rtype: bool
        """
        return self._tag == 'showcase_created'

    def is_showcase_delete_comment(self):
        """
        Check if the union tag is ``showcase_delete_comment``.

        :rtype: bool
        """
        return self._tag == 'showcase_delete_comment'

    def is_showcase_edited(self):
        """
        Check if the union tag is ``showcase_edited``.

        :rtype: bool
        """
        return self._tag == 'showcase_edited'

    def is_showcase_edit_comment(self):
        """
        Check if the union tag is ``showcase_edit_comment``.

        :rtype: bool
        """
        return self._tag == 'showcase_edit_comment'

    def is_showcase_file_added(self):
        """
        Check if the union tag is ``showcase_file_added``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_added'

    def is_showcase_file_download(self):
        """
        Check if the union tag is ``showcase_file_download``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_download'

    def is_showcase_file_removed(self):
        """
        Check if the union tag is ``showcase_file_removed``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_removed'

    def is_showcase_file_view(self):
        """
        Check if the union tag is ``showcase_file_view``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_view'

    def is_showcase_permanently_deleted(self):
        """
        Check if the union tag is ``showcase_permanently_deleted``.

        :rtype: bool
        """
        return self._tag == 'showcase_permanently_deleted'

    def is_showcase_post_comment(self):
        """
        Check if the union tag is ``showcase_post_comment``.

        :rtype: bool
        """
        return self._tag == 'showcase_post_comment'

    def is_showcase_remove_member(self):
        """
        Check if the union tag is ``showcase_remove_member``.

        :rtype: bool
        """
        return self._tag == 'showcase_remove_member'

    def is_showcase_renamed(self):
        """
        Check if the union tag is ``showcase_renamed``.

        :rtype: bool
        """
        return self._tag == 'showcase_renamed'

    def is_showcase_request_access(self):
        """
        Check if the union tag is ``showcase_request_access``.

        :rtype: bool
        """
        return self._tag == 'showcase_request_access'

    def is_showcase_resolve_comment(self):
        """
        Check if the union tag is ``showcase_resolve_comment``.

        :rtype: bool
        """
        return self._tag == 'showcase_resolve_comment'

    def is_showcase_restored(self):
        """
        Check if the union tag is ``showcase_restored``.

        :rtype: bool
        """
        return self._tag == 'showcase_restored'

    def is_showcase_trashed(self):
        """
        Check if the union tag is ``showcase_trashed``.

        :rtype: bool
        """
        return self._tag == 'showcase_trashed'

    def is_showcase_trashed_deprecated(self):
        """
        Check if the union tag is ``showcase_trashed_deprecated``.

        :rtype: bool
        """
        return self._tag == 'showcase_trashed_deprecated'

    def is_showcase_unresolve_comment(self):
        """
        Check if the union tag is ``showcase_unresolve_comment``.

        :rtype: bool
        """
        return self._tag == 'showcase_unresolve_comment'

    def is_showcase_untrashed(self):
        """
        Check if the union tag is ``showcase_untrashed``.

        :rtype: bool
        """
        return self._tag == 'showcase_untrashed'

    def is_showcase_untrashed_deprecated(self):
        """
        Check if the union tag is ``showcase_untrashed_deprecated``.

        :rtype: bool
        """
        return self._tag == 'showcase_untrashed_deprecated'

    def is_showcase_view(self):
        """
        Check if the union tag is ``showcase_view``.

        :rtype: bool
        """
        return self._tag == 'showcase_view'

    def is_sso_add_cert(self):
        """
        Check if the union tag is ``sso_add_cert``.

        :rtype: bool
        """
        return self._tag == 'sso_add_cert'

    def is_sso_add_login_url(self):
        """
        Check if the union tag is ``sso_add_login_url``.

        :rtype: bool
        """
        return self._tag == 'sso_add_login_url'

    def is_sso_add_logout_url(self):
        """
        Check if the union tag is ``sso_add_logout_url``.

        :rtype: bool
        """
        return self._tag == 'sso_add_logout_url'

    def is_sso_change_cert(self):
        """
        Check if the union tag is ``sso_change_cert``.

        :rtype: bool
        """
        return self._tag == 'sso_change_cert'

    def is_sso_change_login_url(self):
        """
        Check if the union tag is ``sso_change_login_url``.

        :rtype: bool
        """
        return self._tag == 'sso_change_login_url'

    def is_sso_change_logout_url(self):
        """
        Check if the union tag is ``sso_change_logout_url``.

        :rtype: bool
        """
        return self._tag == 'sso_change_logout_url'

    def is_sso_change_saml_identity_mode(self):
        """
        Check if the union tag is ``sso_change_saml_identity_mode``.

        :rtype: bool
        """
        return self._tag == 'sso_change_saml_identity_mode'

    def is_sso_remove_cert(self):
        """
        Check if the union tag is ``sso_remove_cert``.

        :rtype: bool
        """
        return self._tag == 'sso_remove_cert'

    def is_sso_remove_login_url(self):
        """
        Check if the union tag is ``sso_remove_login_url``.

        :rtype: bool
        """
        return self._tag == 'sso_remove_login_url'

    def is_sso_remove_logout_url(self):
        """
        Check if the union tag is ``sso_remove_logout_url``.

        :rtype: bool
        """
        return self._tag == 'sso_remove_logout_url'

    def is_team_folder_change_status(self):
        """
        Check if the union tag is ``team_folder_change_status``.

        :rtype: bool
        """
        return self._tag == 'team_folder_change_status'

    def is_team_folder_create(self):
        """
        Check if the union tag is ``team_folder_create``.

        :rtype: bool
        """
        return self._tag == 'team_folder_create'

    def is_team_folder_downgrade(self):
        """
        Check if the union tag is ``team_folder_downgrade``.

        :rtype: bool
        """
        return self._tag == 'team_folder_downgrade'

    def is_team_folder_permanently_delete(self):
        """
        Check if the union tag is ``team_folder_permanently_delete``.

        :rtype: bool
        """
        return self._tag == 'team_folder_permanently_delete'

    def is_team_folder_rename(self):
        """
        Check if the union tag is ``team_folder_rename``.

        :rtype: bool
        """
        return self._tag == 'team_folder_rename'

    def is_team_selective_sync_settings_changed(self):
        """
        Check if the union tag is ``team_selective_sync_settings_changed``.

        :rtype: bool
        """
        return self._tag == 'team_selective_sync_settings_changed'

    def is_account_capture_change_policy(self):
        """
        Check if the union tag is ``account_capture_change_policy``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_policy'

    def is_allow_download_disabled(self):
        """
        Check if the union tag is ``allow_download_disabled``.

        :rtype: bool
        """
        return self._tag == 'allow_download_disabled'

    def is_allow_download_enabled(self):
        """
        Check if the union tag is ``allow_download_enabled``.

        :rtype: bool
        """
        return self._tag == 'allow_download_enabled'

    def is_data_placement_restriction_change_policy(self):
        """
        Check if the union tag is ``data_placement_restriction_change_policy``.

        :rtype: bool
        """
        return self._tag == 'data_placement_restriction_change_policy'

    def is_data_placement_restriction_satisfy_policy(self):
        """
        Check if the union tag is ``data_placement_restriction_satisfy_policy``.

        :rtype: bool
        """
        return self._tag == 'data_placement_restriction_satisfy_policy'

    def is_device_approvals_change_desktop_policy(self):
        """
        Check if the union tag is ``device_approvals_change_desktop_policy``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_desktop_policy'

    def is_device_approvals_change_mobile_policy(self):
        """
        Check if the union tag is ``device_approvals_change_mobile_policy``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_mobile_policy'

    def is_device_approvals_change_overage_action(self):
        """
        Check if the union tag is ``device_approvals_change_overage_action``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_overage_action'

    def is_device_approvals_change_unlink_action(self):
        """
        Check if the union tag is ``device_approvals_change_unlink_action``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_unlink_action'

    def is_directory_restrictions_add_members(self):
        """
        Check if the union tag is ``directory_restrictions_add_members``.

        :rtype: bool
        """
        return self._tag == 'directory_restrictions_add_members'

    def is_directory_restrictions_remove_members(self):
        """
        Check if the union tag is ``directory_restrictions_remove_members``.

        :rtype: bool
        """
        return self._tag == 'directory_restrictions_remove_members'

    def is_emm_add_exception(self):
        """
        Check if the union tag is ``emm_add_exception``.

        :rtype: bool
        """
        return self._tag == 'emm_add_exception'

    def is_emm_change_policy(self):
        """
        Check if the union tag is ``emm_change_policy``.

        :rtype: bool
        """
        return self._tag == 'emm_change_policy'

    def is_emm_remove_exception(self):
        """
        Check if the union tag is ``emm_remove_exception``.

        :rtype: bool
        """
        return self._tag == 'emm_remove_exception'

    def is_extended_version_history_change_policy(self):
        """
        Check if the union tag is ``extended_version_history_change_policy``.

        :rtype: bool
        """
        return self._tag == 'extended_version_history_change_policy'

    def is_file_comments_change_policy(self):
        """
        Check if the union tag is ``file_comments_change_policy``.

        :rtype: bool
        """
        return self._tag == 'file_comments_change_policy'

    def is_file_requests_change_policy(self):
        """
        Check if the union tag is ``file_requests_change_policy``.

        :rtype: bool
        """
        return self._tag == 'file_requests_change_policy'

    def is_file_requests_emails_enabled(self):
        """
        Check if the union tag is ``file_requests_emails_enabled``.

        :rtype: bool
        """
        return self._tag == 'file_requests_emails_enabled'

    def is_file_requests_emails_restricted_to_team_only(self):
        """
        Check if the union tag is ``file_requests_emails_restricted_to_team_only``.

        :rtype: bool
        """
        return self._tag == 'file_requests_emails_restricted_to_team_only'

    def is_google_sso_change_policy(self):
        """
        Check if the union tag is ``google_sso_change_policy``.

        :rtype: bool
        """
        return self._tag == 'google_sso_change_policy'

    def is_group_user_management_change_policy(self):
        """
        Check if the union tag is ``group_user_management_change_policy``.

        :rtype: bool
        """
        return self._tag == 'group_user_management_change_policy'

    def is_member_requests_change_policy(self):
        """
        Check if the union tag is ``member_requests_change_policy``.

        :rtype: bool
        """
        return self._tag == 'member_requests_change_policy'

    def is_member_space_limits_add_exception(self):
        """
        Check if the union tag is ``member_space_limits_add_exception``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_add_exception'

    def is_member_space_limits_change_caps_type_policy(self):
        """
        Check if the union tag is ``member_space_limits_change_caps_type_policy``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_caps_type_policy'

    def is_member_space_limits_change_policy(self):
        """
        Check if the union tag is ``member_space_limits_change_policy``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_policy'

    def is_member_space_limits_remove_exception(self):
        """
        Check if the union tag is ``member_space_limits_remove_exception``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_remove_exception'

    def is_member_suggestions_change_policy(self):
        """
        Check if the union tag is ``member_suggestions_change_policy``.

        :rtype: bool
        """
        return self._tag == 'member_suggestions_change_policy'

    def is_microsoft_office_addin_change_policy(self):
        """
        Check if the union tag is ``microsoft_office_addin_change_policy``.

        :rtype: bool
        """
        return self._tag == 'microsoft_office_addin_change_policy'

    def is_network_control_change_policy(self):
        """
        Check if the union tag is ``network_control_change_policy``.

        :rtype: bool
        """
        return self._tag == 'network_control_change_policy'

    def is_paper_change_deployment_policy(self):
        """
        Check if the union tag is ``paper_change_deployment_policy``.

        :rtype: bool
        """
        return self._tag == 'paper_change_deployment_policy'

    def is_paper_change_member_link_policy(self):
        """
        Check if the union tag is ``paper_change_member_link_policy``.

        :rtype: bool
        """
        return self._tag == 'paper_change_member_link_policy'

    def is_paper_change_member_policy(self):
        """
        Check if the union tag is ``paper_change_member_policy``.

        :rtype: bool
        """
        return self._tag == 'paper_change_member_policy'

    def is_paper_change_policy(self):
        """
        Check if the union tag is ``paper_change_policy``.

        :rtype: bool
        """
        return self._tag == 'paper_change_policy'

    def is_paper_enabled_users_group_addition(self):
        """
        Check if the union tag is ``paper_enabled_users_group_addition``.

        :rtype: bool
        """
        return self._tag == 'paper_enabled_users_group_addition'

    def is_paper_enabled_users_group_removal(self):
        """
        Check if the union tag is ``paper_enabled_users_group_removal``.

        :rtype: bool
        """
        return self._tag == 'paper_enabled_users_group_removal'

    def is_permanent_delete_change_policy(self):
        """
        Check if the union tag is ``permanent_delete_change_policy``.

        :rtype: bool
        """
        return self._tag == 'permanent_delete_change_policy'

    def is_sharing_change_folder_join_policy(self):
        """
        Check if the union tag is ``sharing_change_folder_join_policy``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_folder_join_policy'

    def is_sharing_change_link_policy(self):
        """
        Check if the union tag is ``sharing_change_link_policy``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_link_policy'

    def is_sharing_change_member_policy(self):
        """
        Check if the union tag is ``sharing_change_member_policy``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_member_policy'

    def is_showcase_change_download_policy(self):
        """
        Check if the union tag is ``showcase_change_download_policy``.

        :rtype: bool
        """
        return self._tag == 'showcase_change_download_policy'

    def is_showcase_change_enabled_policy(self):
        """
        Check if the union tag is ``showcase_change_enabled_policy``.

        :rtype: bool
        """
        return self._tag == 'showcase_change_enabled_policy'

    def is_showcase_change_external_sharing_policy(self):
        """
        Check if the union tag is ``showcase_change_external_sharing_policy``.

        :rtype: bool
        """
        return self._tag == 'showcase_change_external_sharing_policy'

    def is_smart_sync_change_policy(self):
        """
        Check if the union tag is ``smart_sync_change_policy``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_change_policy'

    def is_smart_sync_not_opt_out(self):
        """
        Check if the union tag is ``smart_sync_not_opt_out``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_not_opt_out'

    def is_smart_sync_opt_out(self):
        """
        Check if the union tag is ``smart_sync_opt_out``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_opt_out'

    def is_sso_change_policy(self):
        """
        Check if the union tag is ``sso_change_policy``.

        :rtype: bool
        """
        return self._tag == 'sso_change_policy'

    def is_team_selective_sync_policy_changed(self):
        """
        Check if the union tag is ``team_selective_sync_policy_changed``.

        :rtype: bool
        """
        return self._tag == 'team_selective_sync_policy_changed'

    def is_tfa_change_policy(self):
        """
        Check if the union tag is ``tfa_change_policy``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_policy'

    def is_two_account_change_policy(self):
        """
        Check if the union tag is ``two_account_change_policy``.

        :rtype: bool
        """
        return self._tag == 'two_account_change_policy'

    def is_viewer_info_policy_changed(self):
        """
        Check if the union tag is ``viewer_info_policy_changed``.

        :rtype: bool
        """
        return self._tag == 'viewer_info_policy_changed'

    def is_web_sessions_change_fixed_length_policy(self):
        """
        Check if the union tag is ``web_sessions_change_fixed_length_policy``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_fixed_length_policy'

    def is_web_sessions_change_idle_length_policy(self):
        """
        Check if the union tag is ``web_sessions_change_idle_length_policy``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_idle_length_policy'

    def is_team_merge_from(self):
        """
        Check if the union tag is ``team_merge_from``.

        :rtype: bool
        """
        return self._tag == 'team_merge_from'

    def is_team_merge_to(self):
        """
        Check if the union tag is ``team_merge_to``.

        :rtype: bool
        """
        return self._tag == 'team_merge_to'

    def is_team_profile_add_logo(self):
        """
        Check if the union tag is ``team_profile_add_logo``.

        :rtype: bool
        """
        return self._tag == 'team_profile_add_logo'

    def is_team_profile_change_default_language(self):
        """
        Check if the union tag is ``team_profile_change_default_language``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_default_language'

    def is_team_profile_change_logo(self):
        """
        Check if the union tag is ``team_profile_change_logo``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_logo'

    def is_team_profile_change_name(self):
        """
        Check if the union tag is ``team_profile_change_name``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_name'

    def is_team_profile_remove_logo(self):
        """
        Check if the union tag is ``team_profile_remove_logo``.

        :rtype: bool
        """
        return self._tag == 'team_profile_remove_logo'

    def is_tfa_add_backup_phone(self):
        """
        Check if the union tag is ``tfa_add_backup_phone``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_backup_phone'

    def is_tfa_add_security_key(self):
        """
        Check if the union tag is ``tfa_add_security_key``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_security_key'

    def is_tfa_change_backup_phone(self):
        """
        Check if the union tag is ``tfa_change_backup_phone``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_backup_phone'

    def is_tfa_change_status(self):
        """
        Check if the union tag is ``tfa_change_status``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_status'

    def is_tfa_remove_backup_phone(self):
        """
        Check if the union tag is ``tfa_remove_backup_phone``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_backup_phone'

    def is_tfa_remove_security_key(self):
        """
        Check if the union tag is ``tfa_remove_security_key``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_security_key'

    def is_tfa_reset(self):
        """
        Check if the union tag is ``tfa_reset``.

        :rtype: bool
        """
        return self._tag == 'tfa_reset'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_app_link_team(self):
        """
        (apps) Linked app for team

        Only call this if :meth:`is_app_link_team` is true.

        :rtype: AppLinkTeamType
        """
        if not self.is_app_link_team():
            raise AttributeError("tag 'app_link_team' not set")
        return self._value

    def get_app_link_user(self):
        """
        (apps) Linked app for member

        Only call this if :meth:`is_app_link_user` is true.

        :rtype: AppLinkUserType
        """
        if not self.is_app_link_user():
            raise AttributeError("tag 'app_link_user' not set")
        return self._value

    def get_app_unlink_team(self):
        """
        (apps) Unlinked app for team

        Only call this if :meth:`is_app_unlink_team` is true.

        :rtype: AppUnlinkTeamType
        """
        if not self.is_app_unlink_team():
            raise AttributeError("tag 'app_unlink_team' not set")
        return self._value

    def get_app_unlink_user(self):
        """
        (apps) Unlinked app for member

        Only call this if :meth:`is_app_unlink_user` is true.

        :rtype: AppUnlinkUserType
        """
        if not self.is_app_unlink_user():
            raise AttributeError("tag 'app_unlink_user' not set")
        return self._value

    def get_file_add_comment(self):
        """
        (comments) Added file comment

        Only call this if :meth:`is_file_add_comment` is true.

        :rtype: FileAddCommentType
        """
        if not self.is_file_add_comment():
            raise AttributeError("tag 'file_add_comment' not set")
        return self._value

    def get_file_change_comment_subscription(self):
        """
        (comments) Subscribed to or unsubscribed from comment notifications for
        file

        Only call this if :meth:`is_file_change_comment_subscription` is true.

        :rtype: FileChangeCommentSubscriptionType
        """
        if not self.is_file_change_comment_subscription():
            raise AttributeError("tag 'file_change_comment_subscription' not set")
        return self._value

    def get_file_delete_comment(self):
        """
        (comments) Deleted file comment

        Only call this if :meth:`is_file_delete_comment` is true.

        :rtype: FileDeleteCommentType
        """
        if not self.is_file_delete_comment():
            raise AttributeError("tag 'file_delete_comment' not set")
        return self._value

    def get_file_like_comment(self):
        """
        (comments) Liked file comment (deprecated, no longer logged)

        Only call this if :meth:`is_file_like_comment` is true.

        :rtype: FileLikeCommentType
        """
        if not self.is_file_like_comment():
            raise AttributeError("tag 'file_like_comment' not set")
        return self._value

    def get_file_resolve_comment(self):
        """
        (comments) Resolved file comment

        Only call this if :meth:`is_file_resolve_comment` is true.

        :rtype: FileResolveCommentType
        """
        if not self.is_file_resolve_comment():
            raise AttributeError("tag 'file_resolve_comment' not set")
        return self._value

    def get_file_unlike_comment(self):
        """
        (comments) Unliked file comment (deprecated, no longer logged)

        Only call this if :meth:`is_file_unlike_comment` is true.

        :rtype: FileUnlikeCommentType
        """
        if not self.is_file_unlike_comment():
            raise AttributeError("tag 'file_unlike_comment' not set")
        return self._value

    def get_file_unresolve_comment(self):
        """
        (comments) Unresolved file comment

        Only call this if :meth:`is_file_unresolve_comment` is true.

        :rtype: FileUnresolveCommentType
        """
        if not self.is_file_unresolve_comment():
            raise AttributeError("tag 'file_unresolve_comment' not set")
        return self._value

    def get_device_change_ip_desktop(self):
        """
        (devices) Changed IP address associated with active desktop session

        Only call this if :meth:`is_device_change_ip_desktop` is true.

        :rtype: DeviceChangeIpDesktopType
        """
        if not self.is_device_change_ip_desktop():
            raise AttributeError("tag 'device_change_ip_desktop' not set")
        return self._value

    def get_device_change_ip_mobile(self):
        """
        (devices) Changed IP address associated with active mobile session

        Only call this if :meth:`is_device_change_ip_mobile` is true.

        :rtype: DeviceChangeIpMobileType
        """
        if not self.is_device_change_ip_mobile():
            raise AttributeError("tag 'device_change_ip_mobile' not set")
        return self._value

    def get_device_change_ip_web(self):
        """
        (devices) Changed IP address associated with active web session

        Only call this if :meth:`is_device_change_ip_web` is true.

        :rtype: DeviceChangeIpWebType
        """
        if not self.is_device_change_ip_web():
            raise AttributeError("tag 'device_change_ip_web' not set")
        return self._value

    def get_device_delete_on_unlink_fail(self):
        """
        (devices) Failed to delete all files from unlinked device

        Only call this if :meth:`is_device_delete_on_unlink_fail` is true.

        :rtype: DeviceDeleteOnUnlinkFailType
        """
        if not self.is_device_delete_on_unlink_fail():
            raise AttributeError("tag 'device_delete_on_unlink_fail' not set")
        return self._value

    def get_device_delete_on_unlink_success(self):
        """
        (devices) Deleted all files from unlinked device

        Only call this if :meth:`is_device_delete_on_unlink_success` is true.

        :rtype: DeviceDeleteOnUnlinkSuccessType
        """
        if not self.is_device_delete_on_unlink_success():
            raise AttributeError("tag 'device_delete_on_unlink_success' not set")
        return self._value

    def get_device_link_fail(self):
        """
        (devices) Failed to link device

        Only call this if :meth:`is_device_link_fail` is true.

        :rtype: DeviceLinkFailType
        """
        if not self.is_device_link_fail():
            raise AttributeError("tag 'device_link_fail' not set")
        return self._value

    def get_device_link_success(self):
        """
        (devices) Linked device

        Only call this if :meth:`is_device_link_success` is true.

        :rtype: DeviceLinkSuccessType
        """
        if not self.is_device_link_success():
            raise AttributeError("tag 'device_link_success' not set")
        return self._value

    def get_device_management_disabled(self):
        """
        (devices) Disabled device management (deprecated, no longer logged)

        Only call this if :meth:`is_device_management_disabled` is true.

        :rtype: DeviceManagementDisabledType
        """
        if not self.is_device_management_disabled():
            raise AttributeError("tag 'device_management_disabled' not set")
        return self._value

    def get_device_management_enabled(self):
        """
        (devices) Enabled device management (deprecated, no longer logged)

        Only call this if :meth:`is_device_management_enabled` is true.

        :rtype: DeviceManagementEnabledType
        """
        if not self.is_device_management_enabled():
            raise AttributeError("tag 'device_management_enabled' not set")
        return self._value

    def get_device_unlink(self):
        """
        (devices) Disconnected device

        Only call this if :meth:`is_device_unlink` is true.

        :rtype: DeviceUnlinkType
        """
        if not self.is_device_unlink():
            raise AttributeError("tag 'device_unlink' not set")
        return self._value

    def get_emm_refresh_auth_token(self):
        """
        (devices) Refreshed auth token used for setting up enterprise mobility
        management

        Only call this if :meth:`is_emm_refresh_auth_token` is true.

        :rtype: EmmRefreshAuthTokenType
        """
        if not self.is_emm_refresh_auth_token():
            raise AttributeError("tag 'emm_refresh_auth_token' not set")
        return self._value

    def get_account_capture_change_availability(self):
        """
        (domains) Granted/revoked option to enable account capture on team
        domains

        Only call this if :meth:`is_account_capture_change_availability` is true.

        :rtype: AccountCaptureChangeAvailabilityType
        """
        if not self.is_account_capture_change_availability():
            raise AttributeError("tag 'account_capture_change_availability' not set")
        return self._value

    def get_account_capture_migrate_account(self):
        """
        (domains) Account-captured user migrated account to team

        Only call this if :meth:`is_account_capture_migrate_account` is true.

        :rtype: AccountCaptureMigrateAccountType
        """
        if not self.is_account_capture_migrate_account():
            raise AttributeError("tag 'account_capture_migrate_account' not set")
        return self._value

    def get_account_capture_notification_emails_sent(self):
        """
        (domains) Sent proactive account capture email to all unmanaged members

        Only call this if :meth:`is_account_capture_notification_emails_sent` is true.

        :rtype: AccountCaptureNotificationEmailsSentType
        """
        if not self.is_account_capture_notification_emails_sent():
            raise AttributeError("tag 'account_capture_notification_emails_sent' not set")
        return self._value

    def get_account_capture_relinquish_account(self):
        """
        (domains) Account-captured user changed account email to personal email

        Only call this if :meth:`is_account_capture_relinquish_account` is true.

        :rtype: AccountCaptureRelinquishAccountType
        """
        if not self.is_account_capture_relinquish_account():
            raise AttributeError("tag 'account_capture_relinquish_account' not set")
        return self._value

    def get_disabled_domain_invites(self):
        """
        (domains) Disabled domain invites (deprecated, no longer logged)

        Only call this if :meth:`is_disabled_domain_invites` is true.

        :rtype: DisabledDomainInvitesType
        """
        if not self.is_disabled_domain_invites():
            raise AttributeError("tag 'disabled_domain_invites' not set")
        return self._value

    def get_domain_invites_approve_request_to_join_team(self):
        """
        (domains) Approved user's request to join team

        Only call this if :meth:`is_domain_invites_approve_request_to_join_team` is true.

        :rtype: DomainInvitesApproveRequestToJoinTeamType
        """
        if not self.is_domain_invites_approve_request_to_join_team():
            raise AttributeError("tag 'domain_invites_approve_request_to_join_team' not set")
        return self._value

    def get_domain_invites_decline_request_to_join_team(self):
        """
        (domains) Declined user's request to join team

        Only call this if :meth:`is_domain_invites_decline_request_to_join_team` is true.

        :rtype: DomainInvitesDeclineRequestToJoinTeamType
        """
        if not self.is_domain_invites_decline_request_to_join_team():
            raise AttributeError("tag 'domain_invites_decline_request_to_join_team' not set")
        return self._value

    def get_domain_invites_email_existing_users(self):
        """
        (domains) Sent domain invites to existing domain accounts (deprecated,
        no longer logged)

        Only call this if :meth:`is_domain_invites_email_existing_users` is true.

        :rtype: DomainInvitesEmailExistingUsersType
        """
        if not self.is_domain_invites_email_existing_users():
            raise AttributeError("tag 'domain_invites_email_existing_users' not set")
        return self._value

    def get_domain_invites_request_to_join_team(self):
        """
        (domains) Requested to join team

        Only call this if :meth:`is_domain_invites_request_to_join_team` is true.

        :rtype: DomainInvitesRequestToJoinTeamType
        """
        if not self.is_domain_invites_request_to_join_team():
            raise AttributeError("tag 'domain_invites_request_to_join_team' not set")
        return self._value

    def get_domain_invites_set_invite_new_user_pref_to_no(self):
        """
        (domains) Disabled "Automatically invite new users" (deprecated, no
        longer logged)

        Only call this if :meth:`is_domain_invites_set_invite_new_user_pref_to_no` is true.

        :rtype: DomainInvitesSetInviteNewUserPrefToNoType
        """
        if not self.is_domain_invites_set_invite_new_user_pref_to_no():
            raise AttributeError("tag 'domain_invites_set_invite_new_user_pref_to_no' not set")
        return self._value

    def get_domain_invites_set_invite_new_user_pref_to_yes(self):
        """
        (domains) Enabled "Automatically invite new users" (deprecated, no
        longer logged)

        Only call this if :meth:`is_domain_invites_set_invite_new_user_pref_to_yes` is true.

        :rtype: DomainInvitesSetInviteNewUserPrefToYesType
        """
        if not self.is_domain_invites_set_invite_new_user_pref_to_yes():
            raise AttributeError("tag 'domain_invites_set_invite_new_user_pref_to_yes' not set")
        return self._value

    def get_domain_verification_add_domain_fail(self):
        """
        (domains) Failed to verify team domain

        Only call this if :meth:`is_domain_verification_add_domain_fail` is true.

        :rtype: DomainVerificationAddDomainFailType
        """
        if not self.is_domain_verification_add_domain_fail():
            raise AttributeError("tag 'domain_verification_add_domain_fail' not set")
        return self._value

    def get_domain_verification_add_domain_success(self):
        """
        (domains) Verified team domain

        Only call this if :meth:`is_domain_verification_add_domain_success` is true.

        :rtype: DomainVerificationAddDomainSuccessType
        """
        if not self.is_domain_verification_add_domain_success():
            raise AttributeError("tag 'domain_verification_add_domain_success' not set")
        return self._value

    def get_domain_verification_remove_domain(self):
        """
        (domains) Removed domain from list of verified team domains

        Only call this if :meth:`is_domain_verification_remove_domain` is true.

        :rtype: DomainVerificationRemoveDomainType
        """
        if not self.is_domain_verification_remove_domain():
            raise AttributeError("tag 'domain_verification_remove_domain' not set")
        return self._value

    def get_enabled_domain_invites(self):
        """
        (domains) Enabled domain invites (deprecated, no longer logged)

        Only call this if :meth:`is_enabled_domain_invites` is true.

        :rtype: EnabledDomainInvitesType
        """
        if not self.is_enabled_domain_invites():
            raise AttributeError("tag 'enabled_domain_invites' not set")
        return self._value

    def get_create_folder(self):
        """
        (file_operations) Created folders (deprecated, no longer logged)

        Only call this if :meth:`is_create_folder` is true.

        :rtype: CreateFolderType
        """
        if not self.is_create_folder():
            raise AttributeError("tag 'create_folder' not set")
        return self._value

    def get_file_add(self):
        """
        (file_operations) Added files and/or folders

        Only call this if :meth:`is_file_add` is true.

        :rtype: FileAddType
        """
        if not self.is_file_add():
            raise AttributeError("tag 'file_add' not set")
        return self._value

    def get_file_copy(self):
        """
        (file_operations) Copied files and/or folders

        Only call this if :meth:`is_file_copy` is true.

        :rtype: FileCopyType
        """
        if not self.is_file_copy():
            raise AttributeError("tag 'file_copy' not set")
        return self._value

    def get_file_delete(self):
        """
        (file_operations) Deleted files and/or folders

        Only call this if :meth:`is_file_delete` is true.

        :rtype: FileDeleteType
        """
        if not self.is_file_delete():
            raise AttributeError("tag 'file_delete' not set")
        return self._value

    def get_file_download(self):
        """
        (file_operations) Downloaded files and/or folders

        Only call this if :meth:`is_file_download` is true.

        :rtype: FileDownloadType
        """
        if not self.is_file_download():
            raise AttributeError("tag 'file_download' not set")
        return self._value

    def get_file_edit(self):
        """
        (file_operations) Edited files

        Only call this if :meth:`is_file_edit` is true.

        :rtype: FileEditType
        """
        if not self.is_file_edit():
            raise AttributeError("tag 'file_edit' not set")
        return self._value

    def get_file_get_copy_reference(self):
        """
        (file_operations) Created copy reference to file/folder

        Only call this if :meth:`is_file_get_copy_reference` is true.

        :rtype: FileGetCopyReferenceType
        """
        if not self.is_file_get_copy_reference():
            raise AttributeError("tag 'file_get_copy_reference' not set")
        return self._value

    def get_file_move(self):
        """
        (file_operations) Moved files and/or folders

        Only call this if :meth:`is_file_move` is true.

        :rtype: FileMoveType
        """
        if not self.is_file_move():
            raise AttributeError("tag 'file_move' not set")
        return self._value

    def get_file_permanently_delete(self):
        """
        (file_operations) Permanently deleted files and/or folders

        Only call this if :meth:`is_file_permanently_delete` is true.

        :rtype: FilePermanentlyDeleteType
        """
        if not self.is_file_permanently_delete():
            raise AttributeError("tag 'file_permanently_delete' not set")
        return self._value

    def get_file_preview(self):
        """
        (file_operations) Previewed files and/or folders

        Only call this if :meth:`is_file_preview` is true.

        :rtype: FilePreviewType
        """
        if not self.is_file_preview():
            raise AttributeError("tag 'file_preview' not set")
        return self._value

    def get_file_rename(self):
        """
        (file_operations) Renamed files and/or folders

        Only call this if :meth:`is_file_rename` is true.

        :rtype: FileRenameType
        """
        if not self.is_file_rename():
            raise AttributeError("tag 'file_rename' not set")
        return self._value

    def get_file_restore(self):
        """
        (file_operations) Restored deleted files and/or folders

        Only call this if :meth:`is_file_restore` is true.

        :rtype: FileRestoreType
        """
        if not self.is_file_restore():
            raise AttributeError("tag 'file_restore' not set")
        return self._value

    def get_file_revert(self):
        """
        (file_operations) Reverted files to previous version

        Only call this if :meth:`is_file_revert` is true.

        :rtype: FileRevertType
        """
        if not self.is_file_revert():
            raise AttributeError("tag 'file_revert' not set")
        return self._value

    def get_file_rollback_changes(self):
        """
        (file_operations) Rolled back file actions

        Only call this if :meth:`is_file_rollback_changes` is true.

        :rtype: FileRollbackChangesType
        """
        if not self.is_file_rollback_changes():
            raise AttributeError("tag 'file_rollback_changes' not set")
        return self._value

    def get_file_save_copy_reference(self):
        """
        (file_operations) Saved file/folder using copy reference

        Only call this if :meth:`is_file_save_copy_reference` is true.

        :rtype: FileSaveCopyReferenceType
        """
        if not self.is_file_save_copy_reference():
            raise AttributeError("tag 'file_save_copy_reference' not set")
        return self._value

    def get_file_request_change(self):
        """
        (file_requests) Changed file request

        Only call this if :meth:`is_file_request_change` is true.

        :rtype: FileRequestChangeType
        """
        if not self.is_file_request_change():
            raise AttributeError("tag 'file_request_change' not set")
        return self._value

    def get_file_request_close(self):
        """
        (file_requests) Closed file request

        Only call this if :meth:`is_file_request_close` is true.

        :rtype: FileRequestCloseType
        """
        if not self.is_file_request_close():
            raise AttributeError("tag 'file_request_close' not set")
        return self._value

    def get_file_request_create(self):
        """
        (file_requests) Created file request

        Only call this if :meth:`is_file_request_create` is true.

        :rtype: FileRequestCreateType
        """
        if not self.is_file_request_create():
            raise AttributeError("tag 'file_request_create' not set")
        return self._value

    def get_file_request_receive_file(self):
        """
        (file_requests) Received files for file request

        Only call this if :meth:`is_file_request_receive_file` is true.

        :rtype: FileRequestReceiveFileType
        """
        if not self.is_file_request_receive_file():
            raise AttributeError("tag 'file_request_receive_file' not set")
        return self._value

    def get_group_add_external_id(self):
        """
        (groups) Added external ID for group

        Only call this if :meth:`is_group_add_external_id` is true.

        :rtype: GroupAddExternalIdType
        """
        if not self.is_group_add_external_id():
            raise AttributeError("tag 'group_add_external_id' not set")
        return self._value

    def get_group_add_member(self):
        """
        (groups) Added team members to group

        Only call this if :meth:`is_group_add_member` is true.

        :rtype: GroupAddMemberType
        """
        if not self.is_group_add_member():
            raise AttributeError("tag 'group_add_member' not set")
        return self._value

    def get_group_change_external_id(self):
        """
        (groups) Changed external ID for group

        Only call this if :meth:`is_group_change_external_id` is true.

        :rtype: GroupChangeExternalIdType
        """
        if not self.is_group_change_external_id():
            raise AttributeError("tag 'group_change_external_id' not set")
        return self._value

    def get_group_change_management_type(self):
        """
        (groups) Changed group management type

        Only call this if :meth:`is_group_change_management_type` is true.

        :rtype: GroupChangeManagementTypeType
        """
        if not self.is_group_change_management_type():
            raise AttributeError("tag 'group_change_management_type' not set")
        return self._value

    def get_group_change_member_role(self):
        """
        (groups) Changed manager permissions of group member

        Only call this if :meth:`is_group_change_member_role` is true.

        :rtype: GroupChangeMemberRoleType
        """
        if not self.is_group_change_member_role():
            raise AttributeError("tag 'group_change_member_role' not set")
        return self._value

    def get_group_create(self):
        """
        (groups) Created group

        Only call this if :meth:`is_group_create` is true.

        :rtype: GroupCreateType
        """
        if not self.is_group_create():
            raise AttributeError("tag 'group_create' not set")
        return self._value

    def get_group_delete(self):
        """
        (groups) Deleted group

        Only call this if :meth:`is_group_delete` is true.

        :rtype: GroupDeleteType
        """
        if not self.is_group_delete():
            raise AttributeError("tag 'group_delete' not set")
        return self._value

    def get_group_description_updated(self):
        """
        (groups) Updated group (deprecated, no longer logged)

        Only call this if :meth:`is_group_description_updated` is true.

        :rtype: GroupDescriptionUpdatedType
        """
        if not self.is_group_description_updated():
            raise AttributeError("tag 'group_description_updated' not set")
        return self._value

    def get_group_join_policy_updated(self):
        """
        (groups) Updated group join policy (deprecated, no longer logged)

        Only call this if :meth:`is_group_join_policy_updated` is true.

        :rtype: GroupJoinPolicyUpdatedType
        """
        if not self.is_group_join_policy_updated():
            raise AttributeError("tag 'group_join_policy_updated' not set")
        return self._value

    def get_group_moved(self):
        """
        (groups) Moved group (deprecated, no longer logged)

        Only call this if :meth:`is_group_moved` is true.

        :rtype: GroupMovedType
        """
        if not self.is_group_moved():
            raise AttributeError("tag 'group_moved' not set")
        return self._value

    def get_group_remove_external_id(self):
        """
        (groups) Removed external ID for group

        Only call this if :meth:`is_group_remove_external_id` is true.

        :rtype: GroupRemoveExternalIdType
        """
        if not self.is_group_remove_external_id():
            raise AttributeError("tag 'group_remove_external_id' not set")
        return self._value

    def get_group_remove_member(self):
        """
        (groups) Removed team members from group

        Only call this if :meth:`is_group_remove_member` is true.

        :rtype: GroupRemoveMemberType
        """
        if not self.is_group_remove_member():
            raise AttributeError("tag 'group_remove_member' not set")
        return self._value

    def get_group_rename(self):
        """
        (groups) Renamed group

        Only call this if :meth:`is_group_rename` is true.

        :rtype: GroupRenameType
        """
        if not self.is_group_rename():
            raise AttributeError("tag 'group_rename' not set")
        return self._value

    def get_emm_error(self):
        """
        (logins) Failed to sign in via EMM (deprecated, replaced by 'Failed to
        sign in')

        Only call this if :meth:`is_emm_error` is true.

        :rtype: EmmErrorType
        """
        if not self.is_emm_error():
            raise AttributeError("tag 'emm_error' not set")
        return self._value

    def get_login_fail(self):
        """
        (logins) Failed to sign in

        Only call this if :meth:`is_login_fail` is true.

        :rtype: LoginFailType
        """
        if not self.is_login_fail():
            raise AttributeError("tag 'login_fail' not set")
        return self._value

    def get_login_success(self):
        """
        (logins) Signed in

        Only call this if :meth:`is_login_success` is true.

        :rtype: LoginSuccessType
        """
        if not self.is_login_success():
            raise AttributeError("tag 'login_success' not set")
        return self._value

    def get_logout(self):
        """
        (logins) Signed out

        Only call this if :meth:`is_logout` is true.

        :rtype: LogoutType
        """
        if not self.is_logout():
            raise AttributeError("tag 'logout' not set")
        return self._value

    def get_reseller_support_session_end(self):
        """
        (logins) Ended reseller support session

        Only call this if :meth:`is_reseller_support_session_end` is true.

        :rtype: ResellerSupportSessionEndType
        """
        if not self.is_reseller_support_session_end():
            raise AttributeError("tag 'reseller_support_session_end' not set")
        return self._value

    def get_reseller_support_session_start(self):
        """
        (logins) Started reseller support session

        Only call this if :meth:`is_reseller_support_session_start` is true.

        :rtype: ResellerSupportSessionStartType
        """
        if not self.is_reseller_support_session_start():
            raise AttributeError("tag 'reseller_support_session_start' not set")
        return self._value

    def get_sign_in_as_session_end(self):
        """
        (logins) Ended admin sign-in-as session

        Only call this if :meth:`is_sign_in_as_session_end` is true.

        :rtype: SignInAsSessionEndType
        """
        if not self.is_sign_in_as_session_end():
            raise AttributeError("tag 'sign_in_as_session_end' not set")
        return self._value

    def get_sign_in_as_session_start(self):
        """
        (logins) Started admin sign-in-as session

        Only call this if :meth:`is_sign_in_as_session_start` is true.

        :rtype: SignInAsSessionStartType
        """
        if not self.is_sign_in_as_session_start():
            raise AttributeError("tag 'sign_in_as_session_start' not set")
        return self._value

    def get_sso_error(self):
        """
        (logins) Failed to sign in via SSO (deprecated, replaced by 'Failed to
        sign in')

        Only call this if :meth:`is_sso_error` is true.

        :rtype: SsoErrorType
        """
        if not self.is_sso_error():
            raise AttributeError("tag 'sso_error' not set")
        return self._value

    def get_member_add_name(self):
        """
        (members) Added team member name

        Only call this if :meth:`is_member_add_name` is true.

        :rtype: MemberAddNameType
        """
        if not self.is_member_add_name():
            raise AttributeError("tag 'member_add_name' not set")
        return self._value

    def get_member_change_admin_role(self):
        """
        (members) Changed team member admin role

        Only call this if :meth:`is_member_change_admin_role` is true.

        :rtype: MemberChangeAdminRoleType
        """
        if not self.is_member_change_admin_role():
            raise AttributeError("tag 'member_change_admin_role' not set")
        return self._value

    def get_member_change_email(self):
        """
        (members) Changed team member email

        Only call this if :meth:`is_member_change_email` is true.

        :rtype: MemberChangeEmailType
        """
        if not self.is_member_change_email():
            raise AttributeError("tag 'member_change_email' not set")
        return self._value

    def get_member_change_membership_type(self):
        """
        (members) Changed membership type (limited/full) of member (deprecated,
        no longer logged)

        Only call this if :meth:`is_member_change_membership_type` is true.

        :rtype: MemberChangeMembershipTypeType
        """
        if not self.is_member_change_membership_type():
            raise AttributeError("tag 'member_change_membership_type' not set")
        return self._value

    def get_member_change_name(self):
        """
        (members) Changed team member name

        Only call this if :meth:`is_member_change_name` is true.

        :rtype: MemberChangeNameType
        """
        if not self.is_member_change_name():
            raise AttributeError("tag 'member_change_name' not set")
        return self._value

    def get_member_change_status(self):
        """
        (members) Changed member status (invited, joined, suspended, etc.)

        Only call this if :meth:`is_member_change_status` is true.

        :rtype: MemberChangeStatusType
        """
        if not self.is_member_change_status():
            raise AttributeError("tag 'member_change_status' not set")
        return self._value

    def get_member_delete_manual_contacts(self):
        """
        (members) Cleared saved contacts

        Only call this if :meth:`is_member_delete_manual_contacts` is true.

        :rtype: MemberDeleteManualContactsType
        """
        if not self.is_member_delete_manual_contacts():
            raise AttributeError("tag 'member_delete_manual_contacts' not set")
        return self._value

    def get_member_permanently_delete_account_contents(self):
        """
        (members) Permanently deleted contents of deleted team member account

        Only call this if :meth:`is_member_permanently_delete_account_contents` is true.

        :rtype: MemberPermanentlyDeleteAccountContentsType
        """
        if not self.is_member_permanently_delete_account_contents():
            raise AttributeError("tag 'member_permanently_delete_account_contents' not set")
        return self._value

    def get_member_space_limits_add_custom_quota(self):
        """
        (members) Set custom member space limit

        Only call this if :meth:`is_member_space_limits_add_custom_quota` is true.

        :rtype: MemberSpaceLimitsAddCustomQuotaType
        """
        if not self.is_member_space_limits_add_custom_quota():
            raise AttributeError("tag 'member_space_limits_add_custom_quota' not set")
        return self._value

    def get_member_space_limits_change_custom_quota(self):
        """
        (members) Changed custom member space limit

        Only call this if :meth:`is_member_space_limits_change_custom_quota` is true.

        :rtype: MemberSpaceLimitsChangeCustomQuotaType
        """
        if not self.is_member_space_limits_change_custom_quota():
            raise AttributeError("tag 'member_space_limits_change_custom_quota' not set")
        return self._value

    def get_member_space_limits_change_status(self):
        """
        (members) Changed space limit status

        Only call this if :meth:`is_member_space_limits_change_status` is true.

        :rtype: MemberSpaceLimitsChangeStatusType
        """
        if not self.is_member_space_limits_change_status():
            raise AttributeError("tag 'member_space_limits_change_status' not set")
        return self._value

    def get_member_space_limits_remove_custom_quota(self):
        """
        (members) Removed custom member space limit

        Only call this if :meth:`is_member_space_limits_remove_custom_quota` is true.

        :rtype: MemberSpaceLimitsRemoveCustomQuotaType
        """
        if not self.is_member_space_limits_remove_custom_quota():
            raise AttributeError("tag 'member_space_limits_remove_custom_quota' not set")
        return self._value

    def get_member_suggest(self):
        """
        (members) Suggested person to add to team

        Only call this if :meth:`is_member_suggest` is true.

        :rtype: MemberSuggestType
        """
        if not self.is_member_suggest():
            raise AttributeError("tag 'member_suggest' not set")
        return self._value

    def get_member_transfer_account_contents(self):
        """
        (members) Transferred contents of deleted member account to another
        member

        Only call this if :meth:`is_member_transfer_account_contents` is true.

        :rtype: MemberTransferAccountContentsType
        """
        if not self.is_member_transfer_account_contents():
            raise AttributeError("tag 'member_transfer_account_contents' not set")
        return self._value

    def get_secondary_mails_policy_changed(self):
        """
        (members) Secondary mails policy changed

        Only call this if :meth:`is_secondary_mails_policy_changed` is true.

        :rtype: SecondaryMailsPolicyChangedType
        """
        if not self.is_secondary_mails_policy_changed():
            raise AttributeError("tag 'secondary_mails_policy_changed' not set")
        return self._value

    def get_paper_content_add_member(self):
        """
        (paper) Added team member to Paper doc/folder

        Only call this if :meth:`is_paper_content_add_member` is true.

        :rtype: PaperContentAddMemberType
        """
        if not self.is_paper_content_add_member():
            raise AttributeError("tag 'paper_content_add_member' not set")
        return self._value

    def get_paper_content_add_to_folder(self):
        """
        (paper) Added Paper doc/folder to folder

        Only call this if :meth:`is_paper_content_add_to_folder` is true.

        :rtype: PaperContentAddToFolderType
        """
        if not self.is_paper_content_add_to_folder():
            raise AttributeError("tag 'paper_content_add_to_folder' not set")
        return self._value

    def get_paper_content_archive(self):
        """
        (paper) Archived Paper doc/folder

        Only call this if :meth:`is_paper_content_archive` is true.

        :rtype: PaperContentArchiveType
        """
        if not self.is_paper_content_archive():
            raise AttributeError("tag 'paper_content_archive' not set")
        return self._value

    def get_paper_content_create(self):
        """
        (paper) Created Paper doc/folder

        Only call this if :meth:`is_paper_content_create` is true.

        :rtype: PaperContentCreateType
        """
        if not self.is_paper_content_create():
            raise AttributeError("tag 'paper_content_create' not set")
        return self._value

    def get_paper_content_permanently_delete(self):
        """
        (paper) Permanently deleted Paper doc/folder

        Only call this if :meth:`is_paper_content_permanently_delete` is true.

        :rtype: PaperContentPermanentlyDeleteType
        """
        if not self.is_paper_content_permanently_delete():
            raise AttributeError("tag 'paper_content_permanently_delete' not set")
        return self._value

    def get_paper_content_remove_from_folder(self):
        """
        (paper) Removed Paper doc/folder from folder

        Only call this if :meth:`is_paper_content_remove_from_folder` is true.

        :rtype: PaperContentRemoveFromFolderType
        """
        if not self.is_paper_content_remove_from_folder():
            raise AttributeError("tag 'paper_content_remove_from_folder' not set")
        return self._value

    def get_paper_content_remove_member(self):
        """
        (paper) Removed team member from Paper doc/folder

        Only call this if :meth:`is_paper_content_remove_member` is true.

        :rtype: PaperContentRemoveMemberType
        """
        if not self.is_paper_content_remove_member():
            raise AttributeError("tag 'paper_content_remove_member' not set")
        return self._value

    def get_paper_content_rename(self):
        """
        (paper) Renamed Paper doc/folder

        Only call this if :meth:`is_paper_content_rename` is true.

        :rtype: PaperContentRenameType
        """
        if not self.is_paper_content_rename():
            raise AttributeError("tag 'paper_content_rename' not set")
        return self._value

    def get_paper_content_restore(self):
        """
        (paper) Restored archived Paper doc/folder

        Only call this if :meth:`is_paper_content_restore` is true.

        :rtype: PaperContentRestoreType
        """
        if not self.is_paper_content_restore():
            raise AttributeError("tag 'paper_content_restore' not set")
        return self._value

    def get_paper_doc_add_comment(self):
        """
        (paper) Added Paper doc comment

        Only call this if :meth:`is_paper_doc_add_comment` is true.

        :rtype: PaperDocAddCommentType
        """
        if not self.is_paper_doc_add_comment():
            raise AttributeError("tag 'paper_doc_add_comment' not set")
        return self._value

    def get_paper_doc_change_member_role(self):
        """
        (paper) Changed team member permissions for Paper doc

        Only call this if :meth:`is_paper_doc_change_member_role` is true.

        :rtype: PaperDocChangeMemberRoleType
        """
        if not self.is_paper_doc_change_member_role():
            raise AttributeError("tag 'paper_doc_change_member_role' not set")
        return self._value

    def get_paper_doc_change_sharing_policy(self):
        """
        (paper) Changed sharing setting for Paper doc

        Only call this if :meth:`is_paper_doc_change_sharing_policy` is true.

        :rtype: PaperDocChangeSharingPolicyType
        """
        if not self.is_paper_doc_change_sharing_policy():
            raise AttributeError("tag 'paper_doc_change_sharing_policy' not set")
        return self._value

    def get_paper_doc_change_subscription(self):
        """
        (paper) Followed/unfollowed Paper doc

        Only call this if :meth:`is_paper_doc_change_subscription` is true.

        :rtype: PaperDocChangeSubscriptionType
        """
        if not self.is_paper_doc_change_subscription():
            raise AttributeError("tag 'paper_doc_change_subscription' not set")
        return self._value

    def get_paper_doc_deleted(self):
        """
        (paper) Archived Paper doc (deprecated, no longer logged)

        Only call this if :meth:`is_paper_doc_deleted` is true.

        :rtype: PaperDocDeletedType
        """
        if not self.is_paper_doc_deleted():
            raise AttributeError("tag 'paper_doc_deleted' not set")
        return self._value

    def get_paper_doc_delete_comment(self):
        """
        (paper) Deleted Paper doc comment

        Only call this if :meth:`is_paper_doc_delete_comment` is true.

        :rtype: PaperDocDeleteCommentType
        """
        if not self.is_paper_doc_delete_comment():
            raise AttributeError("tag 'paper_doc_delete_comment' not set")
        return self._value

    def get_paper_doc_download(self):
        """
        (paper) Downloaded Paper doc in specific format

        Only call this if :meth:`is_paper_doc_download` is true.

        :rtype: PaperDocDownloadType
        """
        if not self.is_paper_doc_download():
            raise AttributeError("tag 'paper_doc_download' not set")
        return self._value

    def get_paper_doc_edit(self):
        """
        (paper) Edited Paper doc

        Only call this if :meth:`is_paper_doc_edit` is true.

        :rtype: PaperDocEditType
        """
        if not self.is_paper_doc_edit():
            raise AttributeError("tag 'paper_doc_edit' not set")
        return self._value

    def get_paper_doc_edit_comment(self):
        """
        (paper) Edited Paper doc comment

        Only call this if :meth:`is_paper_doc_edit_comment` is true.

        :rtype: PaperDocEditCommentType
        """
        if not self.is_paper_doc_edit_comment():
            raise AttributeError("tag 'paper_doc_edit_comment' not set")
        return self._value

    def get_paper_doc_followed(self):
        """
        (paper) Followed Paper doc (deprecated, replaced by 'Followed/unfollowed
        Paper doc')

        Only call this if :meth:`is_paper_doc_followed` is true.

        :rtype: PaperDocFollowedType
        """
        if not self.is_paper_doc_followed():
            raise AttributeError("tag 'paper_doc_followed' not set")
        return self._value

    def get_paper_doc_mention(self):
        """
        (paper) Mentioned team member in Paper doc

        Only call this if :meth:`is_paper_doc_mention` is true.

        :rtype: PaperDocMentionType
        """
        if not self.is_paper_doc_mention():
            raise AttributeError("tag 'paper_doc_mention' not set")
        return self._value

    def get_paper_doc_ownership_changed(self):
        """
        (paper) Transferred ownership of Paper doc

        Only call this if :meth:`is_paper_doc_ownership_changed` is true.

        :rtype: PaperDocOwnershipChangedType
        """
        if not self.is_paper_doc_ownership_changed():
            raise AttributeError("tag 'paper_doc_ownership_changed' not set")
        return self._value

    def get_paper_doc_request_access(self):
        """
        (paper) Requested access to Paper doc

        Only call this if :meth:`is_paper_doc_request_access` is true.

        :rtype: PaperDocRequestAccessType
        """
        if not self.is_paper_doc_request_access():
            raise AttributeError("tag 'paper_doc_request_access' not set")
        return self._value

    def get_paper_doc_resolve_comment(self):
        """
        (paper) Resolved Paper doc comment

        Only call this if :meth:`is_paper_doc_resolve_comment` is true.

        :rtype: PaperDocResolveCommentType
        """
        if not self.is_paper_doc_resolve_comment():
            raise AttributeError("tag 'paper_doc_resolve_comment' not set")
        return self._value

    def get_paper_doc_revert(self):
        """
        (paper) Restored Paper doc to previous version

        Only call this if :meth:`is_paper_doc_revert` is true.

        :rtype: PaperDocRevertType
        """
        if not self.is_paper_doc_revert():
            raise AttributeError("tag 'paper_doc_revert' not set")
        return self._value

    def get_paper_doc_slack_share(self):
        """
        (paper) Shared Paper doc via Slack

        Only call this if :meth:`is_paper_doc_slack_share` is true.

        :rtype: PaperDocSlackShareType
        """
        if not self.is_paper_doc_slack_share():
            raise AttributeError("tag 'paper_doc_slack_share' not set")
        return self._value

    def get_paper_doc_team_invite(self):
        """
        (paper) Shared Paper doc with team member (deprecated, no longer logged)

        Only call this if :meth:`is_paper_doc_team_invite` is true.

        :rtype: PaperDocTeamInviteType
        """
        if not self.is_paper_doc_team_invite():
            raise AttributeError("tag 'paper_doc_team_invite' not set")
        return self._value

    def get_paper_doc_trashed(self):
        """
        (paper) Deleted Paper doc

        Only call this if :meth:`is_paper_doc_trashed` is true.

        :rtype: PaperDocTrashedType
        """
        if not self.is_paper_doc_trashed():
            raise AttributeError("tag 'paper_doc_trashed' not set")
        return self._value

    def get_paper_doc_unresolve_comment(self):
        """
        (paper) Unresolved Paper doc comment

        Only call this if :meth:`is_paper_doc_unresolve_comment` is true.

        :rtype: PaperDocUnresolveCommentType
        """
        if not self.is_paper_doc_unresolve_comment():
            raise AttributeError("tag 'paper_doc_unresolve_comment' not set")
        return self._value

    def get_paper_doc_untrashed(self):
        """
        (paper) Restored Paper doc

        Only call this if :meth:`is_paper_doc_untrashed` is true.

        :rtype: PaperDocUntrashedType
        """
        if not self.is_paper_doc_untrashed():
            raise AttributeError("tag 'paper_doc_untrashed' not set")
        return self._value

    def get_paper_doc_view(self):
        """
        (paper) Viewed Paper doc

        Only call this if :meth:`is_paper_doc_view` is true.

        :rtype: PaperDocViewType
        """
        if not self.is_paper_doc_view():
            raise AttributeError("tag 'paper_doc_view' not set")
        return self._value

    def get_paper_external_view_allow(self):
        """
        (paper) Changed Paper external sharing setting to anyone (deprecated, no
        longer logged)

        Only call this if :meth:`is_paper_external_view_allow` is true.

        :rtype: PaperExternalViewAllowType
        """
        if not self.is_paper_external_view_allow():
            raise AttributeError("tag 'paper_external_view_allow' not set")
        return self._value

    def get_paper_external_view_default_team(self):
        """
        (paper) Changed Paper external sharing setting to default team
        (deprecated, no longer logged)

        Only call this if :meth:`is_paper_external_view_default_team` is true.

        :rtype: PaperExternalViewDefaultTeamType
        """
        if not self.is_paper_external_view_default_team():
            raise AttributeError("tag 'paper_external_view_default_team' not set")
        return self._value

    def get_paper_external_view_forbid(self):
        """
        (paper) Changed Paper external sharing setting to team-only (deprecated,
        no longer logged)

        Only call this if :meth:`is_paper_external_view_forbid` is true.

        :rtype: PaperExternalViewForbidType
        """
        if not self.is_paper_external_view_forbid():
            raise AttributeError("tag 'paper_external_view_forbid' not set")
        return self._value

    def get_paper_folder_change_subscription(self):
        """
        (paper) Followed/unfollowed Paper folder

        Only call this if :meth:`is_paper_folder_change_subscription` is true.

        :rtype: PaperFolderChangeSubscriptionType
        """
        if not self.is_paper_folder_change_subscription():
            raise AttributeError("tag 'paper_folder_change_subscription' not set")
        return self._value

    def get_paper_folder_deleted(self):
        """
        (paper) Archived Paper folder (deprecated, no longer logged)

        Only call this if :meth:`is_paper_folder_deleted` is true.

        :rtype: PaperFolderDeletedType
        """
        if not self.is_paper_folder_deleted():
            raise AttributeError("tag 'paper_folder_deleted' not set")
        return self._value

    def get_paper_folder_followed(self):
        """
        (paper) Followed Paper folder (deprecated, replaced by
        'Followed/unfollowed Paper folder')

        Only call this if :meth:`is_paper_folder_followed` is true.

        :rtype: PaperFolderFollowedType
        """
        if not self.is_paper_folder_followed():
            raise AttributeError("tag 'paper_folder_followed' not set")
        return self._value

    def get_paper_folder_team_invite(self):
        """
        (paper) Shared Paper folder with member (deprecated, no longer logged)

        Only call this if :meth:`is_paper_folder_team_invite` is true.

        :rtype: PaperFolderTeamInviteType
        """
        if not self.is_paper_folder_team_invite():
            raise AttributeError("tag 'paper_folder_team_invite' not set")
        return self._value

    def get_password_change(self):
        """
        (passwords) Changed password

        Only call this if :meth:`is_password_change` is true.

        :rtype: PasswordChangeType
        """
        if not self.is_password_change():
            raise AttributeError("tag 'password_change' not set")
        return self._value

    def get_password_reset(self):
        """
        (passwords) Reset password

        Only call this if :meth:`is_password_reset` is true.

        :rtype: PasswordResetType
        """
        if not self.is_password_reset():
            raise AttributeError("tag 'password_reset' not set")
        return self._value

    def get_password_reset_all(self):
        """
        (passwords) Reset all team member passwords

        Only call this if :meth:`is_password_reset_all` is true.

        :rtype: PasswordResetAllType
        """
        if not self.is_password_reset_all():
            raise AttributeError("tag 'password_reset_all' not set")
        return self._value

    def get_emm_create_exceptions_report(self):
        """
        (reports) Created EMM-excluded users report

        Only call this if :meth:`is_emm_create_exceptions_report` is true.

        :rtype: EmmCreateExceptionsReportType
        """
        if not self.is_emm_create_exceptions_report():
            raise AttributeError("tag 'emm_create_exceptions_report' not set")
        return self._value

    def get_emm_create_usage_report(self):
        """
        (reports) Created EMM mobile app usage report

        Only call this if :meth:`is_emm_create_usage_report` is true.

        :rtype: EmmCreateUsageReportType
        """
        if not self.is_emm_create_usage_report():
            raise AttributeError("tag 'emm_create_usage_report' not set")
        return self._value

    def get_export_members_report(self):
        """
        (reports) Created member data report

        Only call this if :meth:`is_export_members_report` is true.

        :rtype: ExportMembersReportType
        """
        if not self.is_export_members_report():
            raise AttributeError("tag 'export_members_report' not set")
        return self._value

    def get_paper_admin_export_start(self):
        """
        (reports) Exported all team Paper docs

        Only call this if :meth:`is_paper_admin_export_start` is true.

        :rtype: PaperAdminExportStartType
        """
        if not self.is_paper_admin_export_start():
            raise AttributeError("tag 'paper_admin_export_start' not set")
        return self._value

    def get_smart_sync_create_admin_privilege_report(self):
        """
        (reports) Created Smart Sync non-admin devices report

        Only call this if :meth:`is_smart_sync_create_admin_privilege_report` is true.

        :rtype: SmartSyncCreateAdminPrivilegeReportType
        """
        if not self.is_smart_sync_create_admin_privilege_report():
            raise AttributeError("tag 'smart_sync_create_admin_privilege_report' not set")
        return self._value

    def get_team_activity_create_report(self):
        """
        (reports) Created team activity report

        Only call this if :meth:`is_team_activity_create_report` is true.

        :rtype: TeamActivityCreateReportType
        """
        if not self.is_team_activity_create_report():
            raise AttributeError("tag 'team_activity_create_report' not set")
        return self._value

    def get_collection_share(self):
        """
        (sharing) Shared album

        Only call this if :meth:`is_collection_share` is true.

        :rtype: CollectionShareType
        """
        if not self.is_collection_share():
            raise AttributeError("tag 'collection_share' not set")
        return self._value

    def get_note_acl_invite_only(self):
        """
        (sharing) Changed Paper doc to invite-only (deprecated, no longer
        logged)

        Only call this if :meth:`is_note_acl_invite_only` is true.

        :rtype: NoteAclInviteOnlyType
        """
        if not self.is_note_acl_invite_only():
            raise AttributeError("tag 'note_acl_invite_only' not set")
        return self._value

    def get_note_acl_link(self):
        """
        (sharing) Changed Paper doc to link-accessible (deprecated, no longer
        logged)

        Only call this if :meth:`is_note_acl_link` is true.

        :rtype: NoteAclLinkType
        """
        if not self.is_note_acl_link():
            raise AttributeError("tag 'note_acl_link' not set")
        return self._value

    def get_note_acl_team_link(self):
        """
        (sharing) Changed Paper doc to link-accessible for team (deprecated, no
        longer logged)

        Only call this if :meth:`is_note_acl_team_link` is true.

        :rtype: NoteAclTeamLinkType
        """
        if not self.is_note_acl_team_link():
            raise AttributeError("tag 'note_acl_team_link' not set")
        return self._value

    def get_note_shared(self):
        """
        (sharing) Shared Paper doc (deprecated, no longer logged)

        Only call this if :meth:`is_note_shared` is true.

        :rtype: NoteSharedType
        """
        if not self.is_note_shared():
            raise AttributeError("tag 'note_shared' not set")
        return self._value

    def get_note_share_receive(self):
        """
        (sharing) Shared received Paper doc (deprecated, no longer logged)

        Only call this if :meth:`is_note_share_receive` is true.

        :rtype: NoteShareReceiveType
        """
        if not self.is_note_share_receive():
            raise AttributeError("tag 'note_share_receive' not set")
        return self._value

    def get_open_note_shared(self):
        """
        (sharing) Opened shared Paper doc (deprecated, no longer logged)

        Only call this if :meth:`is_open_note_shared` is true.

        :rtype: OpenNoteSharedType
        """
        if not self.is_open_note_shared():
            raise AttributeError("tag 'open_note_shared' not set")
        return self._value

    def get_sf_add_group(self):
        """
        (sharing) Added team to shared folder (deprecated, no longer logged)

        Only call this if :meth:`is_sf_add_group` is true.

        :rtype: SfAddGroupType
        """
        if not self.is_sf_add_group():
            raise AttributeError("tag 'sf_add_group' not set")
        return self._value

    def get_sf_allow_non_members_to_view_shared_links(self):
        """
        (sharing) Allowed non-collaborators to view links to files in shared
        folder (deprecated, no longer logged)

        Only call this if :meth:`is_sf_allow_non_members_to_view_shared_links` is true.

        :rtype: SfAllowNonMembersToViewSharedLinksType
        """
        if not self.is_sf_allow_non_members_to_view_shared_links():
            raise AttributeError("tag 'sf_allow_non_members_to_view_shared_links' not set")
        return self._value

    def get_sf_external_invite_warn(self):
        """
        (sharing) Set team members to see warning before sharing folders outside
        team (deprecated, no longer logged)

        Only call this if :meth:`is_sf_external_invite_warn` is true.

        :rtype: SfExternalInviteWarnType
        """
        if not self.is_sf_external_invite_warn():
            raise AttributeError("tag 'sf_external_invite_warn' not set")
        return self._value

    def get_sf_fb_invite(self):
        """
        (sharing) Invited Facebook users to shared folder (deprecated, no longer
        logged)

        Only call this if :meth:`is_sf_fb_invite` is true.

        :rtype: SfFbInviteType
        """
        if not self.is_sf_fb_invite():
            raise AttributeError("tag 'sf_fb_invite' not set")
        return self._value

    def get_sf_fb_invite_change_role(self):
        """
        (sharing) Changed Facebook user's role in shared folder (deprecated, no
        longer logged)

        Only call this if :meth:`is_sf_fb_invite_change_role` is true.

        :rtype: SfFbInviteChangeRoleType
        """
        if not self.is_sf_fb_invite_change_role():
            raise AttributeError("tag 'sf_fb_invite_change_role' not set")
        return self._value

    def get_sf_fb_uninvite(self):
        """
        (sharing) Uninvited Facebook user from shared folder (deprecated, no
        longer logged)

        Only call this if :meth:`is_sf_fb_uninvite` is true.

        :rtype: SfFbUninviteType
        """
        if not self.is_sf_fb_uninvite():
            raise AttributeError("tag 'sf_fb_uninvite' not set")
        return self._value

    def get_sf_invite_group(self):
        """
        (sharing) Invited group to shared folder (deprecated, no longer logged)

        Only call this if :meth:`is_sf_invite_group` is true.

        :rtype: SfInviteGroupType
        """
        if not self.is_sf_invite_group():
            raise AttributeError("tag 'sf_invite_group' not set")
        return self._value

    def get_sf_team_grant_access(self):
        """
        (sharing) Granted access to shared folder (deprecated, no longer logged)

        Only call this if :meth:`is_sf_team_grant_access` is true.

        :rtype: SfTeamGrantAccessType
        """
        if not self.is_sf_team_grant_access():
            raise AttributeError("tag 'sf_team_grant_access' not set")
        return self._value

    def get_sf_team_invite(self):
        """
        (sharing) Invited team members to shared folder (deprecated, replaced by
        'Invited user to Dropbox and added them to shared file/folder')

        Only call this if :meth:`is_sf_team_invite` is true.

        :rtype: SfTeamInviteType
        """
        if not self.is_sf_team_invite():
            raise AttributeError("tag 'sf_team_invite' not set")
        return self._value

    def get_sf_team_invite_change_role(self):
        """
        (sharing) Changed team member's role in shared folder (deprecated, no
        longer logged)

        Only call this if :meth:`is_sf_team_invite_change_role` is true.

        :rtype: SfTeamInviteChangeRoleType
        """
        if not self.is_sf_team_invite_change_role():
            raise AttributeError("tag 'sf_team_invite_change_role' not set")
        return self._value

    def get_sf_team_join(self):
        """
        (sharing) Joined team member's shared folder (deprecated, no longer
        logged)

        Only call this if :meth:`is_sf_team_join` is true.

        :rtype: SfTeamJoinType
        """
        if not self.is_sf_team_join():
            raise AttributeError("tag 'sf_team_join' not set")
        return self._value

    def get_sf_team_join_from_oob_link(self):
        """
        (sharing) Joined team member's shared folder from link (deprecated, no
        longer logged)

        Only call this if :meth:`is_sf_team_join_from_oob_link` is true.

        :rtype: SfTeamJoinFromOobLinkType
        """
        if not self.is_sf_team_join_from_oob_link():
            raise AttributeError("tag 'sf_team_join_from_oob_link' not set")
        return self._value

    def get_sf_team_uninvite(self):
        """
        (sharing) Unshared folder with team member (deprecated, replaced by
        'Removed invitee from shared file/folder before invite was accepted')

        Only call this if :meth:`is_sf_team_uninvite` is true.

        :rtype: SfTeamUninviteType
        """
        if not self.is_sf_team_uninvite():
            raise AttributeError("tag 'sf_team_uninvite' not set")
        return self._value

    def get_shared_content_add_invitees(self):
        """
        (sharing) Invited user to Dropbox and added them to shared file/folder

        Only call this if :meth:`is_shared_content_add_invitees` is true.

        :rtype: SharedContentAddInviteesType
        """
        if not self.is_shared_content_add_invitees():
            raise AttributeError("tag 'shared_content_add_invitees' not set")
        return self._value

    def get_shared_content_add_link_expiry(self):
        """
        (sharing) Added expiration date to link for shared file/folder

        Only call this if :meth:`is_shared_content_add_link_expiry` is true.

        :rtype: SharedContentAddLinkExpiryType
        """
        if not self.is_shared_content_add_link_expiry():
            raise AttributeError("tag 'shared_content_add_link_expiry' not set")
        return self._value

    def get_shared_content_add_link_password(self):
        """
        (sharing) Added password to link for shared file/folder

        Only call this if :meth:`is_shared_content_add_link_password` is true.

        :rtype: SharedContentAddLinkPasswordType
        """
        if not self.is_shared_content_add_link_password():
            raise AttributeError("tag 'shared_content_add_link_password' not set")
        return self._value

    def get_shared_content_add_member(self):
        """
        (sharing) Added users and/or groups to shared file/folder

        Only call this if :meth:`is_shared_content_add_member` is true.

        :rtype: SharedContentAddMemberType
        """
        if not self.is_shared_content_add_member():
            raise AttributeError("tag 'shared_content_add_member' not set")
        return self._value

    def get_shared_content_change_downloads_policy(self):
        """
        (sharing) Changed whether members can download shared file/folder

        Only call this if :meth:`is_shared_content_change_downloads_policy` is true.

        :rtype: SharedContentChangeDownloadsPolicyType
        """
        if not self.is_shared_content_change_downloads_policy():
            raise AttributeError("tag 'shared_content_change_downloads_policy' not set")
        return self._value

    def get_shared_content_change_invitee_role(self):
        """
        (sharing) Changed access type of invitee to shared file/folder before
        invite was accepted

        Only call this if :meth:`is_shared_content_change_invitee_role` is true.

        :rtype: SharedContentChangeInviteeRoleType
        """
        if not self.is_shared_content_change_invitee_role():
            raise AttributeError("tag 'shared_content_change_invitee_role' not set")
        return self._value

    def get_shared_content_change_link_audience(self):
        """
        (sharing) Changed link audience of shared file/folder

        Only call this if :meth:`is_shared_content_change_link_audience` is true.

        :rtype: SharedContentChangeLinkAudienceType
        """
        if not self.is_shared_content_change_link_audience():
            raise AttributeError("tag 'shared_content_change_link_audience' not set")
        return self._value

    def get_shared_content_change_link_expiry(self):
        """
        (sharing) Changed link expiration of shared file/folder

        Only call this if :meth:`is_shared_content_change_link_expiry` is true.

        :rtype: SharedContentChangeLinkExpiryType
        """
        if not self.is_shared_content_change_link_expiry():
            raise AttributeError("tag 'shared_content_change_link_expiry' not set")
        return self._value

    def get_shared_content_change_link_password(self):
        """
        (sharing) Changed link password of shared file/folder

        Only call this if :meth:`is_shared_content_change_link_password` is true.

        :rtype: SharedContentChangeLinkPasswordType
        """
        if not self.is_shared_content_change_link_password():
            raise AttributeError("tag 'shared_content_change_link_password' not set")
        return self._value

    def get_shared_content_change_member_role(self):
        """
        (sharing) Changed access type of shared file/folder member

        Only call this if :meth:`is_shared_content_change_member_role` is true.

        :rtype: SharedContentChangeMemberRoleType
        """
        if not self.is_shared_content_change_member_role():
            raise AttributeError("tag 'shared_content_change_member_role' not set")
        return self._value

    def get_shared_content_change_viewer_info_policy(self):
        """
        (sharing) Changed whether members can see who viewed shared file/folder

        Only call this if :meth:`is_shared_content_change_viewer_info_policy` is true.

        :rtype: SharedContentChangeViewerInfoPolicyType
        """
        if not self.is_shared_content_change_viewer_info_policy():
            raise AttributeError("tag 'shared_content_change_viewer_info_policy' not set")
        return self._value

    def get_shared_content_claim_invitation(self):
        """
        (sharing) Acquired membership of shared file/folder by accepting invite

        Only call this if :meth:`is_shared_content_claim_invitation` is true.

        :rtype: SharedContentClaimInvitationType
        """
        if not self.is_shared_content_claim_invitation():
            raise AttributeError("tag 'shared_content_claim_invitation' not set")
        return self._value

    def get_shared_content_copy(self):
        """
        (sharing) Copied shared file/folder to own Dropbox

        Only call this if :meth:`is_shared_content_copy` is true.

        :rtype: SharedContentCopyType
        """
        if not self.is_shared_content_copy():
            raise AttributeError("tag 'shared_content_copy' not set")
        return self._value

    def get_shared_content_download(self):
        """
        (sharing) Downloaded shared file/folder

        Only call this if :meth:`is_shared_content_download` is true.

        :rtype: SharedContentDownloadType
        """
        if not self.is_shared_content_download():
            raise AttributeError("tag 'shared_content_download' not set")
        return self._value

    def get_shared_content_relinquish_membership(self):
        """
        (sharing) Left shared file/folder

        Only call this if :meth:`is_shared_content_relinquish_membership` is true.

        :rtype: SharedContentRelinquishMembershipType
        """
        if not self.is_shared_content_relinquish_membership():
            raise AttributeError("tag 'shared_content_relinquish_membership' not set")
        return self._value

    def get_shared_content_remove_invitees(self):
        """
        (sharing) Removed invitee from shared file/folder before invite was
        accepted

        Only call this if :meth:`is_shared_content_remove_invitees` is true.

        :rtype: SharedContentRemoveInviteesType
        """
        if not self.is_shared_content_remove_invitees():
            raise AttributeError("tag 'shared_content_remove_invitees' not set")
        return self._value

    def get_shared_content_remove_link_expiry(self):
        """
        (sharing) Removed link expiration date of shared file/folder

        Only call this if :meth:`is_shared_content_remove_link_expiry` is true.

        :rtype: SharedContentRemoveLinkExpiryType
        """
        if not self.is_shared_content_remove_link_expiry():
            raise AttributeError("tag 'shared_content_remove_link_expiry' not set")
        return self._value

    def get_shared_content_remove_link_password(self):
        """
        (sharing) Removed link password of shared file/folder

        Only call this if :meth:`is_shared_content_remove_link_password` is true.

        :rtype: SharedContentRemoveLinkPasswordType
        """
        if not self.is_shared_content_remove_link_password():
            raise AttributeError("tag 'shared_content_remove_link_password' not set")
        return self._value

    def get_shared_content_remove_member(self):
        """
        (sharing) Removed user/group from shared file/folder

        Only call this if :meth:`is_shared_content_remove_member` is true.

        :rtype: SharedContentRemoveMemberType
        """
        if not self.is_shared_content_remove_member():
            raise AttributeError("tag 'shared_content_remove_member' not set")
        return self._value

    def get_shared_content_request_access(self):
        """
        (sharing) Requested access to shared file/folder

        Only call this if :meth:`is_shared_content_request_access` is true.

        :rtype: SharedContentRequestAccessType
        """
        if not self.is_shared_content_request_access():
            raise AttributeError("tag 'shared_content_request_access' not set")
        return self._value

    def get_shared_content_unshare(self):
        """
        (sharing) Unshared file/folder by clearing membership and turning off
        link

        Only call this if :meth:`is_shared_content_unshare` is true.

        :rtype: SharedContentUnshareType
        """
        if not self.is_shared_content_unshare():
            raise AttributeError("tag 'shared_content_unshare' not set")
        return self._value

    def get_shared_content_view(self):
        """
        (sharing) Previewed shared file/folder

        Only call this if :meth:`is_shared_content_view` is true.

        :rtype: SharedContentViewType
        """
        if not self.is_shared_content_view():
            raise AttributeError("tag 'shared_content_view' not set")
        return self._value

    def get_shared_folder_change_link_policy(self):
        """
        (sharing) Changed who can access shared folder via link

        Only call this if :meth:`is_shared_folder_change_link_policy` is true.

        :rtype: SharedFolderChangeLinkPolicyType
        """
        if not self.is_shared_folder_change_link_policy():
            raise AttributeError("tag 'shared_folder_change_link_policy' not set")
        return self._value

    def get_shared_folder_change_members_inheritance_policy(self):
        """
        (sharing) Changed whether shared folder inherits members from parent
        folder

        Only call this if :meth:`is_shared_folder_change_members_inheritance_policy` is true.

        :rtype: SharedFolderChangeMembersInheritancePolicyType
        """
        if not self.is_shared_folder_change_members_inheritance_policy():
            raise AttributeError("tag 'shared_folder_change_members_inheritance_policy' not set")
        return self._value

    def get_shared_folder_change_members_management_policy(self):
        """
        (sharing) Changed who can add/remove members of shared folder

        Only call this if :meth:`is_shared_folder_change_members_management_policy` is true.

        :rtype: SharedFolderChangeMembersManagementPolicyType
        """
        if not self.is_shared_folder_change_members_management_policy():
            raise AttributeError("tag 'shared_folder_change_members_management_policy' not set")
        return self._value

    def get_shared_folder_change_members_policy(self):
        """
        (sharing) Changed who can become member of shared folder

        Only call this if :meth:`is_shared_folder_change_members_policy` is true.

        :rtype: SharedFolderChangeMembersPolicyType
        """
        if not self.is_shared_folder_change_members_policy():
            raise AttributeError("tag 'shared_folder_change_members_policy' not set")
        return self._value

    def get_shared_folder_create(self):
        """
        (sharing) Created shared folder

        Only call this if :meth:`is_shared_folder_create` is true.

        :rtype: SharedFolderCreateType
        """
        if not self.is_shared_folder_create():
            raise AttributeError("tag 'shared_folder_create' not set")
        return self._value

    def get_shared_folder_decline_invitation(self):
        """
        (sharing) Declined team member's invite to shared folder

        Only call this if :meth:`is_shared_folder_decline_invitation` is true.

        :rtype: SharedFolderDeclineInvitationType
        """
        if not self.is_shared_folder_decline_invitation():
            raise AttributeError("tag 'shared_folder_decline_invitation' not set")
        return self._value

    def get_shared_folder_mount(self):
        """
        (sharing) Added shared folder to own Dropbox

        Only call this if :meth:`is_shared_folder_mount` is true.

        :rtype: SharedFolderMountType
        """
        if not self.is_shared_folder_mount():
            raise AttributeError("tag 'shared_folder_mount' not set")
        return self._value

    def get_shared_folder_nest(self):
        """
        (sharing) Changed parent of shared folder

        Only call this if :meth:`is_shared_folder_nest` is true.

        :rtype: SharedFolderNestType
        """
        if not self.is_shared_folder_nest():
            raise AttributeError("tag 'shared_folder_nest' not set")
        return self._value

    def get_shared_folder_transfer_ownership(self):
        """
        (sharing) Transferred ownership of shared folder to another member

        Only call this if :meth:`is_shared_folder_transfer_ownership` is true.

        :rtype: SharedFolderTransferOwnershipType
        """
        if not self.is_shared_folder_transfer_ownership():
            raise AttributeError("tag 'shared_folder_transfer_ownership' not set")
        return self._value

    def get_shared_folder_unmount(self):
        """
        (sharing) Deleted shared folder from Dropbox

        Only call this if :meth:`is_shared_folder_unmount` is true.

        :rtype: SharedFolderUnmountType
        """
        if not self.is_shared_folder_unmount():
            raise AttributeError("tag 'shared_folder_unmount' not set")
        return self._value

    def get_shared_link_add_expiry(self):
        """
        (sharing) Added shared link expiration date

        Only call this if :meth:`is_shared_link_add_expiry` is true.

        :rtype: SharedLinkAddExpiryType
        """
        if not self.is_shared_link_add_expiry():
            raise AttributeError("tag 'shared_link_add_expiry' not set")
        return self._value

    def get_shared_link_change_expiry(self):
        """
        (sharing) Changed shared link expiration date

        Only call this if :meth:`is_shared_link_change_expiry` is true.

        :rtype: SharedLinkChangeExpiryType
        """
        if not self.is_shared_link_change_expiry():
            raise AttributeError("tag 'shared_link_change_expiry' not set")
        return self._value

    def get_shared_link_change_visibility(self):
        """
        (sharing) Changed visibility of shared link

        Only call this if :meth:`is_shared_link_change_visibility` is true.

        :rtype: SharedLinkChangeVisibilityType
        """
        if not self.is_shared_link_change_visibility():
            raise AttributeError("tag 'shared_link_change_visibility' not set")
        return self._value

    def get_shared_link_copy(self):
        """
        (sharing) Added file/folder to Dropbox from shared link

        Only call this if :meth:`is_shared_link_copy` is true.

        :rtype: SharedLinkCopyType
        """
        if not self.is_shared_link_copy():
            raise AttributeError("tag 'shared_link_copy' not set")
        return self._value

    def get_shared_link_create(self):
        """
        (sharing) Created shared link

        Only call this if :meth:`is_shared_link_create` is true.

        :rtype: SharedLinkCreateType
        """
        if not self.is_shared_link_create():
            raise AttributeError("tag 'shared_link_create' not set")
        return self._value

    def get_shared_link_disable(self):
        """
        (sharing) Removed shared link

        Only call this if :meth:`is_shared_link_disable` is true.

        :rtype: SharedLinkDisableType
        """
        if not self.is_shared_link_disable():
            raise AttributeError("tag 'shared_link_disable' not set")
        return self._value

    def get_shared_link_download(self):
        """
        (sharing) Downloaded file/folder from shared link

        Only call this if :meth:`is_shared_link_download` is true.

        :rtype: SharedLinkDownloadType
        """
        if not self.is_shared_link_download():
            raise AttributeError("tag 'shared_link_download' not set")
        return self._value

    def get_shared_link_remove_expiry(self):
        """
        (sharing) Removed shared link expiration date

        Only call this if :meth:`is_shared_link_remove_expiry` is true.

        :rtype: SharedLinkRemoveExpiryType
        """
        if not self.is_shared_link_remove_expiry():
            raise AttributeError("tag 'shared_link_remove_expiry' not set")
        return self._value

    def get_shared_link_share(self):
        """
        (sharing) Added members as audience of shared link

        Only call this if :meth:`is_shared_link_share` is true.

        :rtype: SharedLinkShareType
        """
        if not self.is_shared_link_share():
            raise AttributeError("tag 'shared_link_share' not set")
        return self._value

    def get_shared_link_view(self):
        """
        (sharing) Opened shared link

        Only call this if :meth:`is_shared_link_view` is true.

        :rtype: SharedLinkViewType
        """
        if not self.is_shared_link_view():
            raise AttributeError("tag 'shared_link_view' not set")
        return self._value

    def get_shared_note_opened(self):
        """
        (sharing) Opened shared Paper doc (deprecated, no longer logged)

        Only call this if :meth:`is_shared_note_opened` is true.

        :rtype: SharedNoteOpenedType
        """
        if not self.is_shared_note_opened():
            raise AttributeError("tag 'shared_note_opened' not set")
        return self._value

    def get_shmodel_group_share(self):
        """
        (sharing) Shared link with group (deprecated, no longer logged)

        Only call this if :meth:`is_shmodel_group_share` is true.

        :rtype: ShmodelGroupShareType
        """
        if not self.is_shmodel_group_share():
            raise AttributeError("tag 'shmodel_group_share' not set")
        return self._value

    def get_showcase_access_granted(self):
        """
        (showcase) Granted access to showcase

        Only call this if :meth:`is_showcase_access_granted` is true.

        :rtype: ShowcaseAccessGrantedType
        """
        if not self.is_showcase_access_granted():
            raise AttributeError("tag 'showcase_access_granted' not set")
        return self._value

    def get_showcase_add_member(self):
        """
        (showcase) Added member to showcase

        Only call this if :meth:`is_showcase_add_member` is true.

        :rtype: ShowcaseAddMemberType
        """
        if not self.is_showcase_add_member():
            raise AttributeError("tag 'showcase_add_member' not set")
        return self._value

    def get_showcase_archived(self):
        """
        (showcase) Archived showcase

        Only call this if :meth:`is_showcase_archived` is true.

        :rtype: ShowcaseArchivedType
        """
        if not self.is_showcase_archived():
            raise AttributeError("tag 'showcase_archived' not set")
        return self._value

    def get_showcase_created(self):
        """
        (showcase) Created showcase

        Only call this if :meth:`is_showcase_created` is true.

        :rtype: ShowcaseCreatedType
        """
        if not self.is_showcase_created():
            raise AttributeError("tag 'showcase_created' not set")
        return self._value

    def get_showcase_delete_comment(self):
        """
        (showcase) Deleted showcase comment

        Only call this if :meth:`is_showcase_delete_comment` is true.

        :rtype: ShowcaseDeleteCommentType
        """
        if not self.is_showcase_delete_comment():
            raise AttributeError("tag 'showcase_delete_comment' not set")
        return self._value

    def get_showcase_edited(self):
        """
        (showcase) Edited showcase

        Only call this if :meth:`is_showcase_edited` is true.

        :rtype: ShowcaseEditedType
        """
        if not self.is_showcase_edited():
            raise AttributeError("tag 'showcase_edited' not set")
        return self._value

    def get_showcase_edit_comment(self):
        """
        (showcase) Edited showcase comment

        Only call this if :meth:`is_showcase_edit_comment` is true.

        :rtype: ShowcaseEditCommentType
        """
        if not self.is_showcase_edit_comment():
            raise AttributeError("tag 'showcase_edit_comment' not set")
        return self._value

    def get_showcase_file_added(self):
        """
        (showcase) Added file to showcase

        Only call this if :meth:`is_showcase_file_added` is true.

        :rtype: ShowcaseFileAddedType
        """
        if not self.is_showcase_file_added():
            raise AttributeError("tag 'showcase_file_added' not set")
        return self._value

    def get_showcase_file_download(self):
        """
        (showcase) Downloaded file from showcase

        Only call this if :meth:`is_showcase_file_download` is true.

        :rtype: ShowcaseFileDownloadType
        """
        if not self.is_showcase_file_download():
            raise AttributeError("tag 'showcase_file_download' not set")
        return self._value

    def get_showcase_file_removed(self):
        """
        (showcase) Removed file from showcase

        Only call this if :meth:`is_showcase_file_removed` is true.

        :rtype: ShowcaseFileRemovedType
        """
        if not self.is_showcase_file_removed():
            raise AttributeError("tag 'showcase_file_removed' not set")
        return self._value

    def get_showcase_file_view(self):
        """
        (showcase) Viewed file in showcase

        Only call this if :meth:`is_showcase_file_view` is true.

        :rtype: ShowcaseFileViewType
        """
        if not self.is_showcase_file_view():
            raise AttributeError("tag 'showcase_file_view' not set")
        return self._value

    def get_showcase_permanently_deleted(self):
        """
        (showcase) Permanently deleted showcase

        Only call this if :meth:`is_showcase_permanently_deleted` is true.

        :rtype: ShowcasePermanentlyDeletedType
        """
        if not self.is_showcase_permanently_deleted():
            raise AttributeError("tag 'showcase_permanently_deleted' not set")
        return self._value

    def get_showcase_post_comment(self):
        """
        (showcase) Added showcase comment

        Only call this if :meth:`is_showcase_post_comment` is true.

        :rtype: ShowcasePostCommentType
        """
        if not self.is_showcase_post_comment():
            raise AttributeError("tag 'showcase_post_comment' not set")
        return self._value

    def get_showcase_remove_member(self):
        """
        (showcase) Removed member from showcase

        Only call this if :meth:`is_showcase_remove_member` is true.

        :rtype: ShowcaseRemoveMemberType
        """
        if not self.is_showcase_remove_member():
            raise AttributeError("tag 'showcase_remove_member' not set")
        return self._value

    def get_showcase_renamed(self):
        """
        (showcase) Renamed showcase

        Only call this if :meth:`is_showcase_renamed` is true.

        :rtype: ShowcaseRenamedType
        """
        if not self.is_showcase_renamed():
            raise AttributeError("tag 'showcase_renamed' not set")
        return self._value

    def get_showcase_request_access(self):
        """
        (showcase) Requested access to showcase

        Only call this if :meth:`is_showcase_request_access` is true.

        :rtype: ShowcaseRequestAccessType
        """
        if not self.is_showcase_request_access():
            raise AttributeError("tag 'showcase_request_access' not set")
        return self._value

    def get_showcase_resolve_comment(self):
        """
        (showcase) Resolved showcase comment

        Only call this if :meth:`is_showcase_resolve_comment` is true.

        :rtype: ShowcaseResolveCommentType
        """
        if not self.is_showcase_resolve_comment():
            raise AttributeError("tag 'showcase_resolve_comment' not set")
        return self._value

    def get_showcase_restored(self):
        """
        (showcase) Unarchived showcase

        Only call this if :meth:`is_showcase_restored` is true.

        :rtype: ShowcaseRestoredType
        """
        if not self.is_showcase_restored():
            raise AttributeError("tag 'showcase_restored' not set")
        return self._value

    def get_showcase_trashed(self):
        """
        (showcase) Deleted showcase

        Only call this if :meth:`is_showcase_trashed` is true.

        :rtype: ShowcaseTrashedType
        """
        if not self.is_showcase_trashed():
            raise AttributeError("tag 'showcase_trashed' not set")
        return self._value

    def get_showcase_trashed_deprecated(self):
        """
        (showcase) Deleted showcase (old version) (deprecated, replaced by
        'Deleted showcase')

        Only call this if :meth:`is_showcase_trashed_deprecated` is true.

        :rtype: ShowcaseTrashedDeprecatedType
        """
        if not self.is_showcase_trashed_deprecated():
            raise AttributeError("tag 'showcase_trashed_deprecated' not set")
        return self._value

    def get_showcase_unresolve_comment(self):
        """
        (showcase) Unresolved showcase comment

        Only call this if :meth:`is_showcase_unresolve_comment` is true.

        :rtype: ShowcaseUnresolveCommentType
        """
        if not self.is_showcase_unresolve_comment():
            raise AttributeError("tag 'showcase_unresolve_comment' not set")
        return self._value

    def get_showcase_untrashed(self):
        """
        (showcase) Restored showcase

        Only call this if :meth:`is_showcase_untrashed` is true.

        :rtype: ShowcaseUntrashedType
        """
        if not self.is_showcase_untrashed():
            raise AttributeError("tag 'showcase_untrashed' not set")
        return self._value

    def get_showcase_untrashed_deprecated(self):
        """
        (showcase) Restored showcase (old version) (deprecated, replaced by
        'Restored showcase')

        Only call this if :meth:`is_showcase_untrashed_deprecated` is true.

        :rtype: ShowcaseUntrashedDeprecatedType
        """
        if not self.is_showcase_untrashed_deprecated():
            raise AttributeError("tag 'showcase_untrashed_deprecated' not set")
        return self._value

    def get_showcase_view(self):
        """
        (showcase) Viewed showcase

        Only call this if :meth:`is_showcase_view` is true.

        :rtype: ShowcaseViewType
        """
        if not self.is_showcase_view():
            raise AttributeError("tag 'showcase_view' not set")
        return self._value

    def get_sso_add_cert(self):
        """
        (sso) Added X.509 certificate for SSO

        Only call this if :meth:`is_sso_add_cert` is true.

        :rtype: SsoAddCertType
        """
        if not self.is_sso_add_cert():
            raise AttributeError("tag 'sso_add_cert' not set")
        return self._value

    def get_sso_add_login_url(self):
        """
        (sso) Added sign-in URL for SSO

        Only call this if :meth:`is_sso_add_login_url` is true.

        :rtype: SsoAddLoginUrlType
        """
        if not self.is_sso_add_login_url():
            raise AttributeError("tag 'sso_add_login_url' not set")
        return self._value

    def get_sso_add_logout_url(self):
        """
        (sso) Added sign-out URL for SSO

        Only call this if :meth:`is_sso_add_logout_url` is true.

        :rtype: SsoAddLogoutUrlType
        """
        if not self.is_sso_add_logout_url():
            raise AttributeError("tag 'sso_add_logout_url' not set")
        return self._value

    def get_sso_change_cert(self):
        """
        (sso) Changed X.509 certificate for SSO

        Only call this if :meth:`is_sso_change_cert` is true.

        :rtype: SsoChangeCertType
        """
        if not self.is_sso_change_cert():
            raise AttributeError("tag 'sso_change_cert' not set")
        return self._value

    def get_sso_change_login_url(self):
        """
        (sso) Changed sign-in URL for SSO

        Only call this if :meth:`is_sso_change_login_url` is true.

        :rtype: SsoChangeLoginUrlType
        """
        if not self.is_sso_change_login_url():
            raise AttributeError("tag 'sso_change_login_url' not set")
        return self._value

    def get_sso_change_logout_url(self):
        """
        (sso) Changed sign-out URL for SSO

        Only call this if :meth:`is_sso_change_logout_url` is true.

        :rtype: SsoChangeLogoutUrlType
        """
        if not self.is_sso_change_logout_url():
            raise AttributeError("tag 'sso_change_logout_url' not set")
        return self._value

    def get_sso_change_saml_identity_mode(self):
        """
        (sso) Changed SAML identity mode for SSO

        Only call this if :meth:`is_sso_change_saml_identity_mode` is true.

        :rtype: SsoChangeSamlIdentityModeType
        """
        if not self.is_sso_change_saml_identity_mode():
            raise AttributeError("tag 'sso_change_saml_identity_mode' not set")
        return self._value

    def get_sso_remove_cert(self):
        """
        (sso) Removed X.509 certificate for SSO

        Only call this if :meth:`is_sso_remove_cert` is true.

        :rtype: SsoRemoveCertType
        """
        if not self.is_sso_remove_cert():
            raise AttributeError("tag 'sso_remove_cert' not set")
        return self._value

    def get_sso_remove_login_url(self):
        """
        (sso) Removed sign-in URL for SSO

        Only call this if :meth:`is_sso_remove_login_url` is true.

        :rtype: SsoRemoveLoginUrlType
        """
        if not self.is_sso_remove_login_url():
            raise AttributeError("tag 'sso_remove_login_url' not set")
        return self._value

    def get_sso_remove_logout_url(self):
        """
        (sso) Removed sign-out URL for SSO

        Only call this if :meth:`is_sso_remove_logout_url` is true.

        :rtype: SsoRemoveLogoutUrlType
        """
        if not self.is_sso_remove_logout_url():
            raise AttributeError("tag 'sso_remove_logout_url' not set")
        return self._value

    def get_team_folder_change_status(self):
        """
        (team_folders) Changed archival status of team folder

        Only call this if :meth:`is_team_folder_change_status` is true.

        :rtype: TeamFolderChangeStatusType
        """
        if not self.is_team_folder_change_status():
            raise AttributeError("tag 'team_folder_change_status' not set")
        return self._value

    def get_team_folder_create(self):
        """
        (team_folders) Created team folder in active status

        Only call this if :meth:`is_team_folder_create` is true.

        :rtype: TeamFolderCreateType
        """
        if not self.is_team_folder_create():
            raise AttributeError("tag 'team_folder_create' not set")
        return self._value

    def get_team_folder_downgrade(self):
        """
        (team_folders) Downgraded team folder to regular shared folder

        Only call this if :meth:`is_team_folder_downgrade` is true.

        :rtype: TeamFolderDowngradeType
        """
        if not self.is_team_folder_downgrade():
            raise AttributeError("tag 'team_folder_downgrade' not set")
        return self._value

    def get_team_folder_permanently_delete(self):
        """
        (team_folders) Permanently deleted archived team folder

        Only call this if :meth:`is_team_folder_permanently_delete` is true.

        :rtype: TeamFolderPermanentlyDeleteType
        """
        if not self.is_team_folder_permanently_delete():
            raise AttributeError("tag 'team_folder_permanently_delete' not set")
        return self._value

    def get_team_folder_rename(self):
        """
        (team_folders) Renamed active/archived team folder

        Only call this if :meth:`is_team_folder_rename` is true.

        :rtype: TeamFolderRenameType
        """
        if not self.is_team_folder_rename():
            raise AttributeError("tag 'team_folder_rename' not set")
        return self._value

    def get_team_selective_sync_settings_changed(self):
        """
        (team_folders) Changed sync default

        Only call this if :meth:`is_team_selective_sync_settings_changed` is true.

        :rtype: TeamSelectiveSyncSettingsChangedType
        """
        if not self.is_team_selective_sync_settings_changed():
            raise AttributeError("tag 'team_selective_sync_settings_changed' not set")
        return self._value

    def get_account_capture_change_policy(self):
        """
        (team_policies) Changed account capture setting on team domain

        Only call this if :meth:`is_account_capture_change_policy` is true.

        :rtype: AccountCaptureChangePolicyType
        """
        if not self.is_account_capture_change_policy():
            raise AttributeError("tag 'account_capture_change_policy' not set")
        return self._value

    def get_allow_download_disabled(self):
        """
        (team_policies) Disabled downloads (deprecated, no longer logged)

        Only call this if :meth:`is_allow_download_disabled` is true.

        :rtype: AllowDownloadDisabledType
        """
        if not self.is_allow_download_disabled():
            raise AttributeError("tag 'allow_download_disabled' not set")
        return self._value

    def get_allow_download_enabled(self):
        """
        (team_policies) Enabled downloads (deprecated, no longer logged)

        Only call this if :meth:`is_allow_download_enabled` is true.

        :rtype: AllowDownloadEnabledType
        """
        if not self.is_allow_download_enabled():
            raise AttributeError("tag 'allow_download_enabled' not set")
        return self._value

    def get_data_placement_restriction_change_policy(self):
        """
        (team_policies) Set restrictions on data center locations where team
        data resides

        Only call this if :meth:`is_data_placement_restriction_change_policy` is true.

        :rtype: DataPlacementRestrictionChangePolicyType
        """
        if not self.is_data_placement_restriction_change_policy():
            raise AttributeError("tag 'data_placement_restriction_change_policy' not set")
        return self._value

    def get_data_placement_restriction_satisfy_policy(self):
        """
        (team_policies) Completed restrictions on data center locations where
        team data resides

        Only call this if :meth:`is_data_placement_restriction_satisfy_policy` is true.

        :rtype: DataPlacementRestrictionSatisfyPolicyType
        """
        if not self.is_data_placement_restriction_satisfy_policy():
            raise AttributeError("tag 'data_placement_restriction_satisfy_policy' not set")
        return self._value

    def get_device_approvals_change_desktop_policy(self):
        """
        (team_policies) Set/removed limit on number of computers member can link
        to team Dropbox account

        Only call this if :meth:`is_device_approvals_change_desktop_policy` is true.

        :rtype: DeviceApprovalsChangeDesktopPolicyType
        """
        if not self.is_device_approvals_change_desktop_policy():
            raise AttributeError("tag 'device_approvals_change_desktop_policy' not set")
        return self._value

    def get_device_approvals_change_mobile_policy(self):
        """
        (team_policies) Set/removed limit on number of mobile devices member can
        link to team Dropbox account

        Only call this if :meth:`is_device_approvals_change_mobile_policy` is true.

        :rtype: DeviceApprovalsChangeMobilePolicyType
        """
        if not self.is_device_approvals_change_mobile_policy():
            raise AttributeError("tag 'device_approvals_change_mobile_policy' not set")
        return self._value

    def get_device_approvals_change_overage_action(self):
        """
        (team_policies) Changed device approvals setting when member is over
        limit

        Only call this if :meth:`is_device_approvals_change_overage_action` is true.

        :rtype: DeviceApprovalsChangeOverageActionType
        """
        if not self.is_device_approvals_change_overage_action():
            raise AttributeError("tag 'device_approvals_change_overage_action' not set")
        return self._value

    def get_device_approvals_change_unlink_action(self):
        """
        (team_policies) Changed device approvals setting when member unlinks
        approved device

        Only call this if :meth:`is_device_approvals_change_unlink_action` is true.

        :rtype: DeviceApprovalsChangeUnlinkActionType
        """
        if not self.is_device_approvals_change_unlink_action():
            raise AttributeError("tag 'device_approvals_change_unlink_action' not set")
        return self._value

    def get_directory_restrictions_add_members(self):
        """
        (team_policies) Added members to directory restrictions list

        Only call this if :meth:`is_directory_restrictions_add_members` is true.

        :rtype: DirectoryRestrictionsAddMembersType
        """
        if not self.is_directory_restrictions_add_members():
            raise AttributeError("tag 'directory_restrictions_add_members' not set")
        return self._value

    def get_directory_restrictions_remove_members(self):
        """
        (team_policies) Removed members from directory restrictions list

        Only call this if :meth:`is_directory_restrictions_remove_members` is true.

        :rtype: DirectoryRestrictionsRemoveMembersType
        """
        if not self.is_directory_restrictions_remove_members():
            raise AttributeError("tag 'directory_restrictions_remove_members' not set")
        return self._value

    def get_emm_add_exception(self):
        """
        (team_policies) Added members to EMM exception list

        Only call this if :meth:`is_emm_add_exception` is true.

        :rtype: EmmAddExceptionType
        """
        if not self.is_emm_add_exception():
            raise AttributeError("tag 'emm_add_exception' not set")
        return self._value

    def get_emm_change_policy(self):
        """
        (team_policies) Enabled/disabled enterprise mobility management for
        members

        Only call this if :meth:`is_emm_change_policy` is true.

        :rtype: EmmChangePolicyType
        """
        if not self.is_emm_change_policy():
            raise AttributeError("tag 'emm_change_policy' not set")
        return self._value

    def get_emm_remove_exception(self):
        """
        (team_policies) Removed members from EMM exception list

        Only call this if :meth:`is_emm_remove_exception` is true.

        :rtype: EmmRemoveExceptionType
        """
        if not self.is_emm_remove_exception():
            raise AttributeError("tag 'emm_remove_exception' not set")
        return self._value

    def get_extended_version_history_change_policy(self):
        """
        (team_policies) Accepted/opted out of extended version history

        Only call this if :meth:`is_extended_version_history_change_policy` is true.

        :rtype: ExtendedVersionHistoryChangePolicyType
        """
        if not self.is_extended_version_history_change_policy():
            raise AttributeError("tag 'extended_version_history_change_policy' not set")
        return self._value

    def get_file_comments_change_policy(self):
        """
        (team_policies) Enabled/disabled commenting on team files

        Only call this if :meth:`is_file_comments_change_policy` is true.

        :rtype: FileCommentsChangePolicyType
        """
        if not self.is_file_comments_change_policy():
            raise AttributeError("tag 'file_comments_change_policy' not set")
        return self._value

    def get_file_requests_change_policy(self):
        """
        (team_policies) Enabled/disabled file requests

        Only call this if :meth:`is_file_requests_change_policy` is true.

        :rtype: FileRequestsChangePolicyType
        """
        if not self.is_file_requests_change_policy():
            raise AttributeError("tag 'file_requests_change_policy' not set")
        return self._value

    def get_file_requests_emails_enabled(self):
        """
        (team_policies) Enabled file request emails for everyone (deprecated, no
        longer logged)

        Only call this if :meth:`is_file_requests_emails_enabled` is true.

        :rtype: FileRequestsEmailsEnabledType
        """
        if not self.is_file_requests_emails_enabled():
            raise AttributeError("tag 'file_requests_emails_enabled' not set")
        return self._value

    def get_file_requests_emails_restricted_to_team_only(self):
        """
        (team_policies) Enabled file request emails for team (deprecated, no
        longer logged)

        Only call this if :meth:`is_file_requests_emails_restricted_to_team_only` is true.

        :rtype: FileRequestsEmailsRestrictedToTeamOnlyType
        """
        if not self.is_file_requests_emails_restricted_to_team_only():
            raise AttributeError("tag 'file_requests_emails_restricted_to_team_only' not set")
        return self._value

    def get_google_sso_change_policy(self):
        """
        (team_policies) Enabled/disabled Google single sign-on for team

        Only call this if :meth:`is_google_sso_change_policy` is true.

        :rtype: GoogleSsoChangePolicyType
        """
        if not self.is_google_sso_change_policy():
            raise AttributeError("tag 'google_sso_change_policy' not set")
        return self._value

    def get_group_user_management_change_policy(self):
        """
        (team_policies) Changed who can create groups

        Only call this if :meth:`is_group_user_management_change_policy` is true.

        :rtype: GroupUserManagementChangePolicyType
        """
        if not self.is_group_user_management_change_policy():
            raise AttributeError("tag 'group_user_management_change_policy' not set")
        return self._value

    def get_member_requests_change_policy(self):
        """
        (team_policies) Changed whether users can find team when not invited

        Only call this if :meth:`is_member_requests_change_policy` is true.

        :rtype: MemberRequestsChangePolicyType
        """
        if not self.is_member_requests_change_policy():
            raise AttributeError("tag 'member_requests_change_policy' not set")
        return self._value

    def get_member_space_limits_add_exception(self):
        """
        (team_policies) Added members to member space limit exception list

        Only call this if :meth:`is_member_space_limits_add_exception` is true.

        :rtype: MemberSpaceLimitsAddExceptionType
        """
        if not self.is_member_space_limits_add_exception():
            raise AttributeError("tag 'member_space_limits_add_exception' not set")
        return self._value

    def get_member_space_limits_change_caps_type_policy(self):
        """
        (team_policies) Changed member space limit type for team

        Only call this if :meth:`is_member_space_limits_change_caps_type_policy` is true.

        :rtype: MemberSpaceLimitsChangeCapsTypePolicyType
        """
        if not self.is_member_space_limits_change_caps_type_policy():
            raise AttributeError("tag 'member_space_limits_change_caps_type_policy' not set")
        return self._value

    def get_member_space_limits_change_policy(self):
        """
        (team_policies) Changed team default member space limit

        Only call this if :meth:`is_member_space_limits_change_policy` is true.

        :rtype: MemberSpaceLimitsChangePolicyType
        """
        if not self.is_member_space_limits_change_policy():
            raise AttributeError("tag 'member_space_limits_change_policy' not set")
        return self._value

    def get_member_space_limits_remove_exception(self):
        """
        (team_policies) Removed members from member space limit exception list

        Only call this if :meth:`is_member_space_limits_remove_exception` is true.

        :rtype: MemberSpaceLimitsRemoveExceptionType
        """
        if not self.is_member_space_limits_remove_exception():
            raise AttributeError("tag 'member_space_limits_remove_exception' not set")
        return self._value

    def get_member_suggestions_change_policy(self):
        """
        (team_policies) Enabled/disabled option for team members to suggest
        people to add to team

        Only call this if :meth:`is_member_suggestions_change_policy` is true.

        :rtype: MemberSuggestionsChangePolicyType
        """
        if not self.is_member_suggestions_change_policy():
            raise AttributeError("tag 'member_suggestions_change_policy' not set")
        return self._value

    def get_microsoft_office_addin_change_policy(self):
        """
        (team_policies) Enabled/disabled Microsoft Office add-in

        Only call this if :meth:`is_microsoft_office_addin_change_policy` is true.

        :rtype: MicrosoftOfficeAddinChangePolicyType
        """
        if not self.is_microsoft_office_addin_change_policy():
            raise AttributeError("tag 'microsoft_office_addin_change_policy' not set")
        return self._value

    def get_network_control_change_policy(self):
        """
        (team_policies) Enabled/disabled network control

        Only call this if :meth:`is_network_control_change_policy` is true.

        :rtype: NetworkControlChangePolicyType
        """
        if not self.is_network_control_change_policy():
            raise AttributeError("tag 'network_control_change_policy' not set")
        return self._value

    def get_paper_change_deployment_policy(self):
        """
        (team_policies) Changed whether Dropbox Paper, when enabled, is deployed
        to all members or to specific members

        Only call this if :meth:`is_paper_change_deployment_policy` is true.

        :rtype: PaperChangeDeploymentPolicyType
        """
        if not self.is_paper_change_deployment_policy():
            raise AttributeError("tag 'paper_change_deployment_policy' not set")
        return self._value

    def get_paper_change_member_link_policy(self):
        """
        (team_policies) Changed whether non-members can view Paper docs with
        link (deprecated, no longer logged)

        Only call this if :meth:`is_paper_change_member_link_policy` is true.

        :rtype: PaperChangeMemberLinkPolicyType
        """
        if not self.is_paper_change_member_link_policy():
            raise AttributeError("tag 'paper_change_member_link_policy' not set")
        return self._value

    def get_paper_change_member_policy(self):
        """
        (team_policies) Changed whether members can share Paper docs outside
        team, and if docs are accessible only by team members or anyone by
        default

        Only call this if :meth:`is_paper_change_member_policy` is true.

        :rtype: PaperChangeMemberPolicyType
        """
        if not self.is_paper_change_member_policy():
            raise AttributeError("tag 'paper_change_member_policy' not set")
        return self._value

    def get_paper_change_policy(self):
        """
        (team_policies) Enabled/disabled Dropbox Paper for team

        Only call this if :meth:`is_paper_change_policy` is true.

        :rtype: PaperChangePolicyType
        """
        if not self.is_paper_change_policy():
            raise AttributeError("tag 'paper_change_policy' not set")
        return self._value

    def get_paper_enabled_users_group_addition(self):
        """
        (team_policies) Added users to Paper-enabled users list

        Only call this if :meth:`is_paper_enabled_users_group_addition` is true.

        :rtype: PaperEnabledUsersGroupAdditionType
        """
        if not self.is_paper_enabled_users_group_addition():
            raise AttributeError("tag 'paper_enabled_users_group_addition' not set")
        return self._value

    def get_paper_enabled_users_group_removal(self):
        """
        (team_policies) Removed users from Paper-enabled users list

        Only call this if :meth:`is_paper_enabled_users_group_removal` is true.

        :rtype: PaperEnabledUsersGroupRemovalType
        """
        if not self.is_paper_enabled_users_group_removal():
            raise AttributeError("tag 'paper_enabled_users_group_removal' not set")
        return self._value

    def get_permanent_delete_change_policy(self):
        """
        (team_policies) Enabled/disabled ability of team members to permanently
        delete content

        Only call this if :meth:`is_permanent_delete_change_policy` is true.

        :rtype: PermanentDeleteChangePolicyType
        """
        if not self.is_permanent_delete_change_policy():
            raise AttributeError("tag 'permanent_delete_change_policy' not set")
        return self._value

    def get_sharing_change_folder_join_policy(self):
        """
        (team_policies) Changed whether team members can join shared folders
        owned outside team

        Only call this if :meth:`is_sharing_change_folder_join_policy` is true.

        :rtype: SharingChangeFolderJoinPolicyType
        """
        if not self.is_sharing_change_folder_join_policy():
            raise AttributeError("tag 'sharing_change_folder_join_policy' not set")
        return self._value

    def get_sharing_change_link_policy(self):
        """
        (team_policies) Changed whether members can share links outside team,
        and if links are accessible only by team members or anyone by default

        Only call this if :meth:`is_sharing_change_link_policy` is true.

        :rtype: SharingChangeLinkPolicyType
        """
        if not self.is_sharing_change_link_policy():
            raise AttributeError("tag 'sharing_change_link_policy' not set")
        return self._value

    def get_sharing_change_member_policy(self):
        """
        (team_policies) Changed whether members can share files/folders outside
        team

        Only call this if :meth:`is_sharing_change_member_policy` is true.

        :rtype: SharingChangeMemberPolicyType
        """
        if not self.is_sharing_change_member_policy():
            raise AttributeError("tag 'sharing_change_member_policy' not set")
        return self._value

    def get_showcase_change_download_policy(self):
        """
        (team_policies) Enabled/disabled downloading files from Dropbox Showcase
        for team

        Only call this if :meth:`is_showcase_change_download_policy` is true.

        :rtype: ShowcaseChangeDownloadPolicyType
        """
        if not self.is_showcase_change_download_policy():
            raise AttributeError("tag 'showcase_change_download_policy' not set")
        return self._value

    def get_showcase_change_enabled_policy(self):
        """
        (team_policies) Enabled/disabled Dropbox Showcase for team

        Only call this if :meth:`is_showcase_change_enabled_policy` is true.

        :rtype: ShowcaseChangeEnabledPolicyType
        """
        if not self.is_showcase_change_enabled_policy():
            raise AttributeError("tag 'showcase_change_enabled_policy' not set")
        return self._value

    def get_showcase_change_external_sharing_policy(self):
        """
        (team_policies) Enabled/disabled sharing Dropbox Showcase externally for
        team

        Only call this if :meth:`is_showcase_change_external_sharing_policy` is true.

        :rtype: ShowcaseChangeExternalSharingPolicyType
        """
        if not self.is_showcase_change_external_sharing_policy():
            raise AttributeError("tag 'showcase_change_external_sharing_policy' not set")
        return self._value

    def get_smart_sync_change_policy(self):
        """
        (team_policies) Changed default Smart Sync setting for team members

        Only call this if :meth:`is_smart_sync_change_policy` is true.

        :rtype: SmartSyncChangePolicyType
        """
        if not self.is_smart_sync_change_policy():
            raise AttributeError("tag 'smart_sync_change_policy' not set")
        return self._value

    def get_smart_sync_not_opt_out(self):
        """
        (team_policies) Opted team into Smart Sync

        Only call this if :meth:`is_smart_sync_not_opt_out` is true.

        :rtype: SmartSyncNotOptOutType
        """
        if not self.is_smart_sync_not_opt_out():
            raise AttributeError("tag 'smart_sync_not_opt_out' not set")
        return self._value

    def get_smart_sync_opt_out(self):
        """
        (team_policies) Opted team out of Smart Sync

        Only call this if :meth:`is_smart_sync_opt_out` is true.

        :rtype: SmartSyncOptOutType
        """
        if not self.is_smart_sync_opt_out():
            raise AttributeError("tag 'smart_sync_opt_out' not set")
        return self._value

    def get_sso_change_policy(self):
        """
        (team_policies) Changed single sign-on setting for team

        Only call this if :meth:`is_sso_change_policy` is true.

        :rtype: SsoChangePolicyType
        """
        if not self.is_sso_change_policy():
            raise AttributeError("tag 'sso_change_policy' not set")
        return self._value

    def get_team_selective_sync_policy_changed(self):
        """
        (team_policies) Enabled/disabled Team Selective Sync for team

        Only call this if :meth:`is_team_selective_sync_policy_changed` is true.

        :rtype: TeamSelectiveSyncPolicyChangedType
        """
        if not self.is_team_selective_sync_policy_changed():
            raise AttributeError("tag 'team_selective_sync_policy_changed' not set")
        return self._value

    def get_tfa_change_policy(self):
        """
        (team_policies) Changed two-step verification setting for team

        Only call this if :meth:`is_tfa_change_policy` is true.

        :rtype: TfaChangePolicyType
        """
        if not self.is_tfa_change_policy():
            raise AttributeError("tag 'tfa_change_policy' not set")
        return self._value

    def get_two_account_change_policy(self):
        """
        (team_policies) Enabled/disabled option for members to link personal
        Dropbox account and team account to same computer

        Only call this if :meth:`is_two_account_change_policy` is true.

        :rtype: TwoAccountChangePolicyType
        """
        if not self.is_two_account_change_policy():
            raise AttributeError("tag 'two_account_change_policy' not set")
        return self._value

    def get_viewer_info_policy_changed(self):
        """
        (team_policies) Changed team policy for viewer info

        Only call this if :meth:`is_viewer_info_policy_changed` is true.

        :rtype: ViewerInfoPolicyChangedType
        """
        if not self.is_viewer_info_policy_changed():
            raise AttributeError("tag 'viewer_info_policy_changed' not set")
        return self._value

    def get_web_sessions_change_fixed_length_policy(self):
        """
        (team_policies) Changed how long members can stay signed in to
        Dropbox.com

        Only call this if :meth:`is_web_sessions_change_fixed_length_policy` is true.

        :rtype: WebSessionsChangeFixedLengthPolicyType
        """
        if not self.is_web_sessions_change_fixed_length_policy():
            raise AttributeError("tag 'web_sessions_change_fixed_length_policy' not set")
        return self._value

    def get_web_sessions_change_idle_length_policy(self):
        """
        (team_policies) Changed how long team members can be idle while signed
        in to Dropbox.com

        Only call this if :meth:`is_web_sessions_change_idle_length_policy` is true.

        :rtype: WebSessionsChangeIdleLengthPolicyType
        """
        if not self.is_web_sessions_change_idle_length_policy():
            raise AttributeError("tag 'web_sessions_change_idle_length_policy' not set")
        return self._value

    def get_team_merge_from(self):
        """
        (team_profile) Merged another team into this team

        Only call this if :meth:`is_team_merge_from` is true.

        :rtype: TeamMergeFromType
        """
        if not self.is_team_merge_from():
            raise AttributeError("tag 'team_merge_from' not set")
        return self._value

    def get_team_merge_to(self):
        """
        (team_profile) Merged this team into another team

        Only call this if :meth:`is_team_merge_to` is true.

        :rtype: TeamMergeToType
        """
        if not self.is_team_merge_to():
            raise AttributeError("tag 'team_merge_to' not set")
        return self._value

    def get_team_profile_add_logo(self):
        """
        (team_profile) Added team logo to display on shared link headers

        Only call this if :meth:`is_team_profile_add_logo` is true.

        :rtype: TeamProfileAddLogoType
        """
        if not self.is_team_profile_add_logo():
            raise AttributeError("tag 'team_profile_add_logo' not set")
        return self._value

    def get_team_profile_change_default_language(self):
        """
        (team_profile) Changed default language for team

        Only call this if :meth:`is_team_profile_change_default_language` is true.

        :rtype: TeamProfileChangeDefaultLanguageType
        """
        if not self.is_team_profile_change_default_language():
            raise AttributeError("tag 'team_profile_change_default_language' not set")
        return self._value

    def get_team_profile_change_logo(self):
        """
        (team_profile) Changed team logo displayed on shared link headers

        Only call this if :meth:`is_team_profile_change_logo` is true.

        :rtype: TeamProfileChangeLogoType
        """
        if not self.is_team_profile_change_logo():
            raise AttributeError("tag 'team_profile_change_logo' not set")
        return self._value

    def get_team_profile_change_name(self):
        """
        (team_profile) Changed team name

        Only call this if :meth:`is_team_profile_change_name` is true.

        :rtype: TeamProfileChangeNameType
        """
        if not self.is_team_profile_change_name():
            raise AttributeError("tag 'team_profile_change_name' not set")
        return self._value

    def get_team_profile_remove_logo(self):
        """
        (team_profile) Removed team logo displayed on shared link headers

        Only call this if :meth:`is_team_profile_remove_logo` is true.

        :rtype: TeamProfileRemoveLogoType
        """
        if not self.is_team_profile_remove_logo():
            raise AttributeError("tag 'team_profile_remove_logo' not set")
        return self._value

    def get_tfa_add_backup_phone(self):
        """
        (tfa) Added backup phone for two-step verification

        Only call this if :meth:`is_tfa_add_backup_phone` is true.

        :rtype: TfaAddBackupPhoneType
        """
        if not self.is_tfa_add_backup_phone():
            raise AttributeError("tag 'tfa_add_backup_phone' not set")
        return self._value

    def get_tfa_add_security_key(self):
        """
        (tfa) Added security key for two-step verification

        Only call this if :meth:`is_tfa_add_security_key` is true.

        :rtype: TfaAddSecurityKeyType
        """
        if not self.is_tfa_add_security_key():
            raise AttributeError("tag 'tfa_add_security_key' not set")
        return self._value

    def get_tfa_change_backup_phone(self):
        """
        (tfa) Changed backup phone for two-step verification

        Only call this if :meth:`is_tfa_change_backup_phone` is true.

        :rtype: TfaChangeBackupPhoneType
        """
        if not self.is_tfa_change_backup_phone():
            raise AttributeError("tag 'tfa_change_backup_phone' not set")
        return self._value

    def get_tfa_change_status(self):
        """
        (tfa) Enabled/disabled/changed two-step verification setting

        Only call this if :meth:`is_tfa_change_status` is true.

        :rtype: TfaChangeStatusType
        """
        if not self.is_tfa_change_status():
            raise AttributeError("tag 'tfa_change_status' not set")
        return self._value

    def get_tfa_remove_backup_phone(self):
        """
        (tfa) Removed backup phone for two-step verification

        Only call this if :meth:`is_tfa_remove_backup_phone` is true.

        :rtype: TfaRemoveBackupPhoneType
        """
        if not self.is_tfa_remove_backup_phone():
            raise AttributeError("tag 'tfa_remove_backup_phone' not set")
        return self._value

    def get_tfa_remove_security_key(self):
        """
        (tfa) Removed security key for two-step verification

        Only call this if :meth:`is_tfa_remove_security_key` is true.

        :rtype: TfaRemoveSecurityKeyType
        """
        if not self.is_tfa_remove_security_key():
            raise AttributeError("tag 'tfa_remove_security_key' not set")
        return self._value

    def get_tfa_reset(self):
        """
        (tfa) Reset two-step verification for team member

        Only call this if :meth:`is_tfa_reset` is true.

        :rtype: TfaResetType
        """
        if not self.is_tfa_reset():
            raise AttributeError("tag 'tfa_reset' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, processor):
        super(EventType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'EventType(%r, %r)' % (self._tag, self._value)

EventType_validator = bv.Union(EventType)

class ExportMembersReportDetails(bb.Struct):
    """
    Created member data report.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(ExportMembersReportDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ExportMembersReportDetails()'

ExportMembersReportDetails_validator = bv.Struct(ExportMembersReportDetails)

class ExportMembersReportType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ExportMembersReportType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ExportMembersReportType(description={!r})'.format(
            self._description_value,
        )

ExportMembersReportType_validator = bv.Struct(ExportMembersReportType)

class ExtendedVersionHistoryChangePolicyDetails(bb.Struct):
    """
    Accepted/opted out of extended version history.

    :ivar new_value: New extended version history policy.
    :ivar previous_value: Previous extended version history policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New extended version history policy.

        :rtype: ExtendedVersionHistoryPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous extended version history policy. Might be missing due to
        historical data gap.

        :rtype: ExtendedVersionHistoryPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ExtendedVersionHistoryChangePolicyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ExtendedVersionHistoryChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

ExtendedVersionHistoryChangePolicyDetails_validator = bv.Struct(ExtendedVersionHistoryChangePolicyDetails)

class ExtendedVersionHistoryChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ExtendedVersionHistoryChangePolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ExtendedVersionHistoryChangePolicyType(description={!r})'.format(
            self._description_value,
        )

ExtendedVersionHistoryChangePolicyType_validator = bv.Struct(ExtendedVersionHistoryChangePolicyType)

class ExtendedVersionHistoryPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    explicitly_limited = None
    # Attribute is overwritten below the class definition
    explicitly_unlimited = None
    # Attribute is overwritten below the class definition
    implicitly_limited = None
    # Attribute is overwritten below the class definition
    implicitly_unlimited = None
    # Attribute is overwritten below the class definition
    other = None

    def is_explicitly_limited(self):
        """
        Check if the union tag is ``explicitly_limited``.

        :rtype: bool
        """
        return self._tag == 'explicitly_limited'

    def is_explicitly_unlimited(self):
        """
        Check if the union tag is ``explicitly_unlimited``.

        :rtype: bool
        """
        return self._tag == 'explicitly_unlimited'

    def is_implicitly_limited(self):
        """
        Check if the union tag is ``implicitly_limited``.

        :rtype: bool
        """
        return self._tag == 'implicitly_limited'

    def is_implicitly_unlimited(self):
        """
        Check if the union tag is ``implicitly_unlimited``.

        :rtype: bool
        """
        return self._tag == 'implicitly_unlimited'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(ExtendedVersionHistoryPolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ExtendedVersionHistoryPolicy(%r, %r)' % (self._tag, self._value)

ExtendedVersionHistoryPolicy_validator = bv.Union(ExtendedVersionHistoryPolicy)

class ExternalUserLogInfo(bb.Struct):
    """
    A user without a Dropbox account.

    :ivar user_identifier: An external user identifier.
    :ivar identifier_type: Identifier type.
    """

    __slots__ = [
        '_user_identifier_value',
        '_user_identifier_present',
        '_identifier_type_value',
        '_identifier_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 user_identifier=None,
                 identifier_type=None):
        self._user_identifier_value = None
        self._user_identifier_present = False
        self._identifier_type_value = None
        self._identifier_type_present = False
        if user_identifier is not None:
            self.user_identifier = user_identifier
        if identifier_type is not None:
            self.identifier_type = identifier_type

    @property
    def user_identifier(self):
        """
        An external user identifier.

        :rtype: str
        """
        if self._user_identifier_present:
            return self._user_identifier_value
        else:
            raise AttributeError("missing required field 'user_identifier'")

    @user_identifier.setter
    def user_identifier(self, val):
        val = self._user_identifier_validator.validate(val)
        self._user_identifier_value = val
        self._user_identifier_present = True

    @user_identifier.deleter
    def user_identifier(self):
        self._user_identifier_value = None
        self._user_identifier_present = False

    @property
    def identifier_type(self):
        """
        Identifier type.

        :rtype: IdentifierType
        """
        if self._identifier_type_present:
            return self._identifier_type_value
        else:
            raise AttributeError("missing required field 'identifier_type'")

    @identifier_type.setter
    def identifier_type(self, val):
        self._identifier_type_validator.validate_type_only(val)
        self._identifier_type_value = val
        self._identifier_type_present = True

    @identifier_type.deleter
    def identifier_type(self):
        self._identifier_type_value = None
        self._identifier_type_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ExternalUserLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ExternalUserLogInfo(user_identifier={!r}, identifier_type={!r})'.format(
            self._user_identifier_value,
            self._identifier_type_value,
        )

ExternalUserLogInfo_validator = bv.Struct(ExternalUserLogInfo)

class FailureDetailsLogInfo(bb.Struct):
    """
    Provides details about a failure

    :ivar user_friendly_message: A user friendly explanation of the error. Might
        be missing due to historical data gap.
    :ivar technical_error_message: A technical explanation of the error. This is
        relevant for some errors.
    """

    __slots__ = [
        '_user_friendly_message_value',
        '_user_friendly_message_present',
        '_technical_error_message_value',
        '_technical_error_message_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 user_friendly_message=None,
                 technical_error_message=None):
        self._user_friendly_message_value = None
        self._user_friendly_message_present = False
        self._technical_error_message_value = None
        self._technical_error_message_present = False
        if user_friendly_message is not None:
            self.user_friendly_message = user_friendly_message
        if technical_error_message is not None:
            self.technical_error_message = technical_error_message

    @property
    def user_friendly_message(self):
        """
        A user friendly explanation of the error. Might be missing due to
        historical data gap.

        :rtype: str
        """
        if self._user_friendly_message_present:
            return self._user_friendly_message_value
        else:
            return None

    @user_friendly_message.setter
    def user_friendly_message(self, val):
        if val is None:
            del self.user_friendly_message
            return
        val = self._user_friendly_message_validator.validate(val)
        self._user_friendly_message_value = val
        self._user_friendly_message_present = True

    @user_friendly_message.deleter
    def user_friendly_message(self):
        self._user_friendly_message_value = None
        self._user_friendly_message_present = False

    @property
    def technical_error_message(self):
        """
        A technical explanation of the error. This is relevant for some errors.

        :rtype: str
        """
        if self._technical_error_message_present:
            return self._technical_error_message_value
        else:
            return None

    @technical_error_message.setter
    def technical_error_message(self, val):
        if val is None:
            del self.technical_error_message
            return
        val = self._technical_error_message_validator.validate(val)
        self._technical_error_message_value = val
        self._technical_error_message_present = True

    @technical_error_message.deleter
    def technical_error_message(self):
        self._technical_error_message_value = None
        self._technical_error_message_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FailureDetailsLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FailureDetailsLogInfo(user_friendly_message={!r}, technical_error_message={!r})'.format(
            self._user_friendly_message_value,
            self._technical_error_message_value,
        )

FailureDetailsLogInfo_validator = bv.Struct(FailureDetailsLogInfo)

class FileAddCommentDetails(bb.Struct):
    """
    Added file comment.

    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 comment_text=None):
        self._comment_text_value = None
        self._comment_text_present = False
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileAddCommentDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileAddCommentDetails(comment_text={!r})'.format(
            self._comment_text_value,
        )

FileAddCommentDetails_validator = bv.Struct(FileAddCommentDetails)

class FileAddCommentType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileAddCommentType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileAddCommentType(description={!r})'.format(
            self._description_value,
        )

FileAddCommentType_validator = bv.Struct(FileAddCommentType)

class FileAddDetails(bb.Struct):
    """
    Added files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileAddDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileAddDetails()'

FileAddDetails_validator = bv.Struct(FileAddDetails)

class FileAddType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileAddType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileAddType(description={!r})'.format(
            self._description_value,
        )

FileAddType_validator = bv.Struct(FileAddType)

class FileChangeCommentSubscriptionDetails(bb.Struct):
    """
    Subscribed to or unsubscribed from comment notifications for file.

    :ivar new_value: New file comment subscription.
    :ivar previous_value: Previous file comment subscription. Might be missing
        due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New file comment subscription.

        :rtype: FileCommentNotificationPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous file comment subscription. Might be missing due to historical
        data gap.

        :rtype: FileCommentNotificationPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileChangeCommentSubscriptionDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileChangeCommentSubscriptionDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

FileChangeCommentSubscriptionDetails_validator = bv.Struct(FileChangeCommentSubscriptionDetails)

class FileChangeCommentSubscriptionType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileChangeCommentSubscriptionType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileChangeCommentSubscriptionType(description={!r})'.format(
            self._description_value,
        )

FileChangeCommentSubscriptionType_validator = bv.Struct(FileChangeCommentSubscriptionType)

class FileCommentNotificationPolicy(bb.Union):
    """
    Enable or disable file comments notifications

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileCommentNotificationPolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileCommentNotificationPolicy(%r, %r)' % (self._tag, self._value)

FileCommentNotificationPolicy_validator = bv.Union(FileCommentNotificationPolicy)

class FileCommentsChangePolicyDetails(bb.Struct):
    """
    Enabled/disabled commenting on team files.

    :ivar new_value: New commenting on team files policy.
    :ivar previous_value: Previous commenting on team files policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New commenting on team files policy.

        :rtype: FileCommentsPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous commenting on team files policy. Might be missing due to
        historical data gap.

        :rtype: FileCommentsPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileCommentsChangePolicyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileCommentsChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

FileCommentsChangePolicyDetails_validator = bv.Struct(FileCommentsChangePolicyDetails)

class FileCommentsChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileCommentsChangePolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileCommentsChangePolicyType(description={!r})'.format(
            self._description_value,
        )

FileCommentsChangePolicyType_validator = bv.Struct(FileCommentsChangePolicyType)

class FileCommentsPolicy(bb.Union):
    """
    File comments policy

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileCommentsPolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileCommentsPolicy(%r, %r)' % (self._tag, self._value)

FileCommentsPolicy_validator = bv.Union(FileCommentsPolicy)

class FileCopyDetails(bb.Struct):
    """
    Copied files and/or folders.

    :ivar relocate_action_details: Relocate action details.
    """

    __slots__ = [
        '_relocate_action_details_value',
        '_relocate_action_details_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 relocate_action_details=None):
        self._relocate_action_details_value = None
        self._relocate_action_details_present = False
        if relocate_action_details is not None:
            self.relocate_action_details = relocate_action_details

    @property
    def relocate_action_details(self):
        """
        Relocate action details.

        :rtype: list of [RelocateAssetReferencesLogInfo]
        """
        if self._relocate_action_details_present:
            return self._relocate_action_details_value
        else:
            raise AttributeError("missing required field 'relocate_action_details'")

    @relocate_action_details.setter
    def relocate_action_details(self, val):
        val = self._relocate_action_details_validator.validate(val)
        self._relocate_action_details_value = val
        self._relocate_action_details_present = True

    @relocate_action_details.deleter
    def relocate_action_details(self):
        self._relocate_action_details_value = None
        self._relocate_action_details_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileCopyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileCopyDetails(relocate_action_details={!r})'.format(
            self._relocate_action_details_value,
        )

FileCopyDetails_validator = bv.Struct(FileCopyDetails)

class FileCopyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileCopyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileCopyType(description={!r})'.format(
            self._description_value,
        )

FileCopyType_validator = bv.Struct(FileCopyType)

class FileDeleteCommentDetails(bb.Struct):
    """
    Deleted file comment.

    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 comment_text=None):
        self._comment_text_value = None
        self._comment_text_present = False
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileDeleteCommentDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileDeleteCommentDetails(comment_text={!r})'.format(
            self._comment_text_value,
        )

FileDeleteCommentDetails_validator = bv.Struct(FileDeleteCommentDetails)

class FileDeleteCommentType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileDeleteCommentType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileDeleteCommentType(description={!r})'.format(
            self._description_value,
        )

FileDeleteCommentType_validator = bv.Struct(FileDeleteCommentType)

class FileDeleteDetails(bb.Struct):
    """
    Deleted files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileDeleteDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileDeleteDetails()'

FileDeleteDetails_validator = bv.Struct(FileDeleteDetails)

class FileDeleteType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileDeleteType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileDeleteType(description={!r})'.format(
            self._description_value,
        )

FileDeleteType_validator = bv.Struct(FileDeleteType)

class FileDownloadDetails(bb.Struct):
    """
    Downloaded files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileDownloadDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileDownloadDetails()'

FileDownloadDetails_validator = bv.Struct(FileDownloadDetails)

class FileDownloadType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileDownloadType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileDownloadType(description={!r})'.format(
            self._description_value,
        )

FileDownloadType_validator = bv.Struct(FileDownloadType)

class FileEditDetails(bb.Struct):
    """
    Edited files.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileEditDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileEditDetails()'

FileEditDetails_validator = bv.Struct(FileEditDetails)

class FileEditType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileEditType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileEditType(description={!r})'.format(
            self._description_value,
        )

FileEditType_validator = bv.Struct(FileEditType)

class FileGetCopyReferenceDetails(bb.Struct):
    """
    Created copy reference to file/folder.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileGetCopyReferenceDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileGetCopyReferenceDetails()'

FileGetCopyReferenceDetails_validator = bv.Struct(FileGetCopyReferenceDetails)

class FileGetCopyReferenceType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileGetCopyReferenceType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileGetCopyReferenceType(description={!r})'.format(
            self._description_value,
        )

FileGetCopyReferenceType_validator = bv.Struct(FileGetCopyReferenceType)

class FileLikeCommentDetails(bb.Struct):
    """
    Liked file comment.

    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 comment_text=None):
        self._comment_text_value = None
        self._comment_text_present = False
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileLikeCommentDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileLikeCommentDetails(comment_text={!r})'.format(
            self._comment_text_value,
        )

FileLikeCommentDetails_validator = bv.Struct(FileLikeCommentDetails)

class FileLikeCommentType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileLikeCommentType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileLikeCommentType(description={!r})'.format(
            self._description_value,
        )

FileLikeCommentType_validator = bv.Struct(FileLikeCommentType)

class FileOrFolderLogInfo(bb.Struct):
    """
    Generic information relevant both for files and folders

    :ivar path: Path relative to event context.
    :ivar display_name: Display name. Might be missing due to historical data
        gap.
    :ivar file_id: Unique ID. Might be missing due to historical data gap.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_display_name_value',
        '_display_name_present',
        '_file_id_value',
        '_file_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 display_name=None,
                 file_id=None):
        self._path_value = None
        self._path_present = False
        self._display_name_value = None
        self._display_name_present = False
        self._file_id_value = None
        self._file_id_present = False
        if path is not None:
            self.path = path
        if display_name is not None:
            self.display_name = display_name
        if file_id is not None:
            self.file_id = file_id

    @property
    def path(self):
        """
        Path relative to event context.

        :rtype: PathLogInfo
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        self._path_validator.validate_type_only(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def display_name(self):
        """
        Display name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            return None

    @display_name.setter
    def display_name(self, val):
        if val is None:
            del self.display_name
            return
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def file_id(self):
        """
        Unique ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._file_id_present:
            return self._file_id_value
        else:
            return None

    @file_id.setter
    def file_id(self, val):
        if val is None:
            del self.file_id
            return
        val = self._file_id_validator.validate(val)
        self._file_id_value = val
        self._file_id_present = True

    @file_id.deleter
    def file_id(self):
        self._file_id_value = None
        self._file_id_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileOrFolderLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileOrFolderLogInfo(path={!r}, display_name={!r}, file_id={!r})'.format(
            self._path_value,
            self._display_name_value,
            self._file_id_value,
        )

FileOrFolderLogInfo_validator = bv.Struct(FileOrFolderLogInfo)

class FileLogInfo(FileOrFolderLogInfo):
    """
    File's logged information.
    """

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 display_name=None,
                 file_id=None):
        super(FileLogInfo, self).__init__(path,
                                          display_name,
                                          file_id)

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileLogInfo(path={!r}, display_name={!r}, file_id={!r})'.format(
            self._path_value,
            self._display_name_value,
            self._file_id_value,
        )

FileLogInfo_validator = bv.Struct(FileLogInfo)

class FileMoveDetails(bb.Struct):
    """
    Moved files and/or folders.

    :ivar relocate_action_details: Relocate action details.
    """

    __slots__ = [
        '_relocate_action_details_value',
        '_relocate_action_details_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 relocate_action_details=None):
        self._relocate_action_details_value = None
        self._relocate_action_details_present = False
        if relocate_action_details is not None:
            self.relocate_action_details = relocate_action_details

    @property
    def relocate_action_details(self):
        """
        Relocate action details.

        :rtype: list of [RelocateAssetReferencesLogInfo]
        """
        if self._relocate_action_details_present:
            return self._relocate_action_details_value
        else:
            raise AttributeError("missing required field 'relocate_action_details'")

    @relocate_action_details.setter
    def relocate_action_details(self, val):
        val = self._relocate_action_details_validator.validate(val)
        self._relocate_action_details_value = val
        self._relocate_action_details_present = True

    @relocate_action_details.deleter
    def relocate_action_details(self):
        self._relocate_action_details_value = None
        self._relocate_action_details_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileMoveDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileMoveDetails(relocate_action_details={!r})'.format(
            self._relocate_action_details_value,
        )

FileMoveDetails_validator = bv.Struct(FileMoveDetails)

class FileMoveType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileMoveType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileMoveType(description={!r})'.format(
            self._description_value,
        )

FileMoveType_validator = bv.Struct(FileMoveType)

class FilePermanentlyDeleteDetails(bb.Struct):
    """
    Permanently deleted files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FilePermanentlyDeleteDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FilePermanentlyDeleteDetails()'

FilePermanentlyDeleteDetails_validator = bv.Struct(FilePermanentlyDeleteDetails)

class FilePermanentlyDeleteType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FilePermanentlyDeleteType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FilePermanentlyDeleteType(description={!r})'.format(
            self._description_value,
        )

FilePermanentlyDeleteType_validator = bv.Struct(FilePermanentlyDeleteType)

class FilePreviewDetails(bb.Struct):
    """
    Previewed files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FilePreviewDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FilePreviewDetails()'

FilePreviewDetails_validator = bv.Struct(FilePreviewDetails)

class FilePreviewType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FilePreviewType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FilePreviewType(description={!r})'.format(
            self._description_value,
        )

FilePreviewType_validator = bv.Struct(FilePreviewType)

class FileRenameDetails(bb.Struct):
    """
    Renamed files and/or folders.

    :ivar relocate_action_details: Relocate action details.
    """

    __slots__ = [
        '_relocate_action_details_value',
        '_relocate_action_details_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 relocate_action_details=None):
        self._relocate_action_details_value = None
        self._relocate_action_details_present = False
        if relocate_action_details is not None:
            self.relocate_action_details = relocate_action_details

    @property
    def relocate_action_details(self):
        """
        Relocate action details.

        :rtype: list of [RelocateAssetReferencesLogInfo]
        """
        if self._relocate_action_details_present:
            return self._relocate_action_details_value
        else:
            raise AttributeError("missing required field 'relocate_action_details'")

    @relocate_action_details.setter
    def relocate_action_details(self, val):
        val = self._relocate_action_details_validator.validate(val)
        self._relocate_action_details_value = val
        self._relocate_action_details_present = True

    @relocate_action_details.deleter
    def relocate_action_details(self):
        self._relocate_action_details_value = None
        self._relocate_action_details_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRenameDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRenameDetails(relocate_action_details={!r})'.format(
            self._relocate_action_details_value,
        )

FileRenameDetails_validator = bv.Struct(FileRenameDetails)

class FileRenameType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRenameType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRenameType(description={!r})'.format(
            self._description_value,
        )

FileRenameType_validator = bv.Struct(FileRenameType)

class FileRequestChangeDetails(bb.Struct):
    """
    Changed file request.

    :ivar file_request_id: File request id. Might be missing due to historical
        data gap.
    :ivar previous_details: Previous file request details. Might be missing due
        to historical data gap.
    :ivar new_details: New file request details.
    """

    __slots__ = [
        '_file_request_id_value',
        '_file_request_id_present',
        '_previous_details_value',
        '_previous_details_present',
        '_new_details_value',
        '_new_details_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_details=None,
                 file_request_id=None,
                 previous_details=None):
        self._file_request_id_value = None
        self._file_request_id_present = False
        self._previous_details_value = None
        self._previous_details_present = False
        self._new_details_value = None
        self._new_details_present = False
        if file_request_id is not None:
            self.file_request_id = file_request_id
        if previous_details is not None:
            self.previous_details = previous_details
        if new_details is not None:
            self.new_details = new_details

    @property
    def file_request_id(self):
        """
        File request id. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._file_request_id_present:
            return self._file_request_id_value
        else:
            return None

    @file_request_id.setter
    def file_request_id(self, val):
        if val is None:
            del self.file_request_id
            return
        val = self._file_request_id_validator.validate(val)
        self._file_request_id_value = val
        self._file_request_id_present = True

    @file_request_id.deleter
    def file_request_id(self):
        self._file_request_id_value = None
        self._file_request_id_present = False

    @property
    def previous_details(self):
        """
        Previous file request details. Might be missing due to historical data
        gap.

        :rtype: FileRequestDetails
        """
        if self._previous_details_present:
            return self._previous_details_value
        else:
            return None

    @previous_details.setter
    def previous_details(self, val):
        if val is None:
            del self.previous_details
            return
        self._previous_details_validator.validate_type_only(val)
        self._previous_details_value = val
        self._previous_details_present = True

    @previous_details.deleter
    def previous_details(self):
        self._previous_details_value = None
        self._previous_details_present = False

    @property
    def new_details(self):
        """
        New file request details.

        :rtype: FileRequestDetails
        """
        if self._new_details_present:
            return self._new_details_value
        else:
            raise AttributeError("missing required field 'new_details'")

    @new_details.setter
    def new_details(self, val):
        self._new_details_validator.validate_type_only(val)
        self._new_details_value = val
        self._new_details_present = True

    @new_details.deleter
    def new_details(self):
        self._new_details_value = None
        self._new_details_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestChangeDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestChangeDetails(new_details={!r}, file_request_id={!r}, previous_details={!r})'.format(
            self._new_details_value,
            self._file_request_id_value,
            self._previous_details_value,
        )

FileRequestChangeDetails_validator = bv.Struct(FileRequestChangeDetails)

class FileRequestChangeType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestChangeType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestChangeType(description={!r})'.format(
            self._description_value,
        )

FileRequestChangeType_validator = bv.Struct(FileRequestChangeType)

class FileRequestCloseDetails(bb.Struct):
    """
    Closed file request.

    :ivar file_request_id: File request id. Might be missing due to historical
        data gap.
    :ivar previous_details: Previous file request details. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_file_request_id_value',
        '_file_request_id_present',
        '_previous_details_value',
        '_previous_details_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 file_request_id=None,
                 previous_details=None):
        self._file_request_id_value = None
        self._file_request_id_present = False
        self._previous_details_value = None
        self._previous_details_present = False
        if file_request_id is not None:
            self.file_request_id = file_request_id
        if previous_details is not None:
            self.previous_details = previous_details

    @property
    def file_request_id(self):
        """
        File request id. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._file_request_id_present:
            return self._file_request_id_value
        else:
            return None

    @file_request_id.setter
    def file_request_id(self, val):
        if val is None:
            del self.file_request_id
            return
        val = self._file_request_id_validator.validate(val)
        self._file_request_id_value = val
        self._file_request_id_present = True

    @file_request_id.deleter
    def file_request_id(self):
        self._file_request_id_value = None
        self._file_request_id_present = False

    @property
    def previous_details(self):
        """
        Previous file request details. Might be missing due to historical data
        gap.

        :rtype: FileRequestDetails
        """
        if self._previous_details_present:
            return self._previous_details_value
        else:
            return None

    @previous_details.setter
    def previous_details(self, val):
        if val is None:
            del self.previous_details
            return
        self._previous_details_validator.validate_type_only(val)
        self._previous_details_value = val
        self._previous_details_present = True

    @previous_details.deleter
    def previous_details(self):
        self._previous_details_value = None
        self._previous_details_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestCloseDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestCloseDetails(file_request_id={!r}, previous_details={!r})'.format(
            self._file_request_id_value,
            self._previous_details_value,
        )

FileRequestCloseDetails_validator = bv.Struct(FileRequestCloseDetails)

class FileRequestCloseType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestCloseType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestCloseType(description={!r})'.format(
            self._description_value,
        )

FileRequestCloseType_validator = bv.Struct(FileRequestCloseType)

class FileRequestCreateDetails(bb.Struct):
    """
    Created file request.

    :ivar file_request_id: File request id. Might be missing due to historical
        data gap.
    :ivar request_details: File request details. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_file_request_id_value',
        '_file_request_id_present',
        '_request_details_value',
        '_request_details_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 file_request_id=None,
                 request_details=None):
        self._file_request_id_value = None
        self._file_request_id_present = False
        self._request_details_value = None
        self._request_details_present = False
        if file_request_id is not None:
            self.file_request_id = file_request_id
        if request_details is not None:
            self.request_details = request_details

    @property
    def file_request_id(self):
        """
        File request id. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._file_request_id_present:
            return self._file_request_id_value
        else:
            return None

    @file_request_id.setter
    def file_request_id(self, val):
        if val is None:
            del self.file_request_id
            return
        val = self._file_request_id_validator.validate(val)
        self._file_request_id_value = val
        self._file_request_id_present = True

    @file_request_id.deleter
    def file_request_id(self):
        self._file_request_id_value = None
        self._file_request_id_present = False

    @property
    def request_details(self):
        """
        File request details. Might be missing due to historical data gap.

        :rtype: FileRequestDetails
        """
        if self._request_details_present:
            return self._request_details_value
        else:
            return None

    @request_details.setter
    def request_details(self, val):
        if val is None:
            del self.request_details
            return
        self._request_details_validator.validate_type_only(val)
        self._request_details_value = val
        self._request_details_present = True

    @request_details.deleter
    def request_details(self):
        self._request_details_value = None
        self._request_details_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestCreateDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestCreateDetails(file_request_id={!r}, request_details={!r})'.format(
            self._file_request_id_value,
            self._request_details_value,
        )

FileRequestCreateDetails_validator = bv.Struct(FileRequestCreateDetails)

class FileRequestCreateType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestCreateType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestCreateType(description={!r})'.format(
            self._description_value,
        )

FileRequestCreateType_validator = bv.Struct(FileRequestCreateType)

class FileRequestDeadline(bb.Struct):
    """
    File request deadline

    :ivar deadline: The deadline for this file request. Might be missing due to
        historical data gap.
    :ivar allow_late_uploads: If set, allow uploads after the deadline has
        passed. Might be missing due to historical data gap.
    """

    __slots__ = [
        '_deadline_value',
        '_deadline_present',
        '_allow_late_uploads_value',
        '_allow_late_uploads_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 deadline=None,
                 allow_late_uploads=None):
        self._deadline_value = None
        self._deadline_present = False
        self._allow_late_uploads_value = None
        self._allow_late_uploads_present = False
        if deadline is not None:
            self.deadline = deadline
        if allow_late_uploads is not None:
            self.allow_late_uploads = allow_late_uploads

    @property
    def deadline(self):
        """
        The deadline for this file request. Might be missing due to historical
        data gap.

        :rtype: datetime.datetime
        """
        if self._deadline_present:
            return self._deadline_value
        else:
            return None

    @deadline.setter
    def deadline(self, val):
        if val is None:
            del self.deadline
            return
        val = self._deadline_validator.validate(val)
        self._deadline_value = val
        self._deadline_present = True

    @deadline.deleter
    def deadline(self):
        self._deadline_value = None
        self._deadline_present = False

    @property
    def allow_late_uploads(self):
        """
        If set, allow uploads after the deadline has passed. Might be missing
        due to historical data gap.

        :rtype: str
        """
        if self._allow_late_uploads_present:
            return self._allow_late_uploads_value
        else:
            return None

    @allow_late_uploads.setter
    def allow_late_uploads(self, val):
        if val is None:
            del self.allow_late_uploads
            return
        val = self._allow_late_uploads_validator.validate(val)
        self._allow_late_uploads_value = val
        self._allow_late_uploads_present = True

    @allow_late_uploads.deleter
    def allow_late_uploads(self):
        self._allow_late_uploads_value = None
        self._allow_late_uploads_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestDeadline, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestDeadline(deadline={!r}, allow_late_uploads={!r})'.format(
            self._deadline_value,
            self._allow_late_uploads_value,
        )

FileRequestDeadline_validator = bv.Struct(FileRequestDeadline)

class FileRequestDetails(bb.Struct):
    """
    File request details

    :ivar asset_index: Asset position in the Assets list.
    :ivar deadline: File request deadline. Might be missing due to historical
        data gap.
    """

    __slots__ = [
        '_asset_index_value',
        '_asset_index_present',
        '_deadline_value',
        '_deadline_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 asset_index=None,
                 deadline=None):
        self._asset_index_value = None
        self._asset_index_present = False
        self._deadline_value = None
        self._deadline_present = False
        if asset_index is not None:
            self.asset_index = asset_index
        if deadline is not None:
            self.deadline = deadline

    @property
    def asset_index(self):
        """
        Asset position in the Assets list.

        :rtype: long
        """
        if self._asset_index_present:
            return self._asset_index_value
        else:
            raise AttributeError("missing required field 'asset_index'")

    @asset_index.setter
    def asset_index(self, val):
        val = self._asset_index_validator.validate(val)
        self._asset_index_value = val
        self._asset_index_present = True

    @asset_index.deleter
    def asset_index(self):
        self._asset_index_value = None
        self._asset_index_present = False

    @property
    def deadline(self):
        """
        File request deadline. Might be missing due to historical data gap.

        :rtype: FileRequestDeadline
        """
        if self._deadline_present:
            return self._deadline_value
        else:
            return None

    @deadline.setter
    def deadline(self, val):
        if val is None:
            del self.deadline
            return
        self._deadline_validator.validate_type_only(val)
        self._deadline_value = val
        self._deadline_present = True

    @deadline.deleter
    def deadline(self):
        self._deadline_value = None
        self._deadline_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestDetails(asset_index={!r}, deadline={!r})'.format(
            self._asset_index_value,
            self._deadline_value,
        )

FileRequestDetails_validator = bv.Struct(FileRequestDetails)

class FileRequestReceiveFileDetails(bb.Struct):
    """
    Received files for file request.

    :ivar file_request_id: File request id. Might be missing due to historical
        data gap.
    :ivar file_request_details: File request details. Might be missing due to
        historical data gap.
    :ivar submitted_file_names: Submitted file names.
    :ivar submitter_name: The name as provided by the submitter. Might be
        missing due to historical data gap.
    :ivar submitter_email: The email as provided by the submitter. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_file_request_id_value',
        '_file_request_id_present',
        '_file_request_details_value',
        '_file_request_details_present',
        '_submitted_file_names_value',
        '_submitted_file_names_present',
        '_submitter_name_value',
        '_submitter_name_present',
        '_submitter_email_value',
        '_submitter_email_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 submitted_file_names=None,
                 file_request_id=None,
                 file_request_details=None,
                 submitter_name=None,
                 submitter_email=None):
        self._file_request_id_value = None
        self._file_request_id_present = False
        self._file_request_details_value = None
        self._file_request_details_present = False
        self._submitted_file_names_value = None
        self._submitted_file_names_present = False
        self._submitter_name_value = None
        self._submitter_name_present = False
        self._submitter_email_value = None
        self._submitter_email_present = False
        if file_request_id is not None:
            self.file_request_id = file_request_id
        if file_request_details is not None:
            self.file_request_details = file_request_details
        if submitted_file_names is not None:
            self.submitted_file_names = submitted_file_names
        if submitter_name is not None:
            self.submitter_name = submitter_name
        if submitter_email is not None:
            self.submitter_email = submitter_email

    @property
    def file_request_id(self):
        """
        File request id. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._file_request_id_present:
            return self._file_request_id_value
        else:
            return None

    @file_request_id.setter
    def file_request_id(self, val):
        if val is None:
            del self.file_request_id
            return
        val = self._file_request_id_validator.validate(val)
        self._file_request_id_value = val
        self._file_request_id_present = True

    @file_request_id.deleter
    def file_request_id(self):
        self._file_request_id_value = None
        self._file_request_id_present = False

    @property
    def file_request_details(self):
        """
        File request details. Might be missing due to historical data gap.

        :rtype: FileRequestDetails
        """
        if self._file_request_details_present:
            return self._file_request_details_value
        else:
            return None

    @file_request_details.setter
    def file_request_details(self, val):
        if val is None:
            del self.file_request_details
            return
        self._file_request_details_validator.validate_type_only(val)
        self._file_request_details_value = val
        self._file_request_details_present = True

    @file_request_details.deleter
    def file_request_details(self):
        self._file_request_details_value = None
        self._file_request_details_present = False

    @property
    def submitted_file_names(self):
        """
        Submitted file names.

        :rtype: list of [str]
        """
        if self._submitted_file_names_present:
            return self._submitted_file_names_value
        else:
            raise AttributeError("missing required field 'submitted_file_names'")

    @submitted_file_names.setter
    def submitted_file_names(self, val):
        val = self._submitted_file_names_validator.validate(val)
        self._submitted_file_names_value = val
        self._submitted_file_names_present = True

    @submitted_file_names.deleter
    def submitted_file_names(self):
        self._submitted_file_names_value = None
        self._submitted_file_names_present = False

    @property
    def submitter_name(self):
        """
        The name as provided by the submitter. Might be missing due to
        historical data gap.

        :rtype: str
        """
        if self._submitter_name_present:
            return self._submitter_name_value
        else:
            return None

    @submitter_name.setter
    def submitter_name(self, val):
        if val is None:
            del self.submitter_name
            return
        val = self._submitter_name_validator.validate(val)
        self._submitter_name_value = val
        self._submitter_name_present = True

    @submitter_name.deleter
    def submitter_name(self):
        self._submitter_name_value = None
        self._submitter_name_present = False

    @property
    def submitter_email(self):
        """
        The email as provided by the submitter. Might be missing due to
        historical data gap.

        :rtype: str
        """
        if self._submitter_email_present:
            return self._submitter_email_value
        else:
            return None

    @submitter_email.setter
    def submitter_email(self, val):
        if val is None:
            del self.submitter_email
            return
        val = self._submitter_email_validator.validate(val)
        self._submitter_email_value = val
        self._submitter_email_present = True

    @submitter_email.deleter
    def submitter_email(self):
        self._submitter_email_value = None
        self._submitter_email_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestReceiveFileDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestReceiveFileDetails(submitted_file_names={!r}, file_request_id={!r}, file_request_details={!r}, submitter_name={!r}, submitter_email={!r})'.format(
            self._submitted_file_names_value,
            self._file_request_id_value,
            self._file_request_details_value,
            self._submitter_name_value,
            self._submitter_email_value,
        )

FileRequestReceiveFileDetails_validator = bv.Struct(FileRequestReceiveFileDetails)

class FileRequestReceiveFileType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestReceiveFileType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestReceiveFileType(description={!r})'.format(
            self._description_value,
        )

FileRequestReceiveFileType_validator = bv.Struct(FileRequestReceiveFileType)

class FileRequestsChangePolicyDetails(bb.Struct):
    """
    Enabled/disabled file requests.

    :ivar new_value: New file requests policy.
    :ivar previous_value: Previous file requests policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New file requests policy.

        :rtype: FileRequestsPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous file requests policy. Might be missing due to historical data
        gap.

        :rtype: FileRequestsPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestsChangePolicyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestsChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

FileRequestsChangePolicyDetails_validator = bv.Struct(FileRequestsChangePolicyDetails)

class FileRequestsChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestsChangePolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestsChangePolicyType(description={!r})'.format(
            self._description_value,
        )

FileRequestsChangePolicyType_validator = bv.Struct(FileRequestsChangePolicyType)

class FileRequestsEmailsEnabledDetails(bb.Struct):
    """
    Enabled file request emails for everyone.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestsEmailsEnabledDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestsEmailsEnabledDetails()'

FileRequestsEmailsEnabledDetails_validator = bv.Struct(FileRequestsEmailsEnabledDetails)

class FileRequestsEmailsEnabledType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestsEmailsEnabledType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestsEmailsEnabledType(description={!r})'.format(
            self._description_value,
        )

FileRequestsEmailsEnabledType_validator = bv.Struct(FileRequestsEmailsEnabledType)

class FileRequestsEmailsRestrictedToTeamOnlyDetails(bb.Struct):
    """
    Enabled file request emails for team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestsEmailsRestrictedToTeamOnlyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestsEmailsRestrictedToTeamOnlyDetails()'

FileRequestsEmailsRestrictedToTeamOnlyDetails_validator = bv.Struct(FileRequestsEmailsRestrictedToTeamOnlyDetails)

class FileRequestsEmailsRestrictedToTeamOnlyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestsEmailsRestrictedToTeamOnlyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestsEmailsRestrictedToTeamOnlyType(description={!r})'.format(
            self._description_value,
        )

FileRequestsEmailsRestrictedToTeamOnlyType_validator = bv.Struct(FileRequestsEmailsRestrictedToTeamOnlyType)

class FileRequestsPolicy(bb.Union):
    """
    File requests policy

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRequestsPolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRequestsPolicy(%r, %r)' % (self._tag, self._value)

FileRequestsPolicy_validator = bv.Union(FileRequestsPolicy)

class FileResolveCommentDetails(bb.Struct):
    """
    Resolved file comment.

    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 comment_text=None):
        self._comment_text_value = None
        self._comment_text_present = False
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileResolveCommentDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileResolveCommentDetails(comment_text={!r})'.format(
            self._comment_text_value,
        )

FileResolveCommentDetails_validator = bv.Struct(FileResolveCommentDetails)

class FileResolveCommentType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileResolveCommentType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileResolveCommentType(description={!r})'.format(
            self._description_value,
        )

FileResolveCommentType_validator = bv.Struct(FileResolveCommentType)

class FileRestoreDetails(bb.Struct):
    """
    Restored deleted files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRestoreDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRestoreDetails()'

FileRestoreDetails_validator = bv.Struct(FileRestoreDetails)

class FileRestoreType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRestoreType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRestoreType(description={!r})'.format(
            self._description_value,
        )

FileRestoreType_validator = bv.Struct(FileRestoreType)

class FileRevertDetails(bb.Struct):
    """
    Reverted files to previous version.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRevertDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRevertDetails()'

FileRevertDetails_validator = bv.Struct(FileRevertDetails)

class FileRevertType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRevertType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRevertType(description={!r})'.format(
            self._description_value,
        )

FileRevertType_validator = bv.Struct(FileRevertType)

class FileRollbackChangesDetails(bb.Struct):
    """
    Rolled back file actions.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRollbackChangesDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRollbackChangesDetails()'

FileRollbackChangesDetails_validator = bv.Struct(FileRollbackChangesDetails)

class FileRollbackChangesType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileRollbackChangesType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileRollbackChangesType(description={!r})'.format(
            self._description_value,
        )

FileRollbackChangesType_validator = bv.Struct(FileRollbackChangesType)

class FileSaveCopyReferenceDetails(bb.Struct):
    """
    Saved file/folder using copy reference.

    :ivar relocate_action_details: Relocate action details.
    """

    __slots__ = [
        '_relocate_action_details_value',
        '_relocate_action_details_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 relocate_action_details=None):
        self._relocate_action_details_value = None
        self._relocate_action_details_present = False
        if relocate_action_details is not None:
            self.relocate_action_details = relocate_action_details

    @property
    def relocate_action_details(self):
        """
        Relocate action details.

        :rtype: list of [RelocateAssetReferencesLogInfo]
        """
        if self._relocate_action_details_present:
            return self._relocate_action_details_value
        else:
            raise AttributeError("missing required field 'relocate_action_details'")

    @relocate_action_details.setter
    def relocate_action_details(self, val):
        val = self._relocate_action_details_validator.validate(val)
        self._relocate_action_details_value = val
        self._relocate_action_details_present = True

    @relocate_action_details.deleter
    def relocate_action_details(self):
        self._relocate_action_details_value = None
        self._relocate_action_details_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileSaveCopyReferenceDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileSaveCopyReferenceDetails(relocate_action_details={!r})'.format(
            self._relocate_action_details_value,
        )

FileSaveCopyReferenceDetails_validator = bv.Struct(FileSaveCopyReferenceDetails)

class FileSaveCopyReferenceType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileSaveCopyReferenceType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileSaveCopyReferenceType(description={!r})'.format(
            self._description_value,
        )

FileSaveCopyReferenceType_validator = bv.Struct(FileSaveCopyReferenceType)

class FileUnlikeCommentDetails(bb.Struct):
    """
    Unliked file comment.

    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 comment_text=None):
        self._comment_text_value = None
        self._comment_text_present = False
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileUnlikeCommentDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileUnlikeCommentDetails(comment_text={!r})'.format(
            self._comment_text_value,
        )

FileUnlikeCommentDetails_validator = bv.Struct(FileUnlikeCommentDetails)

class FileUnlikeCommentType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileUnlikeCommentType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileUnlikeCommentType(description={!r})'.format(
            self._description_value,
        )

FileUnlikeCommentType_validator = bv.Struct(FileUnlikeCommentType)

class FileUnresolveCommentDetails(bb.Struct):
    """
    Unresolved file comment.

    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 comment_text=None):
        self._comment_text_value = None
        self._comment_text_present = False
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileUnresolveCommentDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileUnresolveCommentDetails(comment_text={!r})'.format(
            self._comment_text_value,
        )

FileUnresolveCommentDetails_validator = bv.Struct(FileUnresolveCommentDetails)

class FileUnresolveCommentType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FileUnresolveCommentType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FileUnresolveCommentType(description={!r})'.format(
            self._description_value,
        )

FileUnresolveCommentType_validator = bv.Struct(FileUnresolveCommentType)

class FolderLogInfo(FileOrFolderLogInfo):
    """
    Folder's logged information.
    """

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 display_name=None,
                 file_id=None):
        super(FolderLogInfo, self).__init__(path,
                                            display_name,
                                            file_id)

    def _process_custom_annotations(self, annotation_type, processor):
        super(FolderLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FolderLogInfo(path={!r}, display_name={!r}, file_id={!r})'.format(
            self._path_value,
            self._display_name_value,
            self._file_id_value,
        )

FolderLogInfo_validator = bv.Struct(FolderLogInfo)

class GeoLocationLogInfo(bb.Struct):
    """
    Geographic location details.

    :ivar city: City name.
    :ivar region: Region name.
    :ivar country: Country code.
    :ivar ip_address: IP address.
    """

    __slots__ = [
        '_city_value',
        '_city_present',
        '_region_value',
        '_region_present',
        '_country_value',
        '_country_present',
        '_ip_address_value',
        '_ip_address_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 ip_address=None,
                 city=None,
                 region=None,
                 country=None):
        self._city_value = None
        self._city_present = False
        self._region_value = None
        self._region_present = False
        self._country_value = None
        self._country_present = False
        self._ip_address_value = None
        self._ip_address_present = False
        if city is not None:
            self.city = city
        if region is not None:
            self.region = region
        if country is not None:
            self.country = country
        if ip_address is not None:
            self.ip_address = ip_address

    @property
    def city(self):
        """
        City name.

        :rtype: str
        """
        if self._city_present:
            return self._city_value
        else:
            return None

    @city.setter
    def city(self, val):
        if val is None:
            del self.city
            return
        val = self._city_validator.validate(val)
        self._city_value = val
        self._city_present = True

    @city.deleter
    def city(self):
        self._city_value = None
        self._city_present = False

    @property
    def region(self):
        """
        Region name.

        :rtype: str
        """
        if self._region_present:
            return self._region_value
        else:
            return None

    @region.setter
    def region(self, val):
        if val is None:
            del self.region
            return
        val = self._region_validator.validate(val)
        self._region_value = val
        self._region_present = True

    @region.deleter
    def region(self):
        self._region_value = None
        self._region_present = False

    @property
    def country(self):
        """
        Country code.

        :rtype: str
        """
        if self._country_present:
            return self._country_value
        else:
            return None

    @country.setter
    def country(self, val):
        if val is None:
            del self.country
            return
        val = self._country_validator.validate(val)
        self._country_value = val
        self._country_present = True

    @country.deleter
    def country(self):
        self._country_value = None
        self._country_present = False

    @property
    def ip_address(self):
        """
        IP address.

        :rtype: str
        """
        if self._ip_address_present:
            return self._ip_address_value
        else:
            raise AttributeError("missing required field 'ip_address'")

    @ip_address.setter
    def ip_address(self, val):
        val = self._ip_address_validator.validate(val)
        self._ip_address_value = val
        self._ip_address_present = True

    @ip_address.deleter
    def ip_address(self):
        self._ip_address_value = None
        self._ip_address_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GeoLocationLogInfo, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GeoLocationLogInfo(ip_address={!r}, city={!r}, region={!r}, country={!r})'.format(
            self._ip_address_value,
            self._city_value,
            self._region_value,
            self._country_value,
        )

GeoLocationLogInfo_validator = bv.Struct(GeoLocationLogInfo)

class GetTeamEventsArg(bb.Struct):
    """
    :ivar limit: The maximal number of results to return per call. Note that
        some calls may not return ``limit`` number of events, and may even
        return no events, even with `has_more` set to true. In this case,
        callers should fetch again using
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue`.
    :ivar account_id: Filter the events by account ID. Return ony events with
        this account_id as either Actor, Context, or Participants.
    :ivar time: Filter by time range.
    :ivar category: Filter the returned events to a single category.
    """

    __slots__ = [
        '_limit_value',
        '_limit_present',
        '_account_id_value',
        '_account_id_present',
        '_time_value',
        '_time_present',
        '_category_value',
        '_category_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 limit=None,
                 account_id=None,
                 time=None,
                 category=None):
        self._limit_value = None
        self._limit_present = False
        self._account_id_value = None
        self._account_id_present = False
        self._time_value = None
        self._time_present = False
        self._category_value = None
        self._category_present = False
        if limit is not None:
            self.limit = limit
        if account_id is not None:
            self.account_id = account_id
        if time is not None:
            self.time = time
        if category is not None:
            self.category = category

    @property
    def limit(self):
        """
        The maximal number of results to return per call. Note that some calls
        may not return ``limit`` number of events, and may even return no
        events, even with `has_more` set to true. In this case, callers should
        fetch again using
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue`.

        :rtype: long
        """
        if self._limit_present:
            return self._limit_value
        else:
            return 1000

    @limit.setter
    def limit(self, val):
        val = self._limit_validator.validate(val)
        self._limit_value = val
        self._limit_present = True

    @limit.deleter
    def limit(self):
        self._limit_value = None
        self._limit_present = False

    @property
    def account_id(self):
        """
        Filter the events by account ID. Return ony events with this account_id
        as either Actor, Context, or Participants.

        :rtype: str
        """
        if self._account_id_present:
            return self._account_id_value
        else:
            return None

    @account_id.setter
    def account_id(self, val):
        if val is None:
            del self.account_id
            return
        val = self._account_id_validator.validate(val)
        self._account_id_value = val
        self._account_id_present = True

    @account_id.deleter
    def account_id(self):
        self._account_id_value = None
        self._account_id_present = False

    @property
    def time(self):
        """
        Filter by time range.

        :rtype: team_common.TimeRange
        """
        if self._time_present:
            return self._time_value
        else:
            return None

    @time.setter
    def time(self, val):
        if val is None:
            del self.time
            return
        self._time_validator.validate_type_only(val)
        self._time_value = val
        self._time_present = True

    @time.deleter
    def time(self):
        self._time_value = None
        self._time_present = False

    @property
    def category(self):
        """
        Filter the returned events to a single category.

        :rtype: EventCategory
        """
        if self._category_present:
            return self._category_value
        else:
            return None

    @category.setter
    def category(self, val):
        if val is None:
            del self.category
            return
        self._category_validator.validate_type_only(val)
        self._category_value = val
        self._category_present = True

    @category.deleter
    def category(self):
        self._category_value = None
        self._category_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GetTeamEventsArg, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GetTeamEventsArg(limit={!r}, account_id={!r}, time={!r}, category={!r})'.format(
            self._limit_value,
            self._account_id_value,
            self._time_value,
            self._category_value,
        )

GetTeamEventsArg_validator = bv.Struct(GetTeamEventsArg)

class GetTeamEventsContinueArg(bb.Struct):
    """
    :ivar cursor: Indicates from what point to get the next set of events.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        Indicates from what point to get the next set of events.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GetTeamEventsContinueArg, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GetTeamEventsContinueArg(cursor={!r})'.format(
            self._cursor_value,
        )

GetTeamEventsContinueArg_validator = bv.Struct(GetTeamEventsContinueArg)

class GetTeamEventsContinueError(bb.Union):
    """
    Errors that can be raised when calling
    :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue`.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar bad_cursor: Bad cursor.
    :ivar datetime.datetime reset: Cursors are intended to be used quickly.
        Individual cursor values are normally valid for days, but in rare cases
        may be reset sooner. Cursor reset errors should be handled by fetching a
        new cursor from :route:`get_events`. The associated value is the
        approximate timestamp of the most recent event returned by the cursor.
        This should be used as a resumption point when calling
        :route:`get_events` to obtain a new cursor.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    bad_cursor = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def reset(cls, val):
        """
        Create an instance of this class set to the ``reset`` tag with value
        ``val``.

        :param datetime.datetime val:
        :rtype: GetTeamEventsContinueError
        """
        return cls('reset', val)

    def is_bad_cursor(self):
        """
        Check if the union tag is ``bad_cursor``.

        :rtype: bool
        """
        return self._tag == 'bad_cursor'

    def is_reset(self):
        """
        Check if the union tag is ``reset``.

        :rtype: bool
        """
        return self._tag == 'reset'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_reset(self):
        """
        Cursors are intended to be used quickly. Individual cursor values are
        normally valid for days, but in rare cases may be reset sooner. Cursor
        reset errors should be handled by fetching a new cursor from
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events`. The associated
        value is the approximate timestamp of the most recent event returned by
        the cursor. This should be used as a resumption point when calling
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events` to obtain a new
        cursor.

        Only call this if :meth:`is_reset` is true.

        :rtype: datetime.datetime
        """
        if not self.is_reset():
            raise AttributeError("tag 'reset' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, processor):
        super(GetTeamEventsContinueError, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GetTeamEventsContinueError(%r, %r)' % (self._tag, self._value)

GetTeamEventsContinueError_validator = bv.Union(GetTeamEventsContinueError)

class GetTeamEventsError(bb.Union):
    """
    Errors that can be raised when calling
    :meth:`dropbox.dropbox.Dropbox.team_log_get_events`.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar account_id_not_found: No user found matching the provided account_id.
    :ivar invalid_time_range: Invalid time range.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    account_id_not_found = None
    # Attribute is overwritten below the class definition
    invalid_time_range = None
    # Attribute is overwritten below the class definition
    other = None

    def is_account_id_not_found(self):
        """
        Check if the union tag is ``account_id_not_found``.

        :rtype: bool
        """
        return self._tag == 'account_id_not_found'

    def is_invalid_time_range(self):
        """
        Check if the union tag is ``invalid_time_range``.

        :rtype: bool
        """
        return self._tag == 'invalid_time_range'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(GetTeamEventsError, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GetTeamEventsError(%r, %r)' % (self._tag, self._value)

GetTeamEventsError_validator = bv.Union(GetTeamEventsError)

class GetTeamEventsResult(bb.Struct):
    """
    :ivar events: List of events. Note that events are not guaranteed to be
        sorted by their timestamp value.
    :ivar cursor: Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue` to obtain
        additional events. The value of ``cursor`` may change for each response
        from :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue`,
        regardless of the value of ``has_more``; older cursor strings may
        expire. Thus, callers should ensure that they update their cursor based
        on the latest value of ``cursor`` after each call, and poll regularly if
        they wish to poll for new events. Callers should handle reset exceptions
        for expired cursors.
    :ivar has_more: Is true if there may be additional events that have not been
        returned yet. An additional call to
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue` can
        retrieve them. Note that ``has_more`` may be ``True``, even if
        ``events`` is empty.
    """

    __slots__ = [
        '_events_value',
        '_events_present',
        '_cursor_value',
        '_cursor_present',
        '_has_more_value',
        '_has_more_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 events=None,
                 cursor=None,
                 has_more=None):
        self._events_value = None
        self._events_present = False
        self._cursor_value = None
        self._cursor_present = False
        self._has_more_value = None
        self._has_more_present = False
        if events is not None:
            self.events = events
        if cursor is not None:
            self.cursor = cursor
        if has_more is not None:
            self.has_more = has_more

    @property
    def events(self):
        """
        List of events. Note that events are not guaranteed to be sorted by
        their timestamp value.

        :rtype: list of [TeamEvent]
        """
        if self._events_present:
            return self._events_value
        else:
            raise AttributeError("missing required field 'events'")

    @events.setter
    def events(self, val):
        val = self._events_validator.validate(val)
        self._events_value = val
        self._events_present = True

    @events.deleter
    def events(self):
        self._events_value = None
        self._events_present = False

    @property
    def cursor(self):
        """
        Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue` to obtain
        additional events. The value of ``cursor`` may change for each response
        from :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue`,
        regardless of the value of ``has_more``; older cursor strings may
        expire. Thus, callers should ensure that they update their cursor based
        on the latest value of ``cursor`` after each call, and poll regularly if
        they wish to poll for new events. Callers should handle reset exceptions
        for expired cursors.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def has_more(self):
        """
        Is true if there may be additional events that have not been returned
        yet. An additional call to
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue` can
        retrieve them. Note that ``has_more`` may be ``True``, even if
        ``events`` is empty.

        :rtype: bool
        """
        if self._has_more_present:
            return self._has_more_value
        else:
            raise AttributeError("missing required field 'has_more'")

    @has_more.setter
    def has_more(self, val):
        val = self._has_more_validator.validate(val)
        self._has_more_value = val
        self._has_more_present = True

    @has_more.deleter
    def has_more(self):
        self._has_more_value = None
        self._has_more_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GetTeamEventsResult, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GetTeamEventsResult(events={!r}, cursor={!r}, has_more={!r})'.format(
            self._events_value,
            self._cursor_value,
            self._has_more_value,
        )

GetTeamEventsResult_validator = bv.Struct(GetTeamEventsResult)

class GoogleSsoChangePolicyDetails(bb.Struct):
    """
    Enabled/disabled Google single sign-on for team.

    :ivar new_value: New Google single sign-on policy.
    :ivar previous_value: Previous Google single sign-on policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New Google single sign-on policy.

        :rtype: GoogleSsoPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous Google single sign-on policy. Might be missing due to
        historical data gap.

        :rtype: GoogleSsoPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GoogleSsoChangePolicyDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GoogleSsoChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

GoogleSsoChangePolicyDetails_validator = bv.Struct(GoogleSsoChangePolicyDetails)

class GoogleSsoChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GoogleSsoChangePolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GoogleSsoChangePolicyType(description={!r})'.format(
            self._description_value,
        )

GoogleSsoChangePolicyType_validator = bv.Struct(GoogleSsoChangePolicyType)

class GoogleSsoPolicy(bb.Union):
    """
    Google SSO policy

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(GoogleSsoPolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GoogleSsoPolicy(%r, %r)' % (self._tag, self._value)

GoogleSsoPolicy_validator = bv.Union(GoogleSsoPolicy)

class GroupAddExternalIdDetails(bb.Struct):
    """
    Added external ID for group.

    :ivar new_value: Current external id.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None):
        self._new_value_value = None
        self._new_value_present = False
        if new_value is not None:
            self.new_value = new_value

    @property
    def new_value(self):
        """
        Current external id.

        :rtype: str
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        val = self._new_value_validator.validate(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupAddExternalIdDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupAddExternalIdDetails(new_value={!r})'.format(
            self._new_value_value,
        )

GroupAddExternalIdDetails_validator = bv.Struct(GroupAddExternalIdDetails)

class GroupAddExternalIdType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupAddExternalIdType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupAddExternalIdType(description={!r})'.format(
            self._description_value,
        )

GroupAddExternalIdType_validator = bv.Struct(GroupAddExternalIdType)

class GroupAddMemberDetails(bb.Struct):
    """
    Added team members to group.

    :ivar is_group_owner: Is group owner.
    """

    __slots__ = [
        '_is_group_owner_value',
        '_is_group_owner_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 is_group_owner=None):
        self._is_group_owner_value = None
        self._is_group_owner_present = False
        if is_group_owner is not None:
            self.is_group_owner = is_group_owner

    @property
    def is_group_owner(self):
        """
        Is group owner.

        :rtype: bool
        """
        if self._is_group_owner_present:
            return self._is_group_owner_value
        else:
            raise AttributeError("missing required field 'is_group_owner'")

    @is_group_owner.setter
    def is_group_owner(self, val):
        val = self._is_group_owner_validator.validate(val)
        self._is_group_owner_value = val
        self._is_group_owner_present = True

    @is_group_owner.deleter
    def is_group_owner(self):
        self._is_group_owner_value = None
        self._is_group_owner_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupAddMemberDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupAddMemberDetails(is_group_owner={!r})'.format(
            self._is_group_owner_value,
        )

GroupAddMemberDetails_validator = bv.Struct(GroupAddMemberDetails)

class GroupAddMemberType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupAddMemberType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupAddMemberType(description={!r})'.format(
            self._description_value,
        )

GroupAddMemberType_validator = bv.Struct(GroupAddMemberType)

class GroupChangeExternalIdDetails(bb.Struct):
    """
    Changed external ID for group.

    :ivar new_value: Current external id.
    :ivar previous_value: Old external id.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        Current external id.

        :rtype: str
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        val = self._new_value_validator.validate(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Old external id.

        :rtype: str
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            raise AttributeError("missing required field 'previous_value'")

    @previous_value.setter
    def previous_value(self, val):
        val = self._previous_value_validator.validate(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupChangeExternalIdDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupChangeExternalIdDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

GroupChangeExternalIdDetails_validator = bv.Struct(GroupChangeExternalIdDetails)

class GroupChangeExternalIdType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupChangeExternalIdType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupChangeExternalIdType(description={!r})'.format(
            self._description_value,
        )

GroupChangeExternalIdType_validator = bv.Struct(GroupChangeExternalIdType)

class GroupChangeManagementTypeDetails(bb.Struct):
    """
    Changed group management type.

    :ivar new_value: New group management type.
    :ivar previous_value: Previous group management type. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New group management type.

        :rtype: team_common.GroupManagementType
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous group management type. Might be missing due to historical data
        gap.

        :rtype: team_common.GroupManagementType
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupChangeManagementTypeDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupChangeManagementTypeDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

GroupChangeManagementTypeDetails_validator = bv.Struct(GroupChangeManagementTypeDetails)

class GroupChangeManagementTypeType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupChangeManagementTypeType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupChangeManagementTypeType(description={!r})'.format(
            self._description_value,
        )

GroupChangeManagementTypeType_validator = bv.Struct(GroupChangeManagementTypeType)

class GroupChangeMemberRoleDetails(bb.Struct):
    """
    Changed manager permissions of group member.

    :ivar is_group_owner: Is group owner.
    """

    __slots__ = [
        '_is_group_owner_value',
        '_is_group_owner_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 is_group_owner=None):
        self._is_group_owner_value = None
        self._is_group_owner_present = False
        if is_group_owner is not None:
            self.is_group_owner = is_group_owner

    @property
    def is_group_owner(self):
        """
        Is group owner.

        :rtype: bool
        """
        if self._is_group_owner_present:
            return self._is_group_owner_value
        else:
            raise AttributeError("missing required field 'is_group_owner'")

    @is_group_owner.setter
    def is_group_owner(self, val):
        val = self._is_group_owner_validator.validate(val)
        self._is_group_owner_value = val
        self._is_group_owner_present = True

    @is_group_owner.deleter
    def is_group_owner(self):
        self._is_group_owner_value = None
        self._is_group_owner_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupChangeMemberRoleDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupChangeMemberRoleDetails(is_group_owner={!r})'.format(
            self._is_group_owner_value,
        )

GroupChangeMemberRoleDetails_validator = bv.Struct(GroupChangeMemberRoleDetails)

class GroupChangeMemberRoleType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupChangeMemberRoleType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupChangeMemberRoleType(description={!r})'.format(
            self._description_value,
        )

GroupChangeMemberRoleType_validator = bv.Struct(GroupChangeMemberRoleType)

class GroupCreateDetails(bb.Struct):
    """
    Created group.

    :ivar is_company_managed: Is company managed group. Might be missing due to
        historical data gap.
    :ivar join_policy: Group join policy.
    """

    __slots__ = [
        '_is_company_managed_value',
        '_is_company_managed_present',
        '_join_policy_value',
        '_join_policy_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 is_company_managed=None,
                 join_policy=None):
        self._is_company_managed_value = None
        self._is_company_managed_present = False
        self._join_policy_value = None
        self._join_policy_present = False
        if is_company_managed is not None:
            self.is_company_managed = is_company_managed
        if join_policy is not None:
            self.join_policy = join_policy

    @property
    def is_company_managed(self):
        """
        Is company managed group. Might be missing due to historical data gap.

        :rtype: bool
        """
        if self._is_company_managed_present:
            return self._is_company_managed_value
        else:
            return None

    @is_company_managed.setter
    def is_company_managed(self, val):
        if val is None:
            del self.is_company_managed
            return
        val = self._is_company_managed_validator.validate(val)
        self._is_company_managed_value = val
        self._is_company_managed_present = True

    @is_company_managed.deleter
    def is_company_managed(self):
        self._is_company_managed_value = None
        self._is_company_managed_present = False

    @property
    def join_policy(self):
        """
        Group join policy.

        :rtype: GroupJoinPolicy
        """
        if self._join_policy_present:
            return self._join_policy_value
        else:
            return None

    @join_policy.setter
    def join_policy(self, val):
        if val is None:
            del self.join_policy
            return
        self._join_policy_validator.validate_type_only(val)
        self._join_policy_value = val
        self._join_policy_present = True

    @join_policy.deleter
    def join_policy(self):
        self._join_policy_value = None
        self._join_policy_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupCreateDetails, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupCreateDetails(is_company_managed={!r}, join_policy={!r})'.format(
            self._is_company_managed_value,
            self._join_policy_value,
        )

GroupCreateDetails_validator = bv.Struct(GroupCreateDetails)

class GroupCreateType(bb.Struct):

    __slots__ = [
        '_description_value',
        '_description_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = None
        self._description_present = False
        if description is not None:
            self.description = description

    @property
    def description(self):
        """
        :rtype: str
        """
        if self._description_present:
            return self._description_value
        else:
            raise AttributeError("missing required field 'description'")

    @description.setter
    def description(self, val):
        val = self._description_validator.validate(val)
        self._description_value = val
        self._description_present = True

    @description.deleter
    def description(self):
        self._description_value = None
        self._description_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(GroupCreateType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'GroupCreateType(description={!r})'.format(
            self._description_value,
        )