/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.ArrayDump;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;

class NearestGCRoot {
    private static final int BUFFER_SIZE = 8192;
    private static final String[] REF_CLASSES = new String[]{"java.lang.ref.WeakReference", "java.lang.ref.SoftReference", "java.lang.ref.FinalReference", "java.lang.ref.PhantomReference"};
    private static final String JAVA_LANG_REF_REFERENCE = "java.lang.ref.Reference";
    private static final String REFERENT_FILED_NAME = "referent";
    private static final String SVM_REFFERENCE = "com.oracle.svm.core.heap.heapImpl.DiscoverableReference";
    private static final String SVM_REFFERENCE_1 = "com.oracle.svm.core.heap.DiscoverableReference";
    private static final String SVM_REFERENT_FILED_NAME = "rawReferent";
    private Field referentFiled;
    private HprofHeap heap;
    private LongBuffer readBuffer;
    private LongBuffer writeBuffer;
    private LongBuffer leaves;
    private LongBuffer multipleParents;
    private Set referenceClasses;
    private boolean gcRootsComputed;
    private long allInstances;
    private long processedInstances;

    NearestGCRoot(HprofHeap hprofHeap) {
        this.heap = hprofHeap;
    }

    Instance getNearestGCRootPointer(Instance instance) {
        if (this.heap.getGCRoot(instance) != null) {
            return instance;
        }
        this.computeGCRoots();
        long l = this.heap.idToOffsetMap.get(instance.getInstanceId()).getNearestGCRootPointer();
        return this.heap.getInstanceByID(l);
    }

    private boolean isSpecialReference(FieldValue fieldValue, Instance instance) {
        Field field = fieldValue.getField();
        return field.equals(this.referentFiled) && this.referenceClasses.contains(instance.getJavaClass());
    }

    private synchronized void computeGCRoots() {
        if (this.gcRootsComputed) {
            return;
        }
        HeapProgress.progressStart();
        if (!this.initHotSpotReference() && !this.initSVMReference()) {
            throw new IllegalArgumentException("reference field not found");
        }
        this.heap.computeReferences();
        this.allInstances = this.heap.getSummary().getTotalLiveInstances();
        HashSet hashSet = new HashSet(this.heap.getAllClasses().size() * 4 / 3);
        try {
            this.createBuffers();
            this.fillZeroLevel();
            do {
                this.switchBuffers();
                this.computeOneLevel(hashSet);
            } while (this.hasMoreLevels());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.deleteBuffers();
        this.heap.idToOffsetMap.flush();
        this.gcRootsComputed = true;
        this.heap.writeToFile();
        HeapProgress.progressFinish();
    }

    private boolean initHotSpotReference() {
        this.referentFiled = this.computeReferentFiled(JAVA_LANG_REF_REFERENCE, REFERENT_FILED_NAME);
        if (this.referentFiled != null) {
            this.referenceClasses = new HashSet();
            for (int i = 0; i < REF_CLASSES.length; ++i) {
                JavaClass javaClass = this.heap.getJavaClassByName(REF_CLASSES[i]);
                if (javaClass == null) continue;
                this.referenceClasses.add(javaClass);
                this.referenceClasses.addAll(javaClass.getSubClasses());
            }
            return this.referenceClasses.size() >= REF_CLASSES.length;
        }
        return false;
    }

    private boolean initSVMReference() {
        this.referentFiled = this.computeReferentFiled(SVM_REFFERENCE, SVM_REFERENT_FILED_NAME);
        if (this.referentFiled == null) {
            this.referentFiled = this.computeReferentFiled(SVM_REFFERENCE_1, SVM_REFERENT_FILED_NAME);
        }
        if (this.referentFiled != null) {
            JavaClass javaClass = this.referentFiled.getDeclaringClass();
            this.referenceClasses = new HashSet();
            this.referenceClasses.add(javaClass);
            this.referenceClasses.addAll(javaClass.getSubClasses());
            return !this.referenceClasses.isEmpty();
        }
        return false;
    }

    private void computeOneLevel(Set set) throws IOException {
        int n = this.heap.dumpBuffer.getIDSize();
        while (true) {
            List list;
            HprofObject hprofObject;
            long l = this.readLong();
            boolean bl = false;
            if (l == 0L) break;
            HeapProgress.progress(this.processedInstances++, this.allInstances);
            Instance instance = this.heap.getInstanceByOffset(new long[]{l});
            if (instance instanceof ObjectArrayInstance) {
                hprofObject = (ObjectArrayDump)instance;
                int n2 = ((ArrayDump)hprofObject).getLength();
                long l2 = ((ObjectArrayDump)hprofObject).getOffset();
                long l3 = instance.getInstanceId();
                for (int i = 0; i < n2; ++i) {
                    long l4 = this.heap.dumpBuffer.getID(l2 + (long)(i * n));
                    if (!this.writeConnection(l3, l4)) continue;
                    bl = true;
                }
                if (bl) continue;
                this.writeLeaf(l3, instance.getSize());
                continue;
            }
            if (instance instanceof PrimitiveArrayInstance) {
                this.writeLeaf(instance.getInstanceId(), instance.getSize());
                continue;
            }
            if (instance instanceof ClassDumpInstance) {
                hprofObject = ((ClassDumpInstance)instance).classDump;
                list = ((ClassDump)hprofObject).getStaticFieldValues();
            } else if (instance instanceof InstanceDump) {
                list = instance.getFieldValues();
            } else {
                if (instance == null) {
                    System.err.println("HeapWalker Warning - null instance for " + this.heap.dumpBuffer.getID(l + 1L));
                    continue;
                }
                throw new IllegalArgumentException("Illegal type " + instance.getClass());
            }
            long l5 = instance.getInstanceId();
            for (FieldValue fieldValue : list) {
                long l6;
                if (!(fieldValue instanceof ObjectFieldValue) || this.isSpecialReference(fieldValue, instance) || !this.writeConnection(l5, l6 = fieldValue instanceof HprofFieldObjectValue ? ((HprofFieldObjectValue)fieldValue).getInstanceID() : ((HprofInstanceObjectValue)fieldValue).getInstanceId())) continue;
                bl = true;
            }
            if (this.writeClassConnection(set, l5, instance.getJavaClass())) {
                bl = true;
            }
            if (bl) continue;
            this.writeLeaf(l5, instance.getSize());
        }
    }

    private Field computeReferentFiled(String string, String string2) {
        JavaClass javaClass = this.heap.getJavaClassByName(string);
        if (javaClass != null) {
            for (Field field : javaClass.getFields()) {
                if (!field.getName().equals(string2)) continue;
                return field;
            }
        }
        return null;
    }

    private void createBuffers() {
        this.readBuffer = new LongBuffer(8192, this.heap.cacheDirectory);
        this.writeBuffer = new LongBuffer(8192, this.heap.cacheDirectory);
        this.leaves = new LongBuffer(8192, this.heap.cacheDirectory);
        this.multipleParents = new LongBuffer(8192, this.heap.cacheDirectory);
    }

    private void deleteBuffers() {
        this.readBuffer.delete();
        this.writeBuffer.delete();
    }

    private void fillZeroLevel() throws IOException {
        for (HprofGCRoot hprofGCRoot : this.heap.getGCRoots()) {
            long l = hprofGCRoot.getInstanceId();
            LongMap.Entry entry = this.heap.idToOffsetMap.get(l);
            if (entry == null) continue;
            this.writeLong(entry.getOffset());
        }
    }

    private boolean hasMoreLevels() {
        return this.writeBuffer.hasData();
    }

    private long readLong() throws IOException {
        return this.readBuffer.readLong();
    }

    private void switchBuffers() throws IOException {
        LongBuffer longBuffer = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = longBuffer;
        this.readBuffer.startReading();
        this.writeBuffer.reset();
    }

    private boolean writeClassConnection(Set set, long l, JavaClass javaClass) throws IOException {
        if (!set.contains(javaClass)) {
            long l2 = javaClass.getJavaClassId();
            set.add(javaClass);
            if (this.writeConnection(l, l2, true)) {
                return true;
            }
        }
        return false;
    }

    private boolean writeConnection(long l, long l2) throws IOException {
        return this.writeConnection(l, l2, false);
    }

    private boolean writeConnection(long l, long l2, boolean bl) throws IOException {
        if (l2 != 0L) {
            LongMap.Entry entry = this.heap.idToOffsetMap.get(l2);
            if (entry != null && entry.getNearestGCRootPointer() == 0L && this.heap.gcRoots.getGCRoot(l2) == null) {
                this.writeLong(entry.getOffset());
                if (bl && !this.checkReferences(l2, l)) {
                    entry.addReference(l);
                }
                entry.setNearestGCRootPointer(l);
                if (!entry.hasOnlyOneReference()) {
                    this.multipleParents.writeLong(l2);
                }
                return true;
            }
            return !bl && entry != null;
        }
        return false;
    }

    private boolean checkReferences(long l, long l2) {
        Instance instance = this.heap.getInstanceByID(l2);
        for (Object e : instance.getFieldValues()) {
            HprofInstanceObjectValue hprofInstanceObjectValue;
            if (!(e instanceof HprofInstanceObjectValue) || (hprofInstanceObjectValue = (HprofInstanceObjectValue)e).getInstanceId() != l) continue;
            return true;
        }
        return false;
    }

    private void writeLong(long l) throws IOException {
        this.writeBuffer.writeLong(l);
    }

    private void writeLeaf(long l, long l2) throws IOException {
        LongMap.Entry entry;
        long l3;
        LongMap.Entry entry2 = this.heap.idToOffsetMap.get(l);
        entry2.setTreeObj();
        entry2.setRetainedSize(l2);
        if (entry2.hasOnlyOneReference() && (l3 = entry2.getNearestGCRootPointer()) != 0L && (entry = this.heap.idToOffsetMap.get(l3)).getRetainedSize() == 0L) {
            entry.setRetainedSize(-1L);
            this.leaves.writeLong(l3);
        }
    }

    LongBuffer getLeaves() {
        this.computeGCRoots();
        return this.leaves;
    }

    LongBuffer getMultipleParents() {
        this.computeGCRoots();
        return this.multipleParents;
    }

    void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(this.gcRootsComputed);
        if (this.gcRootsComputed) {
            this.leaves.writeToStream(dataOutputStream);
            this.multipleParents.writeToStream(dataOutputStream);
        }
    }

    NearestGCRoot(HprofHeap hprofHeap, DataInputStream dataInputStream) throws IOException {
        this(hprofHeap);
        this.gcRootsComputed = dataInputStream.readBoolean();
        if (this.gcRootsComputed) {
            this.leaves = new LongBuffer(dataInputStream, this.heap.cacheDirectory);
            this.multipleParents = new LongBuffer(dataInputStream, this.heap.cacheDirectory);
        }
    }
}

