/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfilerLogger {
    private static final Logger INSTANCE;
    private static final Level EXCEPTION_LEVEL;
    private static volatile Level DEFAULT_LEVEL;
    private static volatile boolean debugFlag;

    public static boolean isDebug() {
        return debugFlag;
    }

    public static void setLevel(Level level) {
        INSTANCE.setLevel(level);
        debugFlag = level.intValue() <= Level.FINEST.intValue();
    }

    public static Level getLevel() {
        return INSTANCE.getLevel();
    }

    public static void debug(String string) {
        INSTANCE.finest(string);
    }

    public static void info(String string) {
        INSTANCE.info(string);
    }

    public static void log(String string) {
        INSTANCE.log(DEFAULT_LEVEL, string);
    }

    public static void log(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        INSTANCE.log(EXCEPTION_LEVEL, stringWriter.toString());
    }

    public static void severe(String string) {
        INSTANCE.severe(string);
    }

    public static void warning(String string) {
        INSTANCE.warning(string);
    }

    static {
        Level level;
        INSTANCE = Logger.getLogger("org.netbeans.lib.profiler.infolog");
        EXCEPTION_LEVEL = Level.SEVERE;
        DEFAULT_LEVEL = Level.INFO;
        debugFlag = false;
        Level level2 = level = INSTANCE.getLevel();
        level2 = DEFAULT_LEVEL.intValue() < EXCEPTION_LEVEL.intValue() ? DEFAULT_LEVEL : EXCEPTION_LEVEL;
        if (level == null || level2.intValue() < level.intValue()) {
            INSTANCE.setLevel(level2);
        }
    }
}

