/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik.suggestions_ordering;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.language.Demo;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.SuggestionsOrdererConfig;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.SuggestionsOrdererGSoC;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrderer;

public class SuggestionsOrdererTest {
    private String originalConfigNgramsPathValue;
    private boolean originalConfigMLSuggestionsOrderingEnabledValue;

    @Before
    public void setUp() throws Exception {
        this.originalConfigNgramsPathValue = SuggestionsOrdererConfig.getNgramsPath();
        this.originalConfigMLSuggestionsOrderingEnabledValue = SuggestionsOrdererConfig.isMLSuggestionsOrderingEnabled();
    }

    @After
    public void tearDown() {
        SuggestionsOrdererConfig.setNgramsPath((String)this.originalConfigNgramsPathValue);
        SuggestionsOrdererConfig.setMLSuggestionsOrderingEnabled((boolean)this.originalConfigMLSuggestionsOrderingEnabledValue);
    }

    @Test
    public void orderSuggestionsUsingModelNonExistingRuleId() throws IOException {
        Demo language = new Demo();
        String rule_id = "rule_id";
        this.testOrderingHappened(language, rule_id);
    }

    @Test
    public void orderSuggestionsUsingModelExistingRuleId() throws IOException {
        Demo language = new Demo();
        String rule_id = "MORFOLOGIK_RULE_EN_US";
        this.testOrderingHappened(language, rule_id);
    }

    @Test
    public void orderSuggestionsWithEnabledML() throws IOException {
        SuggestionsOrdererConfig.setMLSuggestionsOrderingEnabled((boolean)true);
        this.orderSuggestionsUsingModelExistingRuleId();
    }

    @Test
    public void orderSuggestionsWithDisabledML() throws IOException {
        SuggestionsOrdererConfig.setMLSuggestionsOrderingEnabled((boolean)false);
        this.orderSuggestionsUsingModelExistingRuleId();
    }

    private void testOrderingHappened(Language language, String rule_id) throws IOException {
        JLanguageTool languageTool = new JLanguageTool(language);
        SuggestionsOrdererGSoC suggestionsOrderer = new SuggestionsOrdererGSoC(language, null, rule_id);
        String word = "wprd";
        String sentence = String.join((CharSequence)" ", "a", word, "containing", "sentence");
        LinkedList<String> suggestions = new LinkedList<String>();
        suggestions.add("word");
        suggestions.add("weird");
        int startPos = sentence.indexOf(word);
        int wordLength = word.length();
        List suggestionsOrdered = suggestionsOrderer.orderSuggestionsUsingModel(suggestions, word, languageTool.getAnalyzedSentence(sentence), startPos);
        Assert.assertTrue((boolean)suggestionsOrdered.containsAll(suggestions));
    }

    public static void main(String[] args) throws IOException {
        HashMap<String, JLanguageTool> ltMap = new HashMap<String, JLanguageTool>();
        HashMap<String, Rule> rules = new HashMap<String, Rule>();
        HashMap<String, SuggestionsOrderer> ordererMap = new HashMap<String, SuggestionsOrderer>();
        AtomicInteger numOriginalCorrect = new AtomicInteger(0);
        AtomicInteger numReorderedCorrect = new AtomicInteger(0);
        AtomicInteger numOtherCorrect = new AtomicInteger(0);
        AtomicInteger numBothCorrect = new AtomicInteger(0);
        AtomicInteger numTotalReorderings = new AtomicInteger(0);
        AtomicInteger numMatches = new AtomicInteger(0);
        AtomicLong totalReorderingComputationTime = new AtomicLong(0L);
        AtomicLong totalHunspellComputationTime = new AtomicLong(0L);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> System.out.printf("%n**** Correct Suggestions ****%nBoth: %d / Original: %d / Reordered: %d / Other: %d%nAverage time per reordering: %fms / Average time in match(): %fms%n", numBothCorrect.intValue(), numOriginalCorrect.intValue(), numReorderedCorrect.intValue(), numOtherCorrect.intValue(), (double)totalReorderingComputationTime.get() / (double)numTotalReorderings.get(), (double)totalHunspellComputationTime.get() / (double)numMatches.get())));
        SuggestionsOrdererConfig.setNgramsPath((String)args[1]);
        try (CSVParser parser = new CSVParser((Reader)new FileReader(args[0]), CSVFormat.DEFAULT.withFirstRecordAsHeader());){
            for (CSVRecord record : parser) {
                Language language;
                JLanguageTool lt;
                Rule spellerRule;
                String lang = record.get("language");
                String covered = record.get("covered");
                String replacement = record.get("replacement");
                String sentenceStr = record.get("sentence");
                if (lang.equals("auto") || !lang.equals("en-US") && !lang.equals("de-DE") || (spellerRule = rules.computeIfAbsent(lang, arg_0 -> SuggestionsOrdererTest.lambda$main$2(lt = ltMap.computeIfAbsent(lang, arg_0 -> SuggestionsOrdererTest.lambda$main$1(language = Languages.getLanguageForShortCode((String)lang), arg_0)), arg_0))) == null) continue;
                SuggestionsOrderer orderer = null;
                try {
                    orderer = ordererMap.computeIfAbsent(lang, langCode -> new SuggestionsOrdererGSoC(language, null, spellerRule.getId()));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (orderer == null) continue;
                numMatches.incrementAndGet();
                AnalyzedSentence sentence = lt.getAnalyzedSentence(sentenceStr);
                long startTime = System.currentTimeMillis();
                RuleMatch[] matches = spellerRule.match(sentence);
                totalHunspellComputationTime.addAndGet(System.currentTimeMillis() - startTime);
                for (RuleMatch match : matches) {
                    String firstReordered;
                    String matchedWord = sentence.getText().substring(match.getFromPos(), match.getToPos());
                    if (!matchedWord.equals(covered)) continue;
                    List original = match.getSuggestedReplacements();
                    SuggestionsOrdererConfig.setMLSuggestionsOrderingEnabled((boolean)true);
                    numTotalReorderings.incrementAndGet();
                    startTime = System.currentTimeMillis();
                    List reordered = orderer.orderSuggestionsUsingModel(original, matchedWord, sentence, match.getFromPos());
                    totalReorderingComputationTime.addAndGet(System.currentTimeMillis() - startTime);
                    SuggestionsOrdererConfig.setMLSuggestionsOrderingEnabled((boolean)false);
                    if (original.size() == 0 || reordered.size() == 0) continue;
                    String firstOriginal = (String)original.get(0);
                    if (firstOriginal.equals(firstReordered = (String)reordered.get(0))) {
                        if (firstOriginal.equals(replacement)) {
                            numBothCorrect.incrementAndGet();
                            continue;
                        }
                        numOtherCorrect.incrementAndGet();
                        continue;
                    }
                    System.out.println("Ordering changed for match " + matchedWord + ", before: " + firstOriginal + ", after: " + firstReordered + ", choosen: " + replacement);
                    if (firstOriginal.equals(replacement)) {
                        numOriginalCorrect.incrementAndGet();
                        continue;
                    }
                    if (firstReordered.equals(replacement)) {
                        numReorderedCorrect.incrementAndGet();
                        continue;
                    }
                    numOtherCorrect.incrementAndGet();
                }
            }
        }
    }

    private static /* synthetic */ Rule lambda$main$2(JLanguageTool lt, String langCode) {
        return lt.getAllRules().stream().filter(Rule::isDictionaryBasedSpellingRule).findFirst().orElse(null);
    }

    private static /* synthetic */ JLanguageTool lambda$main$1(Language language, String langCode) {
        return new JLanguageTool(language);
    }
}

