/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.collections.Iterators;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.map.NgramsForOrderMapWrapper;
import edu.berkeley.nlp.lm.util.Logger;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NgramMapWrapper<W, V>
extends AbstractMap<List<W>, V> {
    private final NgramsForOrderMapWrapper<W, V>[] ngramsForOrder;
    private final WordIndexer<W> wordIndexer;
    private final NgramMap<V> ngramMap;

    public NgramMapWrapper(NgramMap<V> map, WordIndexer<W> wordIndexer) {
        this(map, wordIndexer, map.getMaxNgramOrder());
    }

    public NgramMapWrapper(NgramMap<V> map, WordIndexer<W> wordIndexer, int maxOrder) {
        NgramsForOrderMapWrapper[] maps = new NgramsForOrderMapWrapper[maxOrder];
        this.ngramsForOrder = maps;
        for (int ngramOrder = 0; ngramOrder < maxOrder; ++ngramOrder) {
            this.ngramsForOrder[ngramOrder] = new NgramsForOrderMapWrapper<W, V>(map, wordIndexer, ngramOrder);
        }
        this.wordIndexer = wordIndexer;
        this.ngramMap = map;
    }

    @Override
    public V get(Object arg0) {
        if (!(arg0 instanceof List)) {
            return null;
        }
        List l = (List)arg0;
        if (l.size() > this.ngramsForOrder.length) {
            return null;
        }
        return this.ngramsForOrder[l.size() - 1].get(l);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public Set<Map.Entry<List<W>, V>> entrySet() {
        return new AbstractSet<Map.Entry<List<W>, V>>(){

            @Override
            public Iterator<Map.Entry<List<W>, V>> iterator() {
                Iterators.Transform transform = new Iterators.Transform<NgramsForOrderMapWrapper<W, V>, Iterator<Map.Entry<List<W>, V>>>(Arrays.asList(NgramMapWrapper.this.ngramsForOrder).iterator()){

                    @Override
                    protected Iterator<Map.Entry<List<W>, V>> transform(NgramsForOrderMapWrapper<W, V> next) {
                        return next.entrySet().iterator();
                    }
                };
                return new Iterators.IteratorIterator(transform);
            }

            @Override
            public int size() {
                if (NgramMapWrapper.this.longSize() > Integer.MAX_VALUE) {
                    Logger.warn(NgramMapWrapper.class.getSimpleName() + " doesn't like maps with size greater than Integer.MAX_VALUE");
                }
                return (int)NgramMapWrapper.this.longSize();
            }
        };
    }

    public Map<List<W>, V> getMapForOrder(int ngramOrder) {
        return this.ngramsForOrder[ngramOrder];
    }

    public long longSize() {
        long size = 0L;
        for (NgramsForOrderMapWrapper<W, V> map : this.ngramsForOrder) {
            size += (long)map.size();
        }
        return size;
    }

    public WordIndexer<W> getWordIndexer() {
        return this.wordIndexer;
    }

    public NgramMap<V> getNgramMap() {
        return this.ngramMap;
    }
}

