/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.taglet;

import com.sun.javadoc.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.diagram.PaintDevice;
import net.sf.sdedit.diagram.SDPaintDevice;
import net.sf.sdedit.diagram.SequenceDiagramFactory;
import net.sf.sdedit.server.Exporter;
import net.sf.sdedit.taglet.SequenceTagletException;
import net.sf.sdedit.text.TextHandler;
import net.sf.sdedit.util.DocUtil;
import net.sf.sdedit.util.PWriter;
import net.sf.sdedit.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SequenceTaglet {
    private static final String tagName = "sequence.diagram";

    public static void register(Map tagletMap) {
        SequenceTaglet taglet;
        try {
            taglet = Utilities.newInstance("net.sf.sdedit.taglet.SequenceTaglet7", SequenceTaglet.class, new Object[0]);
        }
        catch (Throwable t) {
            taglet = Utilities.newInstance("net.sf.sdedit.taglet.SequenceTaglet6", SequenceTaglet.class, new Object[0]);
        }
        tagletMap.put(taglet.getName(), taglet);
    }

    protected SequenceTaglet() {
    }

    private String generateOutput(String[] source) throws SequenceTagletException {
        Document svg;
        if (source == null || source.length == 0) {
            return "";
        }
        PWriter writer = PWriter.create();
        writer.setLineSeparator("\n");
        String diagramTitle = null;
        for (String string : source) {
            if ((string = string.trim()).startsWith("<") && string.endsWith(">")) continue;
            if (string.matches("^[\"'].*[\"']$")) {
                diagramTitle = string.replaceAll("[\"']", "");
                continue;
            }
            writer.println(string);
        }
        writer.flush();
        writer.close();
        String specification = writer.toString();
        if (specification.length() == 0) {
            return "";
        }
        SequenceConfiguration conf = ConfigurationManager.createNewDefaultConfiguration(SequenceConfiguration.class).getDataObject();
        conf.setHeadWidth(25);
        conf.setMainLifelineWidth(5);
        conf.setSubLifelineWidth(5);
        conf.setThreaded(true);
        conf.setGlue(3);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Exporter exporter = Exporter.getExporter("svg", "Landscape", "A4", stream);
        SDPaintDevice paintDevice = new SDPaintDevice(exporter);
        SequenceDiagramFactory factory = new SequenceDiagramFactory(specification, (PaintDevice)paintDevice);
        try {
            factory.generateDiagram(conf);
        }
        catch (Exception e) {
            e.printStackTrace();
            TextHandler handler = (TextHandler)factory.getProvider();
            int error = handler.getLineNumber();
            StringBuffer code = new StringBuffer("<br><tt>");
            for (int i = 0; i < source.length; ++i) {
                String html = source[i].replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
                if (i == error) {
                    html = "<FONT COLOR=\"red\"><U><B>" + html + "</B></U></FONT>";
                }
                code.append(html + "<br>");
            }
            throw new SequenceTagletException("Malformed diagram specification: " + e.getMessage(), "<DT><HR><B>Sequence Diagram:</B></DT><DD><B>Could not create sequence diagram: <font color=\"red\">" + e.getMessage() + "</font></B>" + code.toString() + "</DD>");
        }
        exporter.export();
        ByteArrayInputStream in = new ByteArrayInputStream(stream.toByteArray());
        try {
            svg = DocUtil.readDocument(in, "utf-8");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Element root = svg.getDocumentElement();
        String s = DocUtil.toString(root, true);
        return "<DT><HR><B>" + diagramTitle + ":</B><P></DT>" + "<DD>" + s + "</DD>";
    }

    public String getName() {
        return tagName;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inField() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return false;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return false;
    }

    protected String makeString(Tag tag) throws SequenceTagletException {
        String output = this.generateOutput(tag.text().split("\n"));
        return output;
    }
}

