/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.axis.SimpleLongMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimeMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.CrossBorderLayout;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.DecimalXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYItemPainter;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYSelectionOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.ColorFactory;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;

public final class ThreadsGraphPanel
extends GraphPanel {
    private final Color THREADS_COLOR = ColorFactory.getPredefinedColor(0);
    private final Color CLASSES_COLOR = ColorFactory.getPredefinedColor(1);
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final VMTelemetryModels models;
    private final DataManagerListener listener;
    private final boolean smallPanel;

    public static ThreadsGraphPanel createBigPanel(VMTelemetryModels vMTelemetryModels) {
        return new ThreadsGraphPanel(vMTelemetryModels, false, null);
    }

    public static ThreadsGraphPanel createSmallPanel(VMTelemetryModels vMTelemetryModels, Action action) {
        return new ThreadsGraphPanel(vMTelemetryModels, true, action);
    }

    private ThreadsGraphPanel(VMTelemetryModels vMTelemetryModels, boolean bl, Action action) {
        this.models = vMTelemetryModels;
        this.smallPanel = bl;
        this.initComponents(action);
        this.listener = new DataManagerListener(){

            public void dataChanged() {
                ThreadsGraphPanel.this.updateData();
            }

            public void dataReset() {
                ThreadsGraphPanel.this.resetData();
            }
        };
        vMTelemetryModels.getDataManager().addDataListener(this.listener);
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    @Override
    public void cleanup() {
        this.models.getDataManager().removeDataListener(this.listener);
    }

    private void updateData() {
        VMTelemetryDataManager vMTelemetryDataManager;
        long[] lArray;
        if (this.smallPanel && this.chart.fitsWidth() && (lArray = vMTelemetryDataManager.timeStamps)[(vMTelemetryDataManager = this.models.getDataManager()).getItemCount() - 1] - lArray[0] >= 180000L) {
            this.chart.setFitsWidth(false);
        }
    }

    private void resetData() {
        if (this.smallPanel) {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(true);
        } else {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(false);
        }
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 3L));
    }

    private void initComponents(Action action) {
        PaintersModel paintersModel = this.createThreadsPaintersModel();
        this.chart = this.createChart(this.models.threadsItemsModel(), paintersModel, this.smallPanel);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        AxisComponent axisComponent = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.threadsItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 1, 2);
        axisComponent.setForeground(Color.GRAY);
        SynchronousXYItem synchronousXYItem = this.models.threadsItemsModel().getItem(0);
        XYItemPainter xYItemPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)synchronousXYItem);
        SimpleLongMarksPainter simpleLongMarksPainter = new SimpleLongMarksPainter();
        simpleLongMarksPainter.setForeground(this.THREADS_COLOR);
        AxisComponent axisComponent2 = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)synchronousXYItem, xYItemPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)simpleLongMarksPainter, 7, 2);
        axisComponent2.setForeground(Color.GRAY);
        SynchronousXYItem synchronousXYItem2 = this.models.threadsItemsModel().getItem(1);
        XYItemPainter xYItemPainter2 = (XYItemPainter)paintersModel.getPainter((ChartItem)synchronousXYItem2);
        SimpleLongMarksPainter simpleLongMarksPainter2 = new SimpleLongMarksPainter();
        simpleLongMarksPainter2.setForeground(this.CLASSES_COLOR);
        AxisComponent axisComponent3 = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)synchronousXYItem2, xYItemPainter2, this.chart.getChartContext(), 1), (AxisMarksPainter)simpleLongMarksPainter2, 3, 0);
        axisComponent3.setForeground(Color.GRAY);
        JPanel jPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        jPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createMatteBorder(10, 10, 5, 5, GraphsUI.CHART_BACKGROUND_COLOR));
        jPanel.add((Component)((Object)this.chart), new Integer[]{0});
        jPanel.add((Component)axisComponent, new Integer[]{1, 2, 8});
        jPanel.add((Component)axisComponent2, new Integer[]{7, 6});
        jPanel.add((Component)axisComponent3, new Integer[]{3, 4});
        JScrollBar jScrollBar = new JScrollBar(0);
        this.chart.attachHorizontalScrollBar(jScrollBar);
        jPanel.add((Component)jScrollBar, new Integer[]{5});
        if (!this.smallPanel) {
            ProfilerXYTooltipPainter profilerXYTooltipPainter = new ProfilerXYTooltipPainter(this.createTooltipModel());
            this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, profilerXYTooltipPainter));
            this.chart.getSelectionModel().setHoverMode(102);
            ProfilerXYSelectionOverlay profilerXYSelectionOverlay = new ProfilerXYSelectionOverlay();
            this.chart.addOverlayComponent(profilerXYSelectionOverlay);
            profilerXYSelectionOverlay.registerChart((ChartComponent)this.chart);
            this.chart.getSelectionModel().setMoveMode(1);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.add((Component)jPanel, "Center");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setOpaque(false);
            int n = new JLabel((String)"XXX").getPreferredSize().height;
            jPanel3.setBorder(BorderFactory.createEmptyBorder(n + 17, 0, 0, 10));
            InvisibleToolbar invisibleToolbar = new InvisibleToolbar(1);
            invisibleToolbar.setOpaque(true);
            invisibleToolbar.setBackground(UIUtils.getProfilerResultsBackground());
            invisibleToolbar.add(this.chart.toggleViewAction()).setBackground(UIUtils.getProfilerResultsBackground());
            invisibleToolbar.add(this.chart.zoomInAction()).setBackground(UIUtils.getProfilerResultsBackground());
            invisibleToolbar.add(this.chart.zoomOutAction()).setBackground(UIUtils.getProfilerResultsBackground());
            jPanel3.add((Component)invisibleToolbar, "Center");
            JLabel jLabel = new JLabel(GraphsUI.THREADS_NAME, new ColorIcon(this.THREADS_COLOR, Color.BLACK, 18, 9), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel jLabel2 = new JLabel(GraphsUI.LOADED_CLASSES_NAME, new ColorIcon(this.CLASSES_COLOR, Color.BLACK, 18, 9), 10);
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel jPanel4 = new JPanel(new FlowLayout(4, 7, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 30));
            jPanel4.setOpaque(true);
            jPanel4.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel4.add(jLabel);
            jPanel4.add(jLabel2);
            this.setLayout(new BorderLayout());
            this.setBackground(UIUtils.getProfilerResultsBackground());
            JLabel jLabel3 = new JLabel(GraphsUI.THREADS_CLASSES_CAPTION, 0);
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            jLabel3.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
            jLabel3.setOpaque(true);
            jLabel3.setBackground(UIUtils.getProfilerResultsBackground());
            this.add((Component)jLabel3, "North");
            this.add((Component)jPanel2, "Center");
            this.add((Component)jPanel4, "South");
            this.add((Component)jPanel3, "East");
            this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
        }
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long l) {
                return GraphPanel.DATE_FORMATTER.format(new Date(l));
            }

            @Override
            public int getRowsCount() {
                return 2;
            }

            @Override
            public String getRowName(int n) {
                switch (n) {
                    case 0: {
                        return GraphsUI.THREADS_NAME;
                    }
                    case 1: {
                        return GraphsUI.LOADED_CLASSES_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int n) {
                switch (n) {
                    case 0: {
                        return GraphsUI.THREADS_PAINTER_LINE_COLOR;
                    }
                    case 1: {
                        return GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int n, long l) {
                return GraphPanel.INT_FORMATTER.format(l);
            }

            @Override
            public String getRowUnits(int n) {
                return "";
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int n) {
                return ThreadsGraphPanel.this.getMaxValueString(this.getRowName(n));
            }

            @Override
            public Color getExtraRowColor(int n) {
                return this.getRowColor(n);
            }

            @Override
            public String getExtraRowValue(int n) {
                SynchronousXYItem synchronousXYItem = ThreadsGraphPanel.this.models.threadsItemsModel().getItem(n);
                return GraphPanel.INT_FORMATTER.format(synchronousXYItem.getMaxYValue());
            }

            @Override
            public String getExtraRowUnits(int n) {
                return this.getRowUnits(n);
            }
        };
    }

    private PaintersModel createThreadsPaintersModel() {
        ProfilerXYItemPainter profilerXYItemPainter;
        ProfilerXYItemPainter profilerXYItemPainter2;
        ProfilerXYItemPainter profilerXYItemPainter3 = profilerXYItemPainter2 = ProfilerXYItemPainter.absolutePainter(2.0f, this.THREADS_COLOR, null);
        ProfilerXYItemPainter profilerXYItemPainter4 = profilerXYItemPainter = ProfilerXYItemPainter.relativePainter(2.0f, this.CLASSES_COLOR, null, 10);
        SynchronousXYItemsModel synchronousXYItemsModel = this.models.threadsItemsModel();
        PaintersModel.Default default_ = new PaintersModel.Default(new ChartItem[]{synchronousXYItemsModel.getItem(0), synchronousXYItemsModel.getItem(1)}, (ItemPainter[])new XYItemPainter[]{profilerXYItemPainter3, profilerXYItemPainter4});
        return default_;
    }
}

