/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.python.icu.impl.StandardPlural;
import org.python.icu.impl.number.FormatQuantity;
import org.python.icu.text.PluralRules;

public class FormatQuantity1
implements FormatQuantity {
    private int lOptPos = Integer.MAX_VALUE;
    private int lReqPos = 0;
    private int rReqPos = 0;
    private int rOptPos = Integer.MIN_VALUE;
    private long primary;
    private int primaryScale;
    private int primaryPrecision;
    private BigDecimal fallback;
    private int flags;
    private static final int NEGATIVE_FLAG = 1;
    private static final int INFINITY_FLAG = 2;
    private static final int NAN_FLAG = 4;
    private static final long[] POWERS_OF_TEN = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    static final double LOG_2_OF_TEN = 3.32192809489;

    @Override
    public int maxRepresentableDigits() {
        return Integer.MAX_VALUE;
    }

    public FormatQuantity1(long input) {
        if (input < 0L) {
            this.setNegative(true);
            input *= -1L;
        }
        this.primary = input;
        this.primaryScale = 0;
        this.primaryPrecision = FormatQuantity1.computePrecision(this.primary);
        this.fallback = null;
    }

    public FormatQuantity1(double input) {
        long ieeeBits;
        int exponent;
        if (input < 0.0) {
            this.setNegative(true);
            input *= -1.0;
        }
        if ((exponent = (int)(((ieeeBits = Double.doubleToLongBits(input)) & 0x7FF0000000000000L) >> 52) - 1023) >= 52 && exponent <= 63) {
            long mantissa = (ieeeBits & 0xFFFFFFFFFFFFFL) + 0x10000000000000L;
            this.primary = mantissa << exponent - 52;
            this.primaryScale = 0;
            this.primaryPrecision = FormatQuantity1.computePrecision(this.primary);
            return;
        }
        String temp = Double.toString(input);
        try {
            if (temp.length() == 3 && temp.equals("0.0")) {
                this.primary = 0L;
                this.primaryScale = 0;
                this.primaryPrecision = 0;
            } else if (temp.indexOf(69) != -1) {
                assert (temp.indexOf(46) == 1);
                int expPos = temp.indexOf(69);
                this.primary = Long.parseLong(temp.charAt(0) + temp.substring(2, expPos));
                this.primaryScale = Integer.parseInt(temp.substring(expPos + 1)) - (expPos - 1) + 1;
                this.primaryPrecision = expPos - 1;
            } else if (temp.charAt(0) == '0') {
                assert (temp.indexOf(46) == 1);
                this.primary = Long.parseLong(temp.substring(2));
                this.primaryScale = 2 - temp.length();
                this.primaryPrecision = FormatQuantity1.computePrecision(this.primary);
            } else if (temp.charAt(temp.length() - 1) == '0') {
                assert (temp.indexOf(46) == temp.length() - 2);
                int rightmostNonzeroDigitIndex = temp.length() - 3;
                while (temp.charAt(rightmostNonzeroDigitIndex) == '0') {
                    --rightmostNonzeroDigitIndex;
                }
                this.primary = Long.parseLong(temp.substring(0, rightmostNonzeroDigitIndex + 1));
                this.primaryScale = temp.length() - rightmostNonzeroDigitIndex - 3;
                this.primaryPrecision = rightmostNonzeroDigitIndex + 1;
            } else if (temp.equals("Infinity")) {
                this.primary = 0L;
                this.setInfinity(true);
            } else if (temp.equals("NaN")) {
                this.primary = 0L;
                this.setNaN(true);
            } else {
                int decimalPos = temp.indexOf(46);
                this.primary = Long.parseLong(temp.substring(0, decimalPos) + temp.substring(decimalPos + 1));
                this.primaryScale = decimalPos - temp.length() + 1;
                this.primaryPrecision = temp.length() - 1;
            }
        }
        catch (NumberFormatException e) {
            this.primary = -1L;
            this.fallback = new BigDecimal(temp);
        }
    }

    public FormatQuantity1(double input, boolean fast) {
        int fractionCount;
        if (input < 0.0) {
            this.setNegative(true);
            input *= -1.0;
        }
        long ieeeBits = Double.doubleToLongBits(input);
        int exponent = (int)((ieeeBits & 0x7FF0000000000000L) >> 52) - 1023;
        long mantissa = (ieeeBits & 0xFFFFFFFFFFFFFL) + 0x10000000000000L;
        if (exponent > 63) {
            throw new IllegalArgumentException();
        }
        if (exponent >= 52) {
            this.primary = mantissa << exponent - 52;
            this.primaryScale = 0;
            this.primaryPrecision = FormatQuantity1.computePrecision(this.primary);
            return;
        }
        if (exponent >= 0) {
            int shift = 52 - exponent;
            this.primary = mantissa >> shift;
            fractionCount = (int)((double)shift / 3.32192809489);
            long fraction = mantissa - (this.primary << shift) + 1L;
            this.primary *= POWERS_OF_TEN[fractionCount];
            for (int i = 0; i < fractionCount; ++i) {
                long times10 = fraction * 10L;
                long digit = times10 >> shift;
                assert (digit >= 0L && digit < 10L);
                this.primary += digit * POWERS_OF_TEN[fractionCount - i - 1];
                fraction = times10 & (1L << shift) - 1L;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.primaryScale = -fractionCount;
        this.primaryPrecision = FormatQuantity1.computePrecision(this.primary);
    }

    public FormatQuantity1(BigDecimal decimal) {
        if (decimal.compareTo(BigDecimal.ZERO) < 0) {
            this.setNegative(true);
            decimal = decimal.negate();
        }
        this.primary = -1L;
        this.fallback = decimal.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : decimal;
    }

    public FormatQuantity1(FormatQuantity1 other) {
        this.copyFrom(other);
    }

    @Override
    public FormatQuantity1 createCopy() {
        return new FormatQuantity1(this);
    }

    @Override
    public void copyFrom(FormatQuantity other) {
        FormatQuantity1 _other = (FormatQuantity1)other;
        this.lOptPos = _other.lOptPos;
        this.lReqPos = _other.lReqPos;
        this.rReqPos = _other.rReqPos;
        this.rOptPos = _other.rOptPos;
        this.primary = _other.primary;
        this.primaryScale = _other.primaryScale;
        this.primaryPrecision = _other.primaryPrecision;
        this.fallback = _other.fallback;
        this.flags = _other.flags;
    }

    @Override
    public long getPositionFingerprint() {
        long fingerprint = 0L;
        fingerprint ^= (long)this.lOptPos;
        fingerprint ^= (long)(this.lReqPos << 16);
        fingerprint ^= (long)this.rReqPos << 32;
        return fingerprint ^= (long)this.rOptPos << 48;
    }

    private static int computePrecision(long input) {
        int precision = 0;
        while (input > 0L) {
            input /= 10L;
            ++precision;
        }
        return precision;
    }

    private void convertToBigDecimal() {
        if (this.primary == -1L) {
            return;
        }
        this.fallback = new BigDecimal(this.primary).scaleByPowerOfTen(this.primaryScale);
        this.primary = -1L;
    }

    @Override
    public void setIntegerFractionLength(int minInt, int maxInt, int minFrac, int maxFrac) {
        minInt = Math.max(0, minInt);
        maxInt = Math.max(0, maxInt);
        minFrac = Math.max(0, minFrac);
        maxFrac = Math.max(0, maxFrac);
        if (maxInt < minInt) {
            minInt = maxInt;
        }
        if (maxFrac < minFrac) {
            minFrac = maxFrac;
        }
        if (maxInt == 0 && maxFrac == 0) {
            maxInt = Integer.MAX_VALUE;
            maxFrac = Integer.MAX_VALUE;
        }
        this.lOptPos = maxInt;
        this.lReqPos = minInt;
        this.rReqPos = -minFrac;
        this.rOptPos = -maxFrac;
    }

    @Override
    public void roundToIncrement(BigDecimal roundingInterval, MathContext mathContext) {
        BigDecimal d;
        BigDecimal bigDecimal = d = this.primary == -1L ? this.fallback : new BigDecimal(this.primary).scaleByPowerOfTen(this.primaryScale);
        if (this.isNegative()) {
            d = d.negate();
        }
        d = d.divide(roundingInterval, 0, mathContext.getRoundingMode()).multiply(roundingInterval);
        if (this.isNegative()) {
            d = d.negate();
        }
        this.fallback = d;
        this.primary = -1L;
    }

    @Override
    public void roundToMagnitude(int roundingMagnitude, MathContext mathContext) {
        if (roundingMagnitude < -1000) {
            this.roundToInfinity();
            return;
        }
        if (this.primary == -1L) {
            if (this.isNegative()) {
                this.fallback = this.fallback.negate();
            }
            this.fallback = this.fallback.setScale(-roundingMagnitude, mathContext.getRoundingMode());
            if (this.isNegative()) {
                this.fallback = this.fallback.negate();
            }
            this.fallback = this.fallback.round(mathContext);
        } else {
            int relativeScale = this.primaryScale - roundingMagnitude;
            if (relativeScale < -18) {
                this.primary = 0L;
                this.primaryScale = roundingMagnitude;
                this.primaryPrecision = 0;
            } else if (relativeScale < 0 && this.primary % POWERS_OF_TEN[0 - relativeScale] != 0L) {
                BigDecimal temp = new BigDecimal(this.primary).scaleByPowerOfTen(this.primaryScale);
                if (this.isNegative()) {
                    temp = temp.negate();
                }
                temp = temp.setScale(-roundingMagnitude, mathContext.getRoundingMode());
                if (this.isNegative()) {
                    temp = temp.negate();
                }
                temp = temp.scaleByPowerOfTen(-roundingMagnitude);
                this.primary = temp.longValueExact();
                this.primaryScale = roundingMagnitude;
                this.primaryPrecision = FormatQuantity1.computePrecision(this.primary);
            }
            this.primary = new BigDecimal(this.primary).round(mathContext).longValueExact();
            this.primaryPrecision = FormatQuantity1.computePrecision(this.primary);
        }
    }

    @Override
    public void roundToInfinity() {
    }

    @Override
    public void multiplyBy(BigDecimal multiplicand) {
        this.convertToBigDecimal();
        this.fallback = this.fallback.multiply(multiplicand);
        if (this.fallback.compareTo(BigDecimal.ZERO) < 0) {
            this.setNegative(!this.isNegative());
            this.fallback = this.fallback.negate();
        }
    }

    private void divideBy(BigDecimal divisor, int scale, MathContext mathContext) {
        this.convertToBigDecimal();
        this.fallback = this.fallback.divide(divisor, -scale, mathContext.getRoundingMode());
        if (this.fallback.compareTo(BigDecimal.ZERO) < 0) {
            this.setNegative(!this.isNegative());
            this.fallback = this.fallback.negate();
        }
    }

    @Override
    public boolean isZero() {
        if (this.primary == -1L) {
            return this.fallback.compareTo(BigDecimal.ZERO) == 0;
        }
        return this.primary == 0L;
    }

    @Override
    public int getMagnitude() throws ArithmeticException {
        int precision;
        int scale = this.primary == -1L ? FormatQuantity1.scaleBigDecimal(this.fallback) : this.primaryScale;
        int n = precision = this.primary == -1L ? FormatQuantity1.precisionBigDecimal(this.fallback) : this.primaryPrecision;
        if (precision == 0) {
            throw new ArithmeticException("Magnitude is not well-defined for zero");
        }
        return scale + precision - 1;
    }

    @Override
    public void adjustMagnitude(int delta) {
        if (this.primary == -1L) {
            this.fallback = this.fallback.scaleByPowerOfTen(delta);
        } else {
            this.primaryScale = FormatQuantity1.addOrMaxValue(this.primaryScale, delta);
        }
    }

    private static int addOrMaxValue(int a, int b) {
        if (b < 0 && a + b > a) {
            return Integer.MIN_VALUE;
        }
        if (b > 0 && a + b < a) {
            return Integer.MAX_VALUE;
        }
        return a + b;
    }

    @Override
    public boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    private void setNegative(boolean isNegative) {
        this.flags = this.flags & 0xFFFFFFFE | (isNegative ? 1 : 0);
    }

    @Override
    public boolean isInfinite() {
        return (this.flags & 2) != 0;
    }

    private void setInfinity(boolean isInfinity) {
        this.flags = this.flags & 0xFFFFFFFD | (isInfinity ? 2 : 0);
    }

    @Override
    public boolean isNaN() {
        return (this.flags & 4) != 0;
    }

    private void setNaN(boolean isNaN) {
        this.flags = this.flags & 0xFFFFFFFB | (isNaN ? 4 : 0);
    }

    @Override
    public double toDouble() {
        double result;
        if (this.primary == -1L) {
            result = this.fallback.doubleValue();
        } else {
            int i;
            result = this.primary;
            for (i = 0; i < this.primaryScale; ++i) {
                result *= 10.0;
            }
            for (i = 0; i > this.primaryScale; --i) {
                result /= 10.0;
            }
        }
        return this.isNegative() ? -result : result;
    }

    @Override
    public BigDecimal toBigDecimal() {
        BigDecimal result = this.primary != -1L ? new BigDecimal(this.primary).scaleByPowerOfTen(this.primaryScale) : this.fallback;
        return this.isNegative() ? result.negate() : result;
    }

    @Override
    public StandardPlural getStandardPlural(PluralRules rules) {
        if (rules == null) {
            return StandardPlural.OTHER;
        }
        String ruleString = rules.select(this.toDouble());
        return StandardPlural.orOtherFromString(ruleString);
    }

    @Override
    public double getPluralOperand(PluralRules.Operand operand) {
        return new PluralRules.FixedDecimal(this.toDouble()).getPluralOperand(operand);
    }

    public boolean hasNextFraction() {
        if (this.rReqPos < 0) {
            return true;
        }
        if (this.rOptPos >= 0) {
            return false;
        }
        if (this.primary == -1L) {
            return this.fallback.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) > 0;
        }
        if (this.primaryScale <= -19) {
            return this.primary > 0L;
        }
        if (this.primaryScale < 0) {
            long factor = POWERS_OF_TEN[0 - this.primaryScale];
            return this.primary % factor != 0L;
        }
        return false;
    }

    public byte nextFraction() {
        byte returnValue;
        if (this.primary == -1L) {
            BigDecimal temp = this.fallback.multiply(BigDecimal.TEN);
            returnValue = temp.setScale(0, RoundingMode.FLOOR).remainder(BigDecimal.TEN).byteValue();
            this.fallback = this.fallback.setScale(0, RoundingMode.FLOOR).add(temp.remainder(BigDecimal.ONE));
        } else if (this.primaryScale <= -20) {
            ++this.primaryScale;
            returnValue = 0;
        } else if (this.primaryScale < 0) {
            long factor = POWERS_OF_TEN[0 - this.primaryScale - 1];
            long temp1 = this.primary / factor;
            long temp2 = this.primary % factor;
            returnValue = (byte)(temp1 % 10L);
            this.primary = temp1 / 10L * factor + temp2;
            ++this.primaryScale;
            if (temp1 != 0L) {
                --this.primaryPrecision;
            }
        } else {
            returnValue = 0;
        }
        if (this.lOptPos < 0) {
            ++this.lOptPos;
        }
        if (this.lReqPos < 0) {
            ++this.lReqPos;
        }
        if (this.rReqPos < 0) {
            ++this.rReqPos;
        }
        if (this.rOptPos < 0) {
            ++this.rOptPos;
        }
        assert (returnValue >= 0);
        return returnValue;
    }

    public boolean hasNextInteger() {
        if (this.lReqPos > 0) {
            return true;
        }
        if (this.lOptPos <= 0) {
            return false;
        }
        if (this.primary == -1L) {
            return this.fallback.setScale(0, RoundingMode.FLOOR).compareTo(BigDecimal.ZERO) > 0;
        }
        if (this.primaryScale < -18) {
            return false;
        }
        if (this.primaryScale < 0) {
            long factor = POWERS_OF_TEN[0 - this.primaryScale];
            return this.primary % factor != this.primary;
        }
        return this.primary != 0L;
    }

    private int integerCount() {
        int digitsRemaining = this.primary == -1L ? FormatQuantity1.precisionBigDecimal(this.fallback) + FormatQuantity1.scaleBigDecimal(this.fallback) : this.primaryPrecision + this.primaryScale;
        return Math.min(Math.max(digitsRemaining, this.lReqPos), this.lOptPos);
    }

    private int fractionCount() {
        FormatQuantity1 copy = new FormatQuantity1(this);
        int fractionCount = 0;
        while (copy.hasNextFraction()) {
            copy.nextFraction();
            ++fractionCount;
        }
        return fractionCount;
    }

    @Override
    public int getUpperDisplayMagnitude() {
        return this.integerCount() - 1;
    }

    @Override
    public int getLowerDisplayMagnitude() {
        return -this.fractionCount();
    }

    @Override
    public byte getDigit(int magnitude) {
        FormatQuantity1 copy = new FormatQuantity1(this);
        if (magnitude < 0) {
            for (int p = -1; p > magnitude; --p) {
                copy.nextFraction();
            }
            return copy.nextFraction();
        }
        for (int p = 0; p < magnitude; ++p) {
            copy.nextInteger();
        }
        return copy.nextInteger();
    }

    public byte nextInteger() {
        byte returnValue;
        if (this.primary == -1L) {
            returnValue = this.fallback.setScale(0, RoundingMode.FLOOR).remainder(BigDecimal.TEN).byteValue();
            BigDecimal temp = this.fallback.divide(BigDecimal.TEN).setScale(0, RoundingMode.FLOOR);
            this.fallback = this.fallback.remainder(BigDecimal.ONE).add(temp);
        } else if (this.primaryScale < -18) {
            returnValue = 0;
        } else if (this.primaryScale < 0) {
            long factor = POWERS_OF_TEN[0 - this.primaryScale];
            if (this.primary % factor != this.primary) {
                returnValue = (byte)(this.primary / factor % 10L);
                long temp = this.primary / 10L;
                this.primary = temp - temp % factor + this.primary % factor;
                --this.primaryPrecision;
            } else {
                returnValue = 0;
            }
        } else if (this.primaryScale == 0) {
            if (this.primary != 0L) {
                returnValue = (byte)(this.primary % 10L);
                this.primary /= 10L;
                --this.primaryPrecision;
            } else {
                returnValue = 0;
            }
        } else {
            --this.primaryScale;
            returnValue = 0;
        }
        if (this.lOptPos > 0) {
            --this.lOptPos;
        }
        if (this.lReqPos > 0) {
            --this.lReqPos;
        }
        if (this.rReqPos > 0) {
            --this.rReqPos;
        }
        if (this.rOptPos > 0) {
            --this.rOptPos;
        }
        assert (returnValue >= 0);
        return returnValue;
    }

    private static int precisionBigDecimal(BigDecimal decimal) {
        if (decimal.compareTo(BigDecimal.ZERO) == 0) {
            return 0;
        }
        return decimal.precision();
    }

    private static int scaleBigDecimal(BigDecimal decimal) {
        return -decimal.scale();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<FormatQuantity1 ");
        if (this.primary == -1L) {
            sb.append(this.lOptPos > 1000 ? "max" : Integer.valueOf(this.lOptPos));
            sb.append(":");
            sb.append(this.lReqPos);
            sb.append(":");
            sb.append(this.rReqPos);
            sb.append(":");
            sb.append(this.rOptPos < -1000 ? "min" : Integer.valueOf(this.rOptPos));
            sb.append(" ");
            sb.append(this.fallback.toString());
        } else {
            String digits = Long.toString(this.primary);
            int iDec = digits.length() + this.primaryScale;
            int iLP = iDec - FormatQuantity1.toRange(this.lOptPos, -1000, 1000);
            int iLB = iDec - FormatQuantity1.toRange(this.lReqPos, -1000, 1000);
            int iRB = iDec - FormatQuantity1.toRange(this.rReqPos, -1000, 1000);
            int iRP = iDec - FormatQuantity1.toRange(this.rOptPos, -1000, 1000);
            iDec = Math.max(Math.min(iDec, digits.length() + 1), -1);
            iLP = Math.max(Math.min(iLP, digits.length() + 1), -1);
            iLB = Math.max(Math.min(iLB, digits.length() + 1), -1);
            iRB = Math.max(Math.min(iRB, digits.length() + 1), -1);
            iRP = Math.max(Math.min(iRP, digits.length() + 1), -1);
            for (int i = -1; i <= digits.length() + 1; ++i) {
                if (i == iLP) {
                    sb.append('(');
                }
                if (i == iLB) {
                    sb.append('[');
                }
                if (i == iDec) {
                    sb.append('.');
                }
                if (i == iRB) {
                    sb.append(']');
                }
                if (i == iRP) {
                    sb.append(')');
                }
                if (i >= 0 && i < digits.length()) {
                    sb.append(digits.charAt(i));
                    continue;
                }
                sb.append('\u00a0');
            }
        }
        sb.append(">");
        return sb.toString();
    }

    private static int toRange(int i, int lo, int hi) {
        if (i < lo) {
            return lo;
        }
        if (i > hi) {
            return hi;
        }
        return i;
    }
}

