/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.MemInStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.ConnParams;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Rect;
import java.nio.ByteBuffer;

public class RREDecoder
extends Decoder {
    public RREDecoder() {
        super(Decoder.DecoderFlags.DecoderPlain);
    }

    @Override
    public void readRect(Rect rect, InStream inStream, ConnParams connParams, OutStream outStream) {
        int n = inStream.readU32();
        outStream.writeU32(n);
        outStream.copyBytes(inStream, connParams.pf().bpp / 8 + n * (connParams.pf().bpp / 8 + 8));
    }

    @Override
    public void decodeRect(Rect rect, Object object, int n, ConnParams connParams, ModifiablePixelBuffer modifiablePixelBuffer) {
        MemInStream memInStream = new MemInStream((byte[])object, 0, n);
        PixelFormat pixelFormat = connParams.pf();
        switch (pixelFormat.bpp) {
            case 8: {
                this.rreDecode8(rect, memInStream, pixelFormat, modifiablePixelBuffer);
                break;
            }
            case 16: {
                this.rreDecode16(rect, memInStream, pixelFormat, modifiablePixelBuffer);
                break;
            }
            case 32: {
                this.rreDecode32(rect, memInStream, pixelFormat, modifiablePixelBuffer);
            }
        }
    }

    private static ByteBuffer READ_PIXEL(InStream inStream, PixelFormat pixelFormat) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        switch (pixelFormat.bpp) {
            case 8: {
                byteBuffer.putInt(inStream.readOpaque8());
                return ByteBuffer.allocate(1).put(byteBuffer.get(3));
            }
            case 16: {
                byteBuffer.putInt(inStream.readOpaque16());
                return ByteBuffer.allocate(2).put(byteBuffer.array(), 2, 2);
            }
        }
        byteBuffer.putInt(inStream.readOpaque32());
        return byteBuffer;
    }

    private void RRE_DECODE(Rect rect, InStream inStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        int n = inStream.readU32();
        byte[] byArray = RREDecoder.READ_PIXEL(inStream, pixelFormat).array();
        modifiablePixelBuffer.fillRect(pixelFormat, rect, byArray);
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = RREDecoder.READ_PIXEL(inStream, pixelFormat).array();
            int n2 = inStream.readU16();
            int n3 = inStream.readU16();
            int n4 = inStream.readU16();
            int n5 = inStream.readU16();
            modifiablePixelBuffer.fillRect(pixelFormat, new Rect(rect.tl.x + n2, rect.tl.y + n3, rect.tl.x + n2 + n4, rect.tl.y + n3 + n5), byArray2);
        }
    }

    private void rreDecode8(Rect rect, InStream inStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.RRE_DECODE(rect, inStream, pixelFormat, modifiablePixelBuffer);
    }

    private void rreDecode16(Rect rect, InStream inStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.RRE_DECODE(rect, inStream, pixelFormat, modifiablePixelBuffer);
    }

    private void rreDecode32(Rect rect, InStream inStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.RRE_DECODE(rect, inStream, pixelFormat, modifiablePixelBuffer);
    }
}

