/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.common.XmlBindingTools;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Base64Coding;
import freemind.main.FreeMindMain;
import freemind.main.FreeMindStarter;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.print.Paper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Tools {
    public static final String FREEMIND_LIB_FREEMIND_JAR = "lib/freemind.jar";
    private static Logger logger = null;
    public static final String CONTENTS_JAVA_FREEMIND_JAR = "Contents/Java/freemind.jar";
    public static final String FREE_MIND_APP_CONTENTS_RESOURCES_JAVA = "Contents/Resources/Java/";
    public static final Set executableExtensions;
    private static Set availableFontFamilyNames;
    private static String[] sEnvFonts;
    public static Random ran;
    public static final String JAVA_VERSION;

    public static boolean executableByExtension(String file) {
        return executableExtensions.contains(Tools.getExtension(file));
    }

    public static String colorToXml(Color col) {
        if (col == null) {
            return null;
        }
        String red = Integer.toHexString(col.getRed());
        if (col.getRed() < 16) {
            red = "0" + red;
        }
        String green = Integer.toHexString(col.getGreen());
        if (col.getGreen() < 16) {
            green = "0" + green;
        }
        String blue = Integer.toHexString(col.getBlue());
        if (col.getBlue() < 16) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    public static Color xmlToColor(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 7) {
            int red = Integer.parseInt(string.substring(1, 3), 16);
            int green = Integer.parseInt(string.substring(3, 5), 16);
            int blue = Integer.parseInt(string.substring(5, 7), 16);
            return new Color(red, green, blue);
        }
        throw new IllegalArgumentException("No xml color given by '" + string + "'.");
    }

    public static String PointToXml(Point col) {
        if (col == null) {
            return null;
        }
        Vector<String> l = new Vector<String>();
        l.add(Integer.toString(col.x));
        l.add(Integer.toString(col.y));
        return Tools.listToString(l);
    }

    public static Point xmlToPoint(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("java.awt.Point")) {
            string = string.replaceAll("java\\.awt\\.Point\\[x=(-*[0-9]*),y=(-*[0-9]*)\\]", "$1;$2");
        }
        List l = Tools.stringToList(string);
        ListIterator it = l.listIterator(0);
        if (l.size() != 2) {
            throw new IllegalArgumentException("A point must consist of two numbers (and not: '" + string + "').");
        }
        int x = Integer.parseInt((String)it.next());
        int y = Integer.parseInt((String)it.next());
        return new Point(x, y);
    }

    public static String BooleanToXml(boolean col) {
        return col ? "true" : "false";
    }

    public static boolean xmlToBoolean(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("true");
    }

    public static List stringToList(String string) {
        StringTokenizer tok = new StringTokenizer(string, ";");
        LinkedList<String> list = new LinkedList<String>();
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list;
    }

    public static String listToString(List list) {
        ListIterator it = list.listIterator(0);
        String str = new String();
        while (it.hasNext()) {
            str = str + it.next().toString() + ";";
        }
        return str;
    }

    public static String expandFileName(String file) {
        if (file.startsWith("~")) {
            file = System.getProperty("user.home") + file.substring(1);
        }
        return file;
    }

    public static Set getAvailableFontFamilyNames() {
        if (availableFontFamilyNames == null) {
            String[] envFonts = Tools.getAvailableFonts();
            availableFontFamilyNames = new HashSet();
            for (int i = 0; i < envFonts.length; ++i) {
                availableFontFamilyNames.add(envFonts[i]);
            }
            availableFontFamilyNames.add("dialog");
        }
        return availableFontFamilyNames;
    }

    private static String[] getAvailableFonts() {
        if (sEnvFonts == null) {
            GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            sEnvFonts = gEnv.getAvailableFontFamilyNames();
        }
        return sEnvFonts;
    }

    public static Vector getAvailableFontFamilyNamesAsVector() {
        String[] envFonts = Tools.getAvailableFonts();
        Vector<String> availableFontFamilyNames = new Vector<String>();
        for (int i = 0; i < envFonts.length; ++i) {
            availableFontFamilyNames.add(envFonts[i]);
        }
        return availableFontFamilyNames;
    }

    public static boolean isAvailableFontFamily(String fontFamilyName) {
        return Tools.getAvailableFontFamilyNames().contains(fontFamilyName);
    }

    public static String getExtension(File f) {
        return Tools.getExtension(f.toString());
    }

    public static String getExtension(String s) {
        int i = s.lastIndexOf(46);
        return i > 0 && i < s.length() - 1 ? s.substring(i + 1).toLowerCase().trim() : "";
    }

    public static String removeExtension(String s) {
        int i = s.lastIndexOf(46);
        return i > 0 && i < s.length() - 1 ? s.substring(0, i) : "";
    }

    public static boolean isAbsolutePath(String path) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        String fileSeparator = System.getProperty("file.separator");
        if (osNameStart.equals("Win")) {
            return path.length() > 1 && path.substring(1, 2).equals(":") || path.startsWith(fileSeparator);
        }
        if (osNameStart.equals("Mac")) {
            return path.startsWith(fileSeparator);
        }
        return path.startsWith(fileSeparator);
    }

    public static String urlGetFile(URL url) {
        if (Tools.isWindows() && Tools.isFile(url)) {
            String fileName = url.toString().replaceFirst("^file:", "").replace('/', '\\');
            return fileName.indexOf(58) >= 0 ? fileName.replaceFirst("^\\\\*", "") : fileName;
        }
        return url.getFile();
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").substring(0, 3).equals("Win");
    }

    public static boolean isFile(URL url) {
        return url.getProtocol().equals("file");
    }

    public static String getPrefix(String pFileName) {
        if (Tools.isWindows()) {
            if (pFileName.matches("^[a-zA-Z]:\\\\.*")) {
                return pFileName.substring(0, 3);
            }
        } else if (pFileName.startsWith(File.separator)) {
            return File.separator;
        }
        return null;
    }

    public static String toRelativeURL(URL base, URL target) {
        if (base == null || !base.getProtocol().equals(target.getProtocol()) || !base.getHost().equals(target.getHost())) {
            return target.toString();
        }
        String baseString = base.getFile();
        String targetString = target.getFile();
        String result = "";
        targetString = targetString.substring(0, targetString.lastIndexOf("/") + 1);
        baseString = baseString.substring(0, baseString.lastIndexOf("/") + 1);
        int index = targetString.length() - 1;
        while (!baseString.startsWith(targetString.substring(0, index + 1)) && (index = targetString.lastIndexOf("/", index - 1)) >= 0) {
        }
        String baseStringRest = baseString.substring(index, baseString.length());
        StringTokenizer baseTokens = new StringTokenizer(baseStringRest, "/");
        StringTokenizer targetTokens = new StringTokenizer(targetString.substring(index + 1), "/");
        String nextTargetToken = "";
        while (baseTokens.hasMoreTokens()) {
            result = result.concat("../");
            baseTokens.nextToken();
        }
        while (targetTokens.hasMoreTokens()) {
            nextTargetToken = targetTokens.nextToken();
            result = result.concat(nextTargetToken + "/");
        }
        String temp = target.getFile();
        result = result.concat(temp.substring(temp.lastIndexOf("/") + 1, temp.length()));
        return result;
    }

    public static String fileToRelativeUrlString(File input, File pMapFile) {
        try {
            URL link = Tools.fileToUrl(input);
            String relative = link.toString();
            if ("relative".equals(Resources.getInstance().getProperty("links"))) {
                relative = Tools.toRelativeURL(Tools.fileToUrl(pMapFile), link);
            }
            return relative;
        }
        catch (MalformedURLException ex) {
            Resources.getInstance().logException(ex);
            return input.getAbsolutePath();
        }
    }

    public static boolean isPreferenceTrue(String option) {
        return Tools.safeEquals(option, "true");
    }

    public static boolean safeEquals(String string1, String string2) {
        return string1 != null && string2 != null && string1.equals(string2) || string1 == null && string2 == null;
    }

    public static boolean safeEquals(Object obj1, Object obj2) {
        return obj1 != null && obj2 != null && obj1.equals(obj2) || obj1 == null && obj2 == null;
    }

    public static boolean safeEqualsIgnoreCase(String string1, String string2) {
        return string1 != null && string2 != null && string1.toLowerCase().equals(string2.toLowerCase()) || string1 == null && string2 == null;
    }

    public static boolean safeEquals(Color color1, Color color2) {
        return color1 != null && color2 != null && color1.equals(color2) || color1 == null && color2 == null;
    }

    public static String firstLetterCapitalized(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1, text.length());
    }

    public static void setHidden(File file, boolean hidden, boolean synchronously) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        if (osNameStart.equals("Win")) {
            try {
                Runtime.getRuntime().exec("attrib " + (hidden ? "+" : "-") + "H \"" + file.getAbsolutePath() + "\"");
                if (!synchronously) {
                    return;
                }
                for (int timeOut = 10; file.isHidden() != hidden && timeOut > 0; --timeOut) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
        }
    }

    public static String expandPlaceholders(String message, String s1) {
        String result = message;
        if (s1 != null) {
            s1 = s1.replaceAll("\\\\", "\\\\\\\\");
            result = result.replaceAll("\\$1", s1);
        }
        return result;
    }

    public static String expandPlaceholders(String message, String s1, String s2) {
        String result = message;
        if (s1 != null) {
            result = result.replaceAll("\\$1", s1);
        }
        if (s2 != null) {
            result = result.replaceAll("\\$2", s2);
        }
        return result;
    }

    public static String expandPlaceholders(String message, String s1, String s2, String s3) {
        String result = message;
        if (s1 != null) {
            result = result.replaceAll("\\$1", s1);
        }
        if (s2 != null) {
            result = result.replaceAll("\\$2", s2);
        }
        if (s3 != null) {
            result = result.replaceAll("\\$3", s3);
        }
        return result;
    }

    public static String toBase64(byte[] byteBuffer) {
        return new String(Base64Coding.encode64(byteBuffer));
    }

    public static String toBase64(String text) {
        return Tools.toBase64(text.getBytes());
    }

    public static byte[] fromBase64(String base64String) {
        return Base64Coding.decode64(base64String);
    }

    public static String compress(String message) {
        byte[] input = Tools.uTF8StringToByteArray(message);
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] compressedData = bos.toByteArray();
        return Tools.toBase64(compressedData);
    }

    public static String decompress(String compressedMessage) {
        byte[] compressedData = Tools.fromBase64(compressedMessage);
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1024];
        boolean errorOccured = false;
        while (!decompressor.finished() && !errorOccured) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                errorOccured = true;
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] decompressedData = bos.toByteArray();
        return Tools.byteArrayToUTF8String(decompressedData);
    }

    public static String byteArrayToUTF8String(byte[] compressedData) {
        try {
            return new String(compressedData, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 packing not allowed");
        }
    }

    public static byte[] uTF8StringToByteArray(String uncompressedData) {
        try {
            return uncompressedData.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 packing not allowed");
        }
    }

    public static Date xmlToDate(String xmlString) {
        try {
            return new Date(Long.valueOf(xmlString));
        }
        catch (Exception e) {
            return new Date(System.currentTimeMillis());
        }
    }

    public static String dateToString(Date date) {
        return Long.toString(date.getTime());
    }

    public static boolean safeEquals(BooleanHolder holder, BooleanHolder holder2) {
        return holder == null && holder2 == null || holder != null && holder2 != null && holder.getValue() == holder2.getValue();
    }

    public static void setDialogLocationRelativeTo(JDialog dialog, Component c) {
        int bottomSpace;
        int topSpace;
        int rightSpace;
        int leftSpace;
        if (c == null) {
            return;
        }
        if (c instanceof NodeView) {
            NodeView nodeView = (NodeView)c;
            nodeView.getMap().scrollNodeToVisible(nodeView);
            c = nodeView.getMainView();
        }
        Point compLocation = c.getLocationOnScreen();
        int cw = c.getWidth();
        int ch = c.getHeight();
        Container parent = dialog.getParent();
        Point parentLocation = parent.getLocationOnScreen();
        int pw = parent.getWidth();
        int ph = parent.getHeight();
        int dw = dialog.getWidth();
        int dh = dialog.getHeight();
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = defaultToolkit.getScreenSize();
        Insets screenInsets = defaultToolkit.getScreenInsets(dialog.getGraphicsConfiguration());
        int minX = Math.max(parentLocation.x, screenInsets.left);
        int minY = Math.max(parentLocation.y, screenInsets.top);
        int maxX = Math.min(parentLocation.x + pw, screenSize.width - screenInsets.right);
        int maxY = Math.min(parentLocation.y + ph, screenSize.height - screenInsets.bottom);
        int dx = compLocation.x + cw < minX ? minX : (compLocation.x > maxX ? maxX - dw : ((leftSpace = compLocation.x - minX) > (rightSpace = maxX - (compLocation.x + cw)) ? (leftSpace > dw ? compLocation.x - dw : minX) : (rightSpace > dw ? compLocation.x + cw : maxX - dw)));
        int dy = compLocation.y + ch < minY ? minY : (compLocation.y > maxY ? maxY - dh : ((topSpace = compLocation.y - minY) > (bottomSpace = maxY - (compLocation.y + ch)) ? (topSpace > dh ? compLocation.y - dh : minY) : (bottomSpace > dh ? compLocation.y + ch : maxY - dh)));
        dialog.setLocation(dx, dy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader getUpdateReader(Reader pReader, String xsltScript, FreeMindMain frame) throws IOException {
        StringWriter writer = null;
        InputStream inputStream = null;
        final Logger logger = frame.getLogger(Tools.class.getName());
        logger.info("Updating the reader " + pReader + " to the current version.");
        boolean successful = false;
        String errorMessage = null;
        try {
            URL updaterUrl = null;
            updaterUrl = frame.getResource(xsltScript);
            if (updaterUrl == null) {
                throw new IllegalArgumentException(xsltScript + " not found.");
            }
            inputStream = updaterUrl.openStream();
            final StreamSource xsltSource = new StreamSource(inputStream);
            writer = new StringWriter();
            final StreamResult result = new StreamResult(writer);
            String fileContents = Tools.getFile(pReader);
            if (fileContents.length() > 10) {
                logger.info("File start before UTF8 replacement: '" + fileContents.substring(0, 9) + "'");
            }
            if ((fileContents = Tools.replaceUtf8AndIllegalXmlChars(fileContents)).length() > 10) {
                logger.info("File start after UTF8 replacement: '" + fileContents.substring(0, 9) + "'");
            }
            final StreamSource sr = new StreamSource(new StringReader(fileContents));
            class TransformerRunnable
            implements Runnable {
                private boolean successful = false;
                private String errorMessage;

                TransformerRunnable() {
                }

                @Override
                public void run() {
                    TransformerFactory transFact = TransformerFactory.newInstance();
                    logger.info("TransformerFactory class: " + transFact.getClass());
                    try {
                        Transformer trans = transFact.newTransformer(xsltSource);
                        trans.transform(sr, result);
                        this.successful = true;
                    }
                    catch (Exception ex) {
                        Resources.getInstance().logException(ex);
                        this.errorMessage = ex.toString();
                    }
                }

                public boolean isSuccessful() {
                    return this.successful;
                }

                public String getErrorMessage() {
                    return this.errorMessage;
                }
            }
            TransformerRunnable transformer = new TransformerRunnable();
            Thread transformerThread = new Thread((Runnable)transformer, "XSLT");
            transformerThread.start();
            transformerThread.join();
            logger.info("Updating the reader " + pReader + " to the current version. Done.");
            successful = transformer.isSuccessful();
            errorMessage = transformer.getErrorMessage();
        }
        catch (Exception ex) {
            Resources.getInstance().logException(ex, xsltScript);
            errorMessage = ex.getLocalizedMessage();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        if (successful) {
            String content = writer.getBuffer().toString();
            String replacedContent = Tools.replaceUtf8AndIllegalXmlChars(content);
            return new StringReader(replacedContent);
        }
        return new StringReader("<map><node TEXT='" + HtmlTools.toXMLEscapedText(errorMessage) + "'/></map>");
    }

    public static String replaceUtf8AndIllegalXmlChars(String fileContents) {
        return HtmlTools.removeInvalidXmlCharacters(fileContents);
    }

    public static Reader getActualReader(Reader pReader) throws FileNotFoundException {
        return new BufferedReader(pReader);
    }

    public static String getFile(File pInputFile) {
        try {
            return Tools.getFile(Tools.getReaderFromFile(pInputFile));
        }
        catch (FileNotFoundException e) {
            Resources.getInstance().logException(e);
            return null;
        }
    }

    public static Reader getReaderFromFile(File pInputFile) throws FileNotFoundException {
        return new FileReader(pInputFile);
    }

    public static String getFile(Reader pReader) {
        StringBuffer lines = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(pReader);
            String endLine = System.getProperty("line.separator");
            while ((line = bufferedReader.readLine()) != null) {
                lines.append(line).append(endLine);
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception ex) {
                    Resources.getInstance().logException(ex);
                }
            }
            return null;
        }
        return lines.toString();
    }

    public static void logTransferable(Transferable t) {
        System.err.println();
        System.err.println("BEGIN OF Transferable:\t" + t);
        DataFlavor[] dataFlavors = t.getTransferDataFlavors();
        for (int i = 0; i < dataFlavors.length; ++i) {
            System.out.println("  Flavor:\t" + dataFlavors[i]);
            System.out.println("    Supported:\t" + t.isDataFlavorSupported(dataFlavors[i]));
            try {
                System.out.println("    Content:\t" + t.getTransferData(dataFlavors[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.err.println("END OF Transferable");
        System.err.println();
    }

    public static void addEscapeActionToDialog(JDialog dialog) {
        class EscapeAction
        extends AbstractAction {
            private static final long serialVersionUID = 238333614987438806L;
            final /* synthetic */ JDialog val$dialog;

            EscapeAction(JDialog jDialog) {
                this.val$dialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$dialog.dispose();
            }
        }
        Tools.addEscapeActionToDialog(dialog, new EscapeAction(dialog));
    }

    public static void addEscapeActionToDialog(JDialog dialog, Action action) {
        Tools.addKeyActionToDialog(dialog, action, "ESCAPE", "end_dialog");
    }

    public static void addKeyActionToDialog(JDialog dialog, Action action, String keyStroke, String actionId) {
        action.putValue("Name", actionId);
        dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(keyStroke), action.getValue("Name"));
        dialog.getRootPane().getActionMap().put(action.getValue("Name"), action);
    }

    public static String removeTranslateComment(String inputString) {
        if (inputString != null && inputString.endsWith("[translate me]")) {
            inputString = inputString.substring(0, inputString.length() - "[translate me]".length());
        }
        return inputString;
    }

    public static URL getURLWithoutReference(URL input) throws MalformedURLException {
        return new URL(input.toString().replaceFirst("#.*", ""));
    }

    public static void copyStream(InputStream in, OutputStream out, boolean pCloseOutput) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        if (pCloseOutput) {
            out.close();
        }
    }

    public static Point convertPointToAncestor(Component c, Point p, Component destination) {
        while (c != destination) {
            int x = c.getX();
            int y = c.getY();
            p.x += x;
            p.y += y;
            c = c.getParent();
        }
        return p;
    }

    public static void convertPointFromAncestor(Component source, Point p, Component c) {
        while (c != source) {
            int x = c.getX();
            int y = c.getY();
            p.x -= x;
            p.y -= y;
            c = c.getParent();
        }
    }

    public static void convertPointToAncestor(Component source, Point point, Class ancestorClass) {
        Container destination = SwingUtilities.getAncestorOfClass(ancestorClass, source);
        Tools.convertPointToAncestor(source, point, destination);
    }

    public static void setLabelAndMnemonic(AbstractButton btn, String inLabel) {
        Tools.setLabelAndMnemonic(new ButtonHolder(btn), inLabel);
    }

    public static void setLabelAndMnemonic(Action action, String inLabel) {
        Tools.setLabelAndMnemonic(new ActionHolder(action), inLabel);
    }

    private static void setLabelAndMnemonic(NameMnemonicHolder item, String inLabel) {
        char charAfterMnemoSign;
        String rawLabel = inLabel;
        if (rawLabel == null) {
            rawLabel = item.getText();
        }
        if (rawLabel == null) {
            return;
        }
        item.setText(Tools.removeMnemonic(rawLabel));
        int mnemoSignIndex = rawLabel.indexOf("&");
        if (mnemoSignIndex >= 0 && mnemoSignIndex + 1 < rawLabel.length() && (charAfterMnemoSign = rawLabel.charAt(mnemoSignIndex + 1)) != ' ' && !Tools.isMacOsX()) {
            item.setMnemonic(charAfterMnemoSign);
            item.setDisplayedMnemonicIndex(mnemoSignIndex);
        }
    }

    public static boolean isMacOsX() {
        boolean underMac = false;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            underMac = true;
        }
        return underMac;
    }

    public static boolean isLinux() {
        boolean underLinux = false;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            underLinux = true;
        }
        return underLinux;
    }

    public static String removeMnemonic(String rawLabel) {
        return rawLabel.replaceFirst("&([^ ])", "$1");
    }

    public static KeyStroke getKeyStroke(String keyStrokeDescription) {
        if (keyStrokeDescription == null) {
            return null;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyStrokeDescription);
        if (keyStroke != null) {
            return keyStroke;
        }
        return KeyStroke.getKeyStroke("typed " + keyStrokeDescription);
    }

    public static URL fileToUrl(File pFile) throws MalformedURLException {
        if (pFile == null) {
            return null;
        }
        return pFile.toURI().toURL();
    }

    public static boolean isBelowJava6() {
        return JAVA_VERSION.compareTo("1.6.0") < 0;
    }

    public static boolean isAboveJava4() {
        return JAVA_VERSION.compareTo("1.4.0") > 0;
    }

    public static File urlToFile(URL pUrl) throws URISyntaxException {
        if (Tools.isBelowJava6()) {
            return new File(Tools.urlGetFile(pUrl));
        }
        return new File(new URI(pUrl.toString()));
    }

    public static void restoreAntialiasing(Graphics2D g, Object renderingHint) {
        if (RenderingHints.KEY_ANTIALIASING.isCompatibleValue(renderingHint)) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        }
    }

    public static String getFileNameProposal(MindMapNode node) {
        String rootText = node.getPlainTextContent();
        rootText = rootText.replaceAll("[&:/\\\\\u0000%$#~\\?\\*]+", "");
        return rootText;
    }

    public static void waitForEventQueue() {
        try {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            } else {
                logger.warning("Can't wait for event queue, if I'm inside this queue!");
            }
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
        }
    }

    public static void printStackTrace() {
        Resources.getInstance().logException(new IllegalArgumentException("HERE"));
    }

    public static String getStackTrace() {
        IllegalArgumentException ex = new IllegalArgumentException("HERE");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(b));
        return b.toString();
    }

    public static Font updateFontSize(Font font, float zoom, int normalFontSize) {
        float newFontSize;
        float oldFontSize;
        if (font != null && (oldFontSize = font.getSize2D()) != (newFontSize = (float)normalFontSize * zoom)) {
            font = font.deriveFont(newFontSize);
        }
        return font;
    }

    public static String compareText(String pText1, String pText2) {
        if (pText1 == null || pText2 == null) {
            return "One of the Strings is null " + pText1 + ", " + pText2;
        }
        StringBuffer b = new StringBuffer();
        if (pText1.length() > pText2.length()) {
            b.append("First string is longer :" + pText1.substring(pText2.length()) + "\n");
        }
        if (pText1.length() < pText2.length()) {
            b.append("Second string is longer :" + pText2.substring(pText1.length()) + "\n");
        }
        for (int i = 0; i < Math.min(pText1.length(), pText2.length()); ++i) {
            if (pText1.charAt(i) == pText2.charAt(i)) continue;
            b.append("Difference at " + i + ": " + pText1.charAt(i) + "!=" + pText2.charAt(i) + "\n");
        }
        return b.toString();
    }

    public static String getHostName() {
        String hostname = "UNKNOWN";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    public static String getUserName() {
        String hostname = Tools.getHostName();
        return System.getProperty("user.name") + "@" + hostname;
    }

    public static String marshall(XmlAction action) {
        return XmlBindingTools.getInstance().marshall(action);
    }

    public static XmlAction unMarshall(String inputString) {
        return XmlBindingTools.getInstance().unMarshall(inputString);
    }

    public static String getFileNameFromRestorable(String restoreable) {
        String fileName;
        StringTokenizer token = new StringTokenizer(restoreable, ":");
        if (token.hasMoreTokens()) {
            token.nextToken();
            fileName = token.nextToken("").substring(1);
        } else {
            fileName = null;
        }
        return fileName;
    }

    public static String getModeFromRestorable(String restoreable) {
        StringTokenizer token = new StringTokenizer(restoreable, ":");
        String mode = token.hasMoreTokens() ? token.nextToken() : null;
        return mode;
    }

    public static Vector getVectorWithSingleElement(Object obj) {
        Vector<Object> nodes = new Vector<Object>();
        nodes.add(obj);
        return nodes;
    }

    public static void swapVectorPositions(Vector pVector, int src, int dst) {
        if (src >= pVector.size() || dst >= pVector.size() || src < 0 || dst < 0) {
            throw new IllegalArgumentException("One index is out of bounds " + src + ", " + dst + ", size= " + pVector.size());
        }
        pVector.set(dst, pVector.set(src, pVector.get(dst)));
    }

    public static Object getField(Object[] pObjects, String pField) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        for (int i = 0; i < pObjects.length; ++i) {
            Object object = pObjects[i];
            for (int j = 0; j < object.getClass().getFields().length; ++j) {
                Field f = object.getClass().getFields()[j];
                if (!Tools.safeEquals(pField, f.getName())) continue;
                return object.getClass().getField(pField).get(object);
            }
        }
        return null;
    }

    public static boolean isUnix() {
        return File.separatorChar == '/' || Tools.isMacOsX();
    }

    public static void setPermissions(String path, int permissions) {
        if (permissions != 0 && Tools.isUnix()) {
            String[] cmdarray = new String[]{"chmod", Integer.toString(permissions, 8), path};
            try {
                Process process = Runtime.getRuntime().exec(cmdarray);
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static String arrayToUrls(String[] pArgs) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < pArgs.length; ++i) {
            String fileName = pArgs[i];
            try {
                b.append(Tools.fileToUrl(new File(fileName)));
                b.append('\n');
                continue;
            }
            catch (MalformedURLException e) {
                Resources.getInstance().logException(e);
            }
        }
        return b.toString();
    }

    public static Vector urlStringToUrls(String pUrls) {
        String[] urls = pUrls.split("\n");
        Vector<URL> ret = new Vector<URL>();
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i];
            try {
                ret.add(new URL(url));
                continue;
            }
            catch (MalformedURLException e) {
                Resources.getInstance().logException(e);
            }
        }
        return ret;
    }

    public static boolean isHeadless() {
        GraphicsEnvironment.getLocalGraphicsEnvironment();
        return GraphicsEnvironment.isHeadless();
    }

    public static String getNodeTextHierarchy(MindMapNode pNode, MindMapController pMindMapController) {
        return pNode.getShortText(pMindMapController) + (pNode.isRoot() ? "" : " <- " + Tools.getNodeTextHierarchy(pNode.getParentNode(), pMindMapController));
    }

    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void addFocusPrintTimer() {
        Timer timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                logger.info("Component: " + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() + ", Window: " + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow());
            }
        });
        timer.start();
    }

    public static void invokeActionsToKeyboardLayoutDependantCharacters(KeyEvent pEvent, Action[] specialKeyActions, Object pObject) {
        int modifiersMask = 14;
        for (int i = 0; i < specialKeyActions.length; ++i) {
            Action specialKeyAction = specialKeyActions[i];
            KeyStroke actionKeyStroke = (KeyStroke)specialKeyAction.getValue("AcceleratorKey");
            if (pEvent.getKeyChar() != actionKeyStroke.getKeyChar() || (pEvent.getModifiers() & modifiersMask) != (actionKeyStroke.getModifiers() & modifiersMask) || !specialKeyAction.isEnabled()) continue;
            specialKeyAction.actionPerformed(new ActionEvent(pObject, 1001, (String)specialKeyAction.getValue("ActionCommandKey")));
            pEvent.consume();
        }
    }

    public static int countOccurrences(String pString, String pSearchString) {
        int index;
        int amount = 0;
        while ((index = pString.indexOf(pSearchString)) >= 0) {
            ++amount;
            pString = pString.substring(index + pSearchString.length());
        }
        return amount;
    }

    public static void correctJSplitPaneKeyMap() {
        InputMap map = (InputMap)UIManager.get("SplitPane.ancestorInputMap");
        KeyStroke keyStrokeF6 = KeyStroke.getKeyStroke(117, 0);
        KeyStroke keyStrokeF8 = KeyStroke.getKeyStroke(119, 0);
        map.remove(keyStrokeF6);
        map.remove(keyStrokeF8);
    }

    public static void setPageFormatFromString(Paper pPaper, String pPageFormatProperty) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(pPageFormatProperty, ";");
            if (tokenizer.countTokens() != 6) {
                logger.warning("Page format property has not the correct format:" + pPageFormatProperty);
                return;
            }
            pPaper.setSize(Tools.nt(tokenizer), Tools.nt(tokenizer));
            pPaper.setImageableArea(Tools.nt(tokenizer), Tools.nt(tokenizer), Tools.nt(tokenizer), Tools.nt(tokenizer));
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
        }
    }

    private static double nt(StringTokenizer pTokenizer) {
        String nextToken = pTokenizer.nextToken();
        try {
            return Double.parseDouble(nextToken);
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return 0.0;
        }
    }

    public static String getPageFormatAsString(Paper pPaper) {
        return pPaper.getWidth() + ";" + pPaper.getHeight() + ";" + pPaper.getImageableX() + ";" + pPaper.getImageableY() + ";" + pPaper.getImageableWidth() + ";" + pPaper.getImageableHeight();
    }

    public static String getHostIpAsString() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            Resources.getInstance().logException(e);
            return null;
        }
    }

    public static String printXmlAction(XmlAction pAction) {
        String classString = pAction.getClass().getName().replaceAll(".*\\.", "");
        if (pAction instanceof CompoundAction) {
            CompoundAction compound = (CompoundAction)pAction;
            StringBuffer buf = new StringBuffer("[");
            Iterator it = compound.getListChoiceList().iterator();
            while (it.hasNext()) {
                if (buf.length() > 1) {
                    buf.append(',');
                }
                XmlAction subAction = (XmlAction)it.next();
                buf.append(Tools.printXmlAction(subAction));
            }
            buf.append(']');
            return classString + " " + buf.toString();
        }
        return classString;
    }

    public static XmlAction deepCopy(XmlAction action) {
        return Tools.unMarshall(Tools.marshall(action));
    }

    public static String generateID(String proposedID, HashMap hashMap, String prefix) {
        String returnValue;
        String myProposedID = new String(proposedID != null ? proposedID : "");
        do {
            if (!myProposedID.isEmpty()) {
                returnValue = myProposedID;
                myProposedID = "";
                continue;
            }
            returnValue = prefix + Integer.toString(ran.nextInt(2000000000));
        } while (hashMap.containsKey(returnValue));
        return returnValue;
    }

    public static void invokeAndWait(Runnable pRunnable) throws InvocationTargetException, InterruptedException {
        if (EventQueue.isDispatchThread()) {
            pRunnable.run();
        } else {
            EventQueue.invokeAndWait(pRunnable);
        }
    }

    public static String getFreeMindBasePath() throws UnsupportedEncodingException {
        String path = FreeMindStarter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = URLDecoder.decode(path, "UTF-8");
        logger.info("Path: " + decodedPath);
        if (decodedPath.endsWith(CONTENTS_JAVA_FREEMIND_JAR)) {
            decodedPath = decodedPath.substring(0, decodedPath.length() - CONTENTS_JAVA_FREEMIND_JAR.length());
            decodedPath = decodedPath + FREE_MIND_APP_CONTENTS_RESOURCES_JAVA;
            logger.info("macPath: " + decodedPath);
        } else if (decodedPath.endsWith(FREEMIND_LIB_FREEMIND_JAR)) {
            decodedPath = decodedPath.substring(0, decodedPath.length() - FREEMIND_LIB_FREEMIND_JAR.length());
            logger.info("reducded Path: " + decodedPath);
        }
        return decodedPath;
    }

    public static Properties copyChangedProperties(Properties props2, Properties defProps2) {
        Properties toBeStored = new Properties();
        for (String string : props2.keySet()) {
            if (Tools.safeEquals(props2.get(string), defProps2.get(string))) continue;
            toBeStored.put(string, props2.get(string));
        }
        return toBeStored;
    }

    static {
        logger = Resources.getInstance().getLogger("Tools");
        executableExtensions = new HashSet<String>(Arrays.asList("exe", "com", "vbs", "bat", "lnk"));
        availableFontFamilyNames = null;
        sEnvFonts = null;
        ran = new Random();
        JAVA_VERSION = System.getProperty("java.version");
    }

    public static class MindMapNodePair {
        MindMapNode first;
        MindMapNode second;

        public MindMapNodePair(MindMapNode first, MindMapNode second) {
            this.first = first;
            this.second = second;
        }

        public MindMapNode getCorresponding() {
            return this.first;
        }

        public MindMapNode getCloneNode() {
            return this.second;
        }
    }

    private static class ActionHolder
    implements NameMnemonicHolder {
        private Action action;

        public ActionHolder(Action action) {
            this.action = action;
        }

        @Override
        public String getText() {
            return this.action.getValue("Name").toString();
        }

        @Override
        public void setDisplayedMnemonicIndex(int mnemoSignIndex) {
        }

        @Override
        public void setMnemonic(char charAfterMnemoSign) {
            int vk = charAfterMnemoSign;
            if (vk >= 97 && vk <= 122) {
                vk -= 32;
            }
            this.action.putValue("MnemonicKey", new Integer(vk));
        }

        @Override
        public void setText(String text) {
            this.action.putValue("Name", text);
        }
    }

    private static class ButtonHolder
    implements NameMnemonicHolder {
        private AbstractButton btn;

        public ButtonHolder(AbstractButton btn) {
            this.btn = btn;
        }

        @Override
        public String getText() {
            return this.btn.getText();
        }

        @Override
        public void setDisplayedMnemonicIndex(int mnemoSignIndex) {
            this.btn.setDisplayedMnemonicIndex(mnemoSignIndex);
        }

        @Override
        public void setMnemonic(char charAfterMnemoSign) {
            this.btn.setMnemonic(charAfterMnemoSign);
        }

        @Override
        public void setText(String text) {
            this.btn.setText(text);
        }
    }

    static interface NameMnemonicHolder {
        public String getText();

        public void setText(String var1);

        public void setMnemonic(char var1);

        public void setDisplayedMnemonicIndex(int var1);
    }

    public static class TripleDesEncrypter
    extends DesEncrypter {
        public TripleDesEncrypter(StringBuffer pPassPhrase) {
            super(pPassPhrase, "PBEWithMD5AndTripleDES");
        }
    }

    public static class SingleDesEncrypter
    extends DesEncrypter {
        public SingleDesEncrypter(StringBuffer pPassPhrase) {
            super(pPassPhrase, "PBEWithMD5AndDES");
        }
    }

    public static class DesEncrypter {
        private static final String SALT_PRESENT_INDICATOR = " ";
        private static final int SALT_LENGTH = 8;
        Cipher ecipher;
        Cipher dcipher;
        byte[] salt = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
        int iterationCount = 19;
        private final char[] passPhrase;
        private String mAlgorithm;

        public DesEncrypter(StringBuffer pPassPhrase, String pAlgorithm) {
            this.passPhrase = new char[pPassPhrase.length()];
            pPassPhrase.getChars(0, this.passPhrase.length, this.passPhrase, 0);
            this.mAlgorithm = pAlgorithm;
        }

        private void init(byte[] mSalt) {
            if (mSalt != null) {
                this.salt = mSalt;
            }
            if (this.ecipher == null) {
                try {
                    PBEKeySpec keySpec = new PBEKeySpec(this.passPhrase, this.salt, this.iterationCount);
                    SecretKey key = SecretKeyFactory.getInstance(this.mAlgorithm).generateSecret(keySpec);
                    this.ecipher = Cipher.getInstance(this.mAlgorithm);
                    this.dcipher = Cipher.getInstance(this.mAlgorithm);
                    PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, this.iterationCount);
                    this.ecipher.init(1, (Key)key, paramSpec);
                    this.dcipher.init(2, (Key)key, paramSpec);
                }
                catch (InvalidAlgorithmParameterException e) {
                }
                catch (InvalidKeySpecException e) {
                }
                catch (NoSuchPaddingException e) {
                }
                catch (NoSuchAlgorithmException e) {
                }
                catch (InvalidKeyException invalidKeyException) {
                    // empty catch block
                }
            }
        }

        public String encrypt(String str) {
            try {
                byte[] utf8 = str.getBytes("UTF8");
                byte[] newSalt = new byte[8];
                for (int i = 0; i < newSalt.length; ++i) {
                    newSalt[i] = (byte)(Math.random() * 256.0 - 128.0);
                }
                this.init(newSalt);
                byte[] enc = this.ecipher.doFinal(utf8);
                return Tools.toBase64(newSalt) + SALT_PRESENT_INDICATOR + Tools.toBase64(enc);
            }
            catch (BadPaddingException e) {
            }
            catch (IllegalBlockSizeException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return null;
        }

        public String decrypt(String str) {
            if (str == null) {
                return null;
            }
            try {
                byte[] salt = null;
                int indexOfSaltIndicator = str.indexOf(SALT_PRESENT_INDICATOR);
                if (indexOfSaltIndicator >= 0) {
                    String saltString = str.substring(0, indexOfSaltIndicator);
                    str = str.substring(indexOfSaltIndicator + 1);
                    salt = Tools.fromBase64(saltString);
                }
                str = str.replaceAll("\\s", "");
                byte[] dec = Tools.fromBase64(str);
                this.init(salt);
                byte[] utf8 = this.dcipher.doFinal(dec);
                return new String(utf8, "UTF8");
            }
            catch (BadPaddingException e) {
            }
            catch (IllegalBlockSizeException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return null;
        }
    }

    public static class Pair {
        Object first;
        Object second;

        public Pair(Object first, Object second) {
            this.first = first;
            this.second = second;
        }

        public Object getFirst() {
            return this.first;
        }

        public Object getSecond() {
            return this.second;
        }
    }

    public static class ObjectHolder {
        Object object;

        public void setObject(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static class BooleanHolder {
        private boolean value;

        public BooleanHolder() {
        }

        public BooleanHolder(boolean initialValue) {
            this.value = initialValue;
        }

        public void setValue(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }
    }

    public static class IntHolder {
        private int value;

        public IntHolder() {
        }

        public IntHolder(int value) {
            this.value = value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return new String("IntHolder(") + this.value + ")";
        }
    }
}

