/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.springframework.boot.loader.tools.SignalUtils;
import org.springframework.util.ReflectionUtils;

public class RunProcess {
    private static final Method INHERIT_IO_METHOD = ReflectionUtils.findMethod(ProcessBuilder.class, (String)"inheritIO");
    private static final long JUST_ENDED_LIMIT = 500L;
    private File workingDirectory;
    private final String[] command;
    private volatile Process process;
    private volatile long endTime;

    public RunProcess(String ... command) {
        this((File)null, command);
    }

    public RunProcess(File workingDirectory, String ... command) {
        this.workingDirectory = workingDirectory;
        this.command = command;
    }

    public int run(boolean waitForProcess, String ... args) throws IOException {
        return this.run(waitForProcess, Arrays.asList(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected int run(boolean waitForProcess, Collection<String> args) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.command);
        builder.directory(this.workingDirectory);
        builder.command().addAll(args);
        builder.redirectErrorStream(true);
        boolean inheritedIO = this.inheritIO(builder);
        try {
            Process process;
            this.process = process = builder.start();
            if (!inheritedIO) {
                this.redirectOutput(process);
            }
            SignalUtils.attachSignalHandler(new Runnable(){

                @Override
                public void run() {
                    RunProcess.this.handleSigInt();
                }
            });
            if (waitForProcess) {
                try {
                    int n = process.waitFor();
                    return n;
                }
                catch (InterruptedException ex) {
                    int n;
                    block10: {
                        Thread.currentThread().interrupt();
                        n = 1;
                        if (!waitForProcess) break block10;
                        this.endTime = System.currentTimeMillis();
                        this.process = null;
                    }
                    return n;
                }
            }
            int n = 5;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (waitForProcess) {
                this.endTime = System.currentTimeMillis();
                this.process = null;
            }
        }
    }

    private boolean inheritIO(ProcessBuilder builder) {
        if (RunProcess.isInheritIOBroken()) {
            return false;
        }
        try {
            INHERIT_IO_METHOD.invoke((Object)builder, new Object[0]);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean isInheritIOBroken() {
        if (!System.getProperty("os.name", "none").toLowerCase(Locale.ENGLISH).contains("windows")) {
            return false;
        }
        String runtime = System.getProperty("java.runtime.version");
        if (!runtime.startsWith("1.7")) {
            return false;
        }
        String[] tokens = runtime.split("_");
        if (tokens.length < 2) {
            return true;
        }
        try {
            Integer build = Integer.valueOf(tokens[1].split("[^0-9]")[0]);
            if (build < 60) {
                return true;
            }
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    private void redirectOutput(Process process) {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        new Thread(){

            @Override
            public void run() {
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        System.out.println(line);
                        line = reader.readLine();
                        System.out.flush();
                    }
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public Process getRunningProcess() {
        return this.process;
    }

    public boolean handleSigInt() {
        if (this.hasJustEnded()) {
            return true;
        }
        return this.doKill();
    }

    public void kill() {
        this.doKill();
    }

    private boolean doKill() {
        Process process = this.process;
        if (process != null) {
            try {
                process.destroy();
                process.waitFor();
                this.process = null;
                return true;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    public boolean hasJustEnded() {
        return System.currentTimeMillis() < this.endTime + 500L;
    }
}

