/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.modelset.Atom;
import org.jmol.script.T;
import org.jmol.shape.Mesh;
import org.jmol.shapesurface.PMeshWriter;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.Viewer;

public class IsosurfaceMesh
extends Mesh {
    public JvxlData jvxlData;
    public int vertexIncrement = 1;
    public int firstRealVertex = -1;
    public int dataType;
    public boolean hasGridPoints;
    Object calculatedArea;
    Object calculatedVolume;
    Object info;
    private Map<Integer, Integer> assocGridPointMap;
    private Map<Integer, V3> assocGridPointNormals;
    private int mergeAssociatedNormalCount;
    P3[] centers;
    float[] contourValues;
    short[] contourColixes;
    public ColorEncoder colorEncoder;
    BS bsVdw;
    public boolean colorPhased;

    @Override
    public float getResolution() {
        return 1.0f / this.jvxlData.pointsPerAngstrom;
    }

    IsosurfaceMesh(Viewer viewer, String string, short s, int n) {
        this.mesh1(viewer, string, s, n);
        this.jvxlData = new JvxlData();
        this.checkByteCount = 2;
        this.jvxlData.version = Viewer.getJmolVersion();
    }

    void clearType(String string, boolean bl) {
        this.clear(string);
        this.jvxlData.clear();
        this.assocGridPointMap = null;
        this.assocGridPointNormals = null;
        this.bsVdw = null;
        this.calculatedVolume = null;
        this.calculatedArea = null;
        this.centers = null;
        this.colorEncoder = null;
        this.colorPhased = false;
        this.colorsExplicit = false;
        this.firstRealVertex = -1;
        this.hasGridPoints = bl;
        this.isColorSolid = true;
        this.mergeAssociatedNormalCount = 0;
        this.nSets = 0;
        this.pcs = null;
        this.showPoints = bl;
        this.surfaceSet = null;
        this.vcs = null;
        this.vertexColorMap = null;
        this.vertexIncrement = 1;
        this.vertexSets = null;
        this.vvs = null;
    }

    void allocVertexColixes() {
        if (this.vcs == null) {
            this.vcs = new short[this.vc];
            int n = this.vc;
            while (--n >= 0) {
                this.vcs[n] = this.colix;
            }
        }
        this.isColorSolid = false;
    }

    int addVertexCopy(T3 t3, float f, int n, boolean bl, boolean bl2) {
        int n2 = this.addVCVal(t3, f, bl2);
        switch (n) {
            case -1: {
                if (this.firstRealVertex >= 0) break;
                this.firstRealVertex = n2;
                break;
            }
            case -2: {
                this.hasGridPoints = true;
                break;
            }
            case -3: {
                this.vertexIncrement = 3;
                break;
            }
            default: {
                if (this.firstRealVertex < 0) {
                    this.firstRealVertex = n2;
                }
                if (!bl) break;
                if (this.assocGridPointMap == null) {
                    this.assocGridPointMap = new Hashtable<Integer, Integer>();
                }
                this.assocGridPointMap.put(n2, n + this.mergeAssociatedNormalCount);
            }
        }
        return n2;
    }

    @Override
    public void setTranslucent(boolean bl, float f) {
        this.colix = C.getColixTranslucent3(this.colix, bl, f);
        if (this.vcs != null) {
            int n = this.vc;
            while (--n >= 0) {
                this.vcs[n] = C.getColixTranslucent3(this.vcs[n], bl, f);
            }
        }
    }

    public void setMerged(boolean bl) {
        this.isMerged = bl;
        this.mergePolygonCount0 = bl ? this.pc : 0;
        int n = this.mergeVertexCount0 = bl ? this.vc : 0;
        if (bl) {
            this.mergeAssociatedNormalCount += this.jvxlData.nPointsX * this.jvxlData.nPointsY * this.jvxlData.nPointsZ;
            this.assocGridPointNormals = null;
        }
    }

    @Override
    protected void sumVertexNormals(T3[] t3Array, V3[] v3Array) {
        IsosurfaceMesh.sumVertexNormals2(this, t3Array, v3Array);
        if (this.assocGridPointMap != null && v3Array.length > 0 && !this.isMerged) {
            if (this.assocGridPointNormals == null) {
                this.assocGridPointNormals = new Hashtable<Integer, V3>();
            }
            for (Map.Entry<Integer, Integer> entry : this.assocGridPointMap.entrySet()) {
                Integer n = entry.getValue();
                if (!this.assocGridPointNormals.containsKey(n)) {
                    this.assocGridPointNormals.put(n, V3.new3(0.0f, 0.0f, 0.0f));
                }
                this.assocGridPointNormals.get(n).add(v3Array[entry.getKey()]);
            }
            for (Map.Entry<Integer, Integer> entry : this.assocGridPointMap.entrySet()) {
                v3Array[entry.getKey().intValue()] = this.assocGridPointNormals.get(entry.getValue());
            }
        }
    }

    P3[] getCenters() {
        if (this.centers != null) {
            return this.centers;
        }
        this.centers = new P3[this.pc];
        int n = 0;
        while (n < this.pc) {
            int[] nArray = this.pis[n];
            if (nArray != null) {
                P3 p3 = this.centers[n] = P3.newP(this.vs[nArray[0]]);
                p3.add(this.vs[nArray[1]]);
                p3.add(this.vs[nArray[2]]);
                p3.scale(0.33333334f);
            }
            ++n;
        }
        return this.centers;
    }

    public Lst<Object>[] getContours() {
        Lst<Object>[] lstArray;
        int n = this.jvxlData.nContours;
        if (n == 0 || this.pis == null) {
            return null;
        }
        boolean bl = this.havePlanarContours = this.jvxlData.jvxlPlane != null;
        if (this.havePlanarContours) {
            return null;
        }
        if (n < 0) {
            n = -1 - n;
        }
        if ((lstArray = this.jvxlData.vContours) != null) {
            int n2 = 0;
            while (n2 < n) {
                if (lstArray[n2].size() > 6) {
                    return this.jvxlData.vContours;
                }
                JvxlCoder.set3dContourVector(lstArray[n2], this.pis, this.vs);
                ++n2;
            }
            return this.jvxlData.vContours;
        }
        lstArray = new Lst[n];
        int n3 = 0;
        while (n3 < n) {
            lstArray[n3] = new Lst();
            ++n3;
        }
        if (this.jvxlData.contourValuesUsed == null) {
            float f = (this.jvxlData.valueMappedToBlue - this.jvxlData.valueMappedToRed) / (float)(n + 1);
            int n4 = 0;
            while (n4 < n) {
                float f2 = this.jvxlData.valueMappedToRed + (float)(n4 + 1) * f;
                IsosurfaceMesh.get3dContour(this, lstArray[n4], f2, this.jvxlData.contourColixes[n4]);
                ++n4;
            }
            Logger.info(String.valueOf(n) + " contour lines; separation = " + f);
        } else {
            n3 = 0;
            while (n3 < n) {
                float f = this.jvxlData.contourValuesUsed[n3];
                IsosurfaceMesh.get3dContour(this, lstArray[n3], f, this.jvxlData.contourColixes[n3]);
                ++n3;
            }
        }
        this.jvxlData.contourColixes = new short[n];
        this.jvxlData.contourValues = new float[n];
        int n5 = 0;
        while (n5 < n) {
            this.jvxlData.contourValues[n5] = ((Float)lstArray[n5].get(2)).floatValue();
            this.jvxlData.contourColixes[n5] = ((short[])lstArray[n5].get(3))[0];
            ++n5;
        }
        this.jvxlData.vContours = lstArray;
        return lstArray;
    }

    public Object getPmeshData(boolean bl) {
        PMeshWriter pMeshWriter = (PMeshWriter)Interface.getInterface("org.jmol.shapesurface.PMeshWriter", this.vwr, "script");
        return pMeshWriter.write(this, bl);
    }

    private static void get3dContour(IsosurfaceMesh isosurfaceMesh, Lst<Object> lst, float f, short s) {
        BS bS = BS.newN(isosurfaceMesh.pc);
        SB sB = new SB();
        int n = C.getArgb(s);
        IsosurfaceMesh.setContourVector(lst, isosurfaceMesh.pc, bS, f, s, n, sB);
        int n2 = 0;
        while (n2 < isosurfaceMesh.pc) {
            if (isosurfaceMesh.setABC(n2) != null) {
                IsosurfaceMesh.addContourPoints(lst, bS, n2, sB, isosurfaceMesh.vs, isosurfaceMesh.vvs, isosurfaceMesh.iA, isosurfaceMesh.iB, isosurfaceMesh.iC, f);
            }
            ++n2;
        }
    }

    public static void setContourVector(Lst<Object> lst, int n, BS bS, float f, short s, int n2, SB sB) {
        lst.add(0, n);
        lst.add(1, bS);
        lst.add(2, Float.valueOf(f));
        lst.add(3, new short[]{s});
        lst.add(4, new int[]{n2});
        lst.add(5, sB);
    }

    public static void addContourPoints(Lst<Object> lst, BS bS, int n, SB sB, T3[] t3Array, float[] fArray, int n2, int n3, int n4, float f) {
        float f2;
        P3 p3 = null;
        P3 p32 = null;
        int n5 = 0;
        float f3 = IsosurfaceMesh.checkPt(fArray, n2, n3, f);
        if (!Float.isNaN(f3)) {
            p3 = IsosurfaceMesh.getContourPoint(t3Array, n2, n3, f3);
            n5 |= 1;
        }
        float f4 = f2 = f3 == 1.0f ? Float.NaN : IsosurfaceMesh.checkPt(fArray, n3, n4, f);
        if (!Float.isNaN(f2)) {
            p32 = IsosurfaceMesh.getContourPoint(t3Array, n3, n4, f2);
            if (n5 == 0) {
                p3 = p32;
                f3 = f2;
            }
            n5 |= 2;
        }
        switch (n5) {
            case 0: {
                return;
            }
            case 1: {
                if (f3 == 0.0f) {
                    return;
                }
            }
            case 2: {
                float f5 = f2 = f2 == 1.0f ? Float.NaN : IsosurfaceMesh.checkPt(fArray, n4, n2, f);
                if (Float.isNaN(f2)) break;
                p32 = IsosurfaceMesh.getContourPoint(t3Array, n4, n2, f2);
                n5 |= 4;
            }
        }
        switch (n5) {
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return;
            }
        }
        bS.set(n);
        JvxlCoder.appendContourTriangleIntersection(n5, f3, f2, sB);
        lst.addLast(p3);
        lst.addLast(p32);
    }

    private static float checkPt(float[] fArray, int n, int n2, float f) {
        float f2;
        float f3 = fArray[n];
        return f == f3 ? 0.0f : (f == (f2 = fArray[n2]) ? 1.0f : (f3 < f == f < f2 ? (f - f3) / (f2 - f3) : Float.NaN));
    }

    private static P3 getContourPoint(T3[] t3Array, int n, int n2, float f) {
        P3 p3 = new P3();
        p3.sub2(t3Array[n2], t3Array[n]);
        p3.scaleAdd2(f, p3, t3Array[n]);
        return p3;
    }

    public void setDiscreteColixes(float[] fArray, short[] sArray) {
        if (fArray != null) {
            this.jvxlData.contourValues = fArray;
        }
        if (fArray == null || fArray.length == 0) {
            this.jvxlData.contourValues = this.jvxlData.contourValuesUsed;
            fArray = this.jvxlData.contourValuesUsed;
        }
        if (sArray == null && this.jvxlData.contourColixes != null) {
            sArray = this.jvxlData.contourColixes;
        } else {
            this.jvxlData.contourColixes = sArray;
            this.jvxlData.contourColors = C.getHexCodes(sArray);
        }
        if (this.vs == null || this.vvs == null || fArray == null) {
            return;
        }
        int n = fArray.length;
        float f = fArray[n - 1];
        this.colorCommand = null;
        boolean bl = sArray != null && sArray.length > 0;
        boolean bl2 = this.isColorSolid = bl && this.jvxlData.jvxlPlane != null;
        if (this.jvxlData.vContours != null) {
            if (bl) {
                int n2 = 0;
                while (n2 < this.jvxlData.vContours.length) {
                    short s;
                    ((short[])this.jvxlData.vContours[n2].get((int)3))[0] = s = sArray[n2 % sArray.length];
                    ((int[])this.jvxlData.vContours[n2].get((int)4))[0] = C.getArgb(s);
                    ++n2;
                }
            }
            return;
        }
        short s = 0;
        this.pcs = new short[this.pc];
        this.colorsExplicit = false;
        int n3 = 0;
        while (n3 < this.pc) {
            int[] nArray = this.pis[n3];
            if (nArray != null) {
                this.pcs[n3] = s;
                float f2 = (this.vvs[nArray[0]] + this.vvs[nArray[1]] + this.vvs[nArray[2]]) / 3.0f;
                int n4 = n;
                while (--n4 >= 0) {
                    if (!(f2 >= fArray[n4]) || !(f2 < f)) continue;
                    this.pcs[n3] = bl ? sArray[n4 % sArray.length] : (short)0;
                    break;
                }
            }
            ++n3;
        }
    }

    Map<String, Object> getContourList(Viewer viewer) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("values", this.jvxlData.contourValuesUsed == null ? this.jvxlData.contourValues : this.jvxlData.contourValuesUsed);
        Lst<P3> lst = new Lst<P3>();
        if (this.jvxlData.contourColixes != null) {
            int n = 0;
            while (n < this.jvxlData.contourColixes.length) {
                lst.addLast(CU.colorPtFromInt(C.getArgb(this.jvxlData.contourColixes[n]), null));
                ++n;
            }
            hashtable.put("colors", lst);
        }
        return hashtable;
    }

    void deleteContours() {
        this.jvxlData.contourValuesUsed = null;
        this.jvxlData.contourValues = null;
        this.jvxlData.contourColixes = null;
        this.jvxlData.vContours = null;
    }

    void setVertexColorMap() {
        this.vertexColorMap = new Hashtable();
        short s = -999;
        BS bS = null;
        int n = this.vc;
        while (--n >= 0) {
            String string;
            short s2 = this.vcs[n];
            if (s2 != s && (bS = (BS)this.vertexColorMap.get(string = C.getHexCode(s = s2))) == null) {
                bS = new BS();
                this.vertexColorMap.put(string, bS);
            }
            bS.set(n);
        }
    }

    void setVertexColixesForAtoms(Viewer viewer, short[] sArray, int[] nArray, BS bS) {
        this.jvxlData.vertexDataOnly = true;
        this.jvxlData.vertexColors = new int[this.vc];
        this.jvxlData.nVertexColors = this.vc;
        Atom[] atomArray = viewer.ms.at;
        GData gData = viewer.gdata;
        int n = this.mergeVertexCount0;
        while (n < this.vc) {
            int n2 = this.vertexSource[n];
            if (n2 >= 0 && bS.get(n2)) {
                short s;
                this.vcs[n] = C.copyColixTranslucency(this.colix, atomArray[n2].colixAtom);
                this.jvxlData.vertexColors[n] = gData.getColorArgbOrGray(this.vcs[n]);
                short s2 = s = sArray == null ? (short)0 : sArray[nArray[n2]];
                if (s == 0) {
                    s = atomArray[n2].colixAtom;
                }
                this.vcs[n] = C.copyColixTranslucency(this.colix, s);
            }
            ++n;
        }
    }

    void colorVertices(short s, BS bS, boolean bl) {
        int n;
        if (this.vertexSource == null) {
            return;
        }
        s = C.copyColixTranslucency(this.colix, s);
        BS bS2 = bl ? new BS() : bS;
        this.checkAllocColixes();
        if (bl) {
            n = 0;
            while (n < this.vc) {
                int n2 = this.vertexSource[n];
                if (n2 >= 0 && bS.get(n2)) {
                    this.vcs[n] = s;
                    if (bS2 != null) {
                        bS2.set(n);
                    }
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < this.vc) {
                if (bS2.get(n)) {
                    this.vcs[n] = s;
                }
                ++n;
            }
        }
        if (!bl) {
            return;
        }
        String string = C.getHexCode(s);
        if (this.vertexColorMap == null) {
            this.vertexColorMap = new Hashtable();
        }
        IsosurfaceMesh.addColorToMap(this.vertexColorMap, string, bS);
    }

    void checkAllocColixes() {
        if (this.vcs == null || this.vertexColorMap == null && this.isColorSolid) {
            this.allocVertexColixes();
        }
        this.isColorSolid = false;
    }

    private static void addColorToMap(Map<String, BS> map, String string, BS bS) {
        BS bS2 = null;
        for (Map.Entry<String, BS> entry : map.entrySet()) {
            if (entry.getKey() == string) {
                bS2 = entry.getValue();
                bS2.or(bS);
                continue;
            }
            entry.getValue().andNot(bS);
        }
        if (bS2 == null) {
            map.put(string, bS);
        }
    }

    void setJvxlColorMap(boolean bl) {
        this.jvxlData.diameter = this.diameter;
        this.jvxlData.color = C.getHexCode(this.colix);
        this.jvxlData.meshColor = this.meshColix == 0 ? null : C.getHexCode(this.meshColix);
        this.jvxlData.translucency = (this.colix & 0x7800) == 30720 ? -1.0f : C.getColixTranslucencyFractional(this.colix);
        this.jvxlData.rendering = this.getRendering().substring(1);
        String string = this.jvxlData.colorScheme = this.colorEncoder == null ? null : this.colorEncoder.getColorScheme();
        if (this.jvxlData.vertexColors == null) {
            int n = this.jvxlData.nVertexColors = this.vertexColorMap == null ? 0 : this.vertexColorMap.size();
        }
        if (this.vertexColorMap == null || this.vertexSource == null || !bl) {
            return;
        }
        if (this.jvxlData.vertexColorMap == null) {
            this.jvxlData.vertexColorMap = new Hashtable<String, BS>();
        }
        for (Map.Entry entry : this.vertexColorMap.entrySet()) {
            BS bS = (BS)entry.getValue();
            if (bS.isEmpty()) continue;
            String string2 = (String)entry.getKey();
            BS bS2 = new BS();
            int n = 0;
            while (n < this.vc) {
                if (bS.get(this.vertexSource[n])) {
                    bS2.set(n);
                }
                ++n;
            }
            IsosurfaceMesh.addColorToMap(this.jvxlData.vertexColorMap, string2, bS2);
        }
        this.jvxlData.nVertexColors = this.jvxlData.vertexColorMap.size();
        if (this.jvxlData.vertexColorMap.size() == 0) {
            this.jvxlData.vertexColorMap = null;
        }
    }

    void setColorCommand() {
        if (this.colorEncoder == null || (this.colorCommand = this.colorEncoder.getColorScheme()) == null) {
            return;
        }
        if (this.colorCommand.equals("inherit")) {
            this.colorCommand = "#inherit;";
            return;
        }
        this.colorCommand = "color $" + PT.esc(this.thisID) + PT.esc(this.colorCommand) + " range " + (this.jvxlData.isColorReversed ? String.valueOf(this.jvxlData.valueMappedToBlue) + " " + this.jvxlData.valueMappedToRed : String.valueOf(this.jvxlData.valueMappedToRed) + " " + this.jvxlData.valueMappedToBlue);
    }

    boolean setColorsFromJvxlData(int n) {
        float f;
        this.diameter = this.jvxlData.diameter;
        if (n != -1) {
            if (n != Integer.MIN_VALUE && n != Integer.MAX_VALUE) {
                this.colix = C.getColix(n);
            } else if (this.jvxlData.color != null) {
                this.colix = C.getColixS(this.jvxlData.color);
            }
        }
        if (this.colix == 0) {
            this.colix = (short)5;
        }
        this.colix = C.getColixTranslucent3(this.colix, this.jvxlData.translucency != 0.0f, this.jvxlData.translucency);
        float f2 = f = this.jvxlData.translucency == 0.0f ? Float.NaN : this.jvxlData.translucency;
        if (this.jvxlData.meshColor != null) {
            this.meshColix = C.getColixS(this.jvxlData.meshColor);
        }
        this.setJvxlDataRendering();
        boolean bl = this.isColorSolid = !this.jvxlData.isBicolorMap && this.jvxlData.vertexColors == null && this.jvxlData.vertexColorMap == null;
        if (this.colorEncoder == null) {
            return false;
        }
        if (this.jvxlData.vertexColorMap == null) {
            if (this.jvxlData.colorScheme != null) {
                String string = this.jvxlData.colorScheme;
                boolean bl2 = string.startsWith("translucent ");
                if (bl2) {
                    string = string.substring(12);
                    f = Float.NaN;
                }
                this.colorEncoder.setColorScheme(string, bl2);
                this.remapColors(null, null, f);
            }
        } else {
            if (this.jvxlData.baseColor != null) {
                int n2 = this.vc;
                while (--n2 >= 0) {
                    this.vcs[n2] = this.colix;
                }
            }
            for (Map.Entry<String, BS> entry : this.jvxlData.vertexColorMap.entrySet()) {
                BS bS = entry.getValue();
                short s = C.copyColixTranslucency(this.colix, C.getColixS(entry.getKey()));
                int n3 = bS.nextSetBit(0);
                while (n3 >= 0) {
                    this.vcs[n3] = s;
                    n3 = bS.nextSetBit(n3 + 1);
                }
            }
        }
        return true;
    }

    void setJvxlDataRendering() {
        if (this.jvxlData.rendering != null) {
            String[] stringArray = PT.getTokens(this.jvxlData.rendering);
            int n = 0;
            while (n < stringArray.length) {
                this.setTokenProperty(T.getTokFromName(stringArray[n]), true);
                ++n;
            }
        }
    }

    void remapColors(Viewer viewer, ColorEncoder colorEncoder, float f) {
        int n;
        if (colorEncoder == null) {
            colorEncoder = this.colorEncoder;
        }
        if (colorEncoder == null) {
            colorEncoder = this.colorEncoder = new ColorEncoder(null, viewer);
        }
        this.colorEncoder = colorEncoder;
        this.setColorCommand();
        if (Float.isNaN(f)) {
            f = C.getColixTranslucencyLevel(this.colix);
        } else {
            this.colix = C.getColixTranslucent3(this.colix, true, f);
        }
        float f2 = colorEncoder.lo;
        float f3 = colorEncoder.hi;
        boolean bl = this.vertexSource != null && colorEncoder.currentPalette == 15;
        this.vertexColorMap = null;
        this.pcs = null;
        this.colorsExplicit = false;
        this.jvxlData.baseColor = null;
        this.jvxlData.vertexCount = this.vc;
        if (this.vvs == null || this.jvxlData.vertexCount == 0) {
            return;
        }
        if (this.vcs == null || this.vcs.length != this.vc) {
            this.allocVertexColixes();
        }
        if (bl) {
            this.jvxlData.vertexDataOnly = true;
            this.jvxlData.vertexColors = new int[this.vc];
            this.jvxlData.nVertexColors = this.vc;
            Atom[] atomArray = viewer.ms.at;
            GData gData = viewer.gdata;
            int n2 = this.mergeVertexCount0;
            while (n2 < this.vc) {
                int n3 = this.vertexSource[n2];
                if (n3 >= 0 && n3 < atomArray.length) {
                    this.vcs[n2] = C.copyColixTranslucency(this.colix, atomArray[n3].colixAtom);
                    this.jvxlData.vertexColors[n2] = gData.getColorArgbOrGray(this.vcs[n2]);
                }
                ++n2;
            }
            return;
        }
        this.jvxlData.vertexColors = null;
        this.jvxlData.vertexColorMap = null;
        if (this.jvxlData.isBicolorMap) {
            int n4 = this.mergeVertexCount0;
            while (n4 < this.vc) {
                this.vcs[n4] = C.copyColixTranslucency(this.colix, this.vvs[n4] < 0.0f ? this.jvxlData.minColorIndex : this.jvxlData.maxColorIndex);
                ++n4;
            }
            return;
        }
        this.jvxlData.isColorReversed = colorEncoder.isReversed;
        if (f3 != Float.MAX_VALUE) {
            this.jvxlData.valueMappedToRed = f2;
            this.jvxlData.valueMappedToBlue = f3;
        }
        colorEncoder.setRange(this.jvxlData.valueMappedToRed, this.jvxlData.valueMappedToBlue, this.jvxlData.isColorReversed);
        boolean bl2 = C.isColixTranslucent(this.colix);
        if (colorEncoder.isTranslucent) {
            if (!bl2) {
                this.colix = C.getColixTranslucent3(this.colix, true, 0.5f);
            }
            bl2 = false;
        }
        this.vcs = AU.ensureLengthShort(this.vcs, this.vc);
        int n5 = this.vc;
        while (--n5 >= this.mergeVertexCount0) {
            this.vcs[n5] = colorEncoder.getColorIndex(this.vvs[n5]);
        }
        this.setTranslucent(bl2, f);
        this.colorEncoder = colorEncoder;
        Lst<Object>[] lstArray = this.getContours();
        if (lstArray != null) {
            n = lstArray.length;
            while (--n >= 0) {
                float f4 = ((Float)lstArray[n].get(2)).floatValue();
                short[] sArray = (short[])lstArray[n].get(3);
                sArray[0] = colorEncoder.getColorIndex(f4);
                int[] nArray = (int[])lstArray[n].get(4);
                nArray[0] = C.getArgb(sArray[0]);
            }
        }
        if (this.contourValues != null) {
            this.contourColixes = new short[this.contourValues.length];
            n = 0;
            while (n < this.contourValues.length) {
                this.contourColixes[n] = colorEncoder.getColorIndex(this.contourValues[n]);
                ++n;
            }
            this.setDiscreteColixes(null, null);
        }
        this.jvxlData.isJvxlPrecisionColor = true;
        JvxlCoder.jvxlCreateColorData(this.jvxlData, this.vvs);
        this.setColorCommand();
        this.isColorSolid = false;
    }

    public void reinitializeLightingAndColor(Viewer viewer) {
        this.initialize(this.lighting, null, null);
        if (this.colorEncoder != null || this.jvxlData.isBicolorMap) {
            this.vcs = null;
            this.remapColors(viewer, null, Float.NaN);
        }
    }

    @Override
    public P3[] getBoundingBox() {
        return this.jvxlData.boundingBox;
    }

    @Override
    public void setBoundingBox(P3[] p3Array) {
        this.jvxlData.boundingBox = p3Array;
    }

    protected void merge(MeshData meshData) {
        int n = this.vc + (meshData == null ? 0 : meshData.vc);
        if (this.pis == null) {
            this.pis = new int[0][0];
        }
        if (meshData != null && meshData.pis == null) {
            meshData.pis = new int[0][0];
        }
        int n2 = (this.bsSlabDisplay == null || this.pc == 0 ? this.pc : this.bsSlabDisplay.cardinality()) + (meshData == null || meshData.pc == 0 ? 0 : (meshData.bsSlabDisplay == null ? meshData.pc : meshData.bsSlabDisplay.cardinality()));
        if (this.vs == null) {
            this.vs = new P3[0];
        }
        this.vs = (T3[])AU.ensureLength(this.vs, n);
        this.vvs = AU.ensureLengthA(this.vvs, n);
        boolean bl = this.vertexSource != null && (meshData == null || meshData.vertexSource != null);
        this.vertexSource = AU.ensureLengthI(this.vertexSource, n);
        int[][] nArray = AU.newInt2(n2);
        int n3 = IsosurfaceMesh.mergePolygons(this, 0, 0, nArray);
        if (meshData != null) {
            n3 = IsosurfaceMesh.mergePolygons(meshData, n3, this.vc, nArray);
            int n4 = 0;
            while (n4 < meshData.vc) {
                this.vs[this.vc] = meshData.vs[n4];
                this.vvs[this.vc] = meshData.vvs[n4];
                if (bl) {
                    this.vertexSource[this.vc] = meshData.vertexSource[n4];
                }
                ++n4;
                ++this.vc;
            }
        }
        this.pc = this.polygonCount0 = n2;
        this.vc = this.vertexCount0 = n;
        if (n2 > 0) {
            this.resetSlab();
        }
        this.pis = nArray;
    }

    private static int mergePolygons(MeshSurface meshSurface, int n, int n2, int[][] nArray) {
        int n3 = 0;
        while (n3 < meshSurface.pc) {
            int[] nArray2 = meshSurface.pis[n3];
            if (nArray2 != null && (meshSurface.bsSlabDisplay == null || meshSurface.bsSlabDisplay.get(n3))) {
                nArray[n++] = meshSurface.pis[n3];
                if (n2 > 0) {
                    int n4 = 0;
                    while (n4 < 3) {
                        int n5 = n4++;
                        nArray2[n5] = nArray2[n5] + n2;
                    }
                }
            }
            ++n3;
        }
        return n;
    }

    @Override
    public SymmetryInterface getUnitCell() {
        return this.unitCell != null || (this.unitCell = this.vwr.ms.am[this.modelIndex].biosymmetry) != null || (this.unitCell = this.vwr.ms.getUnitCell(this.modelIndex)) != null || this.oabc != null && (this.unitCell = Interface.getSymmetry(this.vwr, "symmetry").getUnitCell(this.oabc, true, null)) != null ? this.unitCell : null;
    }

    void fixLattice() {
        if (this.getUnitCell() == null) {
            return;
        }
        P3i p3i = new P3i();
        P3i p3i2 = P3i.new3((int)this.lattice.x, (int)this.lattice.y, (int)this.lattice.z);
        this.jvxlData.fixedLattice = this.lattice;
        this.lattice = null;
        SimpleUnitCell.setMinMaxLatticeParameters((int)this.unitCell.getUnitCellInfoType(6), p3i, p3i2, 0);
        int n = (p3i2.x - p3i.x) * (p3i2.y - p3i.y) * (p3i2.z - p3i.z);
        P3 p3 = new P3();
        int n2 = this.vc;
        int n3 = n * this.vc;
        this.vs = AU.arrayCopyPt(this.vs, n3);
        this.vvs = this.vvs == null ? null : AU.ensureLengthA(this.vvs, n3);
        int n4 = this.pc;
        int n5 = n * this.pc;
        this.pis = AU.arrayCopyII(this.pis, n5);
        int n6 = 0;
        this.normixes = AU.arrayCopyShort(this.normixes, n3);
        int n7 = p3i.x;
        while (n7 < p3i2.x) {
            int n8 = p3i.y;
            while (n8 < p3i2.y) {
                int n9 = p3i.z;
                while (n9 < p3i2.z) {
                    if (n7 != 0 || n8 != 0 || n9 != 0) {
                        Object object;
                        p3.set(n7, n8, n9);
                        this.unitCell.toCartesian(p3, false);
                        int n10 = 0;
                        while (n10 < n2) {
                            this.normixes[this.vc] = this.normixes[n10];
                            object = P3.newP(this.vs[n10]);
                            ((T3)object).add(p3);
                            this.addVCVal((T3)object, this.vvs[n10], false);
                            ++n10;
                        }
                        n6 += n2;
                        n10 = 0;
                        while (n10 < n4) {
                            Object object2 = object = (Object)AU.arrayCopyI(this.pis[n10], -1);
                            object2[0] = object2[0] + n6;
                            Object object3 = object;
                            object3[1] = object3[1] + n6;
                            Object object4 = object;
                            object4[2] = object4[2] + n6;
                            this.addPolygon((int[])object, null);
                            ++n10;
                        }
                    }
                    ++n9;
                }
                ++n8;
            }
            ++n7;
        }
        P3 p32 = new P3();
        P3 p33 = new P3();
        this.setBox(p32, p33);
        this.jvxlData.boundingBox = new P3[]{p32, p33};
    }

    @Override
    protected float getMinDistance2ForVertexGrouping() {
        float f;
        if (this.jvxlData.boundingBox != null && this.jvxlData.boundingBox[0] != null && (f = this.jvxlData.boundingBox[1].distanceSquared(this.jvxlData.boundingBox[0])) < 5.0f) {
            return 1.0E-10f;
        }
        return 1.0E-8f;
    }

    @Override
    public BS getVisibleVertexBitSet() {
        BS bS = this.getVisibleVBS();
        if (this.jvxlData.thisSet >= 0) {
            int n = 0;
            while (n < this.vc) {
                if (this.vertexSets[n] != this.jvxlData.thisSet) {
                    bS.clear(n);
                }
                ++n;
            }
        }
        return bS;
    }

    public void updateCoordinates(M4 m4, BS bS) {
        boolean bl;
        boolean bl2 = bl = bS == null || this.isModelConnected;
        if (!bl) {
            int n = 0;
            while (n < this.connectedAtoms.length) {
                if (this.connectedAtoms[n] >= 0 && bS.get(this.connectedAtoms[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (!bl) {
            return;
        }
        if (this.isModelConnected) {
            this.mat4 = this.vwr.ms.am[this.modelIndex].mat4;
        } else {
            if (this.mat4 == null) {
                this.mat4 = M4.newM4(null);
            }
            this.mat4.mul2(m4, this.mat4);
        }
        this.recalcAltVertices = true;
    }

    float[] getDataMinMax() {
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        int n = this.vvs.length;
        while (--n >= 0) {
            float f3 = this.vvs[n];
            if (f3 < f) {
                f = f3;
            }
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        return new float[]{f, f2};
    }

    float[] getDataRange() {
        float[] fArray;
        if (this.jvxlData.jvxlPlane != null && this.colorEncoder == null) {
            fArray = null;
        } else {
            float[] fArray2 = new float[4];
            fArray2[0] = this.jvxlData.mappedDataMin;
            fArray2[1] = this.jvxlData.mappedDataMax;
            fArray2[2] = this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue : this.jvxlData.valueMappedToRed;
            fArray = fArray2;
            fArray2[3] = this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToBlue;
        }
        return fArray;
    }
}

