/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.datasupport;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.Base64;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class Utils {
    public static final RequestProcessor FILE_QUEUE = new RequestProcessor("File Queue");
    private static final int COPY_PACKET_SIZE = 16384;
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    public static <X, Y> boolean containsSubclass(Set<? extends Class<? extends Y>> classes, X superclassInstance) {
        for (Class<Y> classs : classes) {
            if (!classs.isInstance(superclassInstance)) continue;
            return true;
        }
        return false;
    }

    public static <X, Y> boolean containsSuperclass(Set<? extends Class<? extends Y>> classes, X subclassInstance) {
        Class<?> subclass = subclassInstance.getClass();
        for (Class<Y> classs : classes) {
            if (!classs.isAssignableFrom(subclass)) continue;
            return true;
        }
        return false;
    }

    public static <X, Y extends X, Z extends X> Set<Z> getFilteredSet(Set<Y> set, Class<Z> filter) {
        HashSet<Y> filteredSet = new HashSet<Y>();
        for (Y item : set) {
            if (!filter.isInstance(item)) continue;
            filteredSet.add(item);
        }
        return filteredSet;
    }

    public static <X extends DataSource> List<X> getSortedDataSources(Set<X> dataSources) {
        List<DataSourcePath<X>> dataSourcePaths = Utils.getSortedDataSourcePaths(dataSources);
        ArrayList<X> sortedDataSources = new ArrayList<X>();
        for (DataSourcePath<X> dataSourcePath : dataSourcePaths) {
            sortedDataSources.add(dataSourcePath.getDataSource());
        }
        return sortedDataSources;
    }

    public static <X extends DataSource> boolean areDataSourcesIndependent(Set<X> dataSources) {
        return dataSources.size() == Utils.getIndependentDataSources(dataSources).size();
    }

    public static <X extends DataSource> Set<X> getIndependentDataSources(Set<X> dataSources) {
        HashMap<Integer, HashSet<X>> independentDataSourcesMap = new HashMap<Integer, HashSet<X>>();
        List<DataSourcePath<X>> dataSourcePaths = Utils.getSortedDataSourcePaths(dataSources);
        for (DataSourcePath<X> dataSourcePath : dataSourcePaths) {
            boolean independent = true;
            for (int i = 0; i < dataSourcePath.size(); ++i) {
                DataSource dataSource = (DataSource)dataSourcePath.get(i);
                Set set = (Set)independentDataSourcesMap.get(i);
                if (set == null || !set.contains(dataSource)) continue;
                independent = false;
                break;
            }
            if (!independent) continue;
            HashSet<X> set = (HashSet<X>)independentDataSourcesMap.get(dataSourcePath.size() - 1);
            if (set == null) {
                set = new HashSet<X>();
                independentDataSourcesMap.put(dataSourcePath.size() - 1, set);
            }
            set.add(dataSourcePath.getDataSource());
        }
        HashSet independentDataSources = new HashSet();
        Collection independentSetsCollection = independentDataSourcesMap.values();
        for (Set independentSet : independentSetsCollection) {
            independentDataSources.addAll(independentSet);
        }
        return independentDataSources;
    }

    private static <X extends DataSource> List<DataSourcePath<X>> getSortedDataSourcePaths(Set<X> dataSources) {
        ArrayList<DataSourcePath<X>> dataSourcePaths = new ArrayList<DataSourcePath<X>>();
        for (DataSource dataSource : dataSources) {
            dataSourcePaths.add(new DataSourcePath<DataSource>(dataSource));
        }
        Collections.sort(dataSourcePaths);
        return dataSourcePaths;
    }

    public static String getFileBase(String fileName) {
        int extIndex = fileName.lastIndexOf(".");
        if (extIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, extIndex);
    }

    public static String getFileExt(String fileName) {
        int extIndex = fileName.lastIndexOf(".");
        if (extIndex == -1) {
            return "";
        }
        return fileName.substring(extIndex);
    }

    public static File getUniqueFile(File directory, String file) {
        return Utils.getUniqueFile(directory, Utils.getFileBase(file), Utils.getFileExt(file));
    }

    public static synchronized File getUniqueFile(File directory, String fileName, String fileExt) {
        File newFile = new File(directory, fileName + fileExt);
        while (newFile.exists()) {
            fileName = fileName + "_";
            newFile = new File(directory, fileName + fileExt);
        }
        return newFile;
    }

    public static synchronized boolean prepareDirectory(File directory) {
        if (directory.exists()) {
            return true;
        }
        directory.mkdirs();
        return directory.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File file, File copy) {
        if (file == null || copy == null) {
            throw new NullPointerException("File cannot be null");
        }
        if (!file.isFile() || copy.isDirectory()) {
            throw new IllegalArgumentException("Not a valid file");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int bytes;
            fis = new FileInputStream(file);
            fos = new FileOutputStream(copy);
            byte[] packet = new byte[16384];
            while ((bytes = fis.read(packet, 0, 16384)) != -1) {
                fos.write(packet, 0, bytes);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error copying file", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Problem closing target stream", e);
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Problem closing source stream", e);
            }
        }
    }

    public static boolean delete(File file, boolean deleteOnExit) {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Utils.delete(files[i], deleteOnExit);
            }
        }
        if (!file.delete()) {
            if (Utilities.isWindows() && file.isFile()) {
                for (int i = 0; i < 5; ++i) {
                    System.gc();
                    if (!file.delete()) continue;
                    return true;
                }
            }
            if (deleteOnExit) {
                file.deleteOnExit();
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createArchive(File directory, File archive) {
        ZipOutputStream zos = null;
        FileInputStream fis = null;
        File[] contents = directory.listFiles();
        try {
            zos = new ZipOutputStream(new FileOutputStream(archive));
            for (File file : contents) {
                if (!file.isFile()) continue;
                zos.putNextEntry(new ZipEntry(file.getName()));
                try {
                    int bytes;
                    fis = new FileInputStream(file);
                    byte[] packet = new byte[16384];
                    while ((bytes = fis.read(packet, 0, 16384)) != -1) {
                        zos.write(packet, 0, bytes);
                    }
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Problem closing archive entry stream", e);
                    }
                    if (zos != null) {
                        zos.closeEntry();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error creating archive", e);
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Problem closing archive stream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractArchive(File archive, File destination) {
        File directory = Utils.getUniqueFile(destination, archive.getName());
        ZipFile zipFile = null;
        try {
            Utils.prepareDirectory(directory);
            zipFile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                FileOutputStream fos = null;
                InputStream is = null;
                try {
                    int bytes;
                    is = zipFile.getInputStream(entry);
                    fos = new FileOutputStream(new File(directory, entry.getName()));
                    byte[] packet = new byte[16384];
                    while ((bytes = is.read(packet, 0, 16384)) != -1) {
                        fos.write(packet, 0, bytes);
                    }
                }
                finally {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Problem closing extracted file stream", e);
                    }
                    try {
                        if (is == null) continue;
                        is.close();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Problem closing zipentry stream", e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error extracting archive", e);
            File file = null;
            return file;
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Problem closing archive", e);
            }
        }
        return directory;
    }

    public static String encodePassword(String value) {
        return Base64.byteArrayToBase64(value.getBytes());
    }

    public static String decodePassword(String value) {
        return new String(Base64.base64ToByteArray(value));
    }

    public static String imageToString(Image image, String format) {
        byte[] imageBytes = Utils.imageToBytes(image, format);
        return imageBytes != null ? Base64.byteArrayToBase64(imageBytes) : null;
    }

    public static Image stringToImage(String string) {
        return Toolkit.getDefaultToolkit().createImage(Base64.base64ToByteArray(string));
    }

    private static BufferedImage imageToBuffered(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        bufferedImage.createGraphics().drawImage(image, null, null);
        return bufferedImage;
    }

    private static byte[] imageToBytes(Image image, String format) {
        BufferedImage bufferedImage = Utils.imageToBuffered(image);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, format, outputStream);
        }
        catch (Exception e) {
            LOGGER.throwing(Utils.class.getName(), "imageToBytes", e);
            return null;
        }
        return outputStream.toByteArray();
    }

    private static class DataSourcePath<X extends DataSource>
    extends ArrayList<DataSource>
    implements Comparable<DataSourcePath> {
        public DataSourcePath(X dataSource) {
            for (Object ds = dataSource; ds != null; ds = ((DataSource)ds).getOwner()) {
                this.add(0, ds);
            }
        }

        @Override
        public int compareTo(DataSourcePath dataSourcePath) {
            Integer thisSize = this.size();
            return thisSize.compareTo(dataSourcePath.size());
        }

        public X getDataSource() {
            return (X)((DataSource)this.get(this.size() - 1));
        }
    }
}

