/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif


#ifndef _POLYEDER_H_
#define _POLYEDER_H_

#ifndef _CARAT_TYPEDEF_H_
#include"typedef.h"
#endif

#ifdef __STDC__
/*-------------------------------------------------------------*\
| FILE: first_polyeder.c 
\*-------------------------------------------------------------*/
extern polyeder_TYP *first_polyeder(wall_TYP **mauern, int anz);

/*-------------------------------------------------------------*\
| FILE: polyeder_tools.c 
\*-------------------------------------------------------------*/
extern vertex_TYP *init_vertex(int dim, int wall_no) ;
extern word_TYP *init_word(int dim);
extern wall_TYP *init_wall(int dim);
extern polyeder_TYP *init_polyeder(int vert_no, int wall_no);
extern polyeder_TYP *get_polyeder(char *file_name);
extern void put_polyeder(polyeder_TYP *F);
extern int wall_times_vertex(wall_TYP *w, vertex_TYP *v);
extern void free_vertex(vertex_TYP **v);
extern void free_word(word_TYP *word);
extern void free_wall(wall_TYP **v);
extern wall_TYP *mat_to_wall(matrix_TYP *M);
extern void normal_wall(wall_TYP *v);
extern void normal_vertex(vertex_TYP *v);
extern int is_vertex_of_wallno(vertex_TYP *v, int w);
extern word_TYP *copy_word(word_TYP *w);
extern wall_TYP *copy_wall(wall_TYP *w);
extern void free_polyeder(polyeder_TYP *P);

/*-------------------------------------------------------------*\
| FILE: polyeder_to_vecs.c 
\*-------------------------------------------------------------*/
extern matrix_TYP **polyeder_to_vecs(polyeder_TYP *P);

/*-------------------------------------------------------------*\
| FILE: refine_polyeder.c 
\*-------------------------------------------------------------*/
extern int refine_polyeder(polyeder_TYP *F, wall_TYP *h);

#else
/*-------------------------------------------------------------*\
| FILE: first_polyeder.c 
\*-------------------------------------------------------------*/
extern polyeder_TYP *first_polyeder();

/*-------------------------------------------------------------*\
| FILE: polyeder_tools.c 
\*-------------------------------------------------------------*/
extern vertex_TYP *init_vertex();
extern wall_TYP *init_wall();
extern polyeder_TYP *init_polyeder();
extern polyeder_TYP *get_polyeder();
extern void put_polyeder();
extern int wall_times_vertex();
extern void free_vertex();
extern void free_word();
extern void free_wall();
extern wall_TYP *mat_to_wall();
extern void normal_wall();
extern void normal_vertex();
extern int is_vertex_of_wallno();
extern wall_TYP *copy_wall();
extern void free_polyeder();

/*-------------------------------------------------------------*\
| FILE: polyeder_to_vecs.c 
\*-------------------------------------------------------------*/
extern matrix_TYP **polyeder_to_vecs();

/*-------------------------------------------------------------*\
| FILE: refine_polyeder.c 
\*-------------------------------------------------------------*/
extern int refine_polyeder();

#endif
#endif

#ifdef __cplusplus
}
#endif

