/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif


#ifndef _SYMM_H_
#define _SYMM_H_

#ifndef _CARAT_TYPEDEF_H_
#include"typedef.h"
#endif

#ifdef __STDC__
/*-------------------------------------------------------------*\
| FILE: dsylv.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *dsylv(matrix_TYP *M);
extern int definite_test(matrix_TYP *M);

/*-------------------------------------------------------------*\
| FILE: rest_short.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *rest_short(matrix_TYP *mat, int *restvec, int rkgv,
     int zaehler, int nenner, int find_opt, int count_opt, int *anz);

/*-------------------------------------------------------------*\
| FILE: short.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *short_vectors(matrix_TYP *mat, int length,
     int lengthmin, int find_opt, int count_opt, int *anz);

/*-------------------------------------------------------------*\
| FILE: shortest.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *shortest(matrix_TYP *mat, int *min_norm);

#else
/*-------------------------------------------------------------*\
| FILE: dsylv.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *dsylv();
extern int definite_test();

/*-------------------------------------------------------------*\
| FILE: rest_short.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *rest_short();

/*-------------------------------------------------------------*\
| FILE: short.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *short_vectors();

/*-------------------------------------------------------------*\
| FILE: shortest.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *shortest();

#endif
#endif

#ifdef __cplusplus
}
#endif

