/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
#include"getput.h"
#include"bravais.h"
#include"matrix.h"

main (int argc, char *argv[])
{
  int anz,
      i,
      j,
      ggt,
      sum;

  char comment[1000];

  matrix_TYP **F;

  read_header(argc, argv);

  if((FILEANZ != 1) || (is_option('h')))
  {
    printf("Usage: %s 'file'\n",argv[0]);
    printf("\n");
    printf("file: matrix_TYP\n");
    printf("\n");
    printf("Calculates the trace of the given matrices.\n");
    if (is_option('h')){
       exit(0);
    }
    else{
       exit(31);
    }
  }

  F = mget_mat(FILENAMES[0],&anz);

  printf("#%d\n",anz);

  for (i=0;i<anz;i++){
     Check_mat(F[i]);
     rat2kgv(F[i]);

     if (F[i]->rows != F[i]->cols){
        printf("Trace of a non square matrix?\n");
        exit(3);
     }
     else{
       sum = 0;
       for (j=0;j<F[i]->cols;j++){
         sum = sum + F[i]->array.SZ[j][j];
       }
       if (!F[i]->flags.Integral){
         ggt = GGT(sum,F[i]->kgv);
         if (abs(F[i]->kgv)==ggt){
            printf("Trace of the %d-th matrix in %s: %d\n",
                i+1,FILENAMES[0],sum/ggt*(F[i]->kgv/ggt));
         }
         else{
            printf("Trace of the %d-th matrix in %s: %d/%d\n",
                 i+1,FILENAMES[0],sum/ggt,F[i]->kgv/ggt);
         }
       }
       else{
         printf("Trace of the %d-th matrix in %s: %d\n",i+1,FILENAMES[0],sum);
       }
     }
  }

  exit(0);
}
