/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.el.impl.lang;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdesktop.el.ELContext;
import org.jdesktop.el.ELResolver;
import org.jdesktop.el.Expression;
import org.jdesktop.el.FunctionMapper;
import org.jdesktop.el.VariableMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EvaluationContext
extends ELContext {
    private final ELContext elContext;
    private final FunctionMapper fnMapper;
    private final VariableMapper varMapper;
    private final Expression expression;
    private final Set<Expression.ResolvedProperty> currentIdentifierProperties;
    private final Set<Expression.ResolvedProperty> resolvedProperties;

    public EvaluationContext(ELContext elContext, FunctionMapper fnMapper, VariableMapper varMapper, Expression expression) {
        this(elContext, fnMapper, varMapper, expression, false);
    }

    public EvaluationContext(ELContext elContext, FunctionMapper fnMapper, VariableMapper varMapper, Expression expression, boolean trackResolvedProperties) {
        this.elContext = elContext;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
        this.expression = expression;
        if (trackResolvedProperties) {
            this.resolvedProperties = new LinkedHashSet<Expression.ResolvedProperty>(1);
            this.currentIdentifierProperties = new LinkedHashSet<Expression.ResolvedProperty>(1);
        } else {
            this.resolvedProperties = null;
            this.currentIdentifierProperties = null;
        }
    }

    public ELContext getELContext() {
        return this.elContext;
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return this.fnMapper;
    }

    @Override
    public VariableMapper getVariableMapper() {
        return this.varMapper;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public Object getContext(Class key) {
        return this.elContext.getContext(key);
    }

    @Override
    public ELResolver getELResolver() {
        return this.elContext.getELResolver();
    }

    @Override
    public boolean isPropertyResolved() {
        return this.elContext.isPropertyResolved();
    }

    @Override
    public void putContext(Class key, Object contextObject) {
        this.elContext.putContext(key, contextObject);
    }

    @Override
    public void setPropertyResolved(boolean resolved) {
        this.elContext.setPropertyResolved(resolved);
    }

    public void clearResolvedProperties() {
        if (this.resolvedProperties == null) {
            return;
        }
        this.resolvedProperties.clear();
    }

    public void resolvedIdentifier(Object base, Object property) {
        if (base == null || property == null || this.resolvedProperties == null) {
            return;
        }
        this.resolvedProperties.addAll(this.currentIdentifierProperties);
        this.currentIdentifierProperties.clear();
        Expression.ResolvedProperty prop = new Expression.ResolvedProperty(base, property);
        this.resolvedProperties.remove(prop);
        this.currentIdentifierProperties.add(prop);
    }

    public void resolvedProperty(Object base, Object property) {
        if (base == null || property == null || this.resolvedProperties == null) {
            return;
        }
        Expression.ResolvedProperty prop = new Expression.ResolvedProperty(base, property);
        this.resolvedProperties.remove(prop);
        this.currentIdentifierProperties.add(prop);
    }

    public List<Expression.ResolvedProperty> getResolvedProperties() {
        if (this.resolvedProperties == null) {
            return null;
        }
        this.resolvedProperties.addAll(this.currentIdentifierProperties);
        return new ArrayList<Expression.ResolvedProperty>(this.resolvedProperties);
    }
}

