/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.event;

import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.util.filter.AndFilter;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;
import org.apache.ivy.util.filter.NotFilter;
import org.apache.ivy.util.filter.OrFilter;

public class IvyEventFilter
implements Filter {
    private static final String NOT = "NOT ";
    private static final String OR = " OR ";
    private static final String AND = " AND ";
    private PatternMatcher matcher;
    private Filter nameFilter;
    private Filter attFilter;

    public IvyEventFilter(String event, String filterExpression, PatternMatcher matcher) {
        PatternMatcher patternMatcher = this.matcher = matcher == null ? ExactPatternMatcher.INSTANCE : matcher;
        if (event == null) {
            this.nameFilter = NoFilter.INSTANCE;
        } else {
            final Matcher eventNameMatcher = this.matcher.getMatcher(event);
            this.nameFilter = new Filter(){

                @Override
                public boolean accept(Object o) {
                    IvyEvent e = (IvyEvent)o;
                    return eventNameMatcher.matches(e.getName());
                }
            };
        }
        this.attFilter = filterExpression == null || filterExpression.trim().length() == 0 ? NoFilter.INSTANCE : this.parseExpression(filterExpression);
    }

    private Filter parseExpression(String filterExpression) {
        int index = (filterExpression = filterExpression.trim()).indexOf(AND);
        if (index == -1) {
            index = filterExpression.indexOf(OR);
            if (index == -1) {
                if (filterExpression.startsWith(NOT)) {
                    return new NotFilter(this.parseExpression(filterExpression.substring(NOT.length())));
                }
                index = filterExpression.indexOf("=");
                if (index == -1) {
                    throw new IllegalArgumentException("bad filter expression: " + filterExpression + ": no equal sign found");
                }
                final String attname = filterExpression.substring(0, index).trim();
                String[] values = filterExpression.substring(index + 1).trim().split(",");
                final Matcher[] matchers = new Matcher[values.length];
                for (int i = 0; i < values.length; ++i) {
                    matchers[i] = this.matcher.getMatcher(values[i].trim());
                }
                return new Filter(){

                    @Override
                    public boolean accept(Object o) {
                        IvyEvent e = (IvyEvent)o;
                        String val = (String)e.getAttributes().get(attname);
                        if (val == null) {
                            return false;
                        }
                        for (int i = 0; i < matchers.length; ++i) {
                            if (!matchers[i].matches(val)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return new OrFilter(this.parseExpression(filterExpression.substring(0, index)), this.parseExpression(filterExpression.substring(index + OR.length())));
        }
        return new AndFilter(this.parseExpression(filterExpression.substring(0, index)), this.parseExpression(filterExpression.substring(index + AND.length())));
    }

    @Override
    public boolean accept(Object o) {
        if (!(o instanceof IvyEvent)) {
            return false;
        }
        return this.nameFilter.accept(o) && this.attFilter.accept(o);
    }
}

