/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.osmand.util.MapUtils;

public class GeoPointParserUtil {
    public static void main(String[] args) {
        String[] unparsableUrls;
        String[] urls;
        String[] twoQueryParameters;
        String[] oneQueryParameter;
        String[] noQueryParameters;
        int ilat = 34;
        int ilon = -106;
        double dlat = 34.99393;
        double dlon = -106.61568;
        double longLat = 34.993933029174805;
        double longLon = -106.61568069458008;
        String name = "Treasure Island";
        int z = -1;
        for (String s : noQueryParameters = new String[]{"geo:0,0", "geo:0,0?", "http://download.osmand.net/go", "http://download.osmand.net/go?"}) {
            URI uri = URI.create(s);
            Map<String, String> map = GeoPointParserUtil.getQueryParameters(uri);
            System.out.print(s + " map: " + map.size() + "...");
            if (map.size() != 0) {
                System.out.println("");
                throw new RuntimeException("Map should be 0 but is " + map.size());
            }
            System.out.println(" Passed!");
        }
        for (String s : oneQueryParameter = new String[]{"geo:0,0?m", "geo:0,0?m=", "geo:0,0?m=foo", "geo:0,0?q=%D0%9D%D0", "http://download.osmand.net/go?lat", "http://download.osmand.net/go?lat=", "http://download.osmand.net/go?lat=34.99393"}) {
            URI uri = URI.create(s);
            Map<String, String> map = GeoPointParserUtil.getQueryParameters(uri);
            System.out.print(s + " map: " + map.size() + "...");
            if (map.size() != 1) {
                System.out.println("");
                throw new RuntimeException("Map should be 1 but is " + map.size());
            }
            System.out.println(" Passed!");
        }
        for (String s : twoQueryParameters = new String[]{"geo:0,0?z=11&q=Lots+Of+Stuff", "http://osmand.net/go?lat=34.99393&lon=-110.12345", "http://www.osmand.net/go.html?lat=34.99393&lon=-110.12345", "http://download.osmand.net/go?lat=34.99393&lon=-110.12345", "http://download.osmand.net/go?lat=34.99393&lon=-110.12345#this+should+be+ignored"}) {
            URI uri = URI.create(s);
            Map<String, String> map = GeoPointParserUtil.getQueryParameters(uri);
            System.out.print(s + " map: " + map.size() + "...");
            if (map.size() != 2) {
                System.out.println("");
                throw new RuntimeException("Map should be 2 but is " + map.size());
            }
            System.out.println(" Passed!");
        }
        String url = "geo:34,-106";
        System.out.println("url: " + url);
        GeoParsedPoint actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertUrlEquals(url, actual.getGeoUriString());
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0));
        url = "geo:34.99393,-106.61568";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertUrlEquals(url, actual.getGeoUriString());
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568));
        z = 11;
        url = "geo:34.99393,-106.61568?z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertUrlEquals(url, actual.getGeoUriString());
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "geo:34.99393,-106.61568 (Treasure Island)";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, "Treasure Island"));
        z = 11;
        url = "geo:34.99393,-106.61568?z=" + z + " (" + "Treasure Island" + ")";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z, "Treasure Island"));
        z = -1;
        url = "geo:34.99393,-106.61568?q=34.99393%2C-106.61568 (Treasure Island)";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z, "Treasure Island"));
        z = -1;
        url = "geo:34.99393,-106.61568?q=34.99393,-106.61568(" + URLEncoder.encode("Treasure Island") + ")";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z, "Treasure Island"));
        GeoPointParserUtil.assertUrlEquals(url, actual.getGeoUriString());
        z = -1;
        url = "geo:0,0?q=34,-106(Treasure Island)";
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z, "Treasure Island"));
        z = -1;
        url = "geo:0,0?q=34.99393,-106.61568(Treasure Island)";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z, "Treasure Island"));
        z = 11;
        url = "geo:0,0?z=" + z + "&q=" + 34.99393 + "," + -106.61568 + " (" + "Treasure Island" + ")";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z, "Treasure Island"));
        z = 11;
        url = "geo:0,0?z=" + z + "&q=" + 34.99393 + "," + -106.61568;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        String qstr = "760 West Genesee Street Syracuse NY 13204";
        url = "geo:0,0?q=" + URLEncoder.encode(qstr);
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(qstr));
        GeoPointParserUtil.assertUrlEquals(url, actual.getGeoUriString());
        qstr = "760 West Genesee Street Syracuse NY 13204";
        url = "geo:0,0?q=" + qstr;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(qstr));
        qstr = "1600 Amphitheatre Parkway, CA";
        url = "geo:0,0?q=" + URLEncoder.encode(qstr);
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(qstr));
        GeoPointParserUtil.assertUrlEquals(url, actual.getGeoUriString());
        qstr = "1600 Amphitheatre Parkway, CA";
        url = "geo:0,0?z=11&q=" + URLEncoder.encode(qstr);
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(qstr));
        z = 15;
        String qname = "Kiev";
        double qlat = 50.4513;
        double qlon = 30.5699;
        url = "geo:50.451300,30.569900?z=15&q=50.451300,30.569900 (Kiev)";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(qlat, qlon, z, qname));
        z = -1;
        qlat = 50.4513;
        qlon = 30.5699;
        url = "geo:0,0?q=" + qlat + "%2C%20" + qlon;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(qlat, qlon, z, null));
        url = "http://download.osmand.net/go?lat=34&lon=-106&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        url = "http://download.osmand.net/go?lat=34.99393&lon=-106.61568&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "http://www.osmand.net/go.html?lat=34&lon=-106&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        url = "http://maps.google.com/maps?q=N34.99393,E" + Math.abs(-106.61568);
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -Math.abs(-106.61568)));
        url = "http://www.osmand.net/go.html?lat=34.99393&lon=-106.61568&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "http://osmand.net/go?lat=34&lon=-106&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        url = "http://osmand.net/go?lat=34.99393&lon=-106.61568&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = 11;
        url = "http://openstreetmap.org/#map=" + z + "/" + 34 + "/" + -106;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        url = "http://openstreetmap.org/#map=" + z + "/" + 34.99393 + "/" + -106.61568;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "http://openstreetmap.org/#" + z + "/" + 34.99393 + "/" + -106.61568;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "https://www.openstreetmap.org/#map=" + z + "/" + 34.99393 + "/" + -106.61568;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "https://www.openstreetmap.org/?mlat=34.993933029174805&mlon=-106.61568069458008#map=" + z + "/" + 34.99393 + "/" + -106.61568;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = 15;
        url = "http://osm.org/go/TyFYuF6P--?m=";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertApproximateGeoPoint(actual, new GeoParsedPoint(34.993933029174805, -106.61568069458008, z));
        z = 3;
        url = "http://osm.org/go/TyFS--";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertApproximateGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = 20;
        url = "http://osm.org/go/TyFYuF6P~~-?m";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertApproximateGeoPoint(actual, new GeoParsedPoint(34.993933029174805, -106.61568069458008, z));
        z = 21;
        url = "http://osm.org/go/TyFYuF6P@@--?m=";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertApproximateGeoPoint(actual, new GeoParsedPoint(34.993933029174805, -106.61568069458008, z));
        z = 11;
        url = "http://openstreetmap.de/zoom=" + z + "&lat=" + 34 + "&lon=" + -106;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        url = "http://openstreetmap.de/zoom=" + z + "&lat=" + 34.99393 + "&lon=" + -106.61568;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "http://openstreetmap.de/lat=34.99393&lon=-106.61568&zoom=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "http://maps.google.com/maps/@34,-106," + z + "z";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        url = "http://maps.google.com/maps/@34.99393,-106.61568," + z + "z";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "http://maps.google.com/maps/ll=34,-106,z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        url = "http://maps.google.com/maps/ll=34.99393,-106.61568,z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "http://www.google.com/maps/?q=loc:34,-106&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        url = "http://www.google.com/maps/?q=loc:34.99393,-106.61568&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "https://www.google.com/maps/preview#!q=paris&data=!4m15!2m14!1m13!1s0x47e66e1f06e2b70f%3A0x40b82c3688c9460!3m8!1m3!1d24383582!2d-95.677068!3d37.0625!3m2!1i1222!2i718!4f13.1!4m2!3d48.856614!4d2.3522219";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint("paris"));
        url = "http://maps.google.com/maps/q=loc:34,-106&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        url = "http://maps.google.com/maps/q=loc:34.99393,-106.61568&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "http://maps.google.com/maps/q=loc:34,-106 (You)";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        z = -1;
        url = "http://maps.google.com/maps/q=loc:34.99393,-106.61568 (You)";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "https://maps.google.com/maps?q=loc:34.99393,-106.61568 (You)";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "https://maps.google.com/maps?q=loc:34.99393,-106.61568 (USER NAME)";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "https://maps.google.com/maps?q=loc:34.99393,-106.61568 (+55 99 99999-9999)";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "https://maps.google.com/maps?q=loc:34.99393,-106.61568/data=!4m4!2m3!3m1!2s-23.2776,-45.8443128!4b1";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "http://www.google.com/maps/search/food/34,-106," + z + "z";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        url = "http://www.google.com/maps/search/food/34.99393,-106.61568," + z + "z";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "http://maps.google.com?saddr=Current+Location&daddr=34,-106";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        z = -1;
        url = "http://maps.google.com?saddr=Current+Location&daddr=34.99393,-106.61568";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "http://www.google.com/maps/dir/Current+Location/34,-106";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        z = -1;
        url = "http://www.google.com/maps/dir/Current+Location/34.99393,-106.61568";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "http://maps.google.com/maps?q=34,-106";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        z = -1;
        url = "http://maps.google.com/maps?q=34.99393,-106.61568";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "http://maps.google.co.uk/?q=34.99393,-106.61568";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "http://www.google.com.tr/maps?q=34.99393,-106.61568";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "http://maps.google.com/maps?lci=com.google.latitudepublicupdates&ll=34.99393%2C-106.61568&q=34.99393%2C-106.61568((34.99393%2C%20-106.61568))";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = 17;
        url = "https://www.google.com/maps/place/34%C2%B059'38.1%22N+106%C2%B036'56.5%22W/@34.99393,-106.61568," + z + "z/data=!3m1!4b1!4m2!3m1!1s0x0:0x0";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        qstr = "760 West Genesee Street Syracuse NY 13204";
        url = "http://www.google.com/maps/place/" + URLEncoder.encode(qstr);
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(qstr));
        qstr = "760 West Genesee Street Syracuse NY 13204";
        url = "http://www.google.com/maps?q=" + URLEncoder.encode(qstr);
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(qstr));
        qstr = "760 West Genesee Street Syracuse NY 13204";
        url = "http://www.google.com/maps?daddr=" + URLEncoder.encode(qstr);
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(qstr));
        qstr = "760 West Genesee Street Syracuse NY 13204";
        url = "http://www.google.com/maps/dir/Current+Location/" + URLEncoder.encode(qstr);
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(qstr));
        z = 11;
        url = "http://maps.yandex.ru/?ll=34,-106&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.0, -106.0, z));
        z = 11;
        url = "http://maps.yandex.ru/?ll=34.99393,-106.61568&z=" + z;
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = 7;
        int latint = 3499393;
        int lonint = -10661568;
        url = "http://map.baidu.com/?l=" + z + "&tn=B_NORMAL_MAP&c=" + latint + "," + lonint + "&s=gibberish";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = 13;
        url = "http://www.amap.com/#!poi!!q=34.99393,-106.61568|2|%E5%AE%BE%E9%A6%86&radius=1000";
        System.out.println("\nurl: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "http://www.amap.com/?q=34.99393,-106.61568,%E4%B8%8A%E6%B5v%B7%E5%B8%82%E6%B5%A6%E4%B8%9C%E6%96%B0%E5%8C%BA%E4%BA%91%E5%8F%B0%E8%B7%AF8086";
        System.out.println("\nurl: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        url = "http://share.here.com/l/34.99393,-106.61568,Hannah-Arendt-Stra%C3%9Fe?z=" + z + "&t=normal";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = 16;
        url = "https://www.here.com/location?map=34.99393,-106.61568," + z + ",normal&msg=Hannah-Arendt-Stra%C3%9Fe";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = 16;
        url = "https://www.here.com/?map=34.99393,-106.61568," + z + ",normal";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = -1;
        url = "http://map.wap.qq.com/loc/detail.jsp?sid=AU8f3ck87L6XDmytunBm4iWg&g_ut=2&city=%E5%8C%97%E4%BA%AC&key=NOBU%20Beijing&x=-106.61568&y=34.99393&md=10461366113386140862";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = 11;
        url = "http://map.qq.com/AppBox/print/?t=&c=%7B%22base%22%3A%7B%22l%22%3A11%2C%22lat%22%3A34.99393%2C%22lng%22%3A-106.61568%7D%7D";
        System.out.println("url: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        z = 11;
        url = "http://maps.apple.com/?ll=34.99393,-106.61568&z=" + z;
        System.out.println("\nurl: " + url);
        actual = GeoPointParserUtil.parse(url);
        GeoPointParserUtil.assertGeoPoint(actual, new GeoParsedPoint(34.99393, -106.61568, z));
        for (String u : urls = new String[]{"https://openstreetmap.org/go/0LQ127-?m", "http://osm.org/go/0LQ127-?m", "http://osm.org/go/0EEQjE==", "http://osm.org/go/0EEQjEEb", "http://osm.org/go/0EE~jEEb", "http://osm.org/go/0EE@jEEb", "http://osm.org/go/~~~~", "http://osm.org/go/@@@@", "https://www.openstreetmap.org/#map=0/0/0", "https://www.openstreetmap.org/#map=0/180/180", "https://www.openstreetmap.org/#map=0/-180/-180", "https://www.openstreetmap.org/#map=0/180.0/180.0", "https://www.openstreetmap.org/#map=6/33.907/34.662", "https://www.openstreetmap.org/?mlat=49.56275939941406&mlon=17.291107177734375#map=8/49.563/17.291", "https://www.google.at/maps/place/Bargou,+Tunesien/@36.0922506,9.5676327,15z/data=!3m1!4b1!4m2!3m1!1s0x12fc5d0b4dc5e66f:0xbd3618c6193d14cd", "http://www.amap.com/#!poi!!q=38.174596,114.995033,%E6%B2%B3%E5%8C%97%E7%9C%81%E7%9F%B3%E5%AE%B6%E5%BA%84%E5%B8%82%E6%97%A0%E6%9E%81%E5%8E%BF", "http://wb.amap.com/?p=B013706PJN,38.179456,114.98577,%E6%96%B0%E4%B8%9C%E6%96%B9%E5%A4%A7%E9%85%92%E5%BA%97(%E4%BF%9D%E9%99%A9%E8%8A%B1...,%E5%BB%BA%E8%AE%BE%E8%B7%AF67%E5%8F%B7", "http://www.amap.com/#!poi!!q=38.179456,114.98577|3|B013706PJN", "http://www.amap.com/#!poi!!q=38.174596,114.995033|2|%E5%AE%BE%E9%A6%86&radius=1000", "http://www.amap.com/?p=B013704EJT,38.17914,114.976337,%E6%97%A0%E6%9E%81%E5%8E%BF%E4%BA%BA%E6%B0%91%E6%94%BF%E5%BA%9C,%E5%BB%BA%E8%AE%BE%E4%B8%9C%E8%B7%AF12%E5%8F%B7", "http://share.here.com/l/52.5134272,13.3778416,Hannah-Arendt-Stra%C3%9Fe?z=16.0&t=normal", "https://www.here.com/location?map=52.5134272,13.3778416,16,normal&msg=Hannah-Arendt-Stra%C3%9Fe", "https://www.here.com/?map=48.23145,16.38454,15,normal", "http://map.wap.qq.com/loc/detail.jsp?sid=AU8f3ck87L6XDmytunBm4iWg&g_ut=2&city=%E5%8C%97%E4%BA%AC&key=NOBU%20Beijing&x=116.48177&y=39.91082&md=10461366113386140862", "http://map.wap.qq.com/loc/d.jsp?c=113.275020,39.188380&m=113.275020,39.188380&n=%E9%BC%93%E6%A5%BC&a=%E5%B1%B1%E8%A5%BF%E7%9C%81%E5%BF%BB%E5%B7%9E%E5%B8%82%E7%B9%81%E5%B3%99%E5%8E%BF+&p=+&i=16959367104973338386&z=0", "http://map.wap.qq.com/loc/d.jsp?c=113.275020,39.188380&m=113.275020,39.188380&n=%E9%BC%93%E6%A5%BC&a=%E5%B1%B1%E8%A5%BF%E7%9C%81%E5%BF%BB%E5%B7%9E%E5%B8%82%E7%B9%81%E5%B3%99%E5%8E%BF+&p=+&i=16959367104973338386&z=0&m", "http://map.qq.com/AppBox/print/?t=&c=%7B%22base%22%3A%7B%22l%22%3A11%2C%22lat%22%3A39.90403%2C%22lng%22%3A116.407526%7D%7D", "http://maps.yandex.com/?text=Australia%2C%20Victoria%2C%20Christmas%20Hills&sll=145.319026%2C-37.650344&ll=145.319026%2C-37.650344&spn=0.352249%2C0.151501&z=12&l=map", "http://maps.apple.com/?q=Bargou,+Tunisien", "http://maps.apple.com/?daddr=Bargou,+Tunisien", "http://maps.apple.com/?lsp=7618&q=40.738065,-73.988898&sll=40.738065,-73.988898", "http://maps.apple.com/?lsp=9902&auid=13787349062281695774&sll=40.694576,-73.982992&q=Garden%20Nail%20%26%20Spa&hnear=325%20Gold%20St%2C%20Brooklyn%2C%20NY%20%2011201-3054%2C%20United%20States", "https://www.google.com/maps/place/Wild+Herb+Market/@33.32787,-105.66291,14z/data=!4m5!1m2!2m1!1sfood!3m1!1s0x86e1ce2079e1f94b:0x1d7460465dcaf3ed", "http://www.google.com/maps/search/food/@34,-106,14z", "http://www.google.com/maps/search/food/@34.99393,-106.61568,14z"}) {
            System.out.println("url: " + u);
            actual = GeoPointParserUtil.parse(u);
            if (actual == null) {
                throw new RuntimeException(u + " not parsable!");
            }
            System.out.println("Properly parsed as: " + actual.getGeoUriString());
        }
        for (String u : unparsableUrls = new String[]{"http://maps.yandex.ru/-/CVCw6M9g", "http://maps.yandex.com/-/CVCXEKYW", "http://goo.gl/maps/Cji0V", "http://amap.com/0F0i02", "http://j.map.baidu.com/oXrVz", "http://l.map.qq.com/9741483212?m", "http://map.qq.com/?l=261496722", "http://her.is/vLCEXE"}) {
            System.out.println("url: " + u);
            actual = GeoPointParserUtil.parse(u);
            if (actual != null) {
                throw new RuntimeException(u + " not parsable, but parse did not return null!");
            }
            System.out.println("Handled URL");
        }
    }

    private static boolean areCloseEnough(double a, double b, long howClose) {
        long bRounded;
        long aRounded = Math.round(a * Math.pow(10.0, howClose));
        return aRounded == (bRounded = Math.round(b * Math.pow(10.0, howClose)));
    }

    private static void assertGeoPoint(GeoParsedPoint actual, GeoParsedPoint expected) {
        if (expected.getQuery() != null) {
            if (!expected.getQuery().equals(actual.getQuery())) {
                throw new RuntimeException("Query param not equal:\n'" + actual.getQuery() + "' != '" + expected.getQuery());
            }
        } else {
            double aLat = actual.getLatitude();
            double eLat = expected.getLatitude();
            double aLon = actual.getLongitude();
            double eLon = expected.getLongitude();
            int aZoom = actual.getZoom();
            int eZoom = expected.getZoom();
            String aLabel = actual.getLabel();
            String eLabel = expected.getLabel();
            if (eLabel != null && !aLabel.equals(eLabel)) {
                throw new RuntimeException("Point label is not equal; actual=" + aLabel + ", expected=" + eLabel);
            }
            if (!GeoPointParserUtil.areCloseEnough(eLat, aLat, 5L)) {
                throw new RuntimeException("Latitude is not equal; actual=" + aLat + ", expected=" + eLat);
            }
            if (!GeoPointParserUtil.areCloseEnough(eLon, aLon, 5L)) {
                throw new RuntimeException("Longitude is not equal; actual=" + aLon + ", expected=" + eLon);
            }
            if (eZoom != aZoom) {
                throw new RuntimeException("Zoom is not equal; actual=" + aZoom + ", expected=" + eZoom);
            }
        }
        System.out.println("Passed: " + actual);
    }

    private static void assertApproximateGeoPoint(GeoParsedPoint actual, GeoParsedPoint expected) {
        if (expected.getQuery() != null) {
            if (!expected.getQuery().equals(actual.getQuery())) {
                throw new RuntimeException("Query param not equal");
            }
        } else {
            double aLat = actual.getLatitude();
            double eLat = expected.getLatitude();
            double aLon = actual.getLongitude();
            double eLon = expected.getLongitude();
            int aZoom = actual.getZoom();
            int eZoom = expected.getZoom();
            String aLabel = actual.getLabel();
            String eLabel = expected.getLabel();
            if (eLabel != null && !aLabel.equals(eLabel)) {
                throw new RuntimeException("Point label is not equal; actual=" + aLabel + ", expected=" + eLabel);
            }
            if ((int)eLat != (int)aLat) {
                throw new RuntimeException("Latitude is not equal; actual=" + aLat + ", expected=" + eLat);
            }
            if ((int)eLon != (int)aLon) {
                throw new RuntimeException("Longitude is not equal; actual=" + aLon + ", expected=" + eLon);
            }
            if (eZoom != aZoom) {
                throw new RuntimeException("Zoom is not equal; actual=" + aZoom + ", expected=" + eZoom);
            }
        }
        System.out.println("Passed!");
    }

    private static void assertUrlEquals(String actual, String expected) {
        if (actual == null || !actual.equals(expected)) {
            throw new RuntimeException("URLs not equal; actual=" + actual + ", expected=" + expected);
        }
    }

    private static String getQueryParameter(String param, URI uri) {
        String query = uri.getQuery();
        String value = null;
        if (query != null && query.contains(param)) {
            String[] params;
            for (String p : params = query.split("&")) {
                if (!p.contains(param)) continue;
                value = p.substring(p.indexOf("=") + 1, p.length());
                break;
            }
        }
        return value;
    }

    private static Map<String, String> getQueryParameters(URI uri) {
        String query = null;
        if (uri.isOpaque()) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int pos = schemeSpecificPart.indexOf("?");
            if (pos == schemeSpecificPart.length()) {
                query = "";
            } else if (pos > -1) {
                query = schemeSpecificPart.substring(pos + 1);
            }
        } else {
            query = uri.getRawQuery();
        }
        return GeoPointParserUtil.getQueryParameters(query);
    }

    private static Map<String, String> getQueryParameters(String query) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (query != null && !query.equals("")) {
            String[] params;
            for (String p : params = query.split("[&/]")) {
                String[] keyValue = p.split("=");
                if (keyValue.length == 1) {
                    map.put(keyValue[0], "");
                    continue;
                }
                if (keyValue.length <= 1) continue;
                map.put(keyValue[0], URLDecoder.decode(keyValue[1]));
            }
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GeoParsedPoint parse(String uriString) {
        int n;
        String[] key;
        String searchRequest;
        int zoom;
        double lon;
        double lat;
        Pattern positionPattern;
        String name;
        block83: {
            int pref3;
            String[] stringArray;
            String label;
            String z;
            String y;
            String x;
            Map<String, String> params;
            block82: {
                int i;
                String[] patterns;
                String subString;
                block81: {
                    int zoom22;
                    int postf2;
                    String[] m;
                    Map<String, String> params2;
                    String path;
                    block80: {
                        String positionPart;
                        String schemeSpecific;
                        URI uri;
                        System.out.println("parse(uriString=" + uriString + ")");
                        try {
                            uri = URI.create(uriString.replaceAll("\\s+", "+").replaceAll("%20", "+").replaceAll("%2C", ",").replaceAll("\\|", ";").replaceAll("\\(\\(\\S+\\)\\)", ""));
                        }
                        catch (IllegalArgumentException e) {
                            return null;
                        }
                        String scheme = uri.getScheme();
                        if (scheme == null) {
                            return null;
                        }
                        if ("http".equals(scheme = scheme.toLowerCase(Locale.US)) || "https".equals(scheme)) {
                            String host = uri.getHost();
                            if (host == null) {
                                return null;
                            }
                            host = host.toLowerCase(Locale.US);
                            path = uri.getPath();
                            if (path == null) {
                                path = "";
                            }
                            String fragment = uri.getFragment();
                            HashSet<String> simpleDomains = new HashSet<String>();
                            simpleDomains.add("osmand.net");
                            simpleDomains.add("www.osmand.net");
                            simpleDomains.add("download.osmand.net");
                            simpleDomains.add("openstreetmap.de");
                            simpleDomains.add("www.openstreetmap.de");
                            Pattern commaSeparatedPairPattern = Pattern.compile("(?:loc:)?([N|S]?[+-]?\\d+(?:\\.\\d+)?),([E|W]?[+-]?\\d+(?:\\.\\d+)?)");
                            try {
                                Matcher matcher;
                                Matcher matcher2;
                                String ll;
                                if (host.equals("osm.org") || host.endsWith("openstreetmap.org")) {
                                    String mlon;
                                    String mlat;
                                    if (path.startsWith("/go/")) {
                                        Pattern p = Pattern.compile("^/go/([A-Za-z0-9_@~]+-*)(?:.*)");
                                        Matcher matcher3 = p.matcher(path);
                                        if (!matcher3.matches()) return null;
                                        return MapUtils.decodeShortLinkString(matcher3.group(1));
                                    }
                                    double lat2 = 0.0;
                                    double lon2 = 0.0;
                                    int zoom3 = -1;
                                    if (fragment != null) {
                                        String[] vls;
                                        if (fragment.startsWith("map=")) {
                                            fragment = fragment.substring("map=".length());
                                        }
                                        if ((vls = fragment.split("/")).length >= 3) {
                                            zoom3 = GeoPointParserUtil.parseZoom(vls[0]);
                                            lat2 = GeoPointParserUtil.parseSilentDouble(vls[1]);
                                            lon2 = GeoPointParserUtil.parseSilentDouble(vls[2]);
                                        }
                                    }
                                    if ((mlat = GeoPointParserUtil.getQueryParameter("mlat", uri)) != null) {
                                        lat2 = GeoPointParserUtil.parseSilentDouble(mlat);
                                    }
                                    if ((mlon = GeoPointParserUtil.getQueryParameter("mlon", uri)) == null) return new GeoParsedPoint(lat2, lon2, zoom3);
                                    lon2 = GeoPointParserUtil.parseSilentDouble(mlon);
                                    return new GeoParsedPoint(lat2, lon2, zoom3);
                                }
                                if (host.startsWith("map.baidu.")) {
                                    Map<String, String> params3 = GeoPointParserUtil.getQueryParameters(uri);
                                    String zm = params3.get("l");
                                    String[] vls = GeoPointParserUtil.silentSplit(params3.get("c"), ",");
                                    if (vls == null) return null;
                                    if (vls.length < 2) return null;
                                    double lat3 = (double)GeoPointParserUtil.parseSilentInt(vls[0]) / 100000.0;
                                    double lon3 = (double)GeoPointParserUtil.parseSilentInt(vls[1]) / 100000.0;
                                    int zoom22 = GeoPointParserUtil.parseZoom(zm);
                                    return new GeoParsedPoint(lat3, lon3, zoom22);
                                }
                                if (simpleDomains.contains(host)) {
                                    Map<String, String> params4 = GeoPointParserUtil.getQueryParameters(uri);
                                    if (uri.getQuery() == null && params4.size() == 0) {
                                        params4 = GeoPointParserUtil.getQueryParameters(path.substring(1));
                                    }
                                    if (!params4.containsKey("lat")) return null;
                                    if (!params4.containsKey("lon")) return null;
                                    double lat4 = GeoPointParserUtil.parseSilentDouble(params4.get("lat"));
                                    double lon4 = GeoPointParserUtil.parseSilentDouble(params4.get("lon"));
                                    int zoom4 = -1;
                                    if (params4.containsKey("z")) {
                                        zoom4 = GeoPointParserUtil.parseZoom(params4.get("z"));
                                        return new GeoParsedPoint(lat4, lon4, zoom4);
                                    }
                                    if (!params4.containsKey("zoom")) return new GeoParsedPoint(lat4, lon4, zoom4);
                                    zoom4 = GeoPointParserUtil.parseZoom(params4.get("zoom"));
                                    return new GeoParsedPoint(lat4, lon4, zoom4);
                                }
                                if (host.matches("(?:www\\.)?(?:maps\\.)?yandex\\.[a-z]+")) {
                                    Map<String, String> params5 = GeoPointParserUtil.getQueryParameters(uri);
                                    String ll2 = params5.get("ll");
                                    if (ll2 == null) return null;
                                    Matcher matcher4 = commaSeparatedPairPattern.matcher(ll2);
                                    if (!matcher4.matches()) return null;
                                    String z2 = String.valueOf(GeoPointParserUtil.parseZoom(params5.get("z")));
                                    return new GeoParsedPoint(matcher4.group(1), matcher4.group(2), z2, params5.get("text"));
                                }
                                if (host.matches("(?:www\\.)?(?:maps\\.)?google\\.[a-z.]+")) {
                                    String[] pathPrefixes;
                                    Pattern p;
                                    Matcher matcher5;
                                    String latString = null;
                                    String lonString = null;
                                    String z3 = String.valueOf(-1);
                                    params2 = GeoPointParserUtil.getQueryParameters(uri);
                                    if (params2.containsKey("q")) {
                                        System.out.println("q=" + params2.get("q"));
                                        matcher5 = commaSeparatedPairPattern.matcher(params2.get("q"));
                                        if (matcher5.matches()) {
                                            latString = matcher5.group(1);
                                            lonString = matcher5.group(2);
                                        }
                                    } else if (params2.containsKey("ll") && (matcher5 = commaSeparatedPairPattern.matcher(params2.get("ll"))).matches()) {
                                        latString = matcher5.group(1);
                                        lonString = matcher5.group(2);
                                    }
                                    if (latString != null && lonString != null) {
                                        if (!params2.containsKey("z")) return new GeoParsedPoint(latString, lonString, z3);
                                        z3 = params2.get("z");
                                        return new GeoParsedPoint(latString, lonString, z3);
                                    }
                                    if (params2.containsKey("daddr")) {
                                        return GeoPointParserUtil.parseGoogleMapsPath(params2.get("daddr"), params2);
                                    }
                                    if (params2.containsKey("saddr")) {
                                        return GeoPointParserUtil.parseGoogleMapsPath(params2.get("saddr"), params2);
                                    }
                                    if (params2.containsKey("q")) {
                                        String opath = params2.get("q");
                                        String pref2 = "loc:";
                                        if (opath.contains("loc:")) {
                                            opath = opath.substring(opath.lastIndexOf("loc:") + "loc:".length());
                                        }
                                        String postf2 = "\\s\\((\\p{L}|\\p{M}|\\p{Z}|\\p{S}|\\p{N}|\\p{P}|\\p{C})*\\)$";
                                        opath = opath.replaceAll("\\s\\((\\p{L}|\\p{M}|\\p{Z}|\\p{S}|\\p{N}|\\p{P}|\\p{C})*\\)$", "");
                                        System.out.println("opath=" + opath);
                                        return GeoPointParserUtil.parseGoogleMapsPath(opath, params2);
                                    }
                                    if (fragment != null && (m = (p = Pattern.compile(".*[!&]q=([^&!]+).*")).matcher(fragment)).matches()) {
                                        return new GeoParsedPoint(m.group(1));
                                    }
                                    m = pathPrefixes = new String[]{"/@", "/ll=", "loc:", "/"};
                                    postf2 = m.length;
                                    zoom22 = 0;
                                    break block80;
                                }
                                if (host.endsWith(".amap.com")) {
                                    subString = uri.toString().substring(scheme.length() + host.length() + 4);
                                    patterns = new String[]{".*q=([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?).*&radius=(\\d+).*", ".*q=([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?).*", ".*p=(?:[A-Z0-9]+),([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?).*"};
                                    i = 0;
                                    break block81;
                                }
                                if (host.equals("here.com") || host.endsWith(".here.com")) {
                                    Map<String, String> params6 = GeoPointParserUtil.getQueryParameters(uri);
                                    String z4 = String.valueOf(-1);
                                    String label2 = null;
                                    if (params6.containsKey("msg")) {
                                        label2 = params6.get("msg");
                                    }
                                    if (params6.containsKey("z")) {
                                        z4 = params6.get("z");
                                    }
                                    if (params6.containsKey("map")) {
                                        String[] mapArray = params6.get("map").split(",");
                                        if (mapArray.length > 2) {
                                            return new GeoParsedPoint(mapArray[0], mapArray[1], mapArray[2], label2);
                                        }
                                        if (mapArray.length > 1) {
                                            return new GeoParsedPoint(mapArray[0], mapArray[1], z4, label2);
                                        }
                                    }
                                    if (!path.startsWith("/l/")) return null;
                                    Pattern p = Pattern.compile("^/l/([+-]?\\d+(?:\\.\\d+)),([+-]?\\d+(?:\\.\\d+)),(.*)");
                                    Matcher matcher6 = p.matcher(path);
                                    if (!matcher6.matches()) return null;
                                    return new GeoParsedPoint(matcher6.group(1), matcher6.group(2), z4, matcher6.group(3));
                                }
                                if (host.endsWith(".qq.com")) {
                                    String c;
                                    Matcher matcher7;
                                    params = GeoPointParserUtil.getQueryParameters(uri);
                                    x = null;
                                    y = null;
                                    z = String.valueOf(-1);
                                    label = null;
                                    if (params.containsKey("city")) {
                                        label = params.get("city");
                                    } else if (params.containsKey("key")) {
                                        label = params.get("key");
                                    } else if (params.containsKey("a")) {
                                        label = params.get("a");
                                    } else if (params.containsKey("n")) {
                                        label = params.get("n");
                                    }
                                    String m2 = params.get("m");
                                    if (m2 != null && (matcher7 = commaSeparatedPairPattern.matcher(m2)).matches()) {
                                        x = matcher7.group(2);
                                        y = matcher7.group(1);
                                    }
                                    if ((c = params.get("c")) != null) {
                                        Matcher matcher8 = commaSeparatedPairPattern.matcher(c);
                                        if (matcher8.matches()) {
                                            x = matcher8.group(2);
                                            y = matcher8.group(1);
                                        } else {
                                            x = c.replaceAll(".*\"lng\":\\s*([+\\-]?[0-9.]+).*", "$1");
                                            if (x == null) {
                                                x = c.replaceAll(".*\"lon\":\\s*([+\\-]?[0-9.]+).*", "$1");
                                            }
                                            y = c.replaceAll(".*\"lat\":\\s*([+\\-]?[0-9.]+).*", "$1");
                                            z = c.replaceAll(".*\"l\":\\s*([+-]?[0-9.]+).*", "$1");
                                            return new GeoParsedPoint(y, x, z, label);
                                        }
                                    }
                                    stringArray = new String[]{"centerX", "x", "x1", "x2"};
                                    pref3 = stringArray.length;
                                    break block82;
                                }
                                if (!host.equals("maps.apple.com")) return null;
                                Map<String, String> params7 = GeoPointParserUtil.getQueryParameters(uri);
                                String z5 = String.valueOf(-1);
                                String label3 = null;
                                if (params7.containsKey("q")) {
                                    label3 = params7.get("q");
                                }
                                if (params7.containsKey("near")) {
                                    label3 = params7.get("near");
                                }
                                if (params7.containsKey("z")) {
                                    z5 = params7.get("z");
                                }
                                if ((ll = params7.get("ll")) != null && (matcher2 = commaSeparatedPairPattern.matcher(ll)).matches()) {
                                    return new GeoParsedPoint(matcher2.group(1), matcher2.group(2), z5, label3);
                                }
                                String sll = params7.get("sll");
                                if (sll != null && (matcher = commaSeparatedPairPattern.matcher(sll)).matches()) {
                                    return new GeoParsedPoint(matcher.group(1), matcher.group(2), z5, label3);
                                }
                                if (params7.containsKey("q")) {
                                    return new GeoParsedPoint(params7.get("q"));
                                }
                                if (params7.containsKey("daddr")) {
                                    return new GeoParsedPoint(params7.get("daddr"));
                                }
                                if (!params7.containsKey("saddr")) return null;
                                return new GeoParsedPoint(params7.get("saddr"));
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                            return null;
                        }
                        if (!"geo".equals(scheme)) {
                            if (!"osmand.geo".equals(scheme)) return null;
                        }
                        if ((schemeSpecific = uri.getSchemeSpecificPart()) == null) {
                            return null;
                        }
                        name = null;
                        Pattern namePattern = Pattern.compile("[\\+\\s]*\\((.*)\\)[\\+\\s]*$");
                        Matcher nameMatcher = namePattern.matcher(schemeSpecific);
                        if (nameMatcher.find() && (name = URLDecoder.decode(nameMatcher.group(1))) != null) {
                            schemeSpecific = schemeSpecific.substring(0, nameMatcher.start());
                        }
                        String queryPart = "";
                        int queryStartIndex = schemeSpecific.indexOf(63);
                        if (queryStartIndex == -1) {
                            positionPart = schemeSpecific;
                        } else {
                            positionPart = schemeSpecific.substring(0, queryStartIndex);
                            if (queryStartIndex < schemeSpecific.length()) {
                                queryPart = schemeSpecific.substring(queryStartIndex + 1);
                            }
                        }
                        positionPattern = Pattern.compile("([+-]?\\d+(?:\\.\\d+)?),\\s?([+-]?\\d+(?:\\.\\d+)?)");
                        Matcher positionMatcher = positionPattern.matcher(positionPart);
                        if (!positionMatcher.find()) {
                            return null;
                        }
                        lat = Double.valueOf(positionMatcher.group(1));
                        lon = Double.valueOf(positionMatcher.group(2));
                        zoom = -1;
                        searchRequest = null;
                        key = queryPart.split("&");
                        n = key.length;
                        break block83;
                    }
                    while (zoom22 < postf2) {
                        String pref3 = m[zoom22];
                        if (path.contains(pref3)) {
                            path = path.substring(path.lastIndexOf(pref3) + pref3.length());
                            return GeoPointParserUtil.parseGoogleMapsPath(path, params2);
                        }
                        ++zoom22;
                    }
                    return null;
                }
                while (i < patterns.length) {
                    Pattern p = Pattern.compile(patterns[i]);
                    Matcher matcher = p.matcher(subString);
                    if (matcher.matches()) {
                        if (matcher.groupCount() == 3) {
                            float radius = Float.valueOf(matcher.group(3)).floatValue();
                            long zoom5 = Math.round(23.0 - Math.log(radius) / Math.log(2.0));
                            return new GeoParsedPoint(matcher.group(1), matcher.group(2), String.valueOf(zoom5));
                        }
                        if (matcher.groupCount() == 2) {
                            return new GeoParsedPoint(matcher.group(1), matcher.group(2));
                        }
                    }
                    ++i;
                }
                return null;
            }
            for (int i = 0; i < pref3; ++i) {
                String key2 = stringArray[i];
                if (!params.containsKey(key2)) continue;
                x = params.get(key2);
                break;
            }
            for (String key2 : new String[]{"centerY", "y", "y1", "y2"}) {
                if (!params.containsKey(key2)) continue;
                y = params.get(key2);
                break;
            }
            if (x == null) return null;
            if (y == null) return null;
            return new GeoParsedPoint(y, x, z, label);
        }
        for (int i = 0; i < n; ++i) {
            String paramName;
            String param = key[i];
            String paramValue = null;
            int nameValueDelimititerIndex = param.indexOf(61);
            if (nameValueDelimititerIndex == -1) {
                paramName = param;
            } else {
                paramName = param.substring(0, nameValueDelimititerIndex);
                if (nameValueDelimititerIndex < param.length()) {
                    paramValue = param.substring(nameValueDelimititerIndex + 1);
                }
            }
            if ("z".equals(paramName) && paramValue != null) {
                zoom = Integer.parseInt(paramValue);
                continue;
            }
            if (!"q".equals(paramName) || paramValue == null) continue;
            searchRequest = URLDecoder.decode(paramValue);
        }
        if (searchRequest != null) {
            Matcher positionInSearchRequestMatcher = positionPattern.matcher(searchRequest);
            if (lat == 0.0 && lon == 0.0 && positionInSearchRequestMatcher.find()) {
                lat = Double.valueOf(positionInSearchRequestMatcher.group(1));
                lon = Double.valueOf(positionInSearchRequestMatcher.group(2));
            }
        }
        if (lat == 0.0 && lon == 0.0 && searchRequest != null) {
            return new GeoParsedPoint(searchRequest);
        }
        if (zoom == -1) return new GeoParsedPoint(lat, lon, name);
        return new GeoParsedPoint(lat, lon, zoom, name);
    }

    private static GeoParsedPoint parseGoogleMapsPath(String opath, Map<String, String> params) {
        String[] vls;
        String zmPart = "";
        String descr = "";
        String path = opath;
        if (path.contains("&")) {
            vls = path.split("&");
            path = vls[0];
            for (int i = 1; i < vls.length; ++i) {
                int ik = vls[i].indexOf(61);
                if (ik <= 0) continue;
                params.put(vls[i].substring(0, ik), vls[i].substring(ik + 1));
            }
        }
        if (path.contains("+") && (descr = (path = path.substring(0, path.indexOf("+"))).substring(path.indexOf("+") + 1)).contains(")")) {
            descr = descr.substring(0, descr.indexOf(")"));
        }
        if (params.containsKey("z")) {
            zmPart = params.get("z");
        }
        if ((vls = GeoPointParserUtil.silentSplit(path, ",")).length >= 2) {
            double lat = GeoPointParserUtil.parseSilentDouble(vls[0]);
            double lon = GeoPointParserUtil.parseSilentDouble(vls[1]);
            int zoom = -1;
            if (vls.length >= 3 || zmPart.length() > 0) {
                if (zmPart.length() == 0) {
                    zmPart = vls[2];
                }
                if (zmPart.startsWith("z=")) {
                    zmPart = zmPart.substring(2);
                } else if (zmPart.contains("z")) {
                    zmPart = zmPart.substring(0, zmPart.indexOf(122));
                }
                zoom = GeoPointParserUtil.parseZoom(zmPart);
            }
            return new GeoParsedPoint(lat, lon, zoom);
        }
        return new GeoParsedPoint(URLDecoder.decode(opath));
    }

    private static String[] silentSplit(String vl, String split) {
        if (vl == null) {
            return null;
        }
        return vl.split(split);
    }

    private static int parseZoom(String zoom) {
        try {
            if (zoom != null) {
                return Integer.valueOf(zoom);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static double parseSilentDouble(String zoom) {
        try {
            if (zoom != null) {
                return Double.valueOf(zoom);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0.0;
    }

    private static int parseSilentInt(String zoom) {
        try {
            if (zoom != null) {
                return Integer.valueOf(zoom);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public static class GeoParsedPoint {
        private static final int NO_ZOOM = -1;
        private double lat = 0.0;
        private double lon = 0.0;
        private int zoom = -1;
        private String label;
        private String query;
        private boolean geoPoint;
        private boolean geoAddress;

        public GeoParsedPoint(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
            this.geoPoint = true;
        }

        public GeoParsedPoint(double lat, double lon, String label) {
            this(lat, lon);
            if (label != null) {
                this.label = label.replaceAll("\\+", " ");
            }
        }

        public GeoParsedPoint(double lat, double lon, int zoom) {
            this(lat, lon);
            this.zoom = zoom;
        }

        public GeoParsedPoint(double lat, double lon, int zoom, String label) {
            this(lat, lon, label);
            this.zoom = zoom;
        }

        public GeoParsedPoint(String latString, String lonString, String zoomString, String label) throws NumberFormatException {
            this(latString, lonString, zoomString);
            this.label = label;
        }

        public GeoParsedPoint(String latString, String lonString, String zoomString) throws NumberFormatException {
            this(GeoParsedPoint.parseLat(latString), GeoParsedPoint.parseLon(lonString));
            this.zoom = GeoPointParserUtil.parseZoom(zoomString);
        }

        private static double parseLon(String lonString) {
            if (lonString.startsWith("E")) {
                return -Double.valueOf(lonString.substring(1)).doubleValue();
            }
            if (lonString.startsWith("W")) {
                return Double.valueOf(lonString.substring(1));
            }
            return Double.valueOf(lonString);
        }

        private static double parseLat(String latString) {
            if (latString.startsWith("S")) {
                return -Double.valueOf(latString.substring(1)).doubleValue();
            }
            if (latString.startsWith("N")) {
                return Double.valueOf(latString.substring(1));
            }
            return Double.valueOf(latString);
        }

        public GeoParsedPoint(String latString, String lonString) throws NumberFormatException {
            this(GeoParsedPoint.parseLat(latString), GeoParsedPoint.parseLon(lonString));
            this.zoom = -1;
        }

        public GeoParsedPoint(String query) {
            this.query = query;
            this.geoAddress = true;
        }

        public double getLatitude() {
            return this.lat;
        }

        public double getLongitude() {
            return this.lon;
        }

        public int getZoom() {
            return this.zoom;
        }

        public String getLabel() {
            return this.label;
        }

        public String getQuery() {
            return this.query;
        }

        public boolean isGeoPoint() {
            return this.geoPoint;
        }

        private String formatDouble(double d) {
            if (d == (double)((long)d)) {
                return String.format(Locale.ENGLISH, "%d", (long)d);
            }
            return String.format("%s", d);
        }

        public boolean isGeoAddress() {
            return this.geoAddress;
        }

        public String getGeoUriString() {
            if (this.isGeoPoint()) {
                String latlon = this.formatDouble(this.lat) + "," + this.formatDouble(this.lon);
                String uriString = "geo:" + latlon;
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                if (this.zoom != -1) {
                    map.put("z", String.valueOf(this.zoom));
                }
                if (this.query != null) {
                    map.put("q", URLEncoder.encode(this.query));
                }
                if (this.label != null && this.query == null) {
                    map.put("q", latlon + "(" + URLEncoder.encode(this.label) + ")");
                }
                if (map.size() > 0) {
                    uriString = uriString + "?";
                }
                int i = 0;
                for (String key : map.keySet()) {
                    if (i > 0) {
                        uriString = uriString + "&";
                    }
                    uriString = uriString + key + "=" + (String)map.get(key);
                    ++i;
                }
                return uriString;
            }
            if (this.isGeoAddress()) {
                String uriString = "geo:0,0";
                if (this.query != null) {
                    uriString = uriString + "?";
                    if (this.zoom != -1) {
                        uriString = uriString + "z=" + this.zoom + "&";
                    }
                    uriString = uriString + "q=" + URLEncoder.encode(this.query);
                }
                return uriString;
            }
            return null;
        }

        public String toString() {
            return this.isGeoPoint() ? "GeoParsedPoint [lat=" + this.lat + ", lon=" + this.lon + ", zoom=" + this.zoom + ", label=" + this.label + "]" : "GeoParsedPoint [query=" + this.query;
        }
    }
}

