/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.search;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.find.OWLEntityFinderPreferences;
import org.protege.editor.owl.model.search.SearchManager;
import org.protege.editor.owl.model.search.SearchRequest;
import org.protege.editor.owl.model.search.SearchResultSet;
import org.protege.editor.owl.ui.search.SearchOptionsChangedListener;
import org.protege.editor.owl.ui.search.SearchOptionsPanel;
import org.protege.editor.owl.ui.search.SearchResultClickedListener;
import org.protege.editor.owl.ui.search.SearchResultsPanel;
import org.protege.editor.owl.ui.transfer.TransferableOWLObject;
import org.protege.editor.owl.ui.view.ViewClipboard;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchPanel
extends JPanel {
    private static final String WHITE_SPACE_PATTERN = "\\s+";
    private final SearchOptionsPanel searchOptionsPanel;
    private final SearchResultsPanel searchResultsPanel;
    private final Logger logger = LoggerFactory.getLogger(SearchPanel.class);
    private final OWLEditorKit editorKit;
    private String searchString = "";

    public SearchPanel(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.setLayout(new BorderLayout(4, 4));
        this.searchOptionsPanel = new SearchOptionsPanel(editorKit);
        this.add((Component)this.searchOptionsPanel, "North");
        this.searchResultsPanel = new SearchResultsPanel(editorKit);
        this.add(this.searchResultsPanel);
        this.searchOptionsPanel.addListener(new SearchOptionsChangedListener(){

            @Override
            public void searchRequestOptionChanged() {
                SearchPanel.this.doSearch();
            }

            @Override
            public void searchResultsPresentationOptionChanged() {
                SearchPanel.this.updateSearchResultsPresentation();
            }
        });
        JPanel searchActionsPanel = new JPanel(new FlowLayout(0));
        searchActionsPanel.add(new JButton(new AbstractAction("Copy selected entities"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.copySelectedEntities();
            }
        }));
        this.add((Component)searchActionsPanel, "South");
    }

    private String getSearchString() {
        return this.searchString;
    }

    public void setSearchResultClickedListener(SearchResultClickedListener searchResultClickedListener) {
        this.searchResultsPanel.setSearchResultClickedListener(searchResultClickedListener);
    }

    public void setSearchString(String searchString) {
        this.searchString = (String)Preconditions.checkNotNull((Object)searchString);
        this.searchOptionsPanel.refresh();
        this.doSearch();
    }

    private SearchRequest createSearchRequest() throws PatternSyntaxException {
        OWLEntityFinderPreferences prefs = OWLEntityFinderPreferences.getInstance();
        int flags = 0x20 | (prefs.isCaseSensitive() ? 0 : 2);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String splitSearchString : this.getSearchString().split(WHITE_SPACE_PATTERN)) {
            String preparedSearchString;
            if (prefs.isUseRegularExpressions()) {
                preparedSearchString = splitSearchString;
                if (prefs.isIgnoreWhiteSpace()) {
                    preparedSearchString = preparedSearchString.replace(" ", WHITE_SPACE_PATTERN);
                }
            } else if (prefs.isIgnoreWhiteSpace()) {
                StringBuilder sb = new StringBuilder();
                String[] split = splitSearchString.split(WHITE_SPACE_PATTERN);
                for (int i = 0; i < split.length; ++i) {
                    String s = split[i];
                    sb.append(Pattern.quote(s));
                    if (i >= split.length - 1) continue;
                    sb.append(WHITE_SPACE_PATTERN);
                }
                preparedSearchString = sb.toString();
            } else {
                preparedSearchString = Pattern.quote(splitSearchString);
            }
            if (prefs.isWholeWords()) {
                preparedSearchString = "\\b(:?" + preparedSearchString + ")\\b";
            }
            builder.add((Object)Pattern.compile(preparedSearchString, flags));
        }
        return new SearchRequest((ImmutableList<Pattern>)builder.build());
    }

    private void doSearch() {
        String searchStr = this.getSearchString();
        if (searchStr.trim().isEmpty()) {
            this.searchResultsPanel.clearSearchResults();
            return;
        }
        try {
            SearchManager searchManager = this.editorKit.getSearchManager();
            SearchRequest searchRequest = this.createSearchRequest();
            searchManager.performSearch(searchRequest, searchResults -> {
                int categorySizeLimit = this.getCategoryLimit();
                SearchResultSet searchResultSet = new SearchResultSet(searchResults);
                SwingUtilities.invokeLater(() -> this.searchResultsPanel.setSearchResults(searchResultSet, categorySizeLimit));
            });
        }
        catch (PatternSyntaxException e) {
            this.logger.info("Invalid regular expression in search pattern: {}", (Object)e.getPattern());
        }
    }

    private int getCategoryLimit() {
        int categorySizeLimit = 10;
        if (this.searchOptionsPanel.isShowAllResults()) {
            categorySizeLimit = Integer.MAX_VALUE;
        }
        return categorySizeLimit;
    }

    private void updateSearchResultsPresentation() {
        int categorySizeLimit = this.getCategoryLimit();
        this.searchResultsPanel.setCategorySizeLimit(categorySizeLimit);
    }

    public void moveSelectionDown() {
        this.searchResultsPanel.moveSelectionDown();
    }

    public void moveSelectionUp() {
        this.searchResultsPanel.moveSelectionUp();
    }

    private void copySelectedEntities() {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ArrayList<OWLEntity> objects = new ArrayList<OWLEntity>();
        objects.addAll(this.searchResultsPanel.getSelectedEntities());
        ViewClipboard clipboard = ViewClipboard.getInstance();
        TransferableOWLObject contents = new TransferableOWLObject(this.editorKit.getOWLModelManager(), objects);
        clipboard.getClipboard().setContents(contents, null);
        StringBuilder buffer = new StringBuilder();
        for (OWLEntity owlObject : objects) {
            buffer.append(this.editorKit.getOWLModelManager().getRendering((OWLObject)owlObject));
            buffer.append(" ");
            buffer.append(owlObject.getIRI().toQuotedString());
            buffer.append("\n");
        }
        StringSelection stringSelection = new StringSelection(buffer.toString().trim());
        systemClipboard.setContents(stringSelection, null);
    }

    public Optional<OWLEntity> getSelectedEntity() {
        return this.searchResultsPanel.getSelectedEntity();
    }
}

