/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.th;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_th extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e21\u0e2d\u0e2a\u0e42\u0e01",
               "MST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e21\u0e2d\u0e2a\u0e42\u0e01",
               "MST",
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e2d\u0e2a\u0e42\u0e01",
               "MT",
            };
        final String[] Omsk = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e2a\u0e01\u0e4c",
               "OST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e2d\u0e2d\u0e21\u0e2a\u0e04\u0e4c",
               "OST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e2a\u0e01\u0e4c",
               "OT",
            };
        final String[] Sakhalin = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e0b\u0e32\u0e04\u0e32\u0e25\u0e34\u0e19",
               "SST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e0b\u0e32\u0e04\u0e32\u0e25\u0e34\u0e19",
               "SST",
               "\u0e40\u0e27\u0e25\u0e32\u0e0b\u0e32\u0e04\u0e32\u0e25\u0e34\u0e19",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e22\u0e32\u0e04\u0e38\u0e15\u0e2a\u0e04\u0e4c",
               "YST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e22\u0e32\u0e04\u0e38\u0e15\u0e2a\u0e04\u0e4c",
               "YST",
               "\u0e40\u0e27\u0e25\u0e32\u0e22\u0e32\u0e04\u0e38\u0e15\u0e2a\u0e04\u0e4c",
               "YT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e19\u0e04\u0e32\u0e0b\u0e31\u0e04\u0e2a\u0e16\u0e32\u0e19\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e27\u0e25\u0e32\u0e14\u0e35\u0e27\u0e2d\u0e2a\u0e15\u0e2d\u0e04",
               "VST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e27\u0e25\u0e32\u0e14\u0e35\u0e27\u0e2d\u0e2a\u0e15\u0e2d\u0e04",
               "VST",
               "\u0e40\u0e27\u0e25\u0e32\u0e27\u0e25\u0e32\u0e14\u0e35\u0e27\u0e2d\u0e2a\u0e15\u0e2d\u0e04",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01",
               "WEST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01",
               "WEST",
               "\u0e40\u0e27\u0e25\u0e32\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01",
               "WET",
            };
        final String[] Brasilia = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e40\u0e25\u0e35\u0e22",
               "BST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e40\u0e25\u0e35\u0e22",
               "BST",
               "\u0e40\u0e27\u0e25\u0e32\u0e1a\u0e23\u0e32\u0e0b\u0e35\u0e40\u0e25\u0e35\u0e22",
               "BT",
            };
        final String[] Hovd = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e2e\u0e2d\u0e1f\u0e14\u0e4c",
               "HST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e2e\u0e2d\u0e1f\u0e14\u0e4c",
               "HST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2e\u0e2d\u0e1f\u0e14\u0e4c",
               "HT",
            };
        final String[] Mongolia = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e39\u0e25\u0e32\u0e19\u0e1a\u0e32\u0e15\u0e2d\u0e23\u0e4c",
               "UBST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e2d\u0e39\u0e25\u0e32\u0e19\u0e1a\u0e32\u0e15\u0e2d\u0e23\u0e4c",
               "UBST",
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e40\u0e25\u0e35\u0e22",
               "UBT",
            };
        final String[] America_Pacific = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e41\u0e1b\u0e0b\u0e34\u0e1f\u0e34\u0e01",
               "PST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e02\u0e2d\u0e07\u0e41\u0e1b\u0e0b\u0e34\u0e1f\u0e34\u0e01",
               "PDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e41\u0e1b\u0e0b\u0e34\u0e1f\u0e34\u0e01",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01",
               "WAST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e17\u0e32\u0e07\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01\u0e02\u0e2d\u0e07\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32",
               "WAST",
               "\u0e40\u0e27\u0e25\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01\u0e02\u0e2d\u0e07\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32",
               "WAT",
            };
        final String[] Newfoundland = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e19\u0e34\u0e27\u0e1f\u0e31\u0e19\u0e14\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c",
               "NST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e19\u0e34\u0e27\u0e1f\u0e31\u0e19\u0e14\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c",
               "NDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e19\u0e34\u0e27\u0e1f\u0e31\u0e19\u0e14\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c",
               "NT",
            };
        final String[] Volgograd = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e27\u0e2d\u0e25\u0e42\u0e01\u0e01\u0e23\u0e32\u0e14",
               "VST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e27\u0e2d\u0e25\u0e42\u0e01\u0e01\u0e23\u0e32\u0e14",
               "VST",
               "\u0e40\u0e27\u0e25\u0e32\u0e27\u0e2d\u0e25\u0e42\u0e01\u0e01\u0e23\u0e32\u0e14",
               "VT",
            };
        final String[] America_Central = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e15\u0e2d\u0e19\u0e01\u0e25\u0e32\u0e07",
               "CST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e17\u0e32\u0e07\u0e15\u0e2d\u0e19\u0e01\u0e25\u0e32\u0e07",
               "CDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e15\u0e2d\u0e19\u0e01\u0e25\u0e32\u0e07",
               "CT",
            };
        final String[] Argentina = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32",
               "AST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32",
               "AST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e40\u0e22\u0e04\u0e32\u0e40\u0e15\u0e23\u0e34\u0e19\u0e1a\u0e39\u0e23\u0e4c\u0e01",
               "YST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e40\u0e22\u0e04\u0e32\u0e40\u0e15\u0e23\u0e34\u0e19\u0e1a\u0e39\u0e23\u0e4c\u0e01",
               "YST",
               "\u0e40\u0e27\u0e25\u0e32\u0e40\u0e22\u0e01\u0e32\u0e40\u0e15\u0e23\u0e34\u0e19\u0e1a\u0e38\u0e23\u0e4c\u0e01",
               "YT",
            };
        final String[] Lord_Howe = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e25\u0e2d\u0e23\u0e4c\u0e14\u0e42\u0e2e\u0e27\u0e4c",
               "LHST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e02\u0e2d\u0e07\u0e25\u0e2d\u0e23\u0e4c\u0e14\u0e42\u0e2e\u0e27\u0e4c",
               "LHDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e25\u0e2d\u0e23\u0e4c\u0e14\u0e42\u0e2e\u0e27",
               "LHT",
            };
        final String[] Macquarie = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e41\u0e21\u0e01\u0e04\u0e27\u0e2d\u0e23\u0e35",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01",
               "AEST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e17\u0e32\u0e07\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01\u0e02\u0e2d\u0e07\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22",
               "AEDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e35\u0e23\u0e04\u0e38\u0e15\u0e2a\u0e04\u0e4c",
               "IST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e2d\u0e35\u0e23\u0e4c\u0e04\u0e38\u0e15\u0e2a\u0e04\u0e4c",
               "IST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e35\u0e23\u0e04\u0e38\u0e15\u0e2a\u0e04\u0e4c",
               "IT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e2b\u0e32\u0e2a\u0e21\u0e38\u0e17\u0e23\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e0a\u0e2d\u0e22\u0e1b\u0e32\u0e25\u0e0a\u0e32\u0e19",
               "CST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e0a\u0e2d\u0e22\u0e1b\u0e32\u0e25\u0e0a\u0e32\u0e19",
               "CST",
               "\u0e40\u0e27\u0e25\u0e32\u0e0a\u0e2d\u0e22\u0e1b\u0e32\u0e25\u0e0a\u0e32\u0e19",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e19\u0e04\u0e32\u0e0b\u0e31\u0e04\u0e2a\u0e16\u0e32\u0e19\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] America_Eastern = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01",
               "EST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e17\u0e32\u0e07\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01",
               "EDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01",
               "AWST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e17\u0e32\u0e07\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01\u0e02\u0e2d\u0e07\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22",
               "AWDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01\u0e01\u0e25\u0e32\u0e07",
               "ACWST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e17\u0e32\u0e07\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01\u0e15\u0e2d\u0e19\u0e01\u0e25\u0e32\u0e07\u0e02\u0e2d\u0e07\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22",
               "ACWDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01\u0e01\u0e25\u0e32\u0e07",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e04\u0e23\u0e31\u0e2a\u0e42\u0e19\u0e22\u0e32\u0e2a\u0e04\u0e4c",
               "KST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e04\u0e23\u0e31\u0e2a\u0e42\u0e19\u0e22\u0e32\u0e2a\u0e04\u0e4c",
               "KST",
               "\u0e40\u0e27\u0e25\u0e32\u0e04\u0e23\u0e31\u0e2a\u0e42\u0e19\u0e22\u0e32\u0e2a\u0e04\u0e4c",
               "KT",
            };
        final String[] Noronha = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e40\u0e1f\u0e23\u0e4c\u0e19\u0e31\u0e19\u0e42\u0e14\u0e40\u0e14\u0e42\u0e19\u0e23\u0e2d\u0e19\u0e2e\u0e32",
               "FNST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e40\u0e1f\u0e23\u0e4c\u0e19\u0e31\u0e19\u0e42\u0e14\u0e40\u0e14\u0e42\u0e19\u0e23\u0e2d\u0e19\u0e2e\u0e32",
               "FNST",
               "\u0e40\u0e27\u0e25\u0e32\u0e42\u0e19\u0e23\u0e2d\u0e19\u0e2e\u0e32",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e42\u0e19\u0e42\u0e27\u0e0b\u0e35\u0e1a\u0e35\u0e2a\u0e04\u0e4c",
               "NST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e42\u0e19\u0e42\u0e27\u0e0b\u0e35\u0e1a\u0e35\u0e2a\u0e04\u0e4c",
               "NST",
               "\u0e40\u0e27\u0e25\u0e32\u0e42\u0e19\u0e42\u0e27\u0e0b\u0e35\u0e1a\u0e35\u0e2a\u0e04\u0e4c",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e41\u0e16\u0e1a\u0e20\u0e39\u0e40\u0e02\u0e32",
               "MST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e41\u0e16\u0e1a\u0e20\u0e39\u0e40\u0e02\u0e32",
               "MDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e41\u0e16\u0e1a\u0e20\u0e39\u0e40\u0e02\u0e32",
               "MT",
            };
        final String[] Europe_Central = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e01\u0e25\u0e32\u0e07",
               "CEST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e01\u0e25\u0e32\u0e07",
               "CEST",
               "\u0e40\u0e27\u0e25\u0e32\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e01\u0e25\u0e32\u0e07",
               "CET",
            };
        final String[] Alaska = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e2d\u0e30\u0e41\u0e25\u0e2a\u0e01\u0e32",
               "AKST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e02\u0e2d\u0e07\u0e2d\u0e30\u0e41\u0e25\u0e2a\u0e01\u0e32",
               "AKDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e30\u0e41\u0e25\u0e2a\u0e01\u0e32",
               "AKT",
            };
        final String[] Australia_Central = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22\u0e01\u0e25\u0e32\u0e07",
               "ACST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e17\u0e32\u0e07\u0e15\u0e2d\u0e19\u0e01\u0e25\u0e32\u0e07\u0e02\u0e2d\u0e07\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22",
               "ACDT",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22\u0e01\u0e25\u0e32\u0e07",
               "CAT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01",
               "EEST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01",
               "EEST",
               "\u0e40\u0e27\u0e25\u0e32\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e41\u0e2d\u0e15\u0e41\u0e25\u0e19\u0e15\u0e34\u0e01",
               "AST",
               "\u0e40\u0e27\u0e25\u0e32\u0e2d\u0e2d\u0e21\u0e41\u0e2a\u0e07\u0e02\u0e2d\u0e07\u0e41\u0e2d\u0e15\u0e41\u0e25\u0e19\u0e15\u0e34\u0e01",
               "ADT",
               "\u0e40\u0e27\u0e25\u0e32\u0e41\u0e2d\u0e15\u0e41\u0e25\u0e19\u0e15\u0e34\u0e01",
               "AT",
            };
        final String[] Magadan = new String[] {
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e01\u0e32\u0e14\u0e32\u0e19",
               "MST",
               "\u0e40\u0e27\u0e25\u0e32\u0e24\u0e14\u0e39\u0e23\u0e49\u0e2d\u0e19\u0e21\u0e32\u0e01\u0e32\u0e14\u0e32\u0e19",
               "MST",
               "\u0e40\u0e27\u0e25\u0e32\u0e21\u0e32\u0e01\u0e32\u0e14\u0e32\u0e19",
               "MT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Europe/Bucharest", Europe_Eastern },
            { "Europe/Samara", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Asia/Nicosia", Europe_Eastern },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Zurich", Europe_Central },
            { "America/Resolute", America_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Stockholm", Europe_Central },
            { "America/Cayman", America_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Asia/Omsk", Omsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Asia/Choibalsan", Choibalsan },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Thunder_Bay", America_Eastern },
            { "Europe/Prague", Europe_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "America/Tortola", Atlantic },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Nome", Alaska },
            { "America/Moncton", Atlantic },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Maceio", Brasilia },
            { "Europe/Podgorica", Europe_Central },
            { "America/Belize", America_Central },
            { "America/Vancouver", America_Pacific },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Irkutsk", Irkutsk },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Metlakatla", America_Pacific },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "America/Jamaica", America_Eastern },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Australia/Currie", Australia_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Cancun", America_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Jujuy", Argentina },
            { "Europe/Rome", Europe_Central },
            { "America/Buenos_Aires", Argentina },
            { "America/Dawson_Creek", America_Mountain },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Anadyr", Magadan },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Europe/San_Marino", Europe_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Juneau", Alaska },
            { "America/Araguaina", Brasilia },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/St_Lucia", Atlantic },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/St_Thomas", Atlantic },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Minsk", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Europe/Riga", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "America/Santo_Domingo", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "America/Dominica", Atlantic },
            { "Antarctica/Macquarie", Macquarie },
            { "Australia/Darwin", Australia_Central },
            { "MST7MDT", America_Mountain },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "America/Monterrey", America_Central },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
