/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.util.CAL10NBundle;
import ch.qos.cal10n.util.CAL10NBundleFinder;
import ch.qos.cal10n.util.MiscUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;

public abstract class AbstractCAL10NBundleFinder
implements CAL10NBundleFinder {
    public CAL10NBundle getBundle(String baseName, Locale locale, String charset) {
        baseName = baseName.replace('.', '/');
        String languageAndCountryCandidate = this.computeLanguageAndCountryCandidate(baseName, locale);
        String languageOnlyCandidate = this.computeLanguageOnlyCandidate(baseName, locale);
        CAL10NBundle cprbLanguageOnly = this.makePropertyResourceBundle(languageOnlyCandidate, charset);
        CAL10NBundle cprbLanguageAndCountry = null;
        if (languageAndCountryCandidate != null) {
            cprbLanguageAndCountry = this.makePropertyResourceBundle(languageAndCountryCandidate, charset);
        }
        if (cprbLanguageAndCountry != null) {
            cprbLanguageAndCountry.setParent(cprbLanguageOnly);
            return cprbLanguageAndCountry;
        }
        return cprbLanguageOnly;
    }

    private String computeLanguageAndCountryCandidate(String baseName, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (country != null && country.length() > 0) {
            return baseName + "_" + language + "_" + country + ".properties";
        }
        return null;
    }

    protected abstract URL getResource(String var1);

    private CAL10NBundle makePropertyResourceBundle(String resourceCandidate, String charset) {
        CAL10NBundle prb = null;
        URL url = this.getResource(resourceCandidate);
        if (url != null) {
            try {
                InputStream in = this.openConnectionForUrl(url);
                Reader reader = this.toReader(in, charset);
                reader = charset == null || charset.length() == 0 ? new InputStreamReader(in) : new InputStreamReader(in, charset);
                prb = new CAL10NBundle(reader, MiscUtil.urlToFile(url));
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return prb;
    }

    private String computeLanguageOnlyCandidate(String baseName, Locale locale) {
        String language = locale.getLanguage();
        return baseName + "_" + language + ".properties";
    }

    Reader toReader(InputStream in, String charset) {
        if (charset == null || charset.length() == 0) {
            return new InputStreamReader(in);
        }
        try {
            return new InputStreamReader(in, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to open reader", e);
        }
    }

    private InputStream openConnectionForUrl(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.setDefaultUseCaches(false);
        InputStream in = urlConnection.getInputStream();
        return in;
    }
}

