/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.model;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Directive;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.utils.CommonUtils;
import com.github.cereda.arara.utils.DirectiveUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extractor {
    private static final LanguageController messages = LanguageController.getInstance();

    public List<Directive> extract() throws AraraException {
        File file = (File)ConfigurationController.getInstance().get("execution.reference");
        Charset charset = (Charset)ConfigurationController.getInstance().get("directives.charset");
        try {
            List<String> content = CommonUtils.getPreambleContent();
            List<String> lines = FileUtils.readLines(file, charset.name());
            content.addAll(lines);
            return DirectiveUtils.extractDirectives(content);
        }
        catch (IOException ioexception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_EXTRACTOR_IO_ERROR), ioexception);
        }
    }
}

