/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExtendedAppletSecurityHelp;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;
import net.sourceforge.jnlp.security.dialogresults.SetValueHandler;
import net.sourceforge.jnlp.security.dialogresults.YesNoSandboxLimited;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.security.dialogs.remember.RememberPanel;
import net.sourceforge.jnlp.security.dialogs.remember.RememberPanelResult;
import net.sourceforge.jnlp.security.dialogs.remember.RememberableDialog;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.OutputController;

public abstract class AppTrustWarningPanel
extends SecurityDialogPanel
implements RememberableDialog {
    protected int PANE_WIDTH = 500;
    protected int TOP_PANEL_HEIGHT = 60;
    protected int INFO_PANEL_HEIGHT = 160;
    protected int INFO_PANEL_HINT_HEIGHT = 25;
    protected int QUESTION_PANEL_HEIGHT = 35;
    protected List<JButton> buttons;
    protected JButton allowButton;
    protected JButton rejectButton;
    protected JButton helpButton;
    protected RememberPanel rememberPanel;
    protected JNLPFile file;

    public AppTrustWarningPanel(JNLPFile file, SecurityDialog securityDialog) {
        super(securityDialog);
        this.file = file;
        this.parent = securityDialog;
        this.rememberPanel = new RememberPanel(file.getCodeBase());
        this.buttons = new ArrayList<JButton>();
        this.allowButton = new JButton(Translator.R("ButProceed"));
        this.rejectButton = new JButton(Translator.R("ButCancel"));
        this.helpButton = new JButton(Translator.R("APPEXTSECguiPanelHelpButton"));
        this.allowButton.addActionListener(SetValueHandler.createSetValueListener(this.parent, YesNoSandboxLimited.yes()));
        this.rejectButton.addActionListener(SetValueHandler.createSetValueListener(this.parent, YesNoSandboxLimited.no()));
        this.helpButton.addActionListener(this.getHelpButtonAction());
        this.buttons.add(this.allowButton);
        this.buttons.add(this.rejectButton);
        this.buttons.add(this.helpButton);
    }

    protected abstract ImageIcon getInfoImage();

    protected abstract String getTopPanelText();

    protected abstract String getInfoPanelText();

    protected abstract String getQuestionPanelText();

    public final JButton getAllowButton() {
        return this.allowButton;
    }

    public final JButton getRejectButton() {
        return this.rejectButton;
    }

    protected ActionListener getHelpButtonAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedAppletSecurityHelp d = new ExtendedAppletSecurityHelp(null, false, "dialogue");
                ScreenFinder.centerWindowsToCurrentScreen(d);
                d.setVisible(true);
            }
        };
    }

    private void setupTopPanel() {
        String topLabelText = this.getTopPanelText();
        JLabel topLabel = new JLabel(topLabelText, this.getInfoImage(), 2);
        topLabel.setFont(new Font(topLabel.getFont().toString(), 1, 12));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        topPanel.add((Component)topLabel, "Center");
        topPanel.setPreferredSize(new Dimension(this.PANE_WIDTH, this.TOP_PANEL_HEIGHT));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(topPanel);
    }

    protected String getAppletTitle() {
        String title;
        try {
            title = this.file instanceof PluginBridge ? this.file.getTitle() : this.file.getInformation().getTitle();
        }
        catch (Exception e) {
            title = "";
        }
        return title;
    }

    private void setupInfoPanel() {
        JPanel infoPanel = new JPanel(new BorderLayout());
        String titleText = this.getAppletTitle();
        JLabel titleLabel = new JLabel(titleText);
        titleLabel.setFont(new Font(titleLabel.getFont().getName(), 1, 18));
        String infoLabelText = this.getInfoPanelText();
        JEditorPane infoLabel = new JEditorPane("text/html", AppTrustWarningPanel.htmlWrap(infoLabelText));
        infoLabel.setBackground(infoPanel.getBackground());
        infoLabel.setEditable(false);
        infoLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                }
                catch (IOException | URISyntaxException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
        });
        int panelHeight = titleLabel.getHeight() + this.INFO_PANEL_HEIGHT + this.INFO_PANEL_HINT_HEIGHT;
        infoPanel.add((Component)titleLabel, "First");
        infoPanel.add((Component)infoLabel, "Center");
        infoPanel.setPreferredSize(new Dimension(this.PANE_WIDTH, panelHeight));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(infoPanel);
    }

    private void setupQuestionsPanel() {
        JPanel questionPanel = new JPanel(new BorderLayout());
        String questionPanelText = this.getQuestionPanelText();
        questionPanel.add((Component)new JLabel(questionPanelText), "East");
        questionPanel.setPreferredSize(new Dimension(this.PANE_WIDTH, this.QUESTION_PANEL_HEIGHT));
        questionPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add(questionPanel);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        for (JButton button : this.buttons) {
            buttonPanel.add(button);
        }
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        return buttonPanel;
    }

    private void setupButtonAndCheckBoxPanel() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.add((Component)this.rememberPanel, "South");
        outerPanel.add((Component)this.createButtonPanel(), "East");
        this.add(outerPanel);
    }

    protected final void addComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setupTopPanel();
        this.setupInfoPanel();
        this.setupQuestionsPanel();
        this.setupButtonAndCheckBoxPanel();
    }

    @Override
    public RememberPanelResult getRemeberAction() {
        return this.rememberPanel.getRememberAction();
    }

    @Override
    public JNLPFile getFile() {
        return this.file;
    }

    @Override
    public DialogResult getValue() {
        return this.parent.getValue();
    }

    @Override
    public DialogResult readValue(String s) {
        return YesNoSandboxLimited.readValue(s);
    }

    @Override
    public DialogResult getDefaultNegativeAnswer() {
        return YesNoSandboxLimited.no();
    }

    @Override
    public DialogResult getDefaultPositiveAnswer() {
        return YesNoSandboxLimited.yes();
    }

    @Override
    public DialogResult readFromStdIn(String what) {
        return YesNoSandboxLimited.readValue(what);
    }

    @Override
    public String helpToStdIn() {
        return YesNoSandboxLimited.yes().getAllowedValues().toString();
    }
}

