/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.P3;
import javajs.util.T3;
import org.jmol.adapter.readers.simple.InputReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;

public class MopacArchiveReader
extends InputReader {
    private String energyWithUnits;

    @Override
    protected void initializeReader() {
        this.asc.newAtomSet();
        if (!this.checkFilterKey("NOCENTER")) {
            this.doCentralize = true;
        }
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("=") == 34) {
            return this.getMyValue();
        }
        if (this.line.indexOf("FINAL GEOMETRY OBTAINED") >= 0) {
            return this.readCoordinates();
        }
        return true;
    }

    private boolean getMyValue() {
        if (this.line.substring(0, 10).trim().length() != 0) {
            return true;
        }
        String string = this.line.substring(0, 34).trim().replace(' ', '_');
        String string2 = this.line.substring(35).trim();
        this.asc.setCurrentModelInfo(string, string2);
        if (this.line.indexOf("TOTAL ENERGY") >= 0) {
            String[] stringArray = this.getTokens();
            this.energyWithUnits = " (" + stringArray[3] + " " + stringArray[4] + ")";
            this.asc.setAtomSetEnergy(stringArray[3], this.parseFloatStr(stringArray[3]));
        }
        return true;
    }

    private boolean readCoordinates() throws Exception {
        this.rd();
        this.line = this.rd().trim();
        this.asc.setAtomSetName(String.valueOf(this.line) + (this.energyWithUnits == null ? "" : this.energyWithUnits));
        this.rd();
        Atom atom = null;
        String string = null;
        this.setFractionalCoordinates(false);
        while (this.rd() != null && this.line.length() >= 50) {
            atom = new Atom();
            this.vAtoms.addLast(atom);
            atom.x = this.parseFloatRange(this.line, 5, 18);
            atom.y = this.parseFloatRange(this.line, 21, 34);
            atom.z = this.parseFloatRange(this.line, 37, 50);
            if (this.line.length() > 58 && this.line.charAt(58) != ' ') {
                switch (this.ac) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        atom.sub((T3)this.vAtoms.get(0));
                        break;
                    }
                    case 2: {
                        this.setAtom(atom, 0, 1, 0, atom.x, atom.y, Float.MAX_VALUE);
                        break;
                    }
                    default: {
                        this.setAtom(atom, this.parseIntRange(this.line, 54, 59) - 1, this.parseIntRange(this.line, 60, 65) - 1, this.parseIntRange(this.line, 66, 71) - 1, atom.x, atom.y, atom.z);
                    }
                }
            }
            atom.elementSymbol = string = this.line.substring(1, 3).trim();
            if (string.equals("Tv")) continue;
            ++this.ac;
            if (this.line.length() >= 84) {
                atom.partialCharge = this.parseFloatRange(this.line, 76, 84);
            }
            if (JmolAdapter.getElementNumber(string) != 0) {
                this.asc.addAtom(atom);
            }
            this.setAtomCoord(atom);
        }
        if (string.equals("Tv")) {
            int n;
            this.setSpaceGroupName("P1");
            int n2 = n = this.vAtoms.size() - this.ac;
            while (n2 < 3) {
                this.vAtoms.addLast(new Atom());
                ++n2;
            }
            float[] fArray = new float[9];
            int n3 = 0;
            while (n3 < 3) {
                int n4 = n3 * 3;
                atom = (Atom)this.vAtoms.get(this.ac + n3);
                if (!Float.isNaN(atom.x)) {
                    fArray[n4] = atom.x;
                    fArray[n4 + 1] = atom.y;
                    fArray[n4 + 2] = atom.z;
                }
                this.addExplicitLatticeVector(n3, fArray, n4);
                ++n3;
            }
            n3 = this.ac;
            while (--n3 >= 0) {
                this.setAtomCoord((Atom)this.vAtoms.get(n3));
            }
            P3 p3 = P3.new3(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
            P3 p32 = P3.new3(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            if (this.doCentralize) {
                int n5 = this.ac;
                while (--n5 >= 0) {
                    atom = (Atom)this.vAtoms.get(n5);
                    p3.x = Math.max(p3.x, atom.x);
                    p3.y = Math.max(p3.y, atom.y);
                    p3.z = Math.max(p3.z, atom.z);
                    p32.x = Math.min(p32.x, atom.x);
                    p32.y = Math.min(p32.y, atom.y);
                    p32.z = Math.min(p32.z, atom.z);
                }
                P3 p33 = new P3();
                switch (n) {
                    case 3: {
                        p33.x = 0.5f;
                    }
                    case 2: {
                        p33.y = 0.5f;
                    }
                    case 1: {
                        p33.z = 0.5f;
                    }
                }
                p33.scaleAdd2(-0.5f, p32, p33);
                p33.scaleAdd2(-0.5f, p3, p33);
                int n6 = this.ac;
                while (--n6 >= 0) {
                    ((Atom)this.vAtoms.get(n6)).add(p33);
                }
            }
            this.doCentralize = false;
        }
        return true;
    }
}

