/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.spartan;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.spartan.SpartanArchive;
import org.jmol.adapter.readers.spartan.SpartanInputReader;
import org.jmol.util.Logger;

public class SpartanSmolReader
extends SpartanInputReader {
    private boolean iHaveModelStatement;
    private boolean isCompoundDocument;
    private boolean inputOnly;
    private boolean espCharges;
    private boolean natCharges;
    private boolean isInputFirst;
    private boolean iHaveNewDir;
    private static final String endCheck = "END Directory Entry ";
    private String title;
    SpartanArchive spartanArchive;
    Map<String, String> titles;
    private boolean haveCharges;

    @Override
    protected void initializeReader() throws Exception {
        this.isCompoundDocument = this.rd().indexOf("Compound Document File Directory") >= 0;
        this.inputOnly = this.checkFilterKey("INPUT");
        this.natCharges = this.checkFilterKey("NATCHAR");
        this.espCharges = !this.natCharges && !this.checkFilterKey("MULLIKEN");
    }

    @Override
    protected boolean checkLine() throws Exception {
        boolean bl;
        boolean bl2;
        int n = 3;
        boolean bl3 = bl2 = this.isCompoundDocument && this.line.startsWith("NEW Directory M") && !this.line.startsWith("NEW Directory Molecules");
        if (bl2) {
            this.iHaveNewDir = true;
        }
        boolean bl4 = !this.iHaveNewDir && !bl2 && this.isCompoundDocument && this.line.equals("BEGIN Directory Entry Molecule");
        boolean bl5 = bl = !this.isCompoundDocument && (n = this.line.indexOf("#JMOL_MODEL")) >= 0;
        if (bl2 || bl4 || bl) {
            if (this.modelNumber > 0 && !this.isInputFirst) {
                this.applySymmetryAndSetTrajectory();
            }
            this.iHaveModelStatement = true;
            int n2 = bl4 ? 0 : this.parseIntAt(this.line, n + 12);
            this.modelNumber = this.bsModels == null && n2 != Integer.MIN_VALUE && n2 != 0 ? n2 : this.modelNumber + 1;
            this.bondData = "";
            if (!this.doGetModel(this.modelNumber, null)) {
                if (this.isInputFirst) {
                    this.asc.removeCurrentAtomSet();
                    this.discardLinesUntilContains("BEGIN Directory Entry Input");
                } else if (bl2) {
                    this.discardLinesUntilContains("NEW Directory M");
                } else if (bl4) {
                    this.discardLinesUntilContains("BEGIN Directory Entry M");
                } else {
                    this.discardLinesUntilContains("#JMOL_MODEL");
                }
                this.checkLastModel();
                return false;
            }
            if (!this.isInputFirst) {
                this.makeNewAtomSet();
            }
            this.moData = new Hashtable();
            this.moData.put("isNormalized", Boolean.TRUE);
            boolean bl6 = false;
            if (n2 == Integer.MIN_VALUE || this.titles == null) {
                n2 = this.modelNumber;
                this.title = "Model " + n2;
            } else {
                bl6 = true;
                this.title = this.titles.get("Title" + n2);
                this.title = "Profile " + n2 + (this.title == null ? "" : ": " + this.title);
            }
            if (this.constraints == null && (bl6 || !this.isInputFirst)) {
                this.asc.setAtomSetName(this.title);
            }
            this.setModelPDB(false);
            this.asc.setCurrentAtomSetNumber(n2);
            if (bl4) {
                this.readMyTransform();
            }
            return true;
        }
        if (this.iHaveModelStatement && !this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("BEGIN") == 0) {
            String string = this.line.toLowerCase();
            if (string.endsWith("input")) {
                if (!this.iHaveModelStatement) {
                    this.isInputFirst = true;
                }
                if (this.isInputFirst) {
                    this.makeNewAtomSet();
                }
                this.bondData = "";
                this.title = this.readInputRecords();
                if (this.asc.errorMessage != null) {
                    this.continuing = false;
                    return false;
                }
                if (this.title != null && this.constraints == null) {
                    this.asc.setAtomSetName(this.title);
                }
                this.setCharges();
                if (this.inputOnly) {
                    this.continuing = false;
                    return false;
                }
            } else {
                if (string.endsWith("_output")) {
                    return true;
                }
                if (string.endsWith("output")) {
                    this.readOutput();
                    return false;
                }
                if (string.endsWith("molecule") || string.endsWith("molecule:asbinarystring")) {
                    this.readMyTransform();
                    return false;
                }
                if (string.endsWith("proparc") || string.endsWith("propertyarchive")) {
                    this.readProperties();
                    return false;
                }
                if (string.endsWith("archive")) {
                    this.asc.setAtomSetName(this.readArchive());
                    return false;
                }
            }
            return true;
        }
        if (this.line.indexOf("5D shell") >= 0) {
            this.calculationType = this.line;
            this.moData.put("calculationType", this.calculationType);
        }
        return true;
    }

    private void makeNewAtomSet() {
        if (this.asc.ac == 0) {
            this.asc.removeCurrentAtomSet();
        }
        this.asc.newAtomSet();
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        Float f;
        this.finalizeReaderASCR();
        if (this.asc.ac > 0 && this.spartanArchive != null && this.asc.bondCount == 0 && this.bondData != null) {
            this.spartanArchive.addBonds(this.bondData, 0);
        }
        if (this.moData != null && (f = (Float)this.asc.atomSetInfo.get("HOMO_N")) != null) {
            int n = f.intValue();
            this.moData.put("HOMO", n);
        }
    }

    private void readMyTransform() throws Exception {
        String string = this.rd();
        String[] stringArray = PT.getTokens(string.trim());
        if (stringArray.length < 16) {
            return;
        }
        byte[] byArray = new byte[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            byArray[n] = (byte)PT.parseIntRadix(stringArray[n], 16);
            ++n;
        }
        float[] fArray = new float[16];
        n = 16;
        int n2 = byArray.length - 8;
        while (--n >= 0) {
            fArray[n] = BC.bytesToDoubleToFloat(byArray, n2, false);
            n2 -= 8;
        }
        this.setTransform(fArray[0], fArray[1], fArray[2], fArray[4], fArray[5], fArray[6], fArray[8], fArray[9], fArray[10]);
    }

    private void readOutput() throws Exception {
        this.titles = new Hashtable<String, String>();
        SB sB = new SB();
        while (this.rd() != null && !this.line.startsWith("END ")) {
            sB.append(this.line).append("\n");
            int n = this.line.indexOf(")");
            if (n <= 0) continue;
            this.titles.put("Title" + this.parseIntRange(this.line, 0, n), this.line.substring(n + 1).trim());
        }
        this.asc.setInfo("fileHeader", sB.toString());
    }

    private String readArchive() throws Exception {
        this.spartanArchive = new SpartanArchive(this, this.bondData, endCheck, 0);
        String string = this.readArchiveHeader();
        if (string != null) {
            this.modelAtomCount = this.spartanArchive.readArchive(this.line, false, this.asc.ac, false);
        }
        return this.constraints == null ? string : null;
    }

    private void setCharges() {
        if (this.haveCharges || this.asc.ac == 0) {
            return;
        }
        this.haveCharges = this.espCharges && this.asc.setAtomSetCollectionPartialCharges("ESPCHARGES") || this.natCharges && this.asc.setAtomSetCollectionPartialCharges("NATCHARGES") || this.asc.setAtomSetCollectionPartialCharges("MULCHARGES") || this.asc.setAtomSetCollectionPartialCharges("Q1_CHARGES") || this.asc.setAtomSetCollectionPartialCharges("ESPCHARGES");
    }

    private void readProperties() throws Exception {
        if (this.modelAtomCount == 0) {
            this.rd();
            return;
        }
        if (this.spartanArchive == null) {
            this.spartanArchive = new SpartanArchive(this, this.bondData, endCheck, this.modelAtomCount);
        }
        this.spartanArchive.readProperties();
        this.rd();
        this.setCharges();
    }

    private String readArchiveHeader() throws Exception {
        String string = this.rd();
        if (this.debugging) {
            Logger.debug(string);
        }
        if (string.indexOf("Error:") == 0) {
            return null;
        }
        this.asc.setCollectionName(string);
        this.asc.setAtomSetName(string);
        String string2 = this.rd();
        if (this.debugging) {
            Logger.debug(string2);
        }
        this.rd();
        return string2;
    }

    public void setEnergy(float f) {
        this.asc.setAtomSetName(String.valueOf(this.constraints) + (this.constraints.length() == 0 ? "" : " ") + "Energy=" + f + " KJ");
    }
}

